/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.cslacct.IRequisition;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionCheck;
import com.kingdee.eas.fi.gl.cslacct.ReqCheckCondition;
import com.kingdee.eas.fi.gl.cslacct.ReqStatusEnum;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.RequisitionEntryInfo;
import com.kingdee.eas.fi.gl.cslacct.RequisitionFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionInfo;
import com.kingdee.eas.fi.gl.cslacct.VoucherCheckInfo;
import com.kingdee.eas.fi.gl.cslacct.app.RequisitionControllerBean;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class AcNoticeUtil {
    private static final Logger logger = Logger.getLogger(AcNoticeUtil.class);
    public static final String VOUCHERID = "VOUCHERID";
    public static final String COMPANYID = "COMPANYID";
    private static final String VOUCHER_EXCEPTION_RESOURCE = "com.kingdee.eas.fi.gl.VoucherExceptionResource";

    public static Collection dealAcNotice(Context ctx, Collection srcVCH) throws EASBizException, BOSException {
        String voucherId = ctx.get((Object)VOUCHERID).toString();
        String companyId = ctx.get((Object)COMPANYID).toString();
        return AcNoticeUtil.dealAcNotice(ctx, srcVCH, voucherId, companyId);
    }

    public static Collection dealAcNotice(Context ctx, Collection srcVCH, String voucherId, String companyId) throws BOSException, EASBizException {
        ArrayList params = new ArrayList();
        IRequisitionCheck reqCtrl = RequisitionCheckFactory.getLocalInstance(ctx);
        reqCtrl.clearReqRelation("'" + voucherId + "'", false);
        AcNoticeUtil.checkAndRepairReqCheckStatus(ctx, voucherId);
        IRowSet rs = AcNoticeUtil.getAcNoticeData(ctx, companyId, voucherId);
        return AcNoticeUtil.sendACNotice(ctx, rs, companyId, srcVCH, false);
    }

    public static Collection dealAcNotice(Context ctx, Collection srcVCH, VoucherInfo voucher, String companyId) throws BOSException, EASBizException {
        String voucherId = voucher.getId().toString();
        ArrayList params = new ArrayList();
        IRequisitionCheck reqCtrl = RequisitionCheckFactory.getLocalInstance(ctx);
        reqCtrl.clearReqRelation("'" + voucherId + "'", false);
        AcNoticeUtil.checkAndRepairReqCheckStatus(ctx, voucherId);
        if (!voucher.isIsACNotice()) {
            return null;
        }
        IRowSet rs = AcNoticeUtil.getAcNoticeData(ctx, companyId, voucherId);
        return AcNoticeUtil.sendACNotice(ctx, rs, companyId, srcVCH, false);
    }

    public static void clearAcNotice(Context ctx, String voucherId) throws EASBizException, BOSException {
        StringBuffer sqlDel = new StringBuffer();
        sqlDel.append("delete from t_csl_requisitionentry cre where cre.fid in ( \r\n");
        sqlDel.append("select reqe.fid from t_csl_requisition re \r\n");
        sqlDel.append("inner join t_csl_requisitionentry reqe on re.fid=reqe.frequisitionid \r\n");
        sqlDel.append("left join t_gl_voucherassistrecord asst on asst.fid=reqe.fassistrecordid \r\n");
        sqlDel.append("left join t_gl_voucherentry ve on ve.fid=asst.fentryid \r\n");
        sqlDel.append("left join T_BD_AssistantHG assGrp on asst.FAssGrpID = assGrp.FID \r\n");
        sqlDel.append("left join T_BD_Customer customer on assGrp.FCustomerID = customer.FID \r\n");
        sqlDel.append("left join T_BD_Supplier supplier on assGrp.FProviderID = supplier.FID \r\n");
        sqlDel.append("where re.fvoucherid=? and (asst.fid is null \r\n");
        sqlDel.append("      or reqe.faccountid <> ve.faccountid \r\n");
        sqlDel.append("      or reqe.fcurrencyid <> ve.fcurrencyid or reqe.fdc <> ve.fentrydc \r\n");
        sqlDel.append("      or reqe.foriginalamount <> asst.foriginalamount \r\n");
        sqlDel.append("      or reqe.fsummary <> asst.fdescription \r\n");
        sqlDel.append("      or re.ftargcompanyid <> isnull(isnull(assGrp.FCompanyOrgID, isnull(customer.FInternalCompanyID, supplier.FInternalCompanyID)),' ') \r\n");
        sqlDel.append("     ) and reqe.fstatus <> 2 \r\n");
        sqlDel.append(")");
        DbUtil.execute((Context)ctx, (String)sqlDel.toString(), (Object[])new Object[]{voucherId});
        sqlDel.setLength(0);
        sqlDel.append("delete from t_csl_requisition where fvoucherid=? and not exists( \r\n");
        sqlDel.append("select 1 from t_csl_requisitionentry reqe where reqe.frequisitionid=t_csl_requisition.fid) \r\n");
        DbUtil.execute((Context)ctx, (String)sqlDel.toString(), (Object[])new Object[]{voucherId});
    }

    public static Collection sendACNotice(Context ctx, IRowSet rs, String companyId, Collection srcVCH, boolean isAuto) throws EASBizException, BOSException {
        if (rs == null) {
            return null;
        }
        ArrayList<RequisitionCheckInfo> srcACNotice = new ArrayList<RequisitionCheckInfo>();
        int size = 0;
        HashSet<String> vchIds = new HashSet<String>();
        StringBuffer vchidsStr = new StringBuffer();
        String numberSql = " Select Fnumber from t_csl_Requisition where fnumber=?";
        IRequisition reqCtrl = RequisitionFactory.getLocalInstance(ctx);
        RequisitionInfo req = null;
        int line = 1;
        CompanyOrgUnitInfo srcCom = new CompanyOrgUnitInfo();
        srcCom.setId(BOSUuid.read((String)companyId));
        try {
            while (rs.next()) {
                String comId = rs.getString("companyID");
                String vchId = rs.getString("vchID");
                vchIds.add(vchId);
                vchidsStr.append(vchId).append(",");
                String comNumber = rs.getString("comNumber");
                String vchNumber = rs.getString("vchType") + rs.getString("vchNumber");
                int periodYear = rs.getInt("periodYear");
                int periodNumber = rs.getInt("periodNumber");
                int period = rs.getInt("period");
                int entrySeq = rs.getInt("entrySeq");
                int recordSeq = rs.getInt("recordSeq");
                String reqNumber = null;
                do {
                    reqNumber = comNumber + "-" + periodYear + GlUtils.formatNumber(periodNumber, 2) + "-" + vchNumber + "-" + GlUtils.formatNumber(entrySeq, 2) + GlUtils.formatNumber(recordSeq++, 2);
                    if (recordSeq <= 99) continue;
                    ++entrySeq;
                    recordSeq = 1;
                } while (AcNoticeUtil.isExistReqNumber(ctx, reqNumber, numberSql));
                req = new RequisitionInfo();
                req.setNumber(Uuid.create().toString());
                req.setSrcCompany(srcCom);
                CompanyOrgUnitInfo com = new CompanyOrgUnitInfo();
                req.setCompany(com);
                com.setId(BOSUuid.read((String)comId));
                VoucherInfo vch = new VoucherInfo();
                req.setVoucher(vch);
                req.setPeriod(period);
                vch.setId(BOSUuid.read((String)vchId));
                vch.setNumber(rs.getString("vchType") + rs.getString("vchNumber"));
                vch.setLastUpdateTime(rs.getTimestamp("lastUpdateTime"));
                req.setVchNumber(vch.getNumber());
                req.setNumber(reqNumber);
                req.setFiVouchered(false);
                line = 1;
                String acctId = rs.getString("accountID");
                String curId = rs.getString("currencyID");
                EntryDC dc = EntryDC.getEnum((int)rs.getInt("dc"));
                BigDecimal amount = rs.getBigDecimal("amount");
                RequisitionEntryInfo e = new RequisitionEntryInfo();
                req.getRequisitionEntry().add(e);
                e.setRequisition(req);
                e.setLineNo(line++);
                AccountViewInfo acct = new AccountViewInfo();
                e.setAccount(acct);
                acct.setId(BOSUuid.read((String)acctId));
                CurrencyInfo cur = new CurrencyInfo();
                e.setCurrency(cur);
                cur.setId(BOSUuid.read((String)curId));
                e.setDc(dc);
                e.setOriginalAmount(amount);
                e.setStatus(ReqStatusEnum.UNCHECKED);
                VoucherAssistRecordInfo as = new VoucherAssistRecordInfo();
                as.setId(BOSUuid.read((String)rs.getString("recID")));
                e.setAssistRecord(as);
                String recDesc = rs.getString("recDesc");
                if (recDesc != null && recDesc.length() > 255) {
                    recDesc = recDesc.substring(0, 255) + "...";
                }
                e.setSummary(recDesc);
                reqCtrl.submit((CoreBaseInfo)req);
                if (srcVCH == null) continue;
                for (Object obj : srcVCH) {
                    if (!(obj instanceof VoucherCheckInfo) || !((VoucherCheckInfo)obj).getAssistRecord().getId().toString().equals(rs.getString("recID"))) continue;
                    RequisitionCheckInfo reqCheckInfo = new RequisitionCheckInfo();
                    reqCheckInfo.setPropertyValueBykey("requisition.id", req.getId().toString());
                    reqCheckInfo.setPropertyValueBykey("voucher.number", rs.getString("vchType") + rs.getString("vchNumber"));
                    reqCheckInfo.setPropertyValueBykey("srccompany.id", srcCom.getId().toString());
                    reqCheckInfo.setPropertyValueBykey("targcompany.id", com.getId().toString());
                    reqCheckInfo.setPropertyValueBykey("requisitionEntry.id", req.getRequisitionEntry().get(0).getId().toString());
                    reqCheckInfo.setPropertyValueBykey("currency.id", curId);
                    reqCheckInfo.setPropertyValueBykey("dc", dc);
                    reqCheckInfo.setPropertyValueBykey("origAmount", amount);
                    reqCheckInfo.setPropertyValueBykey("assistrecord.id", rs.getString("recID"));
                    reqCheckInfo.setPropertyValueBykey("checkNumber", req.getNumber());
                    reqCheckInfo.setPropertyValueBykey("voucher.id", req.getVoucher());
                    srcACNotice.add(reqCheckInfo);
                    ++size;
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        HashSet<String> ids = new HashSet<String>();
        ids.addAll(vchIds);
        AcNoticeUtil.autoGenerateVoucher(ctx, ids);
        if (isAuto) {
            IRequisitionCheck iRequisitionCheck = RequisitionCheckFactory.getLocalInstance(ctx);
            ReqCheckCondition condition = new ReqCheckCondition();
            if (ctx.get((Object)"requisition.id") != null) {
                condition.setRequisitionId(ctx.get((Object)"requisition.id").toString());
            }
            condition.setCompany(srcCom);
            condition.setVoucherId(vchidsStr.toString());
            iRequisitionCheck.autoCheckByReq(condition);
        }
        if (size > 0) {
            return srcACNotice;
        }
        return null;
    }

    public static void autoGenerateVoucher(Context ctx, Set vchIds) throws BOSException, EASBizException {
        if (vchIds.size() <= 0) {
            return;
        }
        EntityViewInfo env = new EntityViewInfo();
        SelectorItemCollection selectors = AcNoticeUtil.getBotpSelector();
        env.setSelector(selectors);
        FilterInfo filterReq = new FilterInfo();
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sqlId = new StringBuffer();
        sqlId.append("select re.fid from t_csl_requisition re \r\n");
        sqlId.append("inner join t_org_company c on c.fid=re.FTargCompanyID \r\n");
        sqlId.append("inner join t_bas_paramitem pi on pi.forgunitid=c.fid \r\n");
        sqlId.append("inner join t_bas_param p on p.fid=pi.fkeyid \r\n");
        sqlId.append("inner join t_bas_paramitem pi1 on pi1.forgunitid=c.fid \r\n");
        sqlId.append("inner join t_bas_param p1 on p1.fid=pi1.fkeyid \r\n");
        sqlId.append("where re.ffivouchered=0 and p.fnumber='GL_079' and pi.fvalue_").append(lang).append("='true' \r\n");
        sqlId.append("and p1.fnumber='GLG01_3' and pi1.fvalue_").append(lang).append("='false' \r\n");
        sqlId.append("and re.fvoucherid in (");
        Iterator it = vchIds.iterator();
        while (it.hasNext()) {
            sqlId.append("'").append(it.next()).append("',");
        }
        sqlId.setLength(sqlId.length() - 1);
        sqlId.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlId.toString(), (Object[])new Object[0]);
        StringBuffer reqIDs = new StringBuffer();
        try {
            while (rs.next()) {
                reqIDs.append('\'').append(rs.getString("fid")).append('\'').append(',');
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (reqIDs.length() <= 0) {
            return;
        }
        reqIDs.deleteCharAt(reqIDs.length() - 1);
        filterReq.getFilterItems().add(new FilterItemInfo("id", (Object)reqIDs.toString(), CompareType.INNER));
        env.setFilter(filterReq);
        IRequisition reqCtrl = RequisitionFactory.getLocalInstance(ctx);
        CoreBillBaseCollection reqCol = reqCtrl.getCoreBillBaseCollection(env);
        if (reqCol != null && reqCol.size() > 0) {
            int size = reqCol.size();
            for (int i = 0; i < size; ++i) {
                CoreBillBaseCollection tmpCol = new CoreBillBaseCollection();
                RequisitionInfo req = (RequisitionInfo)reqCol.get(i);
                tmpCol.add((CoreBillBaseInfo)req);
                try {
                    BOTMappingInfo botMappingInfo = AcNoticeUtil.getMapping(ctx, tmpCol, DAPVoucherTypeEnum.FIVoucher);
                    reqCtrl.generateVoucher(tmpCol, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException(MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"AUTO_VCH_ERROR", (Locale)ctx.getLocale()), req.getCompany().getName(), req.getCompany().getNumber()) + "\r\n" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static SelectorItemCollection getBotpSelector() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("company.id");
        selectors.add("company.number");
        selectors.add("company.name");
        selectors.add("company.CU.id");
        selectors.add("company.CU.number");
        selectors.add("company.CU.name");
        selectors.add("requisitionEntry.assistRecord.entry.localExchangeRate");
        selectors.add("requisitionEntry.assistRecord.localAmount");
        selectors.add("requisitionEntry.currency.id");
        selectors.add("requisitionEntry.assistRecord.assGrp.provider");
        selectors.add("requisitionEntry.currency");
        selectors.add("requisitionEntry.assistRecord.assGrp.customer");
        selectors.add("requisitionEntry.assistRecord.assGrp.companyOrg");
        selectors.add(new SelectorItemInfo("number"));
        selectors.add(new SelectorItemInfo("requisitionEntry.summary"));
        selectors.add(new SelectorItemInfo("createTime"));
        selectors.add(new SelectorItemInfo("srcCompany.name"));
        selectors.add(new SelectorItemInfo("company.name"));
        selectors.add(new SelectorItemInfo("voucher.srcNumber"));
        selectors.add(new SelectorItemInfo("requisitionEntry.targVchNumber"));
        selectors.add(new SelectorItemInfo("currency.name"));
        selectors.add(new SelectorItemInfo("requisitionEntry.dc"));
        selectors.add(new SelectorItemInfo("requisitionEntry.origAmount"));
        selectors.add(new SelectorItemInfo("reqstatus"));
        selectors.add(new SelectorItemInfo("requisitionEntry.id"));
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("voucher.id"));
        selectors.add(new SelectorItemInfo("srcCompany.id"));
        selectors.add(new SelectorItemInfo("checkNumber"));
        return selectors;
    }

    private static BOTMappingInfo getMapping(Context ctx, CoreBillBaseCollection sourceBillBaseCollection, DAPVoucherTypeEnum dapVoucherTypeEnum) throws BOSException, EASBizException {
        IBOTMapping botMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingCollection botMappingCollection = null;
        VoucherInfo voucherInfo = new VoucherInfo();
        String voucherType = voucherInfo.getBOSType().toString();
        String sourceBillType = sourceBillBaseCollection.getObject(0).getBOSType().toString();
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(sourceBillBaseCollection.getObject(0).getBOSType());
        int count = sourceBillBaseCollection.size();
        String[] idList = new String[count];
        for (int i = 0; i < count; ++i) {
            idList[i] = sourceBillBaseCollection.get(i).getId().toString();
        }
        String[] entrysName = new String[]{AcNoticeUtil.getBillMainEntryName(entity)};
        List entriesKey = AcNoticeUtil.getSelectEntryIDs(sourceBillBaseCollection, entrysName[0]);
        HashMap<String, CtrlUnitInfo> params = new HashMap<String, CtrlUnitInfo>();
        RequisitionInfo req = (RequisitionInfo)sourceBillBaseCollection.get(0);
        params.put("TRANSMITCU", req.getCompany().getCU());
        botMappingCollection = botMapping.getMappingCollectionForSelectUseRuleFilter(sourceBillType, voucherType, DefineSysEnum.DAP, params, idList, entrysName, entriesKey, AcNoticeUtil.getBotpSelector());
        if (botMappingCollection == null || botMappingCollection.size() == 0) {
            throw new BOTPException(BOTPException.MAPPINGNUMZERO);
        }
        return botMappingCollection.get(0);
    }

    private static String getBillMainEntryName(EntityObjectInfo entity) {
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            RelationshipInfo relation;
            if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
            EntityObjectInfo relateEntity = null;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(entity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            return propInfo.getName();
        }
        return "entries";
    }

    private static List getSelectEntryIDs(CoreBillBaseCollection srcBills, String entryName) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entryName)) {
            return entryids;
        }
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }

    public static boolean isExistReqNumber(Context ctx, String reqNumber, String sql) throws BOSException {
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{reqNumber});
        try {
            if (set != null && set.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static String getAcNoticeSql(Context ctx, List list) throws EASBizException, BOSException {
        throw new BOSException("not support");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRowSet getAcNoticeData(Context ctx, String companyId, String voucherId) throws EASBizException, BOSException {
        IRowSet iRowSet;
        String lang = ctx.getLocale().getLanguage();
        GlParam paramMap = GlParam.getGlParams((Context)ctx, (String[])new String[]{"GL_074", "NotSendAcNoticeAbountDapVch"}, (String)companyId);
        boolean notSendAcNoticDapVch = paramMap.getBoolean("NotSendAcNoticeAbountDapVch");
        StringBuffer sql = new StringBuffer();
        String T_TMP_AcNotice = null;
        try {
            String threadSql = "";
            VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
            if (cache != null && cache.isMultiThread()) {
                threadSql = ",F" + Thread.currentThread().getId() + " int DEFAULT 0 \n";
            }
            sql.append("create table T_TMP_AcNotice ( \n");
            sql.append("    vchID VARCHAR(44), \n");
            sql.append("    comNumber NVARCHAR(255), \n");
            sql.append("    comName NVARCHAR(255), \n");
            sql.append("    vchType NVARCHAR(255), \n");
            sql.append("    vchNumber NVARCHAR(255), \n");
            sql.append("    periodYear int, \n");
            sql.append("    periodNumber int, \n");
            sql.append("    period int, \n");
            sql.append("    accountID VARCHAR(44), \n");
            sql.append("    currencyID VARCHAR(44), \n");
            sql.append("    dc int, \n");
            sql.append("    entrySeq int, \n");
            sql.append("    amount NUMERIC(19,4) DEFAULT 0, ");
            sql.append("    recID VARCHAR(44), \n");
            sql.append("    recDesc NVARCHAR(512), \n");
            sql.append("    recordSeq int, \n");
            sql.append("    companyID VARCHAR(44), \n");
            sql.append("    lastUpdateTime DateTime \n");
            sql.append(threadSql);
            sql.append(") \n");
            T_TMP_AcNotice = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
            sql.setLength(0);
            sql.append("insert into " + T_TMP_AcNotice + " ( \n");
            sql.append("    vchID, \n");
            sql.append("    comNumber, comName, vchType, vchNumber, periodYear, periodNumber, period, \n");
            sql.append("    accountID, currencyID, dc, entrySeq, amount, recID, recDesc, recordSeq, companyID,lastUpdateTime \n");
            sql.append(") \n");
            sql.append("select \n");
            sql.append("    vch.FID vchID, \n");
            sql.append("    com.fnumber comNumber, com.FName_" + lang + " comName, vchType.FName_" + lang + " vchType, \n");
            sql.append("    vch.FNumber vchNumber, pd.fperiodYear periodYear,pd.fperiodNumber periodNumber,pd.fnumber period, \n");
            sql.append("    acct.FID accountID, entry.FCurrencyID currencyID, \n");
            sql.append("    entry.FEntryDC dc, entry.fSeq entrySeq, \n");
            sql.append("    record.FOriginalAmount amount, record.FID recID, record.FDescription recDesc,record.fSeq recordSeq, \n");
            sql.append("    isnull(assGrp.FCompanyOrgID, isnull(customer.FInternalCompanyID, supplier.FInternalCompanyID)) companyID,vch.FlastUpdateTime \r\n");
            sql.append("from T_GL_Voucher vch \n");
            sql.append("join T_BD_VoucherTypes vchType on vch.FVoucherTypeID = vchType.FID \n");
            sql.append("join T_Org_Company com on vch.FCompanyId = com.FID \n");
            sql.append("join T_BD_Period pd on vch.FPeriodID = pd.FID \n");
            sql.append("left join T_BKS_AcountScheme acs on acs.fid = com.FAccountSchemeID \n");
            sql.append("join T_GL_VoucherEntry entry on vch.FID = entry.FBillID \n");
            sql.append("join T_GL_VoucherAssistRecord record\ton entry.FID = record.FEntryID \n");
            sql.append("join T_BD_AccountView acct on entry.FAccountID = acct.FID and acct.FACNotice = 1 \n");
            sql.append("join T_BD_AssistantHG assGrp  on record.FAssGrpID = assGrp.FID \n");
            sql.append("left join T_BD_Customer customer on assGrp.FCustomerID = customer.FID \n");
            sql.append("left join T_BD_Supplier supplier on assGrp.FProviderID = supplier.FID \n");
            sql.append("where vch.FID = ? \n");
            sql.append("    and vch.fsourcetype <> 7 \n");
            sql.append("    and vch.FSourceType<>").append(2).append(" \n");
            sql.append("    and vch.FSourceType<>").append(1).append(" \n");
            sql.append("    and record.Fbillid = vch.FID \n");
            sql.append("    and record.FOriginalAmount <> 0 \n");
            sql.append("    and record.freqCheckStatus <> 2 \n");
            if (!notSendAcNoticDapVch) {
                sql.append("    and (record.FSOURCEFUNCTION is null OR record.FSOURCEFUNCTION <> '").append(RequisitionControllerBean.functionName).append("') \n");
            }
            sql.append("    and ( \n");
            sql.append("        assGrp.FCompanyOrgID is not null \n");
            sql.append("        or customer.FInternalCompanyID is not null \n");
            sql.append("        or supplier.FInternalCompanyID is not null \n");
            sql.append("    )\n");
            sql.append("    and (acs.fid is null or acs.FIsMaster = 1) \n");
            sql.append("    and not exists ( \n");
            sql.append("        select 1 from t_csl_RequisitionEntry reqe where reqe.FAssistRecordID=record.fid \n");
            sql.append("    ) \n");
            sql.append(" \n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{voucherId});
            boolean isGroup = GlUtils.isGroupControl(ctx, "GLG01");
            boolean GL_074IsTrue = paramMap.getBoolean("GL_074");
            sql.setLength(0);
            sql.append("select \n");
            sql.append("    /*+ LEADING(t) */ \n");
            sql.append("    distinct \n");
            sql.append("    t.vchID, \n");
            sql.append("    t.comNumber, t.comName, t.vchType, t.vchNumber, t.periodYear, t.periodNumber, t.period, sscpe.fnumber targPeriod, \n");
            sql.append("    t.accountID, t.currencyID, t.dc, t.entrySeq, t.amount, t.recID, t.recDesc, t.recordSeq, t.companyID,t.lastUpdateTime \n");
            sql.append("from " + T_TMP_AcNotice + " t \n");
            if (!isGroup) {
                sql.append("inner join T_BAS_ParamItem tbpi on tbpi.FOrgUnitID = t.companyID \n");
                sql.append("inner join T_BAS_Param tbp  on tbp.fid = tbpi.fkeyid \n");
                sql.append("    and tbp.fnumber ='GLG01' and tbpi.fvalue_" + lang + "='true' \n");
            }
            sql.append(" inner join T_BD_SystemStatusCtrol ssc on ssc.fcompanyid = t.companyID \r\n");
            sql.append(" inner join T_BD_SystemStatus ss on ss.fid = ssc.fsystemstatusid \n");
            if (GL_074IsTrue) {
                sql.append(" inner join t_bd_period sscpe on sscpe.fid = ssc.fcurrentperiodid \n");
            } else {
                sql.append(" inner join t_bd_period sscpe on sscpe.fid = ssc.fstartperiodid \n");
            }
            sql.append("where t.companyID <> '").append(companyId).append("' \n");
            sql.append("    and ssc.fisstart = 1 and ss.fname = 6 \n");
            if (!GL_074IsTrue) {
                sql.append("    and t.period >= sscpe.fnumber \n");
            }
            ArrayList<String> srcIdList = new ArrayList<String>();
            Object relO = ctx.get((Object)"botrelation");
            if (relO != null) {
                ctx.remove((Object)"botrelation");
                BOTRelationCollection relColl = (BOTRelationCollection)relO;
                if (relColl != null && relColl.size() > 0) {
                    int j = relColl.size();
                    for (int i = 0; i < j; ++i) {
                        BOTRelationInfo relInfo = relColl.get(i);
                        if (!"7EB1A733".equals(relInfo.getSrcEntityID())) continue;
                        srcIdList.add(relInfo.getSrcObjectID());
                    }
                }
            }
            if (srcIdList.size() > 0) {
                sql.append("  and not exists ( \r\n");
                sql.append("select 1 from t_csl_requisition req \r\n");
                sql.append("where req.fid in" + SQLUtil.arrayToInList(srcIdList.toArray(new String[srcIdList.size()])) + " \r\n");
                sql.append("and req.FSrcCompanyID=t.companyID) \r\n");
            } else if (notSendAcNoticDapVch) {
                sql.append("  and not exists ( \r\n");
                sql.append("select 1 from t_bot_relation relation \r\n");
                sql.append("inner join t_csl_requisition req on req.fid=relation.fsrcobjectid \r\n");
                sql.append("where relation.fdestobjectid=t.vchID and req.FSrcCompanyID=t.companyID) \r\n");
            }
            StringBuffer sqlCloseInit = new StringBuffer();
            sqlCloseInit.append("SELECT sscl.FCOMPANYID FCOMPANYID FROM  T_BD_SystemStatusCtrol sscl inner join T_BD_SystemStatus sss on sss.fid = sscl.fsystemstatusid ");
            sqlCloseInit.append("inner join t_bd_period sscped on sscped.fid = sscl.fcurrentperiodid ");
            sqlCloseInit.append("where sscl.fisstart = 1 and sss.fname = 6 and sscl.FCOMPANYID ='" + companyId + "'");
            IRowSet rsCloseInit = DbUtil.executeQuery((Context)ctx, (String)sqlCloseInit.toString());
            if (rsCloseInit.next()) {
                sql.append(" and 1 = 1 ");
            } else {
                sql.append(" and 1 = 0 ");
            }
            sql.append("order by companyID, vchID");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (GL_074IsTrue) {
                AcNoticeUtil.checkTargCompanyPeriod(rs);
            }
            iRowSet = rs;
        }
        catch (BOSException e) {
            try {
                throw e;
                catch (EASBizException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new BOSException("sendACNotice error", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (T_TMP_AcNotice == null) throw throwable;
                    TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_AcNotice);
                    throw throwable;
                }
                catch (Exception e4) {
                    logger.warn((Object)"", (Throwable)e4);
                }
                throw throwable;
            }
        }
        try {
            if (T_TMP_AcNotice == null) return iRowSet;
            TempTablePool.getInstance((Context)ctx).releaseTable(T_TMP_AcNotice);
            return iRowSet;
        }
        catch (Exception e) {
            logger.warn((Object)"", (Throwable)e);
        }
        return iRowSet;
    }

    public static void checkACNoticeCorrelation(Context ctx, String vchId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select v.fsourcetype sourceType,var.fid vchAsstId,reqe.FASSISTRECORDID asstId,reqe.FSTATUS status");
        sql.append(",org.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" companyName");
        sql.append(" from t_gl_voucher v \r\n");
        sql.append(" inner join t_gl_voucherassistrecord var on var.fbillid = v.fid \r\n");
        sql.append(" left join T_CSL_REQUISITIONENTRY reqe on reqe.FASSISTRECORDID = var.fid \r\n");
        sql.append(" left join t_csl_requisition req on req.FID = reqe.FREQUISITIONID \r\n");
        sql.append(" left join t_org_baseUnit org on org.fid = req.FTARGCOMPANYID \r\n");
        sql.append(" where v.fid = ? and var.freqcheckstatus = 2");
        IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchId});
        StringBuffer message = new StringBuffer();
        boolean existChecked = false;
        try {
            HashSet<String> asstIds = new HashSet<String>();
            ArrayList<String> companyNames = new ArrayList<String>();
            while (rst.next()) {
                int sourceType = rst.getInt("sourceType");
                String asstId = rst.getString("asstId");
                if (asstId != null && rst.getInt("status") == 1) {
                    asstIds.add(asstId);
                    continue;
                }
                if (asstId == null && sourceType != 3) {
                    String vchAsstId = rst.getString("vchAsstId");
                    asstIds.add(vchAsstId);
                    continue;
                }
                existChecked = true;
                String companyName = rst.getString("companyName");
                if (companyName == null || companyNames.contains(companyName)) continue;
                message.append(companyName).append(";");
                companyNames.add(companyName);
            }
            if (asstIds.size() > 0) {
                String sqlInStr = AcNoticeUtil.getSqlInStr(asstIds.size());
                String repairSql = "update t_gl_voucherassistrecord set freqcheckstatus = 1 where fid in(" + sqlInStr + ")";
                DbUtil.execute((Context)ctx, (String)repairSql, (Object[])asstIds.toArray());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (existChecked) {
            throw new VoucherException(VoucherException.NOTICEISCHECKED, new Object[]{message.toString()});
        }
    }

    private static void checkTargCompanyPeriod(IRowSet rs) throws BOSException, EASBizException, SQLException {
        StringBuilder errorMsg = new StringBuilder();
        MessageFormat messageFormat = null;
        TreeMap<String, String> detailMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String[] strings2;
                String[] strings1 = o1.split(",");
                if (strings1[0].equals((strings2 = o2.split(","))[0])) {
                    return Integer.valueOf(strings1[1]).compareTo(Integer.valueOf(strings2[1]));
                }
                return Integer.valueOf(strings1[0]).compareTo(Integer.valueOf(strings2[0]));
            }
        });
        String period = null;
        while (rs.next()) {
            String srcPeriodNumber;
            period = srcPeriodNumber = rs.getString("period");
            String targperiod = rs.getString("targPeriod");
            if (srcPeriodNumber.compareTo(targperiod) >= 0) continue;
            if (errorMsg.length() == 0) {
                errorMsg.append(EASResource.getString((String)VOUCHER_EXCEPTION_RESOURCE, (String)"PERIOD_ERROR_WITH_GL074")).append('\n');
            }
            detailMap.put(rs.getString("entrySeq") + "," + rs.getString("recordSeq"), targperiod);
        }
        if (errorMsg.length() > 0) {
            int count = 1;
            messageFormat = new MessageFormat(EASResource.getString((String)VOUCHER_EXCEPTION_RESOURCE, (String)"PERIOD_ERROR_WITH_GL074_DETAIL"));
            for (Map.Entry entry : detailMap.entrySet()) {
                String[] strings = ((String)entry.getKey()).split(",");
                errorMsg.append(messageFormat.format(new Object[]{count++, strings[0], strings[1], entry.getValue()})).append('\n');
            }
            messageFormat = new MessageFormat(EASResource.getString((String)VOUCHER_EXCEPTION_RESOURCE, (String)"PERIOD_ERROR_WITH_GL074_ADVISE"));
            errorMsg.append(messageFormat.format(new Object[]{period}));
            throw new VoucherException(VoucherException.PERIOD_ERROR_WITH_GL074, new Object[]{errorMsg});
        }
        rs.beforeFirst();
    }

    public static void checkAndRepairReqCheckStatus(Context ctx, String voucherId) throws BOSException, EASBizException {
        String sql = " select fid from T_gl_voucherassistrecord  assistrecord where fbillid = ? and freqCheckStatus = 2  and not exists (  select 1 from t_csl_requisition requisition   inner join T_CSL_RequisitionEntry RequisitionEntry on  requisition.fid= RequisitionEntry.frequisitionid   where RequisitionEntry.FAssistRecordID = assistrecord .fid and requisition.fvoucherid =  ? )";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherId, voucherId});
        StringBuffer recordIds = new StringBuffer();
        try {
            if (set.size() != 0) {
                while (set.next()) {
                    recordIds.append(" '").append(set.getString(1)).append("',");
                }
                sql = " update T_gl_voucherassistrecord set freqCheckStatus = 1 where fid in (" + recordIds.substring(0, recordIds.length() - 1) + ")";
                DbUtil.execute((Context)ctx, (String)sql);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getSqlInStr(int count) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                sb.append("?");
                continue;
            }
            sb.append(",?");
        }
        return sb.toString();
    }
}

