/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInvokeFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractAntiAuditBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.BookUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionCheck;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;

public class AntiAuditStandardVoucherService
extends AbstractAntiAuditBaseVoucherService {
    public AntiAuditStandardVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    @Override
    protected SelectorItemCollection getAnitAuditSelector() {
        return VoucherInfo.getAnitAuditSelector();
    }

    @Override
    protected void updateAntiAuditStatus(Context ctx, String voucherId) throws BOSException {
        VoucherOprateSharer.updateVoucherStatus(ctx, voucherId, null, VoucherStatusEnum.SUBMITTED.getValue(), "FAuditorid");
    }

    @Override
    protected void logVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo, String voucherNumber, Exception ex) throws BOSException, EASBizException {
        VoucherFacadeFactory.getLocalInstance((Context)ctx).logVoucherNumber((VoucherInfo)voucherInfo, voucherNumber, "recycleNumber", ex);
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected void processCodingRule(Context ctx, IObjectValue model, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), (VoucherInfo)voucherInfo, voucherInfo.getBizStatus())) {
            this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)((VoucherInfo)model), VoucherStatusEnum.SUBMITTED);
            String sql = "update t_gl_voucher set  fnumber=? where fid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getNumber(), voucherInfo.getId().toString()});
        }
    }

    @Override
    protected void beforeAntiAudit(Context ctx, BaseVoucherInfo voucherInfo, HashMap param) throws BOSException, EASBizException, VoucherException {
        ICFRequisition iCFReq;
        String message;
        boolean canModifyVoucherFromMain = Boolean.valueOf((String)GlUtils.getParamByKey(ctx, voucherInfo.getCompany().getId().toString(), "GL015"));
        if (!canModifyVoucherFromMain && !BooksUtil.isMasterBook((Context)ctx, (String)voucherInfo.getCompany().getId().toString()) && voucherInfo.isIsAccountCopy()) {
            throw new VoucherException(VoucherException.MASTERVOUCHERNOTAUDIT);
        }
        boolean manualAudit = Boolean.valueOf(param.get("GL_124").toString());
        if (manualAudit && (message = (iCFReq = CFRequisitionFactory.getLocalInstance(ctx)).checkReqCorrelation(voucherInfo.getId().toString())) != null) {
            throw new VoucherException(VoucherException.ANTI_AUDIT_FAILED, new Object[]{message});
        }
        boolean useWorkflow = GlUtils.isRunningWorkflow(ctx, voucherInfo.getId().toString());
        boolean antiMustAudit = Boolean.valueOf(param.get("GL_049").toString());
        if (!useWorkflow && antiMustAudit && !SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType()) && !ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString().equals(voucherInfo.getAuditor().getId().toString())) {
            throw new VoucherException(VoucherException.ANTIMUSTAUTI);
        }
        String sql = "select fischeck,fbizstatus from  t_gl_voucher where\u3000fischeck=1 and  fid=?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            if (rs.next()) {
                int isCheckAfterAudit = Integer.valueOf(param.get("GL_047").toString());
                if (!useWorkflow && isCheckAfterAudit == 2) {
                    throw new VoucherException(VoucherException.VOUCHERCHECKUNAFAUD);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL error when antiAuditVoucher!", (Throwable)e);
        }
        boolean association = VoucherUtil.isAssociationCashManagement(ctx, voucherInfo.getCompany());
        boolean hasCash = voucherInfo.existsCashOrBankAccount();
        if (hasCash && association && voucherInfo.getBizStatus().getValue() == 1) {
            throw new VoucherException(VoucherException.NOTCHECKED);
        }
    }

    @Override
    protected void afterAntiAudit(Context ctx, BaseVoucherInfo voucherInfo, HashMap param) throws BOSException, EASBizException {
        boolean isNoticeByAudit;
        boolean useAC = Boolean.valueOf(param.get("GLG01").toString());
        boolean bl = isNoticeByAudit = Integer.valueOf(param.get("GLG01_2").toString()) == 0;
        if (useAC && isNoticeByAudit) {
            IRequisitionCheck reqCtrl = RequisitionCheckFactory.getLocalInstance(ctx);
            reqCtrl.clearReqRelation("'" + voucherInfo.getId().toString() + "'", false);
        }
        if (BooksUtil.canCreateBook((Context)ctx) && BooksUtil.isMasterBook((Context)ctx, (String)voucherInfo.getCompany().getId().toString())) {
            BookUtil._deleteVoucher(ctx, 0, (VoucherInfo)voucherInfo);
        }
        this.invokeVoucherAntiAuditPostProcessor(ctx, (VoucherInfo)voucherInfo);
    }

    private void invokeVoucherAntiAuditPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherPostProcessorInvokeFactory.invokeVoucherAntiAuditPostProcessor(ctx, voucherInfo);
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_antiAudit";
    }

    @Override
    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherAntiAudit", "Before");
    }

    @Override
    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherAntiAudit", "After");
    }
}

