/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.ICFRequisition;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherNumberOperator;
import com.kingdee.eas.fi.gl.VoucherPostProcessorInvokeFactory;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherHelpFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractAntiCancelBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AcNoticeUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.SubmitVoucherServiceHelper;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.validator.VoucherBaseAntiCancelValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidatorFactory;
import com.kingdee.eas.ma.budget.BgCtrlException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.List;

public class AntiCancelStandardVoucherService
extends AbstractAntiCancelBaseVoucherService {
    private VoucherValidator validator = null;
    protected SubmitVoucherServiceHelper helper = new SubmitVoucherServiceHelper();

    public AntiCancelStandardVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    @Override
    protected boolean existCodingRule(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        return VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), (VoucherInfo)voucherInfo, voucherInfo.getBizStatus());
    }

    @Override
    protected void handleVoucherSubmitNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        voucherInfo.setNumber(VoucherNumberOperator.build(ctx).getNextValidNumber(voucherInfo, VoucherStatusEnum.SUBMITTED, false));
        if (voucherInfo instanceof VoucherInfo) {
            VoucherCollection col = new VoucherCollection();
            col.add((VoucherInfo)voucherInfo);
            VoucherHelpFacadeControllerBean.botpRewriteStatic(ctx, col);
        }
    }

    @Override
    protected void initVoucherValidator(Context ctx) throws EASBizException, BOSException {
        this.validator = this.getValidator(this.sysParam);
        if (this.validator == null) {
            this.validator = new VoucherValidator();
        }
        VoucherOprateSharer.mergeVoucherValidator(this.validator, this.getAdditionalValidator());
        VoucherValidatorFactory.getVoucherValidator(ctx, this.getClass().getName(), this.validator);
    }

    @Override
    protected void validatorVoucher(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        if (this.validator != null) {
            this.validator.validate(ctx, (VoucherInfo)voucherInfo);
        }
    }

    protected VoucherValidator getAdditionalValidator() throws BOSException {
        return null;
    }

    private VoucherValidator getValidator(GlParam sysParam) throws BOSException {
        VoucherValidator validator = new VoucherValidator();
        validator.addVoucherBaseValidator(new VoucherBaseAntiCancelValidator(sysParam));
        return validator;
    }

    @Override
    protected void afterAntiCancel(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.dealAmortVrh(ctx, (VoucherInfo)voucherInfo);
        this.dealAcctCussent(ctx, voucherInfo);
        this.updateAcctCussentBalance(ctx, voucherInfo, this.sysParam, false);
        this.sendCashFlowRequisition(ctx, voucherInfo);
        this.dealAcNotice(ctx, voucherInfo, this.sysParam);
        this.invokeVoucherAntiCancelPostProcessor(ctx, (VoucherInfo)voucherInfo);
    }

    private void dealAcctCussent(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, GLException, EASBizException {
        boolean allowcuss = this.sysParam.getBoolean("GL_028");
        if (allowcuss && voucherInfo.getBizStatus() == VoucherStatusEnum.SUBMITTED && voucherInfo.isIsAC()) {
            boolean isInTimeVerify;
            boolean bl = isInTimeVerify = this.sysParam.getInt("GL_052") == 0;
            if (!isInTimeVerify) {
                String updateSql = "update t_gl_voucherassistrecord set FIsVierified = 0 where fbillid = ?";
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
                updateSql = "update t_gl_acctcussent set FIsVierified = 0 where FVOUCHERID = ?";
                DbUtil.execute((Context)ctx, (String)updateSql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
            }
            this.helper.clearAcctCussent(ctx, voucherInfo, this.sysParam);
            this.helper.dealAcctCussent(ctx, (VoucherInfo)voucherInfo, this.sysParam);
        }
    }

    private void dealAmortVrh(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        StringBuffer sqlAmortLog = new StringBuffer();
        sqlAmortLog.append(" select vlog.FID,vlog.FAmortSchemeID,vlog.FPeriodID,vs.FAmortAmount,vs.FtotalAmount ,policy.famount FPolicyAmount \r\t");
        sqlAmortLog.append(" from t_gl_vchamortlog vlog inner join t_gl_vchamortscheme vs on vlog.famortschemeid=vs.fid \r\t");
        sqlAmortLog.append(" inner join t_gl_vchamortpolicy policy on policy.famortschemeid = vs.fid and policy.fperiodid=vlog.fperiodid \r\t");
        sqlAmortLog.append(" inner join t_gl_voucher v on v.fid = vlog.fVoucherID  \r\t");
        sqlAmortLog.append(" where vlog.FVoucherID= ? \r\t");
        IRowSet rsAmortLog = DbUtil.executeQuery((Context)ctx, (String)sqlAmortLog.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            if (rsAmortLog.next()) {
                String amortSchemeId = rsAmortLog.getString("FAmortSchemeID");
                String periodId = rsAmortLog.getString("FPeriodID");
                String logId = rsAmortLog.getString("FID");
                BigDecimal amortAmount = rsAmortLog.getBigDecimal("FAmortAmount");
                BigDecimal policyAmount = rsAmortLog.getBigDecimal("FPolicyAmount");
                BigDecimal totalAmount = rsAmortLog.getBigDecimal("FtotalAmount");
                BigDecimal leftAmortAmount = amortAmount.add(policyAmount);
                String status = "2";
                if (totalAmount.compareTo(leftAmortAmount) == 0) {
                    status = "3";
                }
                String updateScheme = "update t_gl_vchamortscheme set famortamount=? ,fstatus=? where fid=?";
                DbUtil.execute((Context)ctx, (String)updateScheme, (Object[])new Object[]{leftAmortAmount, new Integer(status), amortSchemeId});
                String updatePolicy = "update t_gl_vchamortpolicy set fisvouchered= 1 where famortschemeid=? and fperiodid=?";
                DbUtil.execute((Context)ctx, (String)updatePolicy, (Object[])new Object[]{amortSchemeId, periodId});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void invokeVoucherAntiCancelPostProcessor(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherPostProcessorInvokeFactory.invokeVoucherAntiCancelPostProcessor(ctx, voucherInfo);
    }

    @Override
    protected void requestBudgetSubstract(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam, int action) throws BgCtrlException, EASBizException, BOSException {
        VoucherUtil.requestBudgetSubstract(ctx, (VoucherInfo)voucherInfo, sysParam, action);
    }

    @Override
    protected void intoVoucherLog(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        GLBalanceFacadeFactory.getLocalInstance(ctx).insertVoucherLog(new String[]{voucherInfo.getId().toString()}, 6, false, false);
    }

    protected void updateAcctCussentBalance(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam, boolean isPositiveSign) throws EASBizException, BOSException {
        boolean isInTimeVerify = sysParam.getInt("GL_052") == 0;
        boolean allowcuss = sysParam.getBoolean("GL_028");
        if (allowcuss && voucherInfo.isIsAC() && voucherInfo.getId() != null && isInTimeVerify) {
            VoucherOprateSharer.updateAcctCussentUnHoldedBalance(ctx, voucherInfo.getId().toString(), false);
        }
        if (allowcuss && voucherInfo.isIsAC()) {
            int flg = VoucherStatusEnum.POSTED == voucherInfo.getBizStatus() ? 1 : 0;
            AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).updateCussents(voucherInfo.getId().toString(), flg);
        }
    }

    protected void sendCashFlowRequisition(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        ICFRequisition iCFReq = CFRequisitionFactory.getLocalInstance(ctx);
        if (iCFReq.isEnableCFRequisition(voucherInfo.getCompany().getId().toString())) {
            ObjectUuidPK voucherPK = new ObjectUuidPK(voucherInfo.getId());
            iCFReq.clearRequisition((IObjectPK)voucherPK);
            iCFReq.sendRequisition((IObjectPK)voucherPK);
        }
    }

    protected void dealAcNotice(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        boolean isNoticeBySubmit = sysParam.getInt("GLG01_2") == 2;
        boolean useACNotice = sysParam.getBoolean("GLG01");
        if (useACNotice && isNoticeBySubmit) {
            AcNoticeUtil.dealAcNotice(ctx, null, (VoucherInfo)voucherInfo, voucherInfo.getCompany().getId().toString());
        }
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_auditCancel";
    }

    @Override
    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherAntiCancel", "Before");
    }

    @Override
    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherAntiCancel", "After");
    }
}

