/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.app.cache.PermissionCacheFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLMutexUtils;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.AuditBaseVoucherCollectionService;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.Counter;
import com.kingdee.eas.fi.gl.common.GLExecutor;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class AuditVoucherCollectionService
extends AuditBaseVoucherCollectionService {
    private final Counter counter = new Counter();
    private final Object synObj = new Object();
    private boolean multiThread = false;
    private boolean shareCache = false;
    private int threadCount = 2;
    private final Object synPer = new Object();
    private String cacheId;

    public AuditVoucherCollectionService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected String getAuditPermissionItem() {
        return "gl_voucher090_audit";
    }

    @Override
    protected void clearCache(Context ctx) {
    }

    @Override
    protected void initCache(Context ctx) {
    }

    public void auditMyself(Context ctx, List voucherIdList, BOSUuid auditorId) throws BOSException, EASBizException {
        LinkedHashSet[] idSets = this.splitIdList2Idstr(voucherIdList, this.VOUCHER_NUM);
        for (int i = 0; i < idSets.length; ++i) {
            this.auditVoucherCollection(ctx, idSets[i], auditorId);
        }
        this.processError(ctx, voucherIdList);
    }

    public void auditMyself(Context ctx, List voucherIdList) throws BOSException, EASBizException {
        BOSUuid auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        this.auditMyself(ctx, voucherIdList, auditorId);
    }

    @Override
    public void audit(Context ctx, List voucherIdList) throws BOSException, EASBizException {
        BOSUuid auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        this.audit(ctx, voucherIdList, auditorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void audit(Context ctx, List voucherIdList, BOSUuid auditorId) throws BOSException, EASBizException {
        if (voucherIdList == null || voucherIdList.size() == 0) {
            return;
        }
        if (auditorId == null) {
            auditorId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        ArrayList<MutexParameter> mps = new ArrayList<MutexParameter>();
        IMutexServiceControl mutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        try {
            VoucherProcessCache cache;
            boolean mutexLockModifyBalance = false;
            String actionResName = this.getMutexActionResName();
            if (actionResName != null) {
                Set<String> companyIds = this.getCompanyIds(ctx, voucherIdList);
                if (companyIds.size() == 0) {
                    return;
                }
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                Iterator<String> mp = companyIds.iterator();
                while (mp.hasNext()) {
                    boolean isSucceed;
                    String companyId = mp.next();
                    MutexParameter mp2 = GLMutexUtils.buildModifyBalanceParameter(ctx, companyId, userId, actionResName, null, MutexLockType.SHARE_LOCK);
                    MutexParameter current = mutex.requestMutex3(mp2);
                    boolean bl = isSucceed = current == null;
                    if (isSucceed) {
                        mps.add(mp2);
                        continue;
                    }
                    throw new EASBizException(new NumericExceptionSubItem("101", GLMutexUtils.getMutexMessage(ctx, current, mp2)));
                }
                mutexLockModifyBalance = true;
            }
            if (voucherIdList.size() <= 10) {
                VoucherProcessCache.initCache(ctx, cacheId);
                VoucherProcessCache.getCache(ctx).setMutexLockModifyBalance(mutexLockModifyBalance);
                this.auditMyself(ctx, voucherIdList, auditorId);
                return;
            }
            this.initThreadParam(ctx);
            if (!this.multiThread || voucherIdList.size() <= this.VOUCHER_NUM) {
                VoucherProcessCache.initCache(ctx, cacheId);
                VoucherProcessCache.getCache(ctx).setMutexLockModifyBalance(mutexLockModifyBalance);
                this.auditMyself(ctx, voucherIdList, auditorId);
                return;
            }
            LinkedHashSet[] idSets = this.splitIdList2Idstr(voucherIdList, this.VOUCHER_NUM);
            if (idSets.length < this.threadCount) {
                this.threadCount = idSets.length;
            }
            int tCount = 1;
            HashMap<Integer, ArrayList<LinkedHashSet>> map = new HashMap<Integer, ArrayList<LinkedHashSet>>();
            for (int i = 0; i < idSets.length; ++i) {
                ArrayList<LinkedHashSet> list = (ArrayList<LinkedHashSet>)map.get(tCount);
                if (list == null) {
                    list = new ArrayList<LinkedHashSet>();
                    map.put(tCount, list);
                }
                list.add(idSets[i]);
                if (++tCount <= this.threadCount) continue;
                tCount = 1;
            }
            if (this.shareCache) {
                VoucherProcessCache.initCache(ctx, cacheId);
                VoucherProcessCache.getCache(ctx).setMutexLockModifyBalance(mutexLockModifyBalance);
            }
            if ((cache = VoucherProcessCache.getCache(ctx)) != null) {
                cache.setMultiThread(true);
            }
            ArrayList<OptTask> tasks = new ArrayList<OptTask>();
            for (int i = 1; i <= this.threadCount; ++i) {
                List list = (List)map.get(i);
                OptTask task = new OptTask(ctx, list, auditorId, cache, mutexLockModifyBalance);
                tasks.add(task);
                GLExecutor.execute(task);
            }
            Iterator iterator = this.synObj;
            synchronized (iterator) {
                while (this.counter.i < tasks.size()) {
                    try {
                        this.synObj.wait();
                    }
                    catch (InterruptedException list) {}
                }
            }
            for (OptTask task : tasks) {
                if (task.ex == null) continue;
                if (task.ex instanceof EASBizException) {
                    throw (EASBizException)task.ex;
                }
                if (task.ex instanceof BOSException) {
                    throw (BOSException)task.ex;
                }
                throw new BOSException(task.ex);
            }
        }
        finally {
            for (MutexParameter mp : mps) {
                try {
                    mutex.releaseMutex(mp.getRequestId());
                }
                catch (Throwable throwable) {}
            }
            VoucherProcessCache.clearCache(ctx, cacheId);
        }
        this.processError(ctx, voucherIdList);
    }

    protected void initThreadParam(Context ctx) throws EASBizException, BOSException {
        String str;
        HashMap<String, Object> paramKeys = new HashMap<String, Object>();
        paramKeys.put("GL_VchOpt_MultiThread", null);
        paramKeys.put("GL_VchOpt_ShareCache", null);
        paramKeys.put("GL_VchOpt_ThreadCount", null);
        paramKeys.put("GL_VchOpt_BatchCount", null);
        HashMap params = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(paramKeys);
        if (params.get("GL_VchOpt_MultiThread") != null && "true".equals(str = params.get("GL_VchOpt_MultiThread").toString())) {
            this.multiThread = true;
        }
        if (params.get("GL_VchOpt_ShareCache") != null && "true".equals(str = params.get("GL_VchOpt_ShareCache").toString())) {
            this.shareCache = true;
        }
        if (params.get("GL_VchOpt_ThreadCount") != null) {
            try {
                str = params.get("GL_VchOpt_ThreadCount").toString();
                this.threadCount = Integer.parseInt(str);
            }
            catch (Exception str2) {
                // empty catch block
            }
            if (this.threadCount < 2 || this.threadCount > 16) {
                this.threadCount = 2;
            }
        }
        if (params.get("GL_VchOpt_BatchCount") != null) {
            try {
                str = params.get("GL_VchOpt_BatchCount").toString();
                this.VOUCHER_NUM = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.VOUCHER_NUM < 10 || this.VOUCHER_NUM > 100) {
                this.VOUCHER_NUM = 20;
            }
        }
    }

    @Override
    protected void auditVoucherCollection(Context ctx, LinkedHashSet idSet, BOSUuid auditorId) throws BOSException, EASBizException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection allVoucherColl = iVoucher.getVoucherCollection(this.getEntityView(VoucherInfo.getAuditVoucherSelector(), idSet));
        VoucherCollection hasPermissionVoucherColl = this.getHasPermissionVoucherCollection(ctx, allVoucherColl);
        VoucherInfo voucherInfo = null;
        Iterator idIter = idSet.iterator();
        while (idIter.hasNext()) {
            String voucherid = idIter.next().toString();
            voucherInfo = hasPermissionVoucherColl.get((Object)BOSUuid.read((String)voucherid));
            String oldNumber = "";
            String oldVoucherType = "";
            try {
                if (voucherInfo == null) {
                    voucherInfo = allVoucherColl.get((Object)BOSUuid.read((String)voucherid));
                    if (!iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherid))) continue;
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, this.getAuditPermissionItem());
                    Object[] object = new Object[]{voucherInfo.getCompany().getName(), permItemInfo.getAlias()};
                    PermissionException pe = new PermissionException(PermissionException.HAS_NOT_ORG_DATA_PERMISSION, object);
                    throw pe;
                }
                this.checkPermission(ctx, voucherInfo, this.getAuditPermissionItem());
                this.disablePermission();
                oldNumber = voucherInfo.getNumber();
                oldVoucherType = voucherInfo.getVoucherType() == null ? "" : (voucherInfo.getVoucherType().getName() == null ? "" : voucherInfo.getVoucherType().getName());
                ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
                iVoucher.auditVoucherNewTrans((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), auditorId);
            }
            catch (Exception e) {
                String voucherStr;
                log.error((Object)"ERROR", (Throwable)e);
                if (e instanceof PermissionException) {
                    this.noPermErrors.put(voucherid, e.getMessage());
                    continue;
                }
                if (e instanceof MatchAssignmentException) {
                    voucherStr = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"MatchAssignmentException", (Locale)ctx.getLocale()), voucherInfo.getNumber());
                    this.commonErrors.put(voucherid, voucherStr);
                    continue;
                }
                voucherStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"voucher", (Locale)ctx.getLocale());
                String auditFailStr = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"AUDIT_FAIL", (Locale)ctx.getLocale());
                this.commonErrors.put(voucherid, voucherInfo.getCompany().getName() + " " + voucherStr + oldVoucherType + oldNumber + auditFailStr + e.getMessage());
            }
        }
    }

    private VoucherCollection getHasPermissionVoucherCollection(Context ctx, VoucherCollection allVoucherColl) throws BOSException, EASBizException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherCollection hasPermissionVoucherColl = new VoucherCollection();
        HashMap compamyMap = new HashMap();
        int size = allVoucherColl.size();
        for (int i = 0; i < size; ++i) {
            VoucherInfo vch = allVoucherColl.get(i);
            String companyID = vch.getCompany().getId().toString();
            Set<String> idSet = null;
            if (compamyMap.get(companyID) == null) {
                idSet = new HashSet();
                compamyMap.put(companyID, idSet);
            } else {
                idSet = (Set)compamyMap.get(companyID);
            }
            idSet.add(vch.getId().toString());
        }
        Iterator companyIter = compamyMap.keySet().iterator();
        while (companyIter.hasNext()) {
            String companyID = companyIter.next().toString();
            Set idSet = (Set)compamyMap.get(companyID);
            hasPermissionVoucherColl.addCollection(this.queryHasDataPermVoucherCollection(ctx, this.getQueryPermissionSql(ctx, this.getAuditPermissionItem(), companyID), iVoucher, this.getEntityView(VoucherInfo.getAuditVoucherSelector(), idSet)));
        }
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            cache.setVoucherCollection(VoucherInfo.getAuditVoucherSelector(), hasPermissionVoucherColl);
        }
        return hasPermissionVoucherColl;
    }

    private VoucherCollection queryHasDataPermVoucherCollection(Context ctx, String queryPermissionSql, IVoucher ivoucher, EntityViewInfo view) throws BOSException, EASBizException {
        if (queryPermissionSql != null && queryPermissionSql.trim().length() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)queryPermissionSql, CompareType.INNER));
            filterInfo.mergeFilter(view.getFilter(), "and");
            view.setFilter(filterInfo);
        }
        VoucherCollection vchColl = ivoucher.getVoucherCollection(view);
        return vchColl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkPermission(Context ctx, VoucherInfo voucherInfo, String permItem) throws BOSException, EASBizException {
        Object object = this.synPer;
        synchronized (object) {
            String companyid = voucherInfo.getCompany().getId().toString();
            VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
            if (cache.getFunctionPermMap().get(companyid) == null) {
                cache.getFunctionPermMap().put(companyid, false);
                this.checkFunctionPermission(ctx, (IObjectPK)new ObjectUuidPK(companyid), permItem);
                cache.getFunctionPermMap().put(companyid, true);
            } else {
                Boolean hasFunctionPermission = (Boolean)cache.getFunctionPermMap().get(companyid);
                if (!hasFunctionPermission.booleanValue()) {
                    PermItemInfo permItemInfo = PermissionCacheFactory.getPermItemCache((Context)ctx).getPermItem(ctx, permItem);
                    Object[] object2 = new Object[]{permItemInfo.getAlias()};
                    PermissionException pe = new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION, object2);
                    throw pe;
                }
            }
        }
    }

    private VoucherCollection getNoPermVouchers(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(sic);
        view.setFilter(filter);
        return VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(view);
    }

    @Override
    protected void processError(Context ctx, List voucherIdList) throws EASBizException, BOSException {
        if (this.commonErrors.size() <= 0 && this.noPermErrors.size() <= 0) {
            return;
        }
        VoucherCollection vchCol = null;
        if (this.noPermErrors.size() > 0) {
            vchCol = this.getNoPermVouchers(ctx, this.noPermErrors.keySet());
        }
        StringBuffer errMsg = new StringBuffer();
        for (Object pk : voucherIdList) {
            VoucherInfo voucher;
            String id = pk.toString();
            if (this.commonErrors.containsKey(id)) {
                errMsg.append("\r\n").append((String)this.commonErrors.get(id));
                continue;
            }
            if (!this.noPermErrors.containsKey(id) || vchCol == null || (voucher = vchCol.get((Object)BOSUuid.read((String)id))) == null) continue;
            errMsg.append("\r\n").append(voucher.getVoucherType().getName() + " " + voucher.getNumber()).append(" ").append((String)this.noPermErrors.get(id));
        }
        throw new VoucherException(VoucherException.AUDIT_FAILED, new Object[]{errMsg.toString()});
    }

    public String getMutexActionResName() {
        return null;
    }

    protected Set<String> getCompanyIds(Context ctx, List list) throws BOSException, EASBizException {
        int i;
        HashSet<String> companyIds = new HashSet<String>();
        int batchCount = 100;
        String fullSql = "select FID, FCompanyID from T_GL_Voucher where FID in (" + AuditVoucherCollectionService.buildMark(batchCount) + ")";
        String lessSql = null;
        ArrayList idss = new ArrayList();
        Set ids = new HashSet<String>();
        for (i = 0; i < list.size(); ++i) {
            Object pk = list.get(i);
            if (pk == null) continue;
            ids.add(pk.toString());
            if (ids.size() != 100) continue;
            idss.add(ids);
            ids = new HashSet();
        }
        if (ids.size() > 0) {
            idss.add(ids);
            lessSql = "select distinct FCompanyID from T_GL_Voucher where FID in (" + AuditVoucherCollectionService.buildMark(ids.size()) + ")";
        }
        try {
            for (i = 0; i < idss.size(); ++i) {
                ids = (Set)idss.get(i);
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(ids.size() == batchCount ? fullSql : lessSql), (Object[])ids.toArray());
                while (rs.next()) {
                    companyIds.add(rs.getString("FCompanyID"));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return companyIds;
    }

    public static String buildMark(int count) {
        StringBuffer mark = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                mark.append("?");
                continue;
            }
            mark.append(", ?");
        }
        return mark.toString();
    }

    class OptTask
    implements Runnable {
        Context ctx = null;
        List<LinkedHashSet> idSets;
        BOSUuid auditorId;
        VoucherProcessCache cache = null;
        boolean mutexLockModifyBalance;
        Throwable ex;

        OptTask(Context ctx, List<LinkedHashSet> idSets, BOSUuid auditorId, VoucherProcessCache cache, boolean mutexLockModifyBalance) {
            this.ctx = ctx;
            this.idSets = idSets;
            this.auditorId = auditorId;
            this.cache = cache;
            this.mutexLockModifyBalance = mutexLockModifyBalance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String cacheId = BOSUuid.create((String)"ABCD1234").toString();
            if (this.cache != null) {
                cacheId = this.cache.getCacheId();
                VoucherProcessCache.initCache(this.ctx, this.cache);
            } else {
                VoucherProcessCache.initCache(this.ctx, cacheId);
                VoucherProcessCache.getCache(this.ctx).setMultiThread(true);
                VoucherProcessCache.getCache(this.ctx).setMutexLockModifyBalance(this.mutexLockModifyBalance);
            }
            try {
                for (LinkedHashSet idSet : this.idSets) {
                    AuditVoucherCollectionService.this.auditVoucherCollection(this.ctx, idSet, this.auditorId);
                }
            }
            catch (Throwable ex) {
                this.ex = ex;
            }
            finally {
                VoucherProcessCache.clearCache(this.ctx, cacheId);
            }
            Object object = AuditVoucherCollectionService.this.synObj;
            synchronized (object) {
                ++((AuditVoucherCollectionService)AuditVoucherCollectionService.this).counter.i;
                AuditVoucherCollectionService.this.synObj.notifyAll();
            }
        }
    }
}

