/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitGroupInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstAccount;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.IAcountScheme;
import com.kingdee.eas.fi.books.IVoucherMessage;
import com.kingdee.eas.fi.books.VoucherMessageFactory;
import com.kingdee.eas.fi.books.VoucherMessageInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.UserSettingUtil;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherEntryAutoBalance;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BookUtil {
    private static final Logger logger = Logger.getLogger(BookUtil.class);
    public static final String MESSAGERES = "com.kingdee.eas.fi.gl.GLResource";

    public static IObjectPK transferVoucherByVoucherMessage(Context ctx, String vchId, CompanyOrgUnitInfo transferOrg, String filter) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(vchId), VoucherInfo.getDefaultSelector());
        if (BookUtil.checkVchAndOrgPeriod(ctx, voucherInfo.getBookedDate(), transferOrg.getId().toString(), transferOrg.getAccountPeriodType().getId().toString(), voucherInfo.getPeriod().getNumber())) {
            BookUtil._saveVoucherMessageNew(ctx, voucherInfo, transferOrg, null, false, "8003");
            return null;
        }
        if (!BookUtil.checkAccountSchemeRuleNew(ctx, vchId, filter)) {
            BookUtil._saveVoucherMessage(ctx, voucherInfo, transferOrg, null, false, "4002");
            return null;
        }
        AcountSchemeInfo accountScheme = null;
        if (transferOrg.getAccountScheme() == null) {
            accountScheme = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrg.getId().toString());
            transferOrg.setAccountScheme(accountScheme);
        } else {
            accountScheme = transferOrg.getAccountScheme();
        }
        CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany((Context)ctx, (CompanyOrgUnitInfo)transferOrg);
        int status = BooksUtil.getTransferStatus((Context)ctx, (String)accountScheme.getId().toString(), (CompanyOrgUnitInfo)masterCompany);
        IObjectPK pk = null;
        if (voucherInfo.getBizStatus().getValue() == 5 && status == 1 || voucherInfo.getBizStatus().getValue() >= 3 && status == 0) {
            if (BookUtil.isTransPLVoucher(voucherInfo)) {
                return null;
            }
            int n = status = voucherInfo.getBizStatus().getValue() == 5 ? 1 : 0;
            if (voucherInfo.getId() != null) {
                IVoucherMessage voucherMessage = VoucherMessageFactory.getLocalInstance(ctx);
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)transferOrg.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)accountScheme.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("srcVoucher.id", (Object)vchId));
                fi.getFilterItems().add(new FilterItemInfo("tagVoucher.id", null, CompareType.EQUALS));
                pk = voucherMessage.exists(fi) ? BookUtil.transfer(ctx, status, voucherInfo, transferOrg) : BookUtil.transferByNoDel(ctx, status, voucherInfo, transferOrg);
            } else {
                pk = BookUtil.transferByNoDel(ctx, status, voucherInfo, transferOrg);
            }
        } else {
            BookUtil._saveVoucherMessage(ctx, voucherInfo, transferOrg, pk, false, "4002");
        }
        return pk;
    }

    private static IObjectPK transferByNoDel(Context ctx, int status, VoucherInfo vchInfo, CompanyOrgUnitInfo transferOrg) throws EASBizException, BOSException {
        String msg = null;
        IObjectPK pk = null;
        VoucherInfo srcVoucher = new VoucherInfo();
        srcVoucher.setId(vchInfo.getId());
        srcVoucher.setPeriod(vchInfo.getPeriod());
        AcountSchemeInfo accountScheme = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrg.getId().toString());
        Object obj = BookUtil.dealVoucher(ctx, vchInfo, status, transferOrg);
        boolean isSuc = false;
        if (obj instanceof IObjectPK) {
            pk = (IObjectPK)obj;
            msg = "0000";
            isSuc = true;
        } else {
            msg = (String)obj;
        }
        BookUtil._saveVoucherMessage2(ctx, accountScheme, srcVoucher, transferOrg, pk, isSuc, msg);
        return pk;
    }

    private static IObjectPK transfer(Context ctx, int status, VoucherInfo vchInfo, CompanyOrgUnitInfo transferOrg) throws EASBizException, BOSException {
        String msg = null;
        IObjectPK pk = null;
        VoucherInfo srcVoucher = new VoucherInfo();
        srcVoucher.setId(vchInfo.getId());
        srcVoucher.setPeriod(vchInfo.getPeriod());
        Object obj = BookUtil.dealVoucher(ctx, vchInfo, status, transferOrg);
        boolean isSuc = false;
        if (obj instanceof IObjectPK) {
            pk = (IObjectPK)obj;
            msg = "0000";
            isSuc = true;
        } else {
            msg = (String)obj;
        }
        BookUtil._saveVoucherMessage(ctx, srcVoucher, transferOrg, pk, isSuc, msg);
        return pk;
    }

    private static void _saveVoucherMessageNew(Context ctx, VoucherInfo srcVoucher, CompanyOrgUnitInfo transferOrg, IObjectPK tagPK, boolean isSuc, String msg) throws EASBizException, BOSException {
        AcountSchemeInfo accountScheme = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrg.getId().toString());
        IVoucherMessage voucherMessage = VoucherMessageFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)transferOrg.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)accountScheme.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("srcVoucher.id", (Object)srcVoucher.getId().toString()));
        if (voucherMessage.exists(filter)) {
            VoucherMessageFactory.getLocalInstance(ctx).delete(filter);
        }
        BookUtil._saveVoucherMessage2New(ctx, accountScheme, srcVoucher, transferOrg, tagPK, isSuc, msg);
    }

    private static void _saveVoucherMessage(Context ctx, VoucherInfo srcVoucher, CompanyOrgUnitInfo transferOrg, IObjectPK tagPK, boolean isSuc, String msg) throws EASBizException, BOSException {
        AcountSchemeInfo accountScheme = null;
        if (transferOrg.getAccountScheme() == null) {
            accountScheme = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrg.getId().toString());
            transferOrg.setAccountScheme(accountScheme);
        } else {
            accountScheme = transferOrg.getAccountScheme();
        }
        IVoucherMessage voucherMessage = VoucherMessageFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)transferOrg.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)accountScheme.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("srcVoucher.id", (Object)srcVoucher.getId().toString()));
        if (voucherMessage.exists(filter)) {
            VoucherMessageFactory.getLocalInstance(ctx).delete(filter);
        }
        BookUtil._saveVoucherMessage2(ctx, accountScheme, srcVoucher, transferOrg, tagPK, isSuc, msg);
    }

    public static void _saveVoucherMessage2New(Context ctx, AcountSchemeInfo book, VoucherInfo srcVoucher, CompanyOrgUnitInfo transferOrgInfo, IObjectPK tagPK, boolean isSuc, String msg) throws EASBizException, BOSException {
        IVoucherMessage voucherMessage = VoucherMessageFactory.getLocalInstance(ctx);
        VoucherMessageInfo info = new VoucherMessageInfo();
        info.setAccountScheme(book);
        info.setSrcVoucher(srcVoucher);
        if (tagPK != null) {
            VoucherInfo voucher = new VoucherInfo();
            voucher.setId(BOSUuid.read((String)tagPK.toString()));
            info.setTagVoucher(voucher);
        }
        info.setIsSuc(isSuc);
        String msgInfo = ResourceBase.getString((String)MESSAGERES, (String)msg, (Locale)ctx.getLocale());
        if (ctx.get((Object)"paramKey") != null) {
            Object[] params = (Object[])ctx.get((Object)"paramKey");
            for (int i = 0; i < params.length; ++i) {
                msgInfo = StringUtils.replace((String)msgInfo, (String)("{" + i + "}"), (String)("" + params[i]));
            }
        }
        info.setMessage(msgInfo);
        info.setCompany(transferOrgInfo);
        info.setPeriod(srcVoucher.getPeriod());
        voucherMessage.addnew((CoreBaseInfo)info);
    }

    public static void _saveVoucherMessage2(Context ctx, AcountSchemeInfo book, VoucherInfo srcVoucher, CompanyOrgUnitInfo transferOrgInfo, IObjectPK tagPK, boolean isSuc, String msg) throws EASBizException, BOSException {
        IVoucherMessage voucherMessage = VoucherMessageFactory.getLocalInstance(ctx);
        VoucherMessageInfo info = new VoucherMessageInfo();
        info.setAccountScheme(book);
        info.setSrcVoucher(srcVoucher);
        if (tagPK != null) {
            VoucherInfo voucher = new VoucherInfo();
            voucher.setId(BOSUuid.read((String)tagPK.toString()));
            info.setTagVoucher(voucher);
        }
        info.setIsSuc(isSuc);
        String msgInfo = ResourceBase.getString((String)MESSAGERES, (String)msg, (Locale)ctx.getLocale());
        if (ctx.get((Object)"paramKey") != null) {
            Object[] params = (Object[])ctx.get((Object)"paramKey");
            for (int i = 0; i < params.length; ++i) {
                msgInfo = StringUtils.replace((String)msgInfo, (String)("{" + i + "}"), (String)("" + params[i]));
            }
        }
        info.setMessage(msgInfo);
        info.setCompany(transferOrgInfo);
        info.setPeriod(srcVoucher.getPeriod());
        voucherMessage.addnew((CoreBaseInfo)info);
    }

    private static Object dealVoucher(Context ctx, VoucherInfo voucher, int status, CompanyOrgUnitInfo transferOrg) throws EASBizException, BOSException {
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucher.getSourceType())) {
            return "8004";
        }
        String mainOrgId = voucher.getCompany().getId().toString();
        AcountSchemeInfo accountScheme = BooksUtil.getCurrentBook((Context)ctx, (String)transferOrg.getId().toString());
        String[] paramList = new String[]{"G001", "GL_052", "GL_028", "G010", "GL_008"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)transferOrg.getId().toString());
        boolean useReport = glParam.getBoolean("G001");
        boolean isInTimeVerify = glParam.getInt("GL_052") == 0;
        boolean allowCussent = glParam.getBoolean("GL_028");
        boolean isQtyAsst = glParam.getBoolean("G010");
        boolean isFzz = glParam.getBoolean("GL_008");
        String msg = null;
        IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        String accountRef = BookUtil._getAcctRefConstrast(ctx, transferOrg.getId().toString(), mainOrgId, transferOrg.getId().toString());
        if ("1001".equals(accountRef)) {
            return accountRef;
        }
        String srcVchid = voucher.getId().toString();
        BookUtil._lazyLoadCashflow(ctx, voucher);
        msg = BookUtil._reBuildVoucher(ctx, voucher, accountRef, transferOrg, useReport, isQtyAsst, isInTimeVerify, accountScheme);
        IObjectPK pk = null;
        if (msg == null) {
            String actionName;
            List afterListeners;
            try {
                String comid = transferOrg.getId().toString();
                VoucherInfo vo = new VoucherInfo();
                vo.setBizStatus(VoucherStatusEnum.getEnum((int)status));
                vo.setPeriod(voucher.getPeriod());
                vo.setVoucherType(voucher.getVoucherType());
                RuleStatus ruleStatus = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getRuleStatus((IObjectValue)vo, comid, "bizStatus");
                if (!ruleStatus.isExist()) {
                    return "9001";
                }
                while (VoucherUtil.existVoucher(ctx, voucher, transferOrg)) {
                    voucher.setNumber(BookUtil.genVoucherId(ctx, voucher, status, transferOrg, ruleStatus));
                }
            }
            catch (Exception e) {
                return "9001";
            }
            BookUtil.autoBalance(ctx, voucher);
            if (null != ctx.get((Object)"checkDebitCredit")) {
                ctx.remove((Object)"checkDebitCredit");
                return "9002";
            }
            VoucherEntryCollection coll = voucher.getEntries();
            BigDecimal entryLocalDebitAmount = BigDecimal.ZERO;
            BigDecimal entryLocalCreditAmount = BigDecimal.ZERO;
            BigDecimal entryRptDebitAmount = BigDecimal.ZERO;
            BigDecimal entryRptCreditAmount = BigDecimal.ZERO;
            for (int i = 0; i < coll.size(); ++i) {
                VoucherEntryInfo entry = coll.get(i);
                if (entry.getEntryDC() == EntryDC.DEBIT) {
                    entryLocalDebitAmount = entryLocalDebitAmount.add(entry.getLocalAmount());
                    if (!useReport) continue;
                    entryRptDebitAmount = entryRptDebitAmount.add(entry.getReportingAmount());
                    continue;
                }
                entryLocalCreditAmount = entryLocalCreditAmount.add(entry.getLocalAmount());
                if (!useReport) continue;
                entryRptCreditAmount = entryRptCreditAmount.add(entry.getReportingAmount());
            }
            CurrencyInfo localCur = null;
            localCur = isFzz ? voucher.getCurrency() : voucher.getCompany().getBaseCurrency();
            CurrencyInfo rptCur = null;
            if (useReport) {
                rptCur = voucher.getCompany().getReportCurrency();
            }
            if (GlUtils.setScale(entryLocalDebitAmount, localCur.getPrecision()).compareTo(GlUtils.setScale(entryLocalCreditAmount, localCur.getPrecision())) != 0) {
                Object[] params = new Object[]{GlUtils.formatNumber(entryLocalDebitAmount, localCur.getPrecision()), GlUtils.formatNumber(entryLocalCreditAmount, localCur.getPrecision())};
                ctx.put((Object)"paramKey", (Object)params);
                return "1035";
            }
            if (useReport && GlUtils.setScale(entryRptDebitAmount, rptCur.getPrecision()).compareTo(GlUtils.setScale(entryRptCreditAmount, rptCur.getPrecision())) != 0) {
                Object[] params = new Object[]{GlUtils.formatNumber(entryRptDebitAmount, rptCur.getPrecision()), GlUtils.formatNumber(entryRptCreditAmount, rptCur.getPrecision())};
                ctx.put((Object)"paramKey", (Object)params);
                return "1036";
            }
            pk = VoucherUtil._addnewVoucher(ctx, voucher);
            BizobjectFacadeFactory.getLocalInstance((Context)ctx).copyBizRelation(srcVchid, pk.toString());
            BookUtil._createBotRelation(ctx, srcVchid, pk.toString(), voucher.getBOSType());
            if (status == 1) {
                iGLPeriodEndFacade.postVoucherOnBook(transferOrg.getCU().getId().toString(), transferOrg.getId().toString(), new String[]{pk.toString()}, useReport, 1, false);
                iGLPeriodEndFacade.postVoucherOnBook(transferOrg.getCU().getId().toString(), transferOrg.getId().toString(), new String[]{pk.toString()}, useReport, 5, false);
            } else if (status == 0) {
                iGLPeriodEndFacade.postVoucherOnBook(transferOrg.getCU().getId().toString(), transferOrg.getId().toString(), new String[]{pk.toString()}, useReport, 1, false);
            }
            if (allowCussent && (status == 0 && !isInTimeVerify || status == 1 && isInTimeVerify)) {
                AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertCussent(pk.toString());
                AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertVerify(pk.toString(), isInTimeVerify);
            }
            if ((afterListeners = BookUtil.getActionAfterListeners(ctx, actionName = status == 1 ? "GL_VoucherPost" : "GL_VoucherAudit")) != null) {
                for (Object afterListener : afterListeners) {
                    ((GLActionListener)afterListener).actionPerformed(ctx, voucher);
                }
            }
        } else {
            return msg;
        }
        return pk;
    }

    private static List getActionBeforeListeners(Context ctx, String actionName) throws BOSException {
        return GLActionListener.getListeners(ctx, actionName, "Before");
    }

    private static List getActionAfterListeners(Context ctx, String actionName) throws BOSException {
        return GLActionListener.getListeners(ctx, actionName, "After");
    }

    private static void autoBalance(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        VoucherEntryAutoBalance autoBalance = new VoucherEntryAutoBalance();
        String[] paramList = new String[]{"GL_100_1", "GL_100_2", "GL_100", "GL_0301"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)voucherInfo.getCompany().getId().toString());
        autoBalance.setSysParam(glParam);
        autoBalance.setVoucherInfo(voucherInfo);
        autoBalance.setCtx(ctx);
        autoBalance.autoBalanceVoucherEntry();
    }

    public static boolean checkVchAndOrgPeriod(Context ctx, Date time, String transferOrgId, String periodTypeId, int periodNumber) {
        boolean result = false;
        try {
            int comPeriodNumber = GlUtils.getCurrentPeriod(ctx, transferOrgId).getNumber();
            PeriodCollection coll = GlWebServiceUtil.fetchPeriod(ctx, periodTypeId, time);
            int vchPeriodNumber = coll.get(0).getNumber();
            if (coll != null && coll.size() == 2) {
                for (int i = 0; i < coll.size(); ++i) {
                    PeriodInfo info = coll.get(i);
                    if (!info.isIsAdjustPeriod() || periodNumber != info.getNumber()) continue;
                    vchPeriodNumber = coll.get(i).getNumber();
                }
            }
            if (vchPeriodNumber < comPeriodNumber) {
                result = true;
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectPK _transferVoucher(Context ctx, int status, String vchid, String mainOrg, boolean useReport, boolean allowCussent, boolean isInTimeVerify) throws EASBizException, BOSException {
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        String cacheId = BOSUuid.create((String)"ABCD1234").toString();
        if (cache == null) {
            VoucherProcessCache.initCache(ctx, cacheId);
        }
        IObjectPK pk = null;
        try {
            ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            Map bookList = BookUtil.getBookList(ctx, mainOrg);
            Set keys = bookList.keySet();
            for (String transferOrg : keys) {
                List rule = (List)bookList.get(transferOrg);
                String bookid = (String)rule.get(0);
                String filter = (String)rule.get(1);
                if (!BookUtil.checkAccountSchemeRuleNew(ctx, vchid, filter)) continue;
                CompanyOrgUnitInfo transferOrgInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(transferOrg), GlUtils.getCompanySic());
                CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany((Context)ctx, (CompanyOrgUnitInfo)transferOrgInfo);
                if (status == BooksUtil.getTransferStatus((Context)ctx, (String)bookid, (CompanyOrgUnitInfo)masterCompany)) {
                    VoucherInfo voucher;
                    if (BookUtil._checkHasTransfered(ctx, vchid, bookid) || !BookUtil._checkPeriodValid(ctx, vchid, bookid) || BookUtil.isTransPLVoucher(voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(vchid.toString())))) continue;
                    pk = BookUtil.transfer(ctx, status, voucher, transferOrgInfo);
                    continue;
                }
                if (status != 9999) continue;
                VoucherInfo voucherInfo = BookUtil._getSimpleVoucher(ctx, pk);
                BookUtil._saveVoucherMessage(ctx, voucherInfo, transferOrgInfo, pk, false, "4002");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            VoucherProcessCache cache1 = VoucherProcessCache.getCache(ctx);
            VoucherProcessCache.clearCache(ctx, cacheId);
        }
        return pk;
    }

    private static Map getBookList(Context ctx, String mainOrg) throws EASBizException, BOSException {
        Map bookList;
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null) {
            Map bookListMap = cache.getBookListMap();
            if (bookListMap.containsKey(mainOrg)) {
                bookList = (Map)bookListMap.get(mainOrg);
            } else {
                bookList = BookUtil._getBookList(ctx, mainOrg, true);
                cache.setBookList(mainOrg, bookList);
            }
        } else {
            bookList = BookUtil._getBookList(ctx, mainOrg, true);
        }
        return bookList;
    }

    public static void _transferVoucherCollection(Context ctx, int status, List pkList, String mainOrg, boolean useReport, boolean allowCussent, boolean isInTimeVerify) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        IAcountScheme iAcountScheme = AcountSchemeFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = null;
        Map bookList = BookUtil.getBookList(ctx, mainOrg);
        Set keys = bookList.keySet();
        Iterator it = keys.iterator();
        IObjectPK ojbPK = null;
        while (it.hasNext()) {
            String transferOrg = (String)it.next();
            List rule = (List)bookList.get(transferOrg);
            String bookid = (String)rule.get(0);
            String filter = (String)rule.get(1);
            AcountSchemeInfo book = (AcountSchemeInfo)iAcountScheme.getValue((IObjectPK)new ObjectUuidPK(bookid));
            CompanyOrgUnitInfo transferOrgInfo = iCompanyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(transferOrg), GlUtils.getCompanySic());
            CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany((Context)ctx, (CompanyOrgUnitInfo)transferOrgInfo);
            if (status == BooksUtil.getTransferStatus((Context)ctx, (String)bookid, (CompanyOrgUnitInfo)masterCompany)) {
                ArrayList<IObjectPK> newPkList = new ArrayList<IObjectPK>();
                int n = pkList.size();
                for (int i = 0; i < n; ++i) {
                    VoucherInfo voucher;
                    pk = (ObjectUuidPK)pkList.get(i);
                    if (!BookUtil.checkAcountSchemeRule(ctx, pk.toString(), filter) || BookUtil._checkHasTransfered(ctx, pk.toString(), bookid) || !BookUtil._checkPeriodValid(ctx, pk.toString(), bookid) || BookUtil.isTransPLVoucher(voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(pk.toString()))) || (ojbPK = BookUtil.transfer(ctx, status, voucher, transferOrgInfo)) == null) continue;
                    newPkList.add(ojbPK);
                }
                continue;
            }
            if (status != 9999) continue;
            int n = pkList.size();
            for (int i = 0; i < n; ++i) {
                pk = (ObjectUuidPK)pkList.get(i);
                VoucherInfo voucher = BookUtil._getSimpleVoucher(ctx, (IObjectPK)pk);
                BookUtil._saveVoucherMessage(ctx, voucher, transferOrgInfo, (IObjectPK)pk, false, "4002");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String _reBuildVoucher(Context ctx, VoucherInfo voucherInfo, String accountRef, CompanyOrgUnitInfo transferOrg, boolean useReport, boolean isQtyAsst, boolean isInTimeVerify, AcountSchemeInfo book) throws BOSException, EASBizException {
        String mainBaseCurrency;
        CompanyOrgUnitInfo mainOrg = voucherInfo.getCompany();
        String getAccoutSql = " select fnewacctid from t_bd_acctrefcontrastentry where foldacctid=? and  FacctrefcontrastId = ? ";
        voucherInfo.setId(null);
        voucherInfo.setSourceBillId(null);
        String desc = ResourceBase.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"FromMasterAccount", (Locale)ctx.getLocale());
        voucherInfo.setDescription(desc);
        String msg = BookUtil._changePeriod(ctx, voucherInfo, mainOrg, transferOrg);
        if (msg != null) {
            return msg;
        }
        HashMap exchange = new HashMap();
        boolean needLoadCashflow = true;
        String transBaseCurrency = mainBaseCurrency = mainOrg.getBaseCurrency().getId().toString();
        if (transferOrg.getBaseCurrency() != null) {
            transBaseCurrency = transferOrg.getBaseCurrency().getId().toString();
        }
        boolean isSameCurrency = mainBaseCurrency.equals(transBaseCurrency);
        boolean isSameRptCurrency = true;
        String mainRptCurrency = null;
        String transRptCurrency = null;
        if (mainOrg.getReportCurrency() != null) {
            transRptCurrency = mainRptCurrency = mainOrg.getReportCurrency().getId().toString();
            if (transferOrg.getReportCurrency() != null) {
                transRptCurrency = transferOrg.getReportCurrency().getId().toString();
            }
            isSameRptCurrency = mainRptCurrency.equals(transRptCurrency);
        }
        VoucherInfo.ExchangeRateWithValue local = null;
        VoucherInfo.ExchangeRateWithValue rpt = null;
        Date rateDate = BookUtil.getByBizDate(ctx) ? voucherInfo.getBizDate() : voucherInfo.getBookedDate();
        int lcPre = transferOrg.getBaseCurrency().getPrecision();
        int rcurPre = 0;
        rcurPre = transferOrg.getReportCurrency() != null ? transferOrg.getReportCurrency().getPrecision() : lcPre;
        if (voucherInfo.getEntries() != null) {
            Object[] exes;
            Object[] info = null;
            if (!isSameCurrency || !isSameRptCurrency) {
                info = new Object[8];
                info[0] = transferOrg.getBaseExchangeTable().getId().toString();
                info[3] = transferOrg.getBaseCurrency().getId().toString();
                if (transferOrg.getReportExchangeTable() != null) {
                    info[1] = transferOrg.getReportExchangeTable().getId().toString();
                }
                if (transferOrg.getReportCurrency() != null) {
                    info[4] = transferOrg.getReportCurrency().getId().toString();
                }
                info[5] = rateDate;
                info[6] = voucherInfo.getPeriod().getEndDate();
            }
            if (!isSameCurrency) {
                info[2] = mainBaseCurrency;
                exes = GlUtils.getExchangeRate(ctx, info, mainBaseCurrency, exchange);
                local = (VoucherInfo.ExchangeRateWithValue)exes[0];
                if (local == null) {
                    return "2001";
                }
            } else {
                local = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            }
            if (!isSameRptCurrency) {
                info[2] = transBaseCurrency;
                exes = GlUtils.getExchangeRate(ctx, info, transBaseCurrency, exchange);
                rpt = (VoucherInfo.ExchangeRateWithValue)exes[1];
                if (rpt == null) {
                    return "2002";
                }
            } else {
                rpt = VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE;
            }
            boolean isSettleByLocal = 3 == transferOrg.getReportConvertMode().getValue();
            VoucherEntryCollection entrys = voucherInfo.getEntries();
            if (!isSameCurrency) {
                if (local.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    voucherInfo.setLocalCreditAmount(GlUtils.setScale(voucherInfo.getLocalCreditAmount().divide(local.getValue(), lcPre, 4), lcPre));
                    voucherInfo.setLocalDebitAmount(GlUtils.setScale(voucherInfo.getLocalDebitAmount().divide(local.getValue(), lcPre, 4), lcPre));
                } else {
                    voucherInfo.setLocalCreditAmount(GlUtils.setScale(voucherInfo.getLocalCreditAmount().multiply(local.getValue()), lcPre));
                    voucherInfo.setLocalDebitAmount(GlUtils.setScale(voucherInfo.getLocalDebitAmount().multiply(local.getValue()), lcPre));
                }
            }
            if (!isSameRptCurrency) {
                if (rpt.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    voucherInfo.setReportingCreditAmount(GlUtils.setScale(voucherInfo.getReportingCreditAmount().divide(rpt.getValue(), rcurPre, 4), rcurPre));
                    voucherInfo.setReportingDebitAmount(GlUtils.setScale(voucherInfo.getReportingDebitAmount().divide(rpt.getValue(), rcurPre, 4), rcurPre));
                } else {
                    voucherInfo.setReportingCreditAmount(GlUtils.setScale(voucherInfo.getReportingCreditAmount().multiply(rpt.getValue()), rcurPre));
                    voucherInfo.setReportingDebitAmount(GlUtils.setScale(voucherInfo.getReportingDebitAmount().multiply(rpt.getValue()), rcurPre));
                }
            }
            HashMap<String, AsstAccountInfo> caas = new HashMap<String, AsstAccountInfo>();
            HashMap fcaas = new HashMap();
            HashMap asstMap = new HashMap();
            Map result = BookUtil.getAllAsstMap(ctx, voucherInfo, transferOrg);
            for (int i = 0; i < entrys.size(); ++i) {
                ExchangeRateInfo bookExRate;
                VoucherEntryInfo entry = entrys.get(i);
                entry.setId(null);
                AccountViewInfo masAccount = entry.getAccount();
                AsstAccountInfo sourceCAA = entry.getCAA();
                masAccount.setCAA(sourceCAA);
                String accountid = BookUtil._getTranseAccount(ctx, getAccoutSql, masAccount.getId().toString(), accountRef, transferOrg.getId().toString());
                if (accountid == null) {
                    if (accountRef != null) return "1002";
                    return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1008");
                }
                AccountViewInfo transAccount = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountid));
                if (accountRef == null) {
                    if (transAccount.getAccrualDirection().getValue() != masAccount.getAccrualDirection().getValue()) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1009");
                    }
                    if (transAccount.getPLType().getValue() != masAccount.getPLType().getValue()) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1010");
                    }
                    if (!Boolean.valueOf(transAccount.isIsCash()).equals(masAccount.isIsCash())) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1011");
                    }
                    if (!Boolean.valueOf(transAccount.isIsBank()).equals(masAccount.isIsBank())) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1012");
                    }
                    if (!Boolean.valueOf(transAccount.isIsCashEquivalent()).equals(masAccount.isIsCashEquivalent())) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1013");
                    }
                    if (!Boolean.valueOf(transAccount.isAC()).equals(masAccount.isAC())) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1014");
                    }
                    CurrencyInfo masterCurrency = entry.getCurrency();
                    if (!BookUtil.checkCurrencyIsInTransfer(ctx, transAccount, masterCurrency, transferOrg)) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1015");
                    }
                    if (!Boolean.valueOf(transAccount.isIsQty()).equals(masAccount.isIsQty())) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1016");
                    }
                    if (!Boolean.valueOf(transAccount.isHasUserProperty()).equals(masAccount.isHasUserProperty())) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1032");
                    }
                }
                AsstAccountInfo targetCAA = GLAsstAccountUtils.getCAA(ctx, accountid, voucherInfo.getPeriod().getId().toString(), caas);
                transAccount.setCAA(targetCAA);
                entry.setCAA(targetCAA);
                entry.setAccount(transAccount);
                if (isQtyAsst) {
                    if (transAccount.isIsQty() && masAccount.isIsQty() && transAccount.getCAA() != null && masAccount.getCAA() != null) {
                        MeasureUnitGroupInfo masterCaaInfo = masAccount.getCAA().getMeasureUnitGroup();
                        MeasureUnitGroupInfo transferCaaInfo = transAccount.getCAA().getMeasureUnitGroup();
                        if (masterCaaInfo != null && transferCaaInfo == null || masterCaaInfo == null && transferCaaInfo != null || masterCaaInfo != null && transferCaaInfo != null && !masterCaaInfo.getId().toString().equals(transferCaaInfo.getId().toString())) {
                            return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1018");
                        }
                    }
                } else {
                    MeasureUnitGroupInfo masterInfo = masAccount.getMeasureUnitGroupID();
                    MeasureUnitGroupInfo transferInfo = transAccount.getMeasureUnitGroupID();
                    if (masterInfo != null && transferInfo == null || masterInfo == null && transferInfo != null || masterInfo != null && transferInfo != null && !masterInfo.getId().toString().equals(transferInfo.getId().toString())) {
                        return BookUtil.putCtxError(ctx, masAccount.getNumber(), "1017");
                    }
                }
                if (accountRef == null) {
                    IAsstAccount iAsstAccount = AsstAccountFactory.getLocalInstance((Context)ctx);
                    if (masAccount.getCAA() == null && transAccount.getCAA() != null || masAccount.getCAA() != null && transAccount.getCAA() != null && !iAsstAccount.compare((IObjectPK)new ObjectUuidPK(transAccount.getCAA().getId().toString()), (IObjectPK)new ObjectUuidPK(masAccount.getCAA().getId().toString()))) {
                        return "1005";
                    }
                }
                if (masAccount.getCAA() == null && transAccount.getCAA() == null && !masAccount.isHasUserProperty() && transAccount.isHasUserProperty()) {
                    return "1006";
                }
                if (needLoadCashflow && !accountid.equals(masAccount.getId().toString()) && (masAccount.isIsCash() || masAccount.isIsBank() || masAccount.isIsCashEquivalent())) {
                    needLoadCashflow = masAccount.isIsCash() || masAccount.isIsBank() || masAccount.isIsCashEquivalent();
                }
                CurrencyInfo originalCur = entry.getCurrency();
                if (!isSameCurrency) {
                    if (transBaseCurrency.equals(originalCur.getId().toString())) {
                        entry.setLocalExchangeRate(VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE.getValue());
                        if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType()) || entry.getOriginalAmount().compareTo(BigDecimal.ZERO) == 0) {
                            entry.setLocalAmount(GlUtils.computeAmnt(entry.getLocalAmount(), local, lcPre, false));
                        } else {
                            entry.setLocalAmount(entry.getOriginalAmount());
                        }
                    } else {
                        bookExRate = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(info[0].toString()), (IObjectPK)new ObjectUuidPK(originalCur.getId().toString()), (IObjectPK)new ObjectUuidPK(transBaseCurrency), rateDate);
                        ExchangeRateInfo masterExRate = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(info[0].toString()), (IObjectPK)new ObjectUuidPK(originalCur.getId().toString()), (IObjectPK)new ObjectUuidPK(mainBaseCurrency), rateDate);
                        entry.setLocalAmount(GlUtils.computeAmnt(entry.getLocalAmount(), local, lcPre, false));
                        int pre = bookExRate != null ? bookExRate.getPrecision() : local.getPresion();
                        BigDecimal masterRateValue = entry.getLocalExchangeRate();
                        if (masterExRate != null && masterExRate.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                            masterRateValue = new BigDecimal("1").divide(masterRateValue, masterRateValue.precision(), 4);
                        }
                        BigDecimal bookRateValue = GlUtils.computeAmnt(masterRateValue, local, pre, false);
                        if (bookExRate != null && bookExRate.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                            bookRateValue = new BigDecimal("1").divide(bookRateValue, pre, 4);
                        }
                        entry.setLocalExchangeRate(bookRateValue);
                    }
                }
                if (useReport) {
                    if (!isSameRptCurrency) {
                        if (!isSettleByLocal) {
                            if (transRptCurrency.equals(originalCur.getId().toString())) {
                                entry.setReportingExchangeRate(VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE.getValue());
                            } else {
                                int pre;
                                bookExRate = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(info[1].toString()), (IObjectPK)new ObjectUuidPK(originalCur.getId().toString()), (IObjectPK)new ObjectUuidPK(transRptCurrency), rateDate);
                                int n = pre = bookExRate != null ? bookExRate.getPrecision() : rpt.getPresion();
                                if (rpt.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                                    entry.setReportingExchangeRate(GlUtils.computeAmnt(entry.getReportingExchangeRate(), rpt, pre, true));
                                } else {
                                    entry.setReportingExchangeRate(GlUtils.computeAmnt(entry.getReportingExchangeRate(), rpt, pre, false));
                                }
                            }
                        } else if (transRptCurrency.equals(transBaseCurrency)) {
                            entry.setReportingExchangeRate(VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE.getValue());
                        } else {
                            int pre;
                            bookExRate = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(info[1].toString()), (IObjectPK)new ObjectUuidPK(transBaseCurrency), (IObjectPK)new ObjectUuidPK(transRptCurrency), rateDate);
                            int n = pre = bookExRate != null ? bookExRate.getPrecision() : rpt.getPresion();
                            if (rpt.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                                entry.setReportingExchangeRate(GlUtils.computeAmnt(entry.getReportingExchangeRate(), rpt, pre, true));
                            } else {
                                entry.setReportingExchangeRate(GlUtils.computeAmnt(entry.getReportingExchangeRate(), rpt, pre, false));
                            }
                        }
                        if (rpt.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                            entry.setReportingAmount(GlUtils.setScale(entry.getReportingAmount().divide(rpt.getValue(), rcurPre, 4), rcurPre));
                        } else {
                            entry.setReportingAmount(GlUtils.setScale(entry.getReportingAmount().multiply(rpt.getValue()), rcurPre));
                        }
                    } else if (!isSettleByLocal) {
                        if (transRptCurrency.equals(originalCur.getId().toString())) {
                            entry.setReportingExchangeRate(VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE.getValue());
                        } else {
                            int pre;
                            bookExRate = null;
                            if (info != null) {
                                bookExRate = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(info[1].toString()), (IObjectPK)new ObjectUuidPK(originalCur.getId().toString()), (IObjectPK)new ObjectUuidPK(transRptCurrency), rateDate);
                            }
                            int n = pre = bookExRate != null ? bookExRate.getPrecision() : rpt.getPresion();
                            if (rpt.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                                entry.setReportingExchangeRate(GlUtils.computeAmnt(entry.getReportingExchangeRate(), rpt, pre, true));
                            } else {
                                entry.setReportingExchangeRate(GlUtils.computeAmnt(entry.getReportingExchangeRate(), rpt, pre, false));
                            }
                        }
                    } else if (transRptCurrency.equals(transBaseCurrency)) {
                        entry.setReportingExchangeRate(VoucherInfo.ExchangeRateWithValue.STANDARD_EXCHANGERATE.getValue());
                    } else {
                        int pre;
                        bookExRate = null;
                        if (info != null) {
                            bookExRate = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateConvertInfo((IObjectPK)new ObjectUuidPK(info[1].toString()), (IObjectPK)new ObjectUuidPK(transBaseCurrency), (IObjectPK)new ObjectUuidPK(transRptCurrency), rateDate);
                        }
                        int n = pre = bookExRate != null ? bookExRate.getPrecision() : rpt.getPresion();
                        if (rpt.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                            entry.setReportingExchangeRate(GlUtils.computeAmnt(entry.getReportingExchangeRate(), rpt, pre, true));
                        } else {
                            entry.setReportingExchangeRate(GlUtils.computeAmnt(entry.getReportingExchangeRate(), rpt, pre, false));
                        }
                    }
                }
                if (transAccount.getCAA() == null && !transAccount.isHasUserProperty()) {
                    entry.setCAA(null);
                    entry.setAssistRecords((AbstractObjectCollection)new VoucherAssistRecordCollection());
                }
                if (isQtyAsst && masAccount.getCAA() != null && transAccount.getCAA() == null && masAccount.isIsQty()) {
                    entry.setPrice(GlUtils.setScale(entry.getOriginalAmount().divide(entry.getQuantity(), 2, 4), 2));
                    entry.setMeasureUnit(transAccount.getMeasureUnitID());
                }
                Map resultMap = BookUtil.getAcctData(ctx, accountRef, transAccount, masAccount);
                if (masAccount.getCAA() == null && transAccount.getCAA() != null && !transAccount.isHasUserProperty()) {
                    VoucherAssistRecordCollection reCollection = new VoucherAssistRecordCollection();
                    VoucherAssistRecordInfo reInfo = new VoucherAssistRecordInfo();
                    reInfo.setLocalAmount(entry.getLocalAmount());
                    reInfo.setOriginalAmount(entry.getOriginalAmount());
                    reInfo.setReportingAmount(entry.getReportingAmount());
                    reInfo.setSeq(0);
                    reInfo.setBizDate(voucherInfo.getBizDate());
                    reInfo.setEndDate(voucherInfo.getBizDate());
                    reInfo.setIsFullProp(false);
                    reInfo.setQuantity(entry.getQuantity());
                    reInfo.setStandardQuantity(entry.getStandardQuantity());
                    reInfo.setPrice(entry.getPrice());
                    reInfo.setMeasureUnit(entry.getMeasureUnit());
                    reInfo.setOprStatus(1);
                    Map defaults = (Map)resultMap.get("defaults");
                    if (defaults == null || defaults.size() == 0) {
                        Object[] params = new Object[]{transAccount.getNumber(), transAccount.getCAA() != null ? transAccount.getCAA().getName() : null};
                        ctx.put((Object)"paramKey", (Object)params);
                        return "8001";
                    }
                    AssistantHGInfo hgInfo = new AssistantHGInfo();
                    Iterator it = defaults.keySet().iterator();
                    IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
                    AsstActTypeCollection items = new AsstActTypeCollection();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        String value = (String)defaults.get(key);
                        String[] s = value.split("_!");
                        BOSUuid bosid = BOSUuid.read((String)s[2]);
                        IObjectValue dataInfo = iDynamicObject.getValue(bosid.getType(), (IObjectPK)new ObjectUuidPK(bosid));
                        AsstActTypeInfo asstActInfo = new AsstActTypeInfo();
                        asstActInfo.setAsstHGAttribute(s[0]);
                        asstActInfo.setName(s[1]);
                        items.add(asstActInfo);
                        hgInfo.put(s[0], (Object)dataInfo);
                    }
                    AssistantHGInfo hg = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(hgInfo, transAccount.getCAA().getId().toString(), items);
                    if (hg == null) {
                        return "8001";
                    }
                    reInfo.setAssGrp(hg);
                    reCollection.add(reInfo);
                    entry.setAssistRecords((AbstractObjectCollection)reCollection);
                    continue;
                }
                if (transAccount.getCAA() == null) continue;
                VoucherAssistRecordCollection records = entry.getAssistRecords();
                int recordCount = records.size();
                for (int j = 0; j < recordCount; ++j) {
                    VoucherAssistRecordInfo r = records.get(j);
                    AssistantHGInfo transferHgInfo = BookUtil.getNewHgInfo(ctx, resultMap, r.getAssGrp(), transAccount, masAccount, transferOrg, result);
                    if (transferHgInfo == null) {
                        return "8001";
                    }
                    r.setId(null);
                    r.setAssGrp(transferHgInfo);
                    if (isInTimeVerify) {
                        if (r.getVerifiedCussent() != null && r.getVerifiedCussent().getId().toString() != null) {
                            String acctCussentId = BookUtil._getTranseAcctCussent(ctx, r.getVerifiedCussent().getId().toString(), book.getId().toString(), transferOrg.getId().toString(), accountid);
                            if (acctCussentId == null || acctCussentId.trim().equals("")) return "7001";
                            r.getVerifiedCussent().setId(BOSUuid.read((String)acctCussentId));
                        } else if (r.getVerifiedCussent() != null) {
                            r.getVerifiedCussent().setId(null);
                        }
                    } else if (r.getVerifiedCussent() != null) {
                        r.getVerifiedCussent().setId(null);
                    }
                    if (!isSameCurrency) {
                        if (transBaseCurrency.equals(originalCur.getId().toString())) {
                            if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType()) || r.getOriginalAmount().compareTo(BigDecimal.ZERO) == 0) {
                                r.setLocalAmount(GlUtils.computeAmnt(r.getLocalAmount(), local, lcPre, false));
                            } else {
                                r.setLocalAmount(r.getOriginalAmount());
                            }
                        } else {
                            r.setLocalAmount(GlUtils.computeAmnt(r.getLocalAmount(), local, lcPre, false));
                        }
                    }
                    if (isSameRptCurrency) continue;
                    r.setReportingAmount(GlUtils.setScale(r.getReportingAmount().multiply(rpt.getValue()), rcurPre));
                }
            }
        }
        voucherInfo.setCompany(transferOrg);
        if (!needLoadCashflow) {
            voucherInfo.setCashflowRecords(null);
            return null;
        } else {
            if (voucherInfo.getCashflowRecords() == null || isSameCurrency && isSameRptCurrency) return null;
            for (CashflowRecordInfo cr : voucherInfo.getCashflowRecords()) {
                if (!isSameCurrency && local != null) {
                    if (local.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                        cr.setLocalAmount(GlUtils.setScale(cr.getLocalAmount().divide(local.getValue(), lcPre, 4), lcPre));
                    } else {
                        cr.setLocalAmount(GlUtils.setScale(cr.getLocalAmount().multiply(local.getValue()), lcPre));
                    }
                }
                if (isSameRptCurrency || rpt == null) continue;
                if (rpt.getConvertMode().equals((Object)ConvertModeEnum.INDIRECTEXCHANGERATE)) {
                    cr.setReportingAmount(GlUtils.setScale(cr.getReportingAmount().divide(rpt.getValue(), rcurPre, 4), rcurPre));
                    continue;
                }
                cr.setReportingAmount(GlUtils.setScale(cr.getReportingAmount().multiply(rpt.getValue()), rcurPre));
            }
        }
        return null;
    }

    public static String putCtxError(Context ctx, String accountNumber, String msgCode) {
        Object[] params = new Object[]{accountNumber};
        ctx.put((Object)"paramKey", (Object)params);
        return msgCode;
    }

    private static boolean checkCurrencyIsInTransfer(Context ctx, AccountViewInfo accountViewInfo, CurrencyInfo currencyInfo, CompanyOrgUnitInfo transfer) {
        boolean hasON = false;
        String currencyId = currencyInfo.getId().toString();
        int value = accountViewInfo.getAccountingcurrency().getValue();
        if (value == 1) {
            AccountCurrencyCollection accountCurrencyColl = accountViewInfo.getAccountCurrency();
            Iterator iter = accountCurrencyColl.iterator();
            while (iter.hasNext()) {
                CurrencyInfo curInfo = ((AccountCurrencyInfo)iter.next()).getCurrency();
                String curId = curInfo.getId().toString();
                if (!curId.equals(currencyId)) continue;
                hasON = true;
            }
        } else if (value == 2) {
            hasON = true;
        } else if (value == 0) {
            String curId = transfer.getBaseCurrency().getId().toString();
            hasON = curId.equals(currencyId);
        }
        return hasON;
    }

    private static Map getAllAsstMap(Context ctx, VoucherInfo voucherInfo, CompanyOrgUnitInfo tranferorg) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        HashMap<String, Object> asstActs = new HashMap<String, Object>();
        HashMap<String, Object> hgs = new HashMap<String, Object>();
        HashMap hgIdss = new HashMap();
        HashMap asstActIdss = new HashMap();
        for (VoucherEntryInfo entry : voucherInfo.getEntries()) {
            AccountViewInfo account = entry.getAccount();
            AsstAccountInfo caa = entry.getCAA();
            if (caa == null || entry.getAssistRecords() == null || entry.getAssistRecords().size() == 0) continue;
            String caaId = caa.getId().toString();
            HashSet<String> hgIds = (HashSet<String>)hgIdss.get(caaId);
            if (hgIds == null) {
                hgIds = new HashSet<String>();
                hgIdss.put(caaId, hgIds);
            }
            AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, caaId);
            for (VoucherAssistRecordInfo record : entry.getAssistRecords()) {
                AssistantHGInfo hg = record.getAssGrp();
                String string = hg.getId().toString();
                if (hgs.containsKey(string) || hgIds.contains(string)) continue;
                if (hg.getAsstAccount() == null || hg.getAsstAccount().getId() == null) {
                    hgIds.add(hg.getId().toString());
                    continue;
                }
                boolean isFull = true;
                for (AsstActTypeInfo asstActType : asstActTypes) {
                    DataBaseInfo data = (DataBaseInfo)hg.get(asstActType.getAsstHGAttribute());
                    if (data != null && data.getId() != null) {
                        HashSet<String> asstActIds = (HashSet<String>)asstActIdss.get(asstActType.getId().toString());
                        if (asstActIds == null) {
                            asstActIds = new HashSet<String>();
                            asstActIdss.put(asstActType.getId().toString(), asstActIds);
                        }
                        asstActIds.add(data.getId().toString());
                        continue;
                    }
                    isFull = false;
                }
                if (isFull) {
                    hgs.put(hg.getId().toString(), hg);
                    continue;
                }
                hgIds.add(hg.getId().toString());
            }
        }
        boolean foundError = false;
        for (String caaId : hgIdss.keySet()) {
            Set hgIds = (Set)hgIdss.get(caaId);
            if (hgIds.size() > 0) {
                AsstActTypeCollection asstActTypes = VoucherProcessCache.getAsstActTypes(ctx, caaId);
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                Iterator it = asstActTypes.iterator();
                while (it.hasNext()) {
                    selector.add(new SelectorItemInfo("id"));
                    selector.add(new SelectorItemInfo(((AsstActTypeInfo)it.next()).getAsstHGAttribute() + ".id"));
                }
                selector.add("asstAccount.id");
                view.setSelector(selector);
                int count = 0;
                List<Object> batchs = new ArrayList<Set>();
                if (hgIds.size() <= 200) {
                    batchs.add(hgIds);
                } else {
                    batchs = BookUtil.split(hgIds, 200);
                }
                for (Set set : batchs) {
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
                    view.setFilter(filter);
                    AssistantHGCollection coll = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGCollection(view);
                    count += coll.size();
                    block10: for (AssistantHGInfo hg : coll) {
                        hgs.put(hg.getId().toString(), hg);
                        if (!caaId.equals(hg.getAsstAccount().getId().toString())) {
                            foundError = true;
                            continue;
                        }
                        for (AsstActTypeInfo asstActType : asstActTypes) {
                            DataBaseInfo data;
                            HashSet<String> asstActIds = (HashSet<String>)asstActIdss.get(asstActType.getId().toString());
                            if (asstActIds == null) {
                                asstActIds = new HashSet<String>();
                                asstActIdss.put(asstActType.getId().toString(), asstActIds);
                            }
                            if ((data = (DataBaseInfo)hg.get(asstActType.getAsstHGAttribute())) != null) {
                                asstActIds.add(data.getId().toString());
                                continue;
                            }
                            foundError = true;
                            continue block10;
                        }
                    }
                }
                if (count != hgIds.size()) {
                    foundError = true;
                }
            }
            try {
                String cuId = null;
                if (voucherInfo.getCU() != null && voucherInfo.getCU().getId() != null) {
                    cuId = voucherInfo.getCU().getId().toString();
                }
                if (cuId == null && voucherInfo.getCompany().getCU() != null && voucherInfo.getCompany().getCU().getId() != null) {
                    cuId = voucherInfo.getCompany().getCU().getId().toString();
                }
                if (cuId == null) {
                    cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
                }
                String userId = null;
                if (voucherInfo.getCreator() != null && voucherInfo.getCreator().getId() != null) {
                    userId = voucherInfo.getCreator().getId().toString();
                }
                if (userId == null) {
                    userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                }
                for (String asstActTypeId : asstActIdss.keySet()) {
                    AsstActTypeInfo asstActType = new AsstActTypeInfo();
                    asstActType.setId(BOSUuid.read((String)asstActTypeId));
                    Map<String, Object> aAsstActs = VoucherProcessCache.findAsstActByIds(ctx, asstActType, (Set)asstActIdss.get(asstActTypeId), tranferorg, cuId, userId);
                    asstActs.putAll(aAsstActs);
                }
            }
            catch (EASBizException e) {
                throw e;
            }
            catch (BOSException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        map.put("hgs", hgs);
        map.put("asstActs", asstActs);
        return map;
    }

    private static List<Set<String>> split(Set<String> set, int size) {
        ArrayList<Set<String>> list = new ArrayList<Set<String>>();
        if (set.size() <= size) {
            HashSet<String> part = new HashSet<String>();
            part.addAll(set);
            list.add(part);
        } else {
            HashSet<String> part = new HashSet<String>();
            for (String str : set) {
                part.add(str);
                if (part.size() < size) continue;
                list.add(part);
                part = new HashSet();
            }
            if (part.size() > 0) {
                list.add(part);
            }
        }
        return list;
    }

    private static Map getAcctData(Context ctx, String accountRef, AccountViewInfo account, AccountViewInfo acc) throws BOSException {
        if (account.getCAA() == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        sql.append(" select distinct tdf.FAsstActTypeID,ty.fassthgattribute,tdf.FDEFAULTID,ty.FNAME_").append(ctx.getLocale().toString()).append(" fname from T_BD_AcctRefContrast t \t\r\n");
        sql.append(" inner join T_BD_AcctRefContrastEntry tf on tf.FAcctRefContrastID =t.fid \t\r\n");
        sql.append(" inner join T_AC_AcctRefContrastEntryDef tdf on tdf.FParentID = tf.fid \t\r\n");
        sql.append(" inner join T_BD_AsstActType ty on tdf.FAsstActTypeID = ty.fid \t\r\n");
        sql.append(" where tf.fnewacctid = ? and tf.foldacctid = ? and t.fid = ? and tdf.FDEFAULTID is not null  \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{account.getId().toString(), acc.getId().toString(), accountRef});
        HashMap<String, String> defaults = new HashMap<String, String>();
        try {
            while (rs != null && rs.next()) {
                String actTpye = rs.getString("FAsstActTypeID");
                String attr = rs.getString("fassthgattribute");
                String def = rs.getString("FDEFAULTID");
                String name = rs.getString("fname");
                defaults.put(actTpye, attr + "_!" + name + "_!" + def);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        result.put("defaults", defaults);
        sql.setLength(0);
        if (acc.getCAA() != null) {
            sql.append("SELECT ty.fassthgattribute attr FROM T_BD_AsstActGroupDetail aagdChild   \r\n");
            sql.append("INNER JOIN T_BD_AsstActType ty on aagdChild.FAsstActTypeID = ty.fid    \r\n");
            sql.append("WHERE aagdChild.FAsstAccountID = ? AND aagdChild.FAsstActTypeID \r\n");
            sql.append("IN (SELECT aagdParent.FAsstActTypeID FROM T_BD_AsstActGroupDetail aagdParent WHERE aagdParent.FAsstAccountID = ? )");
            IRowSet comrs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{account.getCAA().getId().toString(), acc.getCAA().getId().toString()});
            ArrayList<String> common = new ArrayList<String>();
            try {
                while (comrs != null && comrs.next()) {
                    String actTpye = comrs.getString("attr");
                    common.add(actTpye);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            result.put("common", common);
        }
        return result;
    }

    private static AssistantHGInfo getTransferHgInfoOld(Context ctx, VoucherInfo voucherInfo, AssistantHGInfo assGrp, AccountViewInfo asstAcct, CompanyOrgUnitInfo company, Map<String, AsstAccountInfo> caas) throws EASBizException, BOSException {
        AsstAccountInfo caa = BookUtil.getFCAA(ctx, asstAcct.getCAA().getId().toString(), caas);
        AssistantHGInfo hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(assGrp.getId()));
        AsstActTypeCollection types = new AsstActTypeCollection();
        boolean assExist = true;
        Vector vec = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(hgInfo.getAsstAccount().getId().toString()));
        ArrayList<String> list = new ArrayList<String>();
        int n = vec.size();
        for (int i = 0; i < n; ++i) {
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)vec.get(i);
            list.add(asstActTypeInfo.getAsstHGAttribute());
            AsstActGroupDetailCollection detailCol = caa.getAsstActGpDt();
            for (int j = 0; j < detailCol.size(); ++j) {
                DataBaseInfo data;
                if (!detailCol.get(j).getAsstActType().getId().toString().equals(asstActTypeInfo.getId().toString())) continue;
                String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
                list.remove(asstHGAttribute);
                types.add(asstActTypeInfo);
                if ("bankAccount".equalsIgnoreCase(asstHGAttribute) || (data = GlUtils.findAsstActObject(ctx, asstActTypeInfo, hgInfo.getObjectValue(asstHGAttribute).getString("id"), company.getCU().getId().toString(), company, false)) != null) continue;
                Object[] params = new Object[]{asstAcct.getNumber(), asstActTypeInfo.getName()};
                ctx.put((Object)"paramKey", (Object)params);
                assExist = false;
            }
        }
        AssistantHGInfo transferHgInfo = null;
        if (assExist) {
            for (int i = 0; i < list.size(); ++i) {
                hgInfo.remove(list.get(i).toString());
            }
            transferHgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(hgInfo, asstAcct.getCAA().getId().toString(), types);
        }
        return transferHgInfo;
    }

    private static boolean checkAccountSchemeRuleNew(Context ctx, String vid, String filter) {
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        boolean result = false;
        queryPK = new MetaDataPK("com.kingdee.eas.fi.gl.app.VoucherEntryQuery");
        EntityViewInfo view = null;
        if (filter != null && !filter.equals("WHERE ")) {
            String oql = "Select id " + filter + " and id ='" + vid + "'";
            try {
                view = new EntityViewInfo(oql);
            }
            catch (Exception e1) {
                logger.warn((Object)"query error:", (Throwable)e1);
            }
        } else {
            result = true;
        }
        if (view != null) {
            queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
            queryExcu.setObjectView(view);
            try {
                IRowSet rows = queryExcu.executeQuery();
                if (rows.size() > 0) {
                    result = true;
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static boolean checkAcountSchemeRule(Context ctx, String vid, String filter) throws BOSException {
        IVoucher vf = VoucherFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = null;
        if (filter != null && !filter.equals("WHERE ")) {
            String oql = "Select id " + filter + " and id ='" + vid + "'";
            try {
                view = new EntityViewInfo(oql);
            }
            catch (Exception e1) {
                logger.warn((Object)"query error:", (Throwable)e1);
            }
        }
        if (view != null) {
            VoucherCollection vous = vf.getVoucherCollection(view);
            return vous != null && vous.size() > 0;
        }
        return true;
    }

    private static String _getTranseAcctCussent(Context ctx, String acctCussentId, String accountschemeid, String companyid, String accountid) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("  select c.fid from t_bks_vouchermessage m   \r\n");
        sql.append("  inner join t_gl_voucherassistrecord srcr on m.fsrcvoucherid = srcr.fbillid \r\n");
        sql.append("  left join t_gl_voucherassistrecord tagr on m.ftagvoucherid = tagr.fbillid and tagr.fseq = srcr.fseq \r\n ");
        sql.append("  left join t_gl_acctcussent c on c.FVchAssistRecordID = tagr.fid \r\n ");
        sql.append("  where m.fsrcvoucherid = ( \r\n ");
        sql.append("  select top 1 m.fsrcvoucherid from t_bks_vouchermessage m \r\n ");
        sql.append("  inner join t_gl_voucherassistrecord srcr on m.fsrcvoucherid = srcr.fbillid \r\n ");
        sql.append("  inner join t_gl_acctcussent c on c.FVchAssistRecordID = srcr.fid where c.fid = ? \r\n ");
        sql.append("  and faccountschemeid = ? \r\n ");
        sql.append("  ) and faccountschemeid = ? \r\n ");
        sql.append(" Union All \r\n");
        sql.append(" select c.fid from t_gl_acctcussent c \r\n");
        sql.append("inner join t_gl_voucherassistrecord as1 on as1.fid = c.fvchassistrecordid \r\n");
        sql.append(" inner join t_gl_acctcussent b on c.FORIGINALAMOUNT = b.FORIGINALAMOUNT and c.fcurrencyid=b.fcurrencyid \r\n");
        sql.append("inner join t_gl_voucherassistrecord as2 on as2.fid = b.fvchassistrecordid and as1.fassgrpid=as2.fassgrpid and  as1.fbizdate = as2.fbizdate  and as1.fenddate = as2.fenddate \r\n");
        sql.append(" where c.faccountid= ?");
        sql.append(" and c.fcompanyid= ? ");
        sql.append(" and b.fid = ? ");
        sql.append(" and c.fisinit = 1");
        sql.append(" and c.FIsInitClosed = 1");
        sql.append(" and as1.FIsVierified = 0 ");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{acctCussentId, accountschemeid, accountschemeid, accountid, companyid, acctCussentId});
        try {
            if (set != null && set.next()) {
                return set.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private static String _getTranseAccount(Context ctx, String accountSql, String accountId, String accountRef, String transferOrgId) throws EASBizException, BOSException {
        if (accountRef != null) {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)accountSql, (Object[])new Object[]{accountId, accountRef});
            try {
                if (set != null && set.next()) {
                    return set.getString(1);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("  select acctnew.fid from t_bd_accountview acctnew   \r\n");
        sql.append("  inner join t_bd_accountview acctold on acctold.fnumber=acctnew.fnumber \r\n");
        sql.append("  inner join t_org_company cp on cp.fid = acctnew.fcompanyid and acctnew.faccounttableid = cp.faccounttableid ");
        sql.append("   where acctold.fid=? and cp.fid=? and acctnew.fisleaf = 1");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{accountId, transferOrgId});
        try {
            if (set != null && set.next()) {
                return set.getString(1);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private static VoucherInfo _getSimpleVoucher(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("period.periodYear"));
        sic.add(new SelectorItemInfo("period.periodNumber"));
        return (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(pk.toString()), sic);
    }

    private static boolean isTransPLVoucher(VoucherInfo voucher) {
        return voucher.getSourceType().getValue() == 1;
    }

    public static String _getAcctRefConstrast(Context ctx, String transferOrg, String mainOrgId, String cuid) throws EASBizException, BOSException {
        String sql = "select FaccountTableid from t_Org_Company  where fid=?  ";
        IRowSet set = null;
        String srcTable = null;
        String objTable = null;
        try {
            set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{mainOrgId});
            if (set != null && set.next()) {
                srcTable = set.getString(1);
            }
            if ((set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{transferOrg})) != null && set.next()) {
                objTable = set.getString(1);
            }
            if ((set = DbUtil.executeQuery((Context)ctx, (String)(sql = " select fid from t_bd_acctrefcontrast where FEnabledAcctTableID=? and FDisabledAcctTableID=? and FIsEnabled=1 and FRefType=2 and fcompanyid=? "), (Object[])new Object[]{objTable, srcTable, cuid})) != null && set.next()) {
                return set.getString(1);
            }
            if (srcTable != null && srcTable.equals(objTable)) {
                return null;
            }
            return "1001";
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void _lazyLoadCashflow(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        CashflowRecordCollection cfCol = null;
        Map map = CashflowRecordFactory.getLocalInstance(ctx).getColAndDifference(voucherInfo.getId().toString());
        cfCol = (CashflowRecordCollection)map.get("CashflowRecordCollection");
        voucherInfo.setCashflowRecords((AbstractObjectCollection)cfCol);
        HashMap<String, VoucherEntryInfo> hmEntry = new HashMap<String, VoucherEntryInfo>();
        HashMap<String, VoucherAssistRecordInfo> hmAssist = new HashMap<String, VoucherAssistRecordInfo>();
        VoucherEntryCollection entries = voucherInfo.getEntries();
        int entryCount = entries.size();
        for (int i = 0; i < entryCount; ++i) {
            VoucherEntryInfo e = entries.get(i);
            BOSUuid entryId = e.getId();
            hmEntry.put(entryId.toString(), e);
            VoucherAssistRecordCollection records = e.getAssistRecords();
            int recordCount = records.size();
            for (int j = 0; j < recordCount; ++j) {
                VoucherAssistRecordInfo r = records.get(j);
                if (r.getId() == null) continue;
                hmAssist.put(r.getId().toString(), r);
            }
        }
        if (voucherInfo.getCashflowRecords() != null) {
            Vector<CashflowRecordInfo> removeHere = new Vector<CashflowRecordInfo>();
            Iterator itrHere = null;
            Iterator itrCf = voucherInfo.getCashflowRecords().iterator();
            VoucherEntryInfo entry = null;
            VoucherEntryInfo oppEntry = null;
            VoucherAssistRecordInfo record = null;
            while (itrCf.hasNext()) {
                CashflowRecordInfo cf = (CashflowRecordInfo)itrCf.next();
                cf.setId(null);
                if (cf.getEntry() == null) {
                    removeHere.add(cf);
                    continue;
                }
                String entryKey = cf.getEntry().getId().toString();
                String oppEntryKey = cf.getOpposingAccountEntry().getId().toString();
                entry = (VoucherEntryInfo)hmEntry.get(entryKey);
                cf.setEntry(entry);
                cf.setAccount(entry.getAccount());
                cf.setCurrency(entry.getCurrency());
                cf.setEntryDC(entry.getEntryDC());
                oppEntry = (VoucherEntryInfo)hmEntry.get(oppEntryKey);
                cf.setOpposingAccountEntry(oppEntry);
                cf.setOppAccount(oppEntry.getAccount());
                cf.setOppEntryDC(oppEntry.getEntryDC());
                cf.setVoucher(voucherInfo);
                if (cf.getOppVoucherAssistRecord() == null || cf.getOppVoucherAssistRecord().getId() == null) continue;
                record = (VoucherAssistRecordInfo)hmAssist.get(cf.getOppVoucherAssistRecord().getId().toString());
                cf.setOppVoucherAssistRecord(record);
                cf.setOppAssGrp(record.getAssGrp());
            }
            itrHere = removeHere.iterator();
            while (itrHere.hasNext()) {
                voucherInfo.setCashflowChanged(true);
                ((CashflowRecordCollection)voucherInfo.getCashflowRecords()).remove((CashflowRecordInfo)itrHere.next());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucher.id", (Object)voucherInfo.getId().toString()));
        CashflowSplitRecordCollection cashflowSplitRecordCollection = CashflowSplitRecordFactory.getLocalInstance(ctx).getCashflowSplitRecordCollection(view);
        voucherInfo.setCashflowSplitRecordCollection((AbstractObjectCollection)cashflowSplitRecordCollection);
        if (voucherInfo.getCashflowSplitRecordCollection() != null) {
            Vector<CashflowSplitRecordInfo> removeHere = new Vector<CashflowSplitRecordInfo>();
            Iterator itrHere = null;
            for (CashflowSplitRecordInfo cr : voucherInfo.getCashflowSplitRecordCollection()) {
                cr.setId(null);
                if (cr.getEntry() == null) {
                    removeHere.add(cr);
                    continue;
                }
                String entryKey = cr.getEntry().getId().toString();
                String oppEntryKey = cr.getOpposingAccountEntry().getId().toString();
                cr.setEntry((VoucherEntryInfo)hmEntry.get(entryKey));
                cr.setOpposingAccountEntry((VoucherEntryInfo)hmEntry.get(oppEntryKey));
                cr.setVoucher(voucherInfo);
                if (cr.getOppVoucherAssistRecord() == null || cr.getOppVoucherAssistRecord().getId() == null) continue;
                cr.setOppVoucherAssistRecord((VoucherAssistRecordInfo)hmAssist.get(cr.getOppVoucherAssistRecord().getId().toString()));
            }
            itrHere = removeHere.iterator();
            while (itrHere.hasNext()) {
                ((CashflowSplitRecordCollection)voucherInfo.getCashflowSplitRecordCollection()).remove((CashflowSplitRecordInfo)itrHere.next());
            }
        }
    }

    private static void _createBotRelation(Context ctx, String srcVchId, String destId, BOSObjectType type) throws BOSException {
        BOTRelationInfo bot = null;
        bot = new BOTRelationInfo();
        bot.setSrcEntityID(type.toString());
        bot.setDestEntityID(type.toString());
        bot.setSrcObjectID(srcVchId);
        bot.setOperatorID(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        bot.setDestObjectID(destId);
        BOTRelationFactory.getLocalInstance((Context)ctx).addnew(bot);
    }

    public static Map _getBookList(Context ctx, String companyid, boolean needFilter) throws EASBizException, BOSException {
        if (needFilter) {
            HashMap bookList = new HashMap();
            String sql = "select b.fid,a.faccountschemeid, a.Ffilter from t_bks_accountrule a\t\t\tinner join t_Org_Company  b on a.fcompanyid=b.fmainorgid and a.faccountschemeid=b.faccountschemeid\t\twhere b.fmainorgid=? and b.FisSealUp=0 and a.fisenable=1";
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyid});
            try {
                while (set != null && set.next()) {
                    ArrayList<String> rule = new ArrayList<String>();
                    rule.add(0, set.getString(2));
                    rule.add(1, set.getString(3));
                    bookList.put(set.getString(1), rule);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            return bookList;
        }
        return BookUtil._getBookList(ctx, companyid);
    }

    public static Map _getBookList(Context ctx, String companyid) throws EASBizException, BOSException {
        HashMap<String, String> bookList = new HashMap<String, String>();
        String sql = "select b.fid,a.faccountschemeid from t_bks_accountrule a\t\t\tinner join t_Org_Company  b on a.fcompanyid=b.fmainorgid and a.faccountschemeid=b.faccountschemeid\t\twhere b.fmainorgid=? and b.FisSealUp=0 and a.fisenable=1";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyid});
        try {
            while (set != null && set.next()) {
                bookList.put(set.getString(1), set.getString(2));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return bookList;
    }

    private static String _changePeriod(Context ctx, VoucherInfo voucherInfo, CompanyOrgUnitInfo mainOrg, CompanyOrgUnitInfo transferOrg) throws BOSException, EASBizException {
        if (mainOrg.getAccountPeriodType().getId().toString().equals(transferOrg.getAccountPeriodType().getId().toString())) {
            return null;
        }
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)voucherInfo.getBookedDate(), (CompanyOrgUnitInfo)transferOrg, (SystemEnum)SystemEnum.GENERALLEDGER);
        if (periodInfo == null) {
            return "6001";
        }
        voucherInfo.setPeriod(periodInfo);
        return null;
    }

    private static boolean _checkPeriodValid(Context ctx, String vchid, String bookid) throws EASBizException, BOSException {
        String sql = "select s.FBeginDate from t_bd_systemstatus a \t\t\tinner join t_bd_systemstatusctrol b on a.fid=b.fsystemstatusid\t\t\t\t\tinner join t_bd_period  s on s.fid=b.fstartperiodid\t\t\t\t\tinner join t_org_company c on c.fid=b.fcompanyid where c.faccountschemeid=?\t";
        java.sql.Date startPeriodBeginDate = null;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bookid});
        try {
            if (set == null || !set.next()) {
                return false;
            }
            startPeriodBeginDate = set.getDate("FBeginDate");
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        sql = "select d.FBookedDate from  t_gl_voucher d  inner join t_bd_period e on e.fid=d.fperiodid  where d.fid=? ";
        set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{vchid});
        try {
            if (set != null && set.next()) {
                java.sql.Date voucherBookedDate = set.getDate("FBookedDate");
                if (startPeriodBeginDate != null && voucherBookedDate != null && startPeriodBeginDate.compareTo(voucherBookedDate) > 0) {
                    return false;
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static void _deleteVoucher(Context ctx, int status, VoucherInfo srcVoucher) throws EASBizException, BOSException {
        boolean isMainVoucherToBooksForMain = Boolean.valueOf((String)GlUtils.getParamByKey(ctx, srcVoucher.getCompany().getId().toString(), "GL016"));
        IGLPeriodEndFacade iGLPeriodEndFacade = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        String sql = "select FAccountSchemeID,Fcompanyid,FTAGVOUCHERID from T_BKS_VoucherMessage where FIsSuc=1 and FSrcVoucherID=? ";
        IRowSet set = null;
        boolean useReport = GlUtils.getDefaultGLParam(ctx, null, "G001");
        String vchId = srcVoucher.getId().toString();
        String bookdId = null;
        String transCompanyId = null;
        String tagVoucherid = null;
        try {
            set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{vchId});
            while (set != null && set.next()) {
                boolean isMainVoucherToBooks = Boolean.valueOf((String)GlUtils.getParamByKey(ctx, set.getString("Fcompanyid"), "GL016"));
                if (!isMainVoucherToBooksForMain && !isMainVoucherToBooks) continue;
                bookdId = set.getString(1);
                transCompanyId = set.getString(2);
                tagVoucherid = set.getString(3);
                boolean isInTimeVerify = GlUtils.getVerifyMode(ctx, transCompanyId) == 0;
                VoucherInfo voucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(tagVoucherid), VoucherInfo.getNumberSelector());
                if (BookUtil._existBotRelation(ctx, tagVoucherid, srcVoucher.getBOSType())) {
                    AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookdId));
                    throw new AccountBooksException(AccountBooksException.HASADJUSTED, new Object[]{book.getName(), voucher.getNumber()});
                }
                if (!isInTimeVerify) {
                    boolean hasVerified = AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).hasVerify(tagVoucherid);
                    if (hasVerified) {
                        AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookdId));
                        throw new AccountBooksException(AccountBooksException.HASADJUSTED, new Object[]{book.getName(), voucher.getNumber()});
                    }
                } else if (VoucherOperateStatusEnum.POST.equals((Object)voucher.getBizStatus())) {
                    StringBuffer checksql = new StringBuffer();
                    checksql.append("select ve.FSeq as FEntrySeq,vast.FSeq as FAsstSeq\t\r\n");
                    checksql.append("from t_gl_VoucherAssistRecord vast,                 \r\n");
                    checksql.append("\tt_gl_VoucherEntry ve,                           \r\n");
                    checksql.append("\tt_GL_AcctCussent cust,                          \r\n");
                    checksql.append("\tt_gl_VoucherAssistRecord vast2 ,                 \r\n");
                    checksql.append("\tt_gl_Voucher v\t                          \r\n");
                    checksql.append("where vast.FEntryID = ve.FID                        \r\n");
                    checksql.append("\tand vast.FID = cust.FVchAssistRecordID          \r\n");
                    checksql.append("\tand vast.FBillID = ?                            \r\n");
                    checksql.append("\tand vast2.FVerifiedCussentID = cust.FID         \r\n");
                    checksql.append("\tand vast2.FBillID = v.FID    and v.fbizstatus<>2 ;");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checksql.toString(), (Object[])new Object[]{tagVoucherid});
                    if (rs.next()) {
                        AcountSchemeInfo book = (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(bookdId));
                        throw new AccountBooksException(AccountBooksException.HASADJUSTED, new Object[]{book.getName(), voucher.getNumber()});
                    }
                }
                CompanyOrgUnitInfo transferOrgInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(transCompanyId));
                CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany((Context)ctx, (CompanyOrgUnitInfo)transferOrgInfo);
                VoucherInfo tagVoucher = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(tagVoucherid));
                if (status == 1 && status == BooksUtil.getTransferStatus((Context)ctx, (String)bookdId, (CompanyOrgUnitInfo)masterCompany)) {
                    iGLPeriodEndFacade.postVoucherOnBook(srcVoucher.getCompany().getCU().getId().toString(), transCompanyId, new String[]{tagVoucherid.toString()}, useReport, 1, true);
                    if (VoucherStatusEnum.POSTED.equals((Object)tagVoucher.getBizStatus())) {
                        iGLPeriodEndFacade.postVoucherOnBook(srcVoucher.getCompany().getCU().getId().toString(), transCompanyId, new String[]{tagVoucherid.toString()}, useReport, 5, true);
                    }
                } else if (status == 0 && status == BooksUtil.getTransferStatus((Context)ctx, (String)bookdId, (CompanyOrgUnitInfo)masterCompany)) {
                    if (VoucherStatusEnum.POSTED.equals((Object)tagVoucher.getBizStatus())) {
                        iGLPeriodEndFacade.postVoucherOnBook(srcVoucher.getCompany().getCU().getId().toString(), transCompanyId, new String[]{tagVoucherid.toString()}, useReport, 5, true);
                    }
                    iGLPeriodEndFacade.postVoucherOnBook(srcVoucher.getCompany().getCU().getId().toString(), transCompanyId, new String[]{tagVoucherid.toString()}, useReport, 1, true);
                }
                if (status != BooksUtil.getTransferStatus((Context)ctx, (String)bookdId, (CompanyOrgUnitInfo)masterCompany)) continue;
                voucher.setId(BOSUuid.read((String)tagVoucherid));
                List beforeListeners = BookUtil.getActionBeforeListeners(ctx, "GL_VoucherDelete");
                if (beforeListeners != null) {
                    for (Object beforeListener : beforeListeners) {
                        ((GLActionListener)beforeListener).actionPerformed(ctx, voucher);
                    }
                }
                VoucherUtil._deleteAllAcctcussent(ctx, voucher);
                VoucherUtil._deleteAllCashflowRecords(ctx, voucher);
                VoucherUtil._deleteAllCashflowSplitRecords(ctx, voucher);
                VoucherUtil._deleteAllAssistRecords(ctx, voucher);
                VoucherUtil._deleteAllEntries(ctx, voucher);
                VoucherUtil._deleteVoucher(ctx, voucher);
                VoucherUtil._removeBotRelation(ctx, vchId, tagVoucherid, voucher.getBOSType());
                BoAttchAssoFactory.getLocalInstance((Context)ctx).deleteAllAssociationsByBoID(tagVoucherid);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("srcVoucher.id", (Object)vchId));
                filter.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)bookdId));
                VoucherMessageFactory.getLocalInstance(ctx).delete(filter);
                List afterListeners = BookUtil.getActionAfterListeners(ctx, "GL_VoucherDelete");
                if (afterListeners == null) continue;
                for (Object afterListener : afterListeners) {
                    ((GLActionListener)afterListener).actionPerformed(ctx, voucher);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean _existBotRelation(Context ctx, String srcVchId, BOSObjectType type) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcVchId));
        filter.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)type.toString()));
        filter.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)type.toString()));
        BOTRelationCollection col = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        return col != null && col.size() > 0;
    }

    public static boolean _checkHasTransfered(Context ctx, String vchid, String bookid) throws EASBizException, BOSException {
        boolean isSQLServer = SQLUtil.isMSSQLSERVER(ctx);
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        StringBuffer sql = new StringBuffer();
        if (cache != null && cache.isMultiThread() && isSQLServer) {
            sql.append("/*dialect*/ ");
        }
        sql.append("select fid from T_BKS_VoucherMessage ");
        if (cache != null && cache.isMultiThread() && isSQLServer) {
            sql.append("with(readpast) ");
        }
        sql.append("where FIsSuc=1 and FSrcVoucherID=? and FAccountSchemeID=? ");
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchid, bookid});
        try {
            if (set != null && set.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private static boolean assitHasMainHg(Context ctx, VoucherInfo voucherInfo, AssistantHGInfo assGrp, AccountViewInfo asstAcct, CompanyOrgUnitInfo company, Map<String, AsstAccountInfo> caas) throws EASBizException, BOSException {
        AsstAccountInfo caa = BookUtil.getFCAA(ctx, asstAcct.getCAA().getId().toString(), caas);
        AssistantHGInfo hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(assGrp.getId()));
        Vector vec = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(hgInfo.getAsstAccount().getId().toString()));
        int n = vec.size();
        for (int i = 0; i < n; ++i) {
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)vec.get(i);
            AsstActGroupDetailCollection detailCol = caa.getAsstActGpDt();
            for (int j = 0; j < detailCol.size(); ++j) {
                DataBaseInfo data;
                String asstHGAttribute;
                if (!detailCol.get(j).getAsstActType().getId().toString().equals(asstActTypeInfo.getId().toString()) || "bankAccount".equalsIgnoreCase(asstHGAttribute = asstActTypeInfo.getAsstHGAttribute()) || (data = GlUtils.findAsstActObject(ctx, asstActTypeInfo, hgInfo.getObjectValue(asstHGAttribute).getString("id"), company.getCU().getId().toString(), company, false)) != null) continue;
                Object[] params = new Object[]{asstAcct.getNumber(), asstActTypeInfo.getName()};
                ctx.put((Object)"paramKey", (Object)params);
                return false;
            }
        }
        return true;
    }

    private static AssistantHGInfo getNewHgInfo(Context ctx, Map resultMap, AssistantHGInfo assGrp, AccountViewInfo asstAcct, AccountViewInfo acc, CompanyOrgUnitInfo company, Map<String, Map<String, Object>> map) throws EASBizException, BOSException {
        int defaultSize;
        Map defaults = (Map)resultMap.get("defaults");
        List common = (List)resultMap.get("common");
        Map<String, Object> hgs = map.get("hgs");
        Map<String, Object> asstActs = map.get("asstActs");
        if (!(defaults != null && defaults.size() != 0 || common != null && common.size() != 0)) {
            Object[] params = new Object[]{asstAcct.getNumber(), asstAcct.getCAA() != null ? asstAcct.getCAA().getName() : ""};
            ctx.put((Object)"paramKey", (Object)params);
            return null;
        }
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        AssistantHGInfo hgInfo = assGrp;
        Vector vec = null;
        String caaId = asstAcct.getCAA().getId().toString();
        if (cache != null) {
            Map AsstActTypeByGroupMap = cache.getAsstActTypeByGroupMap();
            vec = (Vector)AsstActTypeByGroupMap.get(caaId);
            if (vec == null) {
                vec = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(asstAcct.getCAA().getId()));
                AsstActTypeByGroupMap.put(caaId, vec);
            }
        } else {
            vec = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstActTypeByGroup((IObjectPK)new ObjectUuidPK(asstAcct.getCAA().getId()));
        }
        AssistantHGInfo result = new AssistantHGInfo();
        AsstActTypeCollection items = new AsstActTypeCollection();
        boolean isVerify = true;
        int transferAsstSize = vec.size();
        int commonSize = common.size();
        int n = defaultSize = defaults != null ? defaults.size() : 0;
        if (transferAsstSize != commonSize + defaultSize) {
            Object[] params = new Object[]{asstAcct.getNumber(), asstAcct.getCAA() != null ? asstAcct.getCAA().getName() : ""};
            ctx.put((Object)"paramKey", (Object)params);
            return null;
        }
        if (common.size() > 0) {
            block0: for (int i = 0; i < vec.size(); ++i) {
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)vec.get(i);
                for (int j = 0; j < common.size(); ++j) {
                    String dataid;
                    Object dt;
                    String attr = (String)common.get(j);
                    if ("bankAccount".equalsIgnoreCase(attr)) {
                        result.put(attr, (Object)hgInfo.getObjectValue(attr));
                        continue;
                    }
                    if (!asstActTypeInfo.getAsstHGAttribute().equals(attr)) continue;
                    DataBaseInfo data = hgInfo.getId() != null ? ((hgInfo = (AssistantHGInfo)hgs.get(hgInfo.getId().toString())).getObjectValue(attr) != null ? ((dt = asstActs.get(dataid = hgInfo.getObjectValue(attr).getString("id"))) instanceof String ? null : (DataBaseInfo)asstActs.get(dataid)) : null) : null;
                    if (data == null) {
                        isVerify = false;
                        Object[] params = new Object[]{asstAcct.getNumber(), asstActTypeInfo.getName()};
                        ctx.put((Object)"paramKey", (Object)params);
                        return null;
                    }
                    result.put(attr, data);
                    items.add(asstActTypeInfo);
                    continue block0;
                }
            }
        }
        if (defaults.size() > 0) {
            Iterator it = defaults.keySet().iterator();
            IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = (String)defaults.get(key);
                String[] s = value.split("_!");
                BOSUuid bosid = BOSUuid.read((String)s[2]);
                IObjectValue dataInfo = null;
                dataInfo = cache != null ? cache.getDataBaseInfo(ctx, bosid) : iDynamicObject.getValue(bosid.getType(), (IObjectPK)new ObjectUuidPK(bosid));
                AsstActTypeInfo asstActInfo = new AsstActTypeInfo();
                asstActInfo.setAsstHGAttribute(s[0]);
                asstActInfo.setName(s[1]);
                items.add(asstActInfo);
                result.put(s[0], (Object)dataInfo);
            }
        }
        if (acc.getCAA().getId().toString().equals(asstAcct.getCAA().getId().toString()) && isVerify) {
            return (AssistantHGInfo)hgs.get(hgInfo.getId().toString());
        }
        hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHG(result, asstAcct.getCAA().getId().toString(), items);
        return hgInfo;
    }

    private static String genVoucherId(Context ctx, VoucherInfo voucherInfo, int status, CompanyOrgUnitInfo transferOrgInfo, RuleStatus ruleStatus) throws BOSException, EASBizException {
        String comid = transferOrgInfo.getId().toString();
        boolean isAddNoBreakCodingRule = false;
        VoucherInfo vo = new VoucherInfo();
        vo.setBizStatus(VoucherStatusEnum.getEnum((int)status));
        vo.setPeriod(voucherInfo.getPeriod());
        vo.setVoucherType(voucherInfo.getVoucherType());
        isAddNoBreakCodingRule = ruleStatus.isAddNoBreak();
        if (isAddNoBreakCodingRule) {
            return BookUtil.getCodingRuleCtrl(ctx).getNonbreakNumber((IObjectValue)vo, comid, "bizStatus", "");
        }
        return BookUtil.getCodingRuleCtrl(ctx).getNumber((IObjectValue)vo, comid, "bizStatus", "");
    }

    private static ICodingRuleManager getCodingRuleCtrl(Context ctx) throws BOSException {
        return CodingRuleManagerFactory.getLocalInstance((Context)ctx);
    }

    private static AsstAccountInfo getFCAA(Context ctx, String caaId, Map<String, AsstAccountInfo> caas) throws EASBizException, BOSException {
        if (caas.containsKey(caaId)) {
            return caas.get(caaId);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("asstActGpDt.*"));
        selector.add(new SelectorItemInfo("asstActGpDt.asstActType.*"));
        AsstAccountInfo caa = AsstAccountFactory.getLocalInstance((Context)ctx).getAsstAccountInfo((IObjectPK)new ObjectUuidPK(caaId), selector);
        caas.put(caaId, caa);
        return caa;
    }

    private static void checkIsClosInit(Context ctx, String voucherId, String companyId, boolean allowCussent) throws EASBizException, BOSException {
        Map checkMap;
        if (!VoucherUtil.isAccountInited(ctx, companyId)) {
            throw new GLPeriodEndException(GLPeriodEndException.GL_INIT_NOT_CLOSED);
        }
        Map checkAssitInited = VoucherUtil.checkAssitInited(ctx, "'" + voucherId + "'", companyId);
        if (checkAssitInited != null && checkAssitInited.containsKey(voucherId)) {
            String errMsg = ((StringBuffer)checkAssitInited.get(voucherId)).toString();
            throw new GLPeriodEndException(GLPeriodEndException.ASST_INIT_NOT_CLOSED, new String[]{errMsg});
        }
        if (allowCussent && (checkMap = VoucherUtil.checkCussentInited(ctx, "'" + voucherId + "'", companyId)) != null && checkMap.containsKey(voucherId)) {
            String errMsg = ((StringBuffer)checkMap.get(voucherId)).toString();
            throw new GLPeriodEndException(GLPeriodEndException.CUSSENT_INIT_NOT_CLOSED, new String[]{errMsg});
        }
    }

    private static boolean getByBizDate(Context ctx) {
        try {
            Map data = UserSettingUtil.getUserSettingByContext(ctx, "fi.gl.voucher.VoucherEditParamSetting", null);
            Properties props = new Properties();
            if (data.size() == 0) {
                return false;
            }
            for (Object obj : data.keySet()) {
                String key = obj.toString();
                props.setProperty(key, data.get(key).toString());
            }
            if (props.getProperty("byBizDate") != null) {
                return Boolean.valueOf(props.getProperty("byBizDate"));
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

