/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IDeleteVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class DeleteBaseVoucherService
extends AbstractOperateVoucherService
implements IDeleteVoucherService {
    protected IVoucherOprateSharer operateSharer;
    private static Logger logger = Logger.getLogger(DeleteBaseVoucherService.class);
    protected GlParam sysParam = null;
    protected IBaseVoucher iVoucher;

    public DeleteBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public void deleteVoucher(Context ctx, BaseVoucherInfo voucherInfo, boolean isFromGL) throws EASBizException, BOSException {
        String msg;
        ObjectUuidPK voucherPK = null;
        if (voucherInfo.getId() == null) {
            return;
        }
        voucherPK = new ObjectUuidPK(voucherInfo.getId());
        IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"deleteVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)voucherPK, (String)this.getLogDetail(ctx, voucherInfo), (String)this.getLogItemName());
        List beforeListeners = this.getBeforeActionListeners(ctx);
        if (beforeListeners != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        this.operateSharer.lockVoucher(ctx, voucherInfo.getId().toString());
        BaseVoucherInfo sVoucher = this.getStatusVoucher(ctx, new ObjectUuidPK(voucherInfo.getId()));
        if (sVoucher == null) {
            throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
        }
        if (voucherInfo.getSourceType() != SourceType.ACCOUNTADJUST) {
            this.checkStatusAndOperate(sVoucher.getBizStatus(), VoucherOperateStatusEnum.DELETE);
        }
        this.initGlParam(ctx, voucherInfo);
        if (sVoucher.getBizStatus().getValue() == 1 && !StringUtils.isEmpty((String)(msg = VoucherFacadeFactory.getLocalInstance((Context)ctx).checkCFRequisition(sVoucher.getId().toString())))) {
            throw new VoucherException(VoucherException.CHECKREQUISITION, new Object[]{msg});
        }
        this.validate(ctx, voucherInfo, isFromGL);
        this.beforeDelete(ctx, voucherInfo);
        this.recycleVoucherNumber(ctx, voucherInfo);
        this.insertVoucherLog(ctx, sVoucher);
        this.undoTransformFromVoucher(ctx, voucherInfo);
        this.clearWebServiceCache(ctx, voucherInfo);
        this.delete(ctx, voucherInfo, this.sysParam);
        if (isFromGL) {
            this.submitDeleteWorkFlow(ctx, voucherInfo);
        }
        if (!isFromGL) {
            this.clearWebServiceCache(ctx, voucherInfo);
            this.submitDeleteWorkFlow(ctx, voucherInfo);
        }
        this.afterDelete(ctx, voucherInfo);
        this.invokeVoucherDeletePostProcessor(ctx, voucherInfo);
        BillImageFacadeFactory.getLocalInstance((Context)ctx).deleteImage4Buss(voucherInfo.getId().toString(), true, false, true);
        List afterListeners = this.getAfterActionListeners(ctx);
        if (afterListeners != null) {
            for (Object afterListener : afterListeners) {
                ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
            }
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    protected abstract void afterDelete(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException, GLException;

    protected abstract void beforeDelete(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException, GLException;

    @Override
    protected abstract String getLogItemName();

    protected abstract void validate(Context var1, BaseVoucherInfo var2, boolean var3) throws EASBizException, BOSException;

    protected void deleteAutoTransVoucherRef(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        DbUtil.execute((Context)ctx, (String)"delete from t_gl_AutoTransVoucherRef where fvoucherid = ?", (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
        ctx.put((Object)"GL_VOUCHERNUMBER_LOG", (Object)this.sysParam.getBoolean("GL_VOUCHERNUMBER_LOG"));
    }

    protected void returnBudget(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        VoucherUtil.returnBudgetSubstract(ctx, voucherInfo);
    }

    protected abstract void recycleVoucherNumber(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    protected abstract void delete(Context var1, BaseVoucherInfo var2, GlParam var3) throws EASBizException, BOSException;

    private void submitDeleteWorkFlow(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.iVoucher.deleteFun((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()));
    }

    protected abstract void undoTransformFromVoucher(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    private void clearWebServiceCache(Context ctx, BaseVoucherInfo voucherInfo) {
        GlWebServiceUtil.setWsObjectKeyMap(ctx, voucherInfo.getCompany().getNumber(), "voucher", voucherInfo.getDescription());
    }

    protected abstract void insertVoucherLog(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    protected abstract void invokeVoucherDeletePostProcessor(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "IDeleteVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"G003", "GL_009", "GL_019", "GLG01", "GL_028", "GL_052", "GLG02", "GL_060", "GL015", "GL_VOUCHERNUMBER_LOG", "GL_104", "GL_013", "GL_073"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    protected void deleteAdjustExchangeRateHistory(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        if (SourceType.PERIOD_END_EXCHANGERATE_ADJUSTMENT.equals((Object)voucherInfo.getSourceType())) {
            String sql = "delete  from T_GL_adjexchratehistory where FVoucherID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
            sql = "delete  from T_GL_AdjRateVoucherRef where FVoucherID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    protected void deleteTransPLHistory(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException {
        if (SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType())) {
            String sql = "delete  from T_GL_TransPlProgramVoucher where FVoucherID = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }
}

