/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.WebVoucherTransfer;
import com.kingdee.eas.fi.gl.app.voucher.ISaveVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import org.apache.log4j.Logger;

public abstract class PreViewBaseVoucherService
implements ISaveVoucherService {
    protected static final Logger logger = Logger.getLogger(PreViewBaseVoucherService.class);
    protected GlParam sysParam = null;
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;

    public PreViewBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    protected abstract IBaseVoucher getIBaseVoucher(Context var1) throws BOSException;

    @Override
    public IObjectPK save(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getCU() == null) {
            voucherInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.initGlParam(ctx, voucherInfo);
        this.loadProperties(ctx, voucherInfo);
        IObjectPK voucherPK = null;
        try {
            voucherInfo.setNumber("");
            voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
            this.dealSaveCashflow(ctx, voucherPK, voucherInfo);
            voucherInfo.putAll((IObjectValue)new WebVoucherTransfer(ctx, (VoucherInfo)voucherInfo).transfer());
        }
        catch (Exception e) {
            this.operateSharer.recycleNumberWhenFail(ctx, voucherInfo, e);
        }
        return null;
    }

    protected String getLogItemName() {
        return "gl_voucher_save";
    }

    protected abstract void validate(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected abstract void loadProperties(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected abstract boolean exist(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    private void versionCheck(BaseVoucherInfo voucherInfo) throws BOSException, EASBizException, VoucherException {
        if (!voucherInfo.isNotChanged()) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            BaseVoucherInfo vch = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId().toString()), sic);
            if (!vch.getLastUpdateTime().equals(voucherInfo.getLastUpdateTime())) {
                throw new VoucherException(VoucherException.EDIT_CONFLICT);
            }
        }
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "ISaveVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"G001", "GL_002", "GL_008", "GL_003", "GLG01", "GL_031", "G010", "GL_VOUCHERNUMBER_LOG", "GL_0301", "GL_100"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private void handleSaveVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException, VoucherException {
        block8: {
            boolean isHandNumber;
            block7: {
                isHandNumber = this.sysParam.getBoolean("GL_031");
                if (!isHandNumber || voucherInfo.getNumber() == null) break block7;
                if (!this.numberValid(ctx, voucherInfo, isHandNumber)) {
                    throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
                }
                if (!this.exist(ctx, voucherInfo) || !this.existCodingRule(ctx, voucherInfo)) break block8;
                String oldNumber = voucherInfo.getNumber();
                BaseVoucherInfo previousVoucher = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), BaseVoucherInfo.getNumberSelector());
                if (previousVoucher.getNumber() != null && !oldNumber.equals(previousVoucher.getNumber())) {
                    this.operateSharer.recycleVoucherId(ctx, voucherInfo, previousVoucher.getNumber());
                }
                break block8;
            }
            if (voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0 || !isHandNumber) {
                if (this.exist(ctx, voucherInfo) || voucherInfo.getSourceType() == SourceType.OTHER_IMPORT && voucherInfo.getNumber() != null) {
                    this.operateSharer.managerVoucherId(ctx, voucherInfo, voucherInfo.getBizStatus());
                    for (int count = 1; !this.numberValid(ctx, voucherInfo, isHandNumber) && count < 1000; ++count) {
                        voucherInfo.setNumber(null);
                        this.operateSharer.managerVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP);
                    }
                } else {
                    voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP));
                    for (int count = 1; !this.numberValid(ctx, voucherInfo, isHandNumber) && count < 1000; ++count) {
                        voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP));
                    }
                }
            }
        }
    }

    protected abstract boolean existCodingRule(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    protected abstract boolean numberValid(Context var1, BaseVoucherInfo var2, boolean var3) throws EASBizException, BOSException;

    protected abstract IVoucherPersistence getVoucherPersistence() throws BOSException;

    protected void clearCashflow(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getId() == null) {
            return;
        }
        if (!voucherInfo.getCashflowFetched() && voucherInfo.getCashflowRecords().size() == 0) {
            return;
        }
        String sql = "delete from t_gl_cashflowrecord where fvoucherid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    protected abstract void dealSaveCashflow(Context var1, IObjectPK var2, BaseVoucherInfo var3) throws BOSException, EASBizException;
}

