/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherHelpFacadeControllerBean;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractOperateVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ISaveVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class SaveBaseVoucherService
extends AbstractOperateVoucherService
implements ISaveVoucherService {
    protected static final Logger logger = Logger.getLogger(SaveBaseVoucherService.class);
    protected GlParam sysParam = null;
    protected IVoucherOprateSharer operateSharer;
    protected IBaseVoucher iVoucher;

    public SaveBaseVoucherService(Context ctx) throws BOSException {
        this.operateSharer = this.getOperateSharer(ctx);
        this.iVoucher = this.getIBaseVoucher(ctx);
    }

    protected abstract IVoucherOprateSharer getOperateSharer(Context var1) throws BOSException;

    @Override
    public IObjectPK save(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        List beforeListeners;
        if (voucherInfo.getCU() == null) {
            voucherInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        this.initGlParam(ctx, voucherInfo);
        ObjectUuidPK voucherPK = null;
        if (voucherInfo.getId() != null) {
            voucherPK = new ObjectUuidPK(voucherInfo.getId());
        }
        IObjectPK logPK = null;
        if (!"WebService".equals(voucherInfo.getString("entrance")) || this.sysParam.getBoolean("GL_VchImp_LogApp")) {
            logPK = LogUtil.beginLog((Context)ctx, (String)"saveVoucher", (BOSObjectType)voucherInfo.getBOSType(), (IObjectPK)voucherPK, (String)this.getLogDetail(ctx, voucherInfo), (String)this.getLogItemName());
        }
        if ((beforeListeners = this.getBeforeActionListeners(ctx)) != null) {
            for (Object beforeListener : beforeListeners) {
                ((GLActionListener)beforeListener).actionPerformed(ctx, voucherInfo);
            }
        }
        if (voucherInfo.getId() != null) {
            this.operateSharer.lockVoucher(ctx, voucherInfo.getId().toString());
            BaseVoucherInfo sVoucher = this.getStatusVoucher(ctx, new ObjectUuidPK(voucherInfo.getId()));
            if (sVoucher != null) {
                this.versionCheck(ctx, voucherInfo, sVoucher);
                this.checkStatusAndOperate(sVoucher.getBizStatus(), VoucherOperateStatusEnum.TEMP);
            } else if (voucherInfo.getLastUpdateTime() != null) {
                throw new VoucherException(VoucherException.VOUCHER_NOT_EXIST);
            }
        }
        this.loadProperties(ctx, voucherInfo);
        this.validate(ctx, voucherInfo);
        try {
            List afterListeners;
            this.handleSaveVoucherNumber(ctx, voucherInfo);
            voucherInfo.setBizStatus(VoucherStatusEnum.TEMP);
            this.operateSharer.loadCashflowRecord(ctx, voucherInfo);
            this.clearCashflow(ctx, voucherInfo);
            voucherPK = this.getVoucherPersistence().persistVoucher(ctx, voucherInfo);
            if (voucherInfo instanceof VoucherInfo) {
                VoucherCollection col = new VoucherCollection();
                col.add((VoucherInfo)voucherInfo);
                VoucherHelpFacadeControllerBean.botpRewriteStatic(ctx, col);
            }
            this.dealSaveCashflow(ctx, (IObjectPK)voucherPK, voucherInfo);
            this.saveDiffItemRecord(ctx, (IObjectPK)voucherPK, voucherInfo);
            String srcVchId = voucherInfo.getSourceBillId();
            if (srcVchId != null && (voucherInfo.isIsReverseVoucher() || SourceType.ADJUST.equals((Object)voucherInfo.getSourceType()))) {
                VoucherUtil.saveBOTRelationInfo(ctx, srcVchId, (IObjectPK)voucherPK, voucherInfo.getBOSType());
            }
            if ((afterListeners = this.getAfterActionListeners(ctx)) != null) {
                for (Object afterListener : afterListeners) {
                    ((GLActionListener)afterListener).actionPerformed(ctx, voucherInfo);
                }
            }
            this.afterLog(ctx, logPK, (IObjectPK)voucherPK, this.getLogDetail(ctx, voucherInfo));
        }
        catch (Exception e) {
            this.operateSharer.recycleNumberWhenFail(ctx, voucherInfo, e);
        }
        return voucherPK;
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_save";
    }

    protected abstract void validate(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected abstract void loadProperties(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    protected abstract boolean exist(Context var1, BaseVoucherInfo var2) throws BOSException, EASBizException;

    private void versionCheck(Context ctx, BaseVoucherInfo voucherInfo, BaseVoucherInfo vch) throws BOSException, EASBizException, VoucherException {
        String loginType;
        Object loginTypeCtx = ctx.get((Object)"LOGIN_TYPE");
        if (loginTypeCtx != null && ("WEBSERVICE".equals(loginType = loginTypeCtx.toString()) || "OPENAPI".equals(loginType))) {
            return;
        }
        if (!vch.getLastUpdateTime().equals(voucherInfo.getLastUpdateTime())) {
            throw new VoucherException(VoucherException.EDIT_CONFLICT);
        }
    }

    protected void initGlParam(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException {
        this.sysParam = this.getGlParam(ctx, voucherInfo.getCompany().getId().toString());
    }

    protected GlParam getGlParam(Context ctx, String companyid) throws EASBizException, BOSException {
        String cacheKey = companyid + "ISaveVoucherService";
        VoucherProcessCache cache = VoucherProcessCache.getCache(ctx);
        if (cache != null && cache.getSysParams().get(cacheKey) != null && cache.getSysParams().get(cacheKey) instanceof GlParam) {
            return (GlParam)cache.getSysParams().get(cacheKey);
        }
        String[] paramList = new String[]{"G001", "GL_002", "GL_008", "GL_003", "GLG01", "GL_031", "G010", "GL_VOUCHERNUMBER_LOG", "GL_0301", "GL_100", "GL_VchImp_LogApp", "GL_058", "GL_122"};
        GlParam glParam = GlParam.getGlParams((Context)ctx, (String[])paramList, (String)companyid);
        if (cache != null) {
            cache.getSysParams().put(cacheKey, glParam);
        }
        return glParam;
    }

    private void handleSaveVoucherNumber(Context ctx, BaseVoucherInfo voucherInfo) throws EASBizException, BOSException, VoucherException {
        BaseVoucherInfo previousVoucher;
        boolean isHandNumber = this.sysParam.getBoolean("GL_031");
        String OPRT_STATE_KEY = "oprtState";
        String oprtState = (String)voucherInfo.get("oprtState");
        if (voucherInfo.containsKey("oprtState")) {
            voucherInfo.remove("oprtState");
        }
        if (isHandNumber && voucherInfo.getNumber() != null) {
            if (!this.numberValid(ctx, voucherInfo, isHandNumber)) {
                throw new VoucherException(VoucherException.VOUCHERNUMBERREPEAT);
            }
            if (this.exist(ctx, voucherInfo) && this.existCodingRule(ctx, voucherInfo)) {
                String oldNumber = voucherInfo.getNumber();
                BaseVoucherInfo previousVoucher2 = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()), BaseVoucherInfo.getNumberSelector());
                if (previousVoucher2.getNumber() != null && !oldNumber.equals(previousVoucher2.getNumber())) {
                    this.operateSharer.recycleVoucherId(ctx, voucherInfo, previousVoucher2.getNumber());
                }
            }
        } else if (voucherInfo.getNumber() == null || voucherInfo.getNumber().trim().length() == 0) {
            if (!isHandNumber) {
                if (this.exist(ctx, voucherInfo) || voucherInfo.getSourceType() == SourceType.OTHER_IMPORT && voucherInfo.getNumber() != null) {
                    this.operateSharer.managerVoucherId(ctx, voucherInfo, voucherInfo.getBizStatus());
                    for (int count = 1; !this.numberValid(ctx, voucherInfo, isHandNumber) && count < 1000; ++count) {
                        voucherInfo.setNumber(null);
                        this.operateSharer.managerVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP);
                    }
                } else {
                    voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP));
                    for (int count = 1; !this.numberValid(ctx, voucherInfo, isHandNumber) && count < 1000; ++count) {
                        voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP));
                    }
                }
            } else if (this.existCodingRule(ctx, voucherInfo)) {
                voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP));
                for (int count = 1; !this.numberValid(ctx, voucherInfo, isHandNumber) && count < 1000; ++count) {
                    voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP));
                }
            }
        } else if ("ADDNEW".equals(oprtState) || "COPYADDNEW".equals(oprtState)) {
            voucherInfo.setNumber(this.operateSharer.genVoucherId(ctx, voucherInfo, VoucherStatusEnum.TEMP));
        } else if (VoucherStatusEnum.TEMP == voucherInfo.getBizStatus() && !isHandNumber && null != voucherInfo.getId() && this.iVoucher.exists((IObjectPK)new ObjectUuidPK(voucherInfo.getId())) && null != (previousVoucher = (BaseVoucherInfo)this.iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()))) && null != previousVoucher.getPeriod() && null != voucherInfo.getPeriod()) {
            boolean periodChange;
            boolean bl = periodChange = !voucherInfo.getPeriod().toString().equals(previousVoucher.getPeriod().toString());
            if (periodChange) {
                String oldNumber = voucherInfo.getNumber();
                this.operateSharer.managerVoucherId(ctx, voucherInfo, voucherInfo.getBizStatus());
                if (!oldNumber.equals(voucherInfo.getNumber())) {
                    VoucherCollection col = new VoucherCollection();
                    col.add((VoucherInfo)voucherInfo);
                    VoucherHelpFacadeControllerBean.botpRewriteStatic(ctx, col);
                }
            }
        }
    }

    protected abstract boolean existCodingRule(Context var1, BaseVoucherInfo var2) throws EASBizException, BOSException;

    protected abstract boolean numberValid(Context var1, BaseVoucherInfo var2, boolean var3) throws EASBizException, BOSException;

    protected abstract IVoucherPersistence getVoucherPersistence() throws BOSException;

    protected void clearCashflow(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getId() == null) {
            return;
        }
        if (!voucherInfo.getCashflowFetched() && voucherInfo.getCashflowRecords().size() == 0) {
            return;
        }
        String sql = "delete from t_gl_cashflowrecord where fvoucherid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    protected abstract void dealSaveCashflow(Context var1, IObjectPK var2, BaseVoucherInfo var3) throws BOSException, EASBizException;

    protected void saveDiffItemRecord(Context ctx, IObjectPK voucherPK, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
    }
}

