/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.DiffItemRecordCollection;
import com.kingdee.eas.fi.gl.DiffItemRecordFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.GLActionListener;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.fi.gl.app.voucher.SaveBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherPersistence;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.validator.VoucherBaseSaveValidator;
import com.kingdee.eas.fi.gl.validator.VoucherEntrySaveValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidator;
import com.kingdee.eas.fi.gl.validator.VoucherValidatorFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SaveVoucherService
extends SaveBaseVoucherService {
    public SaveVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IVoucherPersistence getVoucherPersistence() throws BOSException {
        return new VoucherPersistence(this.sysParam);
    }

    @Override
    protected boolean exist(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return GlUtils.isExisted(ctx, (VoucherInfo)voucherInfo);
    }

    @Override
    protected boolean numberValid(Context ctx, BaseVoucherInfo voucherInfo, boolean isHandNumber) throws EASBizException, BOSException {
        return GlUtils.chechNumberValid((VoucherInfo)voucherInfo, VoucherStatusEnum.TEMP, ctx, isHandNumber);
    }

    @Override
    protected boolean existCodingRule(Context ctx, BaseVoucherInfo baseVoucherInfo) throws EASBizException, BOSException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        return VoucherUtil.isExistVoucherCodingRule(ctx, voucherInfo.getCompany().getId().toString(), voucherInfo, voucherInfo.getBizStatus());
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }

    @Override
    protected void loadProperties(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherInfo vchInfo = (VoucherInfo)voucherInfo;
        if (!vchInfo.isPostedByUI()) {
            VoucherUtil.lazyLoad(ctx, vchInfo, BaseVoucherInfo.getDefaultSelector(), this.sysParam, false);
        } else {
            GlUtils.setVoucherCategory(vchInfo);
            VoucherUtil.computeVoucherAttribute(vchInfo, this.sysParam, false, false, ctx);
        }
    }

    @Override
    protected void validate(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        VoucherInfo old;
        VoucherValidator vaildator = this.getValidator();
        if (vaildator != null) {
            VoucherValidatorFactory.getVoucherValidator(ctx, this.getClass().getName(), vaildator);
            vaildator.validate(ctx, (VoucherInfo)voucherInfo);
        }
        if (SourceType.AUTO_AMORTIZE.equals((Object)voucherInfo.getSourceType()) && this.exist(ctx, voucherInfo) && ((old = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(voucherInfo.getId()))).getLocalCreditAmount().compareTo(voucherInfo.getLocalCreditAmount()) != 0 || old.getLocalDebitAmount().compareTo(voucherInfo.getLocalDebitAmount()) != 0)) {
            throw new VoucherException(VoucherException.AMORTZIEVOUCHERAMOUNTFIXED);
        }
    }

    protected VoucherValidator getValidator() throws BOSException {
        VoucherValidator validator = new VoucherValidator();
        validator.addVoucherBaseValidator(new VoucherBaseSaveValidator(this.sysParam));
        validator.addVoucherEntryValidator(new VoucherEntrySaveValidator(this.sysParam));
        return validator;
    }

    @Override
    protected void dealSaveCashflow(Context ctx, IObjectPK voucherPK, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        if (voucherInfo.getSourceType() == SourceType.ACCOUNTADJUST) {
            return;
        }
        CashflowRecordCollection cashflowRecordColl = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
        if (cashflowRecordColl == null || cashflowRecordColl.size() == 0) {
            return;
        }
        VoucherEntryCollection entryColl = (VoucherEntryCollection)voucherInfo.getEntries();
        if (entryColl == null) {
            return;
        }
        HashMap<BOSUuid, VoucherEntryInfo> voucherEntryMap = new HashMap<BOSUuid, VoucherEntryInfo>();
        Iterator itEntry = entryColl.iterator();
        HashMap<Integer, VoucherEntryInfo> voucherSeqEntryMap = new HashMap<Integer, VoucherEntryInfo>();
        VoucherEntryInfo voucherEntryInfo = null;
        while (itEntry.hasNext()) {
            voucherEntryInfo = (VoucherEntryInfo)itEntry.next();
            voucherEntryMap.put(voucherEntryInfo.getId(), voucherEntryInfo);
            voucherSeqEntryMap.put(voucherEntryInfo.getSeq(), voucherEntryInfo);
        }
        Iterator iteratorCF = cashflowRecordColl.iterator();
        boolean hasPrimaryRecord = false;
        int seqNumber = 0;
        int oopSeqNumber = 0;
        while (iteratorCF.hasNext()) {
            VoucherEntryInfo entry;
            CashflowRecordInfo cashflowRecordInfo = (CashflowRecordInfo)iteratorCF.next();
            if (cashflowRecordInfo.getEntry() != null && cashflowRecordInfo.getEntry().getId() == null && (entry = (VoucherEntryInfo)voucherSeqEntryMap.get(cashflowRecordInfo.getEntry().getSeq())) != null) {
                cashflowRecordInfo.getEntry().setId(entry.getId());
            }
            if (cashflowRecordInfo.getOpposingAccountEntry() != null && cashflowRecordInfo.getOpposingAccountEntry().getId() == null && (entry = (VoucherEntryInfo)voucherSeqEntryMap.get(cashflowRecordInfo.getOpposingAccountEntry().getSeq())) != null) {
                cashflowRecordInfo.getOpposingAccountEntry().setId(entry.getId());
            }
            if (null != cashflowRecordInfo.get("seqnumber") && null != entryColl.get((seqNumber = Integer.parseInt((String)cashflowRecordInfo.get("seqnumber"))) - 1) && cashflowRecordInfo.getEntry() != null) {
                cashflowRecordInfo.getEntry().setId(entryColl.get(seqNumber - 1).getId());
            }
            if (null != cashflowRecordInfo.get("oppseqnumber") && null != entryColl.get((oopSeqNumber = Integer.parseInt((String)cashflowRecordInfo.get("oppseqnumber"))) - 1) && cashflowRecordInfo.getOpposingAccountEntry() != null) {
                cashflowRecordInfo.getOpposingAccountEntry().setId(entryColl.get(oopSeqNumber - 1).getId());
            }
            if (cashflowRecordInfo.getEntry() == null || cashflowRecordInfo.getOpposingAccountEntry() == null || cashflowRecordInfo.getEntry().getId() == null || cashflowRecordInfo.getOpposingAccountEntry().getId() == null) {
                iteratorCF.remove();
                continue;
            }
            if (!voucherEntryMap.containsKey(cashflowRecordInfo.getEntry().getId()) || !voucherEntryMap.containsKey(cashflowRecordInfo.getOpposingAccountEntry().getId())) {
                iteratorCF.remove();
                continue;
            }
            if (hasPrimaryRecord || cashflowRecordInfo.getItemFlag() != ItemFlag.PRIMARY && cashflowRecordInfo.getItemFlag() != ItemFlag.BOTH) continue;
            hasPrimaryRecord = true;
        }
        Map allDif = VoucherProcessCache.getDifference(ctx, voucherInfo.getCompany().getId().toString());
        HashMap<String, String> acctDif = new HashMap<String, String>();
        CashFlowAccountDiffCollection acctDifCol = (CashFlowAccountDiffCollection)allDif.get("CashFlowAccountDiffCollection");
        if (acctDifCol != null) {
            int size = acctDifCol.size();
            for (int i = 0; i < size; ++i) {
                acctDif.put(acctDifCol.get(i).getDiffAccount().getId().toString(), "");
            }
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO iCashflowRecord = ORMappingDAO.getInstance((BOSObjectType)new CashflowRecordInfo().getBOSType(), (Context)ctx, (Connection)conn);
            for (CashflowRecordInfo r : cashflowRecordColl) {
                if (hasPrimaryRecord && CashFlowUtils.isPL(r.getEntry().getAccount(), acctDif)) {
                    r.setIsSupItem(true);
                } else {
                    r.setIsSupItem(false);
                }
                r.setVoucher((VoucherInfo)voucherInfo);
                r.setId(null);
                iCashflowRecord.addNewBatch((IObjectValue)r);
            }
            iCashflowRecord.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected void saveDiffItemRecord(Context ctx, IObjectPK voucherPK, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        DiffItemRecordCollection diRecords = (DiffItemRecordCollection)((Object)voucherInfo.get("diRecords"));
        if (diRecords != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("voucher.id", (Object)voucherPK.toString()));
            DiffItemRecordFactory.getLocalInstance(ctx).delete(filter);
            CoreBaseCollection coll = new CoreBaseCollection();
            Iterator it = diRecords.iterator();
            while (it.hasNext()) {
                coll.add((CoreBaseInfo)it.next());
            }
            if (coll.size() > 0) {
                DiffItemRecordFactory.getLocalInstance(ctx).addnew(coll);
            }
        }
    }

    @Override
    protected List getBeforeActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherSave", "Before");
    }

    @Override
    protected List getAfterActionListeners(Context ctx) throws BOSException {
        return GLActionListener.getListeners(ctx, "GL_VoucherSave", "After");
    }
}

