/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IBaseVoucher;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherNumberOperator;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractSubmitBaseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherOprateSharer;
import com.kingdee.eas.fi.gl.app.voucher.VoucherPersistence;
import org.apache.log4j.Logger;

public class SubmitAccountComparisonVoucherService
extends AbstractSubmitBaseVoucherService {
    protected static final Logger logger = Logger.getLogger(SubmitAccountComparisonVoucherService.class);

    public SubmitAccountComparisonVoucherService(Context ctx) throws BOSException {
        super(ctx);
    }

    @Override
    protected IObjectPK submit(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        this.setCashflowFlag(voucherInfo);
        this.loadVoucherAttribute(ctx, voucherInfo, this.sysParam, false, true);
        this.setVoucherNumber(ctx, voucherInfo);
        this.setVoucherVerifyFlag(voucherInfo);
        voucherInfo.setBizStatus(VoucherStatusEnum.SUBMITTED);
        IObjectPK voucherPK = this.getVoucherPersistence(this.sysParam).persistVoucher(ctx, (BaseVoucherInfo)voucherInfo);
        return voucherPK;
    }

    @Override
    protected String getLogItemName() {
        return "gl_voucher_submit";
    }

    private void setCashflowFlag(VoucherInfo voucherInfo) {
        voucherInfo.setCashflowFlag(CashflowFlag.NONE);
    }

    private void loadVoucherAttribute(Context ctx, VoucherInfo voucherInfo, GlParam sysParam, boolean removeZeroRow, boolean isCheckAsstAcctAmt) throws EASBizException, BOSException {
        VoucherUtil.computeVoucherAttribute(voucherInfo, sysParam, false, true, ctx);
    }

    private void setVoucherNumber(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        int count;
        this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
        VoucherNumberOperator numberOperator = VoucherNumberOperator.build(ctx);
        int MAX_GET_COUNT = numberOperator.getNumberMaxCount((BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
        for (count = 1; !GlUtils.chechNumberValid(voucherInfo, VoucherStatusEnum.SUBMITTED, ctx, false) && count < MAX_GET_COUNT; ++count) {
            voucherInfo.setNumber(null);
            this.operateSharer.managerVoucherId(ctx, (BaseVoucherInfo)voucherInfo, VoucherStatusEnum.SUBMITTED);
        }
        if (count >= MAX_GET_COUNT) {
            throw new VoucherException(VoucherException.CODING_RULE_SN_OUT);
        }
    }

    private void setVoucherVerifyFlag(VoucherInfo voucherInfo) {
        VoucherEntryCollection entries = voucherInfo.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            VoucherEntryInfo voucherEntryInfo = entries.get(i);
            voucherEntryInfo.setIsVerify(false);
        }
    }

    protected VoucherPersistence getVoucherPersistence(GlParam sysParam) throws BOSException {
        return new VoucherPersistence(sysParam);
    }

    @Override
    protected boolean exist(Context ctx, BaseVoucherInfo voucherInfo) throws BOSException, EASBizException {
        return GlUtils.isExisted(ctx, (VoucherInfo)voucherInfo);
    }

    @Override
    protected IBaseVoucher getIBaseVoucher(Context ctx) throws BOSException {
        return VoucherFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected IVoucherOprateSharer getOperateSharer(Context ctx) throws BOSException {
        return new VoucherOprateSharer(ctx);
    }
}

