/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AbstractTransactVoucherColService;
import com.kingdee.eas.fi.gl.app.voucher.TransactVoucherColParameter;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class SubmitVoucherCollectionService
extends AbstractTransactVoucherColService {
    @Override
    protected void processThreadParam(Map params) {
        String str;
        super.processThreadParam(params);
        this.multiThread = false;
        if (params.get("GL_VchSubmit_MultiThread") != null && "true".equals(str = params.get("GL_VchSubmit_MultiThread").toString())) {
            this.multiThread = true;
        }
    }

    @Override
    protected void beforeTransactVoucherNewTrans(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
    }

    @Override
    protected void catchTransactException(Context ctx, VoucherInfo voucherInfo, String oldNumber, Exception ex) {
        String oldVchType = voucherInfo.getVoucherType() == null ? "" : (voucherInfo.getVoucherType().getName() == null ? "" : voucherInfo.getVoucherType().getName());
        String submitFail = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLRes", (String)"SUBMIT_FAIL", (Locale)ctx.getLocale()), oldVchType + oldNumber, !(ex instanceof EASBizException) ? ex.getMessage().split("\n")[0] : ex.getMessage());
        this.commonErrors.put(voucherInfo.getId().toString(), submitFail);
    }

    @Override
    protected VoucherCollection queryHasDataPermVoucherCollection(Context ctx, String queryPermissionSql, IVoucher ivoucher, EntityViewInfo view) throws BOSException, EASBizException {
        VoucherCollection vchColl = super.queryHasDataPermVoucherCollection(ctx, queryPermissionSql, ivoucher, view);
        if (vchColl.isEmpty()) {
            return null;
        }
        Iterator it = vchColl.iterator();
        HashSet<String> voucherIds = new HashSet<String>();
        while (it.hasNext()) {
            VoucherInfo voucher = (VoucherInfo)it.next();
            voucher.setCashflowFetched(true);
            voucherIds.add(voucher.getId().toString());
        }
        CashflowRecordCollection records = this.getCashflowRecordCollection(ctx, voucherIds);
        this.joinCashflowRecords(vchColl, records);
        return vchColl;
    }

    protected CashflowRecordCollection getCashflowRecordCollection(Context ctx, Set voucherIds) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getDefaultSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("voucher.id"));
        sorters.add(new SorterItemInfo("seq"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("voucher.id", (Object)voucherIds, CompareType.INCLUDE));
        return CashflowRecordFactory.getLocalInstance(ctx).getCashflowRecordCollection(view);
    }

    protected void joinCashflowRecords(VoucherCollection vchColl, CashflowRecordCollection records) {
        if (records == null) {
            return;
        }
        Iterator it = records.iterator();
        VoucherInfo voucher = null;
        BOSUuid lastVoucherId = null;
        while (it.hasNext()) {
            CashflowRecordInfo cf = (CashflowRecordInfo)it.next();
            if (!cf.getVoucher().getId().equals(lastVoucherId)) {
                voucher = vchColl.get((Object)cf.getVoucher().getId());
                voucher.setCashflowRecords((AbstractObjectCollection)new CashflowRecordCollection());
                lastVoucherId = cf.getVoucher().getId();
            }
            ((CashflowRecordCollection)voucher.getCashflowRecords()).add(cf);
        }
    }

    @Override
    protected EntityViewInfo getEntityView(Set idSet) {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(VoucherInfo.getDefaultSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return view;
    }

    @Override
    protected String getPermItemName() {
        return "gl_voucher02_edit";
    }

    @Override
    protected void machiningVoucherCollection(Context ctx, Set idSet, VoucherCollection voucherCollection) throws BOSException, EASBizException {
        for (int i = voucherCollection.size() - 1; i >= 0; --i) {
            VoucherInfo voucherInfo = voucherCollection.get(i);
            if (!VoucherStatusEnum.TEMP.equals((Object)voucherInfo.getBizStatus())) continue;
            voucherInfo.setFromSaveSubmit(true);
        }
        VoucherUtil.getAccountUserProperty(ctx, voucherCollection);
    }

    @Override
    protected void transactVoucherNewTrans(Context ctx, TransactVoucherColParameter parameterObject, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        this.getVoucherServiceFacade(ctx).submitVoucherNewTrans((IObjectPK)new ObjectUuidPK(voucherInfo.getId()));
    }

    @Override
    protected VoucherException getVoucherException(String errMsg) {
        return new VoucherException(VoucherException.SUBMIT_FAIL, new Object[]{errMsg});
    }

    @Override
    public String getMutexActionResName() {
        return "GL_VoucherSubmit";
    }
}

