/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFacadeFactory;
import com.kingdee.eas.fi.gl.AcctCussentHistoryFactory;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.CFRequisitionFactory;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordFactory;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IAcctCussentHistory;
import com.kingdee.eas.fi.gl.ICashflowSplitRecord;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCategoryEnum;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fi.gl.app.ITAccountSplitStrategy;
import com.kingdee.eas.fi.gl.app.TAccountSplitStrategyFactory;
import com.kingdee.eas.fi.gl.app.voucher.VoucherSubmitCashFlowAuto;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SubmitVoucherServiceHelper {
    protected static final Logger logger = Logger.getLogger(SubmitVoucherServiceHelper.class);

    public void dealAcctCussent(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        if (SourceType.ASST_ACCOUNT_CHANGE.equals((Object)voucherInfo.getSourceType())) {
            return;
        }
        int virifyMode = sysParam.getInt("GL_052");
        boolean isInTimeVerify = virifyMode == 0;
        CompanyOrgUnitInfo company = voucherInfo.getCompany();
        if (!isInTimeVerify) {
            IAcctCussentHistory factory = AcctCussentHistoryFactory.getLocalInstance(ctx);
            boolean isAcct = false;
            for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
                if (voucherInfo.getEntries().get(i).getAccount().isAC()) {
                    isAcct = true;
                }
                if (!voucherInfo.getEntries().get(i).isIsVerify() || voucherInfo.getId() != null && voucherInfo.getEntries().get(i).getAccount() != null && !this.checkVchPeriodMoreThanAcctcussentInitPeriod(ctx, voucherInfo.getId().toString(), voucherInfo.getEntries().get(i).getAccount().getId().toString())) continue;
                for (int j = 0; j < voucherInfo.getEntries().get(i).getAssistRecords().size(); ++j) {
                    VoucherAssistRecordInfo asst = voucherInfo.getEntries().get(i).getAssistRecords().get(j);
                    if (voucherInfo.isFromSaveSubmit() && asst.getVerifiedCussent() != null) {
                        asst.put("VERIFY_CUSSENT_ID", (Object)asst.getVerifiedCussent().getId().toString());
                        asst.setVerifiedCussent(null);
                    }
                    if (asst.get("VERIFY_CUSSENT_ID") == null) continue;
                    factory.verifyVoucher(asst.getId().toString(), asst.get("VERIFY_CUSSENT_ID").toString(), null, virifyMode, company);
                }
            }
            if (isAcct) {
                AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertCussent(voucherInfo.getId().toString());
                AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertVerify(voucherInfo.getId().toString(), false);
            }
            DbUtil.execute((Context)ctx, (String)"update t_gl_voucherassistrecord set FVerifiedCussentID = null where fbillid = ? ", (Object[])new Object[]{voucherInfo.getId().toString()});
        } else {
            if (voucherInfo.isIsReverseVoucher()) {
                if (voucherInfo.getId() != null && !voucherInfo.isFromSaveSubmit()) {
                    String sql = "DELETE FROM T_GL_ACCTCUSSENTHISTORY WHERE FCUSSENTIDID in  (select fid from t_gl_acctcussent where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?))";
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
                    sql = "DELETE FROM T_GL_ACCTCUSSENTHISTORY WHERE FVOUCHERASSTIDID in  (select fid from t_gl_acctcussent where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?))";
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
                    sql = "delete from t_gl_acctcussent where FVchAssistRecordID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ?)";
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
                }
                AcctCussentHistoryFacadeFactory.getLocalInstance(ctx).insertCussent(voucherInfo.getId().toString(), voucherInfo.isIsReverseVoucher());
            }
            IAcctCussentHistory factory = AcctCussentHistoryFactory.getLocalInstance(ctx);
            VoucherEntryCollection voucherEntryCollection = voucherInfo.getEntries();
            Date verifyDate = new Date();
            for (int i = 0; i < voucherEntryCollection.size(); ++i) {
                VoucherEntryInfo voucherEntryInfo = voucherEntryCollection.get(i);
                if (voucherInfo.getId() != null && voucherEntryInfo.getAccount() != null && !this.checkVchPeriodMoreThanAcctcussentInitPeriod(ctx, voucherInfo.getId().toString(), voucherEntryInfo.getAccount().getId().toString()) || !voucherEntryInfo.isIsVerify() && !voucherInfo.isIsReverseVoucher()) continue;
                VoucherAssistRecordCollection voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
                for (int j = 0; j < voucherAssistRecordCollection.size(); ++j) {
                    VoucherAssistRecordInfo asst = voucherAssistRecordCollection.get(j);
                    String asstID = asst.getId().toString();
                    if (asst.getVerifiedCussent() == null && !voucherInfo.isIsReverseVoucher()) continue;
                    factory.verifyVoucher(asstID, asst.getVerifiedCussent().getId().toString(), verifyDate, virifyMode, company);
                }
            }
        }
    }

    public boolean checkVchPeriodMoreThanAcctcussentInitPeriod(Context ctx, String vchId, String acctId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select v.fid \r\n");
        sql.append("from t_gl_voucher v \r\n");
        sql.append(" left join t_bd_period pv on v.fperiodid = pv.fid \r\n");
        sql.append(" left join t_gl_flag f on v.fcompanyid = f.forgunitid \r\n");
        sql.append(" left join t_bd_period pi on pi.fid = f.finitperiodid \r\n");
        sql.append(" where v.fid = ? and f.fkey = ? and f.fname = 'cussentinit' and f.finitperiodid is not null and pv.fnumber >= pi.fnumber \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchId, acctId});
        try {
            if (rs != null && rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return false;
    }

    public void clearAcctCussent(Context ctx, BaseVoucherInfo voucherInfo, GlParam sysParam) throws BOSException, GLException {
        boolean isInTimeVerify;
        boolean bl = isInTimeVerify = sysParam.getInt("GL_052") == 0;
        if (!isInTimeVerify && voucherInfo.getId() != null && !voucherInfo.isFromSaveSubmit()) {
            String sql = "delete from t_gl_acctcussent where FVoucherId = ? and FUNVERIFIEDAMTFOR = FORIGINALAMOUNT";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
            sql = "delete from t_gl_acctverify where FVoucherId = ? and FUNVERIFIEDAMTFOR = FORIGINALAMOUNT";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        } else if (isInTimeVerify && voucherInfo.getId() != null) {
            String sql = "delete from t_gl_acctcussenthistory  where FVOUCHERASSTIDID in (select fid from t_gl_voucherassistrecord asst where asst.FBillID = ? and FVERIFIEDCUSSENTID is not null)";
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherInfo.getId().toString()});
        }
    }

    public void clearCashflow(Context ctx, VoucherInfo voucherInfo, GlParam sysParam) throws BOSException, EASBizException {
        if (voucherInfo.getId() == null) {
            return;
        }
        if (!voucherInfo.getCashflowFetched() && voucherInfo.getCashflowRecords().size() == 0) {
            return;
        }
        String sql = "";
        if (voucherInfo.getBizStatus() == VoucherStatusEnum.SUBMITTED) {
            if (SubmitVoucherServiceHelper.isEnableCFRequisition(sysParam)) {
                CFRequisitionFactory.getLocalInstance(ctx).clearRequisition((IObjectPK)new ObjectUuidPK(voucherInfo.getId()));
            }
            sql = "delete from t_gl_cashflowsplitrecord where fvoucherid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        }
        sql = "delete from t_gl_cashflowrecord where fvoucherid=?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
    }

    public void handleACNoticeAfterSubmit(Context ctx, VoucherInfo voucherInfo, String oldNumber, String oldTypeName, String oldPeriodId, IObjectPK voucherPK) throws BOSException, EASBizException {
        this.checkACNotice(ctx, voucherPK);
        String newNumber = voucherInfo.getNumber();
        String newTypeName = voucherInfo.getVoucherType().getName(ctx.getLocale());
        if (newTypeName == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("name"));
            newTypeName = VoucherTypeFactory.getLocalInstance((Context)ctx).getVoucherTypeInfo((IObjectPK)new ObjectUuidPK(voucherInfo.getVoucherType().getId()), selector).getName(ctx.getLocale());
        }
        String newPeriodId = voucherInfo.getPeriod().getId().toString();
        if (!(newNumber.equals(oldNumber) && newTypeName.equals(oldTypeName) && newPeriodId.equals(oldPeriodId))) {
            String vchNewTypeNameAndNumber = newTypeName + newNumber;
            String vchOldTypeNameAndNumber = oldTypeName + oldNumber;
            int newPeriod = voucherInfo.getPeriod().getPeriodYear() * 100 + voucherInfo.getPeriod().getPeriodNumber();
            StringBuffer sql = new StringBuffer();
            sql.append("update t_csl_requisition set FVchNumber=?,FPeriod = ? ,FNumber = replace(FNumber,?,?) ");
            sql.append("where fvoucherid=? and exists(select 1 from t_csl_requisitionentry reqe \r\n");
            sql.append("where reqe.frequisitionid=t_csl_requisition.fid and reqe.fstatus=2) \r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchNewTypeNameAndNumber, new Integer(newPeriod), vchOldTypeNameAndNumber, vchNewTypeNameAndNumber, voucherPK.toString()});
            sql.setLength(0);
            sql.append("update t_csl_requisitionentry set FVchNumber=replace(FVchNumber,?,?)");
            sql.append("where FCheckNumber in (select FCheckNumber from t_csl_requisitionentry reqe \r\n");
            sql.append("inner join t_csl_requisition re on re.fid=reqe.frequisitionid \r\n");
            sql.append("where re.fvoucherid=? and reqe.FStatus=2 and FCheckNumber is not null)\r\n");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{vchOldTypeNameAndNumber, vchNewTypeNameAndNumber, voucherPK.toString()});
        }
    }

    public boolean checkHasAcctBal(Context ctx, VoucherInfo voucherInfo) throws BOSException {
        if (voucherInfo.getId() == null || voucherInfo.isFromSaveSubmit()) {
            return false;
        }
        String sql = "select Fbizstatus from t_gl_voucher  where Fbizstatus=1 and fid=?   ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{voucherInfo.getId().toString()});
        try {
            if (rs != null && rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return false;
    }

    public void checkCussent(Context ctx, String vchID, GlParam sysParam) throws BOSException, EASBizException {
        Connection con = null;
        StringBuffer sql = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer errMsg = new StringBuffer();
        boolean acNoLimited = sysParam.getBoolean("GL_025");
        boolean isInTimeVerify = sysParam.getInt("GL_052") == 0;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            if (acNoLimited) {
                sql = new StringBuffer();
                sql.append("select ve.FSeq as FEntrySeq,vast.FSeq as FAsstSeq,vast.FOriginalAmount\t\t\r\n");
                sql.append("from t_gl_VoucherAssistRecord vast,                                         \r\n");
                sql.append("\tt_gl_VoucherEntry ve,                                                   \r\n");
                sql.append("\tt_gl_Voucher vch,                                                   \r\n");
                sql.append("\tt_GL_AcctCussent cust                                                   \r\n");
                sql.append("where ve.FBillID = vch.FID                                                   \r\n");
                sql.append("\tand vast.FEntryID = ve.FID                                                   \r\n");
                sql.append("\tand vch.FID = ?                                                    \r\n");
                sql.append("\tand ve.FIsVerify = 1                                                    \r\n");
                sql.append("\tand vast.FVerifiedCussentID is not null                                 \r\n");
                sql.append("\tand vast.FVerifiedCussentID = cust.FID                                  \r\n");
                sql.append("\tand vast.FOriginalAmount <> 0\t\t\t\t\t\t        \t\t\t\r\n");
                sql.append("\tand ( SIGN(vast.FOriginalAmount) <> SIGN(cust.FUnHoldedAmtFor) )        \r\n");
                sql.append("\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)\t\t\t\t\t\t   \r\n");
                sql.append(";\r\n");
                stmt = con.prepareStatement(sql.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)vchID);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    errMsg.append(this.getStr(ctx, "VoucherEntrySeq"));
                    errMsg.append(rs.getString("FEntrySeq"));
                    errMsg.append(",");
                    errMsg.append(this.getStr(ctx, "VoucherAssistSeq"));
                    errMsg.append(rs.getString("FAsstSeq"));
                    errMsg.append(";\r");
                }
                if (errMsg.length() > 0) {
                    Object[] info = new String[]{errMsg.toString()};
                    throw new GLPeriodEndException(GLPeriodEndException.VCHASST_VERIFY_CUSS_AMT_ERRDC, info);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                sql = new StringBuffer();
                sql.append("select ve.FSeq as FEntrySeq,vast.FSeq as FAsstSeq,vast.FStandardQuantity    \r\n");
                sql.append("from t_gl_VoucherAssistRecord vast,                                         \r\n");
                sql.append("\tt_gl_VoucherEntry ve,                                                   \r\n");
                sql.append("\tt_gl_Voucher vch,                                                   \r\n");
                sql.append("\tt_GL_AcctCussent cust                                                   \r\n");
                sql.append("where ve.FBillID = vch.FID                                                   \r\n");
                sql.append("\tand vast.FEntryID = ve.FID                                                   \r\n");
                sql.append("\tand vch.FID = ?                                                    \r\n");
                sql.append("\t\tand ve.FIsVerify = 1                                                   \r\n");
                sql.append("\tand vast.FVerifiedCussentID is not null                                 \r\n");
                sql.append("\tand vast.FVerifiedCussentID = cust.FID                                  \r\n");
                sql.append("\tand vast.FStandardQuantity <> 0                                         \r\n");
                sql.append("\tand ( SIGN(vast.FStandardQuantity) <> SIGN(cust.FUnHoldedStdQty) )      \r\n");
                sql.append("\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)\t\t\t\t\t\t   \r\n");
                sql.append(";\r\n");
                stmt = con.prepareStatement(sql.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)vchID);
                rs = stmt.executeQuery();
                errMsg = new StringBuffer();
                while (rs.next()) {
                    errMsg.append(this.getStr(ctx, "VoucherEntrySeq"));
                    errMsg.append(rs.getString("FEntrySeq"));
                    errMsg.append(",");
                    errMsg.append(this.getStr(ctx, "VoucherAssistSeq"));
                    errMsg.append(rs.getString("FAsstSeq"));
                    errMsg.append(";\r");
                }
                if (errMsg.length() > 0) {
                    Object[] info = new String[]{errMsg.toString()};
                    throw new GLPeriodEndException(GLPeriodEndException.VCHASST_VERIFY_CUSS_QTY_ERRDC, info);
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            }
            sql = new StringBuffer();
            sql.append("select v.FAccountNumber,v.FBizNumber,v.FVerifiedCussentID cussentId from\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("(                                                                               \r\n");
            sql.append("\tselect ve.FAccountID,acct.FNumber as FAccountNumber,                      \t\r\n");
            sql.append("\tisnull(vast.FBizNumber,' ') as FBizNumber,\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\t\tvast.FVerifiedCussentID, sum(vast.FOriginalAmount) as FSumAmount        \r\n");
            sql.append("\tfrom t_gl_VoucherAssistRecord vast,                                         \r\n");
            sql.append("\t\tt_gl_VoucherEntry ve,                                                   \r\n");
            sql.append("\t\tt_gl_Voucher vch,                                                   \r\n");
            sql.append("\t\tt_bd_accountview acct                                                   \r\n");
            sql.append("\twhere ve.FBillID = vch.FID                                                   \r\n");
            sql.append("\t\tand vast.FEntryID = ve.FID                                                   \r\n");
            sql.append("\t\tand ve.FAccountID = acct.FID                                            \r\n");
            sql.append("\t\tand vch.FID = ?                                                    \r\n");
            if (isInTimeVerify) {
                sql.append("\t\tand (ve.FIsVerify = 1  or  vch.FISREVERSEVOUCHER=1)                \r\n");
            } else {
                sql.append("\t\tand ve.FIsVerify = 1                                                   \r\n");
            }
            sql.append("\t\tand vast.FVerifiedCussentID is not null                                 \r\n");
            sql.append("\t\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)\t\t\t\t\t\t   \r\n");
            sql.append("\tGroup By ve.FAccountID,acct.FNumber,vast.FVerifiedCussentID,vast.FBizNumber     \r\n");
            sql.append(")as v,                                                                              \r\n");
            sql.append("t_GL_AcctCussent cust                                                               \r\n");
            sql.append("Where v.FVerifiedCussentID = cust.FID                                               \r\n");
            sql.append("\tand v.FSumAmount <> 0                                                           \r\n");
            sql.append("\tand ( ABS(v.FSumAmount) > ABS(cust.FUnHoldedAmtFor)                          \t\r\n");
            sql.append("\t\t  or ABS(v.FSumAmount) > ABS(cust.FUnVerifiedAmtFor)                       \t\r\n");
            sql.append("\t    )                         \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(";\r\n");
            stmt = con.prepareStatement(sql.toString());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)vchID);
            rs = stmt.executeQuery();
            errMsg = new StringBuffer();
            ArrayList<String> verifyCussentIds = new ArrayList<String>();
            while (rs.next()) {
                verifyCussentIds.add(rs.getString("cussentId"));
                errMsg.append(this.getStr(ctx, "AccountNumber"));
                errMsg.append(rs.getString("FAccountNumber"));
                if (rs.getString("FBizNumber").compareToIgnoreCase(" ") != 0) {
                    errMsg.append(",");
                    errMsg.append(this.getStr(ctx, "CussentBizNumber"));
                    errMsg.append(rs.getString("FBizNumber"));
                }
                errMsg.append(";\r");
            }
            if (errMsg.length() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String cussentId : verifyCussentIds) {
                    sb.append("'").append(cussentId).append("',");
                }
                sb.deleteCharAt(sb.length() - 1);
                String sql1 = "select ve.fseq veSeq,vast.fseq vastSeq from t_gl_VoucherAssistRecord vast inner join t_gl_voucherentry ve on vast.fentryid = ve.fid where vast.fbillid='" + vchID + "' and vast.FVerifiedCussentID in (" + sb.toString() + ") order by veSeq,vastSeq";
                IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql1);
                LinkedHashMap seqMap = new LinkedHashMap();
                while (result.next()) {
                    Integer veSeq = result.getInt("veSeq");
                    Integer vsSeq = result.getInt("vastSeq");
                    if (!seqMap.containsKey(veSeq)) {
                        ArrayList<Integer> vsSeqList = new ArrayList<Integer>();
                        vsSeqList.add(vsSeq);
                        seqMap.put(veSeq, vsSeqList);
                        continue;
                    }
                    ((List)seqMap.get(veSeq)).add(vsSeq);
                }
                StringBuilder veSeqInfo = new StringBuilder();
                StringBuilder vsSeqInfo = new StringBuilder();
                Set entrySet = seqMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    Integer veSeq = (Integer)entry.getKey();
                    veSeqInfo.append(",").append(String.valueOf(veSeq));
                    List vsSeq = (List)entry.getValue();
                    vsSeqInfo.append(";");
                    for (Integer seq : vsSeq) {
                        vsSeqInfo.append(String.valueOf(seq)).append(",");
                    }
                    vsSeqInfo.deleteCharAt(vsSeqInfo.length() - 1);
                }
                String veSeqStr = veSeqInfo.deleteCharAt(0).toString();
                String vsSeqStr = vsSeqInfo.deleteCharAt(0).toString();
                Object[] info = new String[]{veSeqStr, vsSeqStr, errMsg.toString()};
                throw new GLPeriodEndException(GLPeriodEndException.VERIFY_CUSSENT_AMT, info);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            sql = new StringBuffer();
            sql.append("select v.FAccountNumber,v.FBizNumber from\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("(                                                                                   \r\n");
            sql.append("\tselect ve.FAccountID,acct.FNumber as FAccountNumber,                      \t\r\n");
            sql.append("\tisnull(vast.FBizNumber,' ') as FBizNumber,\t\t\t\t\t\t\t\t\t\r\n");
            sql.append("\t\tvast.FVerifiedCussentID, sum(vast.FStandardQuantity) as FSumStdQty        \r\n");
            sql.append("\tfrom t_gl_VoucherAssistRecord vast,                                             \r\n");
            sql.append("\t\tt_gl_VoucherEntry ve,                                                   \r\n");
            sql.append("\t\tt_gl_Voucher vch,                                                   \r\n");
            sql.append("\t\tt_bd_accountview acct                                                   \r\n");
            sql.append("\twhere ve.FBillID = vch.FID                                                   \r\n");
            sql.append("\t\tand vast.FEntryID = ve.FID                                                   \r\n");
            sql.append("\t\tand ve.FAccountID = acct.FID                                            \r\n");
            sql.append("\t\tand vch.FID = ?                                                    \r\n");
            if (isInTimeVerify) {
                sql.append("\t\tand (ve.FIsVerify = 1  or  vch.FISREVERSEVOUCHER=1)                \r\n");
            } else {
                sql.append("\t\tand ve.FIsVerify = 1                                                   \r\n");
            }
            sql.append("\t\tand vast.FVerifiedCussentID is not null                                 \r\n");
            sql.append("\t\tand (vch.FSourceType = 0 or vast.FOriginalAmount <> 0)\t\t\t\t\t\t   \r\n");
            sql.append("\tGroup By ve.FAccountID,acct.FNumber,vast.FVerifiedCussentID,vast.FBizNumber\t\t\r\n");
            sql.append(")as v,                                                                              \r\n");
            sql.append("t_GL_AcctCussent cust                                                               \r\n");
            sql.append("Where v.FVerifiedCussentID = cust.FID                                               \r\n");
            sql.append("\tand v.FSumStdQty <> 0                                                           \r\n");
            sql.append("\tand ( ABS(v.FSumStdQty) > ABS(cust.FUnHoldedStdQty)                          \t\r\n");
            sql.append("\t\t  or ABS(v.FSumStdQty) > ABS(cust.FUnVerifiedStdQty)                       \t\r\n");
            sql.append("\t    )                         \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
            sql.append(";\r\n");
            stmt = con.prepareStatement(sql.toString());
            DbUtil.prepareVarcharParam((PreparedStatement)stmt, (int)1, (String)vchID);
            rs = stmt.executeQuery();
            errMsg = new StringBuffer();
            while (rs.next()) {
                errMsg.append(this.getStr(ctx, "AccountNumber"));
                errMsg.append(rs.getString("FAccountNumber"));
                if (rs.getString("FBizNumber").compareToIgnoreCase(" ") != 0) {
                    errMsg.append(",");
                    errMsg.append(this.getStr(ctx, "CussentBizNumber"));
                    errMsg.append(rs.getString("FBizNumber"));
                }
                errMsg.append(";\r");
            }
            if (errMsg.length() > 0) {
                Object[] info = new String[]{errMsg.toString()};
                throw new GLPeriodEndException(GLPeriodEndException.VCHASST_VERIFY_CUSS_QTY_TOOMUCH, info);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
    }

    public void checkAmountBalance(Context ctx, IObjectPK voucherPK, GlParam sysParam) throws BOSException, EASBizException {
        boolean usingRpt = sysParam.getBoolean("G001");
        StringBuffer sql = new StringBuffer();
        sql.append("select ve.fentrydc,ve.fseq,ve.flocalamount,ve.freportingamount,v.fnumber,av.fnumber facctnumber,\r\n");
        sql.append("av.FBw,t.fentryid,t.flocalamount fsumlocalamount,t.freportingamount fsumreportingamount \r\n");
        sql.append("from t_gl_voucherentry ve \r\n");
        sql.append("inner join t_bd_accountview av on av.fid=ve.faccountid \r\n");
        sql.append("inner join t_gl_voucher v on v.fid=ve.fbillid \r\n");
        sql.append("left join \r\n");
        sql.append("( \r\n");
        sql.append("  select fentryid,sum(flocalamount) flocalamount,sum(freportingamount) freportingamount from t_gl_voucherassistrecord \r\n");
        sql.append("  where fbillid=? \r\n");
        sql.append("  group by fbillid,fentryid \r\n");
        sql.append(") t on ve.fid=t.fentryid \r\n");
        sql.append("where ve.fbillid=? \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherPK.toString(), voucherPK.toString()});
        try {
            BigDecimal totalVchDebitLocAmt = GlUtils.zero;
            BigDecimal totalVchCreditLocAmt = GlUtils.zero;
            BigDecimal totalVchDebitRptAmt = GlUtils.zero;
            BigDecimal totalVchCreditRptAmt = GlUtils.zero;
            boolean hasBwAcct = false;
            while (rs.next()) {
                BigDecimal locAmt = rs.getBigDecimal("flocalamount") == null ? GlUtils.zero : rs.getBigDecimal("flocalamount");
                BigDecimal rptAmt = rs.getBigDecimal("freportingamount") == null ? GlUtils.zero : rs.getBigDecimal("freportingamount");
                String entryId = rs.getString("fentryid");
                int isBw = rs.getInt("fbw");
                if (isBw == 1) {
                    hasBwAcct = true;
                }
                if (entryId != null && entryId.trim().length() > 0) {
                    BigDecimal sumLocAmt = rs.getBigDecimal("fsumlocalamount");
                    BigDecimal sumRptAmt = rs.getBigDecimal("fsumreportingamount");
                    if (locAmt.compareTo(sumLocAmt) != 0) {
                        logger.error((Object)("zjq---voucherId:" + voucherPK.toString() + " entryId:" + entryId));
                        throw new VoucherException(VoucherException.VCH_LINE_EQUAL_ASSIT_LOC, new Object[]{rs.getString("fnumber"), new Integer(rs.getInt("fseq")), rs.getString("facctnumber"), locAmt, sumLocAmt});
                    }
                    if (usingRpt && rptAmt.compareTo(sumRptAmt) != 0) {
                        throw new VoucherException(VoucherException.VCH_LINE_EQUAL_ASSIT_RPT, new Object[]{rs.getString("fnumber"), new Integer(rs.getInt("fseq")), rs.getString("facctnumber"), rptAmt, sumRptAmt});
                    }
                }
                if (1 == rs.getInt("fentrydc")) {
                    totalVchDebitLocAmt = totalVchDebitLocAmt.add(locAmt);
                    totalVchDebitRptAmt = totalVchDebitRptAmt.add(rptAmt);
                    continue;
                }
                totalVchCreditLocAmt = totalVchCreditLocAmt.add(locAmt);
                totalVchCreditRptAmt = totalVchCreditRptAmt.add(rptAmt);
            }
            if (!hasBwAcct) {
                if (totalVchDebitLocAmt.compareTo(totalVchCreditLocAmt) != 0) {
                    throw new VoucherException(VoucherException.LOCAL_DC_NOT_EQUAL, new Object[]{totalVchDebitLocAmt, totalVchCreditLocAmt});
                }
                if (usingRpt && totalVchDebitRptAmt.compareTo(totalVchCreditRptAmt) != 0) {
                    throw new VoucherException(VoucherException.REPORT_DC_NOT_EQUAL, new Object[]{totalVchDebitRptAmt, totalVchCreditRptAmt});
                }
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    private static boolean isEnableCFRequisition(GlParam sysParams) throws BOSException, EASBizException {
        int paramAsst = sysParams.getInt("GL_0152");
        if (!sysParams.isParamExisted("GL_0152") || paramAsst != 0) {
            return false;
        }
        boolean paramCashflow = sysParams.getBoolean("GL_070");
        return sysParams.isParamExisted("GL_070") && paramCashflow;
    }

    private void checkACNotice(Context ctx, IObjectPK voucherPK) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 re.fid from t_csl_requisition re \r\n");
        sql.append("inner join t_csl_requisitionentry reqe on re.fid=reqe.frequisitionid \r\n");
        sql.append("left join t_gl_voucherassistrecord asst on asst.fid=reqe.fassistrecordid \r\n");
        sql.append("left join t_gl_voucherentry ve on ve.fid=asst.fentryid \r\n");
        sql.append("left join T_BD_AssistantHG assGrp on asst.FAssGrpID = assGrp.FID \r\n");
        sql.append("left join T_BD_Customer customer on assGrp.FCustomerID = customer.FID \r\n");
        sql.append("left join T_BD_Supplier supplier on assGrp.FProviderID = supplier.FID \r\n");
        sql.append("where re.fvoucherid=? and (asst.fid is null \r\n");
        sql.append("      or reqe.faccountid <> ve.faccountid \r\n");
        sql.append("      or reqe.fcurrencyid <> ve.fcurrencyid or reqe.fdc <> ve.fentrydc \r\n");
        sql.append("      or reqe.foriginalamount <> asst.foriginalamount \r\n");
        sql.append("      or reqe.fsummary <> asst.fdescription \r\n");
        sql.append("      or re.ftargcompanyid <> isnull(isnull(assGrp.FCompanyOrgID, isnull(customer.FInternalCompanyID, supplier.FInternalCompanyID)),' ') \r\n");
        sql.append("     ) \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{voucherPK.toString()});
        try {
            if (rs.next()) {
                throw new VoucherException(VoucherException.AC_ASST_CHANGED_1);
            }
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
    }

    private static boolean prepareSubmitCashflow(Context ctx, VoucherInfo voucherInfo, GlParam sysParam, CashflowFlag cfFlag) throws EASBizException, BOSException {
        boolean isSmartAccounting = BOSObjectFactory.getContextFromThread() != null && BOSObjectFactory.getContextFromThread().get((Object)"isSmartAccounting") != null;
        boolean hasAutoSelectAccount = false;
        boolean autoSaveCF = sysParam.getBoolean("GL_autoSaveCF");
        if (voucherInfo.isWebVoucher() && autoSaveCF) {
            VoucherSubmitCashFlowAuto.fillAutoSetCashFlowItem(ctx, voucherInfo);
        }
        HashMap<BOSUuid, VoucherEntryInfo> voucherEntryMap = new HashMap<BOSUuid, VoucherEntryInfo>();
        HashMap<Integer, VoucherEntryInfo> voucherSeqEntryMap = new HashMap<Integer, VoucherEntryInfo>();
        VoucherEntryCollection entryColl = voucherInfo.getEntries();
        for (VoucherEntryInfo voucherEntryInfo : entryColl) {
            if (voucherEntryInfo.getId() == null) {
                voucherEntryInfo.setId(BOSUuid.create((BOSObjectType)voucherEntryInfo.getBOSType()));
            }
            voucherEntryMap.put(voucherEntryInfo.getId(), voucherEntryInfo);
            voucherSeqEntryMap.put(voucherEntryInfo.getSeq(), voucherEntryInfo);
            if (!isSmartAccounting && !autoSaveCF) continue;
            if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                if (voucherEntryInfo.getAccount().getLenderMainCashFlowItem() != null || voucherEntryInfo.getAccount().getLenderAttCashFlowItem() != null) {
                    hasAutoSelectAccount = true;
                }
            } else if (voucherEntryInfo.getAccount().getBorrowerMainCashFlowItem() != null || voucherEntryInfo.getAccount().getBorrowerAttCashFlowItem() != null) {
                hasAutoSelectAccount = true;
            }
            if (!hasAutoSelectAccount && CashFlowUtils.isContainsDAPCashflowItems(voucherEntryInfo)) {
                hasAutoSelectAccount = true;
            }
            if (voucherInfo.isHasCashAccount() || !voucherEntryInfo.getAccount().isIsCash() && !voucherEntryInfo.getAccount().isIsCashEquivalent() && !voucherEntryInfo.getAccount().isIsBank()) continue;
            voucherInfo.setHasCashAccount(true);
        }
        CashflowRecordCollection cashflowRecordCollection = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
        if (cashflowRecordCollection == null) {
            cashflowRecordCollection = new CashflowRecordCollection();
        }
        voucherInfo.setCashflowRecords((AbstractObjectCollection)cashflowRecordCollection);
        GlUtils.checkAndAdjustRecords(cashflowRecordCollection);
        HashSet<String> acctDif = new HashSet<String>();
        CashFlowAccountDiffCollection acctDifCol = voucherInfo.getCashFlowAccountDiffCollection();
        if (acctDifCol != null) {
            int size = acctDifCol.size();
            for (int i = 0; i < size; ++i) {
                acctDif.add(acctDifCol.get(i).getDiffAccount().getId().toString());
            }
        }
        boolean hasPrimaryRecord = false;
        if (CashflowFlag.BOTH_CASH_AND_PNL.equals((Object)cfFlag)) {
            hasPrimaryRecord = true;
        }
        Iterator it = cashflowRecordCollection.iterator();
        while (it.hasNext()) {
            VoucherEntryInfo entry;
            CashflowRecordInfo r = (CashflowRecordInfo)it.next();
            if (r.getEntry() != null && r.getEntry().getId() == null && (entry = (VoucherEntryInfo)voucherSeqEntryMap.get(r.getEntry().getSeq())) != null) {
                r.getEntry().setId(entry.getId());
            }
            if (r.getOpposingAccountEntry() != null && r.getOpposingAccountEntry().getId() == null && (entry = (VoucherEntryInfo)voucherSeqEntryMap.get(r.getOpposingAccountEntry().getSeq())) != null) {
                r.getOpposingAccountEntry().setId(entry.getId());
            }
            if (r.getEntry() == null || r.getEntry().getId() == null || r.getOpposingAccountEntry() == null || r.getOpposingAccountEntry().getId() == null) {
                it.remove();
                continue;
            }
            if (!voucherEntryMap.containsKey(r.getEntry().getId()) || !voucherEntryMap.containsKey(r.getOpposingAccountEntry().getId())) {
                it.remove();
                continue;
            }
            CashFlowItemInfo pi = r.getPrimaryItem();
            if (pi != null && pi.isIsFreeze()) {
                throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{pi.getNumber()});
            }
            CashFlowItemInfo si = r.getSupplementaryItem();
            if (si != null && si.isIsFreeze()) {
                throw new VoucherException(VoucherException.CFITEM_DISABLED, new Object[]{si.getNumber()});
            }
            if (!hasPrimaryRecord || !CashFlowUtils.isPL(r.getEntry().getAccount(), acctDif)) continue;
            r.setIsSupItem(true);
        }
        return hasAutoSelectAccount;
    }

    public static void dealSubmitCashflow(Context ctx, IObjectPK voucherPK, VoucherInfo voucherInfo, GlParam sysParam) throws EASBizException, BOSException {
        block39: {
            if (voucherInfo.getSourceType() == SourceType.ACCOUNTADJUST || SourceType.PROFIT_AND_LOSS.equals((Object)voucherInfo.getSourceType()) || VoucherCategoryEnum.BUDGET.equals((Object)voucherInfo.getCategory())) {
                return;
            }
            VoucherEntryCollection entryColl = voucherInfo.getEntries();
            if (entryColl == null) {
                return;
            }
            boolean mustPI = sysParam.getInt("GL_014") != 2;
            boolean mustBoth = sysParam.getBoolean("GL_015");
            int GL_078 = sysParam.getInt("GL_078");
            boolean autoSelect = GL_078 != 2;
            boolean splitByOpposite = GL_078 == 1;
            int isOutCfAssistRequired = sysParam.getInt("GL_102");
            boolean autoSaveCF = sysParam.getBoolean("GL_autoSaveCF");
            Map allDif = VoucherProcessCache.getDifference(ctx, voucherInfo.getCompany().getId().toString());
            CashFlowAccountDiffCollection acctDifCol = (CashFlowAccountDiffCollection)allDif.get("CashFlowAccountDiffCollection");
            voucherInfo.setCashFlowAccountDiffCollection(acctDifCol);
            CashflowFlag cfFlag = CashFlowUtils.computeCashflowFlag(voucherInfo);
            if (CashflowFlag.BOTHNONE == cfFlag) {
                return;
            }
            if (CashflowFlag.NONE == cfFlag) {
                ITAccountSplitStrategy strategy = TAccountSplitStrategyFactory.getSplitStrategy(splitByOpposite ? "byOpposite" : "default");
                CashflowSplitRecordCollection splitResult = strategy.split(ctx, voucherInfo, new HashMap<String, Object>());
                if (!splitByOpposite) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("cashflowSplitRecords", splitResult);
                    CashflowSplitRecordCollection secondSplitColl = TAccountSplitStrategyFactory.getSplitStrategy("pl").split(ctx, voucherInfo, params);
                    splitResult.addCollection(secondSplitColl);
                }
                CashflowSplitRecordFactory.getLocalInstance(ctx).addBatch((IObjectCollection)splitResult);
                if (voucherPK != null) {
                    DbUtil.execute((Context)ctx, (String)"update t_gl_voucher set fcashflowflag=? where fid=? ", (Object[])new Object[]{0, voucherPK.toString()});
                }
                return;
            }
            boolean hasAutoSelectAccount = SubmitVoucherServiceHelper.prepareSubmitCashflow(ctx, voucherInfo, sysParam, cfFlag);
            boolean isOnlyCashAccount = voucherInfo.isHasCashAccount() && cfFlag.equals((Object)CashflowFlag.NONE);
            CashflowRecordCollection cashflowRecordCollection = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
            logger.error((Object)("params : hasAutoSelectAccount=" + hasAutoSelectAccount + ",autoSaveCF=" + autoSaveCF + ",mustPI=" + mustPI + ",mustBoth=" + mustBoth + ",autoSelect=" + autoSelect + " ,CashflowFlag=" + voucherInfo.getCashflowFlag() + " ,cfFlag=" + cfFlag));
            logger.error((Object)("cashflowRecordCollection=" + cashflowRecordCollection));
            boolean isNeedCompareAmount = true;
            if (!(autoSaveCF && hasAutoSelectAccount || !CashflowFlag.FINISHED.equals((Object)voucherInfo.getCashflowFlag()) && !mustPI && !mustBoth)) {
                SubmitVoucherServiceHelper.compareAmount(ctx, cashflowRecordCollection, entryColl, mustPI, mustBoth, sysParam, voucherInfo);
                VoucherSubmitCashFlowAuto.checkCFAsstGrpIntegrity(ctx, cashflowRecordCollection, isOutCfAssistRequired, null);
                isNeedCompareAmount = false;
            }
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                if (voucherInfo.getCashflowFlag() == CashflowFlag.FINISHED && cashflowRecordCollection.size() > 0) {
                    if (isNeedCompareAmount) {
                        SubmitVoucherServiceHelper.compareAmount(ctx, cashflowRecordCollection, entryColl, mustPI, mustBoth, sysParam, voucherInfo);
                        VoucherSubmitCashFlowAuto.checkCFAsstGrpIntegrity(ctx, cashflowRecordCollection, isOutCfAssistRequired, null);
                    }
                    SubmitVoucherServiceHelper.saveCashflowRecord(ctx, conn, voucherInfo, cashflowRecordCollection);
                    ITAccountSplitStrategy plSplitStrategy = TAccountSplitStrategyFactory.getSplitStrategy("pl");
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("cashflowRecords", cashflowRecordCollection);
                    CashflowSplitRecordCollection splitColl = plSplitStrategy.split(ctx, voucherInfo, params);
                    if (splitColl.size() > 0) {
                        CashflowSplitRecordFactory.getLocalInstance(ctx).addBatch((IObjectCollection)splitColl);
                    }
                    break block39;
                }
                if (mustPI && !autoSelect && !isOnlyCashAccount) {
                    if (CashflowFlag.ONLY_CASHACCOUNT.equals((Object)cfFlag) || CashflowFlag.BOTH_CASH_AND_PNL.equals((Object)cfFlag) || CashflowFlag.ONLY_PNLACCOUNT.equals((Object)cfFlag) && mustBoth) {
                        if (!CashFlowUtils.isAllZero4CashOrPLAccount(voucherInfo, cfFlag)) {
                            throw new VoucherException(VoucherException.CF_ASSIGNED_INCORRECT);
                        }
                        if (CashflowFlag.ONLY_PNLACCOUNT.equals((Object)cfFlag) && !mustBoth) {
                            SubmitVoucherServiceHelper.savePLCashflow(ctx, conn, voucherInfo, splitByOpposite);
                        }
                    }
                    break block39;
                }
                if (autoSaveCF && mustPI && autoSelect) {
                    ITAccountSplitStrategy tAccountSplitStrategy;
                    if (!hasAutoSelectAccount) {
                        SubmitVoucherServiceHelper.compareAmount(ctx, cashflowRecordCollection, entryColl, true, mustBoth, sysParam, voucherInfo);
                    }
                    voucherInfo.setCashflowRecords(null);
                    CashflowSplitRecordCollection firstSplitColl = new CashflowSplitRecordCollection();
                    CashflowSplitRecordCollection secondSplitColl = new CashflowSplitRecordCollection();
                    if (splitByOpposite) {
                        tAccountSplitStrategy = TAccountSplitStrategyFactory.getSplitStrategy("byOpposite");
                        if (CashflowFlag.ONLY_PNLACCOUNT == cfFlag) {
                            secondSplitColl = tAccountSplitStrategy.split(ctx, voucherInfo, new HashMap<String, Object>());
                        } else {
                            firstSplitColl = tAccountSplitStrategy.split(ctx, voucherInfo, new HashMap<String, Object>());
                        }
                    } else {
                        tAccountSplitStrategy = TAccountSplitStrategyFactory.getSplitStrategy("default");
                        firstSplitColl = tAccountSplitStrategy.split(ctx, voucherInfo, new HashMap<String, Object>());
                        ITAccountSplitStrategy plSplitStrategy = TAccountSplitStrategyFactory.getSplitStrategy("pl");
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("cashflowSplitRecords", firstSplitColl);
                        secondSplitColl = plSplitStrategy.split(ctx, voucherInfo, params);
                    }
                    CashflowRecordCollection cfColl = VoucherSubmitCashFlowAuto.toCashflowRecordCollection(ctx, voucherInfo, firstSplitColl, secondSplitColl, sysParam);
                    logger.error((Object)("splitrecords transfer records result: cfColl=" + cfColl));
                    voucherInfo.put("enableAutoBalanceCFRpt", (Object)true);
                    SubmitVoucherServiceHelper.compareAmount(ctx, cfColl, entryColl, mustPI, mustBoth, sysParam, voucherInfo);
                    if (voucherInfo.getId() != null) {
                        HashMap<String, String> mapParam = new HashMap<String, String>();
                        mapParam.put("cfReq", "true");
                        mapParam.put("vchid", voucherInfo.getId().toString());
                        mapParam.put("vch", (String)voucherInfo);
                        CashflowRecordFactory.getLocalInstance(ctx).saveCashflowCols((IObjectCollection)cfColl, mapParam);
                    }
                    voucherInfo.setCashflowRecords((AbstractObjectCollection)cfColl);
                    break block39;
                }
                if (!voucherInfo.isHasCashAccount()) {
                    if (CashflowFlag.ONLY_PNLACCOUNT.equals((Object)cfFlag) && (!autoSaveCF || !autoSelect) && mustBoth && cashflowRecordCollection.size() == 0) {
                        throw new VoucherException(VoucherException.CF_SUPITEM_MUST_ASSIGN);
                    }
                    SubmitVoucherServiceHelper.savePLCashflow(ctx, conn, voucherInfo, splitByOpposite);
                    break block39;
                }
                ITAccountSplitStrategy strategy = TAccountSplitStrategyFactory.getSplitStrategy(splitByOpposite && cashflowRecordCollection.size() == 0 ? "byOpposite" : "default");
                CashflowSplitRecordCollection splitResult = strategy.split(ctx, voucherInfo, new HashMap<String, Object>());
                CashflowSplitRecordCollection cfsNotSaveRecords = new CashflowSplitRecordCollection();
                CashflowRecordCollection cfNeedSaveRecords = new CashflowRecordCollection();
                if (cashflowRecordCollection != null && cashflowRecordCollection.size() > 0) {
                    int cfSize = cashflowRecordCollection.size();
                    block5: for (int i = 0; i < cfSize; ++i) {
                        CashflowRecordInfo cashflow = cashflowRecordCollection.get(i);
                        ItemFlag flag = cashflow.getItemFlag();
                        if (flag == ItemFlag.PRIMARY || flag == ItemFlag.BOTH || flag == ItemFlag.DISPOSE && (cashflow.getEntry().getAccount().isIsBank() || cashflow.getEntry().getAccount().isIsCash() || cashflow.getEntry().getAccount().isIsCashEquivalent())) {
                            int splitSize = splitResult.size();
                            for (int j = 0; j < splitSize; ++j) {
                                CashflowSplitRecordInfo cashflowSplit = splitResult.get(j);
                                if (!cashflowSplit.equalsToCashflowRecordInfo(cashflow)) continue;
                                cfNeedSaveRecords.add(cashflow);
                                cfsNotSaveRecords.add(cashflowSplit);
                                continue block5;
                            }
                            continue;
                        }
                        cfNeedSaveRecords.add(cashflow);
                    }
                }
                SubmitVoucherServiceHelper.saveCashflowRecord(ctx, conn, voucherInfo, cfNeedSaveRecords);
                ICashflowSplitRecord cfSplit = CashflowSplitRecordFactory.getLocalInstance(ctx);
                Iterator itCFS = cfsNotSaveRecords.iterator();
                while (itCFS.hasNext()) {
                    splitResult.remove((CashflowSplitRecordInfo)itCFS.next());
                }
                cfSplit.addBatch((IObjectCollection)splitResult);
                if (splitByOpposite && cfNeedSaveRecords.size() > 0 && splitResult.size() == 0 && (mustPI || mustBoth)) {
                    SubmitVoucherServiceHelper.compareAmount(ctx, cfNeedSaveRecords, entryColl, mustPI, mustBoth, sysParam, voucherInfo);
                    if (voucherPK != null) {
                        DbUtil.execute((Context)ctx, (String)"update t_gl_voucher set fcashflowflag=? where fid=? ", (Object[])new Object[]{CashflowFlag.FINISHED, voucherPK.toString()});
                    }
                } else {
                    ITAccountSplitStrategy plSplitStrategy = TAccountSplitStrategyFactory.getSplitStrategy("pl");
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("cashflowRecords", cfNeedSaveRecords);
                    params.put("cashflowSplitRecords", splitResult);
                    CashflowSplitRecordCollection splitColl = plSplitStrategy.split(ctx, voucherInfo, params);
                    if (splitColl.size() > 0) {
                        CashflowSplitRecordFactory.getLocalInstance(ctx).addBatch((IObjectCollection)splitColl);
                    }
                    String updateSql = "update t_gl_voucher set fcashflowflag=? where fid=? and fcashflowflag <> ? ";
                    if (voucherPK != null) {
                        DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{6, voucherPK.toString(), 0});
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException("SQL ERROR!", (Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
        if (voucherPK != null) {
            SubmitVoucherServiceHelper.sendCFRequisition(ctx, voucherPK, sysParam);
        }
    }

    private static void saveCashflowRecord(Context ctx, Connection conn, VoucherInfo voucherInfo, CashflowRecordCollection cashflowRecordCollection) throws DataAccessException {
        IORMappingDAO iCashflowRecord = ORMappingDAO.getInstance((BOSObjectType)new CashflowRecordInfo().getBOSType(), (Context)ctx, (Connection)conn);
        UserInfo curUser = new UserInfo();
        curUser.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        Timestamp curTime = SubmitVoucherServiceHelper.getCurrentTime();
        for (CashflowRecordInfo cashflowRecordInfo : cashflowRecordCollection) {
            cashflowRecordInfo.setVoucher(voucherInfo);
            cashflowRecordInfo.setId(null);
            cashflowRecordInfo.setCreator(curUser);
            cashflowRecordInfo.setLastUpdateUser(curUser);
            cashflowRecordInfo.setCreateTime(curTime);
            cashflowRecordInfo.setLastUpdateTime(curTime);
            iCashflowRecord.addNewBatch((IObjectValue)cashflowRecordInfo);
        }
        iCashflowRecord.executeBatch();
    }

    private static void sendCFRequisition(Context ctx, IObjectPK voucherPK, GlParam sysParam) throws BOSException, EASBizException {
        if (SubmitVoucherServiceHelper.isEnableCFRequisition(sysParam)) {
            CFRequisitionFactory.getLocalInstance(ctx).clearRequisition(voucherPK);
            CFRequisitionFactory.getLocalInstance(ctx).sendRequisition(voucherPK);
        }
    }

    public static void compareAmount(Context ctx, CashflowRecordCollection cfCol, VoucherEntryCollection entryColl, boolean mustPI, boolean mustBoth, GlParam sysParam, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        CashFlowAccountDiffCollection acctDifCol;
        boolean isUseReport = sysParam.getBoolean("G001");
        HashMap<String, String> cfDif = new HashMap<String, String>();
        HashMap<String, String> acctDif = new HashMap<String, String>();
        Map allDif = VoucherProcessCache.getDifference(ctx, voucherInfo.getCompany().getId().toString());
        CashFlowKeepActivityCollection cfDifCol = (CashFlowKeepActivityCollection)allDif.get("CashFlowKeepActivityCollection");
        if (cfDifCol != null) {
            int size = cfDifCol.size();
            for (int i = 0; i < size; ++i) {
                cfDif.put(cfDifCol.get(i).getConCashFlowItem().getId().toString(), "");
            }
        }
        if ((acctDifCol = (CashFlowAccountDiffCollection)allDif.get("CashFlowAccountDiffCollection")) != null) {
            int size = acctDifCol.size();
            for (int i = 0; i < size; ++i) {
                acctDif.put(acctDifCol.get(i).getDiffAccount().getId().toString(), "");
            }
        }
        BigDecimal cashOrgAmount = GlUtils.zero;
        BigDecimal cashAmount = GlUtils.zero;
        BigDecimal netProfitAmount = GlUtils.zero;
        BigDecimal cashRptAmount = GlUtils.zero;
        BigDecimal netProfitRptAmount = GlUtils.zero;
        Iterator itEntry = entryColl.iterator();
        VoucherEntryInfo entry = null;
        AccountViewInfo entryAcct = null;
        while (itEntry.hasNext()) {
            entry = (VoucherEntryInfo)itEntry.next();
            entryAcct = entry.getAccount();
            if (entryAcct.isBudget()) continue;
            if (entry.getLocalAmount() == null) {
                entry.setLocalAmount(GlUtils.zero);
                logger.error((Object)("voucher persistence error!" + entry.toString()));
            }
            logger.info((Object)("BT526171:Seq = " + entry.getSeq() + "entry id ='" + (entry.getId() != null ? entry.getId().toString() : "null") + "' LocalAmount = " + entry.getLocalAmount() + " scale = " + entry.getLocalAmount().scale()));
            logger.info((Object)("BT526171:cashAmount = " + cashAmount));
            if (entryAcct.isIsCash() || entryAcct.isIsBank() || entryAcct.isIsCashEquivalent()) {
                if (EntryDC.DEBIT.equals((Object)entry.getEntryDC())) {
                    cashOrgAmount = cashOrgAmount.add(entry.getOriginalAmount());
                    cashAmount = cashAmount.add(entry.getLocalAmount());
                    if (entry.getReportingAmount() != null && isUseReport) {
                        cashRptAmount = cashRptAmount.add(entry.getReportingAmount());
                    }
                    logger.info((Object)("BT526171:cashAmount.add(entry.getLocalAmount()); cashAmount = " + cashAmount + " scale = " + cashAmount.scale()));
                    continue;
                }
                cashOrgAmount = cashOrgAmount.subtract(entry.getOriginalAmount());
                cashAmount = cashAmount.subtract(entry.getLocalAmount());
                if (entry.getReportingAmount() != null && isUseReport) {
                    cashRptAmount = cashRptAmount.subtract(entry.getReportingAmount());
                }
                logger.info((Object)("BT526171:cashAmount.subtract(entry.getLocalAmount()); cashAmount = " + cashAmount + " scale = " + cashAmount.scale()));
                continue;
            }
            if (!CashFlowUtils.isPL(entryAcct, acctDif)) continue;
            if (EntryDC.DEBIT.equals((Object)entry.getEntryDC())) {
                netProfitAmount = netProfitAmount.subtract(entry.getLocalAmount());
                if (entry.getReportingAmount() == null || !isUseReport) continue;
                netProfitRptAmount = netProfitRptAmount.subtract(entry.getReportingAmount());
                continue;
            }
            netProfitAmount = netProfitAmount.add(entry.getLocalAmount());
            if (entry.getReportingAmount() == null || !isUseReport) continue;
            netProfitRptAmount = netProfitRptAmount.add(entry.getReportingAmount());
        }
        BigDecimal piOrgAmount = GlUtils.zero;
        BigDecimal piAmount = GlUtils.zero;
        BigDecimal siAmount = GlUtils.zero;
        BigDecimal daAmount = GlUtils.zero;
        BigDecimal piRptAmount = GlUtils.zero;
        BigDecimal siRptAmount = GlUtils.zero;
        BigDecimal daRptAmount = GlUtils.zero;
        CashflowRecordInfo record2 = null;
        BigDecimal diposeCreditAmount = GlUtils.zero;
        BigDecimal diposeDebitAmount = GlUtils.zero;
        BigDecimal diposeSupItemCreditAmount = GlUtils.zero;
        BigDecimal diposeSupItemDebitAmount = GlUtils.zero;
        for (CashflowRecordInfo record2 : cfCol) {
            BigDecimal direction;
            if (ItemFlag.PRIMARY.equals((Object)record2.getItemFlag())) {
                BigDecimal bigDecimal = direction = record2.getPrimaryItem() != null && CashFlowDirection.IN.equals((Object)record2.getPrimaryItem().getDirection()) ? GlUtils.one : GlUtils.negone;
                if (record2.getPrimaryCoefficient() == 1) {
                    piAmount = piAmount.add(record2.getLocalAmount().multiply(GlUtils.one).multiply(direction));
                    piRptAmount = piRptAmount.add(record2.getReportingAmount().multiply(GlUtils.one).multiply(direction));
                    piOrgAmount = piOrgAmount.add(record2.getOriginalAmount().multiply(GlUtils.one).multiply(direction));
                } else {
                    piAmount = piAmount.add(record2.getLocalAmount().multiply(GlUtils.negone).multiply(direction));
                    piRptAmount = piRptAmount.add(record2.getReportingAmount().multiply(GlUtils.negone).multiply(direction));
                    piOrgAmount = piOrgAmount.add(record2.getOriginalAmount().multiply(GlUtils.negone).multiply(direction));
                }
                if (!CashFlowUtils.isDealActivity(record2.getPrimaryItem(), cfDif)) continue;
                if (record2.getPrimaryCoefficient() == 1) {
                    daAmount = daAmount.add(record2.getLocalAmount().multiply(GlUtils.one).multiply(direction));
                    daRptAmount = daRptAmount.add(record2.getReportingAmount().multiply(GlUtils.one).multiply(direction));
                    continue;
                }
                daAmount = daAmount.add(record2.getLocalAmount().multiply(GlUtils.negone).multiply(direction));
                daRptAmount = daRptAmount.add(record2.getReportingAmount().multiply(GlUtils.negone).multiply(direction));
                continue;
            }
            if (ItemFlag.BOTH.equals((Object)record2.getItemFlag())) {
                BigDecimal bigDecimal = direction = CashFlowDirection.IN.equals((Object)record2.getPrimaryItem().getDirection()) ? GlUtils.one : GlUtils.negone;
                if (record2.getPrimaryCoefficient() == 1) {
                    piAmount = piAmount.add(record2.getLocalAmount().multiply(GlUtils.one).multiply(direction));
                    piRptAmount = piRptAmount.add(record2.getReportingAmount().multiply(GlUtils.one).multiply(direction));
                    piOrgAmount = piOrgAmount.add(record2.getOriginalAmount().multiply(GlUtils.one).multiply(direction));
                } else {
                    piAmount = piAmount.add(record2.getLocalAmount().multiply(GlUtils.negone).multiply(direction));
                    piRptAmount = piRptAmount.add(record2.getReportingAmount().multiply(GlUtils.negone).multiply(direction));
                    piOrgAmount = piOrgAmount.add(record2.getOriginalAmount().multiply(GlUtils.negone).multiply(direction));
                }
                if (record2.getSupplementaryCoefficient() == 1) {
                    siAmount = siAmount.add(record2.getLocalAmount().multiply(GlUtils.one));
                    siRptAmount = siRptAmount.add(record2.getReportingAmount().multiply(GlUtils.one));
                } else {
                    siAmount = siAmount.add(record2.getLocalAmount().multiply(GlUtils.negone));
                    siRptAmount = siRptAmount.add(record2.getReportingAmount().multiply(GlUtils.negone));
                }
                if (!CashFlowUtils.isDealActivity(record2.getPrimaryItem(), cfDif)) continue;
                if (record2.getPrimaryCoefficient() == 1) {
                    daAmount = daAmount.add(record2.getLocalAmount().multiply(GlUtils.one).multiply(direction));
                    daRptAmount = daRptAmount.add(record2.getReportingAmount().multiply(GlUtils.one).multiply(direction));
                    continue;
                }
                daAmount = daAmount.add(record2.getLocalAmount().multiply(GlUtils.negone).multiply(direction));
                daRptAmount = daRptAmount.add(record2.getReportingAmount().multiply(GlUtils.negone).multiply(direction));
                continue;
            }
            if (ItemFlag.SUPPLEMENTARY.equals((Object)record2.getItemFlag())) {
                if (record2.getSupplementaryCoefficient() == 1) {
                    siAmount = siAmount.add(record2.getLocalAmount().multiply(GlUtils.one));
                    siRptAmount = siRptAmount.add(record2.getReportingAmount().multiply(GlUtils.one));
                    continue;
                }
                siAmount = siAmount.add(record2.getLocalAmount().multiply(GlUtils.negone));
                siRptAmount = siRptAmount.add(record2.getReportingAmount().multiply(GlUtils.negone));
                continue;
            }
            if (!ItemFlag.DISPOSE.equals((Object)record2.getItemFlag())) continue;
            if (EntryDC.DEBIT.equals((Object)record2.getEntryDC())) {
                if (record2.isIsSupItem()) {
                    diposeSupItemDebitAmount = diposeSupItemDebitAmount.add(record2.getLocalAmount());
                    continue;
                }
                diposeDebitAmount = diposeDebitAmount.add(record2.getLocalAmount());
                continue;
            }
            if (record2.isIsSupItem()) {
                diposeSupItemCreditAmount = diposeSupItemCreditAmount.add(record2.getLocalAmount());
                continue;
            }
            diposeCreditAmount = diposeCreditAmount.add(record2.getLocalAmount());
        }
        if (diposeDebitAmount.compareTo(diposeCreditAmount) != 0 || diposeSupItemDebitAmount.compareTo(diposeSupItemCreditAmount) != 0) {
            throw new VoucherException(VoucherException.CF_DIPOSE_NOT_BALANCE);
        }
        if (mustPI && piAmount.compareTo(cashAmount) != 0) {
            throw new VoucherException(VoucherException.PI_NOT_CORRECT, new Object[]{cashAmount.toPlainString(), piAmount.toPlainString()});
        }
        if (mustBoth && siAmount.compareTo(daAmount.subtract(netProfitAmount)) != 0) {
            throw new VoucherException(VoucherException.SI_NOT_CORRECT, new Object[]{daAmount.subtract(netProfitAmount).toPlainString(), siAmount.toPlainString()});
        }
        boolean isForeign = sysParam.getBoolean("GL_008");
        if (isUseReport && !isForeign) {
            boolean enableAutoBalanceCFRpt = "true".equals(voucherInfo.get("enableAutoBalanceCFRpt") == null ? "false" : voucherInfo.get("enableAutoBalanceCFRpt").toString());
            if (!enableAutoBalanceCFRpt) {
                if (mustPI && piRptAmount.compareTo(cashRptAmount) != 0) {
                    throw new VoucherException(VoucherException.PI_NOT_CORRECT, new Object[]{cashRptAmount.toPlainString(), piRptAmount.toPlainString()});
                }
                if (mustBoth && siRptAmount.compareTo(daRptAmount.subtract(netProfitRptAmount)) != 0) {
                    throw new VoucherException(VoucherException.SI_NOT_CORRECT, new Object[]{daRptAmount.subtract(netProfitRptAmount).toPlainString(), siRptAmount.toPlainString()});
                }
            } else {
                SubmitVoucherServiceHelper.autoBalanceCFRpt(cfCol, voucherInfo, piRptAmount, cashRptAmount, daRptAmount, netProfitRptAmount, siRptAmount, mustPI, mustBoth, cfDif);
                voucherInfo.remove("enableAutoBalanceCFRpt");
                SubmitVoucherServiceHelper.compareAmount(ctx, cfCol, entryColl, mustPI, mustBoth, sysParam, voucherInfo);
            }
        }
    }

    private static void autoBalanceCFRpt(CashflowRecordCollection cfCol, VoucherInfo voucherInfo, BigDecimal piRptAmount, BigDecimal cashRptAmount, BigDecimal daRptAmount, BigDecimal netProfitRptAmount, BigDecimal siRptAmount, boolean mustPI, boolean mustBoth, Map cfDif) throws VoucherException, GLException {
        ItemFlag itemFlag;
        CurrencyInfo rptCur = voucherInfo.getCompany().getReportCurrency();
        CurrencyInfo locCur = voucherInfo.getCompany().getBaseCurrency();
        if (rptCur == null) {
            throw new GLException(GLException.NOREPORTINGCUR);
        }
        if (locCur == null) {
            throw new GLException(GLException.NOLOCALCUR);
        }
        CashflowRecordInfo maxRecordInfo = null;
        BigDecimal cashDiffAmount = null;
        if (mustPI && piRptAmount.compareTo(cashRptAmount) != 0) {
            cashDiffAmount = cashRptAmount.subtract(piRptAmount);
            for (int i = 0; i < cfCol.size(); ++i) {
                CashflowRecordInfo recordInfo = cfCol.get(i);
                itemFlag = recordInfo.getItemFlag();
                CashFlowItemInfo primaryItem = recordInfo.getPrimaryItem();
                if (itemFlag.equals((Object)ItemFlag.DISPOSE) || primaryItem == null) continue;
                if (recordInfo.getReportingAmount() == null) {
                    maxRecordInfo = null;
                    break;
                }
                if (!itemFlag.equals((Object)ItemFlag.BOTH) && !itemFlag.equals((Object)ItemFlag.PRIMARY)) continue;
                maxRecordInfo = maxRecordInfo == null ? recordInfo : (recordInfo.getReportingAmount().abs().compareTo(maxRecordInfo.getReportingAmount().abs()) > 0 ? recordInfo : maxRecordInfo);
            }
            if (maxRecordInfo != null) {
                BigDecimal direction;
                CashFlowItemInfo primaryItem = maxRecordInfo.getPrimaryItem();
                BigDecimal bigDecimal = direction = CashFlowDirection.IN.equals((Object)primaryItem.getDirection()) ? GlUtils.one : GlUtils.negone;
                if (maxRecordInfo.getPrimaryCoefficient() == 1) {
                    maxRecordInfo.setReportingAmount(maxRecordInfo.getReportingAmount().add(cashDiffAmount.multiply(direction)));
                } else {
                    maxRecordInfo.setReportingAmount(maxRecordInfo.getReportingAmount().add(cashDiffAmount.multiply(GlUtils.negone).multiply(direction)));
                }
            } else {
                throw new VoucherException(VoucherException.PI_NOT_CORRECT, new Object[]{cashRptAmount.toPlainString(), piRptAmount.toPlainString()});
            }
        }
        if (mustBoth && siRptAmount.compareTo(daRptAmount.subtract(netProfitRptAmount)) != 0) {
            if (cashDiffAmount != null && cashDiffAmount.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal direction = CashFlowDirection.IN.equals((Object)maxRecordInfo.getPrimaryItem().getDirection()) ? GlUtils.one : GlUtils.negone;
                BigDecimal amount = maxRecordInfo.getPrimaryCoefficient() == 1 ? cashDiffAmount.multiply(direction) : cashDiffAmount.multiply(direction).negate();
                itemFlag = maxRecordInfo.getItemFlag();
                if (itemFlag.equals((Object)ItemFlag.BOTH)) {
                    if (CashFlowUtils.isPL(maxRecordInfo.getOppAccount(), cfDif) && !CashFlowUtils.isDealActivity(maxRecordInfo.getPrimaryItem(), cfDif)) {
                        siRptAmount = siRptAmount.add(maxRecordInfo.getSupplementaryCoefficient() == 1 ? amount : amount.negate());
                    } else {
                        siRptAmount = siRptAmount.add(maxRecordInfo.getSupplementaryCoefficient() == 1 ? amount : amount.negate());
                        daRptAmount = daRptAmount.add(amount);
                    }
                } else if (itemFlag.equals((Object)ItemFlag.PRIMARY) && CashFlowUtils.isPL(maxRecordInfo.getOppAccount()) && CashFlowUtils.isDealActivity(maxRecordInfo.getPrimaryItem(), cfDif)) {
                    daRptAmount = daRptAmount.add(amount);
                }
            }
            BigDecimal diffAmount = daRptAmount.subtract(netProfitRptAmount).subtract(siRptAmount);
            for (int i = 0; i < cfCol.size(); ++i) {
                CashflowRecordInfo recordInfo = cfCol.get(i);
                ItemFlag itemFlag2 = recordInfo.getItemFlag();
                CashFlowItemInfo supplementaryItem = recordInfo.getSupplementaryItem();
                if (itemFlag2.equals((Object)ItemFlag.DISPOSE) || supplementaryItem == null) continue;
                if (recordInfo.getReportingAmount() == null) {
                    maxRecordInfo = null;
                    break;
                }
                if (!itemFlag2.equals((Object)ItemFlag.SUPPLEMENTARY)) continue;
                maxRecordInfo = maxRecordInfo == null ? recordInfo : (recordInfo.getReportingAmount().abs().compareTo(maxRecordInfo.getReportingAmount().abs()) > 0 ? recordInfo : maxRecordInfo);
            }
            if (maxRecordInfo != null) {
                maxRecordInfo.setReportingAmount(maxRecordInfo.getReportingAmount().add(maxRecordInfo.getSupplementaryCoefficient() == 1 ? diffAmount : diffAmount.negate()));
            } else {
                throw new VoucherException(VoucherException.SI_NOT_CORRECT, new Object[]{daRptAmount.subtract(netProfitRptAmount).toPlainString(), siRptAmount.toPlainString()});
            }
        }
    }

    private String getStr(Context ctx, String id) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLPeriodEndResource", (String)id, (Locale)ctx.getLocale());
    }

    private static void savePLCashflow(Context ctx, Connection conn, VoucherInfo voucherInfo, boolean splitByOpposite) throws EASBizException, BOSException {
        CashflowRecordCollection cashflowRecordCollection = (CashflowRecordCollection)voucherInfo.getCashflowRecords();
        if (cashflowRecordCollection.size() > 0) {
            UserInfo curUser = new UserInfo();
            curUser.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            Timestamp curTime = SubmitVoucherServiceHelper.getCurrentTime();
            IORMappingDAO iCashflowRecord = ORMappingDAO.getInstance((BOSObjectType)new CashflowRecordInfo().getBOSType(), (Context)ctx, (Connection)conn);
            Iterator iteratorCF = cashflowRecordCollection.iterator();
            while (iteratorCF.hasNext()) {
                CashflowRecordInfo cashflowRecordInfo = (CashflowRecordInfo)iteratorCF.next();
                if (cashflowRecordInfo.getItemFlag() == ItemFlag.PRIMARY || cashflowRecordInfo.getItemFlag() == ItemFlag.BOTH || cashflowRecordInfo.getPrimaryItem() != null) {
                    iteratorCF.remove();
                    continue;
                }
                cashflowRecordInfo.setVoucher(voucherInfo);
                cashflowRecordInfo.setId(null);
                cashflowRecordInfo.setCreator(curUser);
                cashflowRecordInfo.setLastUpdateUser(curUser);
                cashflowRecordInfo.setCreateTime(curTime);
                cashflowRecordInfo.setLastUpdateTime(curTime);
                iCashflowRecord.addNewBatch((IObjectValue)cashflowRecordInfo);
            }
            iCashflowRecord.executeBatch();
        }
        ITAccountSplitStrategy plSplitStrategy = TAccountSplitStrategyFactory.getSplitStrategy(cashflowRecordCollection.size() == 0 && splitByOpposite ? "byOpposite" : "pl");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("cashflowRecords", cashflowRecordCollection);
        CashflowSplitRecordCollection splitColl = plSplitStrategy.split(ctx, voucherInfo, params);
        if (splitColl.size() > 0) {
            CashflowSplitRecordFactory.getLocalInstance(ctx).addBatch((IObjectCollection)splitColl);
        }
    }

    private static Timestamp getCurrentTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        return new Timestamp(d.getTime().getTime());
    }
}

