/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AdjRateVoucherRefFactory;
import com.kingdee.eas.fi.gl.AdjRateVoucherRefInfo;
import com.kingdee.eas.fi.gl.AdjustExchangeRateInfo;
import com.kingdee.eas.fi.gl.AutoTransInfo;
import com.kingdee.eas.fi.gl.AutoTransVoucherRefFactory;
import com.kingdee.eas.fi.gl.AutoTransVoucherRefInfo;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.ComparisonDetailInfo;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReqStatus;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherPersistence;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class VoucherPersistence
implements IVoucherPersistence {
    protected static final Logger logger = Logger.getLogger(VoucherPersistence.class);
    protected GlParam sysParam;
    private int entryCount;
    private int asstCount;

    public VoucherPersistence(GlParam sysParam) throws BOSException {
        this.sysParam = sysParam;
    }

    @Override
    public IObjectPK persistVoucher(Context ctx, BaseVoucherInfo baseVoucherInfo) throws BOSException, EASBizException {
        VoucherInfo voucherInfo = (VoucherInfo)baseVoucherInfo;
        if (voucherInfo.getEntryCount() > 0) {
            voucherInfo.setVoucherAbstract(voucherInfo.getEntries().get(0).getDescription());
        }
        if (voucherInfo.getSourceType().equals((Object)SourceType.PROFIT_AND_LOSS)) {
            voucherInfo.setIsMgCtrl(false);
        }
        this.calStandardQuantity(ctx, voucherInfo);
        if (voucherInfo.getNumber() == null || "".equals(voucherInfo.getNumber().trim())) {
            throw new VoucherException(VoucherException.NO_VOUCHERNUMBER);
        }
        return this.saveVoucher(ctx, voucherInfo);
    }

    private void calStandardQuantity(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        boolean useQtyAsst = this.sysParam.getBoolean("G010");
        if (voucherInfo.getEntries() != null && voucherInfo.getSourceType() != SourceType.PROFIT_AND_LOSS && voucherInfo.getSourceType() != SourceType.ACCOUNTADJUST) {
            IMeasureUnit iMeasureUnit = null;
            for (VoucherEntryInfo entryInfo : voucherInfo.getEntries()) {
                Iterator iteratorAssist;
                AccountViewInfo account = entryInfo.getAccount();
                if (account == null) continue;
                if (account.isIsQty() && (entryInfo.getCAA() == null || !useQtyAsst)) {
                    iMeasureUnit = this.calEntryStandardQuantity(ctx, entryInfo, iMeasureUnit);
                    continue;
                }
                if (useQtyAsst && entryInfo.getCAA() != null && account.isIsQty() && entryInfo.getCAA().isIsQty()) {
                    iteratorAssist = entryInfo.getAssistRecords().iterator();
                    BigDecimal entryStandQty = new BigDecimal("0.0");
                    while (iteratorAssist.hasNext()) {
                        VoucherAssistRecordInfo recordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
                        iMeasureUnit = this.calAssistRecordStandardQuantity(ctx, recordInfo, iMeasureUnit);
                        if (recordInfo.getStandardQuantity() == null) continue;
                        entryStandQty = entryStandQty.add(recordInfo.getStandardQuantity());
                    }
                    entryInfo.setStandardQuantity(entryStandQty);
                    continue;
                }
                if (!account.isIsQty()) {
                    this.clearEntryQuantity(entryInfo);
                    continue;
                }
                if (!account.isIsQty() || entryInfo.getCAA() == null || entryInfo.getCAA().isIsQty()) continue;
                iteratorAssist = entryInfo.getAssistRecords().iterator();
                while (iteratorAssist.hasNext()) {
                    this.clearAssistRecordQuantity((VoucherAssistRecordInfo)iteratorAssist.next());
                }
            }
        }
    }

    private void clearEntryQuantity(VoucherEntryInfo entryInfo) {
        entryInfo.setMeasureUnit(null);
        entryInfo.setQuantity(GlUtils.zero);
        entryInfo.setStandardQuantity(GlUtils.zero);
        if (entryInfo.getCAA() != null && !entryInfo.getCAA().isIsQty()) {
            Iterator iteratorAssist = entryInfo.getAssistRecords().iterator();
            while (iteratorAssist.hasNext()) {
                this.clearAssistRecordQuantity((VoucherAssistRecordInfo)iteratorAssist.next());
            }
        }
    }

    private void clearAssistRecordQuantity(VoucherAssistRecordInfo recordInfo) {
        recordInfo.setMeasureUnit(null);
        recordInfo.setAssistUnit(null);
        recordInfo.setQuantity(GlUtils.zero);
        recordInfo.setAssistQty(GlUtils.zero);
        recordInfo.setStandardQuantity(GlUtils.zero);
    }

    private IMeasureUnit calAssistRecordStandardQuantity(Context ctx, VoucherAssistRecordInfo recordInfo, IMeasureUnit iMeasureUnit) throws BOSException, EASBizException {
        MeasureUnitInfo measure = recordInfo.getMeasureUnit();
        if (measure != null) {
            BOSUuid measureId = measure.getId();
            BigDecimal coefficient = measure.getCoefficient();
            if (coefficient == null) {
                if (iMeasureUnit == null) {
                    iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
                }
                coefficient = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureId)).getCoefficient();
            }
            if (recordInfo.getQuantity() != null && coefficient != null) {
                recordInfo.setStandardQuantity(recordInfo.getQuantity().multiply(coefficient));
            }
        }
        return iMeasureUnit;
    }

    private IMeasureUnit calEntryStandardQuantity(Context ctx, VoucherEntryInfo entryInfo, IMeasureUnit iMeasureUnit) throws BOSException, EASBizException {
        MeasureUnitInfo measure = entryInfo.getMeasureUnit();
        if (measure != null) {
            BOSUuid measureId = measure.getId();
            BigDecimal coefficient = measure.getCoefficient();
            if (coefficient == null) {
                if (iMeasureUnit == null) {
                    iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
                }
                coefficient = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureId)).getCoefficient();
            }
            if (entryInfo.getQuantity() != null && coefficient != null) {
                entryInfo.setStandardQuantity(entryInfo.getQuantity().multiply(coefficient));
            }
        }
        return iMeasureUnit;
    }

    private IObjectPK saveVoucher(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        IObjectPK voucherPK;
        boolean isNew;
        boolean bl = isNew = !GlUtils.isExisted(ctx, voucherInfo);
        if (!isNew) {
            VoucherUtil._deleteAllAssistRecords(ctx, voucherInfo);
            VoucherUtil._deleteAllEntries(ctx, voucherInfo);
        }
        if (isNew) {
            voucherPK = VoucherFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)voucherInfo);
            voucherInfo.put("id", voucherPK.getKeyValue("id"));
            this.saveAutoTransVoucherRef(ctx, voucherInfo);
            this.saveAdjRateVoucherRef(ctx, voucherInfo);
            this.saveImportKey(ctx, voucherInfo, voucherPK.toString());
            this.saveComparisonDetail(ctx, voucherInfo);
        } else {
            voucherPK = new ObjectUuidPK(voucherInfo.getId());
            if (!voucherInfo.getBoolean("isSSC") || !GlUtils.isRunningWorkflow(ctx, voucherInfo.getId().toString())) {
                voucherInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            } else {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("creator.id"));
                VoucherInfo oldVch = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue(voucherPK, selector);
                voucherInfo.setCreator(oldVch.getCreator());
            }
            VoucherFactory.getLocalInstance((Context)ctx).update(voucherPK, (CoreBaseInfo)voucherInfo);
        }
        this.saveVoucherEntry(ctx, voucherInfo, isNew);
        return voucherPK;
    }

    private void saveComparisonDetail(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        ComparisonDetailInfo comparisonDetailInfo = (ComparisonDetailInfo)voucherInfo.get("comparisonDetail");
        if (comparisonDetailInfo != null) {
            comparisonDetailInfo.setEasId(voucherInfo.getId().toString());
            comparisonDetailInfo.setBosType("2652E01E");
            GlUtils.saveComparisonDetail(ctx, comparisonDetailInfo);
        }
    }

    private void saveAutoTransVoucherRef(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        String autoTransId = (String)voucherInfo.get("autoTransId");
        if (autoTransId != null) {
            AutoTransVoucherRefInfo refInfo = new AutoTransVoucherRefInfo();
            AutoTransInfo autoTransInfo = new AutoTransInfo();
            autoTransInfo.setId(BOSUuid.read((String)autoTransId));
            refInfo.setAutotrans(autoTransInfo);
            refInfo.setVoucher(voucherInfo);
            refInfo.setCompany(voucherInfo.getCompany());
            refInfo.setPeriod(voucherInfo.getPeriod());
            AutoTransVoucherRefFactory.getLocalInstance(ctx).addnew(refInfo);
        }
    }

    private void saveAdjRateVoucherRef(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        String adjRateId = (String)voucherInfo.get("adjRateId");
        if (adjRateId != null) {
            AdjRateVoucherRefInfo refInfo = new AdjRateVoucherRefInfo();
            AdjustExchangeRateInfo adjInfo = new AdjustExchangeRateInfo();
            adjInfo.setId(BOSUuid.read((String)adjRateId));
            refInfo.setAdjustExchangeRate(adjInfo);
            refInfo.setVoucher(voucherInfo);
            refInfo.setCompany(voucherInfo.getCompany());
            refInfo.setPeriod(voucherInfo.getPeriod());
            AdjRateVoucherRefFactory.getLocalInstance(ctx).addnew(refInfo);
        }
    }

    private void saveVoucherEntry(Context ctx, VoucherInfo voucherInfo, boolean isNew) throws BOSException {
        Connection conn = null;
        try {
            this.entryCount = 0;
            this.asstCount = 0;
            logger.error((Object)("zmy:voucherId:" + voucherInfo.getId() != null ? voucherInfo.getId().toString() : "nullVoucherId"));
            conn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO iVoucherEntry = ORMappingDAO.getInstance((BOSObjectType)new VoucherEntryInfo().getBOSType(), (Context)ctx, (Connection)conn);
            IORMappingDAO iVoucherAssistRecord = ORMappingDAO.getInstance((BOSObjectType)new VoucherAssistRecordInfo().getBOSType(), (Context)ctx, (Connection)conn);
            Iterator iteratorEntry = voucherInfo.getEntries().iterator();
            VoucherEntryInfo voucherEntryInfo = null;
            while (iteratorEntry.hasNext()) {
                ++this.entryCount;
                voucherEntryInfo = (VoucherEntryInfo)iteratorEntry.next();
                voucherEntryInfo.setCompany(voucherInfo.getCompany());
                voucherEntryInfo.setPeriod(voucherInfo.getPeriod());
                if (voucherEntryInfo.getLocalAmount() == null) {
                    voucherEntryInfo.setLocalAmount(GlUtils.zero);
                }
                if (voucherEntryInfo.getQuantity() == null) {
                    voucherEntryInfo.setQuantity(GlUtils.zero);
                }
                if (voucherEntryInfo.getId() == null) {
                    if (voucherEntryInfo.get("entryid") == null) {
                        voucherEntryInfo.put("id", (Object)BOSUuid.create((BOSObjectType)voucherEntryInfo.getBOSType()));
                    } else {
                        voucherEntryInfo.put("id", voucherEntryInfo.get("entryid"));
                    }
                }
                voucherEntryInfo.setBill(voucherInfo);
                iVoucherEntry.addNewBatch((IObjectValue)voucherEntryInfo);
                if (this.entryCount % 2000 == 0) {
                    iVoucherEntry.executeBatch();
                }
                this.saveVoucherAssistRecord(voucherInfo, voucherEntryInfo, iVoucherAssistRecord, isNew);
            }
            iVoucherEntry.executeBatch();
            iVoucherAssistRecord.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private void saveVoucherAssistRecord(VoucherInfo voucherInfo, VoucherEntryInfo voucherEntryInfo, IORMappingDAO iVoucherAssistRecord, boolean isNew) throws BOSException {
        if (voucherEntryInfo.getAccount() == null || voucherEntryInfo.getCAA() == null && !voucherEntryInfo.getAccount().isHasUserProperty()) {
            return;
        }
        VoucherAssistRecordInfo voucherAssistRecordInfo = null;
        Iterator iteratorAssist = voucherEntryInfo.getAssistRecords().iterator();
        while (iteratorAssist.hasNext()) {
            ++this.asstCount;
            voucherAssistRecordInfo = (VoucherAssistRecordInfo)iteratorAssist.next();
            voucherAssistRecordInfo.setReqStatus(ReqStatus.NONE);
            voucherAssistRecordInfo.setCompany(voucherInfo.getCompany());
            voucherAssistRecordInfo.setPeriod(voucherInfo.getPeriod());
            voucherAssistRecordInfo.setAccount(voucherEntryInfo.getAccount());
            voucherAssistRecordInfo.setEntry(voucherEntryInfo);
            voucherAssistRecordInfo.setBill(voucherInfo);
            if (voucherAssistRecordInfo.getId() == null) {
                voucherAssistRecordInfo.put("id", (Object)BOSUuid.create((BOSObjectType)voucherAssistRecordInfo.getBOSType()));
            }
            voucherAssistRecordInfo.setBill(voucherInfo);
            voucherAssistRecordInfo.setEntry(voucherEntryInfo);
            iVoucherAssistRecord.addNewBatch((IObjectValue)voucherAssistRecordInfo);
            if (this.asstCount % 2000 != 0) continue;
            iVoucherAssistRecord.executeBatch();
        }
    }

    private void saveImportKey(Context ctx, VoucherInfo voucherInfo, String voucherId) throws BOSException {
        String importKey = voucherInfo.getString("importKey");
        if (importKey != null && importKey.trim().length() > 0) {
            String sql = "insert into T_GL_VoucherImportKey (FVoucherID, FImportKey) values (?, ?)";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{voucherId, importKey.trim()});
        }
    }
}

