/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.VoucherUtil;
import com.kingdee.eas.fi.gl.app.voucher.AntiAuditStandardVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AntiCancelReverseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AntiCancelStandardVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AntiCancelVoucherCollectionService;
import com.kingdee.eas.fi.gl.app.voucher.AntiCheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.AntiPostStandardVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.CancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.CheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.DeleteAmortizationVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.DeleteAmortizeSchemeVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.DeleteReverseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.DeleteVoucherCollectionService;
import com.kingdee.eas.fi.gl.app.voucher.DeleteVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiAuditVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiCancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiCheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IAntiPostVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ICancelVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ICheckVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IDeleteVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.IPostVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ISubmitVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.ITransactVoucherColService;
import com.kingdee.eas.fi.gl.app.voucher.PostAccountComparisonVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.PostStandardVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.PostVoucherCollectionService;
import com.kingdee.eas.fi.gl.app.voucher.SubmitAdjustVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.SubmitAmortizeSchemeVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.SubmitReverseVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.SubmitStandradVoucherService;
import com.kingdee.eas.fi.gl.app.voucher.SubmitVoucherCollectionService;

public class VoucherServiceFactory {
    public static ISubmitVoucherService getSubmitVoucherService(Context ctx, VoucherInfo voucherInfo) throws BOSException {
        if (voucherInfo.isIsReverseVoucher()) {
            return new SubmitReverseVoucherService(ctx);
        }
        if (SourceType.ADJUST.equals((Object)voucherInfo.getSourceType())) {
            return new SubmitAdjustVoucherService(ctx);
        }
        if (SourceType.AUTO_AMORTIZE.equals((Object)voucherInfo.getSourceType())) {
            return new SubmitAmortizeSchemeVoucherService(ctx);
        }
        return new SubmitStandradVoucherService(ctx);
    }

    public static IAntiCancelVoucherService getAntiCancelVoucherService(Context ctx, VoucherInfo voucherInfo) throws BOSException {
        if (voucherInfo.isIsReverseVoucher()) {
            return new AntiCancelReverseVoucherService(ctx);
        }
        return new AntiCancelStandardVoucherService(ctx);
    }

    public static IPostVoucherService getPostVoucherService(Context ctx, VoucherInfo voucherInfo) throws BOSException {
        if (SourceType.ACCOUNTADJUST.equals((Object)voucherInfo.getSourceType())) {
            return new PostAccountComparisonVoucherService(ctx);
        }
        return new PostStandardVoucherService(ctx);
    }

    public static IAntiPostVoucherService getAntiPostVoucherService(Context ctx) throws BOSException {
        return new AntiPostStandardVoucherService(ctx);
    }

    public static IDeleteVoucherService getDeleteVoucherService(Context ctx, VoucherInfo voucherInfo) throws BOSException {
        if (voucherInfo.isIsReverseVoucher()) {
            return new DeleteReverseVoucherService(ctx);
        }
        if (VoucherUtil.isAmortVoucher(voucherInfo)) {
            return new DeleteAmortizationVoucherService(ctx);
        }
        if (SourceType.AUTO_AMORTIZE.equals((Object)voucherInfo.getSourceType())) {
            return new DeleteAmortizeSchemeVoucherService(ctx);
        }
        return new DeleteVoucherService(ctx);
    }

    public static ITransactVoucherColService getSubmitVoucherCollectionService() {
        return new SubmitVoucherCollectionService();
    }

    public static ITransactVoucherColService getAntiCancelVoucherCollectionService() {
        return new AntiCancelVoucherCollectionService();
    }

    public static ITransactVoucherColService getDeleteVoucherCollectionService() {
        return new DeleteVoucherCollectionService();
    }

    public static ITransactVoucherColService getPostVoucherCollectionService() {
        return new PostVoucherCollectionService();
    }

    public static IAntiAuditVoucherService getAntiAuditVoucherService(Context ctx) throws BOSException {
        return new AntiAuditStandardVoucherService(ctx);
    }

    public static ICancelVoucherService getCancelVoucherService(Context ctx) throws BOSException {
        return new CancelVoucherService(ctx);
    }

    public static IAntiCheckVoucherService getAntiCheckVoucherService(Context ctx) throws BOSException {
        return new AntiCheckVoucherService(ctx);
    }

    public static ICheckVoucherService getCheckVoucherService(Context ctx) throws BOSException {
        return new CheckVoucherService(ctx);
    }
}

