/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffInfo;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityCollection;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityInfo;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActTypeDefault;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowUtils;
import com.kingdee.eas.fi.gl.CashflowFlag;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowSplitRecordCollection;
import com.kingdee.eas.fi.gl.CashflowSplitRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherSubmitCashFlowAuto {
    private static final Logger logger = Logger.getLogger(VoucherSubmitCashFlowAuto.class);
    private static String resClassName = "com.kingdee.eas.fi.gl.GLResource";

    public static CashflowRecordCollection toCashflowRecordCollection(Context ctx, VoucherInfo voucher, CashflowSplitRecordCollection priSplitColl, CashflowSplitRecordCollection supSplitColl, GlParam sysParam) throws EASBizException, BOSException {
        Map difference = VoucherSubmitCashFlowAuto.getCashflowDifference(ctx, voucher.getCompany().getId().toString());
        CashflowRecordCollection coll = new CashflowRecordCollection();
        boolean mustInputBothItem = sysParam.getBoolean("GL_015");
        boolean useRptCurrency = sysParam.getBoolean("G001");
        boolean hasPrimaryRecord = false;
        HashMap atMap = new HashMap();
        Map allDif = VoucherProcessCache.getDifference(ctx, voucher.getCompany().getId().toString());
        int seq = 1;
        boolean isSimpleMode = sysParam.getInt("GL_0152") == 0;
        HashMap hmDynamicColumnInfo = new HashMap();
        HashMap hmDynamicDatabaseInfo = new HashMap();
        HashMap hmPrimaryAssGrpInfo = new HashMap();
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        Timestamp createtime = VoucherSubmitCashFlowAuto.getTime();
        for (CashflowSplitRecordInfo splitRecord : priSplitColl) {
            VoucherEntryInfo oppEntry = splitRecord.getOpposingAccountEntry();
            VoucherEntryInfo entry = splitRecord.getEntry();
            CashflowRecordInfo record = new CashflowRecordInfo();
            record.setCreator(userInfo);
            record.setCreateTime(createtime);
            record.setLastUpdateUser(userInfo);
            record.setLastUpdateTime(createtime);
            record.setSeq(seq++);
            record.setVoucher(voucher);
            record.setEntry(entry);
            record.setAccount(entry.getAccount());
            record.setCurrency(entry.getCurrency());
            record.setEntryDC(entry.getEntryDC());
            record.setOpposingAccountEntry(oppEntry);
            record.setOppAccount(oppEntry.getAccount());
            record.setOppEntryDC(oppEntry.getEntryDC());
            if (splitRecord.getOppVoucherAssistRecord() != null) {
                record.setOppVoucherAssistRecord(splitRecord.getOppVoucherAssistRecord());
                record.setOppAssGrp(splitRecord.getOppAssGrp());
            }
            record.setOriginalAmount(splitRecord.getOriginalAmount());
            record.setLocalAmount(splitRecord.getLocalAmount());
            record.setReportingAmount(splitRecord.getReportingAmount());
            if (ItemFlag.DISPOSE.equals((Object)splitRecord.getItemFlag())) {
                record.setSupplementaryItem(null);
                record.setSupplementaryCoefficient(0);
                record.setItemFlag(ItemFlag.DISPOSE);
                record.setIsSupItem(false);
                record.setPrimaryItem(null);
                record.setPrimaryCoefficient(0);
                coll.add(record);
                continue;
            }
            boolean isDebit = oppEntry.getEntryDC().equals((Object)EntryDC.DEBIT);
            CashFlowItemInfo primaryItem = null;
            primaryItem = isDebit ? oppEntry.getAccount().getBorrowerMainCashFlowItem() : oppEntry.getAccount().getLenderMainCashFlowItem();
            if (record.getOppVoucherAssistRecord() != null && record.getOppVoucherAssistRecord().getPrimaryItem() != null) {
                primaryItem = record.getOppVoucherAssistRecord().getPrimaryItem();
            } else if (oppEntry.getPrimaryItem() != null) {
                primaryItem = oppEntry.getPrimaryItem();
            }
            if (primaryItem != null && primaryItem.getType() != CashFlowItemType.MASTER_TABLE_ITEM) {
                primaryItem = null;
            }
            record.setPrimaryItem(primaryItem);
            record.setSupplementaryItem(null);
            record.setSupplementaryCoefficient(0);
            record.setItemFlag(ItemFlag.PRIMARY);
            record.setIsSupItem(false);
            if (primaryItem != null) {
                Object[] asstInfo;
                hasPrimaryRecord = true;
                CashFlowDirection direction = primaryItem.getDirection();
                if (EntryDC.DEBIT.equals((Object)entry.getEntryDC()) && CashFlowDirection.OUT.equals((Object)direction) || EntryDC.CREDIT.equals((Object)entry.getEntryDC()) && CashFlowDirection.IN.equals((Object)direction)) {
                    record.setPrimaryCoefficient(-1);
                } else {
                    record.setPrimaryCoefficient(1);
                }
                record.setType(CashflowTypeEnum.OUT);
                if (primaryItem.isIsEnable() && primaryItem.getAsstAccount() != null && primaryItem.getAsstAccount().getId() != null && oppEntry.getCAA() != null && oppEntry.getCAA().getId() != null && (asstInfo = VoucherSubmitCashFlowAuto.getCachedColumnInfo(ctx, hmDynamicColumnInfo, oppEntry.getCAA().getId().toString())) != null && record.getOppAssGrp() != null) {
                    VoucherInfo.DynamicColumnInfo[] asstItemCols = (VoucherInfo.DynamicColumnInfo[])asstInfo[0];
                    Object[] cfiInfo = VoucherSubmitCashFlowAuto.getCachedColumnInfo(ctx, hmDynamicColumnInfo, primaryItem.getAsstAccount().getId().toString());
                    VoucherInfo.DynamicColumnInfo[] cfiItemCols = (VoucherInfo.DynamicColumnInfo[])cfiInfo[0];
                    VoucherSubmitCashFlowAuto.autoSetActTypeValue(ctx, hmDynamicDatabaseInfo, record, record.getOppAssGrp().getId().toString(), asstItemCols, primaryItem.getAsstAccount(), cfiItemCols, isSimpleMode);
                }
                if (primaryItem.isIsEnable() && primaryItem.getAsstAccount() != null && primaryItem.getAsstAccount().getId() != null && oppEntry.getCAA() == null) {
                    Object[] cfiInfo = VoucherSubmitCashFlowAuto.getCachedColumnInfo(ctx, hmDynamicColumnInfo, primaryItem.getAsstAccount().getId().toString());
                    VoucherInfo.DynamicColumnInfo[] cfiItemCols = (VoucherInfo.DynamicColumnInfo[])cfiInfo[0];
                    VoucherSubmitCashFlowAuto.autoSetActTypeValue(ctx, hmPrimaryAssGrpInfo, record, primaryItem.getAsstAccount(), cfiItemCols, isSimpleMode);
                }
                if (VoucherSubmitCashFlowAuto.isNeedAssignSupItem(voucher, oppEntry, primaryItem)) {
                    CashFlowItemInfo supItem = null;
                    supItem = isDebit ? oppEntry.getAccount().getBorrowerAttCashFlowItem() : oppEntry.getAccount().getLenderAttCashFlowItem();
                    if (record.getOppVoucherAssistRecord() != null && record.getOppVoucherAssistRecord().getSupplementaryItem() != null) {
                        supItem = record.getOppVoucherAssistRecord().getSupplementaryItem();
                    } else if (oppEntry.getSupplementaryItem() != null) {
                        supItem = oppEntry.getSupplementaryItem();
                    }
                    if (supItem != null && supItem.getType() != CashFlowItemType.SECONDARY_TABLE_ITEM) {
                        supItem = null;
                    }
                    if (supItem != null) {
                        record.setItemFlag(ItemFlag.BOTH);
                        record.setSupplementaryItem(supItem);
                        boolean isPnL = AccountProperty.SUNYI.equals((Object)oppEntry.getAccount().getAccountTypeID().getProperty()) && VoucherSubmitCashFlowAuto.isShowSI(oppEntry.getAccount().getNumber(), allDif);
                        EntryDC entryDC = entry.getEntryDC();
                        if (isPnL) {
                            int sc = -1;
                            if (EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC())) {
                                sc = 1;
                                if (EntryDC.DEBIT.equals((Object)entryDC)) {
                                    sc = -1;
                                }
                            } else if (EntryDC.CREDIT.equals((Object)entryDC)) {
                                sc = 1;
                            }
                            record.setSupplementaryCoefficient(sc);
                        } else {
                            int sc = -1;
                            if (EntryDC.DEBIT.equals((Object)entryDC)) {
                                sc = 1;
                            }
                            record.setSupplementaryCoefficient(sc);
                        }
                    }
                }
            } else {
                record.setPrimaryCoefficient(1);
            }
            coll.add(record);
        }
        if (mustInputBothItem) {
            for (CashflowSplitRecordInfo splitRecord : supSplitColl) {
                VoucherEntryInfo oppEntry = splitRecord.getOpposingAccountEntry();
                VoucherEntryInfo entry = splitRecord.getEntry();
                CashflowRecordInfo record = new CashflowRecordInfo();
                record.setCreator(userInfo);
                record.setCreateTime(createtime);
                record.setLastUpdateUser(userInfo);
                record.setLastUpdateTime(createtime);
                record.setSeq(seq++);
                record.setVoucher(voucher);
                record.setEntry(entry);
                record.setAccount(entry.getAccount());
                record.setCurrency(entry.getCurrency());
                record.setEntryDC(entry.getEntryDC());
                record.setOpposingAccountEntry(oppEntry);
                record.setOppAccount(oppEntry.getAccount());
                record.setOppEntryDC(oppEntry.getEntryDC());
                record.setItemFlag(splitRecord.getItemFlag());
                if (splitRecord.getOppVoucherAssistRecord() != null) {
                    record.setOppVoucherAssistRecord(splitRecord.getOppVoucherAssistRecord());
                    record.setOppAssGrp(splitRecord.getOppAssGrp());
                }
                record.setOriginalAmount(splitRecord.getOriginalAmount());
                record.setLocalAmount(splitRecord.getLocalAmount());
                record.setReportingAmount(splitRecord.getReportingAmount());
                if (ItemFlag.DISPOSE.equals((Object)splitRecord.getItemFlag())) {
                    record.setSupplementaryItem(null);
                    record.setSupplementaryCoefficient(0);
                    record.setItemFlag(ItemFlag.DISPOSE);
                    record.setIsSupItem(hasPrimaryRecord);
                    record.setPrimaryItem(null);
                    record.setPrimaryCoefficient(0);
                    coll.add(record);
                    continue;
                }
                boolean isDebit = oppEntry.getEntryDC().equals((Object)EntryDC.DEBIT);
                CashFlowItemInfo supItem = null;
                supItem = isDebit ? oppEntry.getAccount().getBorrowerAttCashFlowItem() : oppEntry.getAccount().getLenderAttCashFlowItem();
                if (record.getOppVoucherAssistRecord() != null && record.getOppVoucherAssistRecord().getSupplementaryItem() != null) {
                    supItem = record.getOppVoucherAssistRecord().getSupplementaryItem();
                } else if (oppEntry.getSupplementaryItem() != null) {
                    supItem = oppEntry.getSupplementaryItem();
                }
                if (supItem != null && supItem.getType() != CashFlowItemType.SECONDARY_TABLE_ITEM) {
                    supItem = null;
                }
                if (supItem != null) {
                    int sc;
                    record.setItemFlag(ItemFlag.SUPPLEMENTARY);
                    record.setSupplementaryItem(supItem);
                    boolean isPnL = AccountProperty.SUNYI.equals((Object)oppEntry.getAccount().getAccountTypeID().getProperty()) && VoucherSubmitCashFlowAuto.isShowSI(oppEntry.getAccount().getNumber(), allDif);
                    EntryDC entryDC = entry.getEntryDC();
                    if (isPnL) {
                        sc = -1;
                        if (EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC())) {
                            sc = 1;
                            if (EntryDC.DEBIT.equals((Object)entryDC)) {
                                sc = -1;
                            }
                        } else if (EntryDC.CREDIT.equals((Object)entryDC)) {
                            sc = 1;
                        }
                        record.setSupplementaryCoefficient(sc);
                    } else {
                        sc = -1;
                        if (EntryDC.DEBIT.equals((Object)entryDC)) {
                            sc = 1;
                        }
                        record.setSupplementaryCoefficient(sc);
                    }
                }
                record.setPrimaryItem(null);
                record.setPrimaryCoefficient(0);
                record.setIsSupItem(hasPrimaryRecord);
                coll.add(record);
            }
        }
        VoucherSubmitCashFlowAuto.checkDataObject(ctx, coll, voucher, sysParam, difference, hmDynamicColumnInfo);
        voucher.setCashflowRecords((AbstractObjectCollection)coll);
        return coll;
    }

    private static void autoDipose(VoucherInfo voucher, CashflowRecordCollection coll) {
        int collCount = coll.size();
        if (collCount < 2) {
            return;
        }
        Iterator vchEntryIt = voucher.getEntries().iterator();
        HashMap<String, Integer> accountAndCurreny = new HashMap<String, Integer>();
        while (vchEntryIt.hasNext()) {
            VoucherEntryInfo vchEntry = (VoucherEntryInfo)vchEntryIt.next();
            if (!vchEntry.getAccount().isIsBank() && !vchEntry.getAccount().isIsCash() && !vchEntry.getAccount().isIsCashEquivalent()) continue;
            String acct = vchEntry.getAccount().getId().toString();
            String cur = vchEntry.getCurrency().getId().toString();
            if (accountAndCurreny.containsKey(acct + cur)) {
                accountAndCurreny.put(acct + cur, (Integer)accountAndCurreny.get(acct + cur) + 1);
                continue;
            }
            accountAndCurreny.put(acct + cur, 1);
        }
        HashMap<String, ArrayList<CashflowRecordInfo>> currencyEdMap = new HashMap<String, ArrayList<CashflowRecordInfo>>();
        ArrayList<CashflowRecordInfo> edList = null;
        for (CashflowRecordInfo cf : coll) {
            if (cf.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            VoucherEntryInfo entry = cf.getEntry();
            String acct = entry.getAccount().getId().toString();
            String cur = entry.getCurrency().getId().toString();
            if (currencyEdMap.get(acct + cur) != null) {
                edList = (List)currencyEdMap.get(acct + cur);
                edList.add(cf);
                continue;
            }
            if (!accountAndCurreny.containsKey(acct + cur) || (Integer)accountAndCurreny.get(acct + cur) <= 1) continue;
            edList = new ArrayList<CashflowRecordInfo>();
            edList.add(cf);
            currencyEdMap.put(acct + cur, edList);
        }
        Set keyset = currencyEdMap.keySet();
        for (String cur : keyset) {
            edList = (ArrayList<CashflowRecordInfo>)currencyEdMap.get(cur);
            VoucherSubmitCashFlowAuto.autoDipose(coll, edList);
        }
    }

    private static void autoDipose(CashflowRecordCollection coll, List edList) {
        CashflowRecordInfo antiCf;
        int j;
        CashflowRecordInfo cf;
        int i;
        int size = edList.size();
        CashflowRecordCollection diposeCol = new CashflowRecordCollection();
        CashflowRecordCollection col = new CashflowRecordCollection();
        for (CashflowRecordInfo cf2 : coll) {
            if (!ItemFlag.DISPOSE.equals((Object)cf2.getItemFlag())) continue;
            col.add(cf2);
        }
        BigDecimal amoumt = null;
        BigDecimal locamoumt = null;
        BigDecimal rptamoumt = null;
        block1: for (i = 0; i < size; ++i) {
            cf = (CashflowRecordInfo)edList.get(i);
            if (ItemFlag.DISPOSE.equals((Object)cf.getItemFlag()) || cf.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            for (j = i; j < size; ++j) {
                if (i == j) continue;
                antiCf = (CashflowRecordInfo)edList.get(j);
                if (ItemFlag.DISPOSE.equals((Object)cf.getItemFlag()) || cf.getEntryDC().equals((Object)antiCf.getEntryDC())) continue;
                if (cf.getLocalAmount().compareTo(antiCf.getLocalAmount()) < 0) {
                    amoumt = cf.getOriginalAmount();
                    locamoumt = cf.getLocalAmount();
                    rptamoumt = cf.getReportingAmount();
                    VoucherSubmitCashFlowAuto.autoDipose(cf, antiCf, amoumt, locamoumt, rptamoumt);
                    diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(cf, cf.getEntry(), antiCf.getEntry(), amoumt, locamoumt, rptamoumt, 1, cf.isIsSupItem()));
                    diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(antiCf, antiCf.getEntry(), cf.getEntry(), amoumt, locamoumt, rptamoumt, 1, antiCf.isIsSupItem()));
                    continue block1;
                }
                amoumt = antiCf.getOriginalAmount();
                locamoumt = antiCf.getLocalAmount();
                rptamoumt = antiCf.getReportingAmount();
                VoucherSubmitCashFlowAuto.autoDipose(antiCf, cf, amoumt, locamoumt, rptamoumt);
                diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(cf, cf.getEntry(), antiCf.getEntry(), amoumt, locamoumt, rptamoumt, 1, cf.isIsSupItem()));
                diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(antiCf, antiCf.getEntry(), cf.getEntry(), amoumt, locamoumt, rptamoumt, 1, antiCf.isIsSupItem()));
            }
        }
        block3: for (i = 0; i < size; ++i) {
            cf = (CashflowRecordInfo)edList.get(i);
            if (ItemFlag.DISPOSE.equals((Object)cf.getItemFlag()) || cf.getLocalAmount().compareTo(GlUtils.zero) == 0) continue;
            for (j = 0; j < size; ++j) {
                if (i == j) continue;
                antiCf = (CashflowRecordInfo)edList.get(j);
                if (ItemFlag.DISPOSE.equals((Object)cf.getItemFlag()) || cf.getLocalAmount().compareTo(GlUtils.zero) == 0 || !cf.getEntryDC().equals((Object)antiCf.getEntryDC())) continue;
                if (cf.getLocalAmount().abs().compareTo(antiCf.getLocalAmount().abs()) < 0) {
                    amoumt = cf.getOriginalAmount();
                    locamoumt = cf.getLocalAmount();
                    rptamoumt = cf.getReportingAmount();
                    VoucherSubmitCashFlowAuto.autoDipose(cf, antiCf, amoumt.multiply(GlUtils.negone), locamoumt.multiply(GlUtils.negone), rptamoumt.multiply(GlUtils.negone));
                    diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(antiCf, antiCf.getEntry(), cf.getEntry(), amoumt.multiply(GlUtils.negone), locamoumt.multiply(GlUtils.negone), rptamoumt.multiply(GlUtils.negone), -1, antiCf.isIsSupItem()));
                    diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(cf, cf.getEntry(), antiCf.getEntry(), amoumt, locamoumt, rptamoumt, -1, cf.isIsSupItem()));
                    continue block3;
                }
                amoumt = antiCf.getOriginalAmount();
                locamoumt = antiCf.getLocalAmount();
                rptamoumt = antiCf.getReportingAmount();
                VoucherSubmitCashFlowAuto.autoDipose(antiCf, cf, amoumt.multiply(GlUtils.negone), locamoumt.multiply(GlUtils.negone), rptamoumt.multiply(GlUtils.negone));
                diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(cf, cf.getEntry(), antiCf.getEntry(), amoumt.multiply(GlUtils.negone), locamoumt.multiply(GlUtils.negone), rptamoumt.multiply(GlUtils.negone), -1, cf.isIsSupItem()));
                diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(antiCf, antiCf.getEntry(), cf.getEntry(), amoumt, locamoumt, rptamoumt, -1, antiCf.isIsSupItem()));
            }
        }
        ArrayList<CashflowRecordInfo> reDispose = new ArrayList<CashflowRecordInfo>();
        for (int i2 = 0; i2 < size; ++i2) {
            CashflowRecordInfo cf3 = (CashflowRecordInfo)edList.get(i2);
            if (ItemFlag.DISPOSE.equals((Object)cf3.getItemFlag()) && cf3.getOpposingAccountEntry() == null) continue;
            reDispose.add(cf3);
        }
        if (reDispose.size() > 0) {
            Iterator it = reDispose.iterator();
            CashflowRecordInfo antiCf2 = null;
            while (it.hasNext()) {
                CashflowRecordInfo cf4 = (CashflowRecordInfo)it.next();
                if (!ItemFlag.DISPOSE.equals((Object)cf4.getItemFlag()) || cf4.getOpposingAccountEntry() == null) continue;
                antiCf2 = cf4;
                break;
            }
            if (antiCf2 != null) {
                for (CashflowRecordInfo cf4 : reDispose) {
                    if (antiCf2 == cf4 || ItemFlag.DISPOSE.equals((Object)cf4.getItemFlag()) || cf4.getOpposingAccountEntry() != null) continue;
                    BigDecimal amt = cf4.getOriginalAmount();
                    BigDecimal localAmt = cf4.getLocalAmount();
                    BigDecimal rptAmt = cf4.getReportingAmount();
                    if (cf4.getEntryDC().equals((Object)antiCf2.getEntryDC())) {
                        VoucherSubmitCashFlowAuto.autoDipose(cf4, antiCf2, amt.multiply(GlUtils.negone), localAmt.multiply(GlUtils.negone), rptAmt.multiply(GlUtils.negone));
                        diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(cf4, cf4.getEntry(), antiCf2.getEntry(), amt.multiply(GlUtils.negone), localAmt.multiply(GlUtils.negone), rptAmt.multiply(GlUtils.negone), -1, cf4.isIsSupItem()));
                        diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(antiCf2, antiCf2.getEntry(), cf4.getEntry(), amt, localAmt, rptAmt, -1, antiCf2.isIsSupItem()));
                        continue;
                    }
                    VoucherSubmitCashFlowAuto.autoDipose(cf4, antiCf2, amt, localAmt, rptAmt);
                    diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(cf4, cf4.getEntry(), antiCf2.getEntry(), amt, localAmt, rptAmt, 1, cf4.isIsSupItem()));
                    diposeCol.add(VoucherSubmitCashFlowAuto.createCashflowRecordInfo(antiCf2, antiCf2.getEntry(), cf4.getEntry(), amt, localAmt, rptAmt, 1, antiCf2.isIsSupItem()));
                }
            }
        }
        if (diposeCol == null) {
            return;
        }
        HashMap<String, CashflowRecordInfo> seqList = new HashMap<String, CashflowRecordInfo>();
        size = diposeCol.size();
        int index = col.size();
        for (int i3 = 0; i3 < size; ++i3) {
            CashflowRecordInfo rec = diposeCol.get(i3);
            String seq = String.valueOf(rec.getEntry().getSeq());
            if (seqList.containsKey(seq)) continue;
            seqList.put(seq, rec);
            for (int j2 = i3 + 1; j2 < size; ++j2) {
                CashflowRecordInfo rec2 = diposeCol.get(j2);
                if (rec2.getEntry().getSeq() != rec.getEntry().getSeq()) continue;
                rec.setOriginalAmount(rec2.getOriginalAmount().add(rec.getOriginalAmount()));
                rec.setLocalAmount(rec2.getLocalAmount().add(rec.getLocalAmount()));
                rec.setReportingAmount(rec2.getReportingAmount().add(rec.getReportingAmount()));
            }
            rec.setSeq(++index);
            coll.add(rec);
        }
    }

    private static CashflowRecordInfo createCashflowRecordInfo(CashflowRecordInfo cf, VoucherEntryInfo entry, VoucherEntryInfo oppEntry, BigDecimal amoumt, BigDecimal locamoumt, BigDecimal rptamoumt, int curcoefficient, boolean isSupItem) {
        CashflowRecordInfo rec = new CashflowRecordInfo();
        rec.setVoucher(cf.getVoucher());
        rec.setEntry(entry);
        rec.setAccount(entry.getAccount());
        rec.setCurrency(entry.getCurrency());
        rec.setEntryDC(entry.getEntryDC());
        rec.setOpposingAccountEntry(oppEntry);
        rec.setOppAccount(oppEntry.getAccount());
        rec.setOppEntryDC(oppEntry.getEntryDC());
        rec.setItemFlag(ItemFlag.DISPOSE);
        rec.setIsSupItem(isSupItem);
        rec.setOriginalAmount(amoumt);
        rec.setLocalAmount(locamoumt);
        rec.setReportingAmount(rptamoumt);
        rec.setPrimaryCoefficient(curcoefficient);
        rec.setSupplementaryCoefficient(curcoefficient);
        return rec;
    }

    private static void autoDipose(CashflowRecordInfo cf, CashflowRecordInfo antiCf, BigDecimal amoumt, BigDecimal locamoumt, BigDecimal rptamoumt) {
        cf.setOriginalAmount(GlUtils.zero);
        cf.setLocalAmount(GlUtils.zero);
        cf.setReportingAmount(GlUtils.zero);
        antiCf.setOriginalAmount(antiCf.getOriginalAmount().subtract(amoumt));
        antiCf.setLocalAmount(antiCf.getLocalAmount().subtract(locamoumt));
        antiCf.setReportingAmount(antiCf.getReportingAmount().subtract(rptamoumt));
    }

    private static void autoSetActTypeValue(Context ctx, Map hmPrimaryAssGrpInfo, CashflowRecordInfo info, AsstAccountInfo cfiTypeGroup, VoucherInfo.DynamicColumnInfo[] cfiActTypeCols, boolean isSimpleMode) {
        if (cfiActTypeCols == null || cfiActTypeCols.length == 0) {
            return;
        }
        AssistantHGInfo defaultAssGrp = new AssistantHGInfo();
        if (hmPrimaryAssGrpInfo.containsKey(info.getPrimaryItem().getId().toString())) {
            defaultAssGrp = (AssistantHGInfo)hmPrimaryAssGrpInfo.get(info.getPrimaryItem().getId().toString());
            if (defaultAssGrp == null) {
                defaultAssGrp = new AssistantHGInfo();
            }
        } else {
            try {
                defaultAssGrp = VoucherSubmitCashFlowAuto.getDefaultAsstItems(ctx, cfiActTypeCols, info.getOppAccount(), info.getVoucher().getCompany() != null ? info.getVoucher().getCompany() : ContextUtil.getCurrentFIUnit((Context)ctx));
            }
            catch (Exception e) {
                logger.error((Object)"CashFlowUtils.getDefaultAsstItems error", (Throwable)e);
            }
        }
        boolean isAllNull = true;
        AssistantHGInfo group = new AssistantHGInfo();
        group.setAsstAccount(cfiTypeGroup);
        CashflowTypeEnum cfType = CashflowTypeEnum.OUT;
        for (int i = 0; i < cfiActTypeCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = cfiActTypeCols[i];
            String key = colInfo.getMappingPropName();
            if (defaultAssGrp.get(key) != null) {
                group.put(key, defaultAssGrp.get(key));
                isAllNull = false;
                if (!cfType.equals((Object)CashflowTypeEnum.OUT)) continue;
                if (key.equals("companyOrg")) {
                    cfType = CashflowTypeEnum.IN;
                }
                if (key.equals("customer") && ((CustomerInfo)defaultAssGrp.get(key)).getInternalCompany() != null) {
                    cfType = CashflowTypeEnum.IN;
                }
                if (!key.equals("provider") || ((SupplierInfo)defaultAssGrp.get(key)).getInternalCompany() == null) continue;
                cfType = CashflowTypeEnum.IN;
                continue;
            }
            group.put(key, null);
        }
        info.setType(cfType);
        if (isAllNull) {
            info.setAssGrp(null);
        } else {
            try {
                group = VoucherFacadeFactory.getLocalInstance((Context)ctx).confirmAssGrp(group, cfiTypeGroup.getId().toString(), cfiActTypeCols);
                if (group != null) {
                    info.setAssGrp(group);
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            }
            catch (Exception e) {
                info.setType(CashflowTypeEnum.OUT);
                logger.error((Object)"CashflowSplitClient invoke autoSetActTypeValue error", (Throwable)e);
            }
        }
        if (!hmPrimaryAssGrpInfo.containsKey(info.getPrimaryItem().getId().toString())) {
            hmPrimaryAssGrpInfo.put(info.getPrimaryItem().getId().toString(), info.getAssGrp());
        }
    }

    private static void checkDataObject(Context ctx, CashflowRecordCollection coll, VoucherInfo voucher, GlParam sysParam, Map difference, Map hmDynamicColumnInfo) throws EASBizException, BOSException {
        Iterator it = coll.iterator();
        CashflowFlag cfFlag = CashFlowUtils.computeCashflowFlag(voucher);
        boolean mustInputBothItem = sysParam.getBoolean("GL_015");
        int isOutCfAssistRequired = sysParam.getInt("GL_102");
        while (it.hasNext()) {
            CashflowRecordInfo record = (CashflowRecordInfo)it.next();
            if (record.getOpposingAccountEntry() == null) {
                throw new GLException(GLException.AUTOSETCF_NEED_OPPACCOUNTENTRY);
            }
            if (record.getItemFlag() == ItemFlag.DISPOSE) continue;
            CashFlowItemInfo pi = record.getPrimaryItem();
            if (!CashflowFlag.ONLY_PNLACCOUNT.equals((Object)cfFlag) && pi == null && (ItemFlag.PRIMARY.equals((Object)record.getItemFlag()) || ItemFlag.BOTH.equals((Object)record.getItemFlag()))) {
                throw new GLException(GLException.AUTOSETCF_NEED_PRIMARYITEM);
            }
            if (!CashflowFlag.ONLY_PNLACCOUNT.equals((Object)cfFlag) && (pi == null || !VoucherSubmitCashFlowAuto.isShowSI(VoucherSubmitCashFlowAuto.isSIEnabled(record.getOpposingAccountEntry(), pi, difference), pi, difference)) || !mustInputBothItem || record.getSupplementaryItem() != null) continue;
            throw new GLException(GLException.AUTOSETCF_NEED_SUPPLYITEM);
        }
        VoucherSubmitCashFlowAuto.checkCFAsstGrpIntegrity(ctx, coll, isOutCfAssistRequired, hmDynamicColumnInfo);
        VoucherSubmitCashFlowAuto.validateCashflowItem(ctx, voucher.getCompany().getCU().getId().toString(), coll);
    }

    public static void checkCFAsstGrpIntegrity(Context ctx, CashflowRecordCollection coll, int isOutCfAssistRequired, Map hmDynamicColumnInfo) throws BOSException, EASBizException {
        if (hmDynamicColumnInfo == null) {
            hmDynamicColumnInfo = new HashMap();
        }
        HashMap<String, AssistantHGInfo> hgInfoCache = new HashMap<String, AssistantHGInfo>();
        for (CashflowRecordInfo record : coll) {
            if (record.getItemFlag() != ItemFlag.PRIMARY && record.getItemFlag() != ItemFlag.BOTH) continue;
            CashFlowItemInfo pi = record.getPrimaryItem();
            CashflowTypeEnum type = record.getType();
            if (pi == null || pi.getAsstAccount() == null || !pi.isIsEnable() || isOutCfAssistRequired != 0 && (type == null || type.equals((Object)CashflowTypeEnum.OUT))) continue;
            if (record.getAssGrp() == null) {
                throw new GLException(GLException.AUTOSETCF_NEED_PRIMARYITEM_ASST);
            }
            String typeGroupId = pi.getAsstAccount().getId().toString();
            Object[] colInfo = VoucherSubmitCashFlowAuto.getCachedColumnInfo(ctx, hmDynamicColumnInfo, typeGroupId);
            VoucherInfo.DynamicColumnInfo[] assItemCols = (VoucherInfo.DynamicColumnInfo[])colInfo[0];
            int inAttrCount = 0;
            SelectorItemCollection selector = new SelectorItemCollection();
            AssistantHGInfo hg = record.getAssGrp();
            if (hgInfoCache.containsKey(hg.getId().toString())) {
                hg = (AssistantHGInfo)hgInfoCache.get(hg.getId().toString());
            } else {
                String key;
                VoucherInfo.DynamicColumnInfo ItemCol;
                int n;
                boolean loadAgain = false;
                VoucherInfo.DynamicColumnInfo[] dynamicColumnInfoArray = assItemCols;
                int n2 = dynamicColumnInfoArray.length;
                for (n = 0; n < n2; ++n) {
                    ItemCol = dynamicColumnInfoArray[n];
                    key = ItemCol.getMappingPropName();
                    if (hg.get(key) != null && !"customer".equals(key) && !"provider".equals(key)) continue;
                    loadAgain = true;
                    break;
                }
                if (loadAgain) {
                    dynamicColumnInfoArray = assItemCols;
                    n2 = dynamicColumnInfoArray.length;
                    for (n = 0; n < n2; ++n) {
                        ItemCol = dynamicColumnInfoArray[n];
                        key = ItemCol.getMappingPropName();
                        selector.add(key);
                        if ("customer".equals(key)) {
                            selector.add("customer.isInternalCompany");
                        }
                        if (!"provider".equals(key)) continue;
                        selector.add("provider.isInternalCompany");
                    }
                }
                hg = selector.size() == 0 ? hg : AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(record.getAssGrp().getId()), selector);
                hgInfoCache.put(hg.getId().toString(), hg);
            }
            for (VoucherInfo.DynamicColumnInfo assItemCol : assItemCols) {
                String key = assItemCol.getMappingPropName();
                if (hg == null || hg.get(key) == null) {
                    if (isOutCfAssistRequired != 0 && (isOutCfAssistRequired != 1 || !type.equals((Object)CashflowTypeEnum.IN))) continue;
                    throw new GLException(GLException.AUTOSETCF_NEED_PRIMARYITEM_ASST_FULL);
                }
                if ("customer".equals(key) && ((CustomerInfo)hg.get(key)).isIsInternalCompany() || "provider".equals(key) && ((SupplierInfo)hg.get(key)).isIsInternalCompany()) {
                    ++inAttrCount;
                    continue;
                }
                if (!"companyOrg".equals(key)) continue;
                ++inAttrCount;
            }
            if (!type.equals((Object)CashflowTypeEnum.IN) || isOutCfAssistRequired != 2 || inAttrCount != 0) continue;
            throw new GLException(GLException.AUTOSETCF_NEED_PRIMARYITEM_ASST_FULL);
        }
    }

    public static void validateCashflowItem(Context ctx, String CUid, CashflowRecordCollection cfRecords) throws EASBizException, BOSException {
        String msg = CashFlowUtils.checkCashflowItemView(ctx, CUid, CashFlowUtils.getCashflowItems(cfRecords));
        if (!StringUtils.isEmpty((String)msg)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)"NOTICE_CashflowItems_View") + msg);
        }
    }

    private static boolean isShowSI(boolean showSI, CashFlowItemInfo item, Map difference) {
        if (!item.isIsDealActivity()) {
            return showSI;
        }
        CashFlowKeepActivityCollection actCol = (CashFlowKeepActivityCollection)difference.get("cashFlowKeepActivityCollection");
        boolean hasActivity = showSI;
        if (actCol != null) {
            int size = actCol.size();
            for (int i = 0; i < size; ++i) {
                CashFlowKeepActivityInfo actitem = actCol.get(i);
                if (actitem.getConCashFlowItem() == null || !item.getId().toString().equals(actitem.getConCashFlowItem().getId().toString())) continue;
                hasActivity = !showSI;
                break;
            }
        }
        return hasActivity;
    }

    private static boolean isSIEnabled(VoucherEntryInfo entry, CashFlowItemInfo pi, Map difference) {
        if (entry == null) {
            return false;
        }
        boolean isPnL = AccountProperty.SUNYI.equals((Object)entry.getAccount().getAccountTypeID().getProperty()) && VoucherSubmitCashFlowAuto.isShowSI(entry.getAccount().getNumber(), difference);
        boolean isAct = pi.isIsDealActivity();
        return isPnL && !isAct || !isPnL && isAct;
    }

    private static boolean isShowSI(String entryAccountNumber, Map difference) {
        CashFlowAccountDiffCollection actCol = (CashFlowAccountDiffCollection)difference.get("CashFlowAccountDiffCollection");
        boolean isShowSI = true;
        if (actCol != null) {
            int size = actCol.size();
            for (int i = 0; i < size; ++i) {
                CashFlowAccountDiffInfo actitem = actCol.get(i);
                if (actitem.getDiffAccount() == null || !entryAccountNumber.equals(actitem.getDiffAccount().getNumber())) continue;
                isShowSI = false;
                break;
            }
        }
        return isShowSI;
    }

    public static void autoSetActTypeValue(Context ctx, Map dynamicDatabaseInfo, CashflowRecordInfo info, String hgId, VoucherInfo.DynamicColumnInfo[] acctActTypeCols, AsstAccountInfo cfiTypeGroup, VoucherInfo.DynamicColumnInfo[] cfiActTypeCols, boolean isSimpleMode) {
        Object objCompany;
        if (StringUtils.isEmpty((String)hgId) || acctActTypeCols == null || acctActTypeCols.length == 0 || cfiActTypeCols == null || cfiActTypeCols.length == 0) {
            return;
        }
        if (!isSimpleMode) {
            return;
        }
        AssistantHGInfo assGrp = null;
        try {
            assGrp = GlUtils.dynamicLoadAssistangHG(ctx, dynamicDatabaseInfo, hgId, acctActTypeCols);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (assGrp == null) {
            return;
        }
        boolean isExistsOppCustomer = false;
        boolean isExistsOppProvider = false;
        boolean isExistsOppCompany = false;
        boolean isExistsCfCustomer = false;
        boolean isExistsCfProvider = false;
        boolean isCustomerToProvider = false;
        boolean isProviderToCustomer = false;
        boolean isCompanyToCustomerAndProvider = false;
        boolean isCompanyToCustomer = false;
        boolean isCompanyToProvider = false;
        SupplierInfo supplierFromBizAnalysisCode = null;
        CustomerInfo customerFromBizAnalysisCode = null;
        SupplierInfo supplierFromCompany = null;
        CustomerInfo customerFromCompany = null;
        for (VoucherInfo.DynamicColumnInfo oppCol : cfiActTypeCols) {
            if ("customer".equals(oppCol.getMappingPropName())) {
                isExistsCfCustomer = true;
            }
            if (!"provider".equals(oppCol.getMappingPropName())) continue;
            isExistsCfProvider = true;
        }
        for (VoucherInfo.DynamicColumnInfo oppCol : acctActTypeCols) {
            if ("customer".equals(oppCol.getMappingPropName())) {
                isExistsOppCustomer = true;
            }
            if ("provider".equals(oppCol.getMappingPropName())) {
                isExistsOppProvider = true;
            }
            if (!"companyOrg".equals(oppCol.getMappingPropName())) continue;
            isExistsOppCompany = true;
        }
        if (isExistsOppCustomer && !isExistsOppProvider && isExistsCfProvider) {
            isCustomerToProvider = true;
            Object objCustomer = assGrp.get("customer");
            if (objCustomer instanceof CustomerInfo) {
                CustomerInfo customer = (CustomerInfo)objCustomer;
                if (customer.getBizAnalysisCode() == null) {
                    isCustomerToProvider = false;
                } else {
                    try {
                        EntityViewInfo view = CashFlowUtils.getBizAnalysisCodeView(customer.getBizAnalysisCode().getId().toString());
                        SupplierCollection supplies = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
                        if (supplies.size() == 1) {
                            supplierFromBizAnalysisCode = supplies.get(0);
                        } else {
                            isCustomerToProvider = false;
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)"autoSetActTypeValue invoke CFAsstautoSetByBizAnalysisCode error", (Throwable)e);
                    }
                }
            }
        }
        if (!isExistsOppCustomer && isExistsOppProvider && isExistsCfCustomer) {
            isProviderToCustomer = true;
            Object objSupplier = assGrp.get("provider");
            if (objSupplier instanceof SupplierInfo) {
                SupplierInfo supplier = (SupplierInfo)objSupplier;
                if (supplier.getBizAnalysisCode() == null) {
                    isProviderToCustomer = false;
                } else {
                    try {
                        EntityViewInfo view = CashFlowUtils.getBizAnalysisCodeView(supplier.getBizAnalysisCode().getId().toString());
                        CustomerCollection customers = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
                        if (customers.size() == 1) {
                            customerFromBizAnalysisCode = customers.get(0);
                        } else {
                            isProviderToCustomer = false;
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)"autoSetActTypeValue invoke CFAsstautoSetByBizAnalysisCode error", (Throwable)e);
                    }
                }
            }
        }
        if (isExistsOppCompany && (objCompany = assGrp.get("companyOrg")) instanceof CompanyOrgUnitInfo) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)objCompany;
            CompanyOrgUnitInfo company = info.getVoucher().getCompany();
            String internalCompanyId = companyOrgUnitInfo.getId().toString();
            try {
                Map<String, Object> customerMap;
                if (!isExistsOppProvider && !isExistsOppCustomer && (isExistsCfProvider || isExistsCfCustomer)) {
                    Map<String, Object> supplierMap;
                    Map<String, Object> customerMap2;
                    boolean isCustomerNotNull = false;
                    boolean isSupplierNotNull = false;
                    if (isExistsCfCustomer && (customerMap2 = CashFlowUtils.getCustomerInfo(ctx, internalCompanyId, company, null)).size() == 1) {
                        customerFromCompany = (CustomerInfo)customerMap2.values().toArray()[0];
                        isCustomerNotNull = true;
                    }
                    if (isExistsCfProvider && (supplierMap = CashFlowUtils.getSuppliersInfo(ctx, internalCompanyId, company, null)).size() == 1) {
                        supplierFromCompany = (SupplierInfo)supplierMap.values().toArray()[0];
                        isSupplierNotNull = true;
                    }
                    isCompanyToCustomerAndProvider = isSupplierNotNull || isCustomerNotNull;
                } else if (isExistsOppCustomer && !isExistsOppProvider && isExistsCfProvider) {
                    Map<String, Object> supplierMap = CashFlowUtils.getSuppliersInfo(ctx, internalCompanyId, company, null);
                    if (supplierMap.size() == 1) {
                        supplierFromCompany = (SupplierInfo)supplierMap.values().toArray()[0];
                        isCompanyToProvider = true;
                    }
                } else if (isExistsOppProvider && !isExistsOppCustomer && isExistsCfCustomer && (customerMap = CashFlowUtils.getCustomerInfo(ctx, internalCompanyId, company, null)).size() == 1) {
                    customerFromCompany = (CustomerInfo)customerMap.values().toArray()[0];
                    isCompanyToCustomer = true;
                }
            }
            catch (Exception e) {
                logger.error((Object)"invoke findCustomerAndSupplier error", (Throwable)e);
            }
        }
        AssistantHGInfo defaultAssGrp = new AssistantHGInfo();
        try {
            defaultAssGrp = VoucherSubmitCashFlowAuto.getDefaultAsstItems(ctx, cfiActTypeCols, info.getOppAccount(), info.getVoucher().getCompany() != null ? info.getVoucher().getCompany() : ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        catch (Exception e) {
            logger.error((Object)"CashFlowUtils.getDefaultAsstItems error", (Throwable)e);
        }
        boolean isAllNull = true;
        AssistantHGInfo group = new AssistantHGInfo();
        group.setAsstAccount(cfiTypeGroup);
        CashflowTypeEnum cfType = CashflowTypeEnum.OUT;
        for (int i = 0; i < cfiActTypeCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo colInfo = cfiActTypeCols[i];
            String key = colInfo.getMappingPropName();
            Object value = assGrp.get(key);
            if ("companyOrg".equals(key)) {
                SupplierInfo supplier;
                Object objSupplier;
                CustomerInfo customer;
                Object objCustomer;
                if (value == null && (objCustomer = assGrp.get("customer")) instanceof CustomerInfo && (customer = (CustomerInfo)objCustomer).getInternalCompany() != null) {
                    value = customer.getInternalCompany();
                }
                if (value == null && (objSupplier = assGrp.get("provider")) instanceof SupplierInfo && (supplier = (SupplierInfo)objSupplier).getInternalCompany() != null) {
                    value = supplier.getInternalCompany();
                }
                if (value != null) {
                    info.setType(CashflowTypeEnum.IN);
                    cfType = CashflowTypeEnum.IN;
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            } else if ("customer".equals(key)) {
                if (value instanceof CustomerInfo) {
                    CustomerInfo customer = (CustomerInfo)value;
                    if (customer.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
                if (value == null && isProviderToCustomer) {
                    if (customerFromBizAnalysisCode.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                }
                if (value == null && (isCompanyToCustomer || isCompanyToCustomerAndProvider)) {
                    info.setType(CashflowTypeEnum.IN);
                    cfType = CashflowTypeEnum.IN;
                }
            } else if ("provider".equals(colInfo.getMappingPropName())) {
                if (value instanceof SupplierInfo) {
                    SupplierInfo supplier = (SupplierInfo)value;
                    if (supplier.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
                if (value == null && isCustomerToProvider) {
                    if (supplierFromBizAnalysisCode != null && supplierFromBizAnalysisCode.getInternalCompany() != null) {
                        info.setType(CashflowTypeEnum.IN);
                        cfType = CashflowTypeEnum.IN;
                    } else {
                        info.setType(CashflowTypeEnum.OUT);
                    }
                }
                if (value == null && (isCompanyToProvider || isCompanyToCustomerAndProvider)) {
                    info.setType(CashflowTypeEnum.IN);
                    cfType = CashflowTypeEnum.IN;
                }
            } else if (!CashflowTypeEnum.IN.equals((Object)info.getType())) {
                info.setType(CashflowTypeEnum.OUT);
            }
            group.put(key, value);
            if (value != null) {
                isAllNull = false;
            }
            if (isCustomerToProvider && key.equals("provider")) {
                group.put(key, (Object)supplierFromBizAnalysisCode);
                if (supplierFromBizAnalysisCode != null) {
                    isAllNull = false;
                }
            }
            if (isProviderToCustomer && key.equals("customer")) {
                group.put(key, (Object)customerFromBizAnalysisCode);
                if (customerFromBizAnalysisCode != null) {
                    isAllNull = false;
                }
            }
            if (isCompanyToCustomer && key.equals("customer")) {
                group.put(key, (Object)customerFromCompany);
                if (customerFromCompany != null) {
                    isAllNull = false;
                }
            }
            if (isCompanyToProvider && key.equals("provider")) {
                group.put(key, (Object)supplierFromCompany);
                if (supplierFromCompany != null) {
                    isAllNull = false;
                }
            }
            if (isCompanyToCustomerAndProvider) {
                if (key.equals("customer")) {
                    group.put(key, (Object)customerFromCompany);
                } else if (key.equals("provider")) {
                    group.put(key, (Object)supplierFromCompany);
                }
                if (supplierFromCompany != null || customerFromCompany != null) {
                    isAllNull = false;
                }
            }
            if (group.get(key) != null || defaultAssGrp.get(key) == null) continue;
            group.put(key, defaultAssGrp.get(key));
            isAllNull = false;
            info.setType(CashflowTypeEnum.OUT);
            if (key.equals("companyOrg")) {
                info.setType(CashflowTypeEnum.IN);
                cfType = CashflowTypeEnum.IN;
            }
            if (key.equals("customer") && ((CustomerInfo)defaultAssGrp.get(key)).getInternalCompany() != null) {
                info.setType(CashflowTypeEnum.IN);
                cfType = CashflowTypeEnum.IN;
            }
            if (!key.equals("provider") || ((SupplierInfo)defaultAssGrp.get(key)).getInternalCompany() == null) continue;
            info.setType(CashflowTypeEnum.IN);
            cfType = CashflowTypeEnum.IN;
        }
        info.setType(cfType);
        if (isAllNull) {
            info.setAssGrp(null);
        } else {
            try {
                group = VoucherFacadeFactory.getLocalInstance((Context)ctx).confirmAssGrp(group, cfiTypeGroup.getId().toString(), cfiActTypeCols);
                if (group != null) {
                    info.setAssGrp(group);
                } else {
                    info.setType(CashflowTypeEnum.OUT);
                }
            }
            catch (Exception e) {
                info.setType(CashflowTypeEnum.OUT);
                logger.error((Object)"VoucherSubmitCashFlowAuto invoke autoSetActTypeValue error", (Throwable)e);
            }
        }
    }

    private static AssistantHGInfo getDefaultAsstItems(Context ctx, VoucherInfo.DynamicColumnInfo[] cfiItemCols, AccountViewInfo acc, CompanyOrgUnitInfo vchCompany) throws Exception {
        AssistantHGInfo defaultAsstGrp = new AssistantHGInfo();
        Object bank = null;
        AccountBankInfo accountBank = null;
        for (int i = 0; i < cfiItemCols.length; ++i) {
            VoucherInfo.DynamicColumnInfo dynamicColumnInfo = cfiItemCols[i];
        }
        if (accountBank != null && bank != null) {
            if (accountBank.getBank() == null) {
                accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId()));
            }
            if (!accountBank.getBank().getId().equals((Object)bank.getId())) {
                defaultAsstGrp.remove("region");
            }
        }
        try {
            IAsstActTypeDefault def = AsstActTypeDefaultFactory.getLocalInstance((Context)ctx);
            for (int i = 0; i < cfiItemCols.length; ++i) {
                VoucherInfo.DynamicColumnInfo info = cfiItemCols[i];
                if (defaultAsstGrp.get(info.getMappingPropName()) != null) continue;
                AsstActTypeInfo type = new AsstActTypeInfo();
                type.setAsstHGAttribute(info.getMappingPropName());
                type.setId(info.getId());
                type.setName(info.getColName());
                AsstActTypeDefaultInfo defalt = (AsstActTypeDefaultInfo)def.getDefaultAcctItem(vchCompany.getId().toString(), (IObjectValue)type);
                if (defalt.getDefaultId() == null) continue;
                DataBaseInfo data = GlUtils.findAsstActObject(ctx, info.getMappingPropName(), defalt.getDefaultId().toString());
                if (data instanceof GeneralAsstActTypeInfo) {
                    GeneralAsstActTypeInfo asst = (GeneralAsstActTypeInfo)data;
                    data.setString("displayLongNumber", asst.getLongNumber().replace("!", "."));
                }
                if (data == null) continue;
                defaultAsstGrp.put(info.getMappingPropName(), (Object)data);
            }
        }
        catch (EASBizException e) {
            logger.error((Object)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"379_VoucherEditBaseUI"), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)com.kingdee.eas.util.client.EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"379_VoucherEditBaseUI"), (Throwable)e);
        }
        return defaultAsstGrp;
    }

    private static boolean isNeedAssignSupItem(VoucherInfo vch, VoucherEntryInfo entry, CashFlowItemInfo pi) {
        if (entry == null || pi == null) {
            return false;
        }
        boolean isPnL = VoucherSubmitCashFlowAuto.isPLAccount(vch, entry.getAccount());
        boolean isAct = VoucherSubmitCashFlowAuto.isCFItemDealActivity(vch, pi);
        return isPnL && !isAct || !isPnL && isAct;
    }

    private static boolean isCFItemDealActivity(VoucherInfo vch, CashFlowItemInfo item) {
        if (item == null || !item.isIsDealActivity()) {
            return false;
        }
        CashFlowKeepActivityCollection actCol = vch.getCashFlowKeepActivityCollection();
        if (actCol == null) {
            return true;
        }
        int size = actCol.size();
        for (int i = 0; i < size; ++i) {
            CashFlowKeepActivityInfo actitem = actCol.get(i);
            if (actitem.getConCashFlowItem() == null || !item.getId().toString().equals(actitem.getConCashFlowItem().getId().toString())) continue;
            return false;
        }
        return true;
    }

    private static boolean isPLAccount(VoucherInfo vch, AccountViewInfo account) {
        if (account == null || account.getPLType() == AccountPLType.NONE) {
            return false;
        }
        CashFlowAccountDiffCollection actCol = vch.getCashFlowAccountDiffCollection();
        if (actCol == null) {
            return true;
        }
        int size = actCol.size();
        for (int i = 0; i < size; ++i) {
            CashFlowAccountDiffInfo actitem = actCol.get(i);
            if (actitem.getDiffAccount() == null || !account.getNumber().equals(actitem.getDiffAccount().getNumber())) continue;
            return false;
        }
        return true;
    }

    private static Object[] getCachedColumnInfo(Context ctx, Map hmDynamicColumnInfo, String typeGroupId) throws EASBizException, BOSException {
        if (typeGroupId == null) {
            return null;
        }
        Object[] colInfo = (Object[])hmDynamicColumnInfo.get(typeGroupId);
        try {
            if (colInfo == null) {
                colInfo = VoucherFacadeFactory.getLocalInstance((Context)ctx).fetchAssColumnInfo(null, typeGroupId, null);
                hmDynamicColumnInfo.put(typeGroupId, colInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return colInfo;
    }

    private static List getOwnAccount(Context ctx, VoucherInfo voucher, GlParam sysParam, String type, boolean substractDispose, Map difference) throws EASBizException, BOSException {
        ArrayList ownAccount = new ArrayList();
        VoucherEntryCollection entrys = voucher.getEntries();
        for (int i = 0; i < entrys.size(); ++i) {
            VoucherEntryInfo entry = entrys.get(i);
            AccountViewInfo account = entry.getAccount();
            boolean isOwnAccount = false;
            isOwnAccount = type.equals("primary") ? account.isIsCash() || account.isIsBank() || account.isIsCashEquivalent() : VoucherSubmitCashFlowAuto.isPLAccount(ctx, account, difference);
            if (account == null || !isOwnAccount) continue;
            BigDecimal localAmount = entry.getLocalAmount();
            if (!sysParam.getBoolean("G001")) continue;
            BigDecimal bigDecimal = entry.getReportingAmount();
        }
        return ownAccount;
    }

    private static Map getCashflowAmount(VoucherEntryInfo entry, String type) {
        HashMap result = new HashMap();
        BigDecimal originalAmount = BigDecimal.ZERO;
        BigDecimal localAmount = BigDecimal.ZERO;
        BigDecimal reportingAmount = BigDecimal.ZERO;
        return result;
    }

    private static boolean validatePrimaryCash(Context ctx, VoucherInfo voucher, GlParam sysParam) throws EASBizException, BOSException {
        boolean result = true;
        return true;
    }

    private static boolean validateSuppCash(Context ctx, VoucherInfo voucher, GlParam sysParam) throws EASBizException, BOSException {
        return true;
    }

    public static AssistantHGInfo toAssGrpInfo(Context ctx, Map assGrp, String asstAccountId, AsstActTypeCollection atColl) throws BOSException, EASBizException {
        if (assGrp == null || StringUtils.isEmpty((String)asstAccountId)) {
            return null;
        }
        String hgId = (String)assGrp.get("id");
        if (StringUtils.isEmpty((String)hgId)) {
            HashMap dbMap = new HashMap();
            for (String attrName : assGrp.keySet()) {
                Object value = assGrp.get(attrName);
                if (value == null || !(value instanceof Map)) continue;
                Object dbId = ((Map)value).get("id");
                dbMap.put(attrName, dbId);
            }
            if (dbMap.isEmpty()) {
                return null;
            }
            IObjectPK pk = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGPK(asstAccountId, atColl, dbMap);
            hgId = pk.toString();
        }
        if (!StringUtils.isEmpty((String)hgId)) {
            AssistantHGInfo hg = new AssistantHGInfo();
            hg.setId(BOSUuid.read((String)hgId));
            return hg;
        }
        return null;
    }

    private static Map getAsstGrpInfo(Context ctx, String asstAccountId, String hgId) throws BOSException, EASBizException {
        HashSet<String> asstAccountIdSet = new HashSet<String>();
        asstAccountIdSet.add(asstAccountId);
        AsstActGroupDetailCollection detailColl = VoucherSubmitCashFlowAuto.getAsstActGroupDetailCollection(ctx, asstAccountIdSet);
        HashMap asstAccount = new HashMap();
        HashMap<String, Object> result = new HashMap<String, Object>();
        AssistantHGInfo assistantHGInfo = null;
        if (!StringUtils.isEmpty((String)hgId)) {
            assistantHGInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(hgId), VoucherSubmitCashFlowAuto.getHGSelector(detailColl));
            result.put("assgrp", assistantHGInfo);
        }
        LinkedHashMap<String, AsstActTypeInfo> config = new LinkedHashMap<String, AsstActTypeInfo>();
        for (AsstActGroupDetailInfo detailInfo : detailColl) {
            AsstActTypeInfo asstActTypeInfo = detailInfo.getAsstActType();
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            config.put(asstHGAttribute, asstActTypeInfo);
        }
        result.put("config", config);
        return result;
    }

    private static SelectorItemCollection getHGSelector(AsstActGroupDetailCollection detailColl) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        for (AsstActGroupDetailInfo detailInfo : detailColl) {
            AsstActTypeInfo asstActTypeInfo = detailInfo.getAsstActType();
            String asstHGAttribute = asstActTypeInfo.getAsstHGAttribute();
            sic.add(new SelectorItemInfo(asstHGAttribute + ".id"));
            sic.add(new SelectorItemInfo(asstHGAttribute + ".name"));
            sic.add(new SelectorItemInfo(asstHGAttribute + ".number"));
            if (asstActTypeInfo.isUseLongNumber()) {
                sic.add(new SelectorItemInfo(asstHGAttribute + ".longNumber"));
            }
            if (asstActTypeInfo.isIsMultilevel()) {
                sic.add(new SelectorItemInfo(asstHGAttribute + ".displayName"));
            }
            if ("customer".equals(asstHGAttribute) || "supplier".equals(asstHGAttribute)) {
                sic.add(new SelectorItemInfo("browseGroup.displayName"));
                sic.add(new SelectorItemInfo("isInternalCompany"));
                continue;
            }
            if (!"material".equals(asstHGAttribute)) continue;
            sic.add(new SelectorItemInfo("materialGroup.displayName"));
        }
        return sic;
    }

    private static AsstActGroupDetailCollection getAsstActGroupDetailCollection(Context ctx, Set asstAccountIdSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(VoucherSubmitCashFlowAuto.getAsstAccountSelector());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("seq"));
        return AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
    }

    private static SelectorItemCollection getAsstAccountSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActType.number"));
        sic.add(new SelectorItemInfo("asstActType.name"));
        sic.add(new SelectorItemInfo("asstActType.defaultQueryName"));
        sic.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("asstActType.isMultilevel"));
        sic.add(new SelectorItemInfo("asstActType.realtionDataObject"));
        sic.add(new SelectorItemInfo("asstActType.mappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.groupTableName"));
        sic.add(new SelectorItemInfo("asstActType.groupMappingFieldName"));
        sic.add(new SelectorItemInfo("asstActType.isForCompany"));
        sic.add(new SelectorItemInfo("asstActType.glAsstActTypeGrp.id"));
        sic.add(new SelectorItemInfo("asstActType.useLongNumber"));
        sic.add(new SelectorItemInfo("asstActType.permissionItem"));
        return sic;
    }

    private static CashflowRecordInfo getSameCashflowRecordInfo(CashflowSplitRecordInfo cff, CashflowRecordCollection coll) {
        CashflowRecordInfo result = null;
        for (int i = 0; i < coll.size(); ++i) {
            CashflowRecordInfo rowInfo = coll.get(i);
            if (!VoucherSubmitCashFlowAuto.equals(cff.getEntry(), rowInfo.getEntry()) || cff.getEntry().getEntryDC() != rowInfo.getEntry().getEntryDC() || !VoucherSubmitCashFlowAuto.equals(cff.getOpposingAccountEntry(), rowInfo.getOpposingAccountEntry())) continue;
            result = rowInfo;
            break;
        }
        return result;
    }

    public static AsstActTypeCollection getAsstActTypeCollection(Context ctx, String asstAccountId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstActType.id"));
        selectors.add(new SelectorItemInfo("asstActType.name"));
        selectors.add(new SelectorItemInfo("asstActType.number"));
        selectors.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        selectors.add(new SelectorItemInfo("asstActType.isMultilevel"));
        selectors.add(new SelectorItemInfo("asstActType.useLongNumber"));
        FilterInfo fi = new FilterInfo();
        view.setFilter(fi);
        FilterItemCollection filters = fi.getFilterItems();
        filters.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        AsstActGroupDetailCollection detail = AsstActGroupDetailFactory.getLocalInstance((Context)ctx).getAsstActGroupDetailCollection(view);
        AsstActTypeCollection atColl = new AsstActTypeCollection();
        for (int i = 0; i < detail.size(); ++i) {
            atColl.add(detail.get(i).getAsstActType());
        }
        return atColl;
    }

    private static boolean lockSuppItem(Context ctx, AccountViewInfo account, CashFlowItemInfo primaryItem, Map difference) {
        boolean isPLAccount = VoucherSubmitCashFlowAuto.isPLAccount(ctx, account, difference);
        boolean isDealActivity = VoucherSubmitCashFlowAuto.isDealActivity(primaryItem, difference);
        return isPLAccount && isDealActivity || !isPLAccount && !isDealActivity;
    }

    private static boolean isDealActivity(CashFlowItemInfo cashItem, Map difference) {
        boolean isDealActivity = cashItem.isIsDealActivity();
        if (isDealActivity && difference != null && difference.get("cashflowKeepActivities") != null && ((List)difference.get("cashflowKeepActivities")).indexOf(cashItem.getId().toString()) != -1) {
            isDealActivity = false;
        }
        return isDealActivity;
    }

    private static boolean isPLAccount(Context ctx, AccountViewInfo account, Map difference) {
        int accountTypePty;
        List cfAccountDiffs = (List)difference.get("cashflowAccountDiffs");
        if (account.getAccountTypeID() != null && account.getAccountTypeID().getProperty() != null) {
            accountTypePty = account.getAccountTypeID().getProperty().getValue();
        } else {
            try {
                account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo(account.getId().toString());
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            accountTypePty = account.getAccountTypeID().getProperty().getValue();
        }
        return accountTypePty == 4 && (cfAccountDiffs == null || cfAccountDiffs.indexOf(account.getId().toString()) == -1);
    }

    private static void addCashflowRecordInfo(CashflowRecordInfo cfInfo, CashflowRecordCollection cfColl) {
        for (int i = 0; i < cfColl.size(); ++i) {
            CashflowRecordInfo cf = cfColl.get(i);
            if (!VoucherSubmitCashFlowAuto.isSameEntryCashflowRecord(cfInfo, cf)) continue;
            cf.setOriginalAmount(cf.getOriginalAmount() == null ? cfInfo.getOriginalAmount() : cf.getOriginalAmount().add(cfInfo.getOriginalAmount()));
            cf.setLocalAmount(cf.getLocalAmount() == null ? cfInfo.getLocalAmount() : cf.getLocalAmount().add(cfInfo.getLocalAmount()));
            cf.setReportingAmount(cf.getReportingAmount() == null ? cfInfo.getReportingAmount() : cf.getReportingAmount().add(cfInfo.getReportingAmount()));
            return;
        }
        cfColl.add(cfInfo);
    }

    private static boolean isSameEntryCashflowRecord(CashflowRecordInfo srcCf, CashflowRecordInfo destCf) {
        if (srcCf.getItemFlag() == ItemFlag.DISPOSE) {
            return srcCf.getItemFlag() == destCf.getItemFlag() && VoucherSubmitCashFlowAuto.equals(srcCf.getEntry(), destCf.getEntry()) && VoucherSubmitCashFlowAuto.equals(srcCf.getOpposingAccountEntry(), destCf.getOpposingAccountEntry()) && srcCf.getEntry().getEntryDC() == destCf.getEntry().getEntryDC();
        }
        return srcCf.getItemFlag() == destCf.getItemFlag() && VoucherSubmitCashFlowAuto.equals(srcCf.getEntry(), destCf.getEntry()) && srcCf.getEntry().getEntryDC() == destCf.getEntry().getEntryDC() && VoucherSubmitCashFlowAuto.equals(srcCf.getOpposingAccountEntry(), destCf.getOpposingAccountEntry()) && VoucherSubmitCashFlowAuto.equals(srcCf.getOppVoucherAssistRecord(), destCf.getOppVoucherAssistRecord()) && VoucherSubmitCashFlowAuto.equals(srcCf.getAssGrp(), destCf.getAssGrp()) && VoucherSubmitCashFlowAuto.equals(srcCf.getPrimaryItem(), destCf.getPrimaryItem()) && VoucherSubmitCashFlowAuto.equals(srcCf.getSupplementaryItem(), destCf.getSupplementaryItem()) && VoucherSubmitCashFlowAuto.equals(srcCf.getFullInfoItem(), destCf.getFullInfoItem()) && srcCf.getType() == destCf.getType();
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 instanceof CoreBaseInfo && obj2 instanceof CoreBaseInfo) {
            return obj1 != null && ((CoreBaseInfo)obj1).getId() != null && obj2 != null && ((CoreBaseInfo)obj2).getId() != null && ((CoreBaseInfo)obj1).getId().equals((Object)((CoreBaseInfo)obj2).getId());
        }
        return obj1 != null && obj1.equals(obj2);
    }

    public static Map getCashflowDifference(Context ctx, String companyId) throws EASBizException, BOSException {
        Map diff = VoucherProcessCache.getDifference(ctx, companyId);
        HashMap result = new HashMap();
        CashFlowKeepActivityCollection cfkaColl = (CashFlowKeepActivityCollection)diff.get("CashFlowKeepActivityCollection");
        ArrayList<String> cfKeepActivities = new ArrayList<String>();
        if (cfkaColl != null && !cfkaColl.isEmpty()) {
            for (int i = 0; i < cfkaColl.size(); ++i) {
                cfKeepActivities.add(cfkaColl.get(i).getConCashFlowItem().getId().toString());
            }
        }
        result.put("cashflowKeepActivities", cfKeepActivities);
        CashFlowAccountDiffCollection placColl = (CashFlowAccountDiffCollection)diff.get("CashFlowAccountDiffCollection");
        ArrayList<String> cfAccountDiffs = new ArrayList<String>();
        if (placColl != null && !placColl.isEmpty()) {
            for (int i = 0; i < placColl.size(); ++i) {
                cfAccountDiffs.add(placColl.get(i).getDiffAccount().getId().toString());
            }
        }
        result.put("cashflowAccountDiffs", cfAccountDiffs);
        result.put("cashFlowAccountDiffCollection", placColl);
        result.put("cashFlowKeepActivityCollection", cfkaColl);
        return result;
    }

    private static void setIsSupItem(CashflowRecordCollection cfColl) {
        for (int i = 0; i < cfColl.size(); ++i) {
            CashflowRecordInfo record = cfColl.get(i);
            if (record.getItemFlag() != ItemFlag.SUPPLEMENTARY) continue;
            record.setIsSupItem(true);
        }
    }

    private static ItemFlag getItemFlag(Context ctx, CashflowRecordInfo record, Map diff) {
        AccountViewInfo acount = record.getAccount();
        AccountViewInfo oppAccount = record.getOppAccount();
        if (acount != null && acount.getId() != null && acount.getAccountTableID() == null) {
            try {
                acount = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(acount.getId().toString()));
                record.setAccount(acount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oppAccount != null && oppAccount.getId() != null && oppAccount.getAccountTableID() == null) {
            try {
                oppAccount = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(oppAccount.getId().toString()));
                record.setOppAccount(oppAccount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List accountDiffs = (List)diff.get("cashflowAccountDiffs");
        if ((acount.isIsCash() || acount.isIsBank() || acount.isIsCashEquivalent()) && (oppAccount.isIsCash() || oppAccount.isIsBank() || oppAccount.isIsCashEquivalent())) {
            return ItemFlag.DISPOSE;
        }
        if (AccountProperty.SUNYI == acount.getAccountTypeID().getProperty() && !accountDiffs.contains(acount.getId().toString()) && AccountProperty.SUNYI == oppAccount.getAccountTypeID().getProperty() && !accountDiffs.contains(oppAccount.getId().toString())) {
            return ItemFlag.DISPOSE;
        }
        if ((acount.isIsCash() || acount.isIsBank() || acount.isIsCashEquivalent()) && record.getPrimaryItem() != null && record.getSupplementaryItem() != null) {
            return ItemFlag.BOTH;
        }
        if (acount.isIsCash() || acount.isIsBank() || acount.isIsCashEquivalent()) {
            return ItemFlag.PRIMARY;
        }
        if (AccountProperty.SUNYI == acount.getAccountTypeID().getProperty() && !accountDiffs.contains(acount.getId().toString())) {
            return ItemFlag.SUPPLEMENTARY;
        }
        return ItemFlag.FULLINFO;
    }

    private static int getPrimaryCoeff(CashFlowItemInfo primaryItem, VoucherEntryInfo ownEntry) {
        int coef = 1;
        CashFlowDirection direct = primaryItem.getDirection();
        if (EntryDC.DEBIT.equals((Object)ownEntry.getEntryDC()) && CashFlowDirection.OUT.equals((Object)direct) || EntryDC.CREDIT.equals((Object)ownEntry.getEntryDC()) && CashFlowDirection.IN.equals((Object)direct)) {
            coef = -1;
        }
        return coef;
    }

    private static int getSupplementaryCoeff(VoucherInfo voucher, VoucherEntryInfo ownEntry, VoucherEntryInfo oppEntry, CashflowRecordInfo record, Map diff) throws EASBizException, BOSException {
        int coef;
        AccountViewInfo account = ownEntry.getAccount();
        if (account.isIsCash() || account.isIsBank() || account.isIsCashEquivalent()) {
            List accountDiffs = (List)diff.get("cashflowAccountDiffs");
            if (AccountProperty.SUNYI == oppEntry.getAccount().getAccountTypeID().getProperty() && !accountDiffs.contains(oppEntry.getAccount().getId().toString())) {
                int coef2;
                int n = coef2 = EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC()) ? 1 : -1;
                if (oppEntry.getEntryDC().equals((Object)ownEntry.getEntryDC())) {
                    coef2 *= -1;
                }
                return coef2;
            }
            List keepActiveDiffs = (List)diff.get("cashflowKeepActivities");
            int coef3 = -1;
            if (record.getPrimaryItem() != null && record.getPrimaryItem().isIsDealActivity() && !keepActiveDiffs.contains(record.getPrimaryItem().getId().toString())) {
                coef3 = CashFlowDirection.IN.equals((Object)record.getPrimaryItem().getDirection()) ? record.getPrimaryCoefficient() : record.getPrimaryCoefficient() * -1;
            } else if (oppEntry.getEntryDC().equals((Object)ownEntry.getEntryDC())) {
                coef3 *= -1;
            }
            return coef3;
        }
        int n = coef = EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC()) ? -1 : 1;
        if (oppEntry.getEntryDC().equals((Object)ownEntry.getEntryDC())) {
            coef *= -1;
        }
        return coef;
    }

    private static VoucherEntryInfo getVoucherEntryInfo(VoucherInfo voucherInfo, int seq) {
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (entry.getSeq() != seq) continue;
            if (entry.get("entryid") != null) {
                entry.setId(BOSUuid.read((String)((String)entry.get("entryid"))));
            }
            return entry;
        }
        return null;
    }

    private static VoucherAssistRecordInfo getVoucherAssistRecordInfo(VoucherInfo voucherInfo, int seq) {
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            String recordId;
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (entry.getSeq() != seq || StringUtils.isEmpty((String)(recordId = (String)entry.get("assistrecordid")))) continue;
            VoucherAssistRecordInfo record = new VoucherAssistRecordInfo();
            record.setId(BOSUuid.read((String)recordId));
            AssistantHGInfo hg = (AssistantHGInfo)entry.getAccount().get("assgrp");
            record.setAssGrp(hg);
            record.setEntry(entry);
            record.setOriginalAmount(entry.getOriginalAmount());
            record.setLocalAmount(entry.getLocalAmount());
            record.setReportingAmount(entry.getReportingAmount());
            return record;
        }
        return null;
    }

    public static void fillAutoSetCashFlowItem(Context ctx, VoucherInfo voucherInfo) throws BOSException {
        int i;
        VoucherEntryCollection voucherEntries = voucherInfo.getEntries();
        HashSet<String> accountSet = new HashSet<String>();
        AccountViewCollection accouts = null;
        for (i = 0; i < voucherEntries.size(); ++i) {
            if (voucherEntries.get(i).getAccount() == null) continue;
            accountSet.add(voucherEntries.get(i).getAccount().getId().toString());
        }
        if (accountSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(VoucherSubmitCashFlowAuto.getAccountInfoSelector());
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", accountSet, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            accouts = ctx == null ? AccountViewFactory.getRemoteInstance().getAccountViewCollection(view) : AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        }
        for (i = 0; i < accouts.size(); ++i) {
            AccountViewInfo account = accouts.get(i);
            for (int j = 0; j < voucherEntries.size(); ++j) {
                AccountViewInfo entryAccount = voucherEntries.get(j).getAccount();
                if (entryAccount == null || !entryAccount.getId().toString().equals(account.getId().toString())) continue;
                entryAccount.setBorrowerMainCashFlowItem(account.getBorrowerMainCashFlowItem());
                entryAccount.setBorrowerAttCashFlowItem(account.getBorrowerAttCashFlowItem());
                entryAccount.setLenderMainCashFlowItem(account.getLenderMainCashFlowItem());
                entryAccount.setLenderAttCashFlowItem(account.getLenderAttCashFlowItem());
            }
        }
    }

    private static SelectorItemCollection getAccountInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("accountTypeID.property");
        selector.add("borrowerMainCashFlowItem.id");
        selector.add("borrowerMainCashFlowItem.name");
        selector.add("borrowerMainCashFlowItem.number");
        selector.add("borrowerMainCashFlowItem.isLeaf");
        selector.add("borrowerMainCashFlowItem.level");
        selector.add("borrowerMainCashFlowItem.longNumber");
        selector.add("borrowerMainCashFlowItem.type");
        selector.add("borrowerMainCashFlowItem.isFreeze");
        selector.add("borrowerMainCashFlowItem.isDealActivity");
        selector.add("borrowerMainCashFlowItem.direction");
        selector.add("borrowerMainCashFlowItem.displayName");
        selector.add("borrowerMainCashFlowItem.isProfit");
        selector.add("borrowerMainCashFlowItem.isEnable");
        selector.add("borrowerMainCashFlowItem.asstAccount.id");
        selector.add("borrowerAttCashFlowItem.id");
        selector.add("borrowerAttCashFlowItem.name");
        selector.add("borrowerAttCashFlowItem.number");
        selector.add("borrowerAttCashFlowItem.isLeaf");
        selector.add("borrowerAttCashFlowItem.level");
        selector.add("borrowerAttCashFlowItem.longNumber");
        selector.add("borrowerAttCashFlowItem.type");
        selector.add("borrowerAttCashFlowItem.isFreeze");
        selector.add("borrowerAttCashFlowItem.isDealActivity");
        selector.add("borrowerAttCashFlowItem.direction");
        selector.add("borrowerAttCashFlowItem.displayName");
        selector.add("borrowerAttCashFlowItem.isProfit");
        selector.add("borrowerAttCashFlowItem.isEnable");
        selector.add("borrowerAttCashFlowItem.asstAccount.id");
        selector.add("lenderMainCashFlowItem.id");
        selector.add("lenderMainCashFlowItem.name");
        selector.add("lenderMainCashFlowItem.number");
        selector.add("lenderMainCashFlowItem.isLeaf");
        selector.add("lenderMainCashFlowItem.level");
        selector.add("lenderMainCashFlowItem.longNumber");
        selector.add("lenderMainCashFlowItem.type");
        selector.add("lenderMainCashFlowItem.isFreeze");
        selector.add("lenderMainCashFlowItem.isDealActivity");
        selector.add("lenderMainCashFlowItem.direction");
        selector.add("lenderMainCashFlowItem.displayName");
        selector.add("lenderMainCashFlowItem.isProfit");
        selector.add("lenderMainCashFlowItem.isEnable");
        selector.add("lenderMainCashFlowItem.asstAccount.id");
        selector.add("lenderAttCashFlowItem.id");
        selector.add("lenderAttCashFlowItem.name");
        selector.add("lenderAttCashFlowItem.number");
        selector.add("lenderAttCashFlowItem.isLeaf");
        selector.add("lenderAttCashFlowItem.level");
        selector.add("lenderAttCashFlowItem.longNumber");
        selector.add("lenderAttCashFlowItem.type");
        selector.add("lenderAttCashFlowItem.isFreeze");
        selector.add("lenderAttCashFlowItem.isDealActivity");
        selector.add("lenderAttCashFlowItem.direction");
        selector.add("lenderAttCashFlowItem.displayName");
        selector.add("lenderAttCashFlowItem.isProfit");
        selector.add("lenderAttCashFlowItem.isEnable");
        selector.add("lenderAttCashFlowItem.asstAccount.id");
        return selector;
    }

    private static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }
}

