/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherAssistRecordValidator;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherBaseValidator;
import com.kingdee.eas.fi.gl.app.voucher.IVoucherEntryValidator;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class VoucherValidator {
    protected static final Logger logger = Logger.getLogger(VoucherValidator.class);
    private List baseValidator = new ArrayList();
    private List entryValidator = new ArrayList();
    private List recordValidator = new ArrayList();

    public void validate(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        for (IVoucherBaseValidator baseValidator : this.baseValidator) {
            if (baseValidator == null) continue;
            baseValidator.validate(ctx, (BaseVoucherInfo)voucherInfo);
        }
        if (voucherInfo.getEntries() != null) {
            for (VoucherEntryInfo entryInfo : voucherInfo.getEntries()) {
                if (entryInfo == null) continue;
                for (IVoucherEntryValidator entryValidator : this.entryValidator) {
                    if (entryValidator == null) continue;
                    entryValidator.validate(ctx, voucherInfo, entryInfo);
                }
                if (entryInfo.getAssistRecords() == null) continue;
                for (VoucherAssistRecordInfo recoredInfo : entryInfo.getAssistRecords()) {
                    if (recoredInfo == null) continue;
                    for (IVoucherAssistRecordValidator recordValidator : this.recordValidator) {
                        if (recordValidator == null) continue;
                        recordValidator.validate(ctx, voucherInfo, entryInfo, recoredInfo);
                    }
                }
            }
        }
    }

    public void addVoucherBaseValidator(IVoucherBaseValidator validator) {
        this.baseValidator.add(validator);
    }

    public void addVoucherEntryValidator(IVoucherEntryValidator validator) {
        this.entryValidator.add(validator);
    }

    public void addVoucherAssistRecordValidator(IVoucherAssistRecordValidator validator) {
        this.recordValidator.add(validator);
    }
}

