/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowDirection;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowKeepActivityCollection;
import com.kingdee.eas.basedata.master.account.AccountProperty;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowRecordCollection;
import com.kingdee.eas.fi.gl.CashflowRecordFactory;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ItemFlag;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.app.voucher.WebUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebCashflowUtils {
    public static CashflowRecordCollection toCashflowRecordCollection(Context ctx, VoucherInfo voucher, List cfList) throws EASBizException, BOSException {
        Map<String, List<String>> diff = WebCashflowUtils.getCashflowDifference(voucher.getCompany().getId().toString());
        CashflowRecordCollection coll = new CashflowRecordCollection();
        boolean useRptCurrency = (Boolean)((Map)voucher.getCompany().get("sysparam")).get("G001");
        boolean hasPrimaryRecord = false;
        HashMap<String, AsstActTypeCollection> atMap = new HashMap<String, AsstActTypeCollection>();
        for (int i = 0; i < cfList.size(); ++i) {
            CashflowRecordInfo cfInfo = new CashflowRecordInfo();
            Map cf = (Map)cfList.get(i);
            cfInfo.setVoucher(voucher);
            int entrySeq = new BigDecimal(cf.get("ownAccount").toString()).intValue();
            VoucherEntryInfo ownEntry = WebCashflowUtils.getVoucherEntryInfo(voucher, entrySeq);
            cfInfo.setEntry(ownEntry);
            cfInfo.setAccount(ownEntry.getAccount());
            cfInfo.setCurrency(ownEntry.getCurrency());
            cfInfo.setEntryDC(ownEntry.getEntryDC());
            int oppEntrySeq = new BigDecimal(cf.get("oppAccount").toString()).intValue();
            VoucherEntryInfo oppEntry = WebCashflowUtils.getVoucherEntryInfo(voucher, oppEntrySeq);
            cfInfo.setOpposingAccountEntry(oppEntry);
            cfInfo.setOppAccount(oppEntry.getAccount());
            VoucherAssistRecordInfo record = WebCashflowUtils.getVoucherAssistRecordInfo(voucher, oppEntrySeq);
            if (record != null) {
                cfInfo.setOppVoucherAssistRecord(record);
                cfInfo.setOppAssGrp(record.getAssGrp());
            }
            cfInfo.setOppEntryDC(oppEntry.getEntryDC());
            cfInfo.setPrimaryCoefficient(0);
            cfInfo.setSupplementaryCoefficient(0);
            if (cf.get("primaryItem") != null) {
                String primaryItemJon = JSONUtils.convertObjectToJson((Context)ctx, cf.get("primaryItem"));
                CashFlowItemInfo primaryItem = (CashFlowItemInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)primaryItemJon, CashFlowItemInfo.class);
                cfInfo.setPrimaryItem(primaryItem);
                Map assGrp = (Map)primaryItem.get("assgrp");
                if (primaryItem.getAsstAccount() != null && assGrp != null) {
                    AsstActTypeCollection atColl = (AsstActTypeCollection)atMap.get(primaryItem.getAsstAccount().getId().toString());
                    if (atColl == null) {
                        atColl = WebUtils.getAsstActTypeCollection(primaryItem.getAsstAccount().getId().toString());
                        atMap.put(primaryItem.getAsstAccount().getId().toString(), atColl);
                    }
                    cfInfo.setAssGrp(WebUtils.toAssGrpInfo(assGrp, primaryItem.getAsstAccount().getId().toString(), atColl));
                }
                int coef = WebCashflowUtils.getPrimaryCoeff(primaryItem, ownEntry);
                cfInfo.setPrimaryCoefficient(coef);
                hasPrimaryRecord = true;
            }
            if (cf.get("supplementaryItem") != null) {
                String supplementaryItemJon = JSONUtils.convertObjectToJson((Context)ctx, cf.get("supplementaryItem"));
                CashFlowItemInfo supplementaryItem = (CashFlowItemInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)supplementaryItemJon, CashFlowItemInfo.class);
                cfInfo.setSupplementaryItem(supplementaryItem);
                int coef = WebCashflowUtils.getSupplementaryCoeff(voucher, ownEntry, oppEntry, cfInfo, diff);
                cfInfo.setSupplementaryCoefficient(coef);
            }
            if (cf.get("fullInfoItem") != null) {
                String fullInfoItemJon = JSONUtils.convertObjectToJson((Context)ctx, cf.get("fullInfoItem"));
                CashFlowItemInfo fullInfoItem = (CashFlowItemInfo)JSONUtils.convertJsonToObject((Context)ctx, (String)fullInfoItemJon, CashFlowItemInfo.class);
                cfInfo.setFullInfoItem(fullInfoItem);
            }
            cfInfo.setItemFlag(WebCashflowUtils.getItemFlag(cfInfo, diff));
            int type = 2;
            Object typeObj = cf.get("type");
            if (typeObj != null && !StringUtils.isEmpty((String)typeObj.toString())) {
                type = new BigDecimal(cf.get("type").toString()).intValue();
            }
            cfInfo.setType(CashflowTypeEnum.getEnum((int)type));
            cfInfo.setOriginalAmount(cf.get("originalAmount") == null || StringUtils.isEmpty((String)cf.get("originalAmount").toString()) ? GlUtils.zero : new BigDecimal(cf.get("originalAmount").toString()));
            cfInfo.setLocalAmount(cf.get("localAmount") == null || StringUtils.isEmpty((String)cf.get("localAmount").toString()) ? GlUtils.zero : new BigDecimal(cf.get("localAmount").toString()));
            cfInfo.setReportingAmount(!useRptCurrency || cf.get("reportingAmount") == null || StringUtils.isEmpty((String)cf.get("reportingAmount").toString()) ? GlUtils.zero : new BigDecimal(cf.get("reportingAmount").toString()));
            WebCashflowUtils.addCashflowRecordInfo(cfInfo, coll);
        }
        if (hasPrimaryRecord) {
            WebCashflowUtils.setIsSupItem(coll);
        }
        CashflowRecordCollection newColl = new CashflowRecordCollection();
        for (int i = 0; i < coll.size(); ++i) {
            CashflowRecordInfo cfInfo = coll.get(i);
            if (!(cfInfo.getOriginalAmount() != null && cfInfo.getOriginalAmount().doubleValue() != 0.0 || cfInfo.getLocalAmount() != null && cfInfo.getLocalAmount().doubleValue() != 0.0 || useRptCurrency && cfInfo.getReportingAmount() != null && cfInfo.getReportingAmount().doubleValue() != 0.0)) continue;
            newColl.add(cfInfo);
        }
        return newColl;
    }

    private static void addCashflowRecordInfo(CashflowRecordInfo cfInfo, CashflowRecordCollection cfColl) {
        for (int i = 0; i < cfColl.size(); ++i) {
            CashflowRecordInfo cf = cfColl.get(i);
            if (!WebCashflowUtils.isSameEntryCashflowRecord(cfInfo, cf)) continue;
            cf.setOriginalAmount(cf.getOriginalAmount() == null ? cfInfo.getOriginalAmount() : cf.getOriginalAmount().add(cfInfo.getOriginalAmount()));
            cf.setLocalAmount(cf.getLocalAmount() == null ? cfInfo.getLocalAmount() : cf.getLocalAmount().add(cfInfo.getLocalAmount()));
            cf.setReportingAmount(cf.getReportingAmount() == null ? cfInfo.getReportingAmount() : cf.getReportingAmount().add(cfInfo.getReportingAmount()));
            return;
        }
        cfColl.add(cfInfo);
    }

    private static boolean isSameEntryCashflowRecord(CashflowRecordInfo srcCf, CashflowRecordInfo destCf) {
        if (srcCf.getItemFlag() == ItemFlag.DISPOSE) {
            return srcCf.getItemFlag() == destCf.getItemFlag() && WebCashflowUtils.equals(srcCf.getEntry(), destCf.getEntry()) && WebCashflowUtils.equals(srcCf.getOpposingAccountEntry(), destCf.getOpposingAccountEntry()) && srcCf.getEntry().getEntryDC() == destCf.getEntry().getEntryDC();
        }
        return srcCf.getItemFlag() == destCf.getItemFlag() && WebCashflowUtils.equals(srcCf.getEntry(), destCf.getEntry()) && srcCf.getEntry().getEntryDC() == destCf.getEntry().getEntryDC() && WebCashflowUtils.equals(srcCf.getOpposingAccountEntry(), destCf.getOpposingAccountEntry()) && WebCashflowUtils.equals(srcCf.getOppVoucherAssistRecord(), destCf.getOppVoucherAssistRecord()) && WebCashflowUtils.equals(srcCf.getAssGrp(), destCf.getAssGrp()) && WebCashflowUtils.equals(srcCf.getPrimaryItem(), destCf.getPrimaryItem()) && WebCashflowUtils.equals(srcCf.getSupplementaryItem(), destCf.getSupplementaryItem()) && WebCashflowUtils.equals(srcCf.getFullInfoItem(), destCf.getFullInfoItem()) && srcCf.getType() == destCf.getType();
    }

    private static boolean equals(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 instanceof CoreBaseInfo && obj2 instanceof CoreBaseInfo) {
            return obj1 != null && ((CoreBaseInfo)obj1).getId() != null && obj2 != null && ((CoreBaseInfo)obj2).getId() != null && ((CoreBaseInfo)obj1).getId().equals((Object)((CoreBaseInfo)obj2).getId());
        }
        return obj1 != null && obj1.equals(obj2);
    }

    public static Map<String, List<String>> getCashflowDifference(String companyId) throws EASBizException, BOSException {
        Map diff = CashflowRecordFactory.getRemoteInstance().getDifference(companyId);
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        CashFlowKeepActivityCollection cfkaColl = (CashFlowKeepActivityCollection)diff.get("CashFlowKeepActivityCollection");
        ArrayList<String> cfKeepActivities = new ArrayList<String>();
        if (cfkaColl != null && !cfkaColl.isEmpty()) {
            for (int i = 0; i < cfkaColl.size(); ++i) {
                cfKeepActivities.add(cfkaColl.get(i).getConCashFlowItem().getId().toString());
            }
        }
        result.put("cashflowKeepActivities", cfKeepActivities);
        CashFlowAccountDiffCollection placColl = (CashFlowAccountDiffCollection)diff.get("CashFlowAccountDiffCollection");
        ArrayList<String> cfAccountDiffs = new ArrayList<String>();
        if (placColl != null && !placColl.isEmpty()) {
            for (int i = 0; i < placColl.size(); ++i) {
                cfAccountDiffs.add(placColl.get(i).getDiffAccount().getId().toString());
            }
        }
        result.put("cashflowAccountDiffs", cfAccountDiffs);
        return result;
    }

    private static void setIsSupItem(CashflowRecordCollection cfColl) {
        for (int i = 0; i < cfColl.size(); ++i) {
            CashflowRecordInfo record = cfColl.get(i);
            if (record.getItemFlag() != ItemFlag.SUPPLEMENTARY) continue;
            record.setIsSupItem(true);
        }
    }

    private static ItemFlag getItemFlag(CashflowRecordInfo record, Map diff) {
        AccountViewInfo acount = record.getAccount();
        AccountViewInfo oppAccount = record.getOppAccount();
        if (acount != null && acount.getId() != null && acount.getAccountTableID() == null) {
            try {
                acount = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(acount.getId().toString()));
                record.setAccount(acount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (oppAccount != null && oppAccount.getId() != null && oppAccount.getAccountTableID() == null) {
            try {
                oppAccount = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(oppAccount.getId().toString()));
                record.setOppAccount(oppAccount);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List accountDiffs = (List)diff.get("cashflowAccountDiffs");
        if ((acount.isIsCash() || acount.isIsBank() || acount.isIsCashEquivalent()) && (oppAccount.isIsCash() || oppAccount.isIsBank() || oppAccount.isIsCashEquivalent())) {
            return ItemFlag.DISPOSE;
        }
        if (AccountProperty.SUNYI == acount.getAccountTypeID().getProperty() && !accountDiffs.contains(acount.getId().toString()) && AccountProperty.SUNYI == oppAccount.getAccountTypeID().getProperty() && !accountDiffs.contains(oppAccount.getId().toString())) {
            return ItemFlag.DISPOSE;
        }
        if ((acount.isIsCash() || acount.isIsBank() || acount.isIsCashEquivalent()) && record.getPrimaryItem() != null && record.getSupplementaryItem() != null) {
            return ItemFlag.BOTH;
        }
        if (acount.isIsCash() || acount.isIsBank() || acount.isIsCashEquivalent()) {
            return ItemFlag.PRIMARY;
        }
        if (AccountProperty.SUNYI == acount.getAccountTypeID().getProperty() && !accountDiffs.contains(acount.getId().toString())) {
            return ItemFlag.SUPPLEMENTARY;
        }
        return ItemFlag.FULLINFO;
    }

    private static int getPrimaryCoeff(CashFlowItemInfo primaryItem, VoucherEntryInfo ownEntry) {
        int coef = 1;
        CashFlowDirection direct = primaryItem.getDirection();
        if (EntryDC.DEBIT.equals((Object)ownEntry.getEntryDC()) && CashFlowDirection.OUT.equals((Object)direct) || EntryDC.CREDIT.equals((Object)ownEntry.getEntryDC()) && CashFlowDirection.IN.equals((Object)direct)) {
            coef = -1;
        }
        return coef;
    }

    private static int getSupplementaryCoeff(VoucherInfo voucher, VoucherEntryInfo ownEntry, VoucherEntryInfo oppEntry, CashflowRecordInfo record, Map diff) throws EASBizException, BOSException {
        int coef;
        AccountViewInfo account = ownEntry.getAccount();
        if (account.isIsCash() || account.isIsBank() || account.isIsCashEquivalent()) {
            List accountDiffs = (List)diff.get("cashflowAccountDiffs");
            if (AccountProperty.SUNYI == oppEntry.getAccount().getAccountTypeID().getProperty() && !accountDiffs.contains(oppEntry.getAccount().getId().toString())) {
                int coef2;
                int n = coef2 = EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC()) ? 1 : -1;
                if (oppEntry.getEntryDC().equals((Object)ownEntry.getEntryDC())) {
                    coef2 *= -1;
                }
                return coef2;
            }
            List keepActiveDiffs = (List)diff.get("cashflowKeepActivities");
            int coef3 = -1;
            if (record.getPrimaryItem() != null && record.getPrimaryItem().isIsDealActivity() && !keepActiveDiffs.contains(record.getPrimaryItem().getId().toString())) {
                coef3 = CashFlowDirection.IN.equals((Object)record.getPrimaryItem().getDirection()) ? record.getPrimaryCoefficient() : record.getPrimaryCoefficient() * -1;
            } else if (oppEntry.getEntryDC().equals((Object)ownEntry.getEntryDC())) {
                coef3 *= -1;
            }
            return coef3;
        }
        int n = coef = EntryDC.DEBIT.equals((Object)oppEntry.getEntryDC()) ? -1 : 1;
        if (oppEntry.getEntryDC().equals((Object)ownEntry.getEntryDC())) {
            coef *= -1;
        }
        return coef;
    }

    private static VoucherEntryInfo getVoucherEntryInfo(VoucherInfo voucherInfo, int seq) {
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (entry.getSeq() != seq) continue;
            if (entry.get("entryid") != null) {
                entry.setId(BOSUuid.read((String)((String)entry.get("entryid"))));
            }
            return entry;
        }
        return null;
    }

    private static VoucherAssistRecordInfo getVoucherAssistRecordInfo(VoucherInfo voucherInfo, int seq) {
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            String recordId;
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (entry.getSeq() != seq || StringUtils.isEmpty((String)(recordId = (String)entry.get("assistrecordid")))) continue;
            VoucherAssistRecordInfo record = new VoucherAssistRecordInfo();
            record.setId(BOSUuid.read((String)recordId));
            AssistantHGInfo hg = (AssistantHGInfo)entry.getAccount().get("assgrp");
            record.setAssGrp(hg);
            record.setEntry(entry);
            record.setOriginalAmount(entry.getOriginalAmount());
            record.setLocalAmount(entry.getLocalAmount());
            record.setReportingAmount(entry.getReportingAmount());
            return record;
        }
        return null;
    }
}

