/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.app.voucher;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IVoucherType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlLevelFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCtrlLevelInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WebUtils {
    public static boolean isGLFSSC(String module) {
        return "FSSC_GL".equals(module);
    }

    public static List getCurrencyComboList() throws EASBizException, BOSException {
        CurrencyCollection currencyColl = WebUtils.getCurrencyCollection();
        ArrayList currencyComboList = new ArrayList();
        for (int i = 0; i < currencyColl.size(); ++i) {
            CurrencyInfo currency = currencyColl.get(i);
            HashMap<String, Object> currencyMap = new HashMap<String, Object>();
            currencyMap.put("value", currency.getId().toString());
            currencyMap.put("alias", currency.getName());
            currencyMap.put("precision", currency.getPrecision());
            currencyMap.put("invalid", currency.getDeletedStatus() == DeletedStatusEnum.DELETED);
            currencyComboList.add(currencyMap);
        }
        return currencyComboList;
    }

    public static List<Map> getVoucherTypeList(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        sic.add(new SelectorItemInfo("level"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        IVoucherType iVoucherType = VoucherTypeFactory.getRemoteInstance();
        FilterInfo filterInfo = iVoucherType.getDatabaseDFilter((IObjectPK)new ObjectUuidPK(company.getCU().getId()), "id", "adminCU");
        view.setFilter(filterInfo);
        VoucherTypeCollection vtColl = iVoucherType.getVoucherTypeCollection(view);
        ArrayList<Map> voucherTypeList = new ArrayList<Map>();
        if (!vtColl.isEmpty()) {
            HashSet<String> vtIdSet = new HashSet<String>();
            for (int i = 0; i < vtColl.size(); ++i) {
                vtIdSet.add(vtColl.get(i).getId().toString());
            }
            EntityViewInfo ctrlView = new EntityViewInfo();
            ctrlView.getSelector().add(new SelectorItemInfo("voucherType.id"));
            ctrlView.getSelector().add(new SelectorItemInfo("level"));
            FilterInfo ctrlFilter = new FilterInfo();
            ctrlFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId()));
            ctrlFilter.getFilterItems().add(new FilterItemInfo("voucherType.id", vtIdSet, CompareType.INCLUDE));
            ctrlView.setFilter(ctrlFilter);
            CoreBaseCollection ctrlColl = VoucherTypeCtrlLevelFactory.getRemoteInstance().getCollection(ctrlView);
            for (int i = 0; i < vtColl.size(); ++i) {
                VoucherTypeInfo vcInfo = vtColl.get(i);
                HashMap<String, Object> vt = new HashMap<String, Object>();
                vt.put("value", vcInfo.getId().toString());
                vt.put("alias", vcInfo.getName());
                vt.put("isDefualt", vcInfo.isPretermit());
                int level = vcInfo.getLevel();
                for (int j = 0; j < ctrlColl.size(); ++j) {
                    VoucherTypeCtrlLevelInfo ctrlLevel = (VoucherTypeCtrlLevelInfo)ctrlColl.get(j);
                    if (!ctrlLevel.getVoucherType().getId().equals((Object)vcInfo.getId())) continue;
                    level = ctrlLevel.getLevel();
                    break;
                }
                vt.put("level", level);
                voucherTypeList.add(vt);
            }
        }
        return voucherTypeList;
    }

    public static List<Map> getVoucherTypeList(String[] cuIds) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        EntityViewInfo view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        IVoucherType vtCtrl = VoucherTypeFactory.getRemoteInstance();
        ObjectUuidPK[] pks = new ObjectUuidPK[cuIds.length];
        for (int i = 0; i < pks.length; ++i) {
            pks[i] = new ObjectUuidPK(cuIds[i]);
        }
        FilterInfo filterVT = vtCtrl.getDatabaseDFilter((IObjectPK[])pks, "id", "adminCU");
        view.setFilter(filterVT);
        VoucherTypeCollection vtCol = vtCtrl.getVoucherTypeCollection(view);
        ArrayList<Map> voucherTypeList = new ArrayList<Map>();
        for (int i = 0; i < vtCol.size(); ++i) {
            VoucherTypeInfo vtInfo = vtCol.get(i);
            HashMap<String, Object> vt = new HashMap<String, Object>();
            vt.put("value", vtInfo.getId().toString());
            vt.put("alias", vtInfo.getName());
            vt.put("isDefualt", vtInfo.isPretermit());
            voucherTypeList.add(vt);
        }
        return voucherTypeList;
    }

    public static String getDefaultVoucherTypeId(List<Map> voucherTypeList) throws BOSException, EASBizException {
        Iterator<Map> it = voucherTypeList.iterator();
        String defaultVoucherTypeId = null;
        Map topLevelDefVType = null;
        while (it.hasNext()) {
            Map vt = it.next();
            if (topLevelDefVType == null || vt.get("level") != null && (Integer)vt.get("level") < (Integer)topLevelDefVType.get("level")) {
                topLevelDefVType = vt;
            }
            if (!Boolean.TRUE.equals(vt.get("isDefualt"))) continue;
            defaultVoucherTypeId = (String)vt.get("value");
            break;
        }
        if (defaultVoucherTypeId != null) {
            return defaultVoucherTypeId;
        }
        if (topLevelDefVType != null) {
            return (String)topLevelDefVType.get("value");
        }
        if (!voucherTypeList.isEmpty()) {
            return (String)voucherTypeList.get(0).get("value");
        }
        return null;
    }

    public static PeriodInfo toPeriodInfo(String periodStr) {
        if (periodStr == null || periodStr.trim().length() == 0) {
            return null;
        }
        PeriodInfo periodInfo = new PeriodInfo();
        String[] pIt = periodStr.split(";");
        periodInfo.setId(BOSUuid.read((String)pIt[0]));
        int period = Integer.valueOf(pIt[1]);
        periodInfo.setNumber(period);
        periodInfo.setPeriodYear(period / 100);
        periodInfo.setPeriodNumber(period % 100);
        periodInfo.setIsAdjustPeriod(Boolean.valueOf(pIt[2]).booleanValue());
        return periodInfo;
    }

    public static AssistantHGInfo toAssGrpInfo(Map assGrp, String asstAccountId, AsstActTypeCollection atColl) throws BOSException, EASBizException {
        if (assGrp == null || StringUtils.isEmpty((String)asstAccountId)) {
            return null;
        }
        String hgId = (String)assGrp.get("id");
        if (StringUtils.isEmpty((String)hgId)) {
            HashMap dbMap = new HashMap();
            for (String attrName : assGrp.keySet()) {
                Object value = assGrp.get(attrName);
                if (value == null || !(value instanceof Map)) continue;
                Object dbId = ((Map)value).get("id");
                dbMap.put(attrName, dbId);
            }
            if (dbMap.isEmpty()) {
                return null;
            }
            IObjectPK pk = AssistantHGFactory.getRemoteInstance().getAssistantHGPK(asstAccountId, atColl, dbMap);
            hgId = pk.toString();
        }
        if (!StringUtils.isEmpty((String)hgId)) {
            AssistantHGInfo hg = new AssistantHGInfo();
            hg.setId(BOSUuid.read((String)hgId));
            return hg;
        }
        return null;
    }

    private static CurrencyCollection getCurrencyCollection() throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        view.getSelector().add(new SelectorItemInfo("deletedStatus"));
        return CurrencyFactory.getRemoteInstance().getCurrencyCollection(view, true);
    }

    public static AsstActTypeCollection getAsstActTypeCollection(String asstAccountId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selectors = view.getSelector();
        selectors.add(new SelectorItemInfo("asstActType.id"));
        selectors.add(new SelectorItemInfo("asstActType.name"));
        selectors.add(new SelectorItemInfo("asstActType.number"));
        selectors.add(new SelectorItemInfo("asstActType.asstHGAttribute"));
        selectors.add(new SelectorItemInfo("asstActType.isMultilevel"));
        selectors.add(new SelectorItemInfo("asstActType.useLongNumber"));
        FilterInfo fi = new FilterInfo();
        view.setFilter(fi);
        FilterItemCollection filters = fi.getFilterItems();
        filters.add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        AsstActGroupDetailCollection detail = AsstActGroupDetailFactory.getRemoteInstance().getAsstActGroupDetailCollection(view);
        AsstActTypeCollection atColl = new AsstActTypeCollection();
        for (int i = 0; i < detail.size(); ++i) {
            atColl.add(detail.get(i).getAsstActType());
        }
        return atColl;
    }
}

