/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDCurrencyEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.calc.CalculatorF7Binder;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7Parameter;
import com.kingdee.eas.fi.gl.client.asstf7.GLF7handler;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Container;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class GLEditor {
    private static final Logger logger = Logger.getLogger(GLEditor.class);
    public static final int MIN_INTEGER_DIGIT = 9;
    public static final int MAX_INTEGER_DIGIT = 15;
    public static final int MIN_DECIMAL_DIGIT = 2;
    public static final int MAX_DECIMAL_DIGIT = 4;
    public static final int WIDTH_15INT = 209;
    public static final int WIDTH_9INT = 132;
    static KDTCellNumberEditorListener numberEditorListener = new KDTCellNumberEditorListener();

    public static ICellEditor getNumberEditor() {
        return GLEditor.getNumberEditor(false);
    }

    public static ICellEditor getNumberEditor(boolean userCurrencyEditor) {
        return GLEditor.getNumberEditor(userCurrencyEditor, false);
    }

    public static ICellEditor getNumberEditor(boolean userCurrencyEditor, boolean allInt) {
        return GLEditor.getNumberEditor(userCurrencyEditor, false, 2);
    }

    public static ICellEditor getNumberEditor(boolean userCurrencyEditor, boolean allInt, int pre) {
        KDTDefaultCellEditor numberEditor = null;
        if (userCurrencyEditor) {
            KDCurrencyEditor editopr = new KDCurrencyEditor(allInt ? 15 : 9, pre);
            numberEditor = new KDTDefaultCellEditor((IKDEditor)editopr);
        } else {
            KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
            formattedTextField.setHorizontalAlignment(4);
            formattedTextField.setDataVerifierType(-1);
            formattedTextField.setSupportedEmpty(true);
            formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
            formattedTextField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
            formattedTextField.addKeyListener((KeyListener)numberEditorListener);
            numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        }
        numberEditor.setClickCountToStart(1);
        return numberEditor;
    }

    public static ICellEditor getPositiveNumberEditor() {
        return GLEditor.getPositiveNumberEditor(false);
    }

    public static ICellEditor getPositiveNumberEditor(boolean userCurrencyEditor) {
        return GLEditor.getPositiveNumberEditor(userCurrencyEditor, false);
    }

    public static ICellEditor getPositiveNumberEditor(boolean userCurrencyEditor, boolean allInt) {
        return GLEditor.getPositiveNumberEditor(userCurrencyEditor, false, 2);
    }

    public static ICellEditor getPositiveNumberEditor(boolean userCurrencyEditor, boolean allInt, int pre) {
        KDTDefaultCellEditor numberEditor = null;
        if (userCurrencyEditor) {
            KDCurrencyEditor editopr = new KDCurrencyEditor(allInt ? 15 : 9, pre);
            numberEditor = new KDTDefaultCellEditor((IKDEditor)editopr);
        } else {
            KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
            formattedTextField.setHorizontalAlignment(4);
            formattedTextField.setDataVerifierType(-1);
            formattedTextField.setSupportedEmpty(true);
            formattedTextField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
            formattedTextField.setMinimumValue((Comparable)GlUtils.zero);
            formattedTextField.addKeyListener((KeyListener)numberEditorListener);
            numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        }
        numberEditor.setClickCountToStart(1);
        return numberEditor;
    }

    public static ICellEditor getNumberEditor(ICellEditor numberEditor, Map ctx) {
        return GLEditor.getNumberEditor(numberEditor, ctx, false, false, 2);
    }

    public static ICellEditor getNumberEditor(ICellEditor numberEditor, Map ctx, boolean userCurrencyEditor, boolean allInt, int pre) {
        if (numberEditor == null) {
            numberEditor = GLEditor.getNumberEditor(userCurrencyEditor, allInt, pre);
            Container con = (Container)ctx.get("Owner");
            if (con != null) {
                Container parent;
                for (parent = con; parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
                }
                if (parent != null) {
                    CalculatorF7Binder cb = new CalculatorF7Binder(con);
                    cb.bindF7Key(numberEditor, 6, true);
                }
            }
        }
        return numberEditor;
    }

    public static ICellEditor getPositiveNumberEditor(ICellEditor positiveNumberEditor, Map ctx) {
        return GLEditor.getPositiveNumberEditor(positiveNumberEditor, ctx, false, false, 2);
    }

    public static ICellEditor getPositiveNumberEditor(ICellEditor positiveNumberEditor, Map ctx, boolean userCurrencyEditor, boolean allInt, int pre) {
        if (positiveNumberEditor == null) {
            positiveNumberEditor = GLEditor.getPositiveNumberEditor(userCurrencyEditor, allInt, pre);
            Container con = (Container)ctx.get("Owner");
            if (con != null) {
                Container parent;
                for (parent = con; parent != null && !(parent instanceof JFrame); parent = parent.getParent()) {
                }
                if (parent != null) {
                    CalculatorF7Binder cb = new CalculatorF7Binder(con);
                    cb.bindF7Key(positiveNumberEditor, 6, true);
                }
            }
        }
        return positiveNumberEditor;
    }

    public static ICellEditor getCellEditor(AsstActTypeInfo asstActInfo, CoreUIObject ui) {
        return GLEditor.getCellEditor(asstActInfo, ui, true);
    }

    public static ICellEditor getCellEditor(AsstActTypeInfo asstActInfo, CoreUIObject ui, boolean onlyLeaf) {
        KDBizPromptBox bizPromptBox = new KDBizPromptBox();
        bizPromptBox.setEditable(true);
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setDisplayFormat("$number$;$name$");
        bizPromptBox.setCommitFormat("$number$;$name$");
        bizPromptBox.setQueryInfo(asstActInfo.getDefaultQueryName());
        bizPromptBox.setDefaultF7UIName(asstActInfo.getDefaultF7UI());
        GLF7Parameter f7Param = new GLF7Parameter();
        f7Param.setOnlyLeaf(onlyLeaf);
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)asstActInfo.get("aacCompany");
        if (currentCompany == null) {
            currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        }
        GLF7handler.assignSelector((CoreUIObject)ui, (KDBizPromptBox)bizPromptBox, (AsstActTypeInfo)asstActInfo, (CompanyOrgUnitInfo)currentCompany, (GLF7Parameter)f7Param);
        return new KDTDefaultCellEditor((IKDEditor)bizPromptBox);
    }

    protected ICellEditor getCellEditor(String columnType) {
        if ("String".equalsIgnoreCase(columnType)) {
            return GLEditor.getTextField();
        }
        if ("Date".equalsIgnoreCase(columnType)) {
            return GLEditor.getKDDatePicker();
        }
        if ("Double".equalsIgnoreCase(columnType)) {
            return GLEditor.getNumberEditor();
        }
        if ("Integer".equalsIgnoreCase(columnType)) {
            return GLEditor.getPositiveNumberEditor();
        }
        if ("Enum".equalsIgnoreCase(columnType)) {
            return GLEditor.getComboBox();
        }
        return GLEditor.getCkeckBox();
    }

    public static ICellEditor getKDDatePicker() {
        KDDatePicker bizDate = new KDDatePicker();
        bizDate.setSupportedEmpty(false);
        return new KDTDefaultCellEditor(bizDate);
    }

    public static ICellEditor getComboBox() {
        KDComboBox box = new KDComboBox();
        return new KDTDefaultCellEditor((JComboBox)box);
    }

    public static ICellEditor getComboBox(String query) {
        KDComboBox box = new KDComboBox();
        Class<?> c = null;
        Method method = null;
        try {
            c = Class.forName(query);
            method = c.getMethod("getEnumList", null);
            box = new KDComboBox(((List)method.invoke(null, null)).toArray());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        catch (SecurityException e) {
            logger.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
        }
        catch (InvocationTargetException e) {
            logger.error((Object)e);
        }
        return new KDTDefaultCellEditor((JComboBox)box);
    }

    public static ICellEditor getComboBox(List list) {
        KDComboBox box = new KDComboBox();
        box.addItems(list.toArray());
        return new KDTDefaultCellEditor((JComboBox)box);
    }

    public static ICellEditor getCkeckBox() {
        KDCheckBox box = new KDCheckBox();
        return new KDTDefaultCellEditor((JCheckBox)box);
    }

    public static ICellEditor getTextField() {
        KDTDefaultCellEditor textEditor = new KDTDefaultCellEditor((JTextField)new KDTextField());
        textEditor.setClickCountToStart(1);
        return textEditor;
    }

    public static Object setSelectedItem(KDComboBox cb, Object obj) {
        ComboBoxModel model = cb.getModel();
        Object rtn_ele = null;
        int n = model.getSize();
        for (int i = 0; i < n; ++i) {
            Object element = model.getElementAt(i);
            if (element instanceof IntEnum && obj instanceof Integer && ((IntEnum)element).getValue() == ((Integer)obj).intValue()) {
                cb.setSelectedIndex(i);
                rtn_ele = element;
                break;
            }
            if (element instanceof IntEnum && obj instanceof IntEnum && ((IntEnum)element).getValue() == ((IntEnum)obj).getValue()) {
                cb.setSelectedIndex(i);
                rtn_ele = element;
                break;
            }
            if (!(obj instanceof StringEnum) || !((StringEnum)element).getValue().equals(obj)) continue;
            cb.setSelectedIndex(i);
            rtn_ele = element;
            break;
        }
        return rtn_ele;
    }

    static class KDTCellNumberEditorListener
    implements KeyListener {
        KDTCellNumberEditorListener() {
        }

        @Override
        public void keyPressed(KeyEvent arg0) {
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }
}

