/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.eas.fi.gl.GLConfig;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class GLExecutor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.common.GLExecutor");
    private static ThreadPoolExecutor executor = null;

    public static synchronized void execute(Runnable task) {
        GLExecutor.init();
        executor.execute(task);
    }

    public static synchronized void close() {
        if (executor != null) {
            executor.shutdown();
            executor = null;
        }
    }

    private static void init() {
        if (executor != null) {
            return;
        }
        int corePoolSize = 4;
        int maximumPoolSize = 16;
        try {
            String str = GLConfig.getString("CORE_POOL_SIZE");
            int core = Integer.parseInt(str);
            str = GLConfig.getString("MAX_POOL_SIZE");
            int max = Integer.parseInt(str);
            if (core >= 1 && max >= core && max <= 128) {
                corePoolSize = core;
                maximumPoolSize = max;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Load GLExecutor Config fail!", (Throwable)e);
        }
        executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        logger.info((Object)("GLExecutor init CORE_POOL_SIZE:" + corePoolSize + ", MAX_POOL_SIZE:" + maximumPoolSize));
    }
}

