/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.IOrgPermFilter;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgPermFilterFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class GLOrgUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.common.GLOrgUtil");

    public static HashMap getAuthorizedOrgViewIDs(Context ctx, IObjectPK userPK, OrgViewType orgViewType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws EASBizException, BOSException {
        HashMap ret = null;
        IPermission iPermission = ctx != null ? PermissionFactory.getLocalInstance((Context)ctx) : PermissionFactory.getRemoteInstance();
        OrgTypeInfo curOrgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
        OrgType curOrgType = null;
        if (curOrgTypeInfo != null) {
            curOrgType = curOrgTypeInfo.getOrgType();
        }
        if (curOrgTypeInfo != null && curOrgType != null && !curOrgTypeInfo.isBasicOrgType()) {
            ret = (HashMap)iPermission.getAuthorizedOrgs(userPK, curOrgType, orgTreePK, uiPK, actionPK);
            INewOUInnerFacade iNOU = ctx != null ? NewOUInnerFacadeFactory.getLocalInstance((Context)ctx) : NewOUInnerFacadeFactory.getRemoteInstance();
            HashMap importCompany = (HashMap)iNOU.getCompanyFromUnionGroup(orgTreePK.toString(), ret);
            ret.putAll(importCompany);
        } else if (orgViewType.getValue() == 15) {
            ret = (HashMap)iPermission.getAuthorizedOrgs(userPK, OrgType.Company, orgTreePK, uiPK, actionPK);
            if (ret == null) {
                ret = new HashMap();
            }
            HashMap map1 = (HashMap)iPermission.getAuthorizedOrgs(userPK, OrgType.CostCenter, orgTreePK, uiPK, actionPK);
            HashMap map2 = (HashMap)iPermission.getAuthorizedOrgs(userPK, OrgType.ProfitCenter, orgTreePK, uiPK, actionPK);
            if (map1 != null) {
                ret.putAll(map1);
            }
            if (map2 != null) {
                ret.putAll(map2);
            }
        } else {
            ret = (HashMap)iPermission.getAuthorizedOrgs(userPK, NewOrgViewHelper.convert((OrgViewType)orgViewType), orgTreePK, uiPK, actionPK);
        }
        if (ret == null) {
            ret = new HashMap();
        }
        return ret;
    }

    public static boolean isOrgValid(Context ctx, String asstHGAttribute, String orgId, String companyId, String userId) throws BOSException, EASBizException {
        HashMap<String, String> hmParamIn = new HashMap<String, String>();
        hmParamIn.put("GL_043", companyId);
        hmParamIn.put("GL_069", companyId);
        IParamControl pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap paramsOrgPerm = pc.getParamHashMap(hmParamIn);
        boolean isOrgPermission = false;
        boolean isChooseAsstCom = true;
        if (paramsOrgPerm != null) {
            if (paramsOrgPerm.get("GL_043") != null) {
                isOrgPermission = Boolean.valueOf(paramsOrgPerm.get("GL_043").toString());
            }
            if (paramsOrgPerm.get("GL_069") != null) {
                isChooseAsstCom = Boolean.valueOf(paramsOrgPerm.get("GL_069").toString());
            }
        }
        return GLOrgUtil.isOrgValid(ctx, asstHGAttribute, orgId, companyId, userId, isChooseAsstCom, isOrgPermission);
    }

    public static boolean isOrgValid(Context ctx, String asstHGAttribute, String orgId, String companyId, String userId, boolean isChooseAsstCom, boolean isOrgPermission) throws BOSException, EASBizException {
        OrgViewType orgViewType = OrgViewType.COMPANY;
        OrgType orgType = OrgType.Company;
        if (asstHGAttribute.equals("saleOrg")) {
            orgViewType = OrgViewType.SALE;
            orgType = OrgType.Sale;
        } else if (asstHGAttribute.equals("profitOrg")) {
            orgViewType = OrgViewType.PROFITCENTER;
            orgType = OrgType.ProfitCenter;
        } else if (asstHGAttribute.equals("purchaseOrg")) {
            orgViewType = OrgViewType.PURCHASE;
            orgType = OrgType.Purchase;
        } else if (asstHGAttribute.equals("storeageOrg")) {
            orgViewType = OrgViewType.STORAGE;
            orgType = OrgType.Storage;
        } else if (asstHGAttribute.equals("costOrg")) {
            orgViewType = OrgViewType.COSTCENTER;
            orgType = OrgType.CostCenter;
        } else if (asstHGAttribute.equals("adminOrg")) {
            orgViewType = OrgViewType.ADMIN;
            orgType = OrgType.Admin;
        }
        if (!orgId.equals(companyId)) {
            HashMap map;
            if (isChooseAsstCom) {
                IOrgPermFilter filter = ctx != null ? OrgPermFilterFactory.getLocalInstance((Context)ctx) : OrgPermFilterFactory.getRemoteInstance();
                HashSet set = filter.getRelationUnitID(orgType, companyId);
                if (set != null && !set.contains(orgId)) {
                    StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"386_GLOrgUtil"));
                    sb.append(companyId + EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"387_GLOrgUtil"));
                    sb.append(orgId).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"388_GLOrgUtil"));
                    sb.append(companyId).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"389_GLOrgUtil"));
                    logger.info((Object)sb.toString());
                    return false;
                }
            } else if (isOrgPermission && (map = GLOrgUtil.getAuthorizedOrgViewIDs(ctx, (IObjectPK)new ObjectUuidPK(userId), orgViewType, null, null, null)).get(orgId) == null) {
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"386_GLOrgUtil"));
                sb.append(companyId).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"390_GLOrgUtil"));
                sb.append(userId).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"391_GLOrgUtil"));
                sb.append(orgId);
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"392_GLOrgUtil"));
                logger.info((Object)sb.toString());
                return false;
            }
        }
        return true;
    }

    public static void orgValid(Context ctx, String asstHGAttribute, String orgId, String companyId, String userId, boolean isChooseAsstCom, boolean isOrgPermission) throws EASBizException, BOSException {
        OrgViewType orgViewType = OrgViewType.COMPANY;
        OrgType orgType = OrgType.Company;
        if (asstHGAttribute.equals("saleOrg")) {
            orgViewType = OrgViewType.SALE;
            orgType = OrgType.Sale;
        } else if (asstHGAttribute.equals("profitOrg")) {
            orgViewType = OrgViewType.PROFITCENTER;
            orgType = OrgType.ProfitCenter;
        } else if (asstHGAttribute.equals("purchaseOrg")) {
            orgViewType = OrgViewType.PURCHASE;
            orgType = OrgType.Purchase;
        } else if (asstHGAttribute.equals("storeageOrg")) {
            orgViewType = OrgViewType.STORAGE;
            orgType = OrgType.Storage;
        } else if (asstHGAttribute.equals("costOrg")) {
            orgViewType = OrgViewType.COSTCENTER;
            orgType = OrgType.CostCenter;
        } else if (asstHGAttribute.equals("adminOrg")) {
            orgViewType = OrgViewType.ADMIN;
            orgType = OrgType.Admin;
        }
        boolean passs = true;
        if (!orgId.equals(companyId)) {
            HashMap map;
            if (isChooseAsstCom) {
                IOrgPermFilter filter = ctx != null ? OrgPermFilterFactory.getLocalInstance((Context)ctx) : OrgPermFilterFactory.getRemoteInstance();
                HashSet set = filter.getRelationUnitID(orgType, companyId);
                if (set != null && !set.contains(orgId)) {
                    passs = false;
                }
            } else if (isOrgPermission && (map = GLOrgUtil.getAuthorizedOrgViewIDs(ctx, (IObjectPK)new ObjectUuidPK(userId), orgViewType, null, null, null)).get(orgId) == null) {
                passs = false;
            }
        }
        if (!passs) {
            IUser iUser;
            IFullOrgUnit iFullOrgUnit;
            ICompanyOrgUnit iCompany;
            if (ctx != null) {
                iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
                iUser = UserFactory.getLocalInstance((Context)ctx);
            } else {
                iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
                iUser = UserFactory.getRemoteInstance();
            }
            CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
            FullOrgUnitInfo org = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgId)));
            UserInfo user = iUser.getUserByID((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)userId)));
            if (isChooseAsstCom) {
                throw new GLException(GLException.ASST_NO_ACCOUNTRELATION, new Object[]{company.getName(), org.getName(), company.getName()});
            }
            throw new GLException(GLException.ASST_NO_ORGRANGE_PERMISSION, new Object[]{company.getName(), user.getName(), org.getName()});
        }
    }
}

