/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.ILicenseSrv;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.agent.LicenseSrvFactory;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.common.RSAUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class LicenseChecker {
    public static String SYS_NAME = "GovAcc";
    private static int value = -1;

    public static void check(Context ctx) throws BOSException, VoucherException {
        if (ctx != null) {
            return;
        }
        if (value >= 0) {
            if (value == 0) {
                throw new VoucherException(VoucherException.GOVACC_LICENSE_OVERDUE);
            }
            return;
        }
        LicenseChecker.doCheck();
    }

    private static synchronized void doCheck() throws BOSException, VoucherException {
        if (value == -1) {
            int n = value = LicenseChecker.licenseParse() ? 1 : 0;
        }
        if (value == 0) {
            throw new VoucherException(VoucherException.GOVACC_LICENSE_OVERDUE);
        }
    }

    private static boolean licenseParse() throws BOSException {
        block16: {
            boolean bl;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            BufferedReader reader = null;
            try {
                ILicenseSrv agent = LicenseSrvFactory.getInstance();
                LicenseBaseInfo baseInfo = agent.getLicenseBaseInfo();
                String licenseUser = baseInfo.getUser();
                String licenseID = baseInfo.getLicenseID();
                Date date = baseInfo.getServiceDate();
                String licenseDate = sdf.format(date);
                String path = System.getProperty("EAS_HOME");
                String licenseFilePath = path + "/server/profiles/server1/config/licenses/" + SYS_NAME + "_License";
                File licenseFile = new File(licenseFilePath);
                if (!licenseFile.exists()) {
                    boolean bl2 = false;
                    return bl2;
                }
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(licenseFile), "UTF-8"));
                String taxLicenseTxt = reader.readLine();
                String licenseTxt = RSAUtils.decryptByPrivateKey(taxLicenseTxt, RSAUtils.privateKey);
                String[] fields = licenseTxt.split("\\$");
                String mySystem = fields[0];
                String myUser = fields[1];
                String myUserNum = fields[2];
                String myDate = fields[3];
                if (!SYS_NAME.equals(mySystem) || !licenseUser.equals(myUser) || !licenseID.equals(myUserNum) || !licenseDate.equals(myDate)) break block16;
                bl = true;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }
        return false;
    }
}

