/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.QueryConnectionProvider;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.message.common.util.UuidException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermItem;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermItemCollection;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.CommRptRouteConfigFacadeFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupStandardFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.CompanyPeriodInfo;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GLPeriodEndException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.RptAsstactBalanceListFactory;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.AssistViewFilterInfo;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RptServerUtil {
    private static final Logger logger = Logger.getLogger(RptServerUtil.class);
    private static int seq = 0;
    public static final int CURRENCY_TYPE_ORIGINAL = 0;
    public static final int CURRENCY_TYPE_LOCAL = 1;
    public static final int CURRENCY_TYPE_REPORT = 2;

    private RptServerUtil() {
    }

    public static synchronized int seq() {
        if (seq == Short.MAX_VALUE) {
            seq = -1;
        }
        return ++seq;
    }

    public static int getMaxAccountLevel(Context ctx, String companyId) throws BOSException, EASBizException {
        ObjectUuidPK companyInfoPK = new ObjectUuidPK(companyId);
        if (AccountViewFactory.getLocalInstance((Context)ctx).getMaxLevel((IObjectPK)companyInfoPK) <= 0) {
            throw new ReportException(ReportException.GET_ACCOUNT_ERROR);
        }
        return AccountViewFactory.getLocalInstance((Context)ctx).getMaxLevel((IObjectPK)companyInfoPK);
    }

    public static PeriodInfo getMaxPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo maxPeriod = null;
        String sql = "select top 1 fid,fnumber,fbeginDate,fendDate  from t_bd_period where FTypeid = ? order by fnumber desc";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{company.getAccountPeriodType().getId().toString()});
        try {
            if (!rs.next()) {
                throw new GLPeriodEndException(GLPeriodEndException.NO_NEXT_PERIOD);
            }
            maxPeriod = new PeriodInfo();
            maxPeriod.setId(BOSUuid.read((String)rs.getString("fid")));
            maxPeriod.setNumber(rs.getInt("fnumber"));
            maxPeriod.setBeginDate((Date)rs.getDate("fbegindate"));
            maxPeriod.setEndDate(rs.getTimestamp("fenddate"));
        }
        catch (com.kingdee.util.UuidException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new SQLAccessException(e);
        }
        return maxPeriod;
    }

    public static CurrencyCollection getAllCurrency(String companyId, Context ctx) throws BOSException, ReportBizException {
        ICurrency currency = CurrencyFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("precision"));
        sic.add(new SelectorItemInfo("isoCode"));
        sic.add(new SelectorItemInfo("sign"));
        sic.add(new SelectorItemInfo("BaseUnit"));
        CurrencyCollection cc = currency.getCurrencyCollection(view);
        String baseCurrencyId = null;
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)"select FBaseCurrencyId from t_org_company where FID=?", (SqlParams)new SqlParams().addString(companyId), (Context)ctx);
            rs.next();
            baseCurrencyId = rs.getString("FBaseCurrencyId");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        CurrencyInfo commonBase = null;
        CurrencyInfo companyBase = null;
        CurrencyInfo rptBase = null;
        int n = cc.size();
        for (int i = 0; i < n; ++i) {
            String currencyId = cc.get(i).getId().toString();
            if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId)) {
                commonBase = cc.get(i);
                continue;
            }
            if (baseCurrencyId.equals(currencyId)) {
                companyBase = cc.get(i);
                continue;
            }
            if (!CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId)) continue;
            rptBase = cc.get(i);
        }
        if (commonBase != null) {
            String name = commonBase.getName();
            String number = commonBase.getNumber();
            commonBase.putAll(companyBase);
            commonBase.setId(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID);
            commonBase.setName(name);
            commonBase.setNumber(number);
        }
        if (rptBase != null) {
            String name = rptBase.getName();
            String number = rptBase.getNumber();
            rptBase.putAll(companyBase);
            rptBase.setId(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID);
            rptBase.setName(name);
            rptBase.setNumber(number);
        }
        return cc;
    }

    public static RptParams getAsstactItemInfo(String actItemId, String actTypeId, Context ctx) throws BOSException, EASBizException, SQLException {
        RptParams pp = new RptParams();
        String loc = RptServerUtil.getLoc(ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FNumber as FFNumber, FDefaultQueryname, FRealtionDataObject,").append("FAsstHGAttribute, FMappingFieldName, fname_").append(loc).append(" FName, FisForCompany, FGLAsstActTypeGrpID, FAsstHGAttribute, FIsMultiLevel, FGroupTableName, FGroupMappingFieldName, ").append(" 'true' FSelected, null FFrom, null FTo, 1 FMaxLevel, 1 FSelectedLevel,FUseLongNumber,").append(" FPermissionItem, 'true' as FEnablePermissionLimit ").append(" from T_BD_AsstActType where fid='" + actTypeId + "'");
        RptRowSet rs = DBUtilx.executeQuery((String)sql.toString(), null, (Context)ctx);
        rs.next();
        AsstactTypeEntity at = new AsstactTypeEntity();
        at.setId(rs.getString("FID"));
        at.setNumber(rs.getString("FFNumber"));
        at.setQueryName(rs.getString("FDefaultQueryname"));
        at.setTableName(rs.getString("FRealtionDataObject"));
        at.setName(rs.getString("FName"));
        at.setForCompany("1".equals(String.valueOf(rs.getObject("FisForCompany"))));
        at.setGeneralAsstactGroupId(rs.getString("FGLAsstActTypeGrpID"));
        at.setHgField(rs.getString("FMappingFieldName"));
        at.setHgAttribute(rs.getString("FAsstHGAttribute"));
        at.setGroupTable(rs.getString("FGroupTableName"));
        at.setGroupField(rs.getString("FGroupMappingFieldName"));
        at.setMaxLevel(rs.getInt("FMaxLevel"));
        at.setSelected(Boolean.valueOf(rs.getString("FSelected")));
        at.setMultilevel("1".equals(String.valueOf(rs.getObject("FIsMultiLevel"))));
        at.setFrom(rs.getObject("FFrom"));
        at.setTo(rs.getObject("FTo"));
        at.setSelectedLevel(rs.getInt("FSelectedLevel"));
        at.setEnabledPermissionLimit(rs.getBoolean("FEnablePermissionLimit", false));
        at.setPermissionItem(rs.getString("FPermissionItem"));
        at.setUseLongNumber("1".equals(String.valueOf(rs.getObject("FUseLongNumber"))));
        sql.setLength(0);
        if (at.isUseGroup()) {
            sql.append("select A.fname_").append(loc).append(" fname, A.fnumber, (case when B.FLongNumber is null then A.FNumber else B.FLongNumber||'!'||A.FNumber end) flongnumber, 1+IsNull(B.FLevel,0) FLevel from ").append(at.getTableName()).append(" A left join ").append(at.getGroupTable()).append(" B on B.FID=A.").append(at.getGroupField()).append(" where A.fid='").append(actItemId).append('\'');
        } else if (at.isUseLevel()) {
            sql.append("select fname_").append(loc).append(" fname, fnumber, flongnumber, flevel from ").append(at.getTableName()).append(" where fid='").append(actItemId).append('\'');
        } else {
            sql.append("select fname_").append(loc).append(" fname, fnumber, fnumber flongnumber, 1 flevel from ").append(at.getTableName()).append(" where fid='").append(actItemId).append('\'');
        }
        rs = DBUtilx.executeQuery((String)sql.toString(), null, (Context)ctx);
        rs.next();
        pp.setString("FID", actItemId);
        pp.setString("FName", rs.getString("FName"));
        pp.setString("FNumber", rs.getString("FNumber"));
        String longNumber = rs.getString("FLongNumber");
        if (at.isUseLongNumber() && longNumber != null) {
            pp.setString("FNumber", rs.getString("FLongNumber").replace('!', '.'));
        }
        pp.setString("FLongNumber", longNumber);
        pp.setInt("FLevel", rs.getInt("FLevel"));
        return pp;
    }

    public static RptRowSet queryAsstActOfRS(RptParams params, Context ctx) throws BOSException, EASBizException {
        return RptAsstactBalanceListFactory.getLocalInstance(ctx).queryAsstAct(params);
    }

    public static List queryAsstAct(String asstAccountId, String cuId, Context ctx) throws BOSException, EASBizException {
        String loc = RptServerUtil.getLoc(ctx);
        SqlParams pp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        sql.append("select distinct A.FID, A.FNumber as FFNumber, A.FDefaultQueryname, A.FRealtionDataObject,").append("A.FAsstHGAttribute, A.FMappingFieldName, A.fname_").append(loc).append(" FName, A.FisForCompany, A.FGLAsstActTypeGrpID, A.FAsstHGAttribute,  A.FMeasureUnitGroupID FMeasureUnitGroupID,A.FMeasureUnitGroupID as FAsstMeasureUnitGroupId, FIsMultiLevel, FGroupTableName, FGroupMappingFieldName, ").append(" 'true' FSelected, null FFrom, null FTo, 1 FMaxLevel, 1 FSelectedLevel,A.FUseLongNumber, ").append(" A.FPermissionItem, 'true' as FEnablePermissionLimit ,A.fisqty as FQtyAsst, mg.Fdefaultunitid ");
        if (asstAccountId != null) {
            sql.append(" ,C.fseq ");
        }
        sql.append(" from T_BD_AsstAccount B ").append(" inner join T_BD_AsstActGroupDetail C on B.fid = C.fasstaccountid").append(" inner join T_BD_AsstActType A on A.fid = C.fasstacttypeid");
        if (asstAccountId == null) {
            sql.append(" left outer join t_bd_measureunitgroup mg on A.FMeasureUnitGroupID = mg.fid ");
            sql.append(" inner join T_ORG_BaseUnit D on D.fid=?");
            sql.append(" inner join T_ORG_BaseUnit E on E.FID=A.fcompanyid and CHARINDEX(E.FLongNumber,D.FLongNumber)=1");
            pp.setString(1, companyID);
            sql.append("\n union \n select distinct A.FID, A.FNumber as FFNumber, A.FDefaultQueryname, A.FRealtionDataObject,").append("A.FAsstHGAttribute, A.FMappingFieldName, A.fname_").append(loc).append(" FName, A.FisForCompany, A.FGLAsstActTypeGrpID, A.FAsstHGAttribute,A.FMeasureUnitGroupID FMeasureUnitGroupID,A.FMeasureUnitGroupID as FAsstMeasureUnitGroupId, FIsMultiLevel, FGroupTableName, FGroupMappingFieldName, ").append(" 'true' FSelected, null FFrom, null FTo, 1 FMaxLevel, 1 FSelectedLevel,A.FUseLongNumber, ").append(" A.FPermissionItem, 'true' as FEnablePermissionLimit ,A.fisqty as FQtyAsst, mg.Fdefaultunitid ").append("from T_BD_AsstAccount Aa  inner join T_BD_AsstActGroupDetail GP on Aa.fid = GP.fasstaccountid inner join T_BD_AsstActType A on A.fid = GP.fasstacttypeid ").append("\n inner join t_bd_asstacttypeReference B on B.FAsstActTypeID=A.FID").append("\n left outer join t_bd_measureunitgroup mg on A.FMeasureUnitGroupID = mg.fid ").append("\n inner join t_org_baseunit C on  C.fid=?").append("inner join T_ORG_BaseUnit E on  e.FID=B.FAssignCompanyID and  CHARINDEX(E.FLongNumber,c.FLongNumber)=1");
            pp.setString(2, companyID);
            sql.append("\n union \n select distinct A.FID, A.FNumber as FFNumber, A.FDefaultQueryname, A.FRealtionDataObject,").append("A.FAsstHGAttribute, A.FMappingFieldName, A.fname_").append(loc).append(" FName, A.FisForCompany, A.FGLAsstActTypeGrpID, A.FAsstHGAttribute,A.FMeasureUnitGroupID FMeasureUnitGroupID, A.FMeasureUnitGroupID as FAsstMeasureUnitGroupId, FIsMultiLevel, FGroupTableName, FGroupMappingFieldName, ").append(" 'true' FSelected, null FFrom, null FTo, 1 FMaxLevel, 1 FSelectedLevel, A.FUseLongNumber,").append(" A.FPermissionItem, 'true' as FEnablePermissionLimit ,A.fisqty as FQtyAsst, mg.Fdefaultunitid ").append("from T_BD_AsstAccount Aa  inner join T_BD_AsstActGroupDetail GP on Aa.fid = GP.fasstaccountid inner join T_BD_AsstActType A on A.fid = GP.fasstacttypeid ").append("inner join T_BD_GeneralAsstActTypeGroup g on a.FGlAsstActTypeGrpID = g.fid").append(" left outer join t_bd_measureunitgroup mg on A.FMeasureUnitGroupID = mg.fid ").append("  where a.fcontrolunitid = ? and g.FShareTactic <> ").append(3);
            pp.setString(3, "00000000-0000-0000-0000-000000000000CCE7AED4");
            sql.append("\n order by FFNumber ");
        } else {
            sql.append(" and B.fid=? ");
            sql.append(" left outer join t_bd_measureunitgroup mg on A.FMeasureUnitGroupID = mg.fid ");
            pp.setString(1, asstAccountId);
            sql.append("\n order by C.fseq, FFNumber ");
        }
        return RptServerUtil.innerQueryAsstAct(cuId, ctx, pp, sql, true);
    }

    public static List queryCussentAsstAct(String comId, String cuId, Context ctx) throws BOSException, EASBizException {
        String loc = RptServerUtil.getLoc(ctx);
        SqlParams pp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct A.FID, A.FNumber as FFNumber, A.FDefaultQueryname, A.FRealtionDataObject,").append("A.FAsstHGAttribute, A.FMappingFieldName, A.fname_").append(loc).append(" FName, A.FisForCompany, A.FGLAsstActTypeGrpID, A.FAsstHGAttribute,A.FMeasureUnitGroupID, FIsMultiLevel, FGroupTableName, FGroupMappingFieldName, ").append(" 'true' FSelected, null FFrom, null FTo, 1 FMaxLevel, 1 FSelectedLevel,A.FUseLongNumber, ").append(" A.FPermissionItem, 'true' as FEnablePermissionLimit ,A.fisqty as FQtyAsst, '' as fdefaultunitid ").append(" from T_BD_AsstAccount B ").append(" inner join T_BD_AsstActGroupDetail C on B.fid = C.fasstaccountid").append(" inner join T_BD_AsstActType A on A.fid = C.fasstacttypeid");
        sql.append(" inner join t_bd_accountview D on B.fid = D.FCAA ");
        sql.append(" where D.FAC = 1 and D.fcompanyid = ? ");
        pp.setString(1, comId);
        sql.append("\n order by FFNumber ");
        return RptServerUtil.innerQueryAsstAct(cuId, ctx, pp, sql, false);
    }

    private static List innerQueryAsstAct(String cuId, Context ctx, SqlParams pp, StringBuffer sql, boolean includeLevel) throws SQLDataException, SQLAccessException {
        ArrayList<AsstactTypeEntity> arrayList;
        ArrayList<AsstactTypeEntity> list;
        Connection con;
        block9: {
            AsstactTypeEntity at;
            con = null;
            list = new ArrayList<AsstactTypeEntity>();
            con = RptServerUtil.getConnection(ctx);
            RptRowSet rs = DBUtil.executeQuery((String)sql.toString(), (SqlParams)pp, (Connection)con);
            HashMap<String, String> has = new HashMap<String, String>();
            while (rs.next()) {
                at = new AsstactTypeEntity();
                String id = rs.getString("FID");
                if (has.containsKey(id)) continue;
                at.setId(id);
                has.put(id, id);
                at.setNumber(rs.getString("FFNumber"));
                at.setQueryName(rs.getString("FDefaultQueryname"));
                at.setTableName(rs.getString("FRealtionDataObject"));
                at.setName(rs.getString("FName"));
                at.setForCompany("1".equals(String.valueOf(rs.getObject("FisForCompany"))));
                at.setGeneralAsstactGroupId(rs.getString("FGLAsstActTypeGrpID"));
                at.setHgField(rs.getString("FMappingFieldName"));
                at.setHgAttribute(rs.getString("FAsstHGAttribute"));
                at.setGroupTable(rs.getString("FGroupTableName"));
                at.setGroupField(rs.getString("FGroupMappingFieldName"));
                at.setMaxLevel(rs.getInt("FMaxLevel"));
                at.setSelected(Boolean.valueOf(rs.getString("FSelected")));
                at.setCollect(CollectEnum.LEAF);
                at.setMultilevel("1".equals(String.valueOf(rs.getObject("FIsMultiLevel"))));
                at.setFrom(rs.getObject("FFrom"));
                at.setTo(rs.getObject("FTo"));
                at.setSelectedLevel(rs.getInt("FSelectedLevel"));
                at.setEnabledPermissionLimit(rs.getBoolean("FEnablePermissionLimit", false));
                at.setPermissionItem(rs.getString("FPermissionItem"));
                at.setAsstMeasureUnitGroupId(rs.getString("FMeasureUnitGroupID"));
                at.setAsstMeasureUnitId(rs.getString("Fdefaultunitid"));
                at.setUseLongNumber("1".equals(String.valueOf(rs.getObject("FUseLongNumber"))));
                at.setQtyAsst("1".equals(String.valueOf(rs.getObject("FQtyAsst"))));
                list.add(at);
            }
            StringBuffer ids = new StringBuffer();
            ids.append("select fasstacttypeid,fasstaccountid from T_BD_AsstActGroupDetail where fasstacttypeid in(''");
            rs.reset();
            while (rs.next()) {
                ids.append(",'").append(rs.getString("FID")).append("'");
            }
            ids.append(')');
            RptRowSet idsRst = DBUtil.executeQuery((String)ids.toString(), null, (Connection)con);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                at = (AsstactTypeEntity)list.get(i);
                idsRst.reset();
                while (idsRst.next()) {
                    if (!at.getId().equals(idsRst.getString("fasstacttypeid"))) continue;
                    at.addAsstAccount(idsRst.getString("fasstaccountid"));
                }
            }
            if (includeLevel) break block9;
            ArrayList<AsstactTypeEntity> arrayList2 = list;
            RptServerUtil.close(con, null, null);
            return arrayList2;
        }
        try {
            RptServerUtil.queryMaxLevel(cuId, list, ctx);
            arrayList = list;
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                RptServerUtil.close(con, null, null);
                throw throwable;
            }
        }
        RptServerUtil.close(con, null, null);
        return arrayList;
    }

    private static List queryMaxLevel(String cuId, List list, Context ctx) throws SQLException {
        String s = null;
        try {
            String selectSingle;
            AsstactTypeEntity at;
            int i;
            AsstactTypeEntity at2;
            int i2;
            ArrayList listGroup = new ArrayList();
            ArrayList listMulLevelGeneralActType = new ArrayList();
            ArrayList listOther = new ArrayList();
            int n = list.size();
            for (i2 = 0; i2 < n; ++i2) {
                s = null;
                at2 = (AsstactTypeEntity)list.get(i2);
                if (at2.isUseGroup()) {
                    listGroup.add(list.get(i2));
                    continue;
                }
                if (!at2.isUseLevel()) continue;
                if (at2.isGeneralActType()) {
                    listMulLevelGeneralActType.add(list.get(i2));
                    continue;
                }
                listOther.add(list.get(i2));
            }
            n = listGroup.size();
            for (i2 = 0; i2 < n; ++i2) {
                at2 = (AsstactTypeEntity)listGroup.get(i2);
                String selectSingle2 = " select max(B.FLevel)+1 FLevel,'" + at2.getTableName() + at2.getHgField() + "' FassistTypeKey from ";
                selectSingle2 = !at2.getHgAttribute().equals("customer") && !at2.getHgAttribute().equals("provider") && !at2.getHgAttribute().equals("material") ? selectSingle2 + at2.getTableName() + "  A inner join " + at2.getGroupTable() + " B on B.FID=A." + at2.getGroupField() : selectSingle2 + " " + at2.getGroupTable() + " B ";
                s = s == null ? selectSingle2 : s + "\r\n union " + selectSingle2;
            }
            String ss = "select fid from t_bd_generalasstacttypegroup where fsharetactic = 3 ";
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)ss);
            HashMap<Object, Boolean> ids = new HashMap<Object, Boolean>();
            while (rst.next()) {
                ids.put(rst.getObject("fid"), Boolean.TRUE);
            }
            int n2 = listMulLevelGeneralActType.size();
            for (i = 0; i < n2; ++i) {
                at = (AsstactTypeEntity)listMulLevelGeneralActType.get(i);
                selectSingle = ids.get(at.getGeneralAsstactGroupId()) != null && (Boolean)ids.get(at.getGeneralAsstactGroupId()) != false ? "select max(FLevel) FLevel ,'" + at.getTableName() + at.getHgField() + "' FassistTypeKey from " + at.getTableName() + " where FGroupId='" + at.getGeneralAsstactGroupId() + "' and fcontrolunitid='" + cuId + '\'' : "select max(FLevel) FLevel ,'" + at.getTableName() + at.getHgField() + "' FassistTypeKey from " + at.getTableName() + " where FGroupId='" + at.getGeneralAsstactGroupId() + "'";
                s = s == null ? selectSingle : s + "\r\n union " + selectSingle;
            }
            n2 = listOther.size();
            for (i = 0; i < n2; ++i) {
                at = (AsstactTypeEntity)listOther.get(i);
                selectSingle = " select max(FLevel) FLevel ,'" + at.getTableName() + at.getHgField() + "' FassistTypeKey from " + at.getTableName();
                s = s == null ? selectSingle : s + "\r\n union " + selectSingle;
            }
            if (s != null) {
                HashMap<Object, Integer> maxLevel = new HashMap<Object, Integer>();
                IRowSet srs = DbUtil.executeQuery((Context)ctx, s);
                while (srs.next()) {
                    maxLevel.put(srs.getObject("FassistTypeKey"), srs.getObject("FLevel") == null ? null : new Integer(srs.getInt("FLevel")));
                }
                int n3 = list.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    AsstactTypeEntity at3;
                    String atKey = (at3 = (AsstactTypeEntity)list.get(i3)).getTableName() + at3.getHgField();
                    at3.setMaxLevel(maxLevel.get(atKey) == null ? 1 : (Integer)maxLevel.get(atKey));
                    at3.setSelectedLevel(1);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return list;
    }

    public static List queryCussentAsstAct(String[] comId, String[] cuId, Context ctx) throws BOSException, EASBizException {
        String loc = RptServerUtil.getLoc(ctx);
        SqlParams pp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct A.FID, A.FNumber as FFNumber, A.FDefaultQueryname, A.FRealtionDataObject,").append("A.FAsstHGAttribute, A.FMappingFieldName, A.fname_").append(loc).append(" FName, A.FisForCompany, A.FGLAsstActTypeGrpID, A.FAsstHGAttribute,A.FMeasureUnitGroupID, FIsMultiLevel, FGroupTableName, FGroupMappingFieldName, ").append(" 'true' FSelected, null FFrom, null FTo, 1 FMaxLevel, 1 FSelectedLevel,A.FUseLongNumber, ").append(" A.FPermissionItem, 'true' as FEnablePermissionLimit ,A.fisqty as FQtyAsst, '' as fdefaultunitid ").append(" from T_BD_AsstAccount B ").append(" inner join T_BD_AsstActGroupDetail C on B.fid = C.fasstaccountid").append(" inner join T_BD_AsstActType A on A.fid = C.fasstacttypeid").append(" inner join  T_BD_AsstActTypeDefault de on a.fid=de.fasstacttypeid and de.fisaccountcussent=1 and de.fcompanyid in (");
        for (int i = 0; i < comId.length; ++i) {
            if (i == 0) {
                sql.append("'");
            } else {
                sql.append(",'");
            }
            sql.append(comId[i]);
            sql.append("'");
        }
        sql.append(" )");
        sql.append("\n order by FFNumber ");
        return RptServerUtil.innerQueryAsstAct(cuId, ctx, pp, sql, false);
    }

    private static List innerQueryAsstAct(String[] cuId, Context ctx, SqlParams pp, StringBuffer sql, boolean includeLevel) throws SQLDataException, SQLAccessException {
        ArrayList<AsstactTypeEntity> arrayList;
        ArrayList<AsstactTypeEntity> list;
        Connection con;
        block9: {
            AsstactTypeEntity at;
            con = null;
            list = new ArrayList<AsstactTypeEntity>();
            con = RptServerUtil.getConnection(ctx);
            RptRowSet rs = DBUtil.executeQuery((String)sql.toString(), (SqlParams)pp, (Connection)con);
            HashMap<String, String> has = new HashMap<String, String>();
            while (rs.next()) {
                at = new AsstactTypeEntity();
                String id = rs.getString("FID");
                if (has.containsKey(id)) continue;
                at.setId(id);
                has.put(id, id);
                at.setNumber(rs.getString("FFNumber"));
                at.setQueryName(rs.getString("FDefaultQueryname"));
                at.setTableName(rs.getString("FRealtionDataObject"));
                at.setName(rs.getString("FName"));
                at.setForCompany("1".equals(String.valueOf(rs.getObject("FisForCompany"))));
                at.setGeneralAsstactGroupId(rs.getString("FGLAsstActTypeGrpID"));
                at.setHgField(rs.getString("FMappingFieldName"));
                at.setHgAttribute(rs.getString("FAsstHGAttribute"));
                at.setGroupTable(rs.getString("FGroupTableName"));
                at.setGroupField(rs.getString("FGroupMappingFieldName"));
                at.setMaxLevel(rs.getInt("FMaxLevel"));
                at.setSelected(Boolean.valueOf(rs.getString("FSelected")));
                at.setCollect(CollectEnum.LEAF);
                at.setMultilevel("1".equals(String.valueOf(rs.getObject("FIsMultiLevel"))));
                at.setFrom(rs.getObject("FFrom"));
                at.setTo(rs.getObject("FTo"));
                at.setSelectedLevel(rs.getInt("FSelectedLevel"));
                at.setEnabledPermissionLimit(rs.getBoolean("FEnablePermissionLimit", false));
                at.setPermissionItem(rs.getString("FPermissionItem"));
                at.setAsstMeasureUnitGroupId(rs.getString("FMeasureUnitGroupID"));
                at.setAsstMeasureUnitId(rs.getString("Fdefaultunitid"));
                at.setUseLongNumber("1".equals(String.valueOf(rs.getObject("FUseLongNumber"))));
                at.setQtyAsst("1".equals(String.valueOf(rs.getObject("FQtyAsst"))));
                list.add(at);
            }
            StringBuffer ids = new StringBuffer();
            ids.append("select fasstacttypeid,fasstaccountid from T_BD_AsstActGroupDetail where fasstacttypeid in(''");
            rs.reset();
            while (rs.next()) {
                ids.append(",'").append(rs.getString("FID")).append("'");
            }
            ids.append(')');
            RptRowSet idsRst = DBUtil.executeQuery((String)ids.toString(), null, (Connection)con);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                at = (AsstactTypeEntity)list.get(i);
                idsRst.reset();
                while (idsRst.next()) {
                    if (!at.getId().equals(idsRst.getString("fasstacttypeid"))) continue;
                    at.addAsstAccount(idsRst.getString("fasstaccountid"));
                }
            }
            if (includeLevel) break block9;
            ArrayList<AsstactTypeEntity> arrayList2 = list;
            RptServerUtil.close(con, null, null);
            return arrayList2;
        }
        try {
            RptServerUtil.queryMaxLevel(cuId, list, ctx);
            arrayList = list;
        }
        catch (SQLException sqle) {
            try {
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                RptServerUtil.close(con, null, null);
                throw throwable;
            }
        }
        RptServerUtil.close(con, null, null);
        return arrayList;
    }

    private static List queryMaxLevel(String[] cuId, List list, Context ctx) throws SQLException {
        String s = null;
        try {
            String selectSingle;
            AsstactTypeEntity at;
            int i;
            AsstactTypeEntity at2;
            int i2;
            ArrayList listGroup = new ArrayList();
            ArrayList listMulLevelGeneralActType = new ArrayList();
            ArrayList listOther = new ArrayList();
            int n = list.size();
            for (i2 = 0; i2 < n; ++i2) {
                s = null;
                at2 = (AsstactTypeEntity)list.get(i2);
                if (at2.isUseGroup()) {
                    listGroup.add(list.get(i2));
                    continue;
                }
                if (!at2.isUseLevel()) continue;
                if (at2.isGeneralActType()) {
                    listMulLevelGeneralActType.add(list.get(i2));
                    continue;
                }
                listOther.add(list.get(i2));
            }
            n = listGroup.size();
            for (i2 = 0; i2 < n; ++i2) {
                at2 = (AsstactTypeEntity)listGroup.get(i2);
                String selectSingle2 = " select max(B.FLevel)+1 FLevel,'" + at2.getTableName() + at2.getHgField() + "' FassistTypeKey from ";
                selectSingle2 = !at2.getHgAttribute().equals("customer") && !at2.getHgAttribute().equals("provider") && !at2.getHgAttribute().equals("material") ? selectSingle2 + at2.getTableName() + "  A inner join " + at2.getGroupTable() + " B on B.FID=A." + at2.getGroupField() : selectSingle2 + " " + at2.getGroupTable() + " B ";
                s = s == null ? selectSingle2 : s + "\r\n union " + selectSingle2;
            }
            String ss = "select fid from t_bd_generalasstacttypegroup where fsharetactic = 3 ";
            IRowSet rst = DbUtil.executeQuery((Context)ctx, (String)ss);
            HashMap<Object, Boolean> ids = new HashMap<Object, Boolean>();
            while (rst.next()) {
                ids.put(rst.getObject("fid"), Boolean.TRUE);
            }
            int n2 = listMulLevelGeneralActType.size();
            for (i = 0; i < n2; ++i) {
                at = (AsstactTypeEntity)listMulLevelGeneralActType.get(i);
                if (ids.get(at.getGeneralAsstactGroupId()) != null && ((Boolean)ids.get(at.getGeneralAsstactGroupId())).booleanValue()) {
                    StringBuffer cuidsb = new StringBuffer();
                    for (int j = 0; j < cuId.length; ++j) {
                        if (j == 0) {
                            cuidsb.append("'");
                        } else {
                            cuidsb.append(",'");
                        }
                        cuidsb.append(cuId[j]);
                        cuidsb.append("'");
                    }
                    selectSingle = "select max(FLevel) FLevel ,'" + at.getTableName() + at.getHgField() + "' FassistTypeKey from " + at.getTableName() + " where FGroupId='" + at.getGeneralAsstactGroupId() + "' and fcontrolunitid in (" + cuidsb.toString() + ") ";
                } else {
                    selectSingle = "select max(FLevel) FLevel ,'" + at.getTableName() + at.getHgField() + "' FassistTypeKey from " + at.getTableName() + " where FGroupId='" + at.getGeneralAsstactGroupId() + "'";
                }
                s = s == null ? selectSingle : s + "\r\n union " + selectSingle;
            }
            n2 = listOther.size();
            for (i = 0; i < n2; ++i) {
                at = (AsstactTypeEntity)listOther.get(i);
                selectSingle = " select max(FLevel) FLevel ,'" + at.getTableName() + at.getHgField() + "' FassistTypeKey from " + at.getTableName();
                s = s == null ? selectSingle : s + "\r\n union " + selectSingle;
            }
            if (s != null) {
                HashMap<Object, Integer> maxLevel = new HashMap<Object, Integer>();
                IRowSet srs = DbUtil.executeQuery((Context)ctx, s);
                while (srs.next()) {
                    maxLevel.put(srs.getObject("FassistTypeKey"), srs.getObject("FLevel") == null ? null : new Integer(srs.getInt("FLevel")));
                }
                int n3 = list.size();
                for (int i3 = 0; i3 < n3; ++i3) {
                    AsstactTypeEntity at3;
                    String atKey = (at3 = (AsstactTypeEntity)list.get(i3)).getTableName() + at3.getHgField();
                    at3.setMaxLevel(maxLevel.get(atKey) == null ? 1 : (Integer)maxLevel.get(atKey));
                    at3.setSelectedLevel(1);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return list;
    }

    public static List getAsstactByAccount(RptParams params, Context ctx) throws BOSException, EASBizException {
        ArrayList<AsstactTypeEntity> returnlist = new ArrayList<AsstactTypeEntity>();
        SqlParams sp = new SqlParams();
        sp.setString(1, params.getString("fid"));
        String cuId = params.getString("cuId");
        try {
            String ss = "select B.FID from t_bd_accountview A\n inner join t_bd_accountview B on A.faccounttableid=B.faccounttableid and A.fcompanyid=B.fcompanyid\n and charIndex(A.fnumber,  B.fnumber)=1\n where A.fid=? and B.Fisleaf=1";
            Connection con = null;
            con = RptServerUtil.getConnection(ctx);
            RptRowSet allIds = DBUtil.executeQuery((String)ss, (SqlParams)sp, (Connection)con);
            StringBuffer sql = new StringBuffer();
            sql.append("select B.FID as AccountID, B.FNumber as AllAccountNumber, C.FID, C.Fname_").append(RptServerUtil.getLoc(ctx)).append(" FName, C.FNumber, FDefaultQueryName, FIsMultiLevel, FGLAsstActTypeGrpID, FAsstHGAttribute, ").append(" FisForCompany, FRealtionDataObject, FMappingFieldName, FGroupTableName, FGroupMappingFieldName, ").append(" 'true' as fselected, null as ffrom, null as fto, ").append(" C.FPermissionItem, 'true' as FEnablePermissionLimit,C.FUseLongNumber").append("\n from t_bd_asstactgroupdetail A ").append("\n inner join t_bd_accountview B on B.FCAA=A.Fasstaccountid").append("\n inner join t_bd_asstacttype C on C.Fid=A.Fasstacttypeid").append("\n where B.FID in(\n").append(ss).append("\n )order by B.FNumber,C.FNumber");
            RptRowSet rs = DBUtil.executeQuery((String)sql.toString(), (SqlParams)sp, (Connection)con);
            while (rs.next()) {
                String id = rs.getString("AccountID");
                allIds.reset();
                while (allIds.next()) {
                    if (!id.equals(allIds.getString("FID"))) continue;
                    allIds.remove();
                }
            }
            if (allIds.getRowCount() != 0) {
                rs.removeAllRow();
            } else {
                ArrayList list = new ArrayList();
                ArrayList<String> buf = new ArrayList<String>();
                String accountNumber = null;
                String oldAccountNumber = null;
                rs.reset();
                while (rs.next()) {
                    accountNumber = rs.getString("AllAccountNumber");
                    if (oldAccountNumber == null) {
                        oldAccountNumber = accountNumber;
                    } else if (!accountNumber.equals(oldAccountNumber)) {
                        list.add(buf);
                        buf = new ArrayList();
                        oldAccountNumber = accountNumber;
                    }
                    buf.add(rs.getString("FNumber"));
                }
                list.add(buf);
                ArrayList actNumberList = (ArrayList)list.get(0);
                int n = list.size();
                for (int i = 1; i < n; ++i) {
                    actNumberList.retainAll((List)list.get(i));
                }
                rs.reset();
                while (rs.next()) {
                    int n2 = actNumberList.indexOf(rs.getString("FNumber"));
                    if (n2 != -1) {
                        actNumberList.remove(n2);
                        continue;
                    }
                    rs.remove();
                }
            }
            rs.reset();
            while (rs.next()) {
                AsstactTypeEntity at = new AsstactTypeEntity();
                at.setId(rs.getString("FID"));
                at.setNumber(rs.getString("FNumber"));
                at.setQueryName(rs.getString("FDefaultQueryname"));
                at.setTableName(rs.getString("FRealtionDataObject"));
                at.setName(rs.getString("FName"));
                at.setForCompany("1".equals(String.valueOf(rs.getObject("FisForCompany"))));
                at.setGeneralAsstactGroupId(rs.getString("FGLAsstActTypeGrpID"));
                at.setHgField(rs.getString("FMappingFieldName"));
                at.setHgAttribute(rs.getString("FAsstHGAttribute"));
                at.setGroupTable(rs.getString("FGroupTableName"));
                at.setGroupField(rs.getString("FGroupMappingFieldName"));
                at.setMaxLevel(10);
                at.setSelected(true);
                at.setMultilevel("1".equals(String.valueOf(rs.getObject("FIsMultiLevel"))));
                at.setFrom(rs.getObject("FFrom"));
                at.setTo(rs.getObject("FTo"));
                at.setUseLongNumber("1".equals(String.valueOf(rs.getObject("FUseLongNumber"))));
                returnlist.add(at);
            }
            RptServerUtil.queryMaxLevel(cuId, returnlist, ctx);
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        return returnlist;
    }

    public static Map getPeriodRange(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return CommRptBaseFactory.getLocalInstance((Context)ctx).getPeriodRange(company);
    }

    private static void close(Connection con, Statement statement, ResultSet rs) {
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private static String getLoc(Context ctx) throws BOSException {
        return LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }

    public static int getCurrencyType(String currencyId) {
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyId)) {
            return 1;
        }
        if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyId)) {
            return 2;
        }
        return 0;
    }

    public static String getCurrencyFieldSuffix(String currencyId) {
        String suffix = null;
        switch (RptServerUtil.getCurrencyType(currencyId)) {
            case 0: {
                suffix = "For";
                break;
            }
            case 1: {
                suffix = "Local";
                break;
            }
            case 2: {
                suffix = "Rpt";
            }
        }
        return suffix;
    }

    public static boolean checkIfPermissionByCU(Context ctx, String strPermItem) throws BOSException {
        boolean isPermissionByCU = false;
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgRelation"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)strPermItem));
        evi.setFilter(filter);
        evi.setSelector(sic);
        IPermItem iPermItem = PermItemFactory.getLocalInstance((Context)ctx);
        PermItemCollection permItemCollection = iPermItem.getPermItemCollection(evi);
        PermItemInfo permItemInfo = permItemCollection.get(0);
        if (permItemInfo.getOrgRelation() == OrgType.ControlUnit) {
            isPermissionByCU = true;
        }
        return isPermissionByCU;
    }

    public static String innerJoinAsstactPermissionSql(String HGField, String permissionItem, String userId, String orgId, Context ctx) throws BOSException, EASBizException {
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), permissionItem);
        if (StringUtils.isEmpty((String)rule)) {
            return "";
        }
        String sql = "";
        HashMap param = GlUtils.getDefaultGLParam(ctx, orgId);
        boolean isTrue = Boolean.parseBoolean(param.get("GL_061").toString());
        if (isTrue) {
            String p = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), permissionItem);
            String pt = "PT" + RptServerUtil.seq();
            sql = " inner join \n(" + p + ")\n " + pt + " on " + pt + ".ID=" + HGField;
        }
        return sql;
    }

    public static String innerJoinAccountPermissionSql(String joinTable, String userId, String orgId, Context ctx) throws EASBizException, BOSException {
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)ctx);
        String rule = provider.getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), "bd_account_accountView_view");
        if (StringUtils.isEmpty((String)rule)) {
            return "";
        }
        String sql = "";
        HashMap param = GlUtils.getDefaultGLParam(ctx, orgId);
        boolean isTrue = Boolean.valueOf(param.get("GL_061").toString());
        if (isTrue) {
            String p = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgId), "bd_account_accountView_view");
            String pt = "PT" + RptServerUtil.seq();
            sql = " inner join \n(" + p + ")\n " + pt + " on " + pt + ".ID=" + joinTable + ".FID";
        }
        return sql;
    }

    public static HashMap getRptSelfCongdition(Context ctx, EntityViewInfo condition, HashMap table) throws BOSException {
        return RptServerUtil.getRptSelfCongdition(ctx, condition, table, false, false);
    }

    public static HashMap getRptSelfCongdition(Context ctx, EntityViewInfo condition, HashMap table, boolean isIncludeAssist, boolean isShowAccountCusAttribute) throws BOSException {
        HashMap<String, String> value = new HashMap<String, String>();
        if (condition == null) {
            return null;
        }
        EntityViewInfo conditionClone = (EntityViewInfo)condition.clone();
        IMetaDataPK iMetaDataPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.gl.app.VoucherReportQuery");
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)iMetaDataPK);
        queryExecutor.setObjectView(conditionClone);
        if (!isIncludeAssist && conditionClone.getFilter() != null) {
            int size = conditionClone.getFilter().getFilterItems().size();
            for (int i = 0; i < size; ++i) {
                FilterItemInfo item = conditionClone.getFilter().getFilterItems().get(i);
                if (!item.getPropertyName().startsWith("assistRecords.") && !item.getPropertyName().startsWith("settlementType.")) continue;
                item.setPropertyName("bookedDate");
                item.setCompareType(CompareType.NOTEQUALS);
                item.setCompareValue(null);
            }
        }
        String selfCondition = queryExecutor.getSQL();
        int wherePoint = selfCondition.lastIndexOf("WHERE");
        int orderPoint = selfCondition.lastIndexOf("ORDER");
        String orderCondition = selfCondition.substring(orderPoint + 8);
        if (wherePoint == -1 && orderPoint == -1) {
            return null;
        }
        if (wherePoint != -1) {
            StringBuffer jointable = new StringBuffer();
            selfCondition = orderPoint == -1 ? selfCondition.substring(wherePoint + 5) : selfCondition.substring(wherePoint + 5, orderPoint);
            if (selfCondition.indexOf("\"VOUCHER\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"VOUCHER\"", RptServerUtil.getAndStructJoinTable(table, "VOUCHER", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"ENTRIES\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"ENTRIES\"", RptServerUtil.getAndStructJoinTable(table, "ENTRIES", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"ASSISTRECORDS\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"ASSISTRECORDS\"", RptServerUtil.getAndStructJoinTable(table, "ASSISTRECORDS", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"SETTLEMENTTYPE\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"SETTLEMENTTYPE\"", RptServerUtil.getAndStructJoinTable(table, "SETTLEMENTTYPE", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"CASHIER\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"CASHIER\"", RptServerUtil.getAndStructJoinTable(table, "CASHIER", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"AUDITOR\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"AUDITOR\"", RptServerUtil.getAndStructJoinTable(table, "AUDITOR", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"CREATOR\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"CREATOR\"", RptServerUtil.getAndStructJoinTable(table, "CREATOR", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"HANDLER\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"HANDLER\"", RptServerUtil.getAndStructJoinTable(table, "HANDLER", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"ASSHANDLER\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"ASSHANDLER\"", RptServerUtil.getAndStructJoinTable(table, "ASSHANDLER", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"POSTER\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"POSTER\"", RptServerUtil.getAndStructJoinTable(table, "POSTER", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"CANCELLER\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"CANCELLER\"", RptServerUtil.getAndStructJoinTable(table, "CANCELLER", jointable, isShowAccountCusAttribute));
            }
            if (selfCondition.indexOf("\"VOUCHERTYPE\"") != -1) {
                selfCondition = selfCondition.replaceAll("\"VOUCHERTYPE\"", RptServerUtil.getAndStructJoinTable(table, "VOUCHERTYPE", jointable, isShowAccountCusAttribute));
            }
            value.put("cond", selfCondition);
            value.put("join", jointable.toString());
        }
        if (orderPoint != -1) {
            if (orderCondition.indexOf("\"VOUCHERTYPE.NAME\"") != -1) {
                orderCondition = orderCondition.replaceAll("\"VOUCHERTYPE.NAME\"", "FVoucherTypeNumber ");
            }
            if (orderCondition.indexOf("\"NUMBER\"") != -1) {
                orderCondition = orderCondition.replaceAll("\"NUMBER\"", "FVoucherNumber");
            }
            if (orderCondition.indexOf("\"BOOKEDDATE\"") != -1) {
                orderCondition = orderCondition.replaceAll("\"BOOKEDDATE\"", "FDATE");
            }
            if (orderCondition.indexOf("\"CREATETIME\"") != -1) {
                orderCondition = orderCondition.replaceAll("\"CREATETIME\"", "FCREATETIME");
            }
            value.put("orderCondition", orderCondition.toString());
        }
        return value;
    }

    public static String getAndStructJoinTable(HashMap table, String tableName, StringBuffer jointable, boolean isShowAccountCusAttribute) {
        if (table.containsKey(tableName)) {
            return table.get(tableName).toString();
        }
        if (tableName.endsWith("VOUCHERTYPE")) {
            jointable.append(" LEFT OUTER JOIN t_bd_vouchertypes " + tableName + " ON " + table.get("VOUCHER").toString() + ".F" + tableName + "ID = " + tableName + ".FID");
        } else if (tableName.endsWith("SETTLEMENTTYPE")) {
            if (isShowAccountCusAttribute && table.get("SETTLEMENTTYPE") != null) {
                table.put(tableName, table.get("SETTLEMENTTYPE").toString());
                return table.get("SETTLEMENTTYPE").toString();
            }
            if (jointable.indexOf("T_GL_VoucherAssistRecord") == -1) {
                jointable.append(" LEFT OUTER JOIN T_GL_VoucherAssistRecord ASSISTRECORDS ON " + table.get("VOUCHER").toString() + ".fid = ASSISTRECORDS.fbillid ");
            }
            jointable.append(" LEFT OUTER JOIN T_BD_SettlementType SETTLEMENTTYPE ON ASSISTRECORDS.F" + tableName + "ID = " + tableName + ".FID");
        } else if (tableName.endsWith("ASSHANDLER")) {
            if (isShowAccountCusAttribute && table.get("ASSHANDLER") != null) {
                table.put(tableName, table.get("ASSHANDLER").toString());
                return table.get("ASSHANDLER").toString();
            }
            if (jointable.indexOf("T_GL_VoucherAssistRecord") == -1) {
                jointable.append(" LEFT OUTER JOIN T_GL_VoucherAssistRecord ASSISTRECORDS ON " + table.get("VOUCHER").toString() + ".fid = ASSISTRECORDS.fbillid ");
            }
            jointable.append(" LEFT OUTER JOIN T_PM_User ASSHANDLER ON ASSISTRECORDS.FHandlerID = " + tableName + ".FID");
        } else if (tableName.endsWith("ASSISTRECORDS")) {
            jointable.append(" LEFT OUTER JOIN T_GL_VoucherAssistRecord ASSISTRECORDS ON " + table.get("VOUCHER").toString() + ".fid = ASSISTRECORDS.fbillid ");
        } else {
            jointable.append(" LEFT OUTER JOIN T_PM_User " + tableName + " ON " + table.get("VOUCHER").toString() + ".F" + tableName + "ID = " + tableName + ".FID");
        }
        table.put(tableName, tableName);
        return tableName;
    }

    public static String getStandardFiltedSqlGroupTable(String groupAlias, AsstactTypeEntity at, Context ctx) throws BOSException, EASBizException {
        if ("T_BD_CSSPGroup".equalsIgnoreCase(at.getGroupTable())) {
            String type = "T_BD_Customer".equalsIgnoreCase(at.getTableName()) ? "1" : "2";
            return "(select *  from " + at.getGroupTable() + " where FCSSPGroupStandardID='" + CSSPGroupStandardFactory.getLocalInstance((Context)ctx).getBasicStandardId(type) + "')";
        }
        return at.getGroupTable();
    }

    public static String getStandardFiltedSqlGroupTable(String groupAlias, AsstactTypeEntity at, boolean isFrom, Context ctx) throws BOSException, EASBizException {
        if (!isFrom) {
            return RptServerUtil.getStandardFiltedSqlGroupTable(groupAlias, at, ctx);
        }
        if ("T_BD_CSSPGroup".equalsIgnoreCase(at.getGroupTable())) {
            String type = "T_BD_Customer".equalsIgnoreCase(at.getTableName()) ? "1" : "2";
            return "(select G1.fid,G2.FLongNumber  from  " + at.getGroupTable() + "  G1  inner join   " + at.getGroupTable() + " G2 on G1.FCSSPGroupStandardID=G2.FCSSPGroupStandardID   and charindex(G2.FLongNumber,G1.FLongNumber||'!')=1 where G1.FCSSPGroupStandardID='" + CSSPGroupStandardFactory.getLocalInstance((Context)ctx).getBasicStandardId(type) + "')";
        }
        return at.getGroupTable();
    }

    public static String bigdecimalToString(BigDecimal number) {
        if (number == null) {
            return "0.0";
        }
        return CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)number);
    }

    public static List queryAllCompanyPeriodInfo(List companies, Context ctx) throws BOSException {
        ArrayList<CompanyPeriodInfo> periods = new ArrayList<CompanyPeriodInfo>();
        String sql = RptServerUtil.getSQL(companies);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        CompanyPeriodInfo cpi = null;
        try {
            while (rs.next()) {
                if (rs.getString("companyid") == null || rs.getString("startpid") == null || rs.getString("currpid") == null) continue;
                cpi = new CompanyPeriodInfo();
                cpi.setCompanyID(rs.getString("companyid"));
                cpi.setStartP(RptServerUtil.createStartPeriod(rs));
                cpi.setCurrP(RptServerUtil.createCurrPeriod(rs));
                periods.add(cpi);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception ee) {
            logger.error((Object)ee);
            throw new BOSException((Throwable)ee);
        }
        return periods;
    }

    public static String setTran2String(Set idSet) {
        if (idSet == null || idSet.size() < 1) {
            return "('')";
        }
        String ids = null;
        Iterator iter = idSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ids = ids == null ? "('" + (String)iter.next() + "'" : ids + ", '" + (String)iter.next() + "'";
            ++i;
        }
        ids = ids + ")";
        return ids;
    }

    private static String getSQL(List col) {
        StringBuffer sb = new StringBuffer();
        sb.append("select ssc.fcompanyid as companyid , \n");
        sb.append(" \n");
        sb.append("startp.fid as startpid,startp.fperiodyear as startpy,startp.fperiodquarter as startpq,startp.fperiodnumber as startpn, \n");
        sb.append("startp.fbegindate as startps,startp.fenddate as startpe,startp.fisadjustperiod as startpisa, \n");
        sb.append(" \n");
        sb.append("currp.fid as currpid,currp.fperiodyear as currpy,currp.fperiodquarter as currpq,currp.fperiodnumber as currpn, \n");
        sb.append("currp.fbegindate as currps,currp.fenddate as currpe,currp.fisadjustperiod as currpisa \n");
        sb.append(" \n");
        sb.append("from T_BD_SystemStatusCtrol as ssc \n");
        sb.append("left outer join T_BD_SystemStatus as ss on ssc.FSystemStatusID=ss.FID  \n");
        sb.append("left outer join T_BD_Period as startp on ssc.FStartPeriodID=startp.FID \n");
        sb.append("left outer join T_BD_Period as currp on ssc.FCurrentPeriodID=currp.FID \n");
        sb.append("where ssc.FCompanyID in ").append(RptServerUtil.setTran2String(RptServerUtil.getCompanyIDSet(col))).append(" and ss.FName=");
        sb.append(SystemEnum.GENERALLEDGER.getValue()).append(" \n");
        return sb.toString();
    }

    private static Set getCompanyIDSet(List col) {
        HashSet<String> idSet = new HashSet<String>();
        int size = col.size();
        SimpleCompanyUserObject company = null;
        for (int i = 0; i < size; ++i) {
            company = (SimpleCompanyUserObject)col.get(i);
            if (company == null) continue;
            idSet.add(company.getCompanyId());
        }
        return idSet;
    }

    private static PeriodInfo createCurrPeriod(IRowSet rs) throws UuidException, SQLException {
        if (rs.getString("currpid") == null || rs.getString("currpid").toString().trim().length() == 0) {
            return null;
        }
        PeriodInfo curP = new PeriodInfo();
        curP.setId(BOSUuid.read((String)rs.getString("currpid")));
        curP.setPeriodYear(rs.getInt("currpy"));
        curP.setPeriodQuarter(rs.getInt("currpq"));
        curP.setPeriodNumber(rs.getInt("currpn"));
        curP.setBeginDate((Date)rs.getDate("currps"));
        curP.setEndDate(rs.getTimestamp("currpe"));
        curP.setIsAdjustPeriod(rs.getBoolean("currpisa"));
        return curP;
    }

    private static PeriodInfo createStartPeriod(IRowSet rs) throws UuidException, SQLException {
        if (rs.getString("startpid") == null || rs.getString("startpid").toString().trim().length() == 0) {
            return null;
        }
        PeriodInfo startp = new PeriodInfo();
        startp.setId(BOSUuid.read((String)rs.getString("startpid")));
        startp.setPeriodYear(rs.getInt("startpy"));
        startp.setPeriodQuarter(rs.getInt("startpq"));
        startp.setPeriodNumber(rs.getInt("startpn"));
        startp.setBeginDate((Date)rs.getDate("startps"));
        startp.setEndDate(rs.getTimestamp("startpe"));
        startp.setIsAdjustPeriod(rs.getBoolean("startpisa"));
        return startp;
    }

    public static String queryAsstItemByAssisthgID(String AssisthgID, Context ctx) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fmappingfieldname                                                      ");
        sql.append("  from T_BD_AsstActType                                                       ");
        sql.append(" where fid in (select D.FAsstActTypeID                                        ");
        sql.append("                 from T_BD_AsstActGroupDetail D                               ");
        sql.append("                inner join T_BD_AsstActType AT on AT.FID = D.FAsstActTypeID   ");
        sql.append("                where D.FAsstAccountID in                                     ");
        sql.append("                      (select FAsstAccountID                                  ");
        sql.append("                        from T_BD_AssistantHG                                ");
        sql.append("                        where FID = ?)           \t\t\t\t\t\t\t  ");
        sql.append("                                                                              ");
        sql.append("               )                                                              ");
        try {
            String sqlQuery;
            IRowSet rs1;
            String mappingField;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{AssisthgID});
            if (rs.next() && (mappingField = rs.getString(1)) != null && (rs1 = DbUtil.executeQuery((Context)ctx, (String)(sqlQuery = "select " + mappingField + " from t_bd_assistanthg where fid = ?").toString(), (Object[])new Object[]{AssisthgID})).next()) {
                return rs1.getString(1);
            }
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        return AssisthgID;
    }

    public static String GetAsstSql(Context ctx, List list, boolean isAsstGroup, boolean WhereOrJoin, String fieldString, SqlParams whereSp) throws EASBizException, BOSException, ParseException {
        return RptServerUtil.GetAsstSql(ctx, list, isAsstGroup, WhereOrJoin, fieldString, whereSp, true);
    }

    public static String GetAsstSqlWithoutPermissionFilter(Context ctx, List list, boolean isAsstGroup, boolean WhereOrJoin, String fieldString, SqlParams whereSp) throws EASBizException, BOSException, ParseException {
        return RptServerUtil.GetAsstSql(ctx, list, isAsstGroup, WhereOrJoin, fieldString, whereSp, false);
    }

    private static String GetAsstSql(Context ctx, List list, boolean isAsstGroup, boolean WhereOrJoin, String fieldString, SqlParams whereSp, boolean needFilterPermission) throws EASBizException, BOSException, ParseException {
        StringBuffer selectSql = new StringBuffer();
        StringBuffer fromSql = new StringBuffer();
        StringBuffer whereSql = new StringBuffer();
        whereSp.clear();
        if (list != null) {
            String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String cuID = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            selectSql.append("select HG.FID from t_bd_assistanthg HG");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Collection obj;
                Object dist;
                AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                if (!at.isSelected()) continue;
                if (!isAsstGroup || !at.isUseGroup()) {
                    String tab = "T_" + i;
                    String tmpName = "B_" + i;
                    fromSql.append("\n inner join ").append(at.getTableName()).append(" ").append(tab);
                    fromSql.append(" on HG.").append(at.getHgField()).append("=").append(tab).append(".FID");
                    if (at.isUseGroup()) {
                        fromSql.append(" left join ").append(at.getGroupTable()).append(" ").append(tmpName).append(" on ").append(tmpName).append(".FID=").append(tab).append(".").append(at.getGroupField());
                    }
                    if (at.isGeneralActType()) {
                        fromSql.append(" and ").append(tab).append(".FGroupID='").append(at.getGeneralAsstactGroupId()).append("'");
                    }
                    if (at.getFrom() != null) {
                        whereSql.append(whereSql.length() == 0 ? "\n where " : " and ");
                        if (at.isUseGroup()) {
                            whereSql.append(tmpName).append(".FLongNumber||'!'||").append(tab).append(".FNumber").append(">=?");
                        } else {
                            whereSql.append(tab).append(at.isMultilevel() ? ".FLongNumber" : ".FNumber").append(">=?");
                        }
                        whereSp.addString(RptServerUtil.getActLongNumber(at, true, ctx));
                    }
                    if (at.getTo() != null) {
                        whereSql.append(whereSql.length() == 0 ? "\n where " : " and ");
                        if (at.isUseGroup()) {
                            whereSql.append(tmpName).append(".FLongNumber||'!'||").append(tab).append(".FNumber").append("<=?");
                        } else {
                            whereSql.append(tab).append(at.isMultilevel() ? ".FLongNumber" : ".FNumber").append("<=?");
                        }
                        whereSp.addString(RptServerUtil.getActLongNumber(at, false, ctx));
                    }
                    if (at.getDist() != null) {
                        dist = at.getDist();
                        if (dist instanceof Set) {
                            obj = (Set)dist;
                            if (obj.size() > 0) {
                                whereSql.append(whereSql.length() != 0 ? " and " : "\n where ");
                                if (at.isUseGroup()) {
                                    whereSql.append(tab).append(".FNumber").append(" in (");
                                } else {
                                    whereSql.append(tab).append(at.isMultilevel() ? ".FLongNumber" : ".FNumber").append(" in (");
                                }
                                Object asst2 = null;
                                for (Object asst2 : obj) {
                                    if (asst2 instanceof AssistViewFilterInfo) {
                                        String number = ((AssistViewFilterInfo)asst2).getNumber();
                                        if (at.isGeneralActType() && number != null) {
                                            number = number.replace(".", "!");
                                        }
                                        whereSp.addString(number);
                                    }
                                    whereSql.append("?,");
                                }
                                whereSql.deleteCharAt(whereSql.lastIndexOf(",")).append(")");
                            }
                        } else if (dist instanceof List && (obj = (List)dist).size() > 0) {
                            whereSql.append(whereSql.length() != 0 ? " and " : "\n where ");
                            if (at.isUseGroup()) {
                                whereSql.append(tab).append(".FNumber").append(" in (");
                            } else {
                                whereSql.append(tab).append(at.isMultilevel() ? ".FLongNumber" : ".FNumber").append(" in (");
                            }
                            DataBaseInfo singleDistValue = null;
                            for (Map asst : obj) {
                                String id;
                                String number = (String)asst.get("number");
                                if (at.isGeneralActType() && (id = (String)asst.get("id")) != null) {
                                    ObjectUuidPK pk = new ObjectUuidPK(id);
                                    singleDistValue = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getDataBaseInfo((IObjectPK)pk);
                                    number = (String)singleDistValue.get("longnumber");
                                }
                                whereSp.addString(number);
                                whereSql.append("?,");
                            }
                            whereSql.deleteCharAt(whereSql.lastIndexOf(",")).append(")");
                        }
                    }
                } else {
                    String asstGroup;
                    String tableAlias = "T_" + i;
                    fromSql.append("\n inner join ").append(at.getTableName()).append(" ").append(tableAlias);
                    fromSql.append(" on HG.").append(at.getHgField()).append(" = ").append(tableAlias).append(".FID");
                    if (at.isGeneralActType()) {
                        fromSql.append(" and " + tableAlias + ".FGroupID='" + at.getGeneralAsstactGroupId() + "' \r\n");
                    }
                    if ((asstGroup = at.getAsstGroup()) != null && asstGroup.length() > 0 && at.getAsstGroup().indexOf(35) >= 0) {
                        AcctountAsstItemParser.AccountAsstItem accountAsstItem = AcctountAsstItemParser.parse((String)("||" + at.getAsstGroup() + "#"));
                        AcctountAsstItemParser.Group[] groups = accountAsstItem.asstItems[0].group;
                        for (int j = 0; j < groups.length; ++j) {
                            AcctountAsstItemParser.Group group = groups[j];
                            whereSql.append(whereSql.length() == 0 ? "\n where " : " and ").append(tableAlias + ".FID in (");
                            whereSql.append("select GD." + (at.getHgAttribute().equalsIgnoreCase("provider") ? "FSupplierID" : at.getHgField()) + " from " + at.getTableName() + "Group" + (at.getHgAttribute().equalsIgnoreCase("Material") ? "Detial" : "Detail") + " GD").append(" inner join " + at.getGroupTable() + "Standard GS on GS.FID = GD.F" + (at.getHgAttribute().equalsIgnoreCase("provider") ? "Supplier" : at.getHgAttribute()) + "GroupStandardID").append(" inner join " + at.getGroupTable() + " G on G.FID = GD.F" + (at.getHgAttribute().equalsIgnoreCase("provider") ? "Supplier" : at.getHgAttribute()) + "GroupID");
                            whereSql.append(" where GS.FNumber = ?");
                            whereSp.addString(group.standardNumber);
                            if (group.startNumber != null) {
                                whereSql.append(" and (G.FLongNumber >= ? or G.FLongNumber like ?)");
                                whereSp.addString(group.startNumber).addString(group.startNumber);
                            }
                            if (group.endNumber != null) {
                                whereSql.append(" and (G.FLongNumber <= ? or G.FLongNumber like ?)");
                                whereSp.addString(group.endNumber).addString(group.endNumber);
                            }
                            whereSql.append(") \r\n");
                        }
                    }
                    if (at.isSelected()) {
                        DataBaseInfo obj2;
                        if (at.getFrom() != null) {
                            whereSql.append(whereSql.length() == 0 ? "\n where " : " and ");
                            whereSql.append(tableAlias).append(at.isGeneralActType() ? ".FLongNumber" : ".FNumber").append(">=?");
                            obj2 = (DataBaseInfo)at.getFrom();
                            whereSp.addString(obj2.get(at.isGeneralActType() ? "LongNumber" : "Number").toString());
                        }
                        if (at.getTo() != null) {
                            whereSql.append(whereSql.length() == 0 ? "\n where " : " and ");
                            whereSql.append(tableAlias).append(at.isGeneralActType() ? ".FLongNumber" : ".FNumber").append("<=?");
                            obj2 = (DataBaseInfo)at.getTo();
                            whereSp.addString(obj2.get(at.isGeneralActType() ? "LongNumber" : "Number").toString());
                        }
                        if (at.getDist() != null) {
                            dist = at.getDist();
                            if (dist instanceof Set) {
                                obj = (Set)dist;
                                if (obj.size() > 0) {
                                    whereSql.append(whereSql.length() != 0 ? " and " : "\n where ");
                                    whereSql.append(tableAlias).append(at.isGeneralActType() ? ".FLongNumber" : ".FNumber").append(" in (");
                                    Iterator it = obj.iterator();
                                    Map asst = null;
                                    while (it.hasNext()) {
                                        asst = (Map)it.next();
                                        if (asst instanceof AssistViewFilterInfo) {
                                            whereSp.addString(((AssistViewFilterInfo)((Object)asst)).getNumber());
                                        }
                                        whereSql.append("?,");
                                    }
                                    whereSql.deleteCharAt(whereSql.lastIndexOf(",")).append(")");
                                }
                            } else if (dist instanceof List && (obj = (List)dist).size() > 0) {
                                whereSql.append(whereSql.length() != 0 ? " and " : "\n where ");
                                whereSql.append(tableAlias).append(at.isGeneralActType() ? ".FLongNumber" : ".FNumber").append(" in (");
                                for (Map asst : obj) {
                                    whereSp.addString(asst.get("number").toString());
                                    whereSql.append("?,");
                                }
                                whereSql.deleteCharAt(whereSql.lastIndexOf(",")).append(")");
                            }
                        }
                        whereSql.append(" \r\n");
                    }
                }
                if (!at.isEnabledPermissionLimit() || !needFilterPermission) continue;
                fromSql.append("\n").append(RptServerUtil.innerJoinAsstactPermissionSql("HG." + at.getHgField(), at.getPermissionItem(), userID, cuID, ctx));
            }
        }
        String sql = WhereOrJoin ? (fromSql.length() > 0 ? fieldString + " in ( \r\n" + selectSql.toString() + fromSql.toString() + whereSql.toString() + ") \r\n" : "1=1") : (fromSql.length() > 0 ? " inner join (" + selectSql.toString() + fromSql.toString() + whereSql.toString() + ") HG on HG.FID = " + fieldString : "");
        return sql;
    }

    private static String getActLongNumber(AsstactTypeEntity at, boolean isFrom, Context ctx) throws BOSException, EASBizException {
        DataBaseInfo obj = (DataBaseInfo)(isFrom ? at.getFrom() : at.getTo());
        if (at.isUseGroup()) {
            RptRowSet rst;
            String sql = "select B.FLongNumber from " + at.getTableName() + " A inner join " + at.getGroupTable() + " B on A." + at.getGroupField() + "=B.FID where A.FID=?";
            try {
                rst = DBUtilx.executeQuery((String)sql, (SqlParams)new SqlParams().setString(1, obj.getId().toString()), (Context)ctx);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (rst.next()) {
                return rst.getString(0) + "!" + obj.get("number").toString();
            }
            if (obj.get("longnumber") != null) {
                return "!" + obj.get("longnumber").toString();
            }
            return "!" + obj.get("number").toString();
        }
        if (at.isUseLevel()) {
            if (obj.get("longnumber") == null) {
                String id;
                if (at.isGeneralActType() && (id = (String)obj.get("id")) != null) {
                    ObjectUuidPK pk = new ObjectUuidPK(id);
                    DataBaseInfo db = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getDataBaseInfo((IObjectPK)pk);
                    return (String)db.get("longnumber");
                }
                return obj.get("number").toString();
            }
            return obj.get("longnumber").toString();
        }
        return obj.get("number").toString();
    }

    public static List queryAsstActByAssisthgID(String AssisthgID, String cuId, Context ctx) throws BOSException, EASBizException {
        SqlParams pp = new SqlParams();
        StringBuffer sql = new StringBuffer();
        List list = RptServerUtil.queryAsstAct(null, cuId, ctx);
        for (int i = 0; i < list.size(); ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
            at.setSelected(false);
        }
        sql = new StringBuffer();
        sql.append("select D.FAsstActTypeID \n").append("from T_BD_AsstActGroupDetail D \n").append("\tinner join T_BD_AsstActType AT on AT.FID=D.FAsstActTypeID \n");
        sql.append("where D.FAsstAccountID = (select FAsstAccountID from T_BD_AssistantHG where FID = ? ) \n");
        pp.setString(1, AssisthgID);
        sql.append("order by AT.FNumber ");
        Connection con = null;
        con = RptServerUtil.getConnection(ctx);
        RptRowSet rs = null;
        try {
            rs = DBUtil.executeQuery((String)sql.toString(), (SqlParams)pp, (Connection)con);
            AsstActTypeCollection actTypesCol = new AsstActTypeCollection();
            while (rs.next()) {
                String asstActTypeID = rs.getString("FAsstActTypeID");
                for (int i = 0; i < list.size(); ++i) {
                    AsstactTypeEntity at = (AsstactTypeEntity)list.get(i);
                    if (!at.getId().equals(asstActTypeID)) continue;
                    at.setSelected(true);
                }
                IAsstActType iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK pk = new ObjectUuidPK(asstActTypeID);
                AsstActTypeInfo asstActTypeInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)pk);
                actTypesCol.add(asstActTypeInfo);
            }
            SelectorItemCollection selectors = new SelectorItemCollection();
            for (int i = 0; i < actTypesCol.size(); ++i) {
                AsstActTypeInfo asstActType = actTypesCol.get(i);
                String attr = asstActType.getAsstHGAttribute();
                selectors.add(attr + ".*");
            }
            AssistantHGInfo hgInfo = AssistantHGFactory.getLocalInstance((Context)ctx).getAssistantHGInfo((IObjectPK)new ObjectUuidPK(AssisthgID), selectors);
            for (int i = 0; i < actTypesCol.size(); ++i) {
                AsstActTypeInfo asstActType = actTypesCol.get(i);
                String attr = asstActType.getAsstHGAttribute();
                Object infObject = hgInfo.get(attr);
                for (int j = 0; j < list.size(); ++j) {
                    AsstactTypeEntity at = (AsstactTypeEntity)list.get(j);
                    if (!at.getHgAttribute().equalsIgnoreCase(attr)) continue;
                    at.setFrom(infObject);
                    at.setTo(infObject);
                }
            }
            List list2 = list;
            return list2;
        }
        catch (SQLException sqle) {
            throw new SQLAccessException(sqle);
        }
        finally {
            RptServerUtil.close(con, null, null);
        }
    }

    public static String[] getQueryNOTransPnLBalanceTable(Context ctx, int periodYear, int fromPeriodNumber, int toPeriodNumber, String companyid, boolean isAfterPeriod, boolean isincludeUnpost, int balanceType, String currencyID, BOSObjectType bosType) throws Exception {
        String tempTableName;
        String[] returnTemp = new String[2];
        String nameKey = GLBalanceUtils.getBalanceTable(balanceType, isincludeUnpost ? 1 : 5, currencyID).substring(1);
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyID)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyID)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        String createSql = "create table tempTable " + RptServerUtil.getBalanceTempTableStruct(balanceType, currencyID);
        returnTemp[1] = tempTableName = RptServerUtil.getTempTablePoolForRead(ctx, bosType).createTempTable(createSql);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTableName).append("(");
        sql.append(" FPeriod,\r\n ");
        sql.append(" FOrgUnitID,\r\n ");
        sql.append(" FAccountID,\r\n ");
        if (balanceType == 2) {
            sql.append(" FAssistGrpID,\r\n");
        } else if (balanceType == 3) {
            sql.append(" FMeasureUnitID,\r\n");
            sql.append(" FAssistGrpID,\r\n");
        }
        if (isForCurrency) {
            sql.append(" FCurrencyID,\r\n ");
            sql.append(" FDebitFor,\r\n ");
            sql.append(" FCreditFor,\r\n ");
            sql.append(" FYearDebitFor,\r\n ");
            sql.append(" FYearCreditFor,\r\n ");
            sql.append(" FEndBalanceFor,\r\n ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" FDebitLocal,\r\n ");
            sql.append(" FCreditLocal,\r\n ");
            sql.append(" FYearDebitLocal,\r\n ");
            sql.append(" FYearCreditLocal,\r\n ");
            sql.append(" FEndBalanceLocal,\r\n ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" FDebitRpt,\r\n ");
            sql.append(" FCreditRpt,\r\n ");
            sql.append(" FYearDebitRpt,\r\n ");
            sql.append(" FYearCreditRpt,\r\n ");
            sql.append(" FEndBalanceRpt,\r\n ");
        }
        sql.append(" FDebitQty,\r\n ");
        sql.append(" FCreditQty,\r\n ");
        sql.append(" FYearDebitQty,\r\n ");
        sql.append(" FYearCreditQty,\r\n ");
        sql.append(" FEndQty\r\n ");
        sql.append(")  ");
        sql.append("select P.FNumber Fperiod,vch.FCompanyID FCompanyID, \r\n");
        sql.append("       ve.FAccountID FAccountID, \r\n");
        if (balanceType == 2) {
            sql.append("       vast.FAssGrpID FAssistGrpID, \r\n");
        } else if (balanceType == 3) {
            sql.append("       case when vast.FMeasureUnitId is null then '00000000-0000-0000-0000-0000000000005B825C57' else vast.FMeasureUnitId end FMeasureUnitid, \r\n");
            sql.append("       vast.FAssGrpID FAssistGrpID, \r\n");
        }
        if (isForCurrency) {
            sql.append("       ve.FCurrencyID FCurrencyID, \r\n");
        }
        if (balanceType == 1) {
            sql.append("       -1*sum(ve.FOriginalAmount * ve.FEntryDC) FDebitForV, \r\n");
            sql.append("       -1*sum(ve.FOriginalAmount * (1 - ve.FEntryDC)) FCreditForV, \r\n");
            sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then ve.FOriginalAmount * ve.FEntryDC else 0 end) FYearDebitForV, \r\n");
            sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then ve.FOriginalAmount * (1 - ve.FEntryDC) else 0 end) FYearCreditForV, \r\n");
            sql.append("       -1*sum(ve.FOriginalAmount * (2 * ve.FEntryDC - 1)) FEndBalanceForV, \r\n");
            sql.append("       -1*sum(ve.FLocalAmount * ve.FEntryDC) FDebitLocalV, \r\n");
            sql.append("       -1*sum(ve.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocalV, \r\n");
            sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then ve.FLocalAmount * ve.FEntryDC else 0 end) FYearDebitLocalV, \r\n");
            sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then ve.FLocalAmount * (1 - ve.FEntryDC) else 0 end) FYearCreditLocalV, \r\n");
            sql.append("       -1*sum(ve.FLocalAmount * (2 * ve.FEntryDC - 1)) FEndBalanceLocalV, \r\n");
            sql.append("       -1*sum(ve.FReportingAmount * ve.FEntryDC) FDebitRptV, \r\n");
            sql.append("       -1*sum(ve.FReportingAmount * (1 - ve.FEntryDC)) FCreditRptV, \r\n");
            sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then ve.FReportingAmount * ve.FEntryDC else 0 end) FYearDebitRptV, \r\n");
            sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then ve.FReportingAmount * (1 - ve.FEntryDC) else 0 end) FYearCreditRptV, \r\n");
            sql.append("       -1*sum(ve.FReportingAmount * (2 * ve.FEntryDC - 1)) FEndBalanceRptV, \r\n");
            sql.append("       -1*sum(ve.FStandardQuantity * ve.FEntryDC) FDebitQtyV, \r\n");
            sql.append("       -1*sum(ve.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQtyV, \r\n");
            sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then ve.FStandardQuantity * ve.FEntryDC else 0 end) FYearDebitQtyV, \r\n");
            sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then ve.FStandardQuantity * (1 - ve.FEntryDC) else 0 end) FYearCreditQtyV, \r\n");
            sql.append("       -1*sum(ve.FStandardQuantity * (2 * ve.FEntryDC - 1)) FEndQtyV \r\n");
            sql.append("   from T_GL_Voucher vch \r\n");
            sql.append(" inner join T_GL_VoucherEntry ve on vch.FID = ve.FBillID \r\n");
            sql.append("inner join t_bd_period p on p.fid = vch.fperiodid \r\n");
            sql.append(" where vch.FSourceType = 1    \r\n");
            sql.append(" and p.fnumber >=").append(fromPeriodNumber).append(" and p.fnumber <= ").append(toPeriodNumber).append("\r\n");
            if (isincludeUnpost) {
                sql.append(" and vch.FBizStatus <> 0   and vch.FBizStatus <> 2 \r\n");
            } else {
                sql.append(" and vch.FBizStatus = 5 \r\n");
            }
            sql.append(" and vch.FCompanyid in (").append(companyid).append(") \r\n");
            sql.append(" group by vch.FCompanyID, vch.FPeriodID, ve.FAccountID, ve.FCurrencyID \r\n");
        } else {
            if (isForCurrency) {
                sql.append("       -1*sum(vast.FOriginalAmount * ve.FEntryDC) FDebitForV, \r\n");
                sql.append("       -1*sum(vast.FOriginalAmount * (1 - ve.FEntryDC)) FCreditForV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FOriginalAmount * ve.FEntryDC else 0 end) FYearDebitForV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FOriginalAmount * (1 - ve.FEntryDC) else 0 end) FYearCreditForV, \r\n");
                sql.append("       -1*sum(vast.FOriginalAmount * (2 * ve.FEntryDC - 1)) FEndBalanceForV, \r\n");
            }
            if (isLocaCurrency || isForCurrency) {
                sql.append("       -1*sum(vast.FLocalAmount * ve.FEntryDC) FDebitLocalV, \r\n");
                sql.append("       -1*sum(vast.FLocalAmount * (1 - ve.FEntryDC)) FCreditLocalV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FLocalAmount * ve.FEntryDC else 0 end) FYearDebitLocalV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FLocalAmount * (1 - ve.FEntryDC) else 0 end) FYearCreditLocalV, \r\n");
                sql.append("       -1*sum(vast.FLocalAmount * (2 * ve.FEntryDC - 1)) FEndBalanceLocalV, \r\n");
            }
            if (isRptCurrency || isForCurrency) {
                sql.append("       -1*sum(vast.FReportingAmount * ve.FEntryDC) FDebitRptV, \r\n");
                sql.append("       -1*sum(vast.FReportingAmount * (1 - ve.FEntryDC)) FCreditRptV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FReportingAmount * ve.FEntryDC else 0 end) FYearDebitRptV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FReportingAmount * (1 - ve.FEntryDC) else 0 end) FYearCreditRptV, \r\n");
                sql.append("       -1*sum(vast.FReportingAmount * (2 * ve.FEntryDC - 1)) FEndBalanceRptV, \r\n");
            }
            if (balanceType == 2) {
                sql.append("       -1*sum(vast.FStandardQuantity * ve.FEntryDC) FDebitQtyV, \r\n");
                sql.append("       -1*sum(vast.FStandardQuantity * (1 - ve.FEntryDC)) FCreditQtyV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FStandardQuantity * ve.FEntryDC else 0 end) FYearDebitQtyV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FStandardQuantity * (1 - ve.FEntryDC) else 0 end) FYearCreditQtyV, \r\n");
                sql.append("       -1*sum(vast.FStandardQuantity * (2 * ve.FEntryDC - 1)) FEndQtyV \r\n");
            } else if (balanceType == 3) {
                sql.append("       -1*sum(vast.FQuantity * ve.FEntryDC) FDebitQtyV, \r\n");
                sql.append("       -1*sum(vast.FQuantity * (1 - ve.FEntryDC)) FCreditQtyV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FQuantity * ve.FEntryDC else 0 end) FYearDebitQtyV, \r\n");
                sql.append("       -1*sum(case when p.fperiodyear = " + periodYear + " then vast.FQuantity * (1 - ve.FEntryDC) else 0 end) FYearCreditQtyV, \r\n");
                sql.append("       -1*sum(vast.FQuantity * (2 * ve.FEntryDC - 1)) FEndQtyV \r\n");
            }
            sql.append("   from T_GL_Voucher vch \r\n");
            sql.append(" inner join T_GL_VoucherEntry ve on vch.FID = ve.FBillID \r\n");
            sql.append(" inner join T_GL_VoucherAssistRecord vast\t  on ve.FID = vast.FEntryID\t  \r\n");
            sql.append("inner join t_bd_period p on p.fid = vch.fperiodid \r\n");
            sql.append(" where vch.FSourceType = 1    \r\n");
            sql.append(" and p.fnumber >=").append(fromPeriodNumber).append(" and p.fnumber <= ").append(toPeriodNumber).append("\r\n");
            if (isincludeUnpost) {
                sql.append(" and vch.FBizStatus <> 0   and vch.FBizStatus <> 2 \r\n");
            } else {
                sql.append(" and vch.FBizStatus = 5 \r\n");
            }
            sql.append(" and vch.FCompanyid in (").append(companyid).append(") \r\n");
            sql.append(" and vast.FAssGrpID is not null  \r\n");
            if (balanceType == 3) {
                sql.append("  and exists(select 1 from t_bd_accountview k where k.fid=ve.faccountid and k.fisqty=1)");
            }
            sql.append(" group by vch.FCompanyID, vch.FPeriodID,p.Fnumber, ve.FAccountID \r\n");
            if (isForCurrency) {
                sql.append(", ve.FCurrencyID \r\n");
            }
            sql.append(",vast.FAssGrpID \r\n");
            if (balanceType == 3) {
                sql.append(",vast.FMeasureUnitId");
            }
        }
        sql.append(" \r\n");
        Connection con = RptServerUtil.getConnectionForRead(ctx, bosType);
        try {
            DBUtils.executeUpdate((String)sql.toString(), null, (Connection)con);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            RptServerUtil.close(con, null, null);
        }
        String periodtype = ContextUtil.getCurrentFIUnit((Context)ctx).getAccountPeriodType() == null ? null : ContextUtil.getCurrentFIUnit((Context)ctx).getAccountPeriodType().getId().toString();
        sql.setLength(0);
        sql.append("insert into ").append(tempTableName).append("(");
        sql.append(" Fperiod,\r\n ");
        sql.append(" FOrgUnitID,\r\n ");
        sql.append(" FAccountID,\r\n ");
        if (balanceType == 2) {
            sql.append(" FAssistGrpID\r\n");
        } else if (balanceType == 3) {
            sql.append(" FMeasureUnitID,\r\n");
            sql.append(" FAssistGrpID\r\n");
        }
        if (isForCurrency) {
            sql.append(" ,FCurrencyID\r\n ");
        }
        sql.append(" )\r\n ");
        sql.append("select distinct p.FNumber,FOrgUnitID,FAccountID,");
        if (balanceType == 2) {
            sql.append(" FAssistGrpID\r\n");
        } else if (balanceType == 3) {
            sql.append(" FMeasureUnitID,\r\n");
            sql.append(" FAssistGrpID\r\n");
        }
        if (isForCurrency) {
            sql.append(",FCurrencyID \r\n ");
        }
        sql.append(" from ");
        sql.append(tempTableName).append(" temp ,t_bd_period p ");
        sql.append("where p.fnumber <= ").append(toPeriodNumber);
        sql.append(" and p.fnumber >= ").append(fromPeriodNumber);
        if (periodtype != null) {
            sql.append(" and p.ftypeid = '").append(periodtype).append("'\r\n");
        }
        sql.append(" and  not exists ( select 1 from " + tempTableName + " tt \r\nwhere tt.fperiod <= " + toPeriodNumber + " and  tt.fperiod >= " + fromPeriodNumber + " and temp.FOrgUnitID=tt.FOrgUnitID and temp.FAccountID = tt.FAccountID and  p.fnumber = tt.fperiod");
        if (isForCurrency) {
            sql.append(" and temp.FCurrencyID = tt.FCurrencyID ");
        }
        if (balanceType == 2) {
            sql.append(" and temp.FAssistGrpID=tt.FAssistGrpID\r\n");
        } else if (balanceType == 3) {
            sql.append(" and temp.FMeasureUnitID=tt.FMeasureUnitID\r\n");
            sql.append(" and temp.FAssistGrpID=tt.FAssistGrpID\r\n");
        }
        sql.append(")");
        con = RptServerUtil.getConnectionForRead(ctx, bosType);
        try {
            DBUtils.executeUpdate((String)sql.toString(), null, (Connection)con);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            RptServerUtil.close(con, null, null);
        }
        try {
            String index = "FAccountID,FOrgUnitID";
            if (isForCurrency) {
                index = index + ",fcurrencyid";
            }
            index = index + ",FPeriod";
            if (balanceType == 2) {
                index = index + ",FAssistGrpID";
            } else if (balanceType == 3) {
                index = index + ",FAssistGrpID,FMeasureUnitID";
            }
            TempTablePool pool = RptServerUtil.getTempTablePoolForRead(ctx, bosType);
            index = "FAssistGrpID,FAccountID,FOrgUnitID";
            if (isForCurrency) {
                index = index + ",fcurrencyid";
            }
            index = index + ",FPeriod";
            pool.createIndex(tempTableName, index, false, false);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        sql.setLength(0);
        sql.append("update ").append(tempTableName);
        sql.append(" set ( \r\n");
        if (isForCurrency) {
            sql.append("fyeardebitfor,fyearcreditfor,fendbalancefor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("fyeardebitlocal,fyearcreditlocal,fendbalancelocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("fyeardebitrpt,fyearcreditrpt,fendbalancerpt, \n");
        }
        sql.append("fyeardebitqty,fyearcreditqty,fendqty \n");
        sql.append(") \n");
        sql.append(" = ( \r\n");
        sql.append("select \n");
        if (isForCurrency) {
            sql.append("t.fyeardebitfor,t.fyearcreditfor,t.fendbalancefor, \n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("t.fyeardebitlocal,t.fyearcreditlocal,t.fendbalancelocal, \n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("t.fyeardebitrpt,t.fyearcreditrpt,t.fendbalancerpt, \n");
        }
        sql.append("t.fyeardebitqty,fyearcreditqty,t.fendqty \n");
        sql.append(" from (select t1.forgunitid orgunitid,ap.fnumber period,t1.faccountid accountid,");
        if (isForCurrency) {
            sql.append("t1.fcurrencyid currencyid,");
        }
        if (balanceType == 2) {
            sql.append("t1.FAssistGrpID AssistGrpID,");
        } else if (balanceType == 3) {
            sql.append("t1.FAssistGrpID AssistGrpID, t1.FMeasureUnitID MeasureUnitID, ");
        }
        if (isForCurrency) {
            sql.append(" sum(case when TO_INT(t1.fperiod/100) = " + periodYear + " then t1.fdebitfor else 0 end) fyeardebitfor,");
            sql.append(" sum(case when TO_INT(t1.fperiod/100) = " + periodYear + " then t1.fcreditfor else 0 end) fyearcreditfor, ");
            sql.append(" sum(t1.fdebitfor - t1.fcreditfor) fendbalancefor, ");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append(" sum(case when TO_INT(t1.fperiod/100) = " + periodYear + " then t1.fdebitlocal else 0 end) fyeardebitlocal,");
            sql.append(" sum(case when TO_INT(t1.fperiod/100) = " + periodYear + " then t1.fcreditlocal else 0 end) fyearcreditlocal, ");
            sql.append(" sum(t1.fdebitlocal - t1.fcreditlocal) fendbalancelocal, ");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append(" sum(case when TO_INT(t1.fperiod/100) = " + periodYear + " then t1.fdebitrpt else 0 end) fyeardebitrpt,");
            sql.append(" sum(case when TO_INT(t1.fperiod/100) = " + periodYear + " then t1.fcreditrpt else 0 end) fyearcreditrpt, ");
            sql.append(" sum(t1.fdebitrpt - t1.fcreditrpt) fendbalancerpt, ");
        }
        sql.append(" sum(case when TO_INT(t1.fperiod/100) = " + periodYear + " then t1.fdebitqty else 0 end) fyeardebitqty, ");
        sql.append(" sum(case when TO_INT(t1.fperiod/100) = " + periodYear + " then t1.fcreditqty else 0 end) fyearcreditqty, ");
        sql.append(" sum(t1.fdebitqty - t1.fcreditqty) fendqty ");
        sql.append(" from ").append(tempTableName).append(" t1 ");
        sql.append(" inner join t_bd_period ap on 1=1 ");
        sql.append(" where ap.fnumber>=t1.fperiod ");
        if (periodtype != null) {
            sql.append(" and ap.ftypeid = '").append(periodtype).append("'\r\n");
        }
        sql.append(" group by t1.forgunitid,ap.fnumber,t1.faccountid");
        if (isForCurrency) {
            sql.append(",t1.fcurrencyid");
        }
        if (balanceType == 2) {
            sql.append(" ,t1.FAssistGrpID ");
        } else if (balanceType == 3) {
            sql.append(" ,t1.FAssistGrpID, t1.FMeasureUnitID ");
        }
        sql.append(") t where t.orgunitid = forgunitid and t.period = fperiod and t.accountid = faccountid ");
        if (isForCurrency) {
            sql.append(" and t.currencyid = fcurrencyid ");
        }
        if (balanceType == 2) {
            sql.append(" and t.AssistGrpID=FAssistGrpID ");
        } else if (balanceType == 3) {
            sql.append(" and t.MeasureUnitID=FMeasureUnitID ");
            sql.append(" and t.AssistGrpID=FAssistGrpID ");
        }
        sql.append(")");
        con = RptServerUtil.getConnectionForRead(ctx, bosType);
        try {
            DBUtils.executeUpdate((String)sql.toString(), null, (Connection)con);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            RptServerUtil.close(con, null, null);
        }
        sql.setLength(0);
        sql.append("insert into ").append(tempTableName).append(" \r\n");
        sql.append("select ").append(RptServerUtil.getBalanceColumns(balanceType, currencyID)).append(" from ").append(isAfterPeriod ? "V" : "T" + nameKey).append(" bal ").append("where exists ( select 1 from ").append(tempTableName).append(" temp ").append("\r\n where temp.faccountid = bal.faccountid ");
        if (isForCurrency) {
            sql.append(" and bal.fcurrencyid=temp.fcurrencyid ");
        }
        sql.append(" and bal.fperiod =temp.fperiod ");
        if (balanceType == 2) {
            sql.append(" and temp.FAssistGrpID=bal.FAssistGrpID ");
        } else if (balanceType == 3) {
            sql.append(" and temp.FMeasureUnitID=bal.FMeasureUnitID ");
            sql.append(" and temp.FAssistGrpID=bal.FAssistGrpID ");
        }
        sql.append(")");
        sql.append(" and forgunitid in (").append(companyid).append(") ");
        con = RptServerUtil.getConnectionForRead(ctx, bosType);
        try {
            DBUtils.executeUpdate((String)sql.toString(), null, (Connection)con);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            RptServerUtil.close(con, null, null);
        }
        StringBuffer sqlGet = new StringBuffer();
        sqlGet.append("(select ").append(RptServerUtil.getBalanceColumns(balanceType, currencyID)).append(" from ").append(isAfterPeriod ? "V" : "T" + nameKey);
        sqlGet.append(" bal where ");
        sqlGet.append(" forgunitid in (").append(companyid).append(") ");
        sqlGet.append(" and bal.fperiod >=").append(fromPeriodNumber).append(" and bal.fperiod <= ").append(toPeriodNumber).append(" ");
        sqlGet.append(" and not exists (");
        sqlGet.append(" select 1 from ").append(tempTableName).append(" temp ").append("\r\n where temp.faccountid = bal.faccountid ");
        if (isForCurrency) {
            sqlGet.append(" and bal.fcurrencyid=temp.fcurrencyid ");
        }
        sqlGet.append(" and bal.fperiod =temp.fperiod ");
        if (balanceType == 2) {
            sqlGet.append(" and temp.FAssistGrpID=bal.FAssistGrpID ");
        } else if (balanceType == 3) {
            sqlGet.append(" and temp.FMeasureUnitID=bal.FMeasureUnitID ");
            sqlGet.append(" and temp.FAssistGrpID=bal.FAssistGrpID ");
        }
        sqlGet.append(")");
        sqlGet.append("\r\n union all\r\n");
        sqlGet.append(" select \r\n");
        sqlGet.append("FOrgUnitID  ,\r\n");
        sqlGet.append("FAccountID  ,\r\n");
        if (balanceType == 2) {
            sqlGet.append("FAssistGrpID  ,\r\n");
        } else if (balanceType == 3) {
            sqlGet.append("FMeasureUnitID  ,\r\n");
            sqlGet.append("FAssistGrpID  ,\r\n");
        }
        if (isForCurrency) {
            sqlGet.append("FCurrencyID  ,\r\n");
            sqlGet.append("sum(FBeginBalanceFor ) FBeginBalanceFor,\r\nsum(FYearDebitFor ) FYearDebitFor,\r\nsum(FYearCreditFor ) FYearCreditFor,\r\nsum(FDebitFor ) FDebitFor,\r\nsum(FCreditFor ) FCreditFor,\r\nsum(FEndBalanceFor ) FEndBalanceFor,\r\nsum(FYearPnLFor ) FYearPnLFor,\r\nsum(FMonthPnLFor ) FMonthPnLFor,\r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sqlGet.append("sum(FBeginBalanceLocal ) FBeginBalanceLocal,\r\nsum(FYearDebitLocal ) FYearDebitLocal,\r\nsum(FYearCreditLocal ) FYearCreditLocal,\r\nsum(FDebitLocal ) FDebitLocal,\r\nsum(FCreditLocal ) FCreditLocal,\r\nsum(FEndBalanceLocal ) FEndBalanceLocal,\r\nsum(FYearPnLLocal ) FYearPnLLocal,\r\nsum(FMonthPnLLocal ) FMonthPnLLocal,\r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sqlGet.append("sum(FBeginBalanceRpt ) FBeginBalanceRpt,\r\nsum(FYearDebitRpt ) FYearDebitRpt,\r\nsum(FYearCreditRpt ) FYearCreditRpt,\r\nsum(FDebitRpt ) FDebitRpt,\r\nsum(FCreditRpt ) FCreditRpt,\r\nsum(FEndBalanceRpt ) FEndBalanceRpt,\r\nsum(FYearPnLRpt ) FYearPnLRpt,\r\nsum(FMonthPnLRpt ) FMonthPnLRpt,\r\n");
        }
        sqlGet.append("sum(FBeginQty ) FBeginQty,\r\nsum(FYearDebitQty ) FYearDebitQty,\r\nsum(FYearCreditQty ) FYearCreditQty,\r\nsum(FDebitQty ) FDebitQty,\r\nsum(FCreditQty ) FCreditQty,\r\nsum(FEndQty ) FEndQty\r\n,FPeriod");
        sqlGet.append("\r from ").append(tempTableName);
        sqlGet.append("\r\n group by FOrgUnitID,FPeriod,FAccountID \r\n");
        if (isForCurrency) {
            sqlGet.append(",FCurrencyID \n");
        }
        if (balanceType == 2) {
            sqlGet.append(",FAssistGrpID ");
        } else if (balanceType == 3) {
            sqlGet.append(",FMeasureUnitID ");
            sqlGet.append(",FAssistGrpID");
        }
        sqlGet.append(") ");
        returnTemp[0] = sqlGet.toString();
        return returnTemp;
    }

    private static String getBalanceTempTableStruct(int balanceType, String currencyId) {
        StringBuffer sql = new StringBuffer();
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        sql.append(" (\r\n");
        sql.append("FOrgUnitID VARCHAR(44) NOT NULL ,\r\n");
        sql.append("FAccountID VARCHAR(44) NOT NULL ,\r\n");
        if (balanceType == 2) {
            sql.append("FAssistGrpID VARCHAR(44) NOT NULL ,\r\n");
        } else if (balanceType == 3) {
            sql.append("FMeasureUnitID VARCHAR(44) NOT NULL ,\r\n");
            sql.append("FAssistGrpID VARCHAR(44) NOT NULL ,\r\n");
        }
        if (isForCurrency) {
            sql.append("FCurrencyID VARCHAR(44) NOT NULL ,\r\n");
            sql.append("FBeginBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFEndBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearPnLFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFMonthPnLFor NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("FBeginBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFEndBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearPnLLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFMonthPnLLocal NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("FBeginBalanceRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearDebitRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearCreditRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFDebitRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFCreditRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFEndBalanceRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFYearPnLRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\nFMonthPnLRpt NUMERIC(19,4) DEFAULT 0 NOT NULL ,\r\n");
        }
        sql.append("FBeginQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,\r\nFYearDebitQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,\r\nFYearCreditQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,\r\nFDebitQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,\r\nFCreditQty NUMERIC(28,10) DEFAULT 0 NOT NULL ,\r\nFEndQty NUMERIC(28,10) DEFAULT 0 NOT NULL,\r\nFPeriod INT DEFAULT 190000 NOT NULL \r\n");
        sql.append("   )\r\n");
        return sql.toString();
    }

    private static String getBalanceColumns(int balanceType, String currencyId) {
        boolean isForCurrency = false;
        boolean isLocaCurrency = false;
        boolean isRptCurrency = false;
        if ("11111111-1111-1111-1111-111111111111DEB58FDC".equals(currencyId)) {
            isLocaCurrency = true;
        } else if ("22222222-2222-2222-2222-222222222222DEB58FDC".equals(currencyId)) {
            isRptCurrency = true;
        } else {
            isForCurrency = true;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("FOrgUnitID,\r\n");
        sql.append("FAccountID,\r\n");
        if (balanceType == 2) {
            sql.append("FAssistGrpID,\r\n");
        } else if (balanceType == 3) {
            sql.append("FMeasureUnitID,\r\n");
            sql.append("FAssistGrpID,\r\n");
        }
        if (isForCurrency) {
            sql.append("FCurrencyID,\r\n");
            sql.append("FBeginBalanceFor,\r\nFYearDebitFor,\r\nFYearCreditFor,\r\nFDebitFor,\r\nFCreditFor,\r\nFEndBalanceFor,\r\nFYearPnLFor,\r\nFMonthPnLFor,\r\n");
        }
        if (isLocaCurrency || isForCurrency) {
            sql.append("FBeginBalanceLocal,\r\nFYearDebitLocal,\r\nFYearCreditLocal,\r\nFDebitLocal,\r\nFCreditLocal,\r\nFEndBalanceLocal,\r\nFYearPnLLocal,\r\nFMonthPnLLocal,\r\n");
        }
        if (isRptCurrency || isForCurrency) {
            sql.append("FBeginBalanceRpt,\r\nFYearDebitRpt,\r\nFYearCreditRpt,\r\nFDebitRpt,\r\nFCreditRpt,\r\nFEndBalanceRpt,\r\nFYearPnLRpt,\r\nFMonthPnLRpt,\r\n");
        }
        sql.append("FBeginQty,\r\nFYearDebitQty,\r\nFYearCreditQty,\r\nFDebitQty,\r\nFCreditQty,\r\nFEndQty,\r\nFPeriod");
        return sql.toString();
    }

    public static Map getCompanyPeriod(Integer periodYearFrom, Integer periodNumberFrom, Integer periodYearTo, Integer periodNumberTo, AccountTableInfo value, CompanyOrgUnitInfo company, Context ctx) throws SQLDataException, RptException {
        String companyIds = company.getDescription();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FEnabledPeriodID from T_BD_AcctRefContrast arf");
        sql.append("\r\n inner join t_bd_period p on p.fid = arf.FEnabledPeriodID");
        sql.append("\r\n where arf.fenabledaccttableid = ? and p.fperiodyear<? and fcompanyid in (" + companyIds + ") and arf.fisenabled=1");
        sql.append("\r\n union ");
        sql.append("\r\n select distinct FEnabledPeriodID from T_BD_AcctRefContrast arf");
        sql.append("\r\n inner join t_bd_period p on p.fid = arf.FEnabledPeriodID");
        sql.append("\r\n where arf.fdisabledaccttableid = ? and p.fperiodyear >=? and fcompanyid in (" + companyIds + ")  and arf.fisenabled=1");
        sql.append("\r\n union");
        sql.append("\r\n select fid as FEnabledPeriodID from t_org_company where fid in (" + companyIds + ")  ");
        sql.append("\r\n and faccounttableid = ? ");
        sql.append("\r\n and fid not in (");
        sql.append("\r\n select fcompanyid from  T_BD_AcctRefContrast where fisenabled=1 )");
        SqlParams parameter = new SqlParams();
        parameter.addString(value.getId().toString());
        parameter.addInt(periodYearFrom.intValue());
        parameter.addString(value.getId().toString());
        parameter.addInt(periodYearTo.intValue());
        parameter.addString(value.getId().toString());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = RptServerUtil.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParams(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                map.put("isTrue", Boolean.TRUE);
            }
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
        return map;
    }

    public static TempTablePool getTempTablePoolForRead(Context ctx, BOSObjectType bosType) throws BOSException, EASBizException {
        String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(bosType.toString());
        return TempTablePool.getInstanceForRead((Context)ctx, (String)ais);
    }

    public static Connection getConnectionForRead(Context ctx, BOSObjectType bosType) throws EASBizException, BOSException {
        String ais = CommRptRouteConfigFacadeFactory.getLocalInstance((Context)ctx).getConnectionKey(bosType.toString());
        try {
            return QueryConnectionProvider.getConnection((Context)ctx, (String)ais);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static CompanyOrgUnitInfo getCompany(Context ctx, CompanyOrgUnitInfo company, int yearEnd, int numberEnd) {
        try {
            company = GlUtils.getCompanyById(ctx, company.getId().toString());
            AccountRefContrastInfo ar = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), company.getAccountTable().getId().toString(), yearEnd, numberEnd);
            if (ar != null && ar.getEnabledAcctTable() != null) {
                company.setAccountTable(RptServerUtil.periodCheckForAccountRefContrast(ar, yearEnd, numberEnd) ? ar.getDisabledAcctTable() : ar.getEnabledAcctTable());
            }
        }
        catch (EASBizException eASBizException) {
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return company;
    }

    public static boolean periodCheckForAccountRefContrast(AccountRefContrastInfo ar, int year, int month) {
        if (ar.getEnabledPeriod() == null) {
            return false;
        }
        int periodYear = ar.getEnabledPeriod().getPeriodYear();
        int periodNumber = ar.getEnabledPeriod().getPeriodNumber();
        return year <= periodYear && (year != periodYear || month <= periodNumber);
    }

    public static void executeBatch(Context ctx, List<String> updateSqlList) throws BOSException {
        Connection con = null;
        Statement ps = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.createStatement();
            int count = 0;
            for (String s : updateSqlList) {
                ps.addBatch(s);
                if (++count != 100) continue;
                ps.executeBatch();
                ps.clearBatch();
                count = 0;
            }
            if (count > 0) {
                ps.executeBatch();
                ps.clearBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                e.setNextException(new SQLException("Execute batch error: " + e));
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)con);
    }
}

