/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.IRptBase;
import com.kingdee.eas.fi.gl.ReportBizException;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptUIContext
extends RptParams
implements Serializable,
Cloneable {
    private static final Logger logger = Logger.getLogger(RptUIContext.class);
    private IRptBase irb;

    public RptUIContext(IRptBase irb) throws ReportBizException, BOSException, EASBizException {
        this.irb = irb;
        this.init();
    }

    private void init() throws ReportBizException, BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        this.putAll(this.irb.init(company));
        this.setObject("company", company);
    }

    public RptUIContext copy() {
        return this;
    }

    public CompanyOrgUnitInfo getCompany() {
        return (CompanyOrgUnitInfo)this.getObject("company");
    }

    public String getCompanyID() {
        return this.getCompany().getId().toString();
    }

    public CurrencyCollection getAllCurrency() {
        return (CurrencyCollection)this.getObject("getAllCurrency");
    }

    public Map getCurrencyScaleMap() {
        return (Map)this.getObject("getCurrencyScaleMap");
    }

    public int getCurrencyScale(CurrencyInfo currency) {
        return this.getCurrencyScale(currency.getId().toString());
    }

    public int getCurrencyScale(String currencyId) {
        return (Integer)this.getCurrencyScaleMap().get(currencyId);
    }

    public int getMaxGroupControlAccountLevel() {
        return this.getInt("getMaxGroupControlAccountLevel");
    }

    public int getMaxAccountLevel() throws ReportException {
        int maxAccountLevel = this.getInt("getMaxAccountLevel");
        if (maxAccountLevel <= 0) {
            throw new ReportException(ReportException.GET_ACCOUNT_ERROR);
        }
        return maxAccountLevel;
    }

    public String getUserName() {
        return SysContext.getSysContext().getUserName();
    }

    public String getCurrencyFormat(CurrencyInfo currency) {
        int scale = 0;
        if (currency != null) {
            scale = this.getCurrencyScale(currency);
        }
        return KDTableUtil.getNumberFormat((int)scale, (boolean)true);
    }

    public boolean isBalanceDirSamAsAccount() {
        return Boolean.valueOf(this.getSystemParams().getObject("GL_005").toString());
    }

    public boolean isAssitShowNumber() {
        return Boolean.valueOf(this.getSystemParams().getObject("GL_004").toString());
    }

    public boolean isAccountShowLongName() {
        return Boolean.valueOf(this.getSystemParams().getObject("GL_012").toString());
    }

    public boolean isForeignCurrencySu() {
        return Boolean.valueOf(this.getSystemParams().getObject("GL_008").toString());
    }

    public void reloadSystemParams() {
        ObjectUuidPK comPk = new ObjectUuidPK(this.getCompanyID());
        RptParams pp = new RptParams();
        pp.setObject("G001", null);
        pp.setObject("GL_004", (Object)comPk);
        pp.setObject("GL_005", (Object)comPk);
        pp.setObject("GL_006", (Object)comPk);
        pp.setObject("GL_009", (Object)comPk);
        pp.setObject("GL_012", (Object)comPk);
        pp.setObject("GL_002", (Object)comPk);
        pp.setObject("GL_003", (Object)comPk);
        pp.setObject("GL_008", (Object)comPk);
        pp.setObject("G000", null);
        try {
            IParamControl pc = ParamControlFactory.getRemoteInstance();
            HashMap allParam = pc.getParamHashMap(new HashMap(pp.toMap()));
            this.setObject("getSystemParams", RptParams.parseFrom((Map)allParam));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public RptParams getSystemParams() {
        if (!this.containsKey("getSystemParams")) {
            this.reloadSystemParams();
        }
        return (RptParams)this.getObject("getSystemParams");
    }
}

