/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.toolkit.dbmono;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.eas.common.calc.IllegalExpressException;
import com.kingdee.eas.common.calc.express.ExpressAnalyzer;
import com.kingdee.eas.fi.gl.common.toolkit.dbmono.SQLEditor;
import com.kingdee.eas.framework.report.CommRptBaseFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.EASResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class SqlFrame
extends JInternalFrame {
    private static final Logger logger = Logger.getLogger(SqlFrame.class);
    public static int NO = 0;
    BorderLayout borderLayout1 = new BorderLayout();
    JSplitPane jSplitPane1 = new JSplitPane();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JScrollPane jScrollPane2 = new JScrollPane();
    SQLEditor jtpSql = new SQLEditor();
    JPanel msgPanel = new JPanel();
    private KDTable tbl = new KDTable();
    private JTextArea jta = new JTextArea();

    public SqlFrame() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        this.init();
    }

    private void init() {
        this.setVisible(true);
        this.setResizable(true);
        this.setSize(640, 480);
        this.jSplitPane1.setDividerLocation(400);
        this.jtpSql.addKeyListener(new KeyAdapter(){
            private int tag = 0;

            @Override
            public void keyPressed(KeyEvent e) {
                int code = e.getKeyCode();
                String sql = SqlFrame.this.jtpSql.getExecuteSql();
                switch (code) {
                    case 119: {
                        SqlFrame.this.executeSql(sql);
                        break;
                    }
                    case 120: {
                        SqlFrame.this.switchView(++this.tag);
                        break;
                    }
                    case 116: {
                        SqlFrame.this.cal(sql);
                        break;
                    }
                    case 115: {
                        SqlFrame.this.transSql(sql);
                    }
                }
            }
        });
        this.tbl.getDataRequestManager().setDataRequestMode(0);
        this.tbl.getSelectManager().setSelectMode(10);
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"401_SqlFrame"));
        sb.append(++NO);
        this.setTitle(sb.toString());
    }

    private void switchView(int tag) {
        int m = tag % 4;
        boolean MARGIN = false;
        switch (m) {
            case 0: 
            case 2: {
                this.jSplitPane1.setDividerLocation(this.jSplitPane1.getHeight() / 2);
                break;
            }
            case 1: {
                this.jSplitPane1.setDividerLocation(0);
                break;
            }
            case 3: {
                int l = this.jSplitPane1.getHeight() - 0;
                if (l <= 0) break;
                this.jSplitPane1.setDividerLocation(l);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SqlFrame.this.jtpSql.requestFocus();
            }
        });
    }

    private String getDialectHeader(String typeName) {
        String space = "                            ";
        StringBuffer sb = new StringBuffer();
        sb.append("+----------------------+\r\n");
        sb.append("|     ").append(typeName).append("                            ".substring(0, 17 - typeName.length()));
        sb.append("|");
        sb.append("\r\n+----------------------+\r\n");
        return sb.toString();
    }

    private void transSql(String express) {
        this.setTitle(express);
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(this.getDialectHeader("MS SQL Server"));
            sql.append(TransUtil.Translate((String)express, (int)3));
            sql.append("\r\n\r\n");
            sql.append(this.getDialectHeader("Oracle"));
            sql.append(TransUtil.Translate((String)express, (int)2));
            sql.append("\r\n\r\n");
            sql.append(this.getDialectHeader("DB2_UDB"));
            sql.append(TransUtil.Translate((String)express, (int)1));
            this.showResult(sql.toString(), false);
        }
        catch (Exception e) {
            this.showResult(e, true);
        }
    }

    private void cal(String express) {
        this.setTitle(express);
        try {
            if (express.toLowerCase().trim().equals("calc")) {
                this.showResult(ExpressAnalyzer.getUsage(), false);
            } else {
                double value = new ExpressAnalyzer().calculate(express);
                BigDecimal bd = new BigDecimal(String.valueOf(value));
                StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"402_SqlFrame"));
                sb.append(bd).append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"403_SqlFrame"));
                sb.append(value);
                this.showResult(sb.toString(), false);
            }
        }
        catch (IllegalExpressException ex) {
            this.showResult((Object)ex, true);
        }
    }

    private void executeSql(String sql) {
        try {
            String method = null;
            String _sql = sql.trim();
            if (_sql.length() == 0) {
                return;
            }
            this.setTitle(sql);
            boolean useDialet = false;
            if (_sql.charAt(0) == '@') {
                useDialet = true;
                _sql = _sql.substring(1).trim();
            }
            method = _sql.toLowerCase().startsWith("select") ? "executeQuery" : "executeUpdate";
            if (useDialet) {
                _sql = "/*dialect*/" + _sql;
            }
            ICommRptBase rb = CommRptBaseFactory.getRemoteInstance();
            Object obj = rb.invoke("com.kingdee.eas.fi.gl.common.toolkit.dbmono.SqlExecutor$" + method, new Object[]{_sql}, new Class[]{Object.class}, true);
            this.showResult(obj, false);
        }
        catch (Exception e) {
            this.showResult(e, true);
        }
    }

    private void showResult(Object obj, boolean error) {
        this.msgPanel.removeAll();
        this.jta.setForeground(error ? Color.RED : Color.BLACK);
        if (obj instanceof RptRowSet) {
            RptRowSet rs = (RptRowSet)obj;
            this.msgPanel.add((Component)this.tbl, "Center");
            this.tbl.checkParsed();
            this.tbl.removeRows();
            this.tbl.removeColumns();
            int n = rs.getColumnCount();
            for (int i = 0; i < n; ++i) {
                IColumn col = this.tbl.addColumn();
                col.setWidth(100);
            }
            IRow row = this.tbl.addHeadRow();
            int n2 = rs.getColumnCount();
            for (int i = 0; i < n2; ++i) {
                row.getCell(i).setValue((Object)rs.getColumnName(i));
            }
            rs.reset();
            KDTableUtil.insertRows((RptRowSet)rs, (int)0, (KDTable)this.tbl);
        } else if (obj instanceof Exception) {
            StringWriter sw = new StringWriter();
            ((Exception)obj).printStackTrace(new PrintWriter(sw));
            StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"404_SqlFrame"));
            sb.append(((Exception)obj).getMessage());
            sb.append(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"405_SqlFrame"));
            sb.append(sw.toString());
            this.showResult(sb.toString(), true);
        } else {
            this.msgPanel.add((Component)this.jta, "Center");
            this.jta.setText(String.valueOf(obj));
            this.jta.setCaretPosition(0);
        }
        this.msgPanel.updateUI();
    }

    void jbInit() throws Exception {
        this.setClosable(true);
        this.setIcon(false);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setMaximum(false);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setDividerSize(5);
        this.jPanel1.setLayout(this.borderLayout2);
        this.jPanel2.setLayout(this.borderLayout3);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jSplitPane1.add((Component)this.jPanel1, "top");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jtpSql, null);
        this.jSplitPane1.add((Component)this.jPanel2, "bottom");
        this.jPanel2.add((Component)this.jScrollPane2, "Center");
        this.jScrollPane2.getViewport().add((Component)this.msgPanel, null);
        this.msgPanel.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(200);
    }

    @Override
    public void addKeyListener(KeyListener l) {
        this.jtpSql.addKeyListener(l);
    }

    public boolean close() {
        StringBuffer sb = new StringBuffer(EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"407_SqlFrame"));
        sb.append(this.getTitle());
        if (JOptionPane.showConfirmDialog(this, EASResource.getString((String)"com.kingdee.eas.fi.gl.FIAutoGenerateResource", (String)"406_SqlFrame"), sb.toString(), 0, 1) == 0) {
            this.dispose();
            return true;
        }
        return false;
    }
}

