/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.common.toolkit.res;

import com.kingdee.eas.fi.gl.common.toolkit.res.CNItem;
import com.kingdee.eas.fi.gl.common.toolkit.res.ItemEntity;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CNScanner {
    private static final Logger logger = Logger.getLogger(CNScanner.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static Map xmlFormatCache = new HashMap();

    private static String maskXMLFormat(String key) {
        if (key == null) {
            return null;
        }
        String v = (String)xmlFormatCache.get(key);
        if (v == null) {
            v = key.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
            xmlFormatCache.put(key, v);
        }
        return v;
    }

    private static String getFileName(String value) {
        String f = value.replace('\\', '/');
        int i = f.lastIndexOf(47);
        if (i >= 0) {
            return f.substring(i + 1);
        }
        return value;
    }

    private static void dumpCNItem(CNItem ci, int no, PrintWriter pw) {
        pw.println("[" + no + "] " + ci.getFile() + " (" + ci.getItemCount() + ')');
        int m = ci.getItemCount();
        for (int i = 0; i < m; ++i) {
            ItemEntity ie = ci.getItem(i);
            pw.println("\t" + (i + 1) + " \t" + ie.toString2());
        }
        pw.flush();
    }

    private static boolean isCN(char ch, boolean withPreCN) {
        boolean b;
        boolean bl = b = ch >= '\u4e00' && ch <= '\u9fa5' || "\uff01\uff0c\u3002\uff1f\uff1a\u201c\u201d\u2018\u2019\uff0b\uff0d\u00d7\u00f7\u3001\u3010\u3011\u300e\u300f\uff5e".indexOf(ch) != -1;
        if (!b && withPreCN) {
            return ",.:;!?-_ \u3000".indexOf(ch) != -1;
        }
        return b;
    }
}

