/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.app;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.AccountAgeFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.GLAcctAgeNewUtils;
import com.kingdee.eas.fi.gl.app.QueryAgeType;
import com.kingdee.eas.fi.gl.cslacct.ParamValidatorException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class GlAccountAgeWebService {
    private static Logger logger = Logger.getLogger((String)GlAccountAgeWebService.class.getClass().getName());
    private String resource = "com.kingdee.eas.fi.gl.WebServiceResource";
    private Map<String, PeriodInfo> periodCache = new HashMap<String, PeriodInfo>();
    private Map<String, PeriodInfo> prePeriodCache = new HashMap<String, PeriodInfo>();
    private Map<String, Map<Map, String[]>> asstItemsCache = new HashMap<String, Map<Map, String[]>>();
    private CompanyOrgUnitCollection companys = null;
    private CurrencyInfo currency = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List queryAge(Context ctx, String paramJson) throws Exception {
        String errorMsg = this.validatorParam(ctx, paramJson);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            throw new ParamValidatorException(errorMsg);
        }
        Map ageParam = this.buildAgeParam(ctx, (Map)JSON.parseObject((String)paramJson, Map.class));
        String periodNumber = (String)ageParam.get("periodNumber");
        String[] accountNumbers = (String[])ageParam.get("accountNumbers");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            for (int i = 0; i < this.companys.size(); ++i) {
                CompanyOrgUnitInfo companyOrgUnitInfo = this.companys.get(i);
                String companyId = companyOrgUnitInfo.getId().toString();
                if (!this.isAllowCussent(ctx, companyId)) continue;
                PeriodInfo periodInfo = this.getCachePeriod(ctx, companyOrgUnitInfo.getAccountPeriodType().getId().toString(), periodNumber);
                if (periodInfo == null) {
                    logger.error((Object)("Company: " + companyOrgUnitInfo.getNumber() + " no period:" + periodNumber));
                    continue;
                }
                PeriodInfo acPeriod = this.getAcPeriod(ctx, companyId);
                if (periodInfo.getNumber() < acPeriod.getNumber()) {
                    logger.error((Object)("company: " + companyOrgUnitInfo.getNumber() + " period:" + periodInfo.getNumber() + " before Ac start period:" + acPeriod.getNumber()));
                    continue;
                }
                ageParam.put("endDate", periodInfo.getEndDate());
                ageParam.put("adjExchDate", periodInfo.getEndDate());
                String accountTableId = companyOrgUnitInfo.getAccountTable().getId().toString();
                AccountViewCollection acAccountViews = this.getAcAccountViews(ctx, companyId, accountTableId, accountNumbers);
                for (int j = 0; j < acAccountViews.size(); ++j) {
                    AccountViewInfo accountViewInfo = acAccountViews.get(j);
                    if (accountViewInfo.getCAA() == null || accountViewInfo.getCAA().getId() == null) continue;
                    List<AccountChangeInfo> asstItemsList = this.getCacheAsstItems(ctx, companyId, periodInfo, acPeriod, accountViewInfo);
                    for (AccountChangeInfo accountChangeInfo : asstItemsList) {
                        Map<String, Object> ageResult;
                        periodInfo = accountChangeInfo.getPeriodInfo();
                        if (periodInfo.getNumber() < acPeriod.getNumber() || (ageResult = this.getAgeResult(ctx, ageParam, periodNumber, companyOrgUnitInfo, periodInfo, companyId, accountTableId, accountViewInfo, accountChangeInfo.getAsstItem())) == null) continue;
                        result.add(ageResult);
                    }
                }
            }
        }
        finally {
            Map<String, String> adjExchTmpTable = GLAcctAgeNewUtils.adjExchTmpTableCache.get();
            if (adjExchTmpTable.size() > 0) {
                TempTablePool iPool = TempTablePool.getInstance((Context)ctx);
                for (Map.Entry<String, String> entry : adjExchTmpTable.entrySet()) {
                    if (StringUtils.isEmpty((String)entry.getValue())) continue;
                    iPool.releaseTable(entry.getValue());
                }
                GLAcctAgeNewUtils.adjExchTmpTableCache.remove();
            }
            GLAcctAgeNewUtils.clearAllDataCache();
            GLAcctAgeNewUtils.clearAdjExchDataCache();
            GLAcctAgeNewUtils.clearAllCurrencyCache();
        }
        return result;
    }

    private Map<String, Object> getAgeResult(Context ctx, Map ageParam, String periodNumber, CompanyOrgUnitInfo companyOrgUnitInfo, PeriodInfo periodInfo, String companyId, String accountTableId, AccountViewInfo accountViewInfo, Map<Map, String[]> asstItems) throws BOSException, EASBizException {
        this.replenishAgeParam(ctx, ageParam, companyId, accountTableId, periodInfo, accountViewInfo, asstItems);
        ArrayList ageResult = AccountAgeFacadeFactory.getLocalInstance(ctx).queryAge(ageParam);
        return this.dealResult(companyOrgUnitInfo, accountViewInfo, asstItems.keySet(), periodNumber, ageResult);
    }

    protected String validatorParam(Context ctx, String paramJson) throws Exception {
        String errorMsg = this.checkParam(ctx, paramJson);
        if (!StringUtils.isEmpty((String)errorMsg)) {
            return errorMsg;
        }
        StringBuilder validatorMsg = new StringBuilder();
        Map paramMap = (Map)JSON.parseObject((String)paramJson, Map.class);
        String currencyNumber = (String)paramMap.get("currency");
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            this.currency = this.getCurrency(ctx, currencyNumber);
        }
        String entity = (String)paramMap.get("entity");
        this.companys = this.getCompnays(ctx, entity);
        if (this.companys == null || this.companys.size() <= 0) {
            validatorMsg.append(ResourceBase.getString((String)this.resource, (String)"notFindCommany", (Locale)ctx.getLocale())).append(entity).append(";");
        }
        return validatorMsg.toString();
    }

    protected Map buildAgeParam(Context ctx, Map param) throws Exception {
        String account = (String)param.get("account");
        String[] accountNumbers = StringUtils.isEmpty((String)account) ? new String[]{} : account.split(";");
        String periodNumber = (String)param.get("period");
        int cancelby = Integer.valueOf((String)param.get("cancelby"));
        int createby = Integer.valueOf((String)param.get("createby"));
        HashMap<String, Object> ageParam = new HashMap<String, Object>();
        ageParam.put("queryAgeType", (Object)QueryAgeType.WEBSERVICE_AGE_DAYS);
        ageParam.put("includeVerifyVch", cancelby == 2);
        ageParam.put("dateType", createby);
        ageParam.put("accountNumbers", accountNumbers);
        ageParam.put("periodNumber", periodNumber);
        ageParam.put("currencyid", this.currency == null ? "AllCurrency" : this.currency.getId().toString());
        ageParam.put("hmItems", new HashMap());
        ageParam.put("endDate", new Date());
        ageParam.put("historyDate", new Date());
        ageParam.put("days", new int[]{30, 60, 90});
        ageParam.put("undays", new int[0]);
        ageParam.put("includeUnPosted", true);
        ageParam.put("isShowUmexpired", false);
        ageParam.put("includeInit", true);
        ageParam.put("accountFrom", null);
        ageParam.put("accountTo", null);
        ageParam.put("isBizCode", false);
        ageParam.put("indexType", 0);
        return ageParam;
    }

    private void replenishAgeParam(Context ctx, Map ageParam, String companyId, String accountTableId, PeriodInfo periodInfo, AccountViewInfo account, Map<Map, String[]> hmItems) throws BOSException, EASBizException {
        ageParam.put("companyid", companyId);
        ageParam.put("curCompanyid", companyId);
        ageParam.put("accountTable", accountTableId);
        ageParam.put("historyDate", periodInfo.getEndDate());
        ageParam.put("accountid", this.getAccountIds(account.getId().toString()));
        ageParam.put("hmItems", hmItems);
    }

    private Map<Map, String[]> getasstItems(Context ctx, String caaId) throws BOSException, EASBizException {
        ArrayList<HashMap<String, Object>> asstItems = this.getAsstItems(ctx, caaId);
        String[] numbers = new String[2];
        HashMap<Map, String[]> hmItems = new HashMap<Map, String[]>();
        for (Map map : asstItems) {
            hmItems.put(map, numbers);
        }
        return hmItems;
    }

    private List<AccountChangeInfo> getCacheAsstItems(Context ctx, String companyId, PeriodInfo periodInfo, PeriodInfo acPeriodInfo, AccountViewInfo account) throws BOSException, EASBizException {
        HashSet<String> accountIds = new HashSet<String>(1);
        accountIds.add(account.getId().toString());
        List<AccountChangeInfo> accountChangeInfos = this.getAccountChangeInfoByPeriodRange(ctx, accountIds, acPeriodInfo, periodInfo);
        if (accountChangeInfos.isEmpty()) {
            accountChangeInfos.add(new AccountChangeInfo(account.getId().toString(), account.getCAA().getId().toString(), periodInfo));
        }
        for (AccountChangeInfo accountChangeInfo : accountChangeInfos) {
            Map<Map, String[]> asstItems = null;
            String caaId = accountChangeInfo.getCaaId();
            if (this.asstItemsCache.containsKey(caaId)) {
                asstItems = this.asstItemsCache.get(caaId);
            } else {
                asstItems = this.getasstItems(ctx, caaId);
                this.asstItemsCache.put(caaId, asstItems);
            }
            accountChangeInfo.setAsstItem(asstItems);
        }
        return accountChangeInfos;
    }

    private ArrayList<HashMap<String, Object>> getAsstItems(Context ctx, String caaId) throws BOSException {
        ArrayList<HashMap<String, Object>> arrayList;
        Locale loc = ctx.getLocale();
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct rel.fid relid,rel.Fseq seq,item.fid id,item.fisforcompany fisforcompany,item.fnumber fnumber,item.fdefaultqueryname queryname,item.frealtiondataobject tablename, item.fassthgattribute propname, item.fmappingfieldname fieldname,item.fname_");
        sql.append(loc);
        sql.append(" fname, item.FGLAsstActTypeGrpID,item.FUseLongNumber useLongNUmber,rel.fasstaccountid caaid ").append(" from T_BD_AsstActGroupDetail rel ").append(" inner join T_BD_AsstActType item on item.fid = rel.fasstacttypeid");
        sql.append(" where rel.fasstaccountid = ?");
        ArrayList<HashMap<String, Object>> crossItems = new ArrayList<HashMap<String, Object>>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = EJBFactory.getConnection((Context)ctx);
            ps = con.prepareStatement(sql.toString());
            ps.setString(1, caaId);
            rs = ps.executeQuery();
            HashSet<String> hmCount = new HashSet<String>();
            while (rs.next()) {
                String id = rs.getString("id");
                String caaid = rs.getString("caaid");
                if (hmCount.contains(id)) continue;
                HashMap<String, Object> item = new HashMap<String, Object>();
                item.put("id", id);
                item.put("relid", rs.getString("relid"));
                item.put("seq", rs.getInt("seq") - 1);
                item.put("isforcompany", rs.getBoolean("fisforcompany"));
                item.put("number", rs.getString("fnumber"));
                item.put("name", rs.getString("fname"));
                item.put("queryname", rs.getString("queryname"));
                item.put("propname", rs.getString("propname"));
                item.put("fieldname", rs.getString("fieldname"));
                item.put("tablename", rs.getString("tablename"));
                item.put("FGLAsstActTypeGrpID", rs.getString("FGLAsstActTypeGrpID"));
                item.put("useLongNUmber", rs.getBoolean("useLongNUmber"));
                item.put("caaid", caaid);
                crossItems.add(item);
                hmCount.add(id);
            }
            arrayList = crossItems;
        }
        catch (SQLException sqle) {
            try {
                throw new BOSException((Throwable)sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)con);
        return arrayList;
    }

    private List<AccountChangeInfo> getAccountChangeInfoByPeriodRange(Context ctx, Set<String> accountIds, PeriodInfo startPeriodInfo, PeriodInfo endPeriodInfo) throws BOSException, EASBizException {
        ArrayList<AccountChangeInfo> arrayList;
        ArrayList<AccountChangeInfo> accountChangeInfoList = new ArrayList<AccountChangeInfo>();
        if (accountIds == null || accountIds.isEmpty() || startPeriodInfo == null || endPeriodInfo == null) {
            return accountChangeInfoList;
        }
        int startPeriod = startPeriodInfo.getNumber();
        int endPeriod = endPeriodInfo.getNumber();
        if (startPeriod <= 0 || endPeriod <= 0 || endPeriod < startPeriod) {
            return accountChangeInfoList;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select \n");
            sql.append("    c.FAccountID, c.FBeforeID,c.FAfterID, p.fid periodId \n");
            sql.append("from T_BD_AsstAccountChange c \n");
            sql.append("join T_BD_Period p on p.FID = c.FPeriodID \n");
            if (accountIds.size() == 1) {
                sql.append("where c.FAccountID = ? \n");
            } else {
                sql.append("where c.FAccountID in ( \n");
                for (String accountId : accountIds) {
                    sql.append("'" + accountId + "',");
                }
                sql.deleteCharAt(sql.length() - 1);
                sql.append(") \n");
            }
            sql.append(" and p.FNumber >= ? and p.FNumber <= ?\n");
            sql.append("order by c.FAccountID, p.FNumber asc \n");
            int index = 1;
            pstmt = conn.prepareStatement(sql.toString());
            if (accountIds.size() == 1) {
                pstmt.setString(index++, accountIds.iterator().next().toString());
            }
            pstmt.setInt(index++, startPeriod);
            pstmt.setInt(index++, endPeriod);
            rs = pstmt.executeQuery();
            HashMap<String, String> afterCaaMap = new HashMap<String, String>();
            while (rs.next()) {
                String accountId = rs.getString("FAccountID");
                String beforeId = rs.getString("FBeforeID");
                String afterId = rs.getString("FAfterID");
                String periodId = rs.getString("periodId");
                afterCaaMap.put(accountId, afterId);
                PeriodInfo prePeriodInfo = null;
                if (this.prePeriodCache.get(periodId) != null) {
                    prePeriodInfo = this.prePeriodCache.get(periodId);
                } else {
                    prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (IObjectPK)new ObjectUuidPK(periodId));
                    this.prePeriodCache.put(periodId, prePeriodInfo);
                }
                if (beforeId == null || prePeriodInfo.getNumber() < startPeriodInfo.getNumber()) continue;
                accountChangeInfoList.add(new AccountChangeInfo(accountId, beforeId, prePeriodInfo));
            }
            for (Map.Entry afterCaaEntry : afterCaaMap.entrySet()) {
                String accountId = (String)afterCaaEntry.getKey();
                String caaId = (String)afterCaaEntry.getValue();
                accountChangeInfoList.add(new AccountChangeInfo(accountId, caaId, endPeriodInfo));
            }
            arrayList = accountChangeInfoList;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"SQL ERROR", (Throwable)e);
                throw new BOSException("SQL ERROR", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return arrayList;
    }

    private Map<String, Object> dealResult(CompanyOrgUnitInfo company, AccountViewInfo account, Set<Map> asstItems, String periodNumber, List ageResult) {
        if (ageResult == null) {
            return null;
        }
        HashMap<String, Object> resultData = new HashMap<String, Object>();
        resultData.put("companyNumber", company.getNumber());
        resultData.put("companyName", company.getName());
        resultData.put("accountNumber", account.getNumber());
        resultData.put("accountName", account.getName());
        resultData.put("periodNumber", periodNumber);
        resultData.put("asstNum", asstItems.size());
        for (Map asstItem : asstItems) {
            int seq = (Integer)asstItem.get("seq");
            resultData.put("asstActTypeNumber" + seq, asstItem.get("number"));
            resultData.put("asstActTypeName" + seq, asstItem.get("name"));
        }
        ArrayList balList = new ArrayList(ageResult.size());
        for (Map data : ageResult) {
            HashMap balMap = new HashMap();
            for (Map asstItem : asstItems) {
                int seq = (Integer)asstItem.get("seq");
                String numberKey = "T" + seq + "fnumber";
                String nameKey = "T" + seq + "fname";
                balMap.put("asstActNumber" + seq, data.get(numberKey));
                balMap.put("asstActName" + seq, data.get(nameKey));
            }
            balMap.put("currencyNumber", data.get("currencyNumber"));
            balMap.put("currencyName", data.get("currencyName"));
            balMap.put("amt", data.get("sumamt"));
            balMap.put("days", data.get("days"));
            balList.add(balMap);
        }
        resultData.put("bal", balList);
        return resultData;
    }

    private String getAccountIds(String accountId) {
        if (accountId == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("'").append(accountId).append("'");
        return sb.toString();
    }

    private PeriodInfo getCachePeriod(Context ctx, String periodTypeID, String periodNumber) throws BOSException {
        String key = periodTypeID + periodNumber;
        PeriodInfo periodInfo = null;
        if (this.periodCache.containsKey(key)) {
            periodInfo = this.periodCache.get(key);
        } else {
            periodInfo = this.getPeriodInfo(ctx, periodTypeID, periodNumber);
            this.periodCache.put(key, periodInfo);
        }
        return periodInfo;
    }

    private PeriodInfo getPeriodInfo(Context ctx, String periodTypeID, String periodNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("endDate");
        view.getSelector().add("periodType.id");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeID));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)periodNumber, CompareType.LESS_EQUALS));
        view.setFilter(filterInfo);
        SorterItemCollection sorterCollection = view.getSorter();
        SorterItemInfo numberSortInfo = new SorterItemInfo("number");
        numberSortInfo.setSortType(SortType.DESCEND);
        sorterCollection.add(numberSortInfo);
        view.setTopCount(1);
        PeriodCollection periodCollection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
        return periodCollection != null && periodCollection.size() > 0 ? periodCollection.get(0) : null;
    }

    private AccountViewCollection getAcAccountViews(Context ctx, String companyId, String accountTableId, String[] accountNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("CAA.id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)companyId));
        filterInfo.getFilterItems().add(new FilterItemInfo("accountTableID.id", (Object)accountTableId));
        if (accountNumbers != null && accountNumbers.length > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(Arrays.asList(accountNumbers)), CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("AC", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1));
        view.setFilter(filterInfo);
        return AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
    }

    private CompanyOrgUnitCollection getCompnays(Context ctx, String entity) throws BOSException {
        String[] companyNumbers = entity.split(";");
        return this.getCompanyOrgUnitCollection(ctx, companyNumbers);
    }

    private CompanyOrgUnitCollection getCompanyOrgUnitCollection(Context ctx, String[] companyNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.getSelector().add("accountTable.id");
        view.getSelector().add("accountPeriodType.id");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(Arrays.asList(companyNumbers)), CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1));
        view.setFilter(filterInfo);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        return companyOrgUnitCollection;
    }

    private CurrencyInfo getCurrency(Context ctx, String currencyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber, CompareType.EQUALS));
        view.setFilter(filterInfo);
        CurrencyCollection currencyCollection = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        return currencyCollection != null && currencyCollection.size() > 0 ? currencyCollection.get(0) : null;
    }

    private String checkParam(Context ctx, String paramJson) {
        if (StringUtils.isEmpty((String)paramJson)) {
            return ResourceBase.getString((String)this.resource, (String)"paramIsNull", (Locale)ctx.getLocale());
        }
        logger.error((Object)("webservice queryAge param json:" + paramJson));
        StringBuilder errorMsg = new StringBuilder();
        Map param = (Map)JSON.parseObject((String)paramJson, Map.class);
        if (StringUtils.isEmpty((String)((String)param.get("entity")))) {
            errorMsg.append(ResourceBase.getString((String)this.resource, (String)"inputCompany", (Locale)ctx.getLocale())).append("(entity);");
        } else {
            String entity = (String)param.get("entity");
            if (entity.split(";").length > 5) {
                errorMsg.append(ResourceBase.getString((String)this.resource, (String)"companyLimitNums", (Locale)ctx.getLocale(), (Object[])new String[]{"5"})).append(";");
            }
        }
        if (StringUtils.isEmpty((String)((String)param.get("period")))) {
            errorMsg.append(ResourceBase.getString((String)this.resource, (String)"inputPeriod", (Locale)ctx.getLocale())).append("(period);");
        } else {
            String period = (String)param.get("period");
            if (!this.isDigit(period)) {
                errorMsg.append(ResourceBase.getString((String)this.resource, (String)"periodIllegal", (Locale)ctx.getLocale())).append(":").append(period).append(";");
            }
        }
        if (StringUtils.isEmpty((String)((String)param.get("cancelby")))) {
            errorMsg.append(ResourceBase.getString((String)this.resource, (String)"cancelby", (Locale)ctx.getLocale())).append("(cancelby);");
        } else {
            String cancelBy = (String)param.get("cancelby");
            if (!cancelBy.matches("^1|2$")) {
                errorMsg.append(ResourceBase.getString((String)this.resource, (String)"cancelByValue", (Locale)ctx.getLocale()));
            }
        }
        if (StringUtils.isEmpty((String)((String)param.get("createby")))) {
            errorMsg.append(ResourceBase.getString((String)this.resource, (String)"createby", (Locale)ctx.getLocale())).append("(createby);");
        } else {
            String createBy = (String)param.get("createby");
            if (!createBy.matches("^0|1$")) {
                errorMsg.append(ResourceBase.getString((String)this.resource, (String)"createByValue", (Locale)ctx.getLocale())).append(";");
            }
        }
        return errorMsg.toString();
    }

    private boolean isDigit(String s) {
        return s.matches("^\\d+$");
    }

    public boolean isAllowCussent(Context ctx, String companyId) throws EASBizException, BOSException {
        Object allowCussentObj = GlUtils.getParamByKey(ctx, companyId, "GL_028");
        return allowCussentObj == null ? false : Boolean.valueOf(allowCussentObj.toString());
    }

    public PeriodInfo getAcPeriod(Context ctx, String companyId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("startPeriod.number"));
        selectors.add(new SelectorItemInfo("acPeriod.number"));
        viewInfo.setSelector(selectors);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)6));
        viewInfo.setFilter(filter);
        SystemStatusCtrolCollection ctrols = SystemStatusCtrolFactory.getLocalInstance((Context)ctx).getSystemStatusCtrolCollection(viewInfo);
        SystemStatusCtrolInfo systemStatusCtrolInfo = ctrols.get(0);
        PeriodInfo startPeriod = systemStatusCtrolInfo.getStartPeriod();
        PeriodInfo acPeriod = systemStatusCtrolInfo.getAcPeriod();
        if (acPeriod == null) {
            acPeriod = startPeriod;
        }
        return acPeriod;
    }

    private class AccountChangeInfo {
        private String accountId;
        private String caaId;
        private PeriodInfo periodInfo;
        private Map<Map, String[]> asstItem = null;

        public AccountChangeInfo(String accountId, String caaId, PeriodInfo periodInfo) {
            this.accountId = accountId;
            this.caaId = caaId;
            this.periodInfo = periodInfo;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public String getCaaId() {
            return this.caaId;
        }

        public void setCaaId(String caaId) {
            this.caaId = caaId;
        }

        public PeriodInfo getPeriodInfo() {
            return this.periodInfo;
        }

        public void setPeriodInfo(PeriodInfo periodInfo) {
            this.periodInfo = periodInfo;
        }

        public Map<Map, String[]> getAsstItem() {
            return this.asstItem;
        }

        public void setAsstItem(Map<Map, String[]> asstItem) {
            this.asstItem = asstItem;
        }
    }
}

