/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.cslacct.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.EnactmentServiceProxy;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.gl.GLException;
import com.kingdee.eas.fi.gl.GLPeriodEndFacadeFactory;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.IGLPeriodEndFacade;
import com.kingdee.eas.fi.gl.ReportException;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fi.gl.cslacct.IRequisition;
import com.kingdee.eas.fi.gl.cslacct.IRequisitionCheck;
import com.kingdee.eas.fi.gl.cslacct.RequisitionCheckFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionException;
import com.kingdee.eas.fi.gl.cslacct.RequisitionFactory;
import com.kingdee.eas.fi.gl.cslacct.RequisitionInfo;
import com.kingdee.eas.fi.gl.cslacct.app.AbstractRequisitionControllerBean;
import com.kingdee.eas.fi.gl.cslacct.app.ServerHelper;
import com.kingdee.eas.fi.gl.cslacct.util.Helper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class RequisitionControllerBean
extends AbstractRequisitionControllerBean {
    private static final String PERMISSION_ITEMNAME_VOUCHERMAINTAIN = "gl_voucher_add";
    public static String functionName = "DAP-Req";
    public static int batchCount = 20;
    private String resource = "com.kingdee.eas.fi.gl.GLRes";

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return this.store(ctx, model);
    }

    @Override
    protected boolean _isChecked(Context ctx, IObjectPK requisition) throws BOSException {
        return this.isReqChecked(ctx, requisition);
    }

    @Override
    protected BOSUuid[] _getSendUsers(Context ctx, IObjectPK requisition) throws BOSException {
        return this.get_SendUsers(ctx, requisition);
    }

    @Override
    protected String _createReqNumber(Context ctx, IObjectValue requisition, String orgId) throws BOSException, EASBizException {
        return this.create_ReqNumber(ctx, requisition, orgId);
    }

    @Override
    protected boolean _existsNonChecked(Context ctx, String companyID, Date startDate, Date endDate) throws BOSException {
        return this.exists_NonCheckedNew(ctx, companyID);
    }

    private boolean exists_NonCheckedNew(Context ctx, String companyID) throws BOSException {
        boolean isExists = false;
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)companyID));
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        try {
            String value = pc.getParamValue((IObjectPK)comPK, "GL_026");
            int isAll = Integer.valueOf(value);
            if (isAll == 2) {
                return isExists;
            }
            String noticeTypeValue = pc.getParamValue((IObjectPK)comPK, "GL_121");
            int intValue = Integer.valueOf(noticeTypeValue);
            PeriodInfo period = GlUtils.getCurrentPeriod(ctx, companyID);
            if (isAll == 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("select 1 from T_CSL_Requisition req \r\n");
                sql.append("inner join T_CSL_RequisitionEntry b on b.FRequisitionID = req.fid \r\n");
                sql.append("inner join T_GL_VOUCHERASSISTRECORD vss on vss.fid = b.FASSISTRECORDID \r\n");
                sql.append("inner join t_gl_voucher vo on req.FVoucherID = vo.fid \r\n");
                sql.append("inner join t_bd_period period on vo.FPeriodID = period.FID \r\n");
                sql.append("where b.FStatus <=1 and req.FIsAvoidCheck = 0  and period.fid=? \r\n");
                Object[] params = null;
                if (intValue == 1) {
                    sql.append(" and (req.FSRCCOMPANYID = ? or req.FTARGCOMPANYID = ? )");
                    params = new Object[]{period.getId().toString(), comPK.toString(), comPK.toString()};
                } else {
                    sql.append(" and req.FSRCCOMPANYID = ?");
                    params = new Object[]{period.getId().toString(), comPK.toString()};
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                if (rs.next()) {
                    isExists = true;
                }
            } else if (isAll == 1) {
                StringBuffer sql = new StringBuffer();
                sql.append("select 1 from T_CSL_Requisition req \r\n");
                sql.append("inner join T_CSL_RequisitionEntry b on b.FRequisitionID = req.fid \r\n");
                sql.append("inner join T_GL_VOUCHERASSISTRECORD vss on vss.fid = b.FASSISTRECORDID \r\n");
                sql.append("inner join t_gl_voucher vo on req.FVoucherID = vo.fid \r\n");
                sql.append("inner join t_bd_period period on vo.FPeriodID = period.FID \r\n");
                sql.append("where b.FStatus <=1 and req.FIsAvoidCheck = 0 and period.fnumber<=? \r\n");
                Object[] params = null;
                if (intValue == 1) {
                    sql.append(" and (req.FSRCCOMPANYID = ? or req.FTARGCOMPANYID = ? )");
                    params = new Object[]{period.getPeriodYear() * 100 + period.getPeriodNumber(), comPK.toString(), comPK.toString()};
                } else {
                    sql.append(" and req.FSRCCOMPANYID = ?");
                    params = new Object[]{period.getPeriodYear() * 100 + period.getPeriodNumber(), comPK.toString()};
                }
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                if (rs.next()) {
                    isExists = true;
                }
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isExists;
    }

    private boolean isReqChecked(Context ctx, IObjectPK requisition) throws BOSException {
        boolean isChecked = true;
        if (requisition != null) {
            IRowSet rs;
            block5: {
                Object[] v = new Object[]{requisition.toString(), new Integer(1)};
                rs = null;
                try {
                    rs = DbUtil.executeQuery((Context)ctx, (String)"Select top 1 b.FID From T_CSL_Requisition a,\t  T_CSL_RequisitionEntry b Where a.FID = b.FRequisitionID and a.FID = ? And b.FStatus = ?", (Object[])v);
                    if (rs == null || !rs.next()) break block5;
                    isChecked = false;
                }
                catch (SQLException e) {
                    try {
                        throw new SQLDataException(e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        return isChecked;
    }

    private BOSUuid[] get_SendUsers(Context ctx, IObjectPK requisition) throws BOSException {
        IRequisition i = RequisitionFactory.getLocalInstance(ctx);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("company.id"));
        RequisitionInfo req = null;
        BOSUuid[] ids = null;
        try {
            req = (RequisitionInfo)i.getValue(requisition, selectors);
            if (req != null && req.getCompany() != null) {
                String companyId = req.getCompany().getId().toString();
                IPermission ie = PermissionFactory.getLocalInstance((Context)ctx);
                Collection ls = ie.getAuthorizedUsers((IObjectPK)new ObjectStringPK(companyId), PERMISSION_ITEMNAME_VOUCHERMAINTAIN);
                if (ls != null && ls.size() != 0) {
                    String userId2 = null;
                    ids = new BOSUuid[ls.size()];
                    int index = 0;
                    for (String userId2 : ls) {
                        if (userId2 == null) continue;
                        ids[index++] = BOSUuid.read((String)userId2);
                    }
                }
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw e;
        }
        return ids;
    }

    private IObjectPK store(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RequisitionInfo req = (RequisitionInfo)model;
        Transaction tx = null;
        try {
            InitialContext initCtx = new InitialContext();
            TransactionManager txManager = (TransactionManager)initCtx.lookup("java:/TransactionManager");
            tx = txManager.getTransaction();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return super._submit(ctx, (IObjectValue)req);
    }

    private String create_ReqNumber(Context ctx, IObjectValue requisition, String orgId) throws BOSException, EASBizException {
        if (requisition == null) {
            return null;
        }
        String number = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (iCodingRuleManager.isExist(requisition, orgId)) {
            number = iCodingRuleManager.getNumber(requisition, orgId);
        } else {
            CompanyOrgUnitInfo rootOrg = ServerHelper.getRootOrgForRootCU(ctx);
            if (rootOrg != null && iCodingRuleManager.isExist(requisition, rootOrg.getId().toString())) {
                number = iCodingRuleManager.getNumber(requisition, rootOrg.getId().toString());
            } else {
                throw new RequisitionException(RequisitionException.REQNUMBERRULENOTEXISTS);
            }
        }
        IRequisition ie = RequisitionFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("srcCompany.id", (Object)orgId));
        if (ie.exists(filter)) {
            throw new RequisitionException(RequisitionException.REQNUMBEREXISTS);
        }
        return number;
    }

    private boolean exists_NonChecked(Context ctx, String companyID, Date startDate, Date endDate) throws BOSException {
        boolean isExists = false;
        ArrayList<Object> ps = new ArrayList<Object>();
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Select top 1 b.FID \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("From T_CSL_Requisition a, \t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t    T_CSL_RequisitionEntry b, \t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("\t    T_GL_Voucher c \t\t\t\t\t\t\t\t\t\t\t\t\t\r\n");
        strSQL.append("Where a.FID = b.FRequisitionID And a.FVoucherID = c.FID \t\t\t\t\r\n");
        if (companyID != null) {
            ps.add(companyID);
            ps.add(companyID);
            strSQL.append("And ( a.FTargCompanyID = ? or a.fsrccompanyid = ? )\t\t\t\t\r\n");
        }
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        String curCompanyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        ObjectUuidPK comPK = new ObjectUuidPK(BOSUuid.read((String)curCompanyID));
        hmParamIn.put("GL_026", comPK);
        boolean isAllowUnConfirm = true;
        try {
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
            isAllowUnConfirm = Boolean.valueOf(hmAllParam.get("GL_026").toString());
        }
        catch (EASBizException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (startDate != null && isAllowUnConfirm) {
            ps.add(Helper.getFilterDate(startDate, "startDate"));
            strSQL.append("And c.FBookedDate >= ? \t\t\t\t\t\t\r\n");
        }
        if (endDate != null) {
            ps.add(Helper.getFilterDate(endDate, "endDate"));
            strSQL.append("And c.FBookedDate <= ? \t\t\t\t\t\t\r\n");
        }
        ps.add(new Integer(1));
        strSQL.append("And b.FStatus <= ? \t\t\t\t\t\t\t\t\r\n");
        strSQL.append("And a.fsrccompanyid != a.FTargCompanyID           \r\n");
        if (!isAllowUnConfirm) {
            strSQL.append(" And a.FIsAvoidCheck = 0 ");
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])ps.toArray());
            if (rs != null && rs.next()) {
                isExists = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return isExists;
    }

    @Override
    protected void _updateBatch(Context ctx, ArrayList pkList, boolean isAvoidCheck) throws BOSException {
        if (pkList == null || pkList.size() <= 0) {
            return;
        }
        List<List> splitList = this.splitList(pkList);
        for (List list : splitList) {
            this.batchUpdate(ctx, list, isAvoidCheck);
        }
    }

    private void batchUpdate(Context ctx, List pkList, boolean isAvoidCheck) throws BOSException {
        StringBuilder sql = new StringBuilder();
        String sqlIn = this.getSqlIn(pkList);
        sql.append("select fnumber from T_CSL_Requisition where fid in(").append(sqlIn).append(")");
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])pkList.toArray());
        StringBuilder logDetail = new StringBuilder();
        try {
            while (executeQuery.next()) {
                String number = executeQuery.getString(1);
                logDetail.append(number).append(";");
            }
            if (logDetail.length() > 0) {
                logDetail.deleteCharAt(logDetail.length() - 1);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException("query requisition number exception", (Throwable)e);
        }
        IObjectPK logPK = null;
        logPK = isAvoidCheck ? LogUtil.beginLogWithDescription((Context)ctx, (String)"_updateBatch", (BOSObjectType)BOSObjectType.create((String)"7EB1A733"), null, (String)logDetail.toString(), (String)EASResource.getString((String)this.resource, (String)"cslRequisitionAvoidCheck")) : LogUtil.beginLogWithDescription((Context)ctx, (String)"_updateBatch", (BOSObjectType)BOSObjectType.create((String)"7EB1A733"), null, (String)logDetail.toString(), (String)EASResource.getString((String)this.resource, (String)"cslRequisitionCheck"));
        sql.setLength(0);
        sql.append(" update T_CSL_Requisition set FIsAvoidCheck=? where fid in (");
        Iterator it = pkList.iterator();
        while (it.hasNext()) {
            sql.append("'").append(it.next().toString()).append("',");
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        Object[] param = null;
        param = isAvoidCheck ? new String[]{"1"} : new String[]{"0"};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])param);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
    }

    private List<List> splitList(List list) {
        ArrayList<List> resultList = new ArrayList<List>();
        ArrayList<String> eList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (i % batchCount == 0) {
                eList = new ArrayList();
                resultList.add(eList);
            }
            eList.add((String)list.get(i));
        }
        return resultList;
    }

    private String getSqlIn(List pkList) {
        StringBuffer sql = new StringBuffer();
        Iterator iterator = pkList.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() == null) continue;
            sql.append("?,");
        }
        if (sql.length() > 0) {
            sql.deleteCharAt(sql.length() - 1);
        }
        return sql.toString();
    }

    @Override
    protected boolean _voucher(Context ctx, String id) throws BOSException, EASBizException {
        throw new BOSException("Method voucher is not supported");
    }

    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        if (sourceBillCollection == null || sourceBillCollection.size() == 0) {
            return new DAPTransformResult();
        }
        HashSet<String> set = new HashSet<String>();
        StringBuffer idList = new StringBuffer();
        String srcBillId = null;
        for (int i = 0; i < sourceBillCollection.size(); ++i) {
            srcBillId = sourceBillCollection.getObject(i).get("id").toString();
            set.add(srcBillId);
            idList.append("'" + srcBillId + "',");
        }
        DbUtil.execute((Context)ctx, (String)("update T_CSL_Requisition set flastupdatetime=flastupdatetime where fid in(" + idList.substring(0, idList.length() - 1) + ")"));
        StringBuffer sqlCheck = new StringBuffer();
        sqlCheck.append("select b.fstatus,count(*) cnt from t_csl_requisition a \r\n");
        sqlCheck.append("inner join t_csl_requisitionentry b on a.fid=b.frequisitionid \r\n");
        sqlCheck.append("where a.fid in(").append(idList.substring(0, idList.length() - 1)).append(") \r\n");
        sqlCheck.append("group by b.fstatus \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlCheck.toString());
        int totalCount = 0;
        boolean existReqChecked = false;
        try {
            while (rs.next()) {
                totalCount += rs.getInt("cnt");
                if (rs.getInt("fstatus") != 2) continue;
                existReqChecked = true;
                break;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (existReqChecked) {
            if (sourceBillCollection.size() == 1) {
                throw new RequisitionException(RequisitionException.BILL_CHECKED);
            }
            throw new RequisitionException(RequisitionException.BILL_PART_CHECKED);
        }
        if (totalCount != sourceBillCollection.size()) {
            if (sourceBillCollection.size() == 1) {
                throw new RequisitionException(RequisitionException.BILL_CHANGED);
            }
            throw new RequisitionException(RequisitionException.BILL_PART_CHANGED);
        }
        DAPTransformResult result = super._generateVoucher(ctx, sourceBillCollection, botMappingPK);
        String reqId = null;
        String curUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        IRequisitionCheck reqCheck = RequisitionCheckFactory.getLocalInstance(ctx);
        IEnactmentService enactService = EnactmentServiceFactory.createEnactService((Context)ctx);
        int len = sourceBillCollection.size();
        for (int i = 0; i < len; ++i) {
            ObjectStringPK pk;
            reqId = sourceBillCollection.getObject(i).get("id").toString();
            AssignmentInfo[] assigns = enactService.checkAssignmentInfos(reqId, curUser);
            if (assigns == null || assigns.length == 0 || assigns[0] == null || !this._isChecked(ctx, (IObjectPK)(pk = new ObjectStringPK(reqId)))) continue;
            reqCheck.virtualSubmit((IObjectPK)pk);
        }
        return result;
    }

    @Override
    protected IRowSet _getRowset(Context ctx, String id, String queryName) throws BOSException, EASBizException {
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK(queryName);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        viewInfo.setFilter(fi);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }

    public void audit(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
        HashSet<String> companySet = new HashSet<String>();
        if (ContextUtil.getCurrentFIUnit((Context)ctx) != null) {
            companySet.add(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        }
        this._audit(ctx, billId, companySet);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK billId, Set companyIdSet) throws BOSException, EASBizException {
        if (billId == null) {
            throw new IllegalArgumentException();
        }
        DbUtil.execute((Context)ctx, (String)("update T_CSL_Requisition set flastupdatetime=flastupdatetime where fid = '" + billId.toString() + "'"));
        if (!this._exists(ctx, billId)) {
            throw new RequisitionException(RequisitionException.BILL_NOT_EXIST);
        }
        RequisitionInfo info = this.getRequisitionInfo(ctx, billId);
        GlParam param = GlParam.getGlParams((Context)ctx, (String)"GLG01_3", (String)info.getTargCompany().getId().toString());
        boolean isAudit = param.getBoolean("GLG01_3");
        if (!isAudit) {
            throw new RequisitionException(RequisitionException.BILL_NOT_AUDITED);
        }
        if (this.exists(ctx, "where isAudit = 1 and id='" + billId.toString() + "'")) {
            throw new RequisitionException(RequisitionException.BILL_HAVE_AUDITED);
        }
        if (companyIdSet == null || companyIdSet.size() == 0) {
            throw new RequisitionException(RequisitionException.BILL_HASNOT_CHECKED);
        }
        StringBuffer sb = this.getSqlForCompanyIdSet(companyIdSet);
        StringBuffer sqlCheck = new StringBuffer();
        sqlCheck.append("select count(1) cnt from t_csl_requisition a \r\n");
        sqlCheck.append("inner join t_csl_requisitionentry b on a.fid=b.frequisitionid \r\n");
        sqlCheck.append("where a.ftargcompanyid in ").append(sb).append(" \r\n");
        sqlCheck.append("and a.fid = '").append(billId.toString()).append("' \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlCheck.toString());
        boolean existReqChecked = false;
        try {
            rs.next();
            if (rs.getInt("cnt") == 1) {
                existReqChecked = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!existReqChecked) {
            throw new RequisitionException(RequisitionException.BILL_HASNOT_CHECKED);
        }
        String[] isWorkFlow = EnactmentServiceFactory.createEnactService((Context)ctx).checkBizObjInWfProcess(new String[]{billId.toString()});
        if (isWorkFlow.length != 0) {
            throw new RequisitionException(RequisitionException.BILL_IS_WORKFLOW);
        }
        String sql = "update T_CSL_Requisition set FIsAudit = ?, FAuditDate = ?, FAuditorId = ? where FId = ? ";
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        Object[] params = new Object[]{new Integer(1), new Date(System.currentTimeMillis()), currentUser.getId().toString(), billId.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private StringBuffer getSqlForCompanyIdSet(Set companyIdSet) {
        Iterator it = companyIdSet.iterator();
        StringBuffer sb = new StringBuffer("(");
        int i = 0;
        while (it.hasNext()) {
            String companyId = (String)it.next();
            if (i == 0) {
                sb.append("'").append(companyId).append("'");
            } else {
                sb.append(",'").append(companyId).append("'");
            }
            ++i;
        }
        sb.append(")");
        return sb;
    }

    @Override
    protected void _antiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("update T_CSL_Requisition set flastupdatetime=flastupdatetime where fid = '" + pk.toString() + "'"));
        RequisitionInfo info = this.getRequisitionInfo(ctx, pk);
        HashSet<String> companyIdSet = new HashSet<String>();
        if (ContextUtil.getCurrentFIUnit((Context)ctx) != null) {
            companyIdSet.add(ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString());
        }
        this.canUnAudit(ctx, pk, info, companyIdSet);
        String sql = "update T_CSL_Requisition set FIsAudit = ?, FAuditDate = null, FAuditorId = null where FId = ? ";
        Object[] params = new Object[]{new Integer(0), pk.toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks, Set companyIdSet) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)("update T_CSL_Requisition set flastupdatetime=flastupdatetime where fid = '" + pks[0].toString() + "'"));
        RequisitionInfo info = this.getRequisitionInfo(ctx, pks[0]);
        this.canUnAudit(ctx, pks[0], info, companyIdSet);
        String sql = "update T_CSL_Requisition set FIsAudit = ?, FAuditDate = null, FAuditorId = null where FId = ? ";
        Object[] params = new Object[]{new Integer(0), pks[0].toString()};
        DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
    }

    private void canUnAudit(Context ctx, IObjectPK pk, RequisitionInfo info, Set companyIdSet) throws BOSException, EASBizException {
        GlParam param = GlParam.getGlParams((Context)ctx, (String)"GLG01_3", (String)info.getTargCompany().getId().toString());
        boolean isAudit = param.getBoolean("GLG01_3");
        if (!isAudit) {
            throw new RequisitionException(RequisitionException.BILL_NOT_UNAUDITED);
        }
        if (!info.isIsAudit()) {
            throw new RequisitionException(RequisitionException.BILL_UNAUDIT_CAN_NOT_UNAUDIT);
        }
        if (companyIdSet == null || companyIdSet.size() == 0) {
            throw new RequisitionException(RequisitionException.BILL_HASNOT_CHECKED);
        }
        StringBuffer sb = this.getSqlForCompanyIdSet(companyIdSet);
        StringBuffer sqlCheck = new StringBuffer();
        sqlCheck.append("select count(1) cnt from t_csl_requisition a \r\n");
        sqlCheck.append("inner join t_csl_requisitionentry b on a.fid=b.frequisitionid \r\n");
        sqlCheck.append("where a.ftargcompanyid in ").append(sb).append(" \r\n");
        sqlCheck.append("and a.fid = '").append(info.getId().toString()).append("' \r\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlCheck.toString());
        boolean existReqChecked = false;
        try {
            rs.next();
            if (rs.getInt("cnt") == 1) {
                existReqChecked = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (!existReqChecked) {
            throw new RequisitionException(RequisitionException.BILL_HASNOT_CHECKED);
        }
        if (info.isFiVouchered()) {
            throw new RequisitionException(RequisitionException.BILL_VOUCHED_CAN_NOT_UNAUDIT);
        }
    }

    protected void setWorkflowServiceState(Context ctx, IObjectPK objId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.id"));
        CompanyOrgUnitInfo comp = (CompanyOrgUnitInfo)this.getValue(ctx, objId, sic).get("company");
        this.setWorkflowServiceState(ctx, comp.getId().toString(), objId.toString());
    }

    protected void setWorkflowServiceState(Context ctx, String companyId, String objId) throws BOSException, EASBizException {
        boolean isUseWorkflow = FaManageUtils.isUseWorkflow((Context)ctx, (String)companyId);
        if (!isUseWorkflow && (objId == null || objId != null && !this.isRunningWorkflow(ctx, objId))) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
    }

    private boolean isRunningWorkflow(Context ctx, String objId) throws BOSException {
        boolean hasWorkflow = false;
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        String procDefID = service.findSubmitProcDef(new VoucherInfo().getBOSType(), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        if (procDefID != null) {
            IEnactmentService service2 = EnactmentServiceProxy.getEnacementService((Context)ctx);
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(objId);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState())) continue;
                hasWorkflow = true;
                break;
            }
        }
        return hasWorkflow;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (srcBillVO instanceof RequisitionInfo && bosType.equals((Object)new VoucherInfo().getBOSType())) {
            String curUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Timestamp curTime = this.getCurrentTime();
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                StringBuffer sqlReq = new StringBuffer();
                sqlReq.append("update t_csl_requisition set ffivouchered=0,flastupdatetime=?,flastupdateuserid=? where fid=?");
                DbUtil.execute((Context)ctx, (String)sqlReq.toString(), (Object[])new Object[]{curTime, curUser, srcBillVO.get("id").toString()});
                StringBuffer sql = new StringBuffer();
                sql.append("update t_csl_requisitionentry set fstatus=1,fvchnumber=null,FCheckNumber=null where frequisitionid=?");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{srcBillVO.get("id").toString()});
                StringBuffer sqlSrcVchAssist = new StringBuffer();
                sqlSrcVchAssist.append("update t_gl_voucherassistrecord set freqcheckstatus=1,FCheckNumber=null  ");
                sqlSrcVchAssist.append("where fid in (select fassistrecordid from t_csl_requisitionentry where frequisitionid=?) and freqcheckstatus=2");
                DbUtil.execute((Context)ctx, (String)sqlSrcVchAssist.toString(), (Object[])new Object[]{srcBillVO.get("id").toString()});
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("voucherType.name"));
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID), sic);
                String vchNumber = voucherInfo.getVoucherType().getName(ctx.getLocale()) + voucherInfo.getNumber();
                StringBuffer sql = new StringBuffer();
                String uuid = UUID.randomUUID().toString();
                sql.append("update t_csl_requisitionentry set fstatus=2,FCheckNumber=?,fvchnumber=? where frequisitionid=?");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{uuid, vchNumber, srcBillVO.get("id").toString()});
                StringBuffer sqlReq = new StringBuffer();
                sqlReq.append("update t_csl_requisition set ffivouchered=1,flastupdatetime=?,flastupdateuserid=? where fid=?");
                DbUtil.execute((Context)ctx, (String)sqlReq.toString(), (Object[])new Object[]{curTime, curUser, srcBillVO.get("id").toString()});
                StringBuffer sqlSrcVchAssist = new StringBuffer();
                sqlSrcVchAssist.append("update t_gl_voucherassistrecord set freqcheckstatus=2,FCheckNumber=? ");
                sqlSrcVchAssist.append("where fid in (select fassistrecordid from t_csl_requisitionentry where frequisitionid=?) and freqcheckstatus=1");
                DbUtil.execute((Context)ctx, (String)sqlSrcVchAssist.toString(), (Object[])new Object[]{uuid, srcBillVO.get("id").toString()});
                StringBuffer sqlDestVchAssist = new StringBuffer();
                sqlDestVchAssist.append("update t_gl_voucherassistrecord set freqstatus=?,FCheckNumber=?,FSOURCEFUNCTION=? where fbillid=?");
                DbUtil.execute((Context)ctx, (String)sqlDestVchAssist.toString(), (Object[])new Object[]{new Integer(0), uuid, functionName, voucherID});
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.EDIT)) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("voucherType.name"));
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID), sic);
                String vchNumber = voucherInfo.getVoucherType().getName(ctx.getLocale()) + voucherInfo.getNumber();
                StringBuffer sql = new StringBuffer();
                sql.append("update t_csl_requisitionentry set fvchnumber=? where frequisitionid=?");
                Object[] params = new Object[]{vchNumber, srcBillVO.get("id").toString()};
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
                StringBuffer sqlReq = new StringBuffer();
                sqlReq.append("update t_csl_requisition set flastupdatetime=?,flastupdateuserid=? where fid=?");
                DbUtil.execute((Context)ctx, (String)sqlReq.toString(), (Object[])new Object[]{curTime, curUser, srcBillVO.get("id").toString()});
                StringBuffer sqlDestVchAssist = new StringBuffer();
                sqlDestVchAssist.append("update t_gl_voucherassistrecord set freqstatus=? where fbillid=? and FSOURCEFUNCTION= ?");
                DbUtil.execute((Context)ctx, (String)sqlDestVchAssist.toString(), (Object[])new Object[]{new Integer(0), voucherID, functionName});
            }
        }
    }

    private BOTRelationCollection getBOTRelationCollection(Context ctx, String firstId) throws BTPException {
        try {
            IBOTRelation iBTPRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            viewInfo.getSelector().add(new SelectorItemInfo(" destObjectID "));
            filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)firstId, CompareType.EQUALS));
            viewInfo.setFilter(filter);
            return iBTPRelation.getCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new BTPException(BTPException.GETRELATIONERROR, (Throwable)e);
        }
    }

    @Override
    protected String _getTargVoucher(Context ctx, Map map) throws BOSException, EASBizException {
        String voucherId = null;
        String requisitionId = map.get("requisitionId").toString();
        String companyId = map.get("companyId").toString();
        String srcCompanyId = map.get("srcCompanyId").toString();
        String origAmount = map.get("origAmount").toString();
        String checkNumber = map.get("checkNumber").toString();
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("select top 1 v.fbillid from t_csl_requisitionentry r left join t_gl_voucherassistrecord v ");
        sbSql.append(" on r.fchecknumber = v.fchecknumber where r.fchecknumber = ?");
        sbSql.append(" and v.fcompanyid = ?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{checkNumber, companyId});
            if (rs.next()) {
                voucherId = rs.getString("fbillid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (voucherId != null) {
            return voucherId;
        }
        BOTRelationCollection relationColl = this.getBOTRelationCollection(ctx, requisitionId);
        if (relationColl != null && relationColl.size() > 0) {
            BOTRelationInfo info = relationColl.get(0);
            voucherId = info.getDestObjectID().toString();
        }
        if (voucherId != null) {
            return voucherId;
        }
        sbSql = new StringBuffer();
        sbSql.append("select top 1 v.fbillid from t_csl_requisitionentry r left join t_gl_voucherassistrecord v");
        sbSql.append(" on r.fchecknumber = v.fchecknumber and r.foriginalamount = (0-v.foriginalamount) where r.fchecknumber = ?");
        sbSql.append(" and v.fcompanyid = ? and v.foriginalamount = (0-?)");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbSql.toString(), (Object[])new Object[]{checkNumber, srcCompanyId, origAmount});
            if (rs.next()) {
                voucherId = rs.getString("fbillid");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return voucherId;
    }

    @Override
    protected Map _fetchInitData(Context ctx, String currentCompanyId) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ObjectUuidPK comPK = new ObjectUuidPK(currentCompanyId);
        HashMap<String, ObjectUuidPK> hmParamIn = new HashMap<String, ObjectUuidPK>();
        hmParamIn.put("GL_026", comPK);
        boolean isGroup = GlUtils.isGroupControl(ctx, "GLG01");
        if (isGroup) {
            hmParamIn.put("GLG01", null);
        } else {
            hmParamIn.put("GLG01", comPK);
        }
        boolean isCompanyByUser = false;
        hmParamIn.put("GL_053", null);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        try {
            result.put("GL_026", Integer.valueOf(hmAllParam.get("GL_026").toString()));
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GL_026"});
        }
        if (hmAllParam.get("GL_053") != null && "true".equals(hmAllParam.get("GL_053"))) {
            isCompanyByUser = true;
        }
        result.put("isCompanyByUser", isCompanyByUser);
        try {
            result.put("GLG01", Boolean.valueOf(hmAllParam.get("GLG01").toString()));
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOPARAM, ex, new Object[]{"GLG01"});
        }
        SelectorItemCollection sic = GlUtils.getCompanySic();
        CompanyOrgUnitInfo company = null;
        try {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)comPK, sic);
            if (company == null) {
                throw new GLException(GLException.NOCOMPANY);
            }
            result.put("CurCompany", company);
        }
        catch (Exception e) {
            throw new GLException(GLException.NOCOMPANY, e);
        }
        PeriodInfo curPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        if (curPeriod == null) {
            throw new ReportException(ReportException.CURRENCY_PERIOD_ERROR);
        }
        result.put("CurPeriod", curPeriod);
        IGLPeriodEndFacade ctrl = GLPeriodEndFacadeFactory.getLocalInstance(ctx);
        GlUtils.AccountPeriodInfo pi = ctrl.getAccountPeriod(company.getId().toString(), curPeriod.getPeriodType().getId().toString());
        result.put("CurAccountPeriod", pi);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        ICurrency ie = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection currencys = ie.getCurrencyCollection(view, true);
        result.put("Currency", currencys);
        view = new EntityViewInfo();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        AccountTableCollection coll = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
        result.put("accountTable", coll);
        return result;
    }

    private Timestamp getCurrentTime() {
        long time = System.currentTimeMillis();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected IRowSet _getRowSetCollection(Context ctx, String queryName, Set idSet) throws BOSException, EASBizException {
        IQueryExecutor queryExcu = null;
        MetaDataPK queryPK = null;
        queryPK = new MetaDataPK(queryName);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        viewInfo.setFilter(fi);
        queryExcu = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }

    @Override
    protected Map _fetchInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        boolean isCompanyByUser = false;
        hmParamIn.put("GL_053", null);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        if (hmAllParam.get("GL_053") != null && "true".equals(hmAllParam.get("GL_053"))) {
            isCompanyByUser = true;
        }
        result.put("isCompanyByUser", isCompanyByUser);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("precision"));
        ICurrency ie = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyCollection currencys = ie.getCurrencyCollection(view, true);
        result.put("Currency", (Boolean)currencys);
        view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        AccountTableCollection coll = AccountTableFactory.getLocalInstance((Context)ctx).getAccountTableCollection(view);
        result.put("accountTable", (Boolean)coll);
        return result;
    }
}

