/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.dbf.utils;

import com.kingdee.eas.fi.gl.dbf.utils.DBFExploder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;

class DBFExploderInputStream
extends InputStream {
    private InputStream in;
    private Queue<Byte> queue = new LinkedList<Byte>();
    private int estimatedUncompressedSize = 0;

    DBFExploderInputStream(InputStream in) {
        this(in, 0);
    }

    DBFExploderInputStream(InputStream in, int uncompressedSize) {
        this.in = in;
        this.estimatedUncompressedSize = uncompressedSize;
    }

    @Override
    public int read() throws IOException {
        int readed;
        if (this.queue.isEmpty() && (readed = this.fillQueue()) < 0) {
            return -1;
        }
        return this.queue.poll().byteValue();
    }

    private int fillQueue() throws IOException {
        ByteArrayOutputStream baos = this.getCompressedByteStream();
        if (baos.size() <= 0) {
            return -1;
        }
        byte[] compressedData = baos.toByteArray();
        int outputBufferSize = this.getAdjustedOutputSize(compressedData);
        byte[] decompressedData = new byte[outputBufferSize];
        int decompressed = DBFExploder.pkexplode(compressedData, DBFExploder.createInMemoryStorage(decompressedData), outputBufferSize);
        for (int i = 0; i < decompressed; ++i) {
            this.queue.add(decompressedData[i]);
        }
        return decompressed;
    }

    protected int getAdjustedOutputSize(byte[] compressedData) {
        int outputBufferSize = this.estimatedUncompressedSize;
        if (outputBufferSize < compressedData.length) {
            outputBufferSize = compressedData.length * 6;
        }
        return outputBufferSize;
    }

    protected ByteArrayOutputStream getCompressedByteStream() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        byte[] buffer = new byte[4096];
        int readed = 0;
        while ((readed = this.in.read(buffer)) > 0) {
            baos.write(buffer, 0, readed);
        }
        return baos;
    }
}

