/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.fi.gl.CollectEnum;
import com.kingdee.eas.fi.gl.ReportConditionBase;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GLRptAsstactBaseCondition
extends GLRptBaseCondition {
    private static final long serialVersionUID = 703551103388352669L;
    private String asstAccountId;
    private List asstActList;
    private Set asstAccountIdSet;
    private String measureUnitId;
    private boolean groupByMU = false;
    private boolean showAsstItemTotal = false;
    private boolean isFilterByCat = false;
    private GLRptRowSet selectedItem;
    private String dataSourceTable;
    private boolean showAsstActSingle = false;

    public GLRptAsstactBaseCondition() {
    }

    public GLRptAsstactBaseCondition(ReportConditionBase base) {
        super(base);
        if (base instanceof GLRptAsstactBaseCondition) {
            GLRptAsstactBaseCondition cond = (GLRptAsstactBaseCondition)base;
            this.setAsstAccountId(cond.getAsstAccountId());
            this.setMeasureUnitId(cond.getMeasureUnitId());
            this.setAsstActList(cond.getAsstActList());
            this.setShowAsstItemTotal(cond.isShowAsstItemTotal());
            this.setFilterByCat(cond.isFilterByCat());
            this.setGroupByMU(cond.isGroupByMU());
        }
    }

    public GLRptAsstactBaseCondition(Map map) throws CloneNotSupportedException {
        super(map);
        if (this.isOldQuerySolution(map)) {
            Object measureUnit;
            Object asstAccount;
            if (map.get("jebAcct") != null && (asstAccount = ((RptConditionManager.ComponentStatus)map.get("jebAcct")).getValue()) instanceof AsstAccountInfo) {
                this.setAsstAccountId(((AsstAccountInfo)asstAccount).getId().toString());
            }
            Boolean filterByCat = map.get("chkFilterByCat") == null ? Boolean.FALSE : (Boolean)((RptConditionManager.ComponentStatus)map.get("chkFilterByCat")).getValue();
            this.setFilterByCat(filterByCat == null ? false : filterByCat);
            ArrayList<AsstactTypeEntity> newList = new ArrayList<AsstactTypeEntity>();
            if (map.get("tableData") != null) {
                List asstActList = (List)map.get("tableData");
                for (AsstactTypeEntity at : asstActList) {
                    if (!at.isSelected()) continue;
                    newList.add(at);
                }
                this.setAsstActList(newList);
            } else if (map.get("rs") != null) {
                RptRowSet rs = (RptRowSet)map.get("rs");
                rs.reset();
                Object v = null;
                while (rs.next()) {
                    AsstactTypeEntity at;
                    at = new AsstactTypeEntity();
                    at.setId(rs.getString("fid"));
                    at.setNumber(rs.getString("NUMBER"));
                    at.setName(rs.getString("FNAME"));
                    at.setSelected(rs.getBoolean("FSELECTED", false));
                    at.setFrom(rs.getObject("FFROM"));
                    at.setTo(rs.getObject("FTO"));
                    at.setMaxLevel(rs.getInt("FMAXLEVEL"));
                    at.setCollect((CollectEnum)((Object)rs.getObject("FCOLLECT")));
                    v = rs.getObject("FQTYASST");
                    if (v instanceof Integer) {
                        at.setQtyAsst((Integer)v == 1);
                    } else {
                        at.setQtyAsst(rs.getBoolean("FQTYASST", false));
                    }
                    at.setHgAttribute(rs.getString("FAsstHGAttribute"));
                    at.setHgField(rs.getString("fmappingfieldname"));
                    at.setGeneralAsstactGroupId(rs.getString("FGLAsstActTypeGrpID"));
                    at.setUseLongNumber(rs.getBoolean("FUseLongNumber", false));
                    at.setAsstMeasureUnitGroupId(rs.getString("FASSTMEASUREUNITGROUPID"));
                    at.setPermissionItem(rs.getString("FPermissionItem"));
                    at.setEnabledPermissionLimit(rs.getBoolean("FENABLEPERMISSIONLIMIT", false));
                    try {
                        at.setSelectedLevel(rs.getInt("SELECTEDLEVEL"));
                    }
                    catch (Exception e) {
                        at.setSelectedLevel(1);
                    }
                    at.setGroupTable(rs.getString("FGroupTableName"));
                    at.setGroupField(rs.getString("FGroupMappingFieldName"));
                    at.setTableName(rs.getString("frealtiondataobject"));
                    at.setQueryName(rs.getString("fdefaultqueryname"));
                    at.setMultilevel(rs.getInt("FIsMultiLevel") == 1);
                    at.setForCompany(rs.getInt("FisForCompany") != 0);
                    at.setAsstGroup(rs.getString("FASSTGROUPINFO"));
                    if (!at.isSelected()) continue;
                    newList.add(at);
                }
                this.setAsstActList(newList);
            }
            Object object = measureUnit = map.get("jebMeasureUnit") == null ? null : ((RptConditionManager.ComponentStatus)map.get("jebMeasureUnit")).getValue();
            if (measureUnit instanceof MeasureUnitInfo) {
                this.setMeasureUnitId(((MeasureUnitInfo)measureUnit).getId().toString());
            }
            Boolean groupByMU = map.get("jcbSumByMeasureUnit") == null ? Boolean.FALSE : (Boolean)((RptConditionManager.ComponentStatus)map.get("jcbSumByMeasureUnit")).getValue();
            this.setGroupByMU(groupByMU == null ? false : groupByMU);
            Boolean jcbDisplayAssSum = map.get("jcbDisplayAssSum") == null ? Boolean.FALSE : (Boolean)((RptConditionManager.ComponentStatus)map.get("jcbDisplayAssSum")).getValue();
            this.setShowAsstItemTotal(jcbDisplayAssSum == null ? false : jcbDisplayAssSum);
        } else {
            this.setAsstAccountId((String)map.get("asstAccountId"));
            this.setAsstActList((List)map.get("asstActList"));
            this.setMeasureUnitId((String)map.get("measureUnitId"));
            this.setShowAsstItemTotal(this.getBoolean((Boolean)map.get("showAsstItemTotal")));
            this.setFilterByCat(this.getBoolean((Boolean)map.get("filterByCat")));
            this.setGroupByMU(this.getBoolean((Boolean)map.get("groupByMU")));
        }
    }

    @Override
    public Map toMap() {
        Map map = super.toMap();
        map.put("asstAccountId", this.getAsstAccountId());
        map.put("asstActList", this.getAsstActList());
        map.put("measureUnitId", this.getMeasureUnitId());
        map.put("showAsstItemTotal", this.isShowAsstItemTotal());
        map.put("filterByCat", this.isFilterByCat());
        map.put("groupByMU", this.isGroupByMU());
        return map;
    }

    public String getAsstAccountId() {
        return this.asstAccountId;
    }

    public void setAsstAccountId(String asstAccountId) {
        this.asstAccountId = asstAccountId;
    }

    public List getAsstActList() {
        if (this.asstActList == null) {
            return new ArrayList();
        }
        return this.asstActList;
    }

    public void setAsstAccountIdSet(Set asstAccountIdSet) throws BOSException {
        this.asstAccountIdSet = asstAccountIdSet;
    }

    public Set getAsstAccountIdSet() throws BOSException {
        if (this.asstAccountIdSet == null) {
            this.asstAccountIdSet = new HashSet();
            if (this.getAsstAccountId() != null) {
                this.asstAccountIdSet.add(this.getAsstAccountId());
            } else {
                this.asstAccountIdSet = this.getAsstAccountIdSet(this.getAsstActList());
            }
        }
        return this.asstAccountIdSet;
    }

    public Set getAsstAccountIdSet(List asstActList) throws BOSException {
        HashSet<String> asstAccountIdSet = new HashSet<String>();
        if (asstActList == null || asstActList.isEmpty()) {
            return asstAccountIdSet;
        }
        ArrayList<String> params = new ArrayList<String>();
        Iterator it = asstActList.iterator();
        AsstactTypeEntity at = (AsstactTypeEntity)it.next();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct \n");
        sql.append("  aa.FCAA \n");
        sql.append("from ( \n");
        sql.append("  SELECT av.FCAA FCAA \n");
        sql.append("  from t_bd_accountview av \n");
        sql.append("  where av.FCompanyID in " + this.getCompanyIdsStr() + " \n");
        sql.append("    and av.FCAA is not null \n");
        sql.append("  union \n");
        sql.append("  select aac.fbeforeid FCAA \n");
        sql.append("  from t_bd_asstAccountChange aac \n");
        sql.append("  join t_bd_accountview av on av.fid = aac.faccountid \n");
        sql.append("  where av.FCompanyID in " + this.getCompanyIdsStr() + " \n");
        sql.append("  and aac.fbeforeid is not null \n");
        sql.append(") aa \n");
        sql.append("inner join t_bd_asstactgroupdetail det on det.fasstaccountid = aa.fcaa and det.fasstacttypeid = ? \n");
        params.add(at.getId());
        int index = 1;
        while (it.hasNext()) {
            at = (AsstactTypeEntity)it.next();
            sql.append(" inner join t_bd_asstactgroupdetail det").append(index).append(" on det").append(index).append(".fasstaccountid = aa.fcaa and det").append(index).append(".fasstacttypeid = ? ");
            params.add(at.getId());
            ++index;
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString(), (Object[])params.toArray());
        try {
            while (rs.next()) {
                asstAccountIdSet.add(rs.getString("fcaa"));
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        if (asstAccountIdSet.isEmpty()) {
            asstAccountIdSet.add("''");
        }
        return asstAccountIdSet;
    }

    public boolean isMulAsstAccount() throws BOSException {
        try {
            Iterator it;
            String sql;
            IRowSet rs;
            Set idSet = this.getAsstAccountIdSet();
            if (idSet.size() > 1) {
                return true;
            }
            if (!idSet.isEmpty() && (rs = DbUtil.executeQuery((Context)this.ctx, (String)(sql = "select count(1) cnt from t_bd_asstactgroupdetail where fasstaccountid = ?"), (Object[])new String[]{(String)(it = idSet.iterator()).next()})).next() && rs.getInt("cnt") > this.asstActList.size()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return false;
    }

    public void setAsstActList(List asstActList) {
        this.asstActList = asstActList;
    }

    public String getMeasureUnitId() {
        return this.measureUnitId;
    }

    public void setMeasureUnitId(String measureUnitId) {
        this.measureUnitId = measureUnitId;
    }

    public boolean isShowAsstItemTotal() {
        return this.showAsstItemTotal;
    }

    public void setShowAsstItemTotal(boolean showAsstItemTotal) {
        this.showAsstItemTotal = showAsstItemTotal;
    }

    public boolean isFilterByCat() {
        return this.isFilterByCat;
    }

    public void setFilterByCat(boolean isFilterByCat) {
        this.isFilterByCat = isFilterByCat;
    }

    public boolean isGroupByMU() {
        return this.groupByMU;
    }

    public void setGroupByMU(boolean groupByMU) {
        this.groupByMU = groupByMU;
    }

    public void setSelectedItem(GLRptRowSet selectedItem) {
        this.selectedItem = selectedItem;
    }

    public void setDataSourceTable(String dataSourceTable) {
        this.dataSourceTable = dataSourceTable;
    }

    public GLRptRowSet getSelectedItem() {
        if (this.selectedItem != null) {
            this.selectedItem.beforeFirst();
        }
        return this.selectedItem;
    }

    public String getDataSourceTable() {
        return this.dataSourceTable;
    }

    public boolean isShowAsstActSingle() {
        return this.showAsstActSingle;
    }

    public void setShowAsstActSingle(boolean showAsstActSingle) {
        this.showAsstActSingle = showAsstActSingle;
    }
}

