/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactBaseExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptAsstactGGFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class GLRptAsstactGGExcelExporter
extends GLRptAsstactBaseExcelExporter {
    public GLRptAsstactGGExcelExporter(Map<String, Object> params) {
        super(params);
    }

    @Override
    protected IGLRptBaseFacade getIGLRptDataFacade() throws BOSException {
        return GLRptAsstactGGFacadeFactory.getRemoteInstance();
    }

    @Override
    protected int createRptHead(Sheet sheet) {
        int rowIndex = 0;
        Row row = sheet.createRow(rowIndex++);
        GLRptAsstactBaseCondition cond = this.getCond();
        Cell cell = row.createCell(0);
        cell.setCellValue(this.buildRichTextString((String)this.params.get("AsstAct")));
        CellRangeAddress rang = new CellRangeAddress(0, 0, 0, 1);
        sheet.addMergedRegion(rang);
        cell = row.createCell(2);
        cell.setCellValue(this.buildRichTextString((String)this.params.get("AsstActItem")));
        rang = new CellRangeAddress(0, 0, 2, 3);
        sheet.addMergedRegion(rang);
        cell = row.createCell(4);
        cell.setCellValue(this.buildRichTextString((String)this.params.get("Period")));
        rang = new CellRangeAddress(0, 0, 4, 5);
        sheet.addMergedRegion(rang);
        cell = row.createCell(6);
        cell.setCellValue(this.buildRichTextString((String)this.params.get("Currency")));
        rang = new CellRangeAddress(0, 0, 6, 7);
        sheet.addMergedRegion(rang);
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            cell = row.createCell(8);
            cell.setCellValue(this.buildRichTextString(cond.getCompany().getName()));
            rang = new CellRangeAddress(0, 0, 8, 9);
            sheet.addMergedRegion(rang);
        }
        String optionPosting = cond.getOptionPosting() ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"include_unpostvoucher") : EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"posted_voucher");
        cell = row.createCell(10);
        cell.setCellValue(this.buildRichTextString(optionPosting));
        rang = new CellRangeAddress(0, 0, 10, 11);
        sheet.addMergedRegion(rang);
        return rowIndex;
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        boolean isTotal = false;
        Object accountID = data.getObject("FAccountID");
        if (accountID == null || accountID.toString().trim().length() == 0) {
            isTotal = true;
        }
        return isTotal;
    }

    @Override
    protected GLRptAsstactBaseCondition getCond() {
        return (GLRptAsstactBaseCondition)super.getCond();
    }

    @Override
    protected String getFileName() {
        return "asstActGGTmp";
    }
}

