/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class GLRptCommonUtil {
    private static final Logger logger = Logger.getLogger(GLRptCommonUtil.class);

    public static CompanyOrgUnitInfo[] getCompanyArray(Context ctx, CompanyOrgUnitInfo[] companys, String accountTableId, String periodTypeId, int periodYear, int periodNumber) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append(" select com.fid from t_org_company com ");
        filterSql.append(" inner join t_bd_acct_contorl ac on ac.fdestcompanyid = com.fid ");
        filterSql.append(" inner join t_bd_accounttable ab on ab.fid = ac.faccounttableid ");
        filterSql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fcompanyid = com.fid");
        filterSql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        filterSql.append(" inner join t_bd_period pe on pe.fid = ssc.fstartperiodid ");
        filterSql.append(" where ac.FIsDefaultForRefer = 0 ");
        if (accountTableId != null) {
            filterSql.append(" and ab.fid = '").append(accountTableId).append("'");
        }
        filterSql.append(" and com.fid in ").append(GLRptCommonUtil.getIdStr(GLRptCommonUtil.getCompanyIdSet(companys)));
        filterSql.append(" and pe.fnumber <= ").append(periodYear * 100 + periodNumber);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        if (periodTypeId != null) {
            fic.add(new FilterItemInfo("accountPeriodType.id", (Object)periodTypeId));
        }
        fic.add(new FilterItemInfo("id", (Object)filterSql.toString(), CompareType.INNER));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setFilter(filter);
        view.setSelector(GlUtils.getCompanySic());
        view.setSorter(sorter);
        CompanyOrgUnitCollection companyCollection = null;
        try {
            companyCollection = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view) : CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (companyCollection == null) {
            return null;
        }
        CompanyOrgUnitInfo[] checkedCompanys = new CompanyOrgUnitInfo[companyCollection.size()];
        for (int i = 0; i < companyCollection.size(); ++i) {
            checkedCompanys[i] = companyCollection.get(i);
        }
        return checkedCompanys;
    }

    public static ProfitCenterOrgUnitInfo[] getProfitCenterArray(Context ctx, ProfitCenterOrgUnitInfo[] profitCenters, CompanyOrgUnitInfo company, String accountTableId, String periodTypeId, int periodYear, int periodNumber) {
        if (profitCenters == null || profitCenters.length == 0) {
            return null;
        }
        StringBuffer filterSql = new StringBuffer();
        filterSql.append(" select distinct pro.fid from t_org_profitCenter pro ");
        filterSql.append(" inner join t_bd_acct_contorl ac on ac.fdestcompanyid = '").append(company.getId().toString()).append("'");
        filterSql.append(" inner join t_bd_accounttable ab on ab.fid = ac.faccounttableid ");
        filterSql.append(" inner join t_bd_systemstatusctrol ssc on ssc.fprofitCenterid = pro.fid");
        filterSql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(1006);
        filterSql.append(" inner join t_bd_period pe on pe.fid = ssc.fstartperiodid ");
        filterSql.append(" where ac.FIsDefaultForRefer = 0 ");
        if (accountTableId != null) {
            filterSql.append(" and ab.fid = '").append(accountTableId).append("'");
        }
        filterSql.append(" and pro.fid in ").append(GLRptCommonUtil.getIdStr(GLRptCommonUtil.getProfitCenterIdSet(profitCenters)));
        filterSql.append(" and pe.fnumber <= ").append(periodYear * 100 + periodNumber);
        if (periodTypeId != null) {
            filterSql.append(" and pe.ftypeid ='").append(periodTypeId).append("'");
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)filterSql.toString(), CompareType.INNER));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setFilter(filter);
        view.setSelector(GlUtils.getProfitCenterSic());
        view.setSorter(sorter);
        ProfitCenterOrgUnitCollection profitCenterCollection = null;
        try {
            profitCenterCollection = ctx != null ? ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx).getProfitCenterOrgUnitCollection(view) : ProfitCenterOrgUnitFactory.getRemoteInstance().getProfitCenterOrgUnitCollection(view);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (profitCenterCollection == null) {
            return null;
        }
        ProfitCenterOrgUnitInfo[] checkedProfitCenters = new ProfitCenterOrgUnitInfo[profitCenterCollection.size()];
        for (int i = 0; i < profitCenterCollection.size(); ++i) {
            checkedProfitCenters[i] = profitCenterCollection.get(i);
        }
        return checkedProfitCenters;
    }

    public static Set getCompanyIdSet(CompanyOrgUnitInfo[] companys) {
        if (companys == null || companys.length == 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < companys.length; ++i) {
            idSet.add(companys[i].getId().toString());
        }
        return idSet;
    }

    public static Set getProfitCenterIdSet(ProfitCenterOrgUnitInfo[] profitCenters) {
        if (profitCenters == null || profitCenters.length == 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < profitCenters.length; ++i) {
            idSet.add(profitCenters[i].getId().toString());
        }
        return idSet;
    }

    public static String getIdStr(Set idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer ids = new StringBuffer();
        Iterator it = idSet.iterator();
        ids.append("('").append(it.next()).append("'");
        while (it.hasNext()) {
            ids.append(",'").append(it.next()).append("'");
        }
        ids.append(")");
        return ids.toString();
    }
}

