/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptQueryResult;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.fi.gl.utils.ExcelUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public abstract class GLRptExcelExporter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.GLRptPageExcelExporter");
    private GLRptBaseCondition cond;
    private CellStyle headColumnStyle = null;
    private CellStyle commTotalStyle;
    private CellStyle commStyle;
    private CellStyle textTotalStyle;
    private CellStyle textStyle;
    private Map<Integer, CellStyle> numeralTotalFormats = new HashMap<Integer, CellStyle>();
    private Map<Integer, CellStyle> numeralFormats = new HashMap<Integer, CellStyle>();
    private GLRptTableHeadInfo head;
    private Workbook wb;
    protected Map<String, Object> params;
    protected ExportType exportType;
    protected Integer exportPageSize = null;
    protected ExportLogger exportLogger = null;
    protected EntityViewInfo view;
    protected String GL_RPT_RESOURCE = "com.kingdee.eas.fi.gl.rpt.GLRptCommonQueryResource";

    public GLRptExcelExporter(Map<String, Object> params) {
        this.params = params;
        this.exportPageSize = (Integer)params.get("exportPageSize");
        this.exportLogger = (ExportLogger)params.get("exportLogger");
        this.view = (EntityViewInfo)params.get("view");
        this.cond = (GLRptBaseCondition)this.view.get("GLFixCondition");
        this.head = (GLRptTableHeadInfo)params.get("head");
        this.exportType = params.get("isSupportXlsx") != null && (Boolean)params.get("isSupportXlsx") != false ? ExportType.XLSX : ExportType.XLS;
    }

    protected abstract IGLRptBaseFacade getIGLRptFacade() throws BOSException;

    public void export() throws Exception {
        GLRptRowSet data;
        String queryId = (String)this.params.get("queryId");
        if (this.head != null && queryId != null) {
            data = this.getData();
        } else {
            this.info("Execute query ...");
            GLRptQueryResult rs = this.getQueryData(this.view);
            this.head = rs == null ? null : rs.getTableHeadInfo();
            GLRptRowSet gLRptRowSet = data = rs == null ? null : rs.getData();
        }
        if (this.head == null || data == null) {
            return;
        }
        this.info("Build excel ...");
        this.export(this.head, data);
        this.info("Export finished");
    }

    public GLRptRowSet getData() throws EASBizException, BOSException {
        IGLRptBaseFacade iFacade = this.getIGLRptFacade();
        String queryId = (String)this.params.get("queryId");
        int count = 0;
        GLRptRowSet rs = null;
        while (true) {
            this.info("Get data " + count + "/" + this.params.get("rowCount") + " ...");
            GLRptRowSet rowSet = iFacade.getData(queryId, count, this.exportPageSize);
            if (rs == null) {
                rs = rowSet;
            } else {
                rs.addRowSets(rowSet);
            }
            if (rowSet.size() < this.exportPageSize) break;
            count += this.exportPageSize.intValue();
        }
        GLRptRowSet sumRow = iFacade.getSumData(queryId);
        if (sumRow != null) {
            while (sumRow.next()) {
                int rowIndex = sumRow.getRowIndex();
                String[] colKey = sumRow.getColumKeys();
                for (int i = 0; i < colKey.length; ++i) {
                    rs.updateObject(rowIndex, colKey[i], sumRow.getObject(colKey[i]));
                }
            }
        }
        this.doGLRowSet(rs);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GLRptQueryResult getQueryData(EntityViewInfo view) throws BOSException, EASBizException {
        GLRptQueryResult rs = null;
        IGLRptBaseFacade facade = this.getIGLRptFacade();
        try {
            rs = facade.query(view);
            if (rs == null) {
                GLRptQueryResult gLRptQueryResult = null;
                return gLRptQueryResult;
            }
            this.doPrintData(rs, facade);
        }
        finally {
            if (rs != null && rs.getQueryId() != null) {
                facade.releaseDataSource(rs.getQueryId());
            }
        }
        return rs;
    }

    protected void doPrintData(GLRptQueryResult qrs, IGLRptBaseFacade facade) throws BOSException, EASBizException {
        GLRptRowSet rs;
        GLRptRowSet rowSet = rs = qrs.getData();
        for (int beginIndex = this.exportPageSize.intValue(); beginIndex < qrs.getViewRowCount(); beginIndex += this.exportPageSize.intValue()) {
            this.info("Get data " + beginIndex + "/" + qrs.getViewRowCount() + " ...");
            rs = facade.getData(qrs.getQueryId(), beginIndex, this.exportPageSize);
            rowSet.addRowSets(rs);
        }
        this.info("Get sum data ...");
        GLRptRowSet sumRow = facade.getSumData(qrs.getQueryId());
        if (sumRow != null) {
            while (sumRow.next()) {
                int rowIndex = sumRow.getRowIndex();
                String[] colKey = sumRow.getColumKeys();
                for (int i = 0; i < colKey.length; ++i) {
                    rowSet.updateObject(rowIndex, colKey[i], sumRow.getObject(colKey[i]));
                }
            }
        }
        this.info("Prepare data ...");
        this.doGLRowSet(rowSet);
    }

    protected void doGLRowSet(GLRptRowSet rs) throws EASBizException, BOSException {
    }

    public void info(String msg) {
        ExportLogger exportLogger = (ExportLogger)this.params.get("exportLogger");
        if (exportLogger != null) {
            exportLogger.info(msg);
        }
    }

    public void error(String msg) {
        ExportLogger exportLogger = (ExportLogger)this.params.get("exportLogger");
        if (exportLogger != null) {
            exportLogger.error(msg);
        }
    }

    public void export(GLRptTableHeadInfo head, GLRptRowSet data) throws BOSException {
        File excelFile;
        if (data == null || data.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"62_RptAsstactGGExportHelper"));
            SysUtil.abort();
        }
        if (head.getColumnSize() > ExportType.XLS.getMaxColumnCount()) {
            this.exportType = ExportType.XLSX;
        }
        if ((excelFile = (File)this.params.get("excelFile")) != null && excelFile.getName().toLowerCase().endsWith(".xlsx")) {
            this.exportType = ExportType.XLSX;
        }
        Workbook wb = this.buildWorkbook();
        Sheet sheet = this.buildSheetWithHead(wb, head);
        int rowIndex = this.getRowSize(sheet);
        this.createTableBody(head, data, wb, rowIndex);
        this.writeFile(wb, excelFile);
    }

    protected abstract String getFileName();

    protected int createRptHead(Sheet sheet) {
        return 0;
    }

    protected int createTableBody(GLRptTableHeadInfo head, GLRptRowSet data, Workbook wb, int rowIndex) throws BOSException {
        this.head = head;
        this.wb = wb;
        Sheet sheet = this.getSheetIfNull(wb);
        this.commTotalStyle = this.getCellStyle(wb, HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
        this.commStyle = this.getCellStyle(wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        this.textTotalStyle = this.getCellStyle(wb, HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
        this.textStyle = this.getCellStyle(wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
        this.commTotalStyle.setAlignment(HorizontalAlignment.LEFT);
        this.commStyle.setAlignment(HorizontalAlignment.LEFT);
        this.textTotalStyle.setAlignment(HorizontalAlignment.LEFT);
        this.textStyle.setAlignment(HorizontalAlignment.LEFT);
        DataFormat format = wb.createDataFormat();
        this.textTotalStyle.setDataFormat(format.getFormat("@"));
        this.textStyle.setDataFormat(format.getFormat("@"));
        data.beforeFirst();
        int maxRowCount = this.exportType.getMaxRowCount();
        while (data.next()) {
            if (rowIndex >= maxRowCount) {
                sheet = this.buildSheetWithHead(wb, head);
                rowIndex = this.getRowSize(sheet);
            }
            Row row = sheet.createRow(rowIndex++);
            this.setRowData(row, data);
        }
        return rowIndex;
    }

    protected void setRowData(Row row, GLRptRowSet data) throws BOSException {
        boolean isTotal = this.isTotal(data);
        int colSize = this.head.getColumnSize();
        int cellIndex = 0;
        for (int j = 0; j < colSize; ++j) {
            GLRptTableHeadInfo.GLRptTableColumnInfo col = this.head.getTableColumnInfo(j);
            if (col.isHide()) continue;
            Cell cell = row.createCell(cellIndex);
            this.setCellValueAndStyle(col, cell, data, isTotal);
            ++cellIndex;
        }
    }

    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, Cell cell, GLRptRowSet data, boolean isTotal) throws BOSException {
        CellStyle style;
        String colName = col.getColName();
        Object value = data.getObject(colName);
        if (col.isNumeral()) {
            cell.setCellType(CellType.NUMERIC);
            this.setCellDoubleValue(cell, value);
            int precision = col.getScale();
            if (this.cond.isAllCurrency() && colName.endsWith("For")) {
                precision = data.getInt("currencyPre");
            }
            style = this.getNumericStyle(isTotal, precision);
        } else {
            style = value instanceof String && !StringUtil.isExcelNumber((String)((String)value)) && !col.getColName().toLowerCase().contains("date") ? this.getTextStyle(isTotal) : this.getCommStyle(isTotal);
            if (value != null) {
                cell.setCellValue(this.buildRichTextString(value.toString()));
            } else {
                cell.setCellValue(this.buildRichTextString(""));
            }
        }
        cell.setCellStyle(style);
    }

    protected void setCellDoubleValue(Cell cell, Object value) {
        if (value != null) {
            double val = 0.0;
            try {
                val = Double.parseDouble(value.toString());
            }
            catch (Exception ex) {
                logger.error((Object)"trans to double error!", (Throwable)ex);
            }
            if (val != 0.0) {
                cell.setCellValue(val);
            } else {
                cell.setCellType(CellType.BLANK);
            }
        } else {
            cell.setCellType(CellType.BLANK);
        }
    }

    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        return false;
    }

    private int createTableHead(GLRptTableHeadInfo head, Workbook wb, Sheet sheet, int rowIndex) {
        String resFile = "com.kingdee.eas.fi.gl.GLXResource";
        for (int i = 0; i < head.getHeadRowSize(); ++i) {
            Row row = sheet.createRow(rowIndex++);
            int cellIndex = 0;
            for (int j = 0; j < head.getColumnSize(); ++j) {
                GLRptTableHeadInfo.GLRptTableColumnInfo col = head.getTableColumnInfo(j);
                if (col.isHide()) continue;
                Cell cell = row.createCell(cellIndex);
                String res = EASResource.getString((String)resFile, (String)head.getHeadTitle()[i][j]);
                if ("Missing Resource".equals(res)) {
                    res = head.getHeadTitle()[i][j];
                }
                cell.setCellValue(this.buildRichTextString(res));
                cell.setCellType(CellType.STRING);
                cell.setCellStyle(this.getHeadColumnStyle(wb));
                ++cellIndex;
            }
        }
        return rowIndex;
    }

    protected RichTextString buildRichTextString(String res) {
        return ExportType.XLS == this.exportType ? new HSSFRichTextString(res) : new XSSFRichTextString(res);
    }

    protected Workbook buildWorkbook() {
        return ExportType.XLS == this.exportType ? new HSSFWorkbook() : new SXSSFWorkbook(this.exportPageSize.intValue());
    }

    protected Sheet buildSheetWithHead(Workbook wb, GLRptTableHeadInfo head) {
        Sheet sheet = this.buildSheet(wb);
        this.adjustColumnWidth(head, sheet);
        int rptHeadRowCount = this.createRptHead(sheet);
        this.createTableHead(head, wb, sheet, rptHeadRowCount);
        this.mergeTableHead(head, sheet, rptHeadRowCount);
        return sheet;
    }

    protected Sheet buildSheet(Workbook wb) {
        int sheetSize = wb.getNumberOfSheets();
        return wb.createSheet("sheet" + (sheetSize + 1));
    }

    protected Sheet getSheetIfNull(Workbook wb) {
        int sheetSize;
        if (wb == null) {
            this.wb = wb = this.buildWorkbook();
        }
        if ((sheetSize = wb.getNumberOfSheets()) == 0) {
            return this.buildSheet(wb);
        }
        return wb.getSheetAt(wb.getNumberOfSheets() - 1);
    }

    protected void addMergeCell(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol, RichTextString richTextString) {
        if (firstRow < 0 || lastRow < 0 || firstCol < 0 || lastCol < 0) {
            return;
        }
        int currentRowSize = this.getRowSize(sheet);
        while (currentRowSize <= firstRow) {
            sheet.createRow(currentRowSize++);
        }
        Row row = sheet.getRow(firstRow);
        int currentCellSize = this.getCellSize(row);
        while (currentCellSize <= firstCol) {
            row.createCell(currentCellSize++);
        }
        Cell cell = row.getCell(firstCol);
        if (richTextString != null) {
            cell.setCellValue(richTextString);
        }
        if (firstRow != lastRow || firstCol != lastCol) {
            CellRangeAddress mergedRegion = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
            sheet.addMergedRegion(mergedRegion);
        }
    }

    protected void addMergeCell(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        this.addMergeCell(sheet, firstRow, lastRow, firstCol, lastCol, null);
    }

    protected int getRowSize(Sheet sheet) {
        int size = sheet.getLastRowNum();
        if (size == 0) {
            return sheet.getPhysicalNumberOfRows() == 0 ? 0 : 1;
        }
        return size + 1;
    }

    protected int getCellSize(Row row) {
        return Math.max(row.getLastCellNum(), 0);
    }

    private CellStyle getHeadColumnStyle(Workbook wb) {
        if (this.headColumnStyle == null) {
            this.headColumnStyle = wb.createCellStyle();
            this.headColumnStyle.setBorderBottom(BorderStyle.THIN);
            this.headColumnStyle.setBorderTop(BorderStyle.THIN);
            this.headColumnStyle.setBorderLeft(BorderStyle.THIN);
            this.headColumnStyle.setBorderRight(BorderStyle.THIN);
            this.headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_40_PERCENT.getIndex());
            this.headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            this.headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
            this.headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            this.headColumnStyle.setHidden(false);
        }
        return this.headColumnStyle;
    }

    private void adjustColumnWidth(GLRptTableHeadInfo head, Sheet sheet) {
        int index = 0;
        for (int i = 0; i < head.getColumnSize(); ++i) {
            if (head.getTableColumnInfo(i).isHide()) continue;
            sheet.setColumnWidth((int)((short)index), head.getTableColumnInfo(i).getWidth() * 40);
            ++index;
        }
    }

    private void mergeTableHead(GLRptTableHeadInfo head, Sheet sheet, int rptHeadRowCount) {
        MergeCell[][] cells = this.getTableHeadCells(head);
        int rowCount = cells.length;
        int colCount = cells[0].length;
        int beginRow = 0;
        int beginCol = 0;
        int endRow = 0;
        int endCol = 0;
        while (endRow != rowCount - 1 || endCol != colCount - 1) {
            for (int i = beginRow; i < rowCount; ++i) {
                for (int j = beginCol; j < colCount && !cells[i][j].isMerged && cells[i][j].getValue().equals(cells[beginRow][beginCol].getValue()); ++j) {
                    endRow = i;
                    endCol = j;
                    cells[i][j].setMerged(true);
                }
            }
            this.addMergeCell(sheet, beginRow + rptHeadRowCount, endRow + rptHeadRowCount, beginCol, endCol);
            int[] beginRowCol = this.getBeginRowCol(cells);
            if (beginRowCol == null) break;
            beginRow = beginRowCol[0];
            beginCol = beginRowCol[1];
        }
    }

    private int[] getBeginRowCol(MergeCell[][] titles) {
        int rowCount = titles.length;
        int colCount = titles[0].length;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                if (titles[i][j].isMerged) continue;
                int[] rowCol = new int[]{i, j};
                return rowCol;
            }
        }
        return null;
    }

    protected CellStyle getNumericStyle(boolean isTotal, int precision) {
        CellStyle style;
        Integer key = precision;
        if (isTotal) {
            style = this.numeralTotalFormats.get(key);
            if (style == null) {
                style = this.getCellStyle(this.wb, HSSFColor.HSSFColorPredefined.LEMON_CHIFFON.getIndex());
                DataFormat format = this.wb.createDataFormat();
                style.setAlignment(HorizontalAlignment.RIGHT);
                style.setDataFormat(format.getFormat(this.getFormatterByPrecision(precision)));
                this.numeralTotalFormats.put(key, style);
            }
        } else {
            style = this.numeralFormats.get(key);
            if (style == null) {
                style = this.getCellStyle(this.wb, HSSFColor.HSSFColorPredefined.WHITE.getIndex());
                DataFormat format = this.wb.createDataFormat();
                style.setAlignment(HorizontalAlignment.RIGHT);
                style.setDataFormat(format.getFormat(this.getFormatterByPrecision(precision)));
                this.numeralFormats.put(key, style);
            }
        }
        return style;
    }

    protected CellStyle getCommStyle(boolean isTotal) {
        return isTotal ? this.commTotalStyle : this.commStyle;
    }

    protected CellStyle getTextStyle(boolean isTotal) {
        return isTotal ? this.textTotalStyle : this.textStyle;
    }

    protected String getFormatterByPrecision(int precision) {
        StringBuilder retValue = new StringBuilder("#,##0.");
        for (int i = 0; i < precision; ++i) {
            retValue.append("0");
        }
        return retValue.toString();
    }

    private CellStyle getCellStyle(Workbook wb, short bgcolor) {
        CellStyle numberStyle = wb.createCellStyle();
        numberStyle.setBorderLeft(BorderStyle.THIN);
        numberStyle.setBorderTop(BorderStyle.THIN);
        numberStyle.setBorderRight(BorderStyle.THIN);
        numberStyle.setBorderBottom(BorderStyle.THIN);
        numberStyle.setFillForegroundColor(bgcolor);
        numberStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        numberStyle.setHidden(false);
        return numberStyle;
    }

    private MergeCell[][] getTableHeadCells(GLRptTableHeadInfo head) {
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        GLRptTableHeadInfo newHead = new GLRptTableHeadInfo();
        for (int i = 0; i < head.getColumnSize(); ++i) {
            GLRptTableHeadInfo.GLRptTableColumnInfo col = head.getTableColumnInfo(i);
            if (col.isHide()) continue;
            indexs.add(new Integer(i));
        }
        String[][] ts = head.getHeadTitle();
        MergeCell[][] cells = new MergeCell[head.getHeadRowSize()][indexs.size()];
        for (int i = 0; i < cells.length; ++i) {
            for (int j = 0; j < indexs.size(); ++j) {
                cells[i][j] = new MergeCell(ts[i][(Integer)indexs.get(j)]);
            }
        }
        return cells;
    }

    private void writeFile(Workbook wb) {
        this.writeFile(wb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(Workbook wb, File file) {
        OutputStream fOut = null;
        try {
            String fileName;
            if (file != null) {
                fileName = file.getAbsolutePath();
                fOut = new FileOutputStream(file);
            } else {
                fileName = this.getTempFilename("GL");
                fOut = new FileOutputStream(new File(fileName));
            }
            wb.write(fOut);
            this.showFile(fileName);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        finally {
            try {
                if (fOut != null) {
                    fOut.flush();
                    ((FileOutputStream)fOut).close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getTempFilename(String prefix) {
        String filename;
        File excelFile = (File)this.params.get("excelFile");
        if (excelFile != null) {
            return excelFile.getAbsolutePath();
        }
        String path = System.getProperty("user.dir") + File.separator + this.getFileName() + this.exportType.getExtend();
        File uploadFilePath = new File(path);
        if (!uploadFilePath.exists()) {
            uploadFilePath.mkdirs();
        }
        String pp = path + File.separator + prefix;
        long timestamp = System.currentTimeMillis();
        File f = null;
        do {
            filename = pp + timestamp + this.exportType.getExtend();
            f = new File(filename);
            ++timestamp;
        } while (f.exists());
        return filename;
    }

    protected void showFile(String fileName) throws IOException {
        ExcelUtils.showFile(fileName);
    }

    protected GLRptBaseCondition getCond() {
        return this.cond;
    }

    public Workbook getWb() {
        return this.wb;
    }

    public void setWb(Workbook wb) {
        this.wb = wb;
    }

    protected static enum ExportType {
        XLS(65536, 256),
        XLSX(0x100000, 16384);

        int maxRowCount;
        int maxColumnCount;

        private ExportType(int maxRowCount, int maxColumnCount) {
            this.maxRowCount = maxRowCount;
            this.maxColumnCount = maxColumnCount;
        }

        public int getMaxRowCount() {
            return this.maxRowCount;
        }

        public int getMaxColumnCount() {
            return this.maxColumnCount;
        }

        public String getExtend() {
            return "." + this.name().toLowerCase();
        }
    }

    protected class MergeCell {
        String value;
        boolean isMerged = false;

        protected MergeCell(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isMerged() {
            return this.isMerged;
        }

        public void setMerged(boolean isMerged) {
            this.isMerged = isMerged;
        }
    }

    public static interface ExportLogger {
        public void info(String var1);

        public void error(String var1);
    }
}

