/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptExcelExporter;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerFacadeFactory;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptBaseFacade;
import com.kingdee.eas.util.client.EASResource;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class GLRptSubLedgerExcelExporter
extends GLRptExcelExporter {
    public GLRptSubLedgerExcelExporter(Map<String, Object> params) {
        super(params);
    }

    @Override
    protected IGLRptBaseFacade getIGLRptFacade() throws BOSException {
        return GLRptSubLedgerFacadeFactory.getRemoteInstance();
    }

    @Override
    protected int createRptHead(Sheet sheet) {
        int rowIndex = 0;
        Row row = sheet.createRow(rowIndex++);
        row.setHeightInPoints(21.75f);
        GLRptSubLedgerCondition cond = this.getCond();
        Cell cell = row.createCell(0);
        this.addMergeCell(sheet, 0, 0, 0, 3, this.buildRichTextString((String)this.params.get("Period")));
        this.addMergeCell(sheet, 0, 0, 4, 5, this.buildRichTextString((String)this.params.get("Currency")));
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.enumerate) {
            this.addMergeCell(sheet, 0, 0, 6, 7, this.buildRichTextString(cond.getCompany().getName()));
        }
        String optionPosting = cond.getOptionPosting() ? EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"include_unpostvoucher") : EASResource.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"posted_voucher");
        this.addMergeCell(sheet, 0, 0, 8, 9, this.buildRichTextString(optionPosting));
        return rowIndex;
    }

    @Override
    protected boolean isTotal(GLRptRowSet data) throws BOSException {
        boolean isTotal = false;
        Object balSeq = data.getObject("FBalSeq");
        if (balSeq == null || balSeq.toString().equals("3") || balSeq.toString().equals("4") || balSeq.toString().equals("5") || balSeq.toString().equals("6") || balSeq.toString().equals("2") && data.getString("voucherNumber") == null) {
            isTotal = true;
        }
        return isTotal;
    }

    @Override
    protected void setCellValueAndStyle(GLRptTableHeadInfo.GLRptTableColumnInfo col, Cell cell, GLRptRowSet data, boolean isTotal) throws BOSException {
        String colName = col.getColName();
        Object value = data.getObject(colName);
        CellStyle style = null;
        GLRptSubLedgerCondition cond = this.getCond();
        if (colName.equals("FLocalExchangeRate")) {
            int localExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                localExRatePre = data.getInt("FLocalExRatePre");
            }
            style = this.getNumericStyle(isTotal, localExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (colName.equals("FReportingExchangeRate")) {
            int rptExRatePre = col.getScale();
            if (cond.isAllCurrency()) {
                rptExRatePre = data.getInt("FRptExRatePre");
            }
            style = this.getNumericStyle(isTotal, rptExRatePre);
            this.setCellDoubleValue(cell, value);
        } else if (col.isNumeral()) {
            cell.setCellType(CellType.NUMERIC);
            int precision = col.getScale();
            if (cond.isAllCurrency() && colName.endsWith("For")) {
                precision = data.getInt("currencyPre");
            }
            style = this.getNumericStyle(isTotal, precision);
            this.setCellDoubleValue(cell, value);
        } else {
            style = value instanceof String && !StringUtil.isExcelNumber((String)((String)value)) && !col.getColName().toLowerCase().contains("date") ? this.getTextStyle(isTotal) : this.getCommStyle(isTotal);
            if (value != null) {
                cell.setCellValue(this.buildRichTextString(value.toString()));
            } else {
                cell.setCellValue(this.buildRichTextString(""));
            }
        }
        cell.setCellStyle(style);
    }

    @Override
    protected GLRptSubLedgerCondition getCond() {
        return (GLRptSubLedgerCondition)super.getCond();
    }

    @Override
    protected String getFileName() {
        return "subledgerTmp";
    }
}

