/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffFactory;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemCollection;
import com.kingdee.eas.basedata.assistant.CashFlowItemFactory;
import com.kingdee.eas.basedata.assistant.CashFlowItemInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICashFlowAccountDiff;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashFlowException;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CashflowInterfaceService {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.CashflowInterfaceService");
    public static final String CF_RESOURCE = "com.kingdee.eas.fi.gl.GLNRptCFResource";
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    private Context ctx;
    private Map<String, Object> params;
    protected List<String> errs = new ArrayList<String>();
    protected int balType = 5;
    protected PeriodTypeInfo periodType = null;
    protected String periodTypeId = null;
    protected Integer fromPeriodNumber = 0;
    protected Integer toPeriodNumber = 0;
    protected String T_TMP_AmountTable = null;
    protected String T_TMP_YearSumTable = null;
    protected String T_TMP_InitDataTable = null;
    protected String T_TMP_DataTable = null;
    private ExecutorService executor;
    private Set<String> tempTables = new HashSet<String>();
    protected Map<String, Object> result = new HashMap<String, Object>();
    protected List<List<String>> rows = new ArrayList<List<String>>();
    protected boolean includeInvisibleItem = false;
    protected boolean includeSupplementItem = false;
    private Map<String, Integer> colIndexes = new HashMap<String, Integer>();
    protected Map<String, String> accountTableIds = new HashMap<String, String>();
    protected List<CompanyOrgUnitInfo> allBizCompanys = new ArrayList<CompanyOrgUnitInfo>();
    protected Map<String, PeriodInfo[]> periodss = null;
    private Map<List<String>, String> periodListsStr = new HashMap<List<String>, String>();
    protected Map<String, List<String>> periodIdLists = new HashMap<String, List<String>>();
    private CurrencyCollection currencys = null;
    private boolean itemFilter = false;
    private Set<String> itemNumbers = null;
    private List<CashFlowItemInfo> items = null;
    private List<CashFlowItemInfo> leafItems = null;
    private String leafItemsIdsStr = null;
    private boolean isIncludeGRC = false;
    private boolean isIncludeGLC = false;
    private Map<String, String> itemViewSqls = new HashMap<String, String>();
    private Map<String, Object> hgs = new HashMap<String, Object>();
    private Map<String, String> hgIdToAsstAccountIds = new HashMap<String, String>();
    private Map<String, List<AsstActTypeInfo>> asstActTypess = new HashMap<String, List<AsstActTypeInfo>>();
    private boolean isColumnAlias = false;
    private String COLUMN_ITEM_NUMBER = "itemNumber";
    private String COLUMN_COMPANY_NUMBER = "companyNumber";
    private String COLUMN_CURRENCY_NUMBER = "currencyNumber";
    private String COLUMN_BEGIN_PERIOD = "fromPeriodNumber";
    private String COLUMN_END_PERIOD = "toPeriodNumber";
    private String COLUMN_TYPE = "type";
    private String COLUMN_AMOUNT = "amount";
    private String COLUMN_YEAR_SUM = "yearSum";
    private String COLUMN_ASSTACT_TYPE_NUMBER = "asstActTypeNumber";
    private String COLUMN_ASSTACT_NUMBER = "asstActNumber";
    private String COLUMN_ITEM_NAME = "itemName";
    private String COLUMN_ITEM_LONGNUMBER = "itemLongNumber";
    private String COLUMN_COMPANY_NAME = "companyName";
    private String COLUMN_COMPANY_LONGNUMBER = "companyLongNumber";
    private String COLUMN_HG_ID = "hgID";
    private String COLUMN_ASSTACT_ID = "asstActID";
    private String COLUMN_ASSTACT_NAME = "asstActName";
    private Set<String> supportExQueryColumns = null;
    private Set<String> exQueryColumns = new HashSet<String>();
    private int colCount = 0;

    public CashflowInterfaceService(Context ctx, Map<String, Object> params) {
        this.ctx = ctx;
        this.params = params;
        this.result.put("rows", this.rows);
        this.result.put("errs", this.errs);
    }

    public Map executeQuery() throws BOSException, EASBizException, SQLException {
        if (!this.beforeQuery()) {
            return this.result;
        }
        try {
            this.doExecuteQuery();
            Map<String, Object> map = this.result;
            return map;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            this.afterQuery();
        }
    }

    public void doExecuteQuery() throws Exception {
        this.validateAllBizCompanys();
        if (this.allBizCompanys.isEmpty()) {
            return;
        }
        if (!this.includeInvisibleItem) {
            this.selectItemViewSQL();
        }
        this.createDataTable();
        this.multiThreadProcess();
        this.mergeTempTables();
        this.insertDetailItemEmptyData();
        this.insertItemSumData();
        this.buildData();
    }

    private void buildData() throws BOSException, SQLException {
        this.buildTableHead();
        String selectSQL = this.getSelectSQL();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSQL);
        HashSet<String> hgIds = new HashSet<String>();
        while (rs.next()) {
            String hgID = rs.getString("hgID");
            if (hgID == null || hgID.trim().length() <= 0) continue;
            hgIds.add(hgID);
        }
        this.cacheHgs(this.ctx, this.groupHgIds(this.ctx, hgIds));
        rs.beforeFirst();
        while (rs.next()) {
            if (!this.itemFilter) {
                List<String> list = this.buildRow(rs);
                this.rows.add(list);
                continue;
            }
            String itemNumber = rs.getString("itemNumber");
            if (this.itemNumbers == null || !this.itemNumbers.contains(itemNumber)) continue;
            List<String> list = this.buildRow(rs);
            this.rows.add(list);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> buildRow(IRowSet rs) throws SQLException, BOSException {
        ArrayList<String> list = new ArrayList<String>(this.colCount);
        String itemNumber = rs.getString("itemNumber");
        list.add(itemNumber);
        if (this.exQueryColumns.contains(this.COLUMN_ITEM_NAME)) {
            String itemName = rs.getString("itemName");
            list.add(itemName);
        }
        if (this.exQueryColumns.contains(this.COLUMN_ITEM_LONGNUMBER)) {
            String itemLongNumber = rs.getString("itemLongNumber");
            list.add(itemLongNumber);
        }
        String companyNumber = rs.getString("companyNumber");
        list.add(companyNumber);
        if (this.exQueryColumns.contains(this.COLUMN_COMPANY_NAME)) {
            String companyName = rs.getString("companyName");
            list.add(companyName);
        }
        if (this.exQueryColumns.contains(this.COLUMN_COMPANY_LONGNUMBER)) {
            String companyLongNumber = rs.getString("companyLongNumber");
            list.add(companyLongNumber);
        }
        String currencyID = rs.getString("currencyID");
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(currencyID)) {
            list.add("GLC");
        } else if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(currencyID)) {
            list.add("GRC");
        } else {
            CurrencyInfo currency = this.currencys.get((Object)BOSUuid.read((String)currencyID));
            list.add(currency != null ? currency.getNumber() : null);
        }
        list.add(this.fromPeriodNumber.toString());
        list.add(this.toPeriodNumber.toString());
        BigDecimal amount = rs.getBigDecimal("amount");
        list.add(amount == null ? BigDecimal.ZERO.toString() : amount.toPlainString());
        BigDecimal yearSum = rs.getBigDecimal("yearSum");
        list.add(yearSum == null ? BigDecimal.ZERO.toString() : yearSum.toPlainString());
        int type = rs.getInt("type");
        list.add(String.valueOf(type));
        String hgID = rs.getString("hgID");
        if (this.exQueryColumns.contains(this.COLUMN_HG_ID)) {
            list.add(hgID);
        }
        if (StringUtils.isEmpty((String)hgID)) return list;
        Map hg = (Map)this.hgs.get(hgID);
        List<AsstActTypeInfo> asstActTypes = this.getAsstActTypes(this.ctx, this.hgIdToAsstAccountIds.get(hgID));
        if (hg == null || asstActTypes == null) return list;
        for (int k = 0; k < asstActTypes.size(); ++k) {
            String number;
            AsstActTypeInfo asstActType = asstActTypes.get(k);
            list.add(asstActType.getNumber());
            if (this.exQueryColumns.contains(this.COLUMN_ASSTACT_ID)) {
                list.add((String)hg.get(asstActType.getNumber() + ".id"));
            }
            if (asstActType.isUseLongNumber()) {
                number = (String)hg.get(asstActType.getNumber() + ".longNumber");
                if (number != null) {
                    number = number.replace('!', '.');
                }
            } else {
                number = (String)hg.get(asstActType.getNumber() + ".number");
            }
            list.add(number);
            if (!this.exQueryColumns.contains(this.COLUMN_ASSTACT_NAME)) continue;
            list.add((String)hg.get(asstActType.getNumber() + ".name"));
        }
        return list;
    }

    private void cacheHgs(Context ctx, Map<String, Set<String>> hgIdss) throws BOSException {
        for (String asstAccountId : hgIdss.keySet()) {
            Set<String> tempIds = hgIdss.get(asstAccountId);
            Set<Object> hgIds = new HashSet();
            if (this.hgs.size() == 0) {
                hgIds = tempIds;
            } else {
                for (String tempId : tempIds) {
                    if (this.hgs.containsKey(tempId)) continue;
                    hgIds.add(tempId);
                }
            }
            if (hgIds.size() <= 0) continue;
            try {
                Map<String, Object> map = GLAsstAccountUtils.getAssistantHgs(ctx, asstAccountId, this.getAsstActTypes(ctx, asstAccountId), hgIds);
                this.hgs.putAll(map);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private List<AsstActTypeInfo> getAsstActTypes(Context ctx, String asstAccountId) throws BOSException {
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        AsstActTypeCollection aats = VoucherProcessCache.getAsstActTypes(ctx, asstAccountId);
        ArrayList<AsstActTypeInfo> asstActTypes = new ArrayList<AsstActTypeInfo>(aats.size());
        for (AsstActTypeInfo aat : aats) {
            aat.put("showId", (Object)this.exQueryColumns.contains(this.COLUMN_ASSTACT_ID));
            if (aat.isUseLongNumber()) {
                aat.put("showNumber", (Object)false);
                aat.put("showLongNumber", (Object)true);
            }
            aat.put("showName", (Object)this.exQueryColumns.contains(this.COLUMN_ASSTACT_NAME));
            asstActTypes.add(aat);
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    private Map<String, Set<String>> groupHgIds(Context ctx, Set<String> hgIds) throws BOSException {
        HashMap<String, Set<String>> hgIdss = new HashMap<String, Set<String>>();
        if (hgIds.size() <= 0) {
            return hgIdss;
        }
        String sql = "select FID, FAsstAccountID from T_BD_AssistantHG where FID in ";
        List<Set<String>> batchs = GlUtils.split(hgIds, 100);
        try {
            for (Set<String> batch : batchs) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql + SQLUtil.buildMarkSQL(batch.size())), (Object[])batch.toArray());
                while (rs.next()) {
                    String asstAccountId = rs.getString("FAsstAccountID");
                    if (asstAccountId == null) continue;
                    HashSet<String> set = (HashSet<String>)hgIdss.get(asstAccountId);
                    if (set == null) {
                        set = new HashSet<String>();
                        hgIdss.put(asstAccountId, set);
                    }
                    String hgId = rs.getString("FID");
                    set.add(hgId);
                    this.hgIdToAsstAccountIds.put(hgId, asstAccountId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hgIdss;
    }

    protected String getString(Context ctx, String resName) {
        return ResourceBase.getString((String)CF_RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    private void buildTableHead() {
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> columnAliases = new ArrayList<String>();
        int idx = 0;
        list.add(this.COLUMN_ITEM_NUMBER);
        columnAliases.add(this.getString(this.ctx, this.COLUMN_ITEM_NUMBER));
        this.colIndexes.put(this.COLUMN_COMPANY_NUMBER, idx++);
        if (this.exQueryColumns.contains(this.COLUMN_ITEM_NAME)) {
            list.add(this.COLUMN_ITEM_NAME);
            columnAliases.add(this.getString(this.ctx, this.COLUMN_ITEM_NAME));
            this.colIndexes.put(this.COLUMN_ITEM_NAME, idx++);
        }
        if (this.exQueryColumns.contains(this.COLUMN_ITEM_LONGNUMBER)) {
            list.add(this.COLUMN_ITEM_LONGNUMBER);
            columnAliases.add(this.getString(this.ctx, this.COLUMN_ITEM_LONGNUMBER));
            this.colIndexes.put(this.COLUMN_ITEM_LONGNUMBER, idx++);
        }
        list.add(this.COLUMN_COMPANY_NUMBER);
        columnAliases.add(this.getString(this.ctx, this.COLUMN_COMPANY_NUMBER));
        this.colIndexes.put(this.COLUMN_COMPANY_NUMBER, idx++);
        if (this.exQueryColumns.contains(this.COLUMN_COMPANY_NAME)) {
            list.add(this.COLUMN_COMPANY_NAME);
            columnAliases.add(this.getString(this.ctx, this.COLUMN_COMPANY_NAME));
            this.colIndexes.put(this.COLUMN_COMPANY_NAME, idx++);
        }
        if (this.exQueryColumns.contains(this.COLUMN_COMPANY_LONGNUMBER)) {
            list.add(this.COLUMN_COMPANY_LONGNUMBER);
            columnAliases.add(this.getString(this.ctx, this.COLUMN_COMPANY_LONGNUMBER));
            this.colIndexes.put(this.COLUMN_COMPANY_LONGNUMBER, idx++);
        }
        list.add(this.COLUMN_CURRENCY_NUMBER);
        columnAliases.add(this.getString(this.ctx, this.COLUMN_CURRENCY_NUMBER));
        this.colIndexes.put(this.COLUMN_CURRENCY_NUMBER, idx++);
        list.add(this.COLUMN_BEGIN_PERIOD);
        columnAliases.add(this.getString(this.ctx, this.COLUMN_BEGIN_PERIOD));
        this.colIndexes.put(this.COLUMN_BEGIN_PERIOD, idx++);
        list.add(this.COLUMN_END_PERIOD);
        columnAliases.add(this.getString(this.ctx, this.COLUMN_END_PERIOD));
        this.colIndexes.put(this.COLUMN_END_PERIOD, idx++);
        list.add(this.COLUMN_AMOUNT);
        columnAliases.add(this.getString(this.ctx, this.COLUMN_AMOUNT));
        this.colIndexes.put(this.COLUMN_AMOUNT, idx++);
        list.add(this.COLUMN_YEAR_SUM);
        columnAliases.add(this.getString(this.ctx, this.COLUMN_YEAR_SUM));
        this.colIndexes.put(this.COLUMN_YEAR_SUM, idx++);
        list.add(this.COLUMN_TYPE);
        columnAliases.add(this.getString(this.ctx, this.COLUMN_TYPE));
        this.colIndexes.put(this.COLUMN_TYPE, idx++);
        if (this.exQueryColumns.contains(this.COLUMN_HG_ID)) {
            list.add(this.COLUMN_HG_ID);
            columnAliases.add(this.getString(this.ctx, this.COLUMN_HG_ID));
            this.colIndexes.put(this.COLUMN_HG_ID, idx++);
        }
        for (int i = 1; i <= 8; ++i) {
            list.add(this.COLUMN_ASSTACT_TYPE_NUMBER + i);
            columnAliases.add(this.getString(this.ctx, this.COLUMN_ASSTACT_TYPE_NUMBER) + i);
            this.colIndexes.put(this.COLUMN_ASSTACT_TYPE_NUMBER + i, idx++);
            if (this.exQueryColumns.contains(this.COLUMN_ASSTACT_ID)) {
                list.add(this.COLUMN_ASSTACT_ID + i);
                columnAliases.add(this.getString(this.ctx, this.COLUMN_ASSTACT_ID) + i);
                this.colIndexes.put(this.COLUMN_ASSTACT_ID + i, idx++);
            }
            list.add(this.COLUMN_ASSTACT_NUMBER + i);
            columnAliases.add(this.getString(this.ctx, this.COLUMN_ASSTACT_NUMBER) + i);
            this.colIndexes.put(this.COLUMN_ASSTACT_NUMBER + i, idx++);
            if (!this.exQueryColumns.contains(this.COLUMN_ASSTACT_NAME)) continue;
            list.add(this.COLUMN_ASSTACT_NAME + i);
            columnAliases.add(this.getString(this.ctx, this.COLUMN_ASSTACT_NAME) + i);
            this.colIndexes.put(this.COLUMN_ASSTACT_NAME + i, idx++);
        }
        this.colCount = list.size();
        this.rows.add(list);
        if (this.isColumnAlias) {
            this.rows.add(columnAliases);
        }
    }

    private String getSelectSQL() {
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        StringBuilder sql = new StringBuilder();
        sql.append("select");
        sql.append("    item.FNumber itemNumber, \n");
        if (this.exQueryColumns.contains(this.COLUMN_ITEM_NAME)) {
            sql.append("    item.FName_" + loc + " itemName, \n");
        }
        if (this.exQueryColumns.contains(this.COLUMN_ITEM_LONGNUMBER)) {
            sql.append("    item.FLongNumber itemLongNumber, \n");
        }
        sql.append("    company.FNumber companyNumber, \n");
        if (this.exQueryColumns.contains(this.COLUMN_COMPANY_NAME)) {
            sql.append("    company.FName_" + loc + " companyName, \n");
        }
        if (this.exQueryColumns.contains(this.COLUMN_COMPANY_LONGNUMBER)) {
            sql.append("    company.FLongNumber companyLongNumber, \n");
        }
        sql.append("    tt.currencyID currencyID, \n");
        sql.append("    tt.hgID hgID, \n");
        sql.append("    tt.FType type, \n");
        sql.append("    tt.amount amount, \n");
        sql.append("    tt.yearSum yearSum \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("inner join t_bd_cashFlowItem item on tt.cashFlowItemID = item.fid \n");
        sql.append("inner join t_org_company company on tt.companyID = company.fid \n");
        sql.append("where item.FType in (0,1) \n");
        sql.append("order by company.FLongNumber,tt.currencyID,item.FLongNumber  \n");
        return sql.toString();
    }

    protected void afterQuery() throws BOSException, EASBizException {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.executor = null;
        }
        for (String tempTable : this.tempTables) {
            try {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
            }
            catch (Throwable throwable) {}
        }
        this.tempTables.clear();
    }

    private void selectItemViewSQL() throws BOSException, EASBizException {
        for (int i = 0; i < this.allBizCompanys.size(); ++i) {
            CompanyOrgUnitInfo company = this.allBizCompanys.get(i);
            String itemViewSql = this.getItemViewSql(this.ctx, company.getCU().getId().toString());
            this.itemViewSqls.put(company.getId().toString(), itemViewSql);
        }
    }

    private String getItemViewSql(Context ctx, String ctrlUnitId) throws BOSException, EASBizException {
        INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
        OrgStructureCollection structCol = iNOV.buildViewSuperiorCollection(ctrlUnitId, "00000000-0000-0000-0000-0000000000014F2827FD");
        String[] cuids = new String[structCol.size() + 1];
        int n = structCol.size();
        for (int i = 0; i < n; ++i) {
            OrgStructureInfo structInfo = structCol.get(i);
            cuids[i] = structInfo.getUnit().getId().toString();
        }
        cuids[cuids.length - 1] = ctrlUnitId;
        StringBuilder schemaSql = new StringBuilder("select sc.fid,sc.FCtrlUnitID from t_bd_cashFlowItemViewSchema sc,T_ORG_CtrlUnit cu where cu.fid = sc.FCtrlUnitID and sc.FCtrlUnitID in (").append(this.stringArrayToString(cuids)).append(") order by cu.FLongNumber desc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)schemaSql.toString());
        try {
            if (rs.next()) {
                String schemaId = rs.getString("fid");
                String cuId = rs.getString("FCtrlUnitID");
                StringBuilder itemSql = new StringBuilder(" in (Select civ.FcashFlowItemID from t_bd_cashFlowItemView civ where civ.FCtrlUnitID = '").append(cuId).append("' and civ.FSchemaID = '").append(schemaId).append("')");
                return itemSql.toString();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void mergeTempTables() throws BOSException {
        String detailSql = this.getDetailItemDataSQL();
        StringBuilder sql = new StringBuilder();
        sql.append("insert into  \n");
        sql.append(this.T_TMP_DataTable).append(" ( \n");
        sql.append("   companyID,\n");
        sql.append("   currencyID,\n");
        sql.append("   cashFlowItemID,\n");
        sql.append("   hgID,\n");
        sql.append("   FType,\n");
        sql.append("   amount,\n");
        sql.append("   yearSum");
        sql.append(" ) \n");
        sql.append(detailSql);
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getDetailItemDataSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("select\n");
        sql.append("    case when t.companyID is null then idt.companyID else t.companyID end  as companyID,\n");
        sql.append("    case when t.currencyID is null then idt.currencyID else t.currencyID end  as currencyID,\n");
        sql.append("    case when t.cashFlowItemID is null then idt.cashFlowItemID else t.cashFlowItemID end  as cashFlowItemID,\n");
        sql.append("    case when t.cashFlowItemID is null then idt.hgID else t.hgID end  as hgID,\n");
        sql.append("    case when t.cashFlowItemID is null then idt.FType else t.FType end  as FType,\n");
        sql.append("    isnull(t.amount,0) as amount,\n");
        sql.append("    case when t.cashFlowItemID is null then isnull(idt.yearSum,0) else (isnull(idt.yearSum,0) + isnull(t.yearSum,0)) end  as yearSum\n");
        sql.append("from\n");
        sql.append("    (\n");
        sql.append("        select\n");
        sql.append("            case when yst.companyID is null then ate.companyID else yst.companyID end as companyID,\n");
        sql.append("            case when yst.currencyID is null then ate.currencyID else yst.currencyID end as currencyID,\n");
        sql.append("            case when yst.cashFlowItemID is null then ate.cashFlowItemID else yst.cashFlowItemID end as cashFlowItemID,\n");
        sql.append("            case when yst.cashFlowItemID is null then ate.hgID else yst.hgID end as hgID,\n");
        sql.append("            case when yst.cashFlowItemID is null then ate.FType else yst.FType end as FType,\n");
        sql.append("            ate.amount as amount,\n");
        sql.append("            yst.yearSum as yearSum\n");
        sql.append("        from ").append(this.T_TMP_YearSumTable).append(" yst\n");
        sql.append("        full join ").append(this.T_TMP_AmountTable).append(" ate  on yst.companyID = ate.companyID and yst.currencyID = ate.currencyID and yst.cashFlowItemID =  ate.cashFlowItemID");
        sql.append("  and  yst.hgID = ate.hgID\n");
        sql.append("    ) t\n");
        sql.append("    full join ").append(this.T_TMP_InitDataTable).append(" idt on t.companyID = idt.companyID and t.currencyID = idt.currencyID and t.cashFlowItemID =  idt.cashFlowItemID");
        sql.append("  and  t.hgID = idt.hgID\n");
        return sql.toString();
    }

    private void insertItemSumData() throws BOSException, SQLException {
        int maxLevel = this.getItemMaxLevel();
        StringBuilder sql = new StringBuilder();
        sql.append("insert into  \n");
        sql.append(this.T_TMP_DataTable).append(" ( \n");
        sql.append("   companyID,\n");
        sql.append("   currencyID,\n");
        sql.append("   cashFlowItemID,\n");
        sql.append("   amount,\n");
        sql.append("   yearSum\n");
        sql.append(" ) \n");
        sql.append("  select \n");
        sql.append("      tt.companyID, \n");
        sql.append("      tt.currencyID, \n");
        sql.append("      item.FParentID, \n");
        sql.append("      sum(tt.amount * (case item.FDirection when 2 then -1 else 1 end) * (case pitem.FDirection when 2 then -1 else 1 end) ), \n");
        sql.append("      sum(tt.yearSum * (case item.FDirection when 2 then -1 else 1 end) * (case pitem.FDirection when 2 then -1 else 1 end)) \n");
        sql.append("  from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("  inner join t_bd_cashFlowItem item on tt.cashFlowItemID = item.fid  \n");
        sql.append("  inner join t_bd_cashFlowItem pitem on item.FParentID = pitem.fid  \n");
        sql.append("  where item.FLevel = ? \n");
        sql.append("  group by tt.companyID, tt.currencyID, item.FParentID \n");
        while (maxLevel > 1) {
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{maxLevel--});
        }
    }

    private int getItemMaxLevel() throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)"select max(FLevel) maxLevel from t_bd_cashFlowItem");
        if (rs.next()) {
            int maxLevel = rs.getInt("maxLevel");
            return maxLevel;
        }
        return 6;
    }

    private void insertDetailItemEmptyData() throws BOSException {
        if (!this.itemFilter) {
            StringBuilder sql = new StringBuilder();
            sql.append("insert into  \n");
            sql.append(this.T_TMP_DataTable).append(" ( \n");
            sql.append("   companyID,\n");
            sql.append("   currencyID,\n");
            sql.append("   cashFlowItemID,\n");
            sql.append("   amount,\n");
            sql.append("   yearSum");
            sql.append(" ) \n");
            sql.append("    select \n");
            sql.append("        ?,  \n");
            sql.append("        ?,  \n");
            sql.append("        item.fid,  \n");
            sql.append("        0,  \n");
            sql.append("        0   \n");
            sql.append("    from t_bd_cashFlowItem item \n");
            sql.append("    where item.FisLeaf = 1 \n");
            if (!this.includeSupplementItem) {
                sql.append("and item.FType = 0 \n");
            }
            sql.append("    and not exists (select tt.cashFlowItemID from ").append(this.T_TMP_DataTable).append(" tt where tt.cashFlowItemID = item.fid and tt.companyID = ? and tt.currencyID = ?) \n");
            for (CompanyOrgUnitInfo company : this.allBizCompanys) {
                String currencyID;
                int length;
                ArrayList<String> params = new ArrayList<String>();
                String companyID = company.getId().toString();
                for (int i = 0; i < this.currencys.size(); ++i) {
                    CurrencyInfo currencyInfo = this.currencys.get(i);
                    int length2 = sql.length();
                    if (!this.includeInvisibleItem && this.itemViewSqls.get(companyID) != null) {
                        sql.append(" and item.fid " + this.itemViewSqls.get(companyID));
                    }
                    String currencyID2 = currencyInfo.getId().toString();
                    params.add(companyID);
                    params.add(currencyID2);
                    params.add(companyID);
                    params.add(currencyID2);
                    DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
                    params.clear();
                    sql.setLength(length2);
                }
                if (this.isIncludeGLC) {
                    length = sql.length();
                    if (!this.includeInvisibleItem && this.itemViewSqls.get(companyID) != null) {
                        sql.append(" and item.fid " + this.itemViewSqls.get(companyID));
                    }
                    currencyID = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
                    params.add(companyID);
                    params.add(currencyID);
                    params.add(companyID);
                    params.add(currencyID);
                    DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
                    params.clear();
                    sql.setLength(length);
                }
                if (!this.isIncludeGRC) continue;
                length = sql.length();
                if (!this.includeInvisibleItem && this.itemViewSqls.get(companyID) != null) {
                    sql.append(" and item.fid " + this.itemViewSqls.get(companyID));
                }
                currencyID = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
                params.add(companyID);
                params.add(currencyID);
                params.add(companyID);
                params.add(currencyID);
                DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
                params.clear();
                sql.setLength(length);
            }
        } else {
            StringBuilder sql = new StringBuilder();
            sql.append("insert into  \n");
            sql.append(this.T_TMP_DataTable).append(" ( \n");
            sql.append("   companyID,\n");
            sql.append("   currencyID,\n");
            sql.append("   cashFlowItemID,\n");
            sql.append("   amount,\n");
            sql.append("   yearSum");
            sql.append(" ) \n");
            sql.append("    select \n");
            sql.append("        ?,  \n");
            sql.append("        ?,  \n");
            sql.append("        item.fid,  \n");
            sql.append("        0,  \n");
            sql.append("        0   \n");
            sql.append("    from t_bd_cashFlowItem item \n");
            sql.append("    where ").append(" item.fid in (").append(this.getItemIdsStr(this.leafItems)).append(") \n");
            sql.append("    and item.FisLeaf = 1 \n");
            if (!this.includeSupplementItem) {
                sql.append("and item.FType = 0 \n");
            }
            sql.append("    and not exists (select tt.cashFlowItemID from ").append(this.T_TMP_DataTable).append(" tt where tt.cashFlowItemID = item.fid and tt.companyID = ? and tt.currencyID = ? ) ");
            for (CompanyOrgUnitInfo company : this.allBizCompanys) {
                ArrayList<String> params = new ArrayList<String>();
                String companyID = company.getId().toString();
                for (int i = 0; i < this.currencys.size(); ++i) {
                    CurrencyInfo currencyInfo = this.currencys.get(i);
                    String currencyID = currencyInfo.getId().toString();
                    params.add(companyID);
                    params.add(currencyID);
                    params.add(companyID);
                    params.add(currencyID);
                    DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
                    params.clear();
                }
                if (this.isIncludeGLC) {
                    String currencyID = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
                    params.add(companyID);
                    params.add(currencyID);
                    params.add(companyID);
                    params.add(currencyID);
                    DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
                    params.clear();
                }
                if (!this.isIncludeGRC) continue;
                String currencyID = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
                params.add(companyID);
                params.add(currencyID);
                params.add(companyID);
                params.add(currencyID);
                DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
                params.clear();
            }
        }
    }

    private void selectAmountAndYearSum(CountDownLatch latch) throws BOSException, EASBizException, InterruptedException {
        for (CompanyOrgUnitInfo company : this.allBizCompanys) {
            PeriodInfo[] periods = this.periodss.get(company.getId().toString());
            PeriodInfo startPeriod = periods[0];
            List<String> periodIdListForCur = this.getPeriodRangeForCur(this.ctx, company, this.fromPeriodNumber, this.toPeriodNumber);
            List<String> periodIdListForSum = this.getPeriodRangeForSum(this.ctx, company, startPeriod.getNumber(), this.toPeriodNumber);
            List<CashFlowItemType> cashFlowItemTypes = Arrays.asList(CashFlowItemType.MASTER_TABLE_ITEM, CashFlowItemType.SECONDARY_TABLE_ITEM);
            boolean needInitData = startPeriod.getPeriodYear() == this.toPeriodNumber / 100;
            for (CashFlowItemType cashFlowItemType : cashFlowItemTypes) {
                if (!this.includeSupplementItem && cashFlowItemType == CashFlowItemType.SECONDARY_TABLE_ITEM) {
                    latch.countDown();
                    continue;
                }
                needInitData = needInitData && cashFlowItemType == CashFlowItemType.MASTER_TABLE_ITEM;
                this.getExecutor().execute(new SubTask(this.ctx, company, periodIdListForCur, periodIdListForSum, cashFlowItemType, needInitData, latch));
            }
        }
    }

    private void multiThreadProcess() throws BOSException, EASBizException, InterruptedException {
        int latchSize = this.allBizCompanys.size() * 2;
        if (this.includeSupplementItem) {
            latchSize += this.allBizCompanys.size();
        }
        CountDownLatch latch = new CountDownLatch(latchSize);
        this.selectAmountAndYearSum(latch);
        this.processRetainedProfit(latch);
        latch.await();
    }

    private void processRetainedProfit(CountDownLatch latch) {
        if (this.includeSupplementItem) {
            for (CompanyOrgUnitInfo bizCompany : this.allBizCompanys) {
                this.getExecutor().execute(new RetainProfitTask(bizCompany, latch));
            }
        }
    }

    private String stringArrayToString(String[] ids) {
        StringBuilder strIds = new StringBuilder();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    strIds.append(",");
                }
                strIds.append("'").append(ids[i]).append("'");
            }
        }
        return strIds.toString();
    }

    private List<String> getPeriodRangeForCur(Context ctx, CompanyOrgUnitInfo company, int fromPeriodNumber, int toPeriodNumber) throws BOSException {
        return this.getPeriodIdByNumberRange(ctx, company.getId().toString(), fromPeriodNumber, toPeriodNumber);
    }

    private List<String> getPeriodRangeForSum(Context ctx, CompanyOrgUnitInfo company, int startPeriodNumber, int toPeriodNumber) throws BOSException, EASBizException {
        int toYear = toPeriodNumber / 100;
        if (startPeriodNumber / 100 == toYear) {
            return this.getPeriodIdByNumberRange(ctx, company.getId().toString(), startPeriodNumber, toPeriodNumber);
        }
        int periodNumber = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)toYear, (String)company.getId().toString());
        return this.getPeriodIdByNumberRange(ctx, company.getId().toString(), toYear * 100 + periodNumber, toPeriodNumber);
    }

    private String getItemIdsStr(List<CashFlowItemInfo> items) {
        if (this.leafItemsIdsStr != null && !this.leafItemsIdsStr.trim().isEmpty()) {
            return this.leafItemsIdsStr;
        }
        String[] ids = new String[items.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = items.get(i).getId().toString();
        }
        this.leafItemsIdsStr = this.stringArrayToString(ids);
        return this.leafItemsIdsStr;
    }

    public String getPeriodIdsStr(List<String> idList) {
        if (this.periodListsStr.containsKey(idList)) {
            return this.periodListsStr.get(idList);
        }
        String[] ids = idList.toArray(new String[idList.size()]);
        String periodListStr = this.stringArrayToString(ids);
        this.periodListsStr.put(idList, periodListStr);
        return periodListStr;
    }

    public List<String> getPeriodIdByNumberRange(Context ctx, String companyId, Integer startPeriod, Integer endPeriod) throws BOSException {
        String key = companyId + "_" + startPeriod + "_" + endPeriod;
        if (this.periodIdLists.containsKey(key)) {
            return this.periodIdLists.get(key);
        }
        if (!companyId.contains("'")) {
            companyId = "'" + companyId + "'";
        }
        StringBuilder periodSql = new StringBuilder();
        periodSql.append("select distinct p.fid fid");
        periodSql.append(" from t_bd_period p");
        periodSql.append(" inner join t_org_company c on c.faccountperiodid = p.FTypeid");
        periodSql.append(" where p.fnumber >= " + startPeriod + " and p.fnumber <= " + endPeriod + " and c.fid in (" + companyId + ")");
        IRowSet rowSet = null;
        if (this.periodTypeId != null) {
            periodSql.append(" and p.FTypeid = ?");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)periodSql.toString(), (Object[])new Object[]{this.periodTypeId});
        } else {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)periodSql.toString());
        }
        ArrayList<String> periodIdList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("fid");
                if (periodIdList.contains(id)) continue;
                periodIdList.add(id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.periodIdLists.put(key, periodIdList);
        return periodIdList;
    }

    protected synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            int maxSize;
            int coreSize = this.allBizCompanys.size() * (this.includeSupplementItem ? 2 : 1);
            if (coreSize > (maxSize = Runtime.getRuntime().availableProcessors())) {
                coreSize = maxSize;
            }
            this.executor = new ThreadPoolExecutor(coreSize, maxSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        return this.executor;
    }

    protected void createDataTable() throws Exception {
        this.T_TMP_AmountTable = this.createDataTable(false, false);
        this.T_TMP_YearSumTable = this.createDataTable(true, false);
        this.T_TMP_InitDataTable = this.createDataTable(true, false);
        this.T_TMP_DataTable = this.createDataTable(true, true);
    }

    protected String createDataTable(boolean isYearSum, boolean isDataTbl) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("create table T_TMP_DataTable ( \n");
        sql.append(" companyID VARCHAR(44), \n");
        sql.append(" currencyID VARCHAR(44), \n");
        sql.append(" cashFlowItemID VARCHAR(44), \n");
        sql.append(" hgID VARCHAR(44) DEFAULT ' ', \n");
        sql.append(" FType int DEFAULT 1, \n");
        if (!isDataTbl) {
            if (!isYearSum) {
                sql.append("  amount         NUMERIC(29,10)  DEFAULT 0   ");
            } else {
                sql.append("  yearSum         NUMERIC(29,10) DEFAULT 0  ");
            }
        } else {
            sql.append("  amount         NUMERIC(29,10)  DEFAULT 0 ,  \n");
            sql.append("  yearSum        NUMERIC(29,10)  DEFAULT 0  \n");
        }
        sql.append(" )");
        return this.createTempTable(sql.toString(), true);
    }

    protected String createTempTable(String createSQL, boolean release) throws Exception {
        String tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createSQL);
        if (release) {
            this.tempTables.add(tempTable);
        }
        return tempTable;
    }

    private boolean beforeQuery() throws BOSException, SQLException {
        String[] splits;
        Object strs;
        this.isColumnAlias = "true".equals(this.params.get("isColumnAlias") == null ? "false" : this.params.get("isColumnAlias").toString());
        Object param = this.params.get("companyNumber");
        if (param == null || param.toString().trim().length() == 0) {
            this.appendErr("companyNumber", "", ResourceBase.getString((String)RESOURCE, (String)"needCompanyNumber_foundNull", (Locale)this.ctx.getLocale()));
            return false;
        }
        String companyNumber = param.toString().trim();
        HashSet<String> companyNumbers = new HashSet<String>();
        if (companyNumber.indexOf(";") >= 0) {
            strs = companyNumber.split(";");
            for (String str : strs) {
                if (str.trim().length() <= 0) continue;
                companyNumbers.add(str.trim());
            }
        } else {
            companyNumbers.add(companyNumber);
        }
        if (companyNumbers.size() == 0) {
            this.appendErr("companyNumber", companyNumber, ResourceBase.getString((String)RESOURCE, (String)"needCompanyNumber_foundNull", (Locale)this.ctx.getLocale()));
            return false;
        }
        this.allBizCompanys = this.getCompanys(companyNumbers);
        if ((this.allBizCompanys == null || this.allBizCompanys.isEmpty()) && (strs = companyNumbers.iterator()).hasNext()) {
            String number = (String)strs.next();
            this.appendErr("companyNumber", number, ResourceBase.getString((String)RESOURCE, (String)"companyNotFound", (Locale)this.ctx.getLocale()));
            return false;
        }
        Iterator<CompanyOrgUnitInfo> itr = this.allBizCompanys.iterator();
        while (itr.hasNext()) {
            CompanyOrgUnitInfo company = itr.next();
            if (company.isIsBizUnit()) continue;
            this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)CF_RESOURCE, (String)"not_support_virtualOrg", (Locale)this.ctx.getLocale()));
            itr.remove();
        }
        param = this.params.get("balType");
        if (param != null && param.toString().trim().length() > 0) {
            String str = param.toString().trim();
            if ("5".equals(str)) {
                this.balType = 5;
            } else if ("1".equals(str)) {
                this.balType = 1;
            } else {
                this.appendErr("balType", str, ResourceBase.getString((String)RESOURCE, (String)"balTypeError", (Locale)this.ctx.getLocale()));
                return false;
            }
        }
        if ((param = this.params.get("periodTypeNumber")) != null && param.toString().trim().length() > 0) {
            String periodTypeNumber = param.toString().trim();
            this.periodType = this.getPeriodType(periodTypeNumber);
            if (this.periodType == null) {
                this.appendErr("periodTypeNumber", periodTypeNumber, ResourceBase.getString((String)RESOURCE, (String)"periodTypeNotFound", (Locale)this.ctx.getLocale()));
                return false;
            }
            this.periodTypeId = this.periodType.getId().toString();
        }
        if ((param = this.params.get("fromPeriodNumber")) != null && param.toString().trim().length() > 0) {
            try {
                this.fromPeriodNumber = Integer.parseInt(param.toString().trim());
                if (this.fromPeriodNumber <= 190000 || this.fromPeriodNumber > 999999) {
                    this.appendErr("fromPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
                    return false;
                }
            }
            catch (Exception e) {
                this.appendErr("fromPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
                return false;
            }
            this.toPeriodNumber = this.fromPeriodNumber;
        }
        String accountTableId = null;
        param = this.params.get("accountTableNumber");
        if (param == null || param.toString().trim().length() == 0 || "null".equals(param.toString().trim())) {
            accountTableId = null;
        } else {
            String accountTableNumber = param.toString().trim();
            AccountTableInfo at = this.getAccountTable(accountTableNumber);
            if (at != null) {
                accountTableId = at.getId().toString();
            } else {
                this.appendErr("accountTableNumber", accountTableNumber, ResourceBase.getString((String)RESOURCE, (String)"accountTable_notFound", (Locale)this.ctx.getLocale()));
                return false;
            }
        }
        for (CompanyOrgUnitInfo company : this.allBizCompanys) {
            if (accountTableId != null) {
                this.accountTableIds.put(company.getId().toString(), accountTableId);
                continue;
            }
            if (company.getAccountTable() == null) continue;
            this.accountTableIds.put(company.getId().toString(), company.getAccountTable().getId().toString());
        }
        param = this.params.get("toPeriodNumber");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                this.toPeriodNumber = Integer.parseInt(param.toString().trim());
                if (this.toPeriodNumber <= 190000 || this.toPeriodNumber > 999999) {
                    this.appendErr("toPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
                    return false;
                }
            }
            catch (Exception e) {
                this.appendErr("toPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
                return false;
            }
            if (this.fromPeriodNumber == 0) {
                this.fromPeriodNumber = this.toPeriodNumber;
            }
        }
        if (this.fromPeriodNumber > this.toPeriodNumber) {
            this.appendErr("toPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
            return false;
        }
        param = this.params.get("currencyNumber");
        if (param != null && param.toString().trim().length() > 0) {
            String currencyNumber = param.toString().trim();
            splits = currencyNumber.split(";");
            if (splits.length == 0) {
                this.appendErr("currencyNumber", currencyNumber, ResourceBase.getString((String)CF_RESOURCE, (String)"currency_foundNull", (Locale)this.ctx.getLocale()));
                return false;
            }
            HashSet<String> set = new HashSet<String>();
            String[] stringArray = splits;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String split = stringArray[i];
                if (split.equals("GLC")) {
                    this.isIncludeGLC = true;
                    continue;
                }
                if (split.equals("GRC")) {
                    this.isIncludeGRC = true;
                    continue;
                }
                set.add(split);
            }
            this.currencys = this.getCurrencys(set);
            if (this.isIncludeGLC && this.isIncludeGRC && (this.currencys == null || this.currencys.isEmpty())) {
                this.appendErr("currencyNumber", currencyNumber, ResourceBase.getString((String)CF_RESOURCE, (String)"currencyNotFound", (Locale)this.ctx.getLocale()));
                return false;
            }
        } else {
            this.appendErr("currencyNumber", (String)param, ResourceBase.getString((String)CF_RESOURCE, (String)"currencyNotFound", (Locale)this.ctx.getLocale()));
            return false;
        }
        param = this.params.get("includeInvisibleItem");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.includeInvisibleItem = true;
        }
        if ((param = this.params.get("includeSupplementItem")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.includeSupplementItem = true;
        }
        if ((param = this.params.get("cashflowItemNumber")) != null && param.toString().trim().length() > 0) {
            String cashflowItemNumber = param.toString().trim();
            splits = cashflowItemNumber.split(";");
            if (splits.length == 0) {
                this.appendErr("cashflowItemNumber", cashflowItemNumber, ResourceBase.getString((String)CF_RESOURCE, (String)"cashflowItem_foundNull", (Locale)this.ctx.getLocale()));
                return false;
            }
            this.itemNumbers = new HashSet<String>();
            for (String split : splits) {
                this.itemNumbers.add(split);
            }
            this.items = this.getCashflowItems(this.itemNumbers);
            if (this.items.isEmpty()) {
                this.appendErr("currencyNumber", cashflowItemNumber, ResourceBase.getString((String)CF_RESOURCE, (String)"cashflowItemNotFound", (Locale)this.ctx.getLocale()));
                return false;
            }
            this.leafItems = this.getLeafCashflowItems(this.items);
            this.itemFilter = true;
        }
        if ((param = this.params.get("exQueryColumns")) != null && param.toString().trim().length() > 0) {
            this.initSupportExQueryColumns();
            String exCols = param.toString().trim();
            splits = exCols.split(";");
            if (splits.length == 0) {
                this.appendErr("exQueryColumns", exCols, ResourceBase.getString((String)CF_RESOURCE, (String)"exQueryColumns_isEmpty", (Locale)this.ctx.getLocale()));
                return false;
            }
            for (String split : splits) {
                if (!this.supportExQueryColumns.contains(split)) {
                    this.appendErr("exQueryColumns", split, ResourceBase.getString((String)CF_RESOURCE, (String)"not_support_query_this_column", (Locale)this.ctx.getLocale()));
                    return false;
                }
                this.exQueryColumns.add(split);
            }
        }
        try {
            boolean r;
            Object p = VoucherProcessCache.getParam(this.ctx, null, "GL_IfcUsePerm_Enable");
            if (p != null && Boolean.valueOf(p.toString()).booleanValue() && !(r = PermissionFactory.getLocalInstance((Context)this.ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId()), null, "gl_ifc_cashFlowTable"))) {
                this.appendErr("user", ContextUtil.getCurrentUserInfo((Context)this.ctx).getNumber(), MessageFormat.format(this.getCFResource("NO_Ifc_cashFlowTable_UsePerm"), ContextUtil.getCurrentUserInfo((Context)this.ctx).getNumber()));
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String getCFResource(String resName) {
        return ResourceBase.getString((String)CF_RESOURCE, (String)resName, (Locale)this.ctx.getLocale());
    }

    private void initSupportExQueryColumns() {
        this.supportExQueryColumns = new HashSet<String>();
        this.supportExQueryColumns.add(this.COLUMN_ITEM_NAME);
        this.supportExQueryColumns.add(this.COLUMN_ITEM_LONGNUMBER);
        this.supportExQueryColumns.add(this.COLUMN_COMPANY_NAME);
        this.supportExQueryColumns.add(this.COLUMN_COMPANY_LONGNUMBER);
        this.supportExQueryColumns.add(this.COLUMN_HG_ID);
        this.supportExQueryColumns.add(this.COLUMN_ASSTACT_ID);
        this.supportExQueryColumns.add(this.COLUMN_ASSTACT_NAME);
    }

    protected PeriodTypeInfo getPeriodType(String periodTypeNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)periodTypeNumber));
        view.setFilter(filter);
        PeriodTypeCollection periodTypes = PeriodTypeFactory.getLocalInstance((Context)this.ctx).getPeriodTypeCollection(view);
        if (periodTypes != null && periodTypes.size() > 0) {
            return periodTypes.get(0);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)periodTypeNumber));
        view.setFilter(filter);
        periodTypes = PeriodTypeFactory.getLocalInstance((Context)this.ctx).getPeriodTypeCollection(view);
        if (periodTypes != null && periodTypes.size() > 0) {
            return periodTypes.get(0);
        }
        return null;
    }

    protected CurrencyCollection getCurrencys(Set<String> currencyNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("precision");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", currencyNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        CurrencyCollection currencys = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view);
        if (currencys == null) {
            return new CurrencyCollection();
        }
        return currencys;
    }

    protected List<CashFlowItemInfo> getLeafCashflowItems(List<CashFlowItemInfo> items) throws BOSException, SQLException {
        ArrayList<CashFlowItemInfo> col = new ArrayList<CashFlowItemInfo>();
        ArrayList<String> longNumbers = new ArrayList<String>();
        for (CashFlowItemInfo item : items) {
            if (item.isIsLeaf()) {
                col.add(item);
                continue;
            }
            longNumbers.add(item.getLongNumber());
        }
        if (!longNumbers.isEmpty()) {
            String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
            StringBuilder sql = new StringBuilder();
            sql.append("select Fid,FNumber,FLongNumber,FName_" + loc + " FName from t_bd_cashflowItem where FisLeaf = 1 and (\n");
            for (String longNumber : longNumbers) {
                sql.append("FLongNumber like '" + longNumber + "!%' or\n");
            }
            sql.setLength(sql.length() - 4);
            sql.append(")");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs.next()) {
                CashFlowItemInfo item = new CashFlowItemInfo();
                item.setId(BOSUuid.read((String)rs.getString("Fid")));
                item.setName(rs.getString("FName"));
                item.setNumber(rs.getString("FNumber"));
                item.setLongNumber(rs.getString("FLongNumber"));
                item.setIsLeaf(true);
                col.add(item);
            }
        }
        return col;
    }

    protected List<CashFlowItemInfo> getCashflowItems(Set<String> itemNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("isLeaf");
        selector.add("name");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", itemNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        CashFlowItemCollection coll = CashFlowItemFactory.getLocalInstance((Context)this.ctx).getCashFlowItemCollection(view);
        ArrayList<CashFlowItemInfo> list = new ArrayList<CashFlowItemInfo>();
        if (coll != null && !coll.isEmpty()) {
            for (int i = 0; i < coll.size(); ++i) {
                CashFlowItemInfo item = coll.get(i);
                list.add(item);
            }
            return list;
        }
        return list;
    }

    protected List<CompanyOrgUnitInfo> getCompanys(Set<String> companyNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("name");
        selector.add("displayName");
        selector.add("isBizUnit");
        selector.add("level");
        selector.add("CU.id");
        selector.add("accountPeriodType.id");
        selector.add("accountTable.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", companyNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("longNumber");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        view.setSorter(sorter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
        if (coll != null && !coll.isEmpty()) {
            ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
            for (int i = 0; i < coll.size(); ++i) {
                list.add(coll.get(i));
            }
            return list;
        }
        return null;
    }

    protected void validateAllBizCompanys() throws BOSException, EASBizException {
        HashSet<CompanyOrgUnitInfo> okCompanys = new HashSet<CompanyOrgUnitInfo>();
        for (CompanyOrgUnitInfo company : this.allBizCompanys) {
            PeriodTypeInfo periodType = company.getAccountPeriodType();
            if (!StringUtils.isEmpty((String)this.periodTypeId) && !this.periodTypeId.equals(periodType.getId().toString())) {
                this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)CF_RESOURCE, (String)"org_periodType_mismatch", (Locale)this.ctx.getLocale()));
                continue;
            }
            okCompanys.add(company);
        }
        HashSet<String> companyIds = new HashSet<String>();
        for (CompanyOrgUnitInfo okCompany : okCompanys) {
            companyIds.add(okCompany.getId().toString());
        }
        this.periodss = this.getPeriodss(this.ctx, companyIds);
        this.cachePeriodRange(okCompanys);
        this.allBizCompanys.clear();
        for (CompanyOrgUnitInfo company : okCompanys) {
            PeriodInfo[] periods = this.periodss.get(company.getId().toString());
            if (periods == null) continue;
            if (periods[0] == null || periods[1] == null) {
                if (!company.getBoolean("inhere")) continue;
                this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)RESOURCE, (String)"company_notEnabled", (Locale)this.ctx.getLocale()));
                continue;
            }
            this.allBizCompanys.add(company);
        }
    }

    protected Map<String, PeriodInfo[]> getPeriodss(Context ctx, Set<String> companyIds) throws BOSException {
        try {
            if (companyIds.size() == 0) {
                return new HashMap<String, PeriodInfo[]>();
            }
            if (companyIds.size() <= 100) {
                return this.doGetPeriods(ctx, companyIds);
            }
            Map<String, PeriodInfo[]> periodss = null;
            List<Set<String>> batchs = GlUtils.split(companyIds, 100);
            for (Set<String> batch : batchs) {
                Map<String, PeriodInfo[]> bPeriodss = this.doGetPeriods(ctx, batch);
                if (periodss == null) {
                    periodss = bPeriodss;
                    continue;
                }
                periodss.putAll(bPeriodss);
            }
            return periodss;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map<String, PeriodInfo[]> doGetPeriods(Context ctx, Set<String> companyIds) throws BOSException, SQLException {
        HashMap<String, PeriodInfo[]> periodss = new HashMap<String, PeriodInfo[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("select ssc.FCompanyID, \n");
        sql.append("    sp.FID FStartPeriodID, sp.FNumber FStartPeriodNumber, sp.FPeriodYear FStartPeriodYear, sp.FPeriodNumber FStartPeriodMonth, \n");
        sql.append("    cp.FID FCurrentPeriodID, cp.FNumber FCurrentPeriodNumber, cp.FPeriodYear FCurrentPeriodYear, cp.FPeriodNumber FCurrentPeriodMonth\n");
        sql.append("from T_BD_SystemStatusCtrol ssc \n");
        sql.append("join T_BD_SystemStatus ss on ss.FID = ssc.FSystemStatusID \n");
        sql.append("left join T_BD_Period sp on sp.FID = ssc.FStartPeriodID \n");
        sql.append("left join T_BD_Period cp on cp.FID = ssc.FCurrentPeriodID \n");
        sql.append("where ss.FName = 6 \n");
        sql.append("and ssc.FCompanyID in " + SQLUtil.buildMarkSQL(companyIds.size()) + "\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])companyIds.toArray());
        while (rs.next()) {
            PeriodInfo[] periods = new PeriodInfo[2];
            PeriodInfo start = null;
            String id = rs.getString("FStartPeriodID");
            if (id != null) {
                int number = rs.getInt("FStartPeriodNumber");
                int year = rs.getInt("FStartPeriodYear");
                int month = rs.getInt("FStartPeriodMonth");
                start = new PeriodInfo();
                start.setId(BOSUuid.read((String)id));
                start.setNumber(number);
                start.setPeriodYear(year);
                start.setPeriodNumber(month);
            }
            periods[0] = start;
            PeriodInfo current = null;
            id = rs.getString("FCurrentPeriodID");
            if (id != null) {
                int number = rs.getInt("FCurrentPeriodNumber");
                int year = rs.getInt("FCurrentPeriodYear");
                int month = rs.getInt("FCurrentPeriodMonth");
                current = new PeriodInfo();
                current.setId(BOSUuid.read((String)id));
                current.setNumber(number);
                current.setPeriodYear(year);
                current.setPeriodNumber(month);
            }
            periods[1] = current;
            periodss.put(rs.getString("FCompanyID"), periods);
        }
        for (String companyId : companyIds) {
            if (periodss.containsKey(companyId)) continue;
            PeriodInfo[] periods = new PeriodInfo[]{null, null};
            periodss.put(companyId, periods);
        }
        return periodss;
    }

    protected void appendErr(String key, String val, String msg) {
        this.errs.add(key + "[" + val + "]:" + msg);
    }

    protected AccountTableInfo getAccountTable(String accountTableNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber));
        view.setFilter(filter);
        AccountTableCollection ats = AccountTableFactory.getLocalInstance((Context)this.ctx).getAccountTableCollection(view);
        if (ats != null && ats.size() > 0) {
            return ats.get(0);
        }
        return null;
    }

    private String getCurrencyIdsStr(CurrencyCollection currencys) {
        if (currencys != null && !currencys.isEmpty()) {
            String[] currencyIds = new String[currencys.size()];
            for (int i = 0; i < currencys.size(); ++i) {
                currencyIds[i] = currencys.get(i).getId().toString();
            }
            return this.stringArrayToString(currencyIds);
        }
        return "";
    }

    public String getDiff(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getAccountSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("diffAccount.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)company.getCU().getId().toString()));
        if (this.accountTableIds.get(company.getId().toString()) != null) {
            fic.add(new FilterItemInfo("accountTable.id", (Object)this.accountTableIds.get(company.getId().toString())));
        }
        ICashFlowAccountDiff activity = CashFlowAccountDiffFactory.getLocalInstance((Context)ctx);
        CashFlowAccountDiffCollection col = activity.getCashFlowAccountDiffCollection(view);
        StringBuffer sb = new StringBuffer();
        CashFlowAccountDiffInfo diffInfo = null;
        AccountViewInfo account = null;
        for (int i = 0; i < col.size(); ++i) {
            diffInfo = col.get(i);
            account = diffInfo.getDiffAccount();
            sb.append("'").append(account.getId().toString()).append("'").append(",");
        }
        if (col.size() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    private void cachePeriodRange(Set<CompanyOrgUnitInfo> bizCompanys) throws BOSException, EASBizException {
        Iterator<CompanyOrgUnitInfo> itr = bizCompanys.iterator();
        while (itr.hasNext()) {
            CompanyOrgUnitInfo company = itr.next();
            PeriodInfo[] periods = this.periodss.get(company.getId().toString());
            PeriodInfo startPeriod = periods[0];
            List<String> periodIdListForCur = this.getPeriodRangeForCur(this.ctx, company, this.fromPeriodNumber, this.toPeriodNumber);
            List<String> periodIdListForSum = this.getPeriodRangeForSum(this.ctx, company, startPeriod.getNumber(), this.toPeriodNumber);
            if (!periodIdListForCur.isEmpty() && !periodIdListForSum.isEmpty()) continue;
            this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)CF_RESOURCE, (String)"periodTypeNotFoundPeriod", (Locale)this.ctx.getLocale()));
            itr.remove();
        }
    }

    class RetainProfitTask
    implements Runnable {
        CompanyOrgUnitInfo company;
        CountDownLatch latch;

        RetainProfitTask(CompanyOrgUnitInfo company, CountDownLatch latch) {
            this.company = company;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BigDecimal retainedSumProfit;
                BigDecimal retainedProfit;
                ArrayList<Object> params;
                Map<String, BigDecimal> retainedSumProfits;
                Map<String, BigDecimal> retainedProfits;
                String diffAccountSet = CashflowInterfaceService.this.getDiff(CashflowInterfaceService.this.ctx, this.company);
                StringBuilder sql = new StringBuilder();
                sql.append("insert into  ").append(CashflowInterfaceService.this.T_TMP_DataTable).append(" ( \n");
                sql.append("   companyID,\n");
                sql.append("   currencyID,\n");
                sql.append("   cashFlowItemID,\n");
                sql.append("   amount,\n");
                sql.append("   yearSum");
                sql.append(" ) \n");
                sql.append("    select \n");
                sql.append("        ?,  \n");
                sql.append("        ?,  \n");
                sql.append("        item.fid,  \n");
                sql.append("        ?,  \n");
                sql.append("        ?  \n");
                sql.append("    from t_bd_cashFlowItem item \n");
                sql.append("    where item.FisProfit = 1 \n");
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                if (!CashflowInterfaceService.this.currencys.isEmpty()) {
                    retainedProfits = this.getRetainedProfits(diffAccountSet, false, true, false);
                    retainedSumProfits = this.getRetainedProfits(diffAccountSet, true, true, false);
                    for (int i = 0; i < CashflowInterfaceService.this.currencys.size(); ++i) {
                        CurrencyInfo currency = CashflowInterfaceService.this.currencys.get(i);
                        String currencyID = currency.getId().toString();
                        ArrayList<Object> params2 = new ArrayList<Object>();
                        params2.add(this.company.getId().toString());
                        params2.add(currencyID);
                        BigDecimal retainedProfit2 = retainedProfits.get(currencyID);
                        BigDecimal retainedSumProfit2 = retainedSumProfits.get(currencyID);
                        params2.add(retainedProfit2 == null ? BigDecimal.ZERO : retainedProfit2);
                        params2.add(retainedSumProfit2 == null ? BigDecimal.ZERO : retainedSumProfit2);
                        paramList.add(params2.toArray());
                    }
                }
                if (CashflowInterfaceService.this.isIncludeGLC) {
                    retainedProfits = this.getRetainedProfits(diffAccountSet, false, false, true);
                    retainedSumProfits = this.getRetainedProfits(diffAccountSet, true, false, true);
                    String currencyID = CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString();
                    params = new ArrayList<Object>();
                    params.add(this.company.getId().toString());
                    params.add(currencyID);
                    retainedProfit = retainedProfits.get(currencyID);
                    retainedSumProfit = retainedSumProfits.get(currencyID);
                    params.add(retainedProfit == null ? BigDecimal.ZERO : retainedProfit);
                    params.add(retainedSumProfit == null ? BigDecimal.ZERO : retainedSumProfit);
                    paramList.add(params.toArray());
                }
                if (CashflowInterfaceService.this.isIncludeGRC) {
                    retainedProfits = this.getRetainedProfits(diffAccountSet, false, false, false);
                    retainedSumProfits = this.getRetainedProfits(diffAccountSet, true, false, false);
                    String currencyID = CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString();
                    params = new ArrayList();
                    params.add(this.company.getId().toString());
                    params.add(currencyID);
                    retainedProfit = retainedProfits.get(currencyID);
                    retainedSumProfit = retainedSumProfits.get(currencyID);
                    params.add(retainedProfit == null ? BigDecimal.ZERO : retainedProfit);
                    params.add(retainedSumProfit == null ? BigDecimal.ZERO : retainedSumProfit);
                    paramList.add(params.toArray());
                }
                DbUtil.executeBatch((Context)CashflowInterfaceService.this.ctx, (String)sql.toString(), paramList);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                CashflowInterfaceService.this.appendErr("", "", e.getMessage());
            }
            finally {
                this.latch.countDown();
            }
        }

        private Map<String, BigDecimal> getRetainedProfits(String diffAccountSet, boolean isSum, boolean isForCurrency, boolean isGLC) throws BOSException, SQLException, EASBizException {
            List<String> periodIdList;
            StringBuilder sql = new StringBuilder();
            String companyID = this.company.getId().toString();
            ArrayList<Object> params = new ArrayList<Object>();
            int beginPeriodNumber = CashflowInterfaceService.this.fromPeriodNumber;
            if (isSum) {
                beginPeriodNumber = CashflowInterfaceService.this.fromPeriodNumber / 100 == CashflowInterfaceService.this.toPeriodNumber / 100 ? CashflowInterfaceService.this.fromPeriodNumber / 100 * 100 + 1 : CashflowInterfaceService.this.toPeriodNumber / 100 * 100 + 1;
            }
            if ((periodIdList = CashflowInterfaceService.this.getPeriodIdByNumberRange(CashflowInterfaceService.this.ctx, companyID, beginPeriodNumber, CashflowInterfaceService.this.toPeriodNumber)).isEmpty()) {
                throw new CashFlowException(CashFlowException.CANT_FIND_PERIOD_BY_PERIODTYPE);
            }
            String periodIdsStr = CashflowInterfaceService.this.getPeriodIdsStr(periodIdList);
            sql.append("select \n");
            if (isForCurrency) {
                sql.append("    ve.FCurrencyID currencyID,    \n");
                sql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) amount \n");
            } else if (isGLC) {
                sql.append("'" + CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString() + "'  currencyID, \n");
                sql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) amount \n");
            } else {
                sql.append("'" + CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString() + "' currencyID, \n");
                sql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) amount \n");
            }
            sql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID \n");
            sql.append(" inner join T_BD_AccountView account on ve.FAccountID = account.FID \n");
            sql.append(" left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID \n");
            sql.append(" where voucher.FCompanyID = ? \n");
            params.add(companyID);
            sql.append(" and account.FCompanyID = ? \n");
            params.add(companyID);
            sql.append(" and fdiffaccountid is null \n");
            sql.append(" and account.FPLType <> ? \n");
            params.add(0);
            sql.append(" and account.FCategory = 1 \n");
            if (CashflowInterfaceService.this.accountTableIds.get(companyID) != null) {
                sql.append(" and account.FAccountTableID = ? \n");
                params.add(CashflowInterfaceService.this.accountTableIds.get(companyID));
            }
            sql.append(" and voucher.FPeriodID in ( ").append(periodIdsStr).append(" )\n");
            if (isForCurrency) {
                sql.append(" and ve.FCurrencyID in (").append(CashflowInterfaceService.this.getCurrencyIdsStr(CashflowInterfaceService.this.currencys)).append(" )\n");
            }
            sql.append(" and voucher.FSourceType<>1 \n");
            if (CashflowInterfaceService.this.balType == 5) {
                sql.append(" and voucher.FBizStatus = 5 \n");
            } else {
                sql.append(" and voucher.FBizStatus in (1, 3, 5) \n");
            }
            if (diffAccountSet != null && diffAccountSet.length() > 0) {
                sql.append(" and account.FID not in (" + diffAccountSet + ") \n");
            }
            if (isForCurrency) {
                sql.append(" group by ve.FCurrencyID");
            }
            IRowSet rs = DbUtil.executeQuery((Context)CashflowInterfaceService.this.ctx, (String)sql.toString(), (Object[])params.toArray());
            HashMap<String, BigDecimal> res = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                String currencyID = rs.getString("currencyID");
                BigDecimal amount = rs.getBigDecimal("amount");
                res.put(currencyID, amount);
            }
            return res;
        }
    }

    private final class SubTask
    implements Runnable {
        Context ctx;
        CompanyOrgUnitInfo company;
        List<String> periodIdListForCur;
        List<String> periodIdListForSum;
        CashFlowItemType cashFlowItemType;
        boolean needInitData;
        CountDownLatch latch;

        public SubTask(Context ctx, CompanyOrgUnitInfo company, List<String> periodIdListForCur, List<String> periodIdListForSum, CashFlowItemType cashFlowItemType, boolean needInitData, CountDownLatch latch) {
            this.ctx = ctx;
            this.company = company;
            this.periodIdListForCur = periodIdListForCur;
            this.periodIdListForSum = periodIdListForSum;
            this.cashFlowItemType = cashFlowItemType;
            this.needInitData = needInitData;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.insertAmountData();
                this.insertYearSumData();
                if (this.needInitData) {
                    this.insertInitData();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                CashflowInterfaceService.this.appendErr("", "", e.getMessage());
            }
            finally {
                this.latch.countDown();
            }
        }

        private void insertAmountData() throws BOSException {
            String SQL2;
            ArrayList<Object> params = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder();
            sql.append("insert into " + CashflowInterfaceService.this.T_TMP_AmountTable + " ( \n");
            sql.append("    companyID, \n");
            sql.append("    cashFlowItemID, \n");
            sql.append("    currencyID, \n");
            sql.append("    hgID, \n");
            sql.append("    FType, \n");
            sql.append("    amount \n");
            sql.append("    ) \n");
            if (!CashflowInterfaceService.this.currencys.isEmpty()) {
                SQL2 = this.getSumRecordsSQL(this.periodIdListForCur, this.cashFlowItemType, params, true, false);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
                params.clear();
            }
            if (CashflowInterfaceService.this.isIncludeGLC) {
                SQL2 = this.getSumRecordsSQL(this.periodIdListForCur, this.cashFlowItemType, params, false, true);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
                params.clear();
            }
            if (CashflowInterfaceService.this.isIncludeGRC) {
                SQL2 = this.getSumRecordsSQL(this.periodIdListForCur, this.cashFlowItemType, params, false, false);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
            }
        }

        private void insertYearSumData() throws BOSException {
            String SQL2;
            ArrayList<Object> params = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder();
            sql.append("insert into " + CashflowInterfaceService.this.T_TMP_YearSumTable + " ( \n");
            sql.append("    companyID, \n");
            sql.append("    cashFlowItemID, \n");
            sql.append("    currencyID, \n");
            sql.append("    hgID, \n");
            sql.append("    FType, \n");
            sql.append("    yearSum \n");
            sql.append("    ) \n");
            if (!CashflowInterfaceService.this.currencys.isEmpty()) {
                SQL2 = this.getSumRecordsSQL(this.periodIdListForSum, this.cashFlowItemType, params, true, false);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
                params.clear();
            }
            if (CashflowInterfaceService.this.isIncludeGLC) {
                SQL2 = this.getSumRecordsSQL(this.periodIdListForSum, this.cashFlowItemType, params, false, true);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
                params.clear();
            }
            if (CashflowInterfaceService.this.isIncludeGRC) {
                SQL2 = this.getSumRecordsSQL(this.periodIdListForSum, this.cashFlowItemType, params, false, false);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
            }
        }

        private void insertInitData() throws BOSException {
            String SQL2;
            ArrayList<Object> params = new ArrayList<Object>();
            StringBuilder sql = new StringBuilder();
            sql.append("insert into " + CashflowInterfaceService.this.T_TMP_InitDataTable + " ( \n");
            sql.append("    companyID, \n");
            sql.append("    cashFlowItemID, \n");
            sql.append("    currencyID, \n");
            sql.append("    hgID, \n");
            sql.append("    FType, \n");
            sql.append("    yearSum \n");
            sql.append("    ) \n");
            if (!CashflowInterfaceService.this.currencys.isEmpty()) {
                SQL2 = this.getInitDataSQL(params, true, false);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
                params.clear();
            }
            if (CashflowInterfaceService.this.isIncludeGLC) {
                SQL2 = this.getInitDataSQL(params, false, true);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
                params.clear();
            }
            if (CashflowInterfaceService.this.isIncludeGRC) {
                SQL2 = this.getInitDataSQL(params, false, false);
                DbUtil.execute((Context)this.ctx, (String)(sql.toString() + SQL2), (Object[])params.toArray());
            }
        }

        private String getInitDataSQL(List<Object> params, boolean isForCurrency, boolean isGLC) {
            StringBuilder sql = new StringBuilder();
            sql.append("select \n");
            sql.append("init.FCompanyID companyID,\n");
            sql.append("init.FcashFlowItemID as cashFlowItemID,\n");
            if (isForCurrency) {
                sql.append("init.FCurrencyID as currencyID,\n");
            } else if (isGLC) {
                sql.append("'" + CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString() + "'  currencyID, \n");
            } else {
                sql.append("'" + CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString() + "' currencyID, \n");
            }
            sql.append("isnull(asst.FAssistGrpID,' ') as hgID, \n");
            sql.append("asst.FType as FType, \n");
            if (isForCurrency) {
                sql.append("asst.FOriginalAmount as\u3000amount \n");
            } else if (isGLC) {
                sql.append("asst.FLocalAmount as\u3000amount \n");
            } else {
                sql.append("asst.FReportingAmount as\u3000amount \n");
            }
            sql.append("from T_GL_CashflowInit as init \n");
            sql.append("left  join T_GL_CashflowGrpAsst as asst on init.FID = asst.FCflowInitID \n");
            sql.append("where init.FCompanyID = ?  \n");
            params.add(this.company.getId().toString());
            if (isForCurrency) {
                sql.append("and init.FCurrencyID = in( ").append(CashflowInterfaceService.this.getCurrencyIdsStr(CashflowInterfaceService.this.currencys)).append(") ");
            }
            if (!CashflowInterfaceService.this.includeInvisibleItem && CashflowInterfaceService.this.itemViewSqls.get(this.company.getId().toString()) != null) {
                sql.append("   and init.FcashFlowItemID ").append((String)CashflowInterfaceService.this.itemViewSqls.get(this.company.getId().toString())).append("\n");
            }
            if (CashflowInterfaceService.this.itemFilter) {
                sql.append(" and init.FcashFlowItemID in (").append(CashflowInterfaceService.this.getItemIdsStr(CashflowInterfaceService.this.leafItems)).append(") \n");
            }
            return sql.toString();
        }

        private String getSumRecordsSQL(List<String> periodIdList, CashFlowItemType cashFlowItemType, List<Object> params, boolean isForCurrency, boolean isGLC) {
            String companyID = this.company.getId().toString();
            String itemIDStr = "";
            String coeffientStr = "";
            String accountTableId = CashflowInterfaceService.this.accountTableIds.get(this.company.getId().toString());
            if (cashFlowItemType == CashFlowItemType.MASTER_TABLE_ITEM) {
                itemIDStr = "cfr.FPrimaryItemID";
                coeffientStr = "cfr.FPrimaryCoeffient";
            } else {
                itemIDStr = "cfr.FSupplementaryItemID";
                coeffientStr = "cfr.FSupplementaryCoeffient";
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select   \n");
            sql.append("    ? companyID,   \n\t");
            params.add(companyID);
            sql.append(itemIDStr).append(" cashFlowItemID,    \n");
            if (isForCurrency) {
                sql.append("    cfr.FCurrencyID currencyID,    \n");
            } else if (isGLC) {
                sql.append("'" + CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString() + "'  currencyID, \n");
            } else {
                sql.append("'" + CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString() + "' currencyID, \n");
            }
            if (cashFlowItemType == CashFlowItemType.MASTER_TABLE_ITEM) {
                sql.append("    isnull(cfr.fassgrpid,' ') as hgID,   \n");
                sql.append("    cfr.FType as FType,     \n");
            } else {
                sql.append("    ' ' as hgID,   \n");
                sql.append("    1 as FType,     \n");
            }
            if (isForCurrency) {
                sql.append("    sum(cfr.FOriginalAmount * ").append(coeffientStr).append(" ) amount     \n");
            } else if (isGLC) {
                sql.append("    sum(cfr.FLocalAmount * ").append(coeffientStr).append(" ) amount     \n");
            } else {
                sql.append("    sum(cfr.FReportingAmount * ").append(coeffientStr).append(" ) amount     \n");
            }
            sql.append("from  T_GL_CashflowRecord cfr  \n");
            sql.append("inner join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
            if (accountTableId != null) {
                sql.append("inner join T_BD_Accountview av on cfr.Faccountid = av.fid \n");
            }
            sql.append("where \n");
            sql.append("  voucher.FCompanyID = ?\n");
            params.add(companyID);
            if (isForCurrency) {
                sql.append("   and cfr.FCurrencyID in (").append(CashflowInterfaceService.this.getCurrencyIdsStr(CashflowInterfaceService.this.currencys)).append(" )\n");
            }
            if (CashflowInterfaceService.this.balType == 5) {
                sql.append("   and voucher.FBizStatus = 5 \n");
            } else {
                sql.append("   and voucher.FBizStatus in (1, 3, 5) \n");
            }
            if (accountTableId != null) {
                sql.append("   and av.faccounttableid = ?\n");
                params.add(accountTableId);
            }
            if (!CashflowInterfaceService.this.includeInvisibleItem && CashflowInterfaceService.this.itemViewSqls.get(this.company.getId().toString()) != null) {
                sql.append("   and ").append(itemIDStr).append((String)CashflowInterfaceService.this.itemViewSqls.get(this.company.getId().toString())).append("\n");
            }
            sql.append("   and voucher.FPeriodID in (").append(CashflowInterfaceService.this.getPeriodIdsStr(periodIdList)).append(")\n");
            if (CashflowInterfaceService.this.itemFilter) {
                sql.append("    and ").append(itemIDStr).append(" in (").append(CashflowInterfaceService.this.getItemIdsStr(CashflowInterfaceService.this.leafItems)).append(" ) \n");
            }
            sql.append("group by ").append(itemIDStr);
            if (isForCurrency) {
                sql.append(",cfr.FCurrencyID ");
            }
            if (cashFlowItemType == CashFlowItemType.MASTER_TABLE_ITEM) {
                sql.append(", cfr.fassgrpid, cfr.FType \n");
            }
            return sql.toString();
        }
    }
}

