/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IOrgRange;
import com.kingdee.eas.base.permission.OrgRangeFactory;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffCollection;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffFactory;
import com.kingdee.eas.basedata.assistant.CashFlowAccountDiffInfo;
import com.kingdee.eas.basedata.assistant.CashFlowItemType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICashFlowAccountDiff;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.CashflowRecordInfo;
import com.kingdee.eas.fi.gl.CashflowTypeEnum;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GLBalanceFacadeFactory;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.cache.VoucherProcessCache;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptBaseService;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class CashflowTableService
extends GLNRptBaseService {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.app.CashflowTableService");
    protected boolean hasVirtual = false;
    protected CompanyOrgUnitInfo companyTop = null;
    protected boolean isMultiTree = false;
    protected boolean sumByUnion = false;
    protected boolean showAsst = false;
    protected boolean showExchangeItem = false;
    protected boolean showInvisibleItem = false;
    protected boolean showCashInitEndBalance = false;
    protected boolean showSupplementItem = false;
    protected boolean showAsstNumber = false;
    protected boolean showAsstLongName = false;
    protected Integer sumItemLevel = 10;
    protected String T_TMP_AmountTable = null;
    protected String T_TMP_YearSumTable = null;
    protected String T_TMP_InitDataTable = null;
    protected String T_TMP_DataTable = null;
    protected List<Map<String, Object>> treeDatas = null;
    protected Map<String, PeriodInfo[]> periodss = null;
    protected Map<String, List<String>> periodIdLists = new HashMap<String, List<String>>();
    protected List<CompanyOrgUnitInfo> allBizCompanys = new ArrayList<CompanyOrgUnitInfo>();
    protected Map<String, String> accountTableIds = new HashMap<String, String>();
    protected List<CompanyOrgUnitInfo> companys = new ArrayList<CompanyOrgUnitInfo>();
    protected CompanyDisplayModeEnum companyDisplayMode = null;
    protected int companyLevel = 0;
    protected GLNRptBaseService.CompanyNode root = null;
    protected CtrlUnitInfo ctrlUnit = null;
    private String itemViewSql = null;
    private Map<Integer, String> typeAlias = null;
    protected Map<String, Integer> colIndexes = new HashMap<String, Integer>();
    private Map<List<String>, String> periodListsStr = new HashMap<List<String>, String>();
    private static final String CF_RESOURCE = "com.kingdee.eas.fi.gl.GLNRptCFResource";
    private int digit = 1;
    private int currencyScale = 4;
    private int maxScale = 4;
    private boolean isForCurrency = true;
    private Map<String, Object> hgs = new HashMap<String, Object>();
    private Map<String, String> hgIdToAsstAccountIds = new HashMap<String, String>();
    private Map<String, String> hgNameCache = new HashMap<String, String>();
    private Map<String, List<AsstActTypeInfo>> asstActTypess = new HashMap<String, List<AsstActTypeInfo>>();
    private String COLUMN_CASH_FLOW_ITEM_NAME = "cashFlowItemName";
    private String COLUMN_SEQ = "seq";
    private String COLUMN_COMPANY_NAME = "companyName";
    private String COLUMN_TYPE = "type";
    private String COLUMN_HG_LONG_NAME_GROUP = "hgLongNameGroup";
    private String COLUMN_AMOUNT = "amount";
    private String COLUMN_YEAR_SUM = "yearSum";
    private String COLUMN_ITEM_LEVEL = "itemLevel";
    private String COLUMN_COMPANY_LEVEL = "companyLevel";
    private String COLUMN_IS_NET_ROW = "isNetRow";
    private String COLUMN_ITEM_ID = "itemID";
    private String COLUMN_COMPANY_ID = "companyID";
    private String COLUMN_HG_ID = "hgID";
    private String COLUMN_IS_ASST_ROW = "isAsstRow";
    private String COLUMN_IS_QUERY_ROW = "isQueryRow";
    private Integer seq = 0;

    public CashflowTableService(Context ctx, Map params) {
        super(ctx, params);
    }

    @Override
    public void doExecuteQuery() throws Exception {
        this.query();
        Object param = this.params.get("showCompanyInfo");
        if (param != null && "true".equals(param.toString().trim())) {
            List<Map<String, Object>> companyInfos = this.toMap(this.treeDatas);
            this.result.put("companys", companyInfos);
        }
        if (this.debug) {
            this.byPage = true;
            Map<String, Object> pageParams = this.getPageParams();
            String pageName = this.saveTmpFile(pageParams);
            this.result.put("pageName", pageName);
        }
    }

    private void query() throws Exception {
        this.buildTableHead();
        if (this.allBizCompanys.isEmpty()) {
            return;
        }
        this.updateVoucherBalance();
        this.ctrlUnit = !this.hasVirtual ? this.allBizCompanys.get(0).getCU() : this.root.childs.get((int)0).company.getCU();
        if (!this.showInvisibleItem && this.ctrlUnit.getId() != null) {
            this.itemViewSql = this.getItemViewSql(this.ctx, this.ctrlUnit.getId().toString());
        }
        this.createDataTable();
        this.multiThreadProcess();
        this.mergeTempTables();
        this.cacheHgs();
        this.updateFlagColumn();
        this.insertAsstSumData();
        this.insertDetailItemEmptyData();
        this.insertItemSumData();
        this.insertOrgSumData();
        this.buildData();
    }

    private void cacheHgs() throws BOSException, SQLException {
        if (this.showAsst) {
            StringBuilder SQL2 = new StringBuilder();
            SQL2.append("select distinct hgID from ").append(this.T_TMP_DataTable);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)SQL2.toString());
            HashSet<String> hgIds = new HashSet<String>();
            while (rs.next()) {
                String hgID = rs.getString("hgID");
                if (hgID == null || hgID.trim().length() <= 0) continue;
                hgIds.add(hgID);
            }
            this.cacheHgs(this.ctx, this.groupHgIds(this.ctx, hgIds));
        }
    }

    private void cacheHgs(Context ctx, Map<String, Set<String>> hgIdss) throws BOSException {
        for (String asstAccountId : hgIdss.keySet()) {
            Set<String> tempIds = hgIdss.get(asstAccountId);
            Set<Object> hgIds = new HashSet();
            if (this.hgs.size() == 0) {
                hgIds = tempIds;
            } else {
                for (String tempId : tempIds) {
                    if (this.hgs.containsKey(tempId)) continue;
                    hgIds.add(tempId);
                }
            }
            if (hgIds.size() <= 0) continue;
            try {
                Map<String, Object> map = GLAsstAccountUtils.getAssistantHgs(ctx, asstAccountId, this.getAsstActTypes(ctx, asstAccountId), hgIds);
                this.hgs.putAll(map);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private Map<String, Set<String>> groupHgIds(Context ctx, Set<String> hgIds) throws BOSException {
        HashMap<String, Set<String>> hgIdss = new HashMap<String, Set<String>>();
        if (hgIds.size() <= 0) {
            return hgIdss;
        }
        String sql = "select FID, FAsstAccountID from T_BD_AssistantHG where FID in ";
        List<Set<String>> batchs = GlUtils.split(hgIds, 100);
        try {
            for (Set<String> batch : batchs) {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql + SQLUtil.buildMarkSQL(batch.size())), (Object[])batch.toArray());
                while (rs.next()) {
                    String asstAccountId = rs.getString("FAsstAccountID");
                    if (asstAccountId == null) continue;
                    HashSet<String> set = (HashSet<String>)hgIdss.get(asstAccountId);
                    if (set == null) {
                        set = new HashSet<String>();
                        hgIdss.put(asstAccountId, set);
                    }
                    String hgId = rs.getString("FID");
                    set.add(hgId);
                    this.hgIdToAsstAccountIds.put(hgId, asstAccountId);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hgIdss;
    }

    private List<AsstActTypeInfo> getAsstActTypes(Context ctx, String asstAccountId) throws BOSException {
        if (this.asstActTypess.containsKey(asstAccountId)) {
            return this.asstActTypess.get(asstAccountId);
        }
        AsstActTypeCollection aats = VoucherProcessCache.getAsstActTypes(ctx, asstAccountId);
        ArrayList<AsstActTypeInfo> asstActTypes = new ArrayList<AsstActTypeInfo>(aats.size());
        for (AsstActTypeInfo aat : aats) {
            if (this.showAsstNumber) {
                if (aat.isUseLongNumber()) {
                    aat.put("showLongNumber", (Object)true);
                } else {
                    aat.put("showNumber", (Object)true);
                }
            }
            if (this.showAsstLongName) {
                aat.put("showLongName", (Object)true);
            }
            if (this.showAsstNumber && this.showAsstLongName) {
                aat.put("showName", (Object)false);
            } else {
                aat.put("showName", (Object)true);
            }
            asstActTypes.add(aat);
        }
        this.asstActTypess.put(asstAccountId, asstActTypes);
        return asstActTypes;
    }

    private void updateVoucherBalance() throws BOSException {
        if (!this.showCashInitEndBalance) {
            return;
        }
        String[] companyIds = new String[this.allBizCompanys.size()];
        for (int i = 0; i < this.allBizCompanys.size(); ++i) {
            CompanyOrgUnitInfo bizCompany = this.allBizCompanys.get(i);
            companyIds[i] = bizCompany.getId().toString();
        }
        GLBalanceFacadeFactory.getLocalInstance(this.ctx).updateVoucherBalance(companyIds);
    }

    private void processAccountBalanceData(CountDownLatch latch) {
        if (this.showCashInitEndBalance) {
            for (CompanyOrgUnitInfo bizCompany : this.allBizCompanys) {
                this.getExecutor().execute(new CashBalanceTask(bizCompany, latch));
            }
        }
    }

    private void processVirtualOrgAccountBalanceData(Flag flag) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into " + this.T_TMP_DataTable + " ( \n");
        if (!this.sumByUnion) {
            sql.append("    companyID, \n");
        } else {
            sql.append("    unionID, \n");
        }
        sql.append("    amount, \n");
        sql.append("    yearSum, \n");
        sql.append("    flag, \n");
        sql.append("    isReturn \n");
        sql.append("    ) \n");
        sql.append("select \n");
        if (!this.sumByUnion) {
            sql.append("     company.FParentID,\n");
        } else {
            sql.append("     s.FParentID,\n");
        }
        sql.append("     sum(tt.amount),\n");
        sql.append("     sum(tt.yearSum),\n");
        sql.append("    " + flag.getValue() + ", \n");
        sql.append("    ? \n");
        sql.append("from " + this.T_TMP_DataTable + " tt\n");
        if (!this.sumByUnion) {
            sql.append("inner join t_org_company company on tt.companyID = company.fid\n");
            sql.append("where company.flevel = ?  \n");
            sql.append("and tt.flag = " + flag.getValue()).append("\n");
            sql.append("group by company.FParentID\n");
        } else {
            sql.append("inner join t_org_structure s on tt.unionID = s.fid\n");
            sql.append("where s.flevel = ? \n");
            sql.append("and tt.flag = " + flag.getValue()).append("\n");
            sql.append("group by s.FParentID\n");
        }
        if (!this.sumByUnion) {
            int maxLevel;
            int tree;
            HashMap<Integer, Integer> maxLevels = new HashMap<Integer, Integer>();
            for (Map<String, Object> treeData : this.treeDatas) {
                List companys = (List)treeData.get("companys");
                tree = (Integer)treeData.get("tree");
                maxLevel = 0;
                for (CompanyOrgUnitInfo company : companys) {
                    maxLevel = Math.max(maxLevel, company.getLevel());
                }
                maxLevels.put(tree, maxLevel);
            }
            for (Map<String, Object> treeData : this.treeDatas) {
                CompanyOrgUnitInfo rootCompany = (CompanyOrgUnitInfo)treeData.get("rootCompany");
                if (rootCompany.isIsBizUnit()) continue;
                tree = (Integer)treeData.get("tree");
                for (int level = maxLevel = ((Integer)maxLevels.get(tree)).intValue(); level > rootCompany.getLevel(); --level) {
                    boolean isReturn = this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level) || level == rootCompany.getLevel() + 1;
                    this.execute(this.ctx, sql.toString(), new Object[]{isReturn ? 1 : 0, level});
                }
            }
        } else {
            int maxLevel = 1;
            for (Map<String, Object> treeData : this.treeDatas) {
                List companys = (List)treeData.get("companys");
                for (CompanyOrgUnitInfo company : companys) {
                    maxLevel = Math.max(maxLevel, company.getInt("unionLevel"));
                }
            }
            int companyTopLevel = (Integer)this.result.get("companyTopLevel");
            for (int level = maxLevel; level > companyTopLevel; --level) {
                boolean isReturn = this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level) || level == companyTopLevel + 1;
                this.execute(this.ctx, sql.toString(), new Object[]{isReturn ? 1 : 0, level});
            }
        }
    }

    private void multiThreadProcess() throws BOSException, EASBizException, InterruptedException {
        int latchSize = this.allBizCompanys.size() * 2;
        if (this.showCashInitEndBalance) {
            latchSize += this.allBizCompanys.size();
        }
        if (this.showSupplementItem) {
            latchSize += this.allBizCompanys.size();
        }
        CountDownLatch latch = new CountDownLatch(latchSize);
        this.selectAmountAndYearSum(latch);
        this.processAccountBalanceData(latch);
        this.processRetainedProfit(latch);
        latch.await();
        if (this.showCashInitEndBalance && !this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.enumerate)) {
            this.processVirtualOrgAccountBalanceData(Flag.ALL_CASH_BEGIN);
            this.processVirtualOrgAccountBalanceData(Flag.CASH_END);
            this.processVirtualOrgAccountBalanceData(Flag.CASH_BEGIN);
            this.processVirtualOrgAccountBalanceData(Flag.EQU_BEGIN);
            this.processVirtualOrgAccountBalanceData(Flag.EQU_END);
        }
    }

    private void cachePeriodRange(Set<CompanyOrgUnitInfo> bizCompanys) throws BOSException, EASBizException {
        Iterator<CompanyOrgUnitInfo> itr = bizCompanys.iterator();
        while (itr.hasNext()) {
            CompanyOrgUnitInfo company = itr.next();
            PeriodInfo[] periods = this.periodss.get(company.getId().toString());
            PeriodInfo startPeriod = periods[0];
            List<String> periodIdListForCur = this.getPeriodRangeForCur(this.ctx, company, this.fromPeriodNumber, this.toPeriodNumber);
            List<String> periodIdListForSum = this.getPeriodRangeForSum(this.ctx, company, startPeriod.getNumber(), this.toPeriodNumber);
            if (!periodIdListForCur.isEmpty() && !periodIdListForSum.isEmpty()) continue;
            this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)CF_RESOURCE, (String)"periodTypeNotFoundPeriod", (Locale)this.ctx.getLocale()));
            itr.remove();
        }
    }

    private void processRetainedProfit(CountDownLatch latch) {
        if (this.showSupplementItem) {
            for (CompanyOrgUnitInfo bizCompany : this.allBizCompanys) {
                this.getExecutor().execute(new RetainProfitTask(bizCompany, latch));
            }
        }
    }

    private void selectAmountAndYearSum(CountDownLatch latch) throws BOSException, EASBizException {
        for (CompanyOrgUnitInfo company : this.allBizCompanys) {
            PeriodInfo[] periods = this.periodss.get(company.getId().toString());
            PeriodInfo startPeriod = periods[0];
            List<String> periodIdListForCur = this.getPeriodRangeForCur(this.ctx, company, this.fromPeriodNumber, this.toPeriodNumber);
            List<String> periodIdListForSum = this.getPeriodRangeForSum(this.ctx, company, startPeriod.getNumber(), this.toPeriodNumber);
            List<CashFlowItemType> cashFlowItemTypes = Arrays.asList(CashFlowItemType.MASTER_TABLE_ITEM, CashFlowItemType.SECONDARY_TABLE_ITEM);
            boolean needInitData = startPeriod.getPeriodYear() == this.toPeriodNumber / 100;
            for (CashFlowItemType cashFlowItemType : cashFlowItemTypes) {
                if (!this.showSupplementItem && cashFlowItemType == CashFlowItemType.SECONDARY_TABLE_ITEM) {
                    if (latch == null) continue;
                    latch.countDown();
                    continue;
                }
                boolean bl = needInitData = needInitData && cashFlowItemType == CashFlowItemType.MASTER_TABLE_ITEM;
                if (latch != null) {
                    this.getExecutor().execute(new SubTask(this.ctx, company, periodIdListForCur, periodIdListForSum, cashFlowItemType, needInitData, latch));
                    continue;
                }
                SubTask subTask = new SubTask(this.ctx, company, periodIdListForCur, periodIdListForSum, cashFlowItemType, needInitData, null);
                subTask.run();
            }
        }
    }

    @Override
    protected synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            int maxSize;
            int coreSize = this.allBizCompanys.size() * (this.showSupplementItem ? 2 : 1);
            if (coreSize > (maxSize = Runtime.getRuntime().availableProcessors())) {
                coreSize = maxSize;
            }
            this.executor = new ThreadPoolExecutor(coreSize, maxSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadPoolExecutor.CallerRunsPolicy());
        }
        return this.executor;
    }

    private void validateAllBizCompanys() throws BOSException, EASBizException {
        this.allBizCompanys = new ArrayList<CompanyOrgUnitInfo>(this.companys.size());
        this.treeDatas = this.toList(this.root);
        for (Map<String, Object> map : this.treeDatas) {
            List companys = (List)map.get("companys");
            this.allBizCompanys.addAll(companys);
        }
        this.periodss = this.getPeriodss(this.ctx, this.allBizCompanys);
        HashSet<CompanyOrgUnitInfo> okCompanys = new HashSet<CompanyOrgUnitInfo>(this.allBizCompanys.size());
        for (CompanyOrgUnitInfo company : this.allBizCompanys) {
            PeriodInfo[] periods;
            if (company.getBoolean("hasError") || (periods = this.periodss.get(company.getId().toString())) == null) continue;
            if (periods[0] == null || periods[1] == null) {
                if (!company.getBoolean("inhere")) continue;
                this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"company_notEnabled", (Locale)this.ctx.getLocale()));
                continue;
            }
            okCompanys.add(company);
        }
        Set<CompanyOrgUnitInfo> set = this.getAllBizCompanyWithGL053(okCompanys);
        HashSet<CompanyOrgUnitInfo> checkedCompanys = new HashSet<CompanyOrgUnitInfo>();
        if (!StringUtils.isEmpty((String)this.periodTypeId)) {
            for (CompanyOrgUnitInfo companyOrgUnitInfo : set) {
                PeriodTypeInfo periodType = companyOrgUnitInfo.getAccountPeriodType();
                if (!this.periodTypeId.equals(periodType.getId().toString())) {
                    this.appendErr("companyNumber", companyOrgUnitInfo.getNumber(), ResourceBase.getString((String)CF_RESOURCE, (String)"org_periodType_mismatch", (Locale)this.ctx.getLocale()));
                    continue;
                }
                checkedCompanys.add(companyOrgUnitInfo);
            }
        }
        this.cachePeriodRange(checkedCompanys);
        this.allBizCompanys.clear();
        for (Map map : this.treeDatas) {
            List companys = (List)map.get("companys");
            ArrayList<CompanyOrgUnitInfo> bizCompanys = new ArrayList<CompanyOrgUnitInfo>(companys.size());
            for (CompanyOrgUnitInfo company : companys) {
                PeriodInfo[] periods;
                if (company.getBoolean("hasError") || (periods = this.periodss.get(company.getId().toString())) == null) continue;
                if (periods[0] == null || periods[1] == null) {
                    if (!company.getBoolean("inhere")) continue;
                    this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"company_notEnabled", (Locale)this.ctx.getLocale()));
                    continue;
                }
                if (!checkedCompanys.contains(company)) continue;
                bizCompanys.add(company);
                this.allBizCompanys.add(company);
            }
            map.put("companys", bizCompanys);
        }
    }

    protected Map<String, Object> buildTreeData(GLNRptBaseService.CompanyNode root) throws BOSException {
        HashMap<String, Object> treeData = new HashMap<String, Object>();
        GLNRptBaseService.CompanyNode node = root.childs.get(0);
        treeData.put("rootCompany", node.company);
        treeData.put("companys", node.getBizCompanys());
        return treeData;
    }

    public Set<CompanyOrgUnitInfo> getAllBizCompanyWithGL053(Set<CompanyOrgUnitInfo> allBizCompanys) throws BOSException, EASBizException {
        if (this.hasVirtual) {
            HashSet<CompanyOrgUnitInfo> coll = new HashSet<CompanyOrgUnitInfo>();
            GlParam glParam = GlParam.getGlParams((Context)this.ctx, (String)"GL_053", null);
            if (glParam.getBoolean("GL_053")) {
                HashSet<String> idSet = new HashSet<String>();
                for (CompanyOrgUnitInfo company : allBizCompanys) {
                    idSet.add(company.getId().toString());
                }
                BOSUuid currentUserID = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId();
                IOrgRange orgRange = OrgRangeFactory.getLocalInstance((Context)this.ctx);
                List compIdList = orgRange.getOrgIdByUserAndType((IObjectPK)new ObjectUuidPK(currentUserID), OrgRangeType.BIZ_ORG_TYPE);
                HashSet compIdSet = new HashSet(compIdList);
                idSet.retainAll(compIdSet);
                for (CompanyOrgUnitInfo company : allBizCompanys) {
                    if (!idSet.contains(company.getId().toString())) continue;
                    coll.add(company);
                }
                return coll;
            }
            return allBizCompanys;
        }
        return allBizCompanys;
    }

    private void insertDetailItemEmptyData() throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into  \n");
        sql.append(this.T_TMP_DataTable).append(" ( \n");
        sql.append("   companyID,\n");
        if (this.sumByUnion) {
            sql.append("   unionID,\n");
        }
        sql.append("   cashFlowItemID,\n");
        sql.append("   amount,\n");
        sql.append("   yearSum,");
        sql.append("   flag");
        sql.append(" ) \n");
        sql.append("    select \n");
        sql.append("        ?,  \n");
        if (this.sumByUnion) {
            sql.append("        ?,  \n");
        }
        sql.append("        item.fid,  \n");
        sql.append("        0,  \n");
        sql.append("        0,  \n");
        sql.append("       " + Flag.ITEM.getValue() + "  \n");
        sql.append("    from t_bd_cashFlowItem item \n");
        sql.append("    where ").append(" \n");
        if (this.itemViewSql != null) {
            sql.append(" item.fid ").append(this.itemViewSql).append(" \n");
            sql.append(" and ");
        }
        sql.append("    item.FisLeaf = 1 \n");
        if (!this.showSupplementItem) {
            sql.append("    and item.FType = 0 \n");
        }
        sql.append("    and not exists (select tt.cashFlowItemID from ").append(this.T_TMP_DataTable).append(" tt where tt.cashFlowItemID = item.fid and tt.companyID = ?)");
        for (CompanyOrgUnitInfo company : this.allBizCompanys) {
            ArrayList<String> params = new ArrayList<String>();
            String companyID = company.getId().toString();
            params.add(companyID);
            if (this.sumByUnion) {
                params.add(company.getString("unionId"));
            }
            params.add(companyID);
            this.execute(this.ctx, sql.toString(), params.toArray());
        }
    }

    private void insertOrgSumData() throws BOSException {
        if (this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.enumerate)) {
            return;
        }
        if (!this.sumByUnion) {
            int maxLevel;
            int tree;
            HashMap<Integer, Integer> maxLevels = new HashMap<Integer, Integer>();
            for (Map<String, Object> treeData : this.treeDatas) {
                List companys = (List)treeData.get("companys");
                tree = (Integer)treeData.get("tree");
                maxLevel = 0;
                for (CompanyOrgUnitInfo company : companys) {
                    maxLevel = Math.max(maxLevel, company.getLevel());
                }
                maxLevels.put(tree, maxLevel);
            }
            for (Map<String, Object> treeData : this.treeDatas) {
                CompanyOrgUnitInfo rootCompany = (CompanyOrgUnitInfo)treeData.get("rootCompany");
                if (rootCompany.isIsBizUnit()) continue;
                tree = (Integer)treeData.get("tree");
                for (int level = maxLevel = ((Integer)maxLevels.get(tree)).intValue(); level > rootCompany.getLevel(); --level) {
                    boolean isReturn = this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level) || level == rootCompany.getLevel() + 1;
                    this.insertVirtualOrgSumData(level, isReturn);
                }
            }
        } else {
            int maxLevel = 1;
            for (Map<String, Object> treeData : this.treeDatas) {
                List companys = (List)treeData.get("companys");
                for (CompanyOrgUnitInfo company : companys) {
                    maxLevel = Math.max(maxLevel, company.getInt("unionLevel"));
                }
            }
            int companyTopLevel = (Integer)this.result.get("companyTopLevel");
            for (int level = maxLevel; level > companyTopLevel; --level) {
                boolean isReturn = this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level) || level == companyTopLevel + 1;
                this.insertVirtualOrgSumData(level, isReturn);
            }
        }
    }

    private void insertVirtualOrgSumData(int level, boolean isReturn) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into  \n");
        sql.append(this.T_TMP_DataTable).append(" ( \n");
        if (!this.sumByUnion) {
            sql.append("   companyID,\n");
        } else {
            sql.append("   unionID,\n");
        }
        sql.append("   cashFlowItemID,\n");
        sql.append("   amount,\n");
        sql.append("   yearSum,");
        sql.append("   flag,");
        sql.append("   isReturn");
        sql.append(" ) \n");
        sql.append("  select \n");
        if (!this.sumByUnion) {
            sql.append("      company.FParentID, \n");
        } else {
            sql.append("      s.FParentID, \n");
        }
        sql.append("      tt.cashFlowItemID, \n");
        sql.append("      sum(tt.amount), \n");
        sql.append("      sum(tt.yearSum), \n");
        sql.append("      " + Flag.ITEM.getValue() + ", \n");
        sql.append("      " + (isReturn ? 1 : 0) + " \n");
        sql.append("  from ").append(this.T_TMP_DataTable).append(" tt  \n");
        if (!this.sumByUnion) {
            sql.append("  inner join t_org_company company on tt.companyID = company.fid  \n");
            sql.append("  where company.flevel = ? and tt.flag = " + Flag.ITEM.getValue() + " \n");
            sql.append("  group by tt.cashFlowItemID,company.FParentID \n");
        } else {
            sql.append("  inner join t_org_structure s on tt.unionID = s.fid  \n");
            sql.append("  where s.flevel = ? and tt.flag =  " + Flag.ITEM.getValue() + " \n");
            sql.append("  group by tt.cashFlowItemID,s.FParentID \n");
        }
        this.execute(this.ctx, sql.toString(), new Object[]{level});
    }

    private void insertItemSumData() throws BOSException, SQLException {
        int maxLevel = this.getItemMaxLevel();
        StringBuilder sql = new StringBuilder();
        sql.append("insert into  \n");
        sql.append(this.T_TMP_DataTable).append(" ( \n");
        sql.append("   companyID,\n");
        if (this.sumByUnion) {
            sql.append("   unionID,\n");
        }
        sql.append("   cashFlowItemID,\n");
        sql.append("   amount,\n");
        sql.append("   yearSum,\n");
        sql.append("   flag\n");
        sql.append(" ) \n");
        sql.append("  select \n");
        sql.append("      tt.companyID, \n");
        if (this.sumByUnion) {
            sql.append("      tt.unionID, \n");
        }
        sql.append("      item.FParentID, \n");
        sql.append("      sum(tt.amount * (case item.FDirection when 2 then -1 else 1 end) * (case pitem.FDirection when 2 then -1 else 1 end) ), \n");
        sql.append("      sum(tt.yearSum * (case item.FDirection when 2 then -1 else 1 end) * (case pitem.FDirection when 2 then -1 else 1 end)), \n");
        sql.append("      " + Flag.ITEM.getValue() + " \n");
        sql.append("  from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("  inner join t_bd_cashFlowItem item on tt.cashFlowItemID = item.fid  \n");
        sql.append("  inner join t_bd_cashFlowItem pitem on item.FParentID = pitem.fid  \n");
        sql.append("  where item.flevel = ? and tt.flag = " + Flag.ITEM.getValue() + "\n");
        if (!this.sumByUnion) {
            sql.append("  group by tt.companyID, item.FParentID \n");
        } else {
            sql.append("  group by tt.unionID, item.FParentID,tt.companyID \n");
        }
        while (maxLevel > 1) {
            this.execute(this.ctx, sql.toString(), new Object[]{maxLevel});
            --maxLevel;
        }
    }

    private int getItemMaxLevel() throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)"select max(flevel) maxlevel from t_bd_cashFlowItem");
        if (rs.next()) {
            int maxlevel = rs.getInt("maxlevel");
            return maxlevel;
        }
        return 6;
    }

    private void insertAsstSumData() throws BOSException {
        if (!this.showAsst) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("insert into  \n");
        sql.append(this.T_TMP_DataTable).append(" ( \n");
        sql.append("   companyID,\n");
        if (this.sumByUnion) {
            sql.append("   unionID,\n");
        }
        sql.append("   cashFlowItemID,\n");
        sql.append("   amount,\n");
        sql.append("   yearSum,");
        sql.append("   flag");
        sql.append(" ) \n");
        sql.append("   select companyID," + (this.sumByUnion ? "unionID," : "") + "cashFlowItemID,sum(amount),sum(yearSum)," + Flag.ITEM.getValue() + " \n");
        sql.append("   from ").append(this.T_TMP_DataTable).append(" where flag = " + Flag.ASST.getValue() + " group by companyID," + (this.sumByUnion ? "unionID," : "") + "cashFlowItemID  \n");
        this.execute(this.ctx, sql.toString());
    }

    private void updateFlagColumn() throws BOSException {
        StringBuilder updateFlagSql = new StringBuilder();
        if (this.showAsst) {
            updateFlagSql.append("update " + this.T_TMP_DataTable + " t set flag =  " + Flag.ASST.getValue()).append(" where exists(select item.fid from t_bd_cashFlowItem item where item.fid= t.cashFlowItemID and item.fasstaccountid is not null )");
            this.execute(this.ctx, updateFlagSql.toString());
            updateFlagSql.setLength(0);
            updateFlagSql.append("update " + this.T_TMP_DataTable + " t set flag =  " + Flag.ITEM.getValue()).append(" where exists(select item.fid from t_bd_cashFlowItem item where item.fid= t.cashFlowItemID and item.fasstaccountid is null )");
            this.execute(this.ctx, updateFlagSql.toString());
        } else {
            updateFlagSql.append("update " + this.T_TMP_DataTable + " t set flag =  " + Flag.ITEM.getValue() + " where flag = -1");
            this.execute(this.ctx, updateFlagSql.toString());
        }
    }

    private void mergeTempTables() throws BOSException {
        String detailSql = this.getDetailItemDataSQL();
        StringBuilder sql = new StringBuilder();
        sql.append("insert into  \n");
        sql.append(this.T_TMP_DataTable).append(" ( \n");
        sql.append("   companyID,\n");
        if (this.sumByUnion) {
            sql.append("   unionID,\n");
        }
        sql.append("   cashFlowItemID,\n");
        if (this.showAsst) {
            sql.append("   hgID,\n");
            sql.append("   FType,\n");
        }
        sql.append("   amount,\n");
        sql.append("   yearSum");
        sql.append(" ) \n");
        sql.append(detailSql);
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void buildData() throws SQLException, BOSException {
        if (!this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.enumerate)) {
            this.buildPrimaryData();
            Map<String, BigDecimal[]> cashNetAmounts = this.buildNetTotalRows(0);
            if (this.showCashInitEndBalance) {
                this.buildCashBalance(cashNetAmounts);
            }
            if (this.showSupplementItem) {
                this.buildSupplementData();
            }
            if (this.showCashInitEndBalance) {
                this.buildAdditionOfCash();
            }
        } else {
            Map<String, List<List<String>>> primaryData = this.getPrimaryData4Enumerate();
            Map<String, List<String>> netTotals = this.getNetTotals4Enumerate();
            Map<String, List<String>> cashBeginBalances = null;
            Map<String, List<String>> cashEndBalances = null;
            if (this.showCashInitEndBalance) {
                cashBeginBalances = this.getCashBeginBalance4Enumerate();
                cashEndBalances = this.getCashEndBalance4Enumerate(netTotals, cashBeginBalances);
            }
            Map<String, List<List<String>>> supplementData = null;
            if (this.showSupplementItem) {
                supplementData = this.getSupplementData4Enumerate();
            }
            Map<String, List<List<String>>> additions = null;
            if (this.showCashInitEndBalance) {
                additions = this.getAdditionOfCash();
            }
            for (String companyId : primaryData.keySet()) {
                this.seq = 0;
                this.rowsAddAll(primaryData.get(companyId));
                this.rowsAdd(netTotals.get(companyId));
                if (this.showCashInitEndBalance) {
                    this.rowsAdd(cashBeginBalances.get(companyId));
                    this.rowsAdd(cashEndBalances.get(companyId));
                }
                if (this.showSupplementItem) {
                    this.rowsAddAll(supplementData.get(companyId));
                }
                if (!this.showCashInitEndBalance) continue;
                this.rowsAddAll(additions.get(companyId));
            }
        }
    }

    private Map<String, List<List<String>>> getAdditionOfCash() throws BOSException, SQLException {
        BigDecimal[] bigDecimals;
        HashMap<String, List<List<String>>> additions = new HashMap<String, List<List<String>>>();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        String itemName = this.getCFResource("strAdd");
        List<String> categoryRowData = this.getCategoryRowData(-1, itemName);
        StringBuilder sql = new StringBuilder();
        sql.append("select");
        sql.append("    company.FName_" + loc + " companyName, \n");
        sql.append("    company.FLevel companyLevel, \n");
        sql.append("    company.fid companyId, \n");
        sql.append("    tt.flag flag, \n");
        sql.append("    tt.amount amount, \n");
        sql.append("    tt.yearSum yearSum \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("inner join t_org_company company on tt.companyID = company.fid \n");
        sql.append("where tt.flag in (4,5,6,7) \n");
        sql.append("order by company.FLongNumber,tt.flag ");
        IRowSet rs = this.executeQuery(this.ctx, sql.toString());
        LinkedHashMap<String, BigDecimal[]> netAmounts = new LinkedHashMap<String, BigDecimal[]>();
        String preCompanyId = null;
        ArrayList<List<String>> lists = null;
        while (rs.next()) {
            String companyId = rs.getString("companyId");
            if (!companyId.equals(preCompanyId)) {
                lists = new ArrayList<List<String>>();
                lists.add(categoryRowData);
                additions.put(companyId, lists);
            }
            int flag = rs.getInt("flag");
            BigDecimal amount = rs.getBigDecimal("amount");
            BigDecimal yearSum = rs.getBigDecimal("yearSum");
            String companyName = rs.getString("companyName");
            Integer companyLevel = rs.getInt("companyLevel");
            amount = amount == null ? BigDecimal.ZERO : amount;
            BigDecimal bigDecimal = yearSum = yearSum == null ? BigDecimal.ZERO : yearSum;
            if (flag == Flag.CASH_END.getValue()) {
                itemName = this.getCFResource("strCashEnd");
            } else if (flag == Flag.CASH_BEGIN.getValue()) {
                itemName = this.getCFResource("strJCahsBegin");
            } else if (flag == Flag.EQU_END.getValue()) {
                itemName = this.getCFResource("strAddSjdjwEnd");
            } else if (flag == Flag.EQU_BEGIN.getValue()) {
                itemName = this.getCFResource("strJSjdjwEnd");
            }
            lists.add(this.buildSpecialRow(itemName, 2, companyName, companyLevel, amount, yearSum, false));
            preCompanyId = companyId;
            String key = companyId + "@_" + companyName + "@_" + companyLevel;
            if (!netAmounts.containsKey(key)) {
                bigDecimals = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                netAmounts.put(key, bigDecimals);
            }
            bigDecimals = (BigDecimal[])netAmounts.get(key);
            if (flag == Flag.CASH_END.getValue() || flag == Flag.EQU_END.getValue()) {
                bigDecimals[0] = bigDecimals[0].add(amount);
                bigDecimals[1] = bigDecimals[1].add(yearSum);
                continue;
            }
            bigDecimals[0] = bigDecimals[0].add(amount.negate());
            bigDecimals[1] = bigDecimals[1].add(yearSum.negate());
        }
        String netItemName = this.getCFResource("strCashAndXjdjw");
        for (String key : netAmounts.keySet()) {
            String[] strs = key.split("@_");
            String companyId = strs[0];
            String companyName = strs[1];
            Integer companyLevel = Integer.parseInt(strs[2]);
            bigDecimals = (BigDecimal[])netAmounts.get(key);
            List<String> list = this.buildSpecialRow(netItemName, 2, companyName, companyLevel, bigDecimals[0], bigDecimals[1], false);
            ((List)additions.get(companyId)).add(list);
        }
        return additions;
    }

    private Map<String, List<List<String>>> getSupplementData4Enumerate() throws BOSException, SQLException {
        HashMap<String, List<List<String>>> supplementData = new HashMap<String, List<List<String>>>();
        String supplementSQL = this.getSelectSQL(1);
        IRowSet rs = this.executeQuery(this.ctx, supplementSQL);
        String preCompanyId = null;
        ArrayList<List<String>> lists = null;
        while (rs.next()) {
            String companyId = rs.getString("companyId");
            int itemLevel = rs.getInt("itemLevel");
            int isProfit = rs.getInt("isProfit");
            if (!companyId.equals(preCompanyId)) {
                lists = new ArrayList<List<String>>();
                supplementData.put(companyId, lists);
            }
            if (itemLevel == 1) {
                String itemName = rs.getString("itemName");
                lists.add(this.getCategoryRowData(this.digit, itemName));
            } else {
                List<String> rowData = this.buildItemRow(rs, CashFlowItemType.SECONDARY_TABLE_ITEM);
                if (isProfit == 1) {
                    rowData.set(this.colIndexes.get(this.COLUMN_IS_QUERY_ROW), "0");
                }
                if (itemLevel <= this.sumItemLevel) {
                    lists.add(rowData);
                }
            }
            preCompanyId = companyId;
        }
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        String itemName = this.getCFResource("strWork");
        StringBuilder sql = new StringBuilder();
        sql.append("select \n");
        sql.append("    company.fid companyId, \n");
        sql.append("    company.FLongNumber companyLongNumber, \n");
        sql.append("    company.FName_" + loc + " companyName, \n");
        sql.append("    company.FLevel companyLevel, \n");
        sql.append("    sum(tt.amount) amount, \n");
        sql.append("    sum(tt.yearSum) yearSum \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("inner join t_bd_cashFlowItem item on item.fid = tt.cashFlowItemID \n");
        sql.append("inner join t_org_company company on tt.companyID = company.fid \n");
        sql.append("where item.FisLeaf = 1 and item.FType = 1\n");
        sql.append("group by company.fid,company.FLongNumber,company.FName_" + loc + ",company.FLevel \n");
        sql.append("order by company.FLongNumber \n");
        rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        while (rs.next()) {
            String companyId = rs.getString("companyId");
            String companyName = rs.getString("companyName");
            Integer companyLevel = rs.getInt("companyLevel");
            BigDecimal amount = rs.getBigDecimal("amount");
            BigDecimal yearSum = rs.getBigDecimal("yearSum");
            List<String> list = this.buildSpecialRow(itemName, 2, companyName, companyLevel, amount, yearSum, true);
            ((List)supplementData.get(companyId)).add(list);
        }
        return supplementData;
    }

    private Map<String, List<String>> getCashEndBalance4Enumerate(Map<String, List<String>> netTotals, Map<String, List<String>> cashBeginBalances) {
        String itemName = this.getCFResource("strCashAndXjdjwEndBanlance");
        Integer amountIdx = this.colIndexes.get(this.COLUMN_AMOUNT);
        Integer yearSumIdx = this.colIndexes.get(this.COLUMN_YEAR_SUM);
        Integer itemNameIdx = this.colIndexes.get(this.COLUMN_CASH_FLOW_ITEM_NAME);
        int scale = this.isForCurrency ? this.currencyScale : this.maxScale;
        HashMap<String, List<String>> cashEndBalances = new HashMap<String, List<String>>();
        for (String key : netTotals.keySet()) {
            List<String> netTotal = netTotals.get(key);
            if (!cashBeginBalances.containsKey(key)) continue;
            ArrayList<String> cashEndBalance = this.copyRowData(netTotal);
            BigDecimal amount = netTotal.get(amountIdx) == null ? BigDecimal.ZERO : new BigDecimal(netTotal.get(amountIdx)).setScale(scale, 4);
            BigDecimal yearSum = netTotal.get(yearSumIdx) == null ? BigDecimal.ZERO : new BigDecimal(netTotal.get(yearSumIdx)).setScale(scale, 4);
            List<String> cashBeginBalance = cashBeginBalances.get(key);
            if (cashBeginBalance.get(amountIdx) != null) {
                amount = amount.add(new BigDecimal(cashBeginBalance.get(amountIdx)));
            }
            if (cashBeginBalance.get(yearSumIdx) != null) {
                yearSum = yearSum.add(new BigDecimal(cashBeginBalance.get(yearSumIdx)));
            }
            cashEndBalance.set(itemNameIdx, itemName);
            cashEndBalance.set(amountIdx, amount.compareTo(BigDecimal.ZERO) == 0 ? null : amount.toPlainString());
            cashEndBalance.set(yearSumIdx, yearSum.compareTo(BigDecimal.ZERO) == 0 ? null : yearSum.toPlainString());
            cashEndBalances.put(key, cashEndBalance);
        }
        return cashEndBalances;
    }

    private Map<String, List<String>> getCashBeginBalance4Enumerate() throws BOSException, SQLException {
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        String itemName = this.getCFResource("strAddCashAndXjdjwBegin");
        StringBuilder sql = new StringBuilder();
        sql.append("select");
        sql.append("    company.FName_" + loc + " companyName, \n");
        sql.append("    company.FLevel companyLevel, \n");
        sql.append("    company.Fid companyId, \n");
        sql.append("    tt.amount amount, \n");
        sql.append("    tt.yearSum yearSum \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("inner join t_org_company company on tt.companyID = company.Fid \n");
        sql.append("where tt.flag = ").append(Flag.ALL_CASH_BEGIN.getValue()).append("\n");
        sql.append("order by ");
        sql.append("company.FLongNumber");
        HashMap<String, List<String>> cashBegins = new HashMap<String, List<String>>();
        IRowSet rs = this.executeQuery(this.ctx, sql.toString());
        while (rs.next()) {
            String companyName = rs.getString("companyName");
            Integer companyLevel = rs.getInt("companyLevel");
            BigDecimal amount = rs.getBigDecimal("amount");
            BigDecimal yearSum = rs.getBigDecimal("yearSum");
            List<String> list = this.buildSpecialRow(itemName, 2, companyName, companyLevel, amount, yearSum, true);
            cashBegins.put(rs.getString("companyId"), list);
        }
        return cashBegins;
    }

    private Map<String, List<String>> getNetTotals4Enumerate() throws BOSException, SQLException {
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        StringBuilder sql = new StringBuilder();
        sql.append("select");
        sql.append("    company.FName_" + loc + " companyName, \n");
        sql.append("    company.FLevel companyLevel, \n");
        sql.append("    company.fid companyId, \n");
        sql.append("    sum(tt.amount) amount, \n");
        sql.append("    sum(tt.yearSum) yearSum \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("inner join t_bd_cashFlowItem item on tt.cashFlowItemID = item.fid \n");
        sql.append("inner join t_org_company company on tt.companyID = company.fid \n");
        sql.append("where item.FType = 0 \n");
        sql.append("and item.FLevel = 1 \n");
        sql.append("group by company.FLongNumber,company.FName_" + loc + ", company.fid ,company.FLevel \n");
        sql.append("order by company.FLongNumber ");
        List<String> list = null;
        HashMap<String, List<String>> cashNetAmounts = new HashMap<String, List<String>>();
        String itemName = this.getCFResource("strCashSum");
        IRowSet rs = this.executeQuery(this.ctx, sql.toString());
        while (rs.next()) {
            String companyId = rs.getString("companyId");
            String companyName = rs.getString("companyName");
            Integer companyLevel = rs.getInt("companyLevel");
            BigDecimal amount = rs.getBigDecimal("amount");
            BigDecimal yearSum = rs.getBigDecimal("yearSum");
            list = this.buildSpecialRow(itemName, 2, companyName, companyLevel, amount, yearSum, true);
            cashNetAmounts.put(companyId, list);
        }
        return cashNetAmounts;
    }

    private Map<String, List<List<String>>> getPrimaryData4Enumerate() throws BOSException, SQLException {
        LinkedHashMap<String, List<List<String>>> primaryData = new LinkedHashMap<String, List<List<String>>>();
        int itemNameIdx = this.colIndexes.get(this.COLUMN_CASH_FLOW_ITEM_NAME);
        int itemLevelIdx = this.colIndexes.get(this.COLUMN_ITEM_LEVEL);
        int isNetRowIdx = this.colIndexes.get(this.COLUMN_IS_NET_ROW);
        int isQueryRowIdx = this.colIndexes.get(this.COLUMN_IS_QUERY_ROW);
        String primarySQL = this.getSelectSQL(0);
        IRowSet rs = this.executeQuery(this.ctx, primarySQL);
        List<String> preNetAmount = null;
        ArrayList<List<String>> lists = null;
        int i = 0;
        int size = rs.size();
        while (rs.next()) {
            String companyId = rs.getString("companyId");
            int itemLevel = rs.getInt("itemLevel");
            int isExchange = rs.getInt("isExchange");
            if (!primaryData.containsKey(companyId)) {
                this.digit = 1;
                if (preNetAmount != null && lists != null) {
                    lists.add(preNetAmount);
                }
                preNetAmount = null;
                lists = new ArrayList<List<String>>();
                primaryData.put(companyId, lists);
            }
            List<String> rowData = this.buildItemRow(rs, CashFlowItemType.MASTER_TABLE_ITEM);
            String itemName = rowData.get(itemNameIdx);
            if (itemLevel == 1) {
                if (preNetAmount != null) {
                    lists.add(preNetAmount);
                }
                lists.add(this.getCategoryRowData(this.digit++, itemName));
                rowData.set(itemNameIdx, this.getNetAmountString(itemName));
                rowData.set(itemLevelIdx, "2");
                rowData.set(isNetRowIdx, "1");
                rowData.set(isQueryRowIdx, "0");
                preNetAmount = rowData;
            } else if (isExchange != 1 || this.showExchangeItem) {
                lists.add(rowData);
            }
            if (i == size - 1 && preNetAmount != null) {
                lists.add(preNetAmount);
            }
            ++i;
        }
        return primaryData;
    }

    private void buildAdditionOfCash() throws BOSException, SQLException {
        int lv;
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        String itemName = this.getCFResource("strAdd");
        List<String> categoryRowData = this.getCategoryRowData(-1, itemName);
        this.rowsAdd(categoryRowData);
        StringBuilder sql = new StringBuilder();
        sql.append("select");
        if (!this.sumByUnion) {
            sql.append("    company.FName_" + loc + " companyName, \n");
            sql.append("    company.FLevel companyLevel, \n");
            sql.append("    company.fid companyId, \n");
        } else {
            sql.append("    unit.FName_" + loc + " companyName, \n");
            sql.append("    unit.FLevel companyLevel, \n");
            sql.append("    s.fid unionID, \n");
        }
        sql.append("    tt.flag flag, \n");
        sql.append("    tt.amount amount, \n");
        sql.append("    tt.yearSum yearSum \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        if (!this.sumByUnion) {
            sql.append("inner join t_org_company company on tt.companyID = company.fid \n");
        } else {
            sql.append("inner join t_org_structure s on tt.unionID = s.fid \n");
            sql.append("inner join t_org_baseUnit unit on unit.fid = s.FUnitID \n");
        }
        sql.append("where tt.flag in (4,5,6,7) \n");
        sql.append("and tt.isReturn = 1 \n");
        if (!this.sumByUnion) {
            if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
                lv = this.root.childs.get((int)0).company.getLevel() + this.companyLevel - 1;
                sql.append("and company.FLevel <= " + lv + "\n");
            }
        } else if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
            lv = 1 + this.companyLevel - 1;
            sql.append("and s.FLevel <= " + lv + "\n");
        }
        sql.append("order by tt.flag, ");
        sql.append(this.sumByUnion ? "s.FLongNumber" : "company.FLongNumber");
        IRowSet rs = this.executeQuery(this.ctx, sql.toString());
        LinkedHashMap<String, BigDecimal[]> netAmounts = new LinkedHashMap<String, BigDecimal[]>();
        while (rs.next()) {
            BigDecimal[] bigDecimals;
            int flag = rs.getInt("flag");
            BigDecimal amount = rs.getBigDecimal("amount");
            BigDecimal yearSum = rs.getBigDecimal("yearSum");
            String companyName = rs.getString("companyName");
            Integer companyLevel = rs.getInt("companyLevel");
            amount = amount == null ? BigDecimal.ZERO : amount;
            yearSum = yearSum == null ? BigDecimal.ZERO : yearSum;
            String orgId = rs.getString(!this.sumByUnion ? "companyId" : "unionID");
            if (flag == Flag.CASH_END.getValue()) {
                itemName = this.getCFResource("strCashEnd");
            } else if (flag == Flag.CASH_BEGIN.getValue()) {
                itemName = this.getCFResource("strJCahsBegin");
            } else if (flag == Flag.EQU_END.getValue()) {
                itemName = this.getCFResource("strAddSjdjwEnd");
            } else if (flag == Flag.EQU_BEGIN.getValue()) {
                itemName = this.getCFResource("strJSjdjwEnd");
            }
            String key = orgId + "@_" + companyName + "@_" + companyLevel;
            if (!netAmounts.containsKey(key)) {
                bigDecimals = new BigDecimal[]{BigDecimal.ZERO, BigDecimal.ZERO};
                netAmounts.put(key, bigDecimals);
            }
            bigDecimals = (BigDecimal[])netAmounts.get(key);
            if (flag == Flag.CASH_END.getValue() || flag == Flag.EQU_END.getValue()) {
                bigDecimals[0] = bigDecimals[0].add(amount);
                bigDecimals[1] = bigDecimals[1].add(yearSum);
            } else {
                bigDecimals[0] = bigDecimals[0].add(amount.negate());
                bigDecimals[1] = bigDecimals[1].add(yearSum.negate());
            }
            this.rowsAdd(this.buildSpecialRow(itemName, 2, companyName, companyLevel, amount, yearSum, false));
        }
        String netItemName = this.getCFResource("strCashAndXjdjw");
        for (String key : netAmounts.keySet()) {
            String[] strs = key.split("@_");
            String companyName = strs[1];
            Integer companyLevel = Integer.parseInt(strs[2]);
            BigDecimal[] bigDecimals = (BigDecimal[])netAmounts.get(key);
            this.rowsAdd(this.buildSpecialRow(netItemName, 2, companyName, companyLevel, bigDecimals[0], bigDecimals[1], false));
        }
    }

    private void buildCashBalance(Map<String, BigDecimal[]> cashNetAmounts) throws BOSException, SQLException {
        int lv;
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        String itemName = this.getCFResource("strAddCashAndXjdjwBegin");
        StringBuilder sql = new StringBuilder();
        sql.append("select");
        if (!this.sumByUnion) {
            sql.append("    company.FName_" + loc + " companyName, \n");
            sql.append("    company.FLevel companyLevel, \n");
            sql.append("    company.fid companyId, \n");
        } else {
            sql.append("    unit.FName_" + loc + " companyName, \n");
            sql.append("    unit.FLevel companyLevel, \n");
            sql.append("    s.fid unionID, \n");
        }
        sql.append("    tt.amount amount, \n");
        sql.append("    tt.yearSum yearSum \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        if (!this.sumByUnion) {
            sql.append("inner join t_org_company company on tt.companyID = company.fid \n");
        } else {
            sql.append("inner join t_org_structure s on tt.unionID = s.fid \n");
            sql.append("inner join t_org_baseUnit unit on unit.fid = s.FUnitID \n");
        }
        sql.append("where tt.flag = ").append(Flag.ALL_CASH_BEGIN.getValue()).append("\n");
        sql.append("and tt.isReturn = 1 \n");
        if (!this.sumByUnion) {
            if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
                lv = this.root.childs.get((int)0).company.getLevel() + this.companyLevel - 1;
                sql.append("and company.FLevel <= " + lv + "\n");
            }
        } else if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
            lv = 1 + this.companyLevel - 1;
            sql.append("and s.FLevel <= " + lv + "\n");
        }
        sql.append("order by ");
        sql.append(this.sumByUnion ? "s.FLongNumber" : "company.FLongNumber");
        LinkedHashMap<String, List<String>> cashBegins = new LinkedHashMap<String, List<String>>();
        IRowSet rs = this.executeQuery(this.ctx, sql.toString());
        while (rs.next()) {
            String companyName = rs.getString("companyName");
            Integer companyLevel = rs.getInt("companyLevel");
            BigDecimal amount = rs.getBigDecimal("amount");
            BigDecimal yearSum = rs.getBigDecimal("yearSum");
            List<String> list = this.buildSpecialRow(itemName, 2, companyName, companyLevel, amount, yearSum, true);
            this.rowsAdd(list);
            cashBegins.put(rs.getString(!this.sumByUnion ? "companyId" : "unionID"), list);
        }
        itemName = this.getCFResource("strCashAndXjdjwEndBanlance");
        this.buildCashEndBalanceRow(cashNetAmounts, itemName, cashBegins);
    }

    private void buildCashEndBalanceRow(Map<String, BigDecimal[]> cashNetAmounts, String itemName, Map<String, List<String>> cashBegins) {
        int itemNameIdx = this.colIndexes.get(this.COLUMN_CASH_FLOW_ITEM_NAME);
        int amountIdx = this.colIndexes.get(this.COLUMN_AMOUNT);
        int yearSumIdx = this.colIndexes.get(this.COLUMN_YEAR_SUM);
        int itemLevelIdx = this.colIndexes.get(this.COLUMN_ITEM_LEVEL);
        int scale = this.isForCurrency ? this.currencyScale : this.maxScale;
        for (String key : cashBegins.keySet()) {
            List<String> rowData = cashBegins.get(key);
            ArrayList<String> list = this.copyRowData(rowData);
            BigDecimal amount = cashNetAmounts.get(key)[0].add(rowData.get(amountIdx) == null ? BigDecimal.ZERO : new BigDecimal(rowData.get(amountIdx))).setScale(scale, 4);
            BigDecimal yearSum = cashNetAmounts.get(key)[1].add(rowData.get(yearSumIdx) == null ? BigDecimal.ZERO : new BigDecimal(rowData.get(yearSumIdx))).setScale(scale, 4);
            list.set(itemNameIdx, itemName);
            list.set(itemLevelIdx, "1");
            list.set(amountIdx, amount.compareTo(BigDecimal.ZERO) == 0 ? null : amount.toPlainString());
            list.set(yearSumIdx, yearSum.compareTo(BigDecimal.ZERO) == 0 ? null : yearSum.toPlainString());
            this.rowsAdd(list);
        }
    }

    private ArrayList<String> copyRowData(List<String> rowData) {
        ArrayList<String> newList = new ArrayList<String>();
        for (String ele : rowData) {
            newList.add(ele);
        }
        return newList;
    }

    private void rowsAdd(List<String> list) {
        if (list == null) {
            return;
        }
        int seqColumnIdx = this.colIndexes.get(this.COLUMN_SEQ);
        int itemNameColumnIdx = this.colIndexes.get(this.COLUMN_CASH_FLOW_ITEM_NAME);
        int itemLevelColumnIdx = this.colIndexes.get(this.COLUMN_ITEM_LEVEL);
        int size = this.rows.size();
        String preItemName = (String)((List)this.rows.get(size - 1)).get(itemNameColumnIdx);
        String preItemLevel = (String)((List)this.rows.get(size - 1)).get(itemLevelColumnIdx);
        if (size != 2 && !StringUtils.isEmpty((String)preItemName) && !StringUtils.isEmpty((String)preItemLevel)) {
            String itemName = list.get(itemNameColumnIdx);
            String itemLevel = list.get(itemLevelColumnIdx);
            if (!"1".equals(itemLevel)) {
                if (preItemName.equals(itemName)) {
                    list.set(seqColumnIdx, this.seq.toString());
                } else {
                    this.seq = this.seq + 1;
                    list.set(seqColumnIdx, this.seq.toString());
                }
            }
        }
        this.rows.add(list);
    }

    private void rowsAddAll(List<List<String>> lists) {
        if (lists == null) {
            return;
        }
        for (List<String> list : lists) {
            this.rowsAdd(list);
        }
    }

    private void buildPrimaryData() throws BOSException, SQLException {
        int itemNameIdx = this.colIndexes.get(this.COLUMN_CASH_FLOW_ITEM_NAME);
        int itemLevelIdx = this.colIndexes.get(this.COLUMN_ITEM_LEVEL);
        int isNetRowIdx = this.colIndexes.get(this.COLUMN_IS_NET_ROW);
        int isQueryRowIdx = this.colIndexes.get(this.COLUMN_IS_QUERY_ROW);
        String primarySQL = this.getSelectSQL(0);
        IRowSet rs = this.executeQuery(this.ctx, primarySQL);
        ArrayList<List<String>> netAmounts = new ArrayList<List<String>>();
        String preItem = null;
        while (rs.next()) {
            int itemLevel = rs.getInt("itemLevel");
            List<String> list = this.buildItemRow(rs, CashFlowItemType.MASTER_TABLE_ITEM);
            int isExchange = rs.getInt("isExchange");
            String itemName = list.get(itemNameIdx);
            if (itemLevel == 1) {
                if (preItem == null || !itemName.equals(preItem)) {
                    for (List list2 : netAmounts) {
                        this.rowsAdd(list2);
                    }
                    netAmounts.clear();
                    this.rowsAdd(this.getCategoryRowData(this.digit++, itemName));
                }
                list.set(itemNameIdx, this.getNetAmountString(itemName));
                list.set(itemLevelIdx, "2");
                list.set(isNetRowIdx, "1");
                list.set(isQueryRowIdx, "0");
                netAmounts.add(list);
            } else if (isExchange != 1 || this.showExchangeItem) {
                this.rowsAdd(list);
            }
            preItem = itemName;
        }
        for (List list : netAmounts) {
            this.rowsAdd(list);
        }
    }

    private void buildSupplementData() throws SQLException, BOSException {
        String supplementSQL = this.getSelectSQL(1);
        IRowSet rs = this.executeQuery(this.ctx, supplementSQL);
        String preItem = null;
        while (rs.next()) {
            int isProfit = rs.getInt("isProfit");
            int itemLevel = rs.getInt("itemLevel");
            String itemName = rs.getString("itemName");
            if (itemLevel == 1) {
                if (preItem != null && itemName.equals(preItem)) continue;
                this.rowsAdd(this.getCategoryRowData(this.digit++, itemName));
                preItem = itemName;
                continue;
            }
            List<String> rowData = this.buildItemRow(rs, CashFlowItemType.SECONDARY_TABLE_ITEM);
            if (isProfit == 1) {
                rowData.set(this.colIndexes.get(this.COLUMN_IS_QUERY_ROW), "0");
            }
            this.rowsAdd(rowData);
        }
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        String itemName = this.getCFResource("strWork");
        StringBuilder sql = new StringBuilder();
        sql.append("select \n");
        if (!this.sumByUnion) {
            sql.append("    company.FLongNumber companyLongNumber, \n");
            sql.append("    company.FName_" + loc + " companyName, \n");
            sql.append("    company.FLevel companyLevel, \n");
        } else {
            sql.append("    s.FLongNumber companyLongNumber, \n");
            sql.append("    unit.FName_" + loc + " companyName, \n");
            sql.append("    s.FLevel companyLevel, \n");
        }
        sql.append("    sum(tt.amount) amount, \n");
        sql.append("    sum(tt.yearSum) yearSum, \n");
        sql.append("    tt.isReturn isReturn \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("inner join t_bd_cashFlowItem item on item.fid = tt.cashFlowItemID \n");
        if (!this.sumByUnion) {
            sql.append("inner join t_org_company company on tt.companyID = company.fid \n");
            sql.append("where item.FisLeaf = 1 and item.FType = 1\n");
            if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
                int lv = this.root.childs.get((int)0).company.getLevel() + this.companyLevel - 1;
                sql.append("and company.FLevel <= " + lv + "\n");
            }
            sql.append("group by company.FLongNumber,company.FName_" + loc + ",company.FLevel,tt.isReturn \n");
            sql.append("order by company.FLongNumber \n");
        } else {
            sql.append("left join T_ORG_Structure s on s.FID = tt.UnionID \n");
            sql.append("left join t_org_baseUnit unit on unit.FID = s.FUnitID \n");
            sql.append("where item.FisLeaf = 1 and item.FType = 1\n");
            if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
                int lv = 1 + this.companyLevel - 1;
                sql.append("and s.FLevel <= " + lv + "\n");
            }
            sql.append("group by s.FLongNumber,unit.FName_" + loc + ",s.FLevel,tt.isReturn \n");
            sql.append("order by s.FLongNumber \n");
        }
        rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        while (rs.next()) {
            int isReturn = rs.getInt("isReturn");
            if (isReturn != 1) continue;
            String companyName = rs.getString("companyName");
            Integer companyLevel = rs.getInt("companyLevel");
            BigDecimal amount = rs.getBigDecimal("amount");
            BigDecimal yearSum = rs.getBigDecimal("yearSum");
            List<String> list = this.buildSpecialRow(itemName, 2, companyName, companyLevel, amount, yearSum, true);
            this.rowsAdd(list);
        }
    }

    private Map<String, BigDecimal[]> buildNetTotalRows(int itemTypeValue) throws SQLException, BOSException {
        int lv;
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        StringBuilder sql = new StringBuilder();
        sql.append("select");
        if (!this.sumByUnion) {
            sql.append("    company.FName_" + loc + " companyName, \n");
            sql.append("    company.FLevel companyLevel, \n");
            sql.append("    company.Fid companyId, \n");
        } else {
            sql.append("    unit.FName_" + loc + " companyName, \n");
            sql.append("    s.FLevel companyLevel, \n");
            sql.append("    s.Fid unionID, \n");
        }
        sql.append("    sum(tt.amount) amount, \n");
        sql.append("    sum(tt.yearSum) yearSum \n");
        sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
        sql.append("inner join t_bd_cashFlowItem item on tt.cashFlowItemID = item.Fid \n");
        if (!this.sumByUnion) {
            sql.append("inner join t_org_company company on tt.companyID = company.Fid \n");
        } else {
            sql.append("left join t_org_structure s on tt.unionID = s.fid \n");
            sql.append("left join t_org_baseUnit unit on s.FUnitID = unit.fid \n");
        }
        sql.append("where item.FType = ").append(itemTypeValue).append("\n");
        sql.append("and item.FLevel = 1 \n");
        sql.append("and tt.isReturn = 1 \n");
        if (!this.sumByUnion) {
            if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
                lv = this.root.childs.get((int)0).company.getLevel() + this.companyLevel - 1;
                sql.append("and company.FLevel <= " + lv + "\n");
            }
            sql.append("group by company.FLongNumber,company.FName_" + loc + ", company.fid ,company.FLevel \n");
            sql.append("order by company.FLongNumber ");
        } else {
            if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
                lv = 1 + this.companyLevel - 1;
                sql.append("and s.FLevel <= " + lv + "\n");
            }
            sql.append("group by s.FLongNumber,unit.FName_" + loc + ", s.fid ,s.FLevel \n");
            sql.append("order by s.FLongNumber ");
        }
        HashMap<String, BigDecimal[]> cashNetAmounts = new HashMap<String, BigDecimal[]>();
        String itemName = this.getCFResource("strCashSum");
        IRowSet rs = this.executeQuery(this.ctx, sql.toString());
        while (rs.next()) {
            String companyName = rs.getString("companyName");
            Integer companyLevel = rs.getInt("companyLevel");
            BigDecimal amount = rs.getBigDecimal("amount");
            BigDecimal yearSum = rs.getBigDecimal("yearSum");
            BigDecimal[] cashNetAmount = new BigDecimal[]{amount, yearSum};
            cashNetAmounts.put(rs.getString(!this.sumByUnion ? "companyId" : "unionID"), cashNetAmount);
            List<String> list = this.buildSpecialRow(itemName, 2, companyName, companyLevel, amount, yearSum, true);
            this.rowsAdd(list);
        }
        return cashNetAmounts;
    }

    private List<String> buildSpecialRow(String itemName, Integer itemLevel, String companyName, Integer companyLevel, BigDecimal amount, BigDecimal yearSum, boolean isNetRow) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(itemName);
        list.add(null);
        list.add(companyName);
        if (this.showAsst) {
            list.add(null);
            list.add(null);
        }
        int scale = this.isForCurrency ? this.currencyScale : this.maxScale;
        list.add(amount.compareTo(BigDecimal.ZERO) == 0 ? null : amount.setScale(scale, 4).toPlainString());
        list.add(yearSum.compareTo(BigDecimal.ZERO) == 0 ? null : yearSum.setScale(scale, 4).toPlainString());
        list.add(itemLevel.toString());
        list.add(companyLevel.toString());
        list.add(isNetRow ? "1" : "0");
        list.add(null);
        list.add(null);
        if (this.showAsst) {
            list.add(null);
            list.add("0");
        }
        list.add("0");
        return list;
    }

    private String getSelectSQL(int itemType) {
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        StringBuilder sql = new StringBuilder();
        if (!this.sumByUnion) {
            sql.append("select");
            sql.append("    item.FName_" + loc + " itemName, \n");
            sql.append("    item.FLevel itemLevel, \n");
            sql.append("    item.Fid itemID, \n");
            if (itemType == 0) {
                sql.append("    item.FisExchange isExchange, \n");
            } else {
                sql.append("    item.FisProfit isProfit, \n");
            }
            sql.append("    company.FName_" + loc + " companyName, \n");
            sql.append("    company.FLevel companyLevel, \n");
            sql.append("    company.fid companyId, \n");
            if (this.showAsst && itemType == 0) {
                sql.append("    tt.hgID hgID, \n");
                sql.append("    tt.FType type, \n");
            }
            sql.append("    tt.amount amount, \n");
            sql.append("    tt.yearSum yearSum, \n");
            sql.append("    tt.flag flag, \n");
            sql.append("    company.FisLeaf canQuery \n");
            sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
            sql.append("inner join t_bd_cashFlowItem item on tt.cashFlowItemID = item.fid \n");
            sql.append("left join t_org_company company on tt.companyID = company.fid \n");
            sql.append("where item.FType = ").append(itemType).append("\n");
            if (!this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.enumerate)) {
                sql.append("and tt.isReturn = 1\n");
            }
            sql.append("and item.FLevel <= " + this.sumItemLevel + " \n");
            if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
                int lv = this.root.childs.get((int)0).company.getLevel() + this.companyLevel - 1;
                sql.append("and company.FLevel <= " + lv + "\n");
            }
            if (!this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.enumerate)) {
                sql.append("order by item.FLongNumber ,company.FLongNumber  \n");
            } else {
                sql.append("order by company.FLongNumber, item.FLongNumber  \n");
            }
            if (this.showAsst && itemType == 0) {
                sql.append(",tt.flag desc ");
            }
        } else {
            sql.append("select");
            sql.append("    item.FName_" + loc + " itemName, \n");
            sql.append("    item.FLevel itemLevel, \n");
            sql.append("    item.Fid itemID, \n");
            if (itemType == 0) {
                sql.append("    item.FisExchange isExchange, \n");
            } else {
                sql.append("    item.FisProfit isProfit, \n");
            }
            sql.append("    unit.FName_" + loc + " companyName, \n");
            sql.append("    s.FLevel companyLevel, \n");
            sql.append("    s.FID unionID, \n");
            sql.append("    tt.companyID companyId, \n");
            if (this.showAsst && itemType == 0) {
                sql.append("    tt.hgID hgID, \n");
                sql.append("    tt.FType type, \n");
            }
            sql.append("    tt.amount amount, \n");
            sql.append("    tt.yearSum yearSum, \n");
            sql.append("    tt.flag flag, \n");
            sql.append("    case when tt.companyID is not null then 1 else 0 end canQuery \n");
            sql.append("from ").append(this.T_TMP_DataTable).append(" tt  \n");
            sql.append("inner join t_bd_cashFlowItem item on tt.cashFlowItemID = item.fid \n");
            sql.append("left join T_ORG_Structure s on s.FID = tt.UnionID \n");
            sql.append("left join t_org_baseUnit unit on unit.FID = s.FUnitID \n");
            sql.append("where item.FType = ").append(itemType).append("\n");
            sql.append("and tt.isReturn = 1\n");
            sql.append("and item.FLevel <= " + this.sumItemLevel + " \n");
            if (this.companyLevel > 0 && this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level)) {
                int lv = 1 + this.companyLevel - 1;
                sql.append("and s.FLevel <= " + lv + "\n");
            }
            sql.append("order by item.FLongNumber ,s.FLongNumber  \n");
            if (this.showAsst && itemType == 0) {
                sql.append(",tt.flag desc ");
            }
        }
        if (this.showAsst && itemType == 0) {
            sql.append(", tt.FType, tt.hgID \n");
        }
        return sql.toString();
    }

    private List<String> getCategoryRowData(int digit, String itemName) {
        ArrayList<String> rowData = new ArrayList<String>();
        rowData.add(this.getBigDigitString(digit) + itemName);
        for (int i = 0; i < this.colIndexes.size() - 1; ++i) {
            rowData.add(null);
        }
        rowData.set(this.colIndexes.get(this.COLUMN_ITEM_LEVEL), "1");
        return rowData;
    }

    private String getBigDigitString(int digit) {
        if (digit < 0) {
            return "";
        }
        return this.getCFResource(String.valueOf(digit));
    }

    private String getNetAmountString(String sumName) {
        StringBuilder sbReturn = new StringBuilder(this.getCFResource("netAmount"));
        int pos = sbReturn.indexOf("@");
        sbReturn.replace(pos, pos + 1, sumName);
        return sbReturn.toString();
    }

    public String getCFResource(String resName) {
        return ResourceBase.getString((String)CF_RESOURCE, (String)resName, (Locale)this.ctx.getLocale());
    }

    private List<String> buildItemRow(IRowSet rs, CashFlowItemType itemType) throws SQLException, BOSException {
        ArrayList<String> list = new ArrayList<String>();
        String itemName = rs.getString("itemName");
        Integer itemLevel = rs.getInt("itemLevel");
        String companyName = rs.getString("companyName");
        Integer companyLevel = rs.getInt("companyLevel");
        BigDecimal amount = rs.getBigDecimal("amount");
        BigDecimal yearSum = rs.getBigDecimal("yearSum");
        String itemID = rs.getString("itemID");
        String companyID = rs.getString("companyId");
        int flag = rs.getInt("flag");
        boolean isAsstRow = false;
        if (flag == Flag.ASST.getValue()) {
            isAsstRow = true;
        }
        list.add(itemName);
        list.add(null);
        list.add(companyName);
        if (this.showAsst && itemType == CashFlowItemType.MASTER_TABLE_ITEM) {
            Integer type = rs.getInt("type");
            list.add(this.typeAlias.get(type));
        } else if (this.showAsst) {
            list.add(null);
        }
        if (this.showAsst && itemType == CashFlowItemType.MASTER_TABLE_ITEM) {
            String hgID = rs.getString("hgID");
            this.setHgColumn(hgID, list, itemType);
        } else if (this.showAsst) {
            list.add(null);
        }
        int scale = this.isForCurrency ? this.currencyScale : this.maxScale;
        list.add(amount.compareTo(BigDecimal.ZERO) == 0 ? null : amount.setScale(scale, 4).toPlainString());
        list.add(yearSum.compareTo(BigDecimal.ZERO) == 0 ? null : yearSum.setScale(scale, 4).toPlainString());
        list.add(itemLevel.toString());
        list.add(companyLevel.toString());
        list.add("0");
        list.add(itemID);
        list.add(companyID);
        if (this.showAsst && itemType == CashFlowItemType.MASTER_TABLE_ITEM) {
            list.add(rs.getString("hgID"));
            list.add(isAsstRow ? "1" : "0");
        } else if (this.showAsst) {
            list.add(null);
            list.add("0");
        }
        int canQuery = rs.getInt("canQuery");
        list.add(canQuery == 1 ? "1" : "0");
        return list;
    }

    private void setHgColumn(String hgID, List<String> list, CashFlowItemType itemType) throws BOSException {
        if (!this.showAsst) {
            return;
        }
        if (itemType == CashFlowItemType.SECONDARY_TABLE_ITEM || StringUtils.isEmpty((String)hgID)) {
            list.add(null);
            return;
        }
        if (this.hgNameCache.containsKey(hgID)) {
            list.add(this.hgNameCache.get(hgID));
            return;
        }
        Map hg = (Map)this.hgs.get(hgID);
        List<AsstActTypeInfo> asstActTypes = this.getAsstActTypes(this.ctx, this.hgIdToAsstAccountIds.get(hgID));
        StringBuilder asstStr = new StringBuilder();
        if (hg != null && asstActTypes != null) {
            for (int k = 0; k < asstActTypes.size(); ++k) {
                String number;
                AsstActTypeInfo asstActType = asstActTypes.get(k);
                asstStr.append(asstActType.getName());
                asstStr.append(":");
                if (!this.showAsstNumber && !this.showAsstLongName) {
                    asstStr.append((String)hg.get(asstActType.getNumber() + ".name"));
                } else if (this.showAsstNumber && !this.showAsstLongName) {
                    if (asstActType.isUseLongNumber()) {
                        number = (String)hg.get(asstActType.getNumber() + ".longNumber");
                        if (number != null) {
                            number = number.replace('!', '.');
                        }
                    } else {
                        number = (String)hg.get(asstActType.getNumber() + ".number");
                    }
                    asstStr.append(number);
                    asstStr.append(" ");
                    asstStr.append((String)hg.get(asstActType.getNumber() + ".name"));
                } else if (!this.showAsstNumber && this.showAsstLongName) {
                    asstStr.append((String)hg.get(asstActType.getNumber() + ".longName"));
                } else {
                    if (asstActType.isUseLongNumber()) {
                        number = (String)hg.get(asstActType.getNumber() + ".longNumber");
                        if (number != null) {
                            number = number.replace('!', '.');
                        }
                    } else {
                        number = (String)hg.get(asstActType.getNumber() + ".number");
                    }
                    asstStr.append(number);
                    asstStr.append(" ");
                    asstStr.append((String)hg.get(asstActType.getNumber() + ".longName"));
                }
                asstStr.append(";");
            }
        }
        String hgName = asstStr.toString();
        list.add(hgName);
        this.hgNameCache.put(hgID, hgName);
    }

    private String getDetailItemDataSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("select\n");
        sql.append("    case when t.companyID is null then idt.companyID else t.companyID end  as companyID,\n");
        if (this.sumByUnion) {
            sql.append("    case when t.unionID is null then idt.unionID else t.unionID end  as unionID,\n");
        }
        sql.append("    case when t.cashFlowItemID is null then idt.cashFlowItemID else t.cashFlowItemID end  as cashFlowItemID,\n");
        if (this.showAsst) {
            sql.append("    case when t.cashFlowItemID is null then idt.hgID else t.hgID end  as hgID,\n");
            sql.append("    case when t.cashFlowItemID is null then idt.FType else t.FType end  as FType,\n");
        }
        sql.append("    isnull(t.amount,0) as amount,\n");
        sql.append("    case when t.cashFlowItemID is null then isnull(idt.yearSum,0) else (isnull(idt.yearSum,0) + isnull(t.yearSum,0)) end  as yearSum\n");
        sql.append("from\n");
        sql.append("    (\n");
        sql.append("        select\n");
        sql.append("            case when yst.companyID is null then ate.companyID else yst.companyID end as companyID,\n");
        if (this.sumByUnion) {
            sql.append("            case when yst.unionID is null then ate.unionID else yst.unionID end as unionID,\n");
        }
        sql.append("            case when yst.cashFlowItemID is null then ate.cashFlowItemID else yst.cashFlowItemID end as cashFlowItemID,\n");
        if (this.showAsst) {
            sql.append("            case when yst.cashFlowItemID is null then ate.hgID else yst.hgID end as hgID,\n");
            sql.append("            case when yst.cashFlowItemID is null then ate.FType else yst.FType end as FType,\n");
        }
        sql.append("            ate.amount as amount,\n");
        sql.append("            yst.yearSum as yearSum\n");
        sql.append("        from ").append(this.T_TMP_YearSumTable).append(" yst\n");
        sql.append("        full join ").append(this.T_TMP_AmountTable).append(" ate  on yst.companyID = ate.companyID and yst.cashFlowItemID =  ate.cashFlowItemID");
        if (this.showAsst) {
            sql.append("  and  yst.hgID = ate.hgID\n");
        }
        sql.append("    ) t\n");
        sql.append("    full join ").append(this.T_TMP_InitDataTable).append(" idt on t.companyID = idt.companyID and t.cashFlowItemID =  idt.cashFlowItemID");
        if (this.showAsst) {
            sql.append("  and  t.hgID = idt.hgID\n");
        }
        return sql.toString();
    }

    private void buildTableHead() {
        ArrayList<String> cols = new ArrayList<String>();
        ArrayList<String> colNames = new ArrayList<String>();
        int index = 0;
        cols.add(this.COLUMN_CASH_FLOW_ITEM_NAME);
        colNames.add(this.getCFResource("cashFlowItem"));
        this.colIndexes.put(this.COLUMN_CASH_FLOW_ITEM_NAME, index++);
        cols.add(this.COLUMN_SEQ);
        colNames.add(this.getCFResource("seq"));
        this.colIndexes.put(this.COLUMN_SEQ, index++);
        cols.add(this.COLUMN_COMPANY_NAME);
        colNames.add(this.getCFResource(!this.sumByUnion ? "companyName" : "unionUnit"));
        this.colIndexes.put(this.COLUMN_COMPANY_NAME, index++);
        if (this.showAsst) {
            cols.add(this.COLUMN_TYPE);
            colNames.add(this.getCFResource("type"));
            this.colIndexes.put(this.COLUMN_TYPE, index++);
            cols.add(this.COLUMN_HG_LONG_NAME_GROUP);
            colNames.add(this.getCFResource("asstActGrp"));
            this.colIndexes.put(this.COLUMN_HG_LONG_NAME_GROUP, index++);
        }
        cols.add(this.COLUMN_AMOUNT);
        colNames.add(this.getCFResource("amount"));
        this.colIndexes.put(this.COLUMN_AMOUNT, index++);
        cols.add(this.COLUMN_YEAR_SUM);
        colNames.add(this.getCFResource("yearSum"));
        this.colIndexes.put(this.COLUMN_YEAR_SUM, index++);
        cols.add(this.COLUMN_ITEM_LEVEL);
        colNames.add(this.getCFResource("itemLevel"));
        this.colIndexes.put(this.COLUMN_ITEM_LEVEL, index++);
        cols.add(this.COLUMN_COMPANY_LEVEL);
        colNames.add(this.getCFResource("companyLevel"));
        this.colIndexes.put(this.COLUMN_COMPANY_LEVEL, index++);
        cols.add(this.COLUMN_IS_NET_ROW);
        colNames.add(this.getCFResource("isNetRow"));
        this.colIndexes.put(this.COLUMN_IS_NET_ROW, index++);
        cols.add(this.COLUMN_ITEM_ID);
        colNames.add(this.getCFResource("itemID"));
        this.colIndexes.put(this.COLUMN_ITEM_ID, index++);
        cols.add(this.COLUMN_COMPANY_ID);
        colNames.add(this.getCFResource("companyID"));
        this.colIndexes.put(this.COLUMN_COMPANY_ID, index++);
        if (this.showAsst) {
            cols.add(this.COLUMN_HG_ID);
            colNames.add("hgID");
            this.colIndexes.put(this.COLUMN_HG_ID, index++);
            cols.add(this.COLUMN_IS_ASST_ROW);
            colNames.add(this.getCFResource("isAsstRow"));
            this.colIndexes.put(this.COLUMN_IS_ASST_ROW, index++);
        }
        cols.add(this.COLUMN_IS_QUERY_ROW);
        colNames.add(this.getCFResource("isQueryRow"));
        this.colIndexes.put(this.COLUMN_IS_QUERY_ROW, index++);
        this.rows.add(cols);
        this.rows.add(colNames);
    }

    public List<String> getPeriodIdByNumberRange(Context ctx, String companyId, Integer startPeriod, Integer endPeriod) throws BOSException {
        String key = companyId + "_" + startPeriod + "_" + endPeriod;
        if (this.periodIdLists.containsKey(key)) {
            return this.periodIdLists.get(key);
        }
        if (!companyId.contains("'")) {
            companyId = "'" + companyId + "'";
        }
        StringBuilder periodSql = new StringBuilder();
        periodSql.append("select distinct p.fid fid");
        periodSql.append(" from t_bd_period p");
        periodSql.append(" inner join t_org_company c on c.faccountperiodid = p.FTypeid");
        periodSql.append(" where p.fnumber >= " + startPeriod + " and p.fnumber <= " + endPeriod + " and c.fid in (" + companyId + ")");
        IRowSet rowSet = null;
        if (this.periodTypeId != null) {
            periodSql.append(" and p.FTypeid = ?");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)periodSql.toString(), (Object[])new Object[]{this.periodTypeId});
        } else {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)periodSql.toString());
        }
        ArrayList<String> periodIdList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("fid");
                if (periodIdList.contains(id)) continue;
                periodIdList.add(id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.periodIdLists.put(key, periodIdList);
        return periodIdList;
    }

    private List<String> getPeriodRangeForCur(Context ctx, CompanyOrgUnitInfo company, int fromPeriodNumber, int toPeriodNumber) throws BOSException {
        return this.getPeriodIdByNumberRange(ctx, company.getId().toString(), fromPeriodNumber, toPeriodNumber);
    }

    private List<String> getPeriodRangeForSum(Context ctx, CompanyOrgUnitInfo company, int startPeriodNumber, int toPeriodNumber) throws BOSException, EASBizException {
        int toYear = toPeriodNumber / 100;
        if (startPeriodNumber / 100 == toYear) {
            return this.getPeriodIdByNumberRange(ctx, company.getId().toString(), startPeriodNumber, toPeriodNumber);
        }
        int periodNumber = PeriodUtils.getMinPeriodNumber((Context)ctx, (int)toYear, (String)company.getId().toString());
        return this.getPeriodIdByNumberRange(ctx, company.getId().toString(), toYear * 100 + periodNumber, toPeriodNumber);
    }

    protected void createDataTable() throws Exception {
        this.T_TMP_AmountTable = this.createDataTable(false, false);
        this.T_TMP_YearSumTable = this.createDataTable(true, false);
        this.T_TMP_InitDataTable = this.createDataTable(true, false);
        this.T_TMP_DataTable = this.createDataTable(true, true);
    }

    protected String createDataTable(boolean isYearSum, boolean isDataTbl) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("create table T_TMP_DataTable ( \n");
        sql.append(" companyID VARCHAR(44), \n");
        if (this.sumByUnion) {
            sql.append(" unionID VARCHAR(44), \n");
        }
        sql.append(" cashFlowItemID VARCHAR(44), \n");
        if (this.showAsst) {
            sql.append(" hgID VARCHAR(44) DEFAULT ' ', \n");
            sql.append(" FType int DEFAULT 1, \n");
        }
        if (!isDataTbl) {
            if (!isYearSum) {
                sql.append("  amount         NUMERIC(29,10)  DEFAULT 0   ");
            } else {
                sql.append("  yearSum         NUMERIC(29,10) DEFAULT 0  ");
            }
        } else {
            sql.append("  amount         NUMERIC(29,10)  DEFAULT 0 ,  \n");
            sql.append("  yearSum        NUMERIC(29,10)  DEFAULT 0 , \n");
            sql.append("  flag int default -1 ,");
            sql.append("  isReturn int default 1 ");
        }
        sql.append(" )");
        return this.createTempTable(sql.toString(), true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean beforeQuery() throws BOSException, EASBizException {
        int n;
        void var8_35;
        HashSet set;
        HashMap<String, CompanyOrgUnitInfo> orgMap;
        ArrayList<ObjectUuidPK> orgPKs;
        OrgStructureInfo topUnion;
        Object param;
        block68: {
            block71: {
                String orgTreeId;
                block70: {
                    block69: {
                        if (!super.beforeQuery()) {
                            return false;
                        }
                        if (this.currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || this.currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                            this.isForCurrency = false;
                        }
                        this.companyDisplayMode = CompanyDisplayModeEnum.level;
                        param = this.params.get("companyDisplayMode");
                        if (param != null && param.toString().trim().length() > 0) {
                            String str = param.toString().trim();
                            if (str.equals(String.valueOf(CompanyDisplayModeEnum.details.getValue())) || str.equals(CompanyDisplayModeEnum.details.getName()) || str.equals(CompanyDisplayModeEnum.details.getAlias())) {
                                this.companyDisplayMode = CompanyDisplayModeEnum.details;
                            } else if (str.equals(String.valueOf(CompanyDisplayModeEnum.enumerate.getValue())) || str.equals(CompanyDisplayModeEnum.enumerate.getName()) || str.equals(CompanyDisplayModeEnum.enumerate.getAlias())) {
                                this.companyDisplayMode = CompanyDisplayModeEnum.enumerate;
                            }
                        }
                        if ((param = this.params.get("companyLevel")) != null && param.toString().trim().length() > 0) {
                            try {
                                int i = Integer.parseInt(param.toString().trim());
                                if (i < 0) {
                                    this.appendErr("companyLevel", param.toString().trim(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"companyLevel_ERROR", (Locale)this.ctx.getLocale()));
                                    return false;
                                }
                                this.companyLevel = i;
                            }
                            catch (Exception e) {
                                this.appendErr("companyLevel", param.toString().trim(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"companyLevel_ERROR", (Locale)this.ctx.getLocale()));
                                return false;
                            }
                        }
                        if ((param = this.params.get("showAsst")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
                            this.showAsst = true;
                        }
                        if ((param = this.params.get("showExchangeItem")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
                            this.showExchangeItem = true;
                        }
                        if ((param = this.params.get("showInvisibleItem")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
                            this.showInvisibleItem = true;
                        }
                        if ((param = this.params.get("showCashInitEndBalance")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
                            this.showCashInitEndBalance = true;
                        }
                        if ((param = this.params.get("showSupplementItem")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
                            this.showSupplementItem = true;
                        }
                        if ((param = this.params.get("showAsstNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
                            this.showAsstNumber = true;
                        }
                        if ((param = this.params.get("showAsstLongName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
                            this.showAsstLongName = true;
                        }
                        if ((param = this.params.get("sumItemLevel")) != null && param.toString().trim().length() > 0) {
                            this.sumItemLevel = Integer.parseInt(param.toString());
                        }
                        if ((param = this.params.get("sumByUnion")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
                            this.sumByUnion = true;
                        }
                        topUnion = null;
                        orgTreeId = null;
                        param = this.params.get("orgTreeId");
                        if (param != null && param.toString().trim().length() > 0) {
                            orgTreeId = param.toString().trim();
                            String unionNumber = null;
                            param = this.params.get("unionNumber");
                            if (param != null && param.toString().trim().length() > 0) {
                                unionNumber = param.toString().trim();
                            }
                            if (this.sumByUnion) {
                                topUnion = this.getTopOrgStructure(orgTreeId, unionNumber);
                            }
                            CompanyOrgUnitCollection coll = this.getCompanys(orgTreeId, unionNumber);
                            if (this.sumByUnion && topUnion == null || coll.size() == 0) {
                                this.appendErr("orgTreeId", orgTreeId, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"notFoundOrgUnitByOrgTree", (Locale)this.ctx.getLocale()));
                                return false;
                            }
                            for (CompanyOrgUnitInfo companyOrgUnitInfo : coll) {
                                this.companys.add(companyOrgUnitInfo);
                            }
                        } else {
                            this.sumByUnion = false;
                            param = this.params.get("companyNumber");
                            if (param == null || param.toString().trim().length() == 0) {
                                this.appendErr("companyNumber", "", ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"needCompanyNumber_foundNull", (Locale)this.ctx.getLocale()));
                                return false;
                            }
                            String companyNumber = param.toString().trim();
                            HashSet<String> companyNumbers = new HashSet<String>();
                            if (companyNumber.indexOf(";") >= 0) {
                                String[] strs;
                                for (String str : strs = companyNumber.split(";")) {
                                    if (str.trim().length() <= 0) continue;
                                    companyNumbers.add(str.trim());
                                }
                            } else {
                                companyNumbers.add(companyNumber);
                            }
                            if (companyNumbers.size() == 0) {
                                this.appendErr("companyNumber", companyNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"needCompanyNumber_foundNull", (Locale)this.ctx.getLocale()));
                                return false;
                            }
                            HashMap<String, CompanyOrgUnitInfo> map = new HashMap<String, CompanyOrgUnitInfo>();
                            if (companyNumbers.size() == 1) {
                                CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompany((String)companyNumbers.iterator().next());
                                if (companyOrgUnitInfo != null) {
                                    companyOrgUnitInfo.put("inhere", (Object)true);
                                    map.put(companyOrgUnitInfo.getNumber(), companyOrgUnitInfo);
                                    this.companys.add(companyOrgUnitInfo);
                                }
                            } else {
                                CompanyOrgUnitCollection companyOrgUnitCollection = this.getCompanys(companyNumbers);
                                for (CompanyOrgUnitInfo company : companyOrgUnitCollection) {
                                    company.put("inhere", (Object)true);
                                    map.put(company.getNumber(), company);
                                    this.companys.add(company);
                                }
                            }
                            for (String string : companyNumbers) {
                                if (map.containsKey(string)) continue;
                                this.appendErr("companyNumber", string, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"companyNotFound", (Locale)this.ctx.getLocale()));
                                return false;
                            }
                        }
                        this.root = new GLNRptBaseService.CompanyNode(this);
                        for (CompanyOrgUnitInfo company : this.companys) {
                            if (!company.isIsBizUnit()) {
                                this.hasVirtual = true;
                            }
                            this.root.addChild(new GLNRptBaseService.CompanyNode(this, company));
                        }
                        if (this.root.childs.size() > 1) {
                            this.isMultiTree = true;
                        }
                        if (!this.hasVirtual) break block69;
                        if (this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.level) || this.companyDisplayMode.equals((Object)CompanyDisplayModeEnum.details)) {
                            if (this.isMultiTree) {
                                String str = "";
                                param = this.params.get("companyNumber");
                                if (param != null) {
                                    str = param.toString();
                                }
                                this.appendErr("companyNumber", str, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"queryMultiOrgTree_notSupport", (Locale)this.ctx.getLocale()));
                                return false;
                            }
                            break block70;
                        } else {
                            this.companys = new ArrayList<CompanyOrgUnitInfo>();
                            for (int i = 0; i < this.root.childs.size(); ++i) {
                                GLNRptBaseService.CompanyNode node = this.root.childs.get(i);
                                this.companys.addAll(node.getBizCompanys());
                            }
                            this.root = new GLNRptBaseService.CompanyNode(this);
                            for (CompanyOrgUnitInfo company : this.companys) {
                                this.root.addChild(new GLNRptBaseService.CompanyNode(this, company));
                            }
                            this.hasVirtual = false;
                            if (this.root.childs.size() > 1) {
                                this.isMultiTree = true;
                            }
                        }
                        break block70;
                    }
                    this.companyDisplayMode = CompanyDisplayModeEnum.enumerate;
                }
                orgPKs = new ArrayList<ObjectUuidPK>();
                orgMap = new HashMap<String, CompanyOrgUnitInfo>();
                if (this.sumByUnion || !this.hasVirtual) break block71;
                boolean hasPermission = PermissionFactory.getLocalInstance((Context)this.ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId()), (IObjectPK)new ObjectUuidPK(this.root.childs.get((int)0).company.getId()), "gl_cashflow_report");
                if (!hasPermission) {
                    if (orgTreeId != null) {
                        for (CompanyOrgUnitInfo companyOrgUnitInfo : this.companys) {
                            if (!companyOrgUnitInfo.isIsBizUnit()) continue;
                            orgPKs.add(new ObjectUuidPK(companyOrgUnitInfo.getId()));
                            orgMap.put(companyOrgUnitInfo.getId().toString(), companyOrgUnitInfo);
                        }
                        break block68;
                    } else {
                        for (CompanyOrgUnitInfo companyOrgUnitInfo : this.root.childs.get(0).getBizCompanys()) {
                            orgPKs.add(new ObjectUuidPK(companyOrgUnitInfo.getId()));
                            orgMap.put(companyOrgUnitInfo.getId().toString(), companyOrgUnitInfo);
                        }
                    }
                }
                break block68;
            }
            for (CompanyOrgUnitInfo companyOrgUnitInfo : this.companys) {
                orgPKs.add(new ObjectUuidPK(companyOrgUnitInfo.getId()));
                orgMap.put(companyOrgUnitInfo.getId().toString(), companyOrgUnitInfo);
            }
        }
        if ((set = PermissionFactory.getLocalInstance((Context)this.ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId()), orgPKs.toArray(new IObjectPK[orgPKs.size()]), "gl_cashflow_report")) == null) {
            set = new HashSet();
        }
        for (IObjectPK iObjectPK : orgPKs) {
            if (set.contains(iObjectPK.toString())) continue;
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orgMap.get(iObjectPK.toString());
            company.put("hasError", (Object)true);
            this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"have_no", (Locale)this.ctx.getLocale()) + " [" + company + "] " + ResourceBase.getString((String)CF_RESOURCE, (String)"gl_cashFlowTable_queryPermission", (Locale)this.ctx.getLocale()));
            if (!company.getBoolean("inhere")) continue;
            return false;
        }
        int n2 = 99;
        boolean bl = false;
        while (var8_35 < this.root.childs.size()) {
            CompanyOrgUnitInfo company = this.root.childs.get((int)var8_35).company;
            if (company.getLevel() < n) {
                this.companyTop = company;
                n = company.getLevel();
            }
            ++var8_35;
        }
        this.result.put("companyTopLevel", n);
        if (this.sumByUnion) {
            this.result.put("companyTopLevel", topUnion != null ? topUnion.getLevel() : 1);
        }
        this.result.put("sumByUnion", String.valueOf(this.sumByUnion));
        Object var8_36 = null;
        param = this.params.get("accountTableNumber");
        if (param == null || param.toString().trim().length() == 0 || "null".equals(param.toString().trim())) {
            String string = "current";
        } else {
            String accountTableNumber = param.toString().trim();
            if (!"merge".equals(accountTableNumber)) {
                AccountTableInfo at = this.getAccountTable(accountTableNumber);
                if (at == null) {
                    this.appendErr("accountTableNumber", accountTableNumber, ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"accountTable_notFound", (Locale)this.ctx.getLocale()));
                    return false;
                }
                String string = at.getId().toString();
            }
        }
        this.validateAllBizCompanys();
        for (int i = 0; i < this.allBizCompanys.size(); ++i) {
            void var8_39;
            CompanyOrgUnitInfo company = this.allBizCompanys.get(i);
            String atId = null;
            if (var8_39 != null) {
                if (var8_39.equals("current")) {
                    if (company.getAccountTable() == null) {
                        this.appendErr("companyNumber", company.getNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLNResource", (String)"companyAccountTable_missed", (Locale)this.ctx.getLocale()));
                        return false;
                    }
                    atId = company.getAccountTable().getId().toString();
                } else {
                    atId = var8_39;
                }
            }
            this.accountTableIds.put(company.getId().toString(), atId);
        }
        if (this.showAsst) {
            this.typeAlias = new HashMap<Integer, String>();
            this.typeAlias.put(1, "");
            this.typeAlias.put(2, CashflowTypeEnum.getEnum((int)2).toString());
            this.typeAlias.put(3, CashflowTypeEnum.getEnum((int)3).toString());
        }
        if (this.allBizCompanys.isEmpty()) {
            return true;
        }
        if (this.isForCurrency) {
            this.currencyScale = this.currency.getPrecision();
            return true;
        }
        this.maxScale = this.getMaxScale(this.allBizCompanys);
        return true;
    }

    private int getMaxScale(List<CompanyOrgUnitInfo> allBizCompanys) throws BOSException {
        String[] companyIds = new String[allBizCompanys.size()];
        for (int i = 0; i < companyIds.length; ++i) {
            companyIds[i] = allBizCompanys.get(i).getId().toString();
        }
        String companyIdsStr = this.stringArrayToString(companyIds);
        StringBuilder sql = new StringBuilder();
        sql.append("select max(fprecision) maxScale from t_org_company company inner join t_bd_currency currency  \n");
        if (this.currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
            sql.append("on company.FBaseCurrencyID = currency.fid \n");
        } else {
            sql.append("on company.FReportCurrencyID = currency.fid \n");
        }
        sql.append("where company.fid in ( ").append(companyIdsStr).append(" )");
        int maxScale = 4;
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                maxScale = rs.getInt("maxScale");
            }
        }
        catch (SQLException exception) {
            throw new BOSException((Throwable)exception);
        }
        return maxScale == 0 ? 4 : maxScale;
    }

    private String getItemViewSql(Context ctx, String ctrlUnitId) throws BOSException, EASBizException {
        INewOrgViewFacade iNOV = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx);
        OrgStructureCollection structCol = iNOV.buildViewSuperiorCollection(ctrlUnitId, "00000000-0000-0000-0000-0000000000014F2827FD");
        String[] cuids = new String[structCol.size() + 1];
        int n = structCol.size();
        for (int i = 0; i < n; ++i) {
            OrgStructureInfo structInfo = structCol.get(i);
            cuids[i] = structInfo.getUnit().getId().toString();
        }
        cuids[cuids.length - 1] = ctrlUnitId;
        StringBuilder schemaSql = new StringBuilder("select sc.fid,sc.FCtrlUnitID from t_bd_cashFlowItemViewSchema sc,T_ORG_CtrlUnit cu where cu.fid = sc.FCtrlUnitID and sc.FCtrlUnitID in (").append(this.stringArrayToString(cuids)).append(") order by cu.FLongNumber desc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)schemaSql.toString());
        try {
            if (rs.next()) {
                String schemaId = rs.getString("fid");
                String cuId = rs.getString("FCtrlUnitID");
                StringBuilder itemSql = new StringBuilder(" in (Select civ.FcashFlowItemID from t_bd_cashFlowItemView civ where civ.FCtrlUnitID = '").append(cuId).append("' and civ.FSchemaID = '").append(schemaId).append("')");
                return itemSql.toString();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private String stringArrayToString(String[] ids) {
        StringBuilder strIds = new StringBuilder();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    strIds.append(",");
                }
                strIds.append("'").append(ids[i]).append("'");
            }
        }
        return strIds.toString();
    }

    public String getPeriodIdsStr(List<String> idList) {
        if (this.periodListsStr.containsKey(idList)) {
            return this.periodListsStr.get(idList);
        }
        String[] ids = idList.toArray(new String[idList.size()]);
        String periodListStr = this.stringArrayToString(ids);
        this.periodListsStr.put(idList, periodListStr);
        return periodListStr;
    }

    @Override
    protected CompanyOrgUnitInfo getCompany(String companyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("name");
        selector.add("displayName");
        selector.add("isBizUnit");
        selector.add("level");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        selector.add("baseCurrency.id");
        selector.add("baseCurrency.number");
        selector.add("baseCurrency.name");
        selector.add("baseCurrency.precision");
        selector.add("reportCurrency.id");
        selector.add("reportCurrency.number");
        selector.add("reportCurrency.name");
        selector.add("reportCurrency.precision");
        selector.add("reportConvertMode");
        selector.add("CU.id");
        selector.add("accountPeriodType.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber));
        view.setFilter(filter);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
        if (companys != null && companys.size() > 0) {
            return companys.get(0);
        }
        return null;
    }

    @Override
    protected CompanyOrgUnitCollection getCompanys(Set<String> companyNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("name");
        selector.add("displayName");
        selector.add("isBizUnit");
        selector.add("level");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        selector.add("baseCurrency.id");
        selector.add("baseCurrency.number");
        selector.add("baseCurrency.name");
        selector.add("baseCurrency.precision");
        selector.add("reportCurrency.id");
        selector.add("reportCurrency.number");
        selector.add("reportCurrency.name");
        selector.add("reportCurrency.precision");
        selector.add("reportConvertMode");
        selector.add("CU.id");
        selector.add("accountPeriodType.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", companyNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("longNumber");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        view.setSorter(sorter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
        if (coll == null) {
            coll = new CompanyOrgUnitCollection();
        }
        return coll;
    }

    @Override
    protected CompanyOrgUnitCollection getChildCompanys(CompanyOrgUnitInfo parent) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select \n");
        sql.append("    c.FID, c.FNumber, c.FLongNumber, c.FName_" + loc + " FName, \n");
        sql.append("    c.FDisplayName_" + loc + " FDisplayName, c.FIsBizUnit, c.FLevel,c.FAccountPeriodID  FAccountPeriodID, c.FControlUnitID FControlUnitID,\n");
        sql.append("    bc.FID FBaseCurrencyID, bc.FNumber FBaseCurrencyNumber, bc.FName_" + loc + " FBaseCurrencyName, bc.FPrecision FBaseCurrencyPrecision, \n");
        sql.append("    rc.FID FReportCurrencyID, rc.FNumber FReportCurrencyNumber, rc.FName_" + loc + " FReportCurrencyName, rc.FPrecision FReportCurrencyPrecision, c.FReportConvertMode, \n");
        sql.append("    at.FID FAccountTableID, at.FNumber FAccountTableNumber \n");
        sql.append("from T_ORG_Company c \n");
        sql.append("left join T_BD_Currency bc on bc.FID = c.FBaseCurrencyID \n");
        sql.append("left join T_BD_Currency rc on rc.FID = c.FReportCurrencyID \n");
        sql.append("join T_BD_SystemStatusCtrol sc on sc.FCompanyID = c.FID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_AccountTable at on at.FID = c.FAccountTableID \n");
        sql.append("where sc.FStartPeriodID is not null and sc.FCurrentPeriodID is not null \n");
        sql.append("    and sc.FIsStart = 1 and s.FName = 6 \n");
        sql.append("    and c.FIsAssistantOrg = 0 \n");
        sql.append("    and c.FLongNumber like '" + parent.getLongNumber() + "!%' \n");
        sql.append("\n");
        sql.append("");
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                String reportCurrencyId;
                String baseCurrencyId;
                String accountTableId;
                String accountPeriodID;
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)rowSet.getString("FID")));
                company.setNumber(rowSet.getString("FNumber"));
                company.setLongNumber(rowSet.getString("FLongNumber"));
                company.setName(rowSet.getString("FName"));
                company.setDisplayName(rowSet.getString("FDisplayName"));
                company.setIsBizUnit(rowSet.getInt("FIsBizUnit") == 1);
                company.setLevel(rowSet.getInt("FLevel"));
                company.setIsAssistantOrg(false);
                String controlUnitID = rowSet.getString("FControlUnitID");
                if (controlUnitID != null && controlUnitID.length() > 0) {
                    CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                    ctrlUnitInfo.setId(BOSUuid.read((String)controlUnitID));
                    company.setCU(ctrlUnitInfo);
                }
                if ((accountPeriodID = rowSet.getString("FAccountPeriodID")) != null && accountPeriodID.length() > 0) {
                    PeriodTypeInfo periodTypeInfo = new PeriodTypeInfo();
                    periodTypeInfo.setId(BOSUuid.read((String)accountPeriodID));
                    company.setAccountPeriodType(periodTypeInfo);
                }
                if ((accountTableId = rowSet.getString("FAccountTableID")) != null && accountTableId.length() > 0) {
                    AccountTableInfo table = new AccountTableInfo();
                    table.setId(BOSUuid.read((String)accountTableId));
                    table.setNumber(rowSet.getString("FAccountTableNumber"));
                    company.setAccountTable(table);
                }
                if ((baseCurrencyId = rowSet.getString("FBaseCurrencyID")) != null && baseCurrencyId.length() > 0) {
                    CurrencyInfo cy = new CurrencyInfo();
                    cy.setId(BOSUuid.read((String)baseCurrencyId));
                    cy.setNumber(rowSet.getString("FBaseCurrencyNumber"));
                    cy.setName(rowSet.getString("FBaseCurrencyName"));
                    cy.setPrecision(rowSet.getInt("FBaseCurrencyPrecision"));
                    company.setBaseCurrency(cy);
                }
                if ((reportCurrencyId = rowSet.getString("FReportCurrencyID")) != null && reportCurrencyId.length() > 0) {
                    CurrencyInfo cy = new CurrencyInfo();
                    cy.setId(BOSUuid.read((String)reportCurrencyId));
                    cy.setNumber(rowSet.getString("FReportCurrencyNumber"));
                    cy.setName(rowSet.getString("FReportCurrencyName"));
                    cy.setPrecision(rowSet.getInt("FReportCurrencyPrecision"));
                    company.setReportCurrency(cy);
                    company.setReportConvertMode(ReportCurrencyConvertMode.getEnum((int)rowSet.getInt("FReportConvertMode")));
                }
                coll.add(company);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    @Override
    protected CompanyOrgUnitCollection getCompanys(String orgTreeId, String unionNumber) throws BOSException, EASBizException {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("CU.id");
        selector.add("CU.number");
        OrgTreeInfo orgTree = OrgTreeFactory.getLocalInstance((Context)this.ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeId), selector);
        if (orgTree.getCU() == null) {
            return coll;
        }
        CompanyOrgUnitInfo cu = this.getCompany(orgTree.getCU().getNumber());
        if (cu == null) {
            return coll;
        }
        coll.add(cu);
        HashSet<String> unionNumbers = new HashSet<String>();
        if (unionNumber != null && unionNumber.length() > 0) {
            if (unionNumber.indexOf(";") >= 0) {
                String[] strs;
                for (String str : strs = unionNumber.split(";")) {
                    if (str.trim().length() <= 0) continue;
                    unionNumbers.add(str.trim());
                }
            } else {
                unionNumbers.add(unionNumber);
            }
        }
        Set<String> unionLongNumbers = this.getUnionLongNumbers(this.ctx, orgTreeId, unionNumbers);
        StringBuffer sql = new StringBuffer();
        ArrayList<String> ps = new ArrayList<String>();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select DISTINCT st.FID FUnionID, st.FLevel FUnionLevel, \n");
        sql.append("    c.FID, c.FNumber, c.FLongNumber, c.FName_" + loc + " FName, c.FIsAssistantOrg, \n");
        sql.append("    c.FDisplayName_" + loc + " FDisplayName, c.FIsBizUnit, c.FLevel,c.FAccountPeriodID  FAccountPeriodID,c.FControlUnitID FControlUnitID, \n");
        sql.append("    bc.FID FBaseCurrencyID, bc.FNumber FBaseCurrencyNumber, bc.FName_" + loc + " FBaseCurrencyName, bc.FPrecision FBaseCurrencyPrecision, \n");
        sql.append("    rc.FID FReportCurrencyID, rc.FNumber FReportCurrencyNumber, rc.FName_" + loc + " FReportCurrencyName, rc.FPrecision FReportCurrencyPrecision, c.FReportConvertMode, \n");
        sql.append("    at.FID FAccountTableID, at.FNumber FAccountTableNumber \n");
        sql.append("from T_ORG_Structure st \n");
        sql.append("join T_ORG_Company c on c.FID = st.FUNITID \n");
        sql.append("left join T_BD_Currency bc on bc.FID = c.FBaseCurrencyID \n");
        sql.append("left join T_BD_Currency rc on rc.FID = c.FReportCurrencyID \n");
        sql.append("join T_BD_AccountTable at on at.FID = c.FAccountTableID \n");
        sql.append("where st.FTreeID = ? \n");
        ps.add(orgTreeId);
        sql.append("    and FIsBizUnit = 1 \n");
        if (unionLongNumbers.size() > 0) {
            sql.append("    and ( \n");
            boolean firstNumber = true;
            for (String unionLongNumber : unionLongNumbers) {
                if (!firstNumber) {
                    sql.append("or ");
                }
                firstNumber = false;
                sql.append("        st.FLongNumber like ? \n");
                ps.add(unionLongNumber + "!%");
            }
            sql.append("    ) \n");
        }
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])ps.toArray());
            while (rowSet.next()) {
                String reportCurrencyId;
                String baseCurrencyId;
                String accountTableId;
                String accountPeriodID;
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                String id = rowSet.getString("FID");
                if (id.equals(cu.getId().toString())) continue;
                company.setId(BOSUuid.read((String)id));
                company.setNumber(rowSet.getString("FNumber"));
                company.setLongNumber(rowSet.getString("FLongNumber"));
                company.setName(rowSet.getString("FName"));
                company.setDisplayName(rowSet.getString("FDisplayName"));
                company.setIsBizUnit(rowSet.getInt("FIsBizUnit") == 1);
                company.setLevel(rowSet.getInt("FLevel"));
                company.setIsAssistantOrg(rowSet.getInt("FIsAssistantOrg") == 1);
                String controlUnitID = rowSet.getString("FControlUnitID");
                if (controlUnitID != null && controlUnitID.length() > 0) {
                    CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                    ctrlUnitInfo.setId(BOSUuid.read((String)controlUnitID));
                    company.setCU(ctrlUnitInfo);
                }
                if ((accountPeriodID = rowSet.getString("FAccountPeriodID")) != null && accountPeriodID.length() > 0) {
                    PeriodTypeInfo periodTypeInfo = new PeriodTypeInfo();
                    periodTypeInfo.setId(BOSUuid.read((String)accountPeriodID));
                    company.setAccountPeriodType(periodTypeInfo);
                }
                if ((accountTableId = rowSet.getString("FAccountTableID")) != null && accountTableId.length() > 0) {
                    AccountTableInfo table = new AccountTableInfo();
                    table.setId(BOSUuid.read((String)accountTableId));
                    table.setNumber(rowSet.getString("FAccountTableNumber"));
                    company.setAccountTable(table);
                }
                if ((baseCurrencyId = rowSet.getString("FBaseCurrencyID")) != null && baseCurrencyId.length() > 0) {
                    CurrencyInfo cy = new CurrencyInfo();
                    cy.setId(BOSUuid.read((String)baseCurrencyId));
                    cy.setNumber(rowSet.getString("FBaseCurrencyNumber"));
                    cy.setName(rowSet.getString("FBaseCurrencyName"));
                    cy.setPrecision(rowSet.getInt("FBaseCurrencyPrecision"));
                    company.setBaseCurrency(cy);
                }
                if ((reportCurrencyId = rowSet.getString("FReportCurrencyID")) != null && reportCurrencyId.length() > 0) {
                    CurrencyInfo cy = new CurrencyInfo();
                    cy.setId(BOSUuid.read((String)reportCurrencyId));
                    cy.setNumber(rowSet.getString("FReportCurrencyNumber"));
                    cy.setName(rowSet.getString("FReportCurrencyName"));
                    cy.setPrecision(rowSet.getInt("FReportCurrencyPrecision"));
                    company.setReportCurrency(cy);
                    company.setReportConvertMode(ReportCurrencyConvertMode.getEnum((int)rowSet.getInt("FReportConvertMode")));
                }
                company.put("unionId", (Object)rowSet.getString("FUnionID"));
                company.put("unionLevel", (Object)rowSet.getInt("FUnionLevel"));
                coll.add(company);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (coll.size() == 1) {
            coll.clear();
            return coll;
        }
        return coll;
    }

    public String getDiff(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)CashflowRecordInfo.getAccountSelector());
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("diffAccount.number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("CU.id", (Object)company.getCU().getId().toString()));
        if (this.accountTableIds.get(company.getId().toString()) != null) {
            fic.add(new FilterItemInfo("accountTable.id", (Object)this.accountTableIds.get(company.getId().toString())));
        }
        ICashFlowAccountDiff activity = CashFlowAccountDiffFactory.getLocalInstance((Context)ctx);
        CashFlowAccountDiffCollection col = activity.getCashFlowAccountDiffCollection(view);
        StringBuffer sb = new StringBuffer();
        CashFlowAccountDiffInfo diffInfo = null;
        AccountViewInfo account = null;
        for (int i = 0; i < col.size(); ++i) {
            diffInfo = col.get(i);
            account = diffInfo.getDiffAccount();
            sb.append("'").append(account.getId().toString()).append("'").append(",");
        }
        if (col.size() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return null;
    }

    @Override
    protected String getPageClass() {
        return CashflowTableService.class.getName();
    }

    static enum Flag {
        ASST(1),
        ITEM(2),
        ALL_CASH_BEGIN(3),
        CASH_END(4),
        CASH_BEGIN(5),
        EQU_END(6),
        EQU_BEGIN(7),
        NET_AMOUNT(8),
        NET_TOTAL_AMOUNT(9),
        NET_DEAL_ACTIVITY(10),
        ALL_CASH_END(11),
        OTHER_ROW(12),
        NET_TOTAL_AMOUNT_LAST(13);

        private int value;

        private Flag(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private final class SubTask
    implements Runnable {
        Context ctx;
        CompanyOrgUnitInfo company;
        List<String> periodIdListForCur;
        List<String> periodIdListForSum;
        CashFlowItemType cashFlowItemType;
        boolean needInitData;
        CountDownLatch latch;

        public SubTask(Context ctx, CompanyOrgUnitInfo company, List<String> periodIdListForCur, List<String> periodIdListForSum, CashFlowItemType cashFlowItemType, boolean needInitData, CountDownLatch latch) {
            this.ctx = ctx;
            this.company = company;
            this.periodIdListForCur = periodIdListForCur;
            this.periodIdListForSum = periodIdListForSum;
            this.cashFlowItemType = cashFlowItemType;
            this.needInitData = needInitData;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.insertAmountData(this.ctx, this.periodIdListForCur, this.cashFlowItemType);
                this.insertYearSumData(this.ctx, this.periodIdListForSum, this.cashFlowItemType);
                if (this.needInitData) {
                    this.insertInitData();
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                CashflowTableService.this.appendErr("", "", e.getMessage());
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }

        private void insertAmountData(Context ctx, List<String> periodIdList, CashFlowItemType cashFlowItemType) throws BOSException {
            ArrayList<Object> params = new ArrayList<Object>();
            String SQL2 = this.getSumRecordsSQL(periodIdList, cashFlowItemType, params);
            StringBuilder sql = new StringBuilder();
            sql.append("insert into " + CashflowTableService.this.T_TMP_AmountTable + " ( \n");
            sql.append("    companyID, \n");
            if (CashflowTableService.this.sumByUnion) {
                sql.append("    unionID, \n");
            }
            sql.append("    cashFlowItemID, \n");
            if (CashflowTableService.this.showAsst) {
                sql.append("    hgID, \n");
                sql.append("    FType, \n");
            }
            sql.append("    amount \n");
            sql.append("    ) \n");
            sql.append(SQL2);
            CashflowTableService.this.execute(ctx, sql.toString(), params.toArray());
        }

        private void insertYearSumData(Context ctx, List<String> periodIdList, CashFlowItemType cashFlowItemType) throws BOSException {
            ArrayList<Object> params = new ArrayList<Object>();
            String SQL2 = this.getSumRecordsSQL(periodIdList, cashFlowItemType, params);
            StringBuilder sql = new StringBuilder();
            sql.append("insert into " + CashflowTableService.this.T_TMP_YearSumTable + " ( \n");
            sql.append("    companyID, \n");
            if (CashflowTableService.this.sumByUnion) {
                sql.append("    unionID, \n");
            }
            sql.append("    cashFlowItemID, \n");
            if (CashflowTableService.this.showAsst) {
                sql.append("    hgID, \n");
                sql.append("    FType, \n");
            }
            sql.append("    yearSum \n");
            sql.append("    ) \n");
            sql.append(SQL2);
            CashflowTableService.this.execute(ctx, sql.toString(), params.toArray());
        }

        private String getSumRecordsSQL(List<String> periodIdList, CashFlowItemType cashFlowItemType, List<Object> params) {
            String companyID = this.company.getId().toString();
            String itemIDStr = "";
            String coeffientStr = "";
            boolean isForCurrency = false;
            String accountTableId = CashflowTableService.this.accountTableIds.get(this.company.getId().toString());
            if (cashFlowItemType == CashFlowItemType.MASTER_TABLE_ITEM) {
                itemIDStr = "cfr.FPrimaryItemID";
                coeffientStr = "cfr.FPrimaryCoeffient";
            } else {
                itemIDStr = "cfr.FSupplementaryItemID";
                coeffientStr = "cfr.FSupplementaryCoeffient";
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select   \n");
            sql.append("    ? companyID,   \n\t");
            params.add(companyID);
            if (CashflowTableService.this.sumByUnion) {
                sql.append("    ?, \n");
                params.add(this.company.getString("unionId"));
            }
            sql.append(itemIDStr).append(" cashFlowItemID,    \n");
            if (CashflowTableService.this.showAsst && cashFlowItemType == CashFlowItemType.MASTER_TABLE_ITEM) {
                sql.append("    isnull(cfr.fassgrpid,' ') as hgID,   \n");
                sql.append("    cfr.FType as FType,     \n");
            } else if (CashflowTableService.this.showAsst) {
                sql.append("    ' ' as hgID,   \n");
                sql.append("    1 as FType,     \n");
            }
            if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                sql.append("    sum(cfr.FLocalAmount * ").append(coeffientStr).append(" ) amount     \n");
            } else if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                sql.append("    sum(cfr.FReportingAmount * ").append(coeffientStr).append(" ) amount     \n");
            } else {
                sql.append("    sum(cfr.FOriginalAmount * ").append(coeffientStr).append(" ) amount     \n");
                isForCurrency = true;
            }
            sql.append("from  T_GL_CashflowRecord cfr  \n");
            sql.append("inner join T_GL_Voucher voucher on cfr.FVoucherID = voucher.FID \n");
            if (accountTableId != null) {
                sql.append("inner join T_BD_Accountview av on cfr.Faccountid = av.fid \n");
            }
            sql.append("where \n");
            sql.append("  voucher.FCompanyID = ?\n");
            params.add(companyID);
            if (isForCurrency) {
                sql.append("   and cfr.FCurrencyID = ?\n");
                params.add(CashflowTableService.this.currencyId);
            }
            if (CashflowTableService.this.balType == 5) {
                sql.append("   and voucher.FBizStatus = 5 \n");
            } else {
                sql.append("   and voucher.FBizStatus in (1, 3, 5) \n");
            }
            if (accountTableId != null) {
                sql.append("   and av.faccounttableid = ?\n");
                params.add(accountTableId);
            }
            if (CashflowTableService.this.itemViewSql != null) {
                sql.append("   and ").append(itemIDStr).append(CashflowTableService.this.itemViewSql).append("\n");
            }
            sql.append("   and voucher.FPeriodID in (").append(CashflowTableService.this.getPeriodIdsStr(periodIdList)).append(")\n");
            sql.append("group by ").append(itemIDStr);
            if (CashflowTableService.this.showAsst && cashFlowItemType == CashFlowItemType.MASTER_TABLE_ITEM) {
                sql.append(", cfr.fassgrpid, cfr.FType \n");
            }
            return sql.toString();
        }

        private void insertInitData() throws BOSException {
            boolean isForCurrency = false;
            ArrayList<String> params = new ArrayList<String>();
            StringBuilder sql = new StringBuilder();
            sql.append("insert into " + CashflowTableService.this.T_TMP_InitDataTable + " ( \n");
            sql.append("    companyID, \n");
            if (CashflowTableService.this.sumByUnion) {
                sql.append("    unionID, \n");
            }
            sql.append("    cashFlowItemID, \n");
            if (CashflowTableService.this.showAsst) {
                sql.append("    hgID, \n");
                sql.append("    FType, \n");
            }
            sql.append("    yearSum \n");
            sql.append("    ) \n");
            sql.append("select \n");
            sql.append("init.FCompanyID companyID,\n");
            if (CashflowTableService.this.sumByUnion) {
                sql.append("    ?, \n");
                params.add(this.company.getString("unionId"));
            }
            sql.append("init.FcashFlowItemID as cashFlowItemID,\n");
            if (CashflowTableService.this.showAsst) {
                sql.append("isnull(asst.FAssistGrpID,' ') as hgID, \n");
                sql.append("asst.FType as FType, \n");
                if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("asst.FLocalAmount as amount \n");
                } else if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("asst.FReportingAmount as amount \n");
                } else {
                    isForCurrency = true;
                    sql.append("asst.FOriginalAmount as amount \n");
                }
                sql.append("from T_GL_CashflowInit as init \n");
                sql.append("left  join T_GL_CashflowGrpAsst as asst on init.FID = asst.FCflowInitID \n");
            } else {
                if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append("init.FLocalAmount as amount \n");
                } else if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append("init.FReportingAmount as amount \n");
                } else {
                    isForCurrency = true;
                    sql.append("init.FOriginalAmount as amount \n");
                }
                sql.append("from T_GL_CashflowInit as init \n");
            }
            sql.append("where init.FCompanyID = ?  \n");
            params.add(this.company.getId().toString());
            if (isForCurrency) {
                sql.append("and init.FCurrencyID = ? \n");
                params.add(CashflowTableService.this.currencyId);
            }
            if (CashflowTableService.this.itemViewSql != null) {
                sql.append("and init.FcashFlowItemID ").append(CashflowTableService.this.itemViewSql).append("\n");
            }
            if (CashflowTableService.this.showAsst) {
                if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                    sql.append(" and asst.FLocalAmount <> 0 \n");
                } else if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                    sql.append(" and asst.FReportingAmount <> 0 \n");
                } else {
                    sql.append(" and asst.FOriginalAmount<>0 ");
                }
            } else if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                sql.append(" and init.FLocalAmount <> 0 \n");
            } else if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                sql.append(" and init.FReportingAmount <> 0 \n");
            } else {
                sql.append(" and init.FOriginalAmount<>0 ");
            }
            CashflowTableService.this.execute(this.ctx, sql.toString(), params.toArray());
        }
    }

    class CashBalanceTask
    implements Runnable {
        CompanyOrgUnitInfo company;
        CountDownLatch latch;

        CashBalanceTask(CompanyOrgUnitInfo company, CountDownLatch latch) {
            this.company = company;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Iterator iterator;
                BigDecimal cashBeginBalance = this.getCashBeginBalance(this.company, false, true);
                BigDecimal cashBeginSumBalance = this.getCashBeginBalance(this.company, true, true);
                BigDecimal equBeginBalance = this.getCashBeginBalance(this.company, false, false);
                BigDecimal equBeginSumBalance = this.getCashBeginBalance(this.company, true, false);
                BigDecimal cashEndBalance = this.getCashEndBalance(this.company, true);
                BigDecimal cashEndSumBalance = this.getCashEndBalance(this.company, true);
                BigDecimal equEndBalance = this.getCashEndBalance(this.company, false);
                BigDecimal equEndSumBalance = this.getCashEndBalance(this.company, false);
                String sql = this.getInsertBizOrgCashBalanceSQL();
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                this.prepareInsertBizOrgCashBalance(this.company, cashBeginBalance.add(equBeginBalance), cashBeginSumBalance.add(equBeginSumBalance), Flag.ALL_CASH_BEGIN, paramsList);
                this.prepareInsertBizOrgCashBalance(this.company, cashEndBalance, cashEndSumBalance, Flag.CASH_END, paramsList);
                this.prepareInsertBizOrgCashBalance(this.company, cashBeginBalance, cashBeginSumBalance, Flag.CASH_BEGIN, paramsList);
                this.prepareInsertBizOrgCashBalance(this.company, equBeginBalance, equBeginSumBalance, Flag.EQU_BEGIN, paramsList);
                this.prepareInsertBizOrgCashBalance(this.company, equEndBalance, equEndSumBalance, Flag.EQU_END, paramsList);
                long startTime = System.currentTimeMillis();
                DbUtil.executeBatch((Context)CashflowTableService.this.ctx, (String)sql, paramsList);
                if (CashflowTableService.this.debug && (iterator = paramsList.iterator()).hasNext()) {
                    Object[] objects = (Object[])iterator.next();
                    CashflowTableService.this.logSql(sql, objects, System.currentTimeMillis() - startTime);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                CashflowTableService.this.appendErr("", "", e.getMessage());
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }

        private BigDecimal getCashBeginBalance(CompanyOrgUnitInfo company, boolean isSum, boolean isCash) throws BOSException, SQLException {
            String companyID = company.getId().toString();
            StringBuilder sql = new StringBuilder();
            int beginPeriodNumber = CashflowTableService.this.fromPeriodNumber;
            if (isSum) {
                beginPeriodNumber = CashflowTableService.this.fromPeriodNumber / 100 == CashflowTableService.this.toPeriodNumber / 100 ? CashflowTableService.this.fromPeriodNumber / 100 * 100 + 1 : CashflowTableService.this.toPeriodNumber / 100 * 100 + 1;
            }
            if (!this.checkPeriod(company, beginPeriodNumber)) {
                return BigDecimal.ZERO;
            }
            boolean isForCurrency = false;
            ArrayList<String> params = new ArrayList<String>();
            sql.append("select \n");
            if (CashflowTableService.this.currency.getId().toString().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                sql.append(" sum(FBeginBalanceLocal) amount \n");
            } else if (CashflowTableService.this.currency.getId().toString().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                sql.append(" sum(FBeginBalanceRpt) amount \n");
            } else {
                isForCurrency = true;
                sql.append(" sum(FBeginBalanceFor) amount \n");
            }
            sql.append(" from " + GLBalanceUtils.getAccountBalanceTable(CashflowTableService.this.balType, CashflowTableService.this.currencyId) + " balance join T_BD_AccountView account \n");
            sql.append(" on balance.FAccountID = account.FID \n");
            sql.append(" where account.FIsLeaf = 1 \n");
            sql.append(" and balance.FOrgUnitId = ? \n");
            params.add(companyID);
            if (CashflowTableService.this.accountTableIds.get(companyID) != null) {
                sql.append(" and account.FAccountTableID = ? \n");
                params.add(CashflowTableService.this.accountTableIds.get(companyID));
            }
            sql.append(" and balance.FPeriod = " + beginPeriodNumber);
            if (isForCurrency) {
                sql.append(" and balance.FCurrencyID = ? \n");
                params.add(CashflowTableService.this.currencyId);
            }
            if (isCash) {
                sql.append(" and (account.FIsCash = 1 or account.FIsBank = 1 ) \n");
            } else {
                sql.append(" and account.FIsCashEquivalent = 1 \n");
            }
            IRowSet rs = CashflowTableService.this.executeQuery(CashflowTableService.this.ctx, sql.toString(), params.toArray());
            if (rs.next()) {
                BigDecimal amount = rs.getBigDecimal("amount");
                return amount == null ? BigDecimal.ZERO : amount;
            }
            return BigDecimal.ZERO;
        }

        private boolean checkPeriod(CompanyOrgUnitInfo company, int periodNumber) throws BOSException, SQLException {
            StringBuilder sql = new StringBuilder();
            sql.append("select distinct p.fid fid");
            sql.append(" from t_bd_period p");
            sql.append(" inner join t_org_company c on c.faccountperiodid = p.FTypeid");
            sql.append(" where p.fnumber = ? and c.fid = ? ");
            IRowSet rowSet = null;
            String companyID = company.getId().toString();
            if (CashflowTableService.this.periodTypeId != null) {
                sql.append(" and p.FTypeid = ?");
                rowSet = DbUtil.executeQuery((Context)CashflowTableService.this.ctx, (String)sql.toString(), (Object[])new Object[]{periodNumber, companyID, CashflowTableService.this.periodTypeId});
            } else {
                rowSet = DbUtil.executeQuery((Context)CashflowTableService.this.ctx, (String)sql.toString(), (Object[])new Object[]{periodNumber, companyID});
            }
            return rowSet.next();
        }

        private BigDecimal getCashEndBalance(CompanyOrgUnitInfo company, boolean isCash) throws BOSException, SQLException {
            String companyID = company.getId().toString();
            StringBuilder sql = new StringBuilder();
            int endPeriodNumber = CashflowTableService.this.toPeriodNumber;
            if (!this.checkPeriod(company, endPeriodNumber)) {
                return BigDecimal.ZERO;
            }
            boolean isForCurrency = false;
            ArrayList<String> params = new ArrayList<String>();
            sql.append("select \n");
            if (CashflowTableService.this.currency.getId().toString().equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                sql.append(" sum(FDebitLocal-FCreditLocal+FBeginBalanceLocal) amount \n");
            } else if (CashflowTableService.this.currency.getId().toString().equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                sql.append(" sum(FDebitRpt-FCreditRpt+FBeginBalanceRpt) amount \n");
            } else {
                isForCurrency = true;
                sql.append(" sum(FDebitFor-FCreditFor+FBeginBalanceFor) amount \n");
            }
            sql.append(" from " + GLBalanceUtils.getAccountBalanceTable(CashflowTableService.this.balType, CashflowTableService.this.currencyId) + " balance join T_BD_AccountView account \n");
            sql.append(" on balance.FAccountID = account.FID \n");
            sql.append(" where account.FIsLeaf = 1 \n");
            sql.append(" and balance.FOrgUnitId = ? \n");
            params.add(companyID);
            if (CashflowTableService.this.accountTableIds.get(companyID) != null) {
                sql.append(" and account.FAccountTableID = ? \n");
                params.add(CashflowTableService.this.accountTableIds.get(companyID));
            }
            sql.append(" and balance.FPeriod = " + endPeriodNumber);
            if (isForCurrency) {
                sql.append(" and balance.FCurrencyID = ? \n");
                params.add(CashflowTableService.this.currencyId);
            }
            if (isCash) {
                sql.append(" and (account.FIsCash = 1 or account.FIsBank = 1 ) \n");
            } else {
                sql.append(" and account.FIsCashEquivalent = 1 \n");
            }
            IRowSet rs = CashflowTableService.this.executeQuery(CashflowTableService.this.ctx, sql.toString(), params.toArray());
            if (rs.next()) {
                BigDecimal amount = rs.getBigDecimal("amount");
                return amount == null ? BigDecimal.ZERO : amount;
            }
            return BigDecimal.ZERO;
        }

        private String getInsertBizOrgCashBalanceSQL() {
            StringBuilder sql = new StringBuilder();
            sql.append("insert into " + CashflowTableService.this.T_TMP_DataTable + " ( \n");
            sql.append("    companyID, \n");
            if (CashflowTableService.this.sumByUnion) {
                sql.append("    unionID, \n");
            }
            sql.append("    amount, \n");
            sql.append("    yearSum, \n");
            sql.append("    flag \n");
            sql.append("    ) \n");
            sql.append("values (\n");
            sql.append("    ?, \n");
            if (CashflowTableService.this.sumByUnion) {
                sql.append("    ?, \n");
            }
            sql.append("    ?, \n");
            sql.append("    ?, \n");
            sql.append("    ? \n");
            sql.append("     ) \n");
            return sql.toString();
        }

        private void prepareInsertBizOrgCashBalance(CompanyOrgUnitInfo company, BigDecimal amount, BigDecimal sumAmount, Flag flag, List<Object[]> paramsList) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(company.getId().toString());
            if (CashflowTableService.this.sumByUnion) {
                params.add(company.getString("unionId"));
            }
            params.add(amount);
            params.add(sumAmount);
            params.add(flag.getValue());
            paramsList.add(params.toArray());
        }
    }

    class RetainProfitTask
    implements Runnable {
        CompanyOrgUnitInfo company;
        CountDownLatch latch;

        RetainProfitTask(CompanyOrgUnitInfo company, CountDownLatch latch) {
            this.company = company;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String diffAccountSet = CashflowTableService.this.getDiff(CashflowTableService.this.ctx, this.company);
                BigDecimal retainedProfit = this.getRetainedProfits(diffAccountSet, false);
                BigDecimal retainedSumProfit = this.getRetainedProfits(diffAccountSet, true);
                StringBuilder sql = new StringBuilder();
                sql.append("insert into  ").append(CashflowTableService.this.T_TMP_DataTable).append(" ( \n");
                sql.append("   companyID,\n");
                if (CashflowTableService.this.sumByUnion) {
                    sql.append("   unionID,\n");
                }
                sql.append("   cashFlowItemID,\n");
                sql.append("   amount,\n");
                sql.append("   yearSum,");
                sql.append("   flag");
                sql.append(" ) \n");
                sql.append("    select \n");
                sql.append("        ?,  \n");
                if (CashflowTableService.this.sumByUnion) {
                    sql.append("        ?,  \n");
                }
                sql.append("        item.fid,  \n");
                sql.append("        ?,  \n");
                sql.append("        ?,  \n");
                sql.append("       " + Flag.ITEM.getValue() + "  \n");
                sql.append("    from t_bd_cashFlowItem item \n");
                sql.append("    where item.FisProfit = 1 \n");
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(this.company.getId().toString());
                if (CashflowTableService.this.sumByUnion) {
                    params.add(this.company.getString("unionId"));
                }
                params.add(retainedProfit);
                params.add(retainedSumProfit);
                CashflowTableService.this.execute(CashflowTableService.this.ctx, sql.toString(), params.toArray());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
                CashflowTableService.this.appendErr("", "", e.getMessage());
            }
            finally {
                if (this.latch != null) {
                    this.latch.countDown();
                }
            }
        }

        private BigDecimal getRetainedProfits(String diffAccountSet, boolean isSum) throws BOSException, SQLException, EASBizException {
            IRowSet rs;
            List<String> periodIdList;
            StringBuilder sql = new StringBuilder();
            String companyID = this.company.getId().toString();
            boolean isForCurrency = false;
            ArrayList<Object> params = new ArrayList<Object>();
            int beginPeriodNumber = CashflowTableService.this.fromPeriodNumber;
            if (isSum) {
                beginPeriodNumber = CashflowTableService.this.fromPeriodNumber / 100 == CashflowTableService.this.toPeriodNumber / 100 ? CashflowTableService.this.fromPeriodNumber / 100 * 100 + 1 : CashflowTableService.this.toPeriodNumber / 100 * 100 + 1;
            }
            if ((periodIdList = CashflowTableService.this.getPeriodIdByNumberRange(CashflowTableService.this.ctx, companyID, beginPeriodNumber, CashflowTableService.this.toPeriodNumber)).isEmpty()) {
                CashflowTableService.this.appendErr("periodTypeNumber", this.company.getNumber(), ResourceBase.getString((String)CashflowTableService.CF_RESOURCE, (String)"periodTypeNotFoundPeriod", (Locale)CashflowTableService.this.ctx.getLocale()));
                return BigDecimal.ZERO;
            }
            String periodIdsStr = CashflowTableService.this.getPeriodIdsStr(periodIdList);
            sql.append("select \n");
            if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString())) {
                sql.append(" sum(case ve.FEntryDC when 0 then ve.FLocalAmount else (-1) * FLocalAmount end) amount \n");
            } else if (CashflowTableService.this.currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) {
                sql.append(" sum(case ve.FEntryDC when 0 then ve.FReportingAmount else (-1) * FReportingAmount end) amount \n");
            } else {
                isForCurrency = true;
                sql.append(" sum(case ve.FEntryDC when 0 then ve.FOriginalAmount else (-1) * FOriginalAmount end) amount \n");
            }
            sql.append(" from T_GL_Voucher voucher join T_GL_VoucherEntry ve on voucher.FID = ve.FBillID \n");
            sql.append(" inner join T_BD_AccountView account on ve.FAccountID = account.FID \n");
            sql.append(" left join t_bd_cashflowaccountdiff on fdiffaccountid=account.FID \n");
            sql.append(" where voucher.FCompanyID = ? \n");
            params.add(companyID);
            sql.append(" and account.FCompanyID = ? \n");
            params.add(companyID);
            sql.append(" and fdiffaccountid is null \n");
            sql.append(" and account.FPLType <> ? \n");
            params.add(0);
            sql.append(" and account.FCategory = 1 \n");
            if (CashflowTableService.this.accountTableIds.get(companyID) != null) {
                sql.append(" and account.FAccountTableID = ? \n");
                params.add(CashflowTableService.this.accountTableIds.get(companyID));
            }
            sql.append(" and voucher.FPeriodID in ( ").append(periodIdsStr).append(" )\n");
            if (isForCurrency) {
                sql.append(" and ve.FCurrencyID = ? \n");
                params.add(CashflowTableService.this.currencyId);
            }
            sql.append(" and voucher.FSourceType<>1 \n");
            if (CashflowTableService.this.balType == 5) {
                sql.append(" and voucher.FBizStatus = 5 \n");
            } else {
                sql.append(" and voucher.FBizStatus in (1, 3, 5) \n");
            }
            if (diffAccountSet != null && diffAccountSet.length() > 0) {
                sql.append(" and account.FID not in (" + diffAccountSet + ") \n");
            }
            if ((rs = CashflowTableService.this.executeQuery(CashflowTableService.this.ctx, sql.toString(), params.toArray())).next()) {
                BigDecimal amount = rs.getBigDecimal("amount");
                return amount == null ? BigDecimal.ZERO : amount;
            }
            return BigDecimal.ZERO;
        }
    }
}

