/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class DefaultGLRptIDCreator
implements IGLRptIDCreator {
    private GLRptBaseCondition cond;
    private Map companys = new HashMap();
    private SimpleCompanyUserObject rootObj;

    public DefaultGLRptIDCreator(String mainTableAlias, GLRptBaseCondition cond) {
        this.cond = cond;
        if (cond.getTreeModelOfCompany() != null) {
            this.initCompanyMap(cond);
        }
    }

    private void initCompanyMap(GLRptBaseCondition cond) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)cond.getTreeModelOfCompany();
        Enumeration<TreeNode> e = root.breadthFirstEnumeration();
        this.rootObj = (SimpleCompanyUserObject)root.getUserObject();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
            this.companys.put(userObject.getCompanyId(), userObject);
        }
    }

    @Override
    public String getIDSelect() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("t.").append("KSQL_SEQ").append(", t.").append("SQL_BATCH");
        if (!this.cond.getCompany().isIsBizUnit() && this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level) {
            sql.append(", t.FOrgUnitID treeID ");
        }
        return sql.toString();
    }

    @Override
    public GLRptID create(ResultSet rs) throws SQLException {
        SimpleCompanyUserObject obj;
        GLRptTreeNode node = new GLRptTreeNode(rs.getInt("SQL_BATCH"), rs.getInt("KSQL_SEQ"));
        if (!this.cond.getCompany().isIsBizUnit() && this.cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level && (obj = this.getTreeNodeObjectById(rs.getString("treeID"))) != null) {
            node.setLevel(obj.getLevel());
            node.setLeaf(obj.isLeaf());
            node.setUserObject(obj);
        }
        return node;
    }

    public SimpleCompanyUserObject getTreeNodeObjectById(String objId) {
        SimpleCompanyUserObject obj = (SimpleCompanyUserObject)this.companys.get(objId);
        if (obj == null) {
            return this.rootObj;
        }
        return obj;
    }
}

