/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptBasePage;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GLNRptAccountBalancePage
extends GLNRptBasePage {
    protected boolean showYear = false;
    protected boolean showAsstDetail = false;
    protected int asstActCount = 0;
    protected List<AsstActTypeInfo> asstActTypes = null;
    private Map<String, Integer> aatIndexs = null;
    private boolean rebuildAsstAct = false;
    protected boolean showAsstActName = false;
    protected boolean showAsstActLongName = false;
    protected boolean showAsstActNumber = false;
    protected boolean showSumRow = false;
    protected boolean sumByUnion = false;
    protected boolean showByDispatchDc = false;
    protected String localPrecision = "";
    protected String rptPrecision = "";

    @Override
    protected void init() {
        super.init();
        Object param = this.params.get("showYear");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showYear = true;
        }
        if ((param = this.params.get("showAsstDetail")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstDetail = true;
        }
        if ((param = this.params.get("asstActCount")) != null && param.toString().trim().length() > 0) {
            try {
                int count = Integer.parseInt(param.toString().trim());
                if (count > 0) {
                    this.asstActCount = count;
                }
            }
            catch (Exception count) {
                // empty catch block
            }
        }
        if ((param = this.params.get("showAsstActName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActName = true;
        }
        if ((param = this.params.get("showAsstActLongName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActLongName = true;
        }
        if ((param = this.params.get("showAsstActNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActNumber = true;
        }
        if ((param = this.params.get("showSumRow")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showSumRow = true;
        }
        if ((param = this.params.get("sumByUnion")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.sumByUnion = true;
        }
        if ((param = this.params.get("showByDispatchDc")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showByDispatchDc = true;
        }
        this.asstActTypes = (List)this.params.get("asstActTypes");
        this.aatIndexs = new HashMap<String, Integer>();
        for (int i = 0; i < this.asstActTypes.size(); ++i) {
            this.aatIndexs.put(this.asstActTypes.get(i).getNumber(), i);
        }
        param = this.params.get("rebuildAsstAct");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.rebuildAsstAct = true;
        }
        this.localPrecision = (String)this.params.get("localPrecision");
        this.rptPrecision = (String)this.params.get("rptPrecision");
    }

    @Override
    protected String getPageSql() {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select /*+ LEADING(b) */ \n");
        if (this.sumByUnion) {
            sql.append("    u.FNumber FCompanyNumber, \n");
            if (this.showCompanyLongNumber) {
                sql.append("    s.FLongNumber FCompanyLongNumber, \n");
            }
            if (this.showCompanyName) {
                sql.append("    u.FName_" + loc + " FCompanyName, \n");
            }
            if (this.showCompanyLevel) {
                sql.append("    s.FLevel FCompanyLevel, \n");
            }
            if (this.showCompanyBizUnit) {
                sql.append("    s.FIsLeaf FIsBizUnit, \n");
            }
        } else {
            sql.append("    c.FNumber FCompanyNumber, \n");
            if (this.showCompanyLongNumber) {
                sql.append("    c.FLongNumber FCompanyLongNumber, \n");
            }
            if (this.showCompanyName) {
                sql.append("    c.FName_" + loc + " FCompanyName, \n");
            }
            if (this.showCompanyLevel) {
                sql.append("    c.FLevel FCompanyLevel, \n");
            }
            if (this.showCompanyBizUnit) {
                sql.append("    c.FIsBizUnit, \n");
            }
        }
        sql.append("    b.FAccountNumber, \n");
        if (this.showAccountName) {
            sql.append("    av.FName_" + loc + " FAccountName, \n");
        }
        if (this.showAccountLongName) {
            sql.append("    av.FDisplayName_" + loc + " FAccountLongName, \n");
        }
        if (this.showAccountLevel) {
            sql.append("    av.FLevel FAccountLevel, \n");
        }
        if (this.showAccountDc) {
            sql.append("    av.FDC FAccountDc, \n");
        }
        sql.append("    cy.FID FCurrencyID, \n");
        if (this.showCurrencyNumber) {
            sql.append("    cy.FNumber FCurrencyNumber, \n");
        }
        if (this.showCurrencyName) {
            sql.append("    cy.FName_" + loc + " FCurrencyName, \n");
        }
        if (this.showAsstDetail) {
            sql.append("    hg.FID FHgID, \n");
            if (this.rebuildAsstAct) {
                sql.append("    hg.FAsstAccountID FAsstAccountID, \n");
            } else {
                sql.append("    hg.FNumberGroup_" + loc + " FNumberGroup, \n");
                if (this.showAsstActLongName) {
                    sql.append("    hg.FDisplayNameGroup_" + loc + " FDisplayNameGroup, \n");
                }
            }
        }
        if (this.showFor) {
            if (this.showYear) {
                sql.append("    FYearBeginBalanceFor, \n");
                if (this.showByDispatchDc) {
                    sql.append("    FYearBeginBalanceDebitFor, \n");
                    sql.append("    FYearBeginBalanceCreditFor, \n");
                }
            }
            sql.append("    FBeginBalanceFor, \n");
            if (this.showByDispatchDc) {
                sql.append("    FBeginBalanceDebitFor, \n");
                sql.append("    FBeginBalanceCreditFor, \n");
            }
            sql.append("    FDebitFor, \n");
            sql.append("    FCreditFor, \n");
            sql.append("    FYearDebitFor, \n");
            sql.append("    FYearCreditFor, \n");
            sql.append("    FEndBalanceFor, \n");
            if (this.showByDispatchDc) {
                sql.append("    FEndBalanceDebitFor, \n");
                sql.append("    FEndBalanceCreditFor, \n");
            }
        }
        if (this.showLocal) {
            if (this.showYear) {
                sql.append("    FYearBeginBalanceLocal, \n");
                if (this.showByDispatchDc) {
                    sql.append("    FYearBeginBalanceDebitLocal, \n");
                    sql.append("    FYearBeginBalanceCreditLocal, \n");
                }
            }
            sql.append("    FBeginBalanceLocal, \n");
            if (this.showByDispatchDc) {
                sql.append("    FBeginBalanceDebitLocal, \n");
                sql.append("    FBeginBalanceCreditLocal, \n");
            }
            sql.append("    FDebitLocal, \n");
            sql.append("    FCreditLocal, \n");
            sql.append("    FYearDebitLocal, \n");
            sql.append("    FYearCreditLocal, \n");
            sql.append("    FEndBalanceLocal, \n");
            if (this.showByDispatchDc) {
                sql.append("    FEndBalanceDebitLocal, \n");
                sql.append("    FEndBalanceCreditLocal, \n");
            }
        }
        if (this.showRpt) {
            if (this.showYear) {
                sql.append("    FYearBeginBalanceRpt, \n");
                if (this.showByDispatchDc) {
                    sql.append("    FYearBeginBalanceDebitRpt, \n");
                    sql.append("    FYearBeginBalanceCreditRpt, \n");
                }
            }
            sql.append("    FBeginBalanceRpt, \n");
            if (this.showByDispatchDc) {
                sql.append("    FBeginBalanceDebitRpt, \n");
                sql.append("    FBeginBalanceCreditRpt, \n");
            }
            sql.append("    FDebitRpt, \n");
            sql.append("    FCreditRpt, \n");
            sql.append("    FYearDebitRpt, \n");
            sql.append("    FYearCreditRpt, \n");
            sql.append("    FEndBalanceRpt, \n");
            if (this.showByDispatchDc) {
                sql.append("    FEndBalanceDebitRpt, \n");
                sql.append("    FEndBalanceCreditRpt, \n");
            }
        }
        if (this.showQty) {
            sql.append("    mu.FName_" + loc + " FMeasureUnitName, \n");
            if (this.showYear) {
                sql.append("    FYearBeginQty, \n");
                if (this.showByDispatchDc) {
                    sql.append("    FYearBeginDebitQty, \n");
                    sql.append("    FYearBeginCreditQty, \n");
                }
            }
            sql.append("    FBeginQty, \n");
            if (this.showByDispatchDc) {
                sql.append("    FBeginDebitQty, \n");
                sql.append("    FBeginCreditQty, \n");
            }
            sql.append("    FDebitQty, \n");
            sql.append("    FCreditQty, \n");
            sql.append("    FYearDebitQty, \n");
            sql.append("    FYearCreditQty, \n");
            sql.append("    FEndQty, \n");
            if (this.showByDispatchDc) {
                sql.append("    FEndDebitQty, \n");
                sql.append("    FEndCreditQty, \n");
            }
        }
        if (this.showSumRow) {
            sql.append("    FIsTotal, \n");
        }
        sql.deleteCharAt(sql.lastIndexOf(","));
        sql.append("from " + this.params.get("pageId") + " b \n");
        if (this.sumByUnion) {
            sql.append("left join T_ORG_Structure s on s.FID = b.FUnionID \n");
            sql.append("left join T_ORG_BaseUnit u on u.FID = s.FUnitID \n");
        } else {
            sql.append("left join T_ORG_Company c on c.FID = b.FCompanyID \n");
        }
        sql.append("left join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
        sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
        sql.append("left join T_BD_MeasureUnit mu on mu.FID = b.FMeasureUnitID \n");
        if (this.showAsstDetail) {
            sql.append("left join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
        }
        sql.append("where KSQL_SEQ >= ? and KSQL_SEQ < ? \n");
        sql.append("order by KSQL_SEQ \n");
        return sql.toString();
    }

    @Override
    protected Object buildCache(ResultSet rowset) throws BOSException, SQLException {
        HashMap<String, Map<String, Object>> cache = new HashMap<String, Map<String, Object>>();
        if (this.rebuildAsstAct && this.asstActCount > 0) {
            HashMap<String, HashSet<String>> idss = new HashMap<String, HashSet<String>>();
            while (rowset.next()) {
                String asstAccountId;
                String hgId = rowset.getString("FHgId");
                if (hgId == null || (asstAccountId = rowset.getString("FAsstAccountID")) == null) continue;
                HashSet<String> ids = (HashSet<String>)idss.get(asstAccountId);
                if (ids == null) {
                    ids = new HashSet<String>();
                    idss.put(asstAccountId, ids);
                }
                ids.add(hgId);
            }
            rowset.beforeFirst();
            Map<String, Object> hgs = null;
            for (String asstAccountId : idss.keySet()) {
                List<AsstActTypeInfo> aats = this.getAsstActTypes(asstAccountId, this.asstActTypes);
                for (AsstActTypeInfo aat : aats) {
                    aat.put("showNumber", (Object)this.showAsstActNumber);
                    if (aat.isUseLongNumber()) {
                        aat.put("showLongNumber", (Object)true);
                    }
                    aat.put("showName", (Object)this.showAsstActName);
                    aat.put("showLongName", (Object)this.showAsstActLongName);
                }
                if (hgs == null) {
                    hgs = GLAsstAccountUtils.getAssistantHgs(this.ctx, asstAccountId, aats, (Set)idss.get(asstAccountId));
                    continue;
                }
                hgs.putAll(GLAsstAccountUtils.getAssistantHgs(this.ctx, asstAccountId, aats, (Set)idss.get(asstAccountId)));
            }
            cache.put("hgs", hgs);
        }
        return cache;
    }

    @Override
    protected List<String> buildRow(ResultSet rowset, Object cache) throws BOSException, SQLException {
        ArrayList<String> data = new ArrayList<String>();
        boolean isTotalRow = false;
        if (this.showSumRow) {
            isTotalRow = rowset.getInt("FIsTotal") == 1;
        }
        data.add(isTotalRow ? "" : rowset.getString("FCompanyNumber"));
        if (this.showCompanyLongNumber) {
            data.add(isTotalRow ? "" : rowset.getString("FCompanyLongNumber"));
        }
        if (this.showCompanyName) {
            data.add(isTotalRow ? "" : rowset.getString("FCompanyName"));
        }
        if (this.showCompanyLevel) {
            data.add(isTotalRow ? "" : rowset.getString("FCompanyLevel"));
        }
        if (this.showCompanyBizUnit) {
            data.add(isTotalRow ? "" : String.valueOf(rowset.getInt("FIsBizUnit")));
        }
        data.add(isTotalRow ? "" : rowset.getString("FAccountNumber"));
        if (this.showAccountName) {
            data.add(isTotalRow ? "" : rowset.getString("FAccountName"));
        }
        if (this.showAccountLongName) {
            data.add(isTotalRow ? "" : rowset.getString("FAccountLongName"));
        }
        if (this.showAccountLevel) {
            data.add(isTotalRow ? "" : rowset.getString("FAccountLevel"));
        }
        if (this.showAccountDc) {
            data.add(isTotalRow ? "1" : rowset.getString("FAccountDc"));
        }
        if (this.showCurrencyNumber) {
            String currencyNumber = rowset.getString("FCurrencyNumber");
            data.add(currencyNumber == null ? "" : currencyNumber);
        }
        if (this.showCurrencyName) {
            String currencyName = rowset.getString("FCurrencyName");
            data.add(currencyName == null ? "" : currencyName);
        }
        if (this.asstActCount > 0) {
            String hgId = rowset.getString("FHgId");
            data.add(hgId);
            String[] asstActs = null;
            if (this.rebuildAsstAct) {
                Map hgs;
                Map hg;
                if (hgId != null && hgId.length() > 0 && (hg = (Map)(hgs = (Map)((Map)cache).get("hgs")).get(hgId)) != null) {
                    String asstAccountId = rowset.getString("FAsstAccountID");
                    asstActs = this.buildAssData(this.getAsstActTypes(asstAccountId, this.asstActTypes), hg, true, this.showAsstActNumber, this.showAsstActName, this.showAsstActLongName);
                }
                if (asstActs == null) {
                    asstActs = new String[]{};
                }
            } else {
                asstActs = this.buildAssData(this.aatIndexs, rowset, "FHgId", "FNumberGroup", "FDisplayNameGroup", true, this.showAsstActNumber, this.showAsstActName, this.showAsstActLongName);
            }
            for (int i = 0; i < this.asstActCount; ++i) {
                data.add(i < asstActs.length ? asstActs[i] : "");
            }
        }
        if (this.showFor) {
            this.buildData(rowset, data, "For");
            data.add(String.valueOf(this.getCurrencyPrecision(this.ctx, rowset.getString("FCurrencyID"))));
        }
        if (this.showLocal) {
            this.buildData(rowset, data, "Local");
            data.add(this.localPrecision);
        }
        if (this.showRpt) {
            this.buildData(rowset, data, "Rpt");
            data.add(this.rptPrecision);
        }
        if (this.showQty) {
            String unitName = rowset.getString("FMeasureUnitName");
            data.add(unitName == null ? "" : unitName);
            this.buildData(rowset, data, "Qty");
            data.add("4");
        }
        if (this.showSumRow) {
            data.add(isTotalRow ? "1" : "0");
        }
        return data;
    }

    protected void buildData(ResultSet rowset, List<String> data, String type) throws SQLException {
        BigDecimal yearCredit;
        BigDecimal yearDebit;
        BigDecimal endBalance = rowset.getBigDecimal(("Qty".equals(type) ? "FEnd" : "FEndBalance") + type);
        if (endBalance == null) {
            endBalance = GlUtils.zero;
        }
        if ((yearDebit = rowset.getBigDecimal("FYearDebit" + type)) == null) {
            yearDebit = GlUtils.zero;
        }
        if ((yearCredit = rowset.getBigDecimal("FYearCredit" + type)) == null) {
            yearCredit = GlUtils.zero;
        }
        if (this.showYear) {
            if (this.showByDispatchDc) {
                BigDecimal yearBeginDebit = rowset.getBigDecimal(("Qty".equals(type) ? "FYearBeginDebit" : "FYearBeginBalanceDebit") + type);
                BigDecimal yearBeginCredit = rowset.getBigDecimal(("Qty".equals(type) ? "FYearBeginCredit" : "FYearBeginBalanceCredit") + type);
                data.add(yearBeginDebit == null ? "0" : String.valueOf(yearBeginDebit));
                data.add(yearBeginCredit == null ? "0" : String.valueOf(yearBeginCredit));
            } else if (this.notIncludePLVoucher) {
                BigDecimal yearBegin = rowset.getBigDecimal(("Qty".equals(type) ? "FYearBegin" : "FYearBeginBalance") + type);
                data.add(yearBegin == null ? "0" : String.valueOf(yearBegin));
            } else {
                data.add(String.valueOf(endBalance.subtract(yearDebit).add(yearCredit)));
            }
        }
        if (this.showByDispatchDc) {
            BigDecimal beginDebit = rowset.getBigDecimal(("Qty".equals(type) ? "FBeginDebit" : "FBeginBalanceDebit") + type);
            BigDecimal beginCredit = rowset.getBigDecimal(("Qty".equals(type) ? "FBeginCredit" : "FBeginBalanceCredit") + type);
            data.add(beginDebit == null ? "0" : String.valueOf(beginDebit));
            data.add(beginCredit == null ? "0" : String.valueOf(beginCredit));
        } else {
            BigDecimal begin = rowset.getBigDecimal(("Qty".equals(type) ? "FBegin" : "FBeginBalance") + type);
            data.add(begin == null ? "0" : String.valueOf(begin));
        }
        BigDecimal debit = rowset.getBigDecimal("FDebit" + type);
        BigDecimal credit = rowset.getBigDecimal("FCredit" + type);
        data.add(debit == null ? "0" : String.valueOf(debit));
        data.add(credit == null ? "0" : String.valueOf(credit));
        if (this.showYear) {
            data.add(String.valueOf(yearDebit));
            data.add(String.valueOf(yearCredit));
        }
        if (this.showByDispatchDc) {
            BigDecimal endDebit = rowset.getBigDecimal(("Qty".equals(type) ? "FEndDebit" : "FEndBalanceDebit") + type);
            BigDecimal endCredit = rowset.getBigDecimal(("Qty".equals(type) ? "FEndCredit" : "FEndBalanceCredit") + type);
            data.add(endDebit == null ? "0" : String.valueOf(endDebit));
            data.add(endCredit == null ? "0" : String.valueOf(endCredit));
        } else {
            data.add(String.valueOf(endBalance));
        }
    }

    @Override
    public Map<String, Object> search(Context ctx, Map params) throws BOSException, SQLException {
        int i;
        ArrayList rows = new ArrayList();
        this.result.put("rows", rows);
        String word = (String)params.get("word");
        if (word == null || word.length() == 0) {
            return this.result;
        }
        boolean mistiness = true;
        if ("false".equalsIgnoreCase((String)params.get("mistiness"))) {
            mistiness = false;
        }
        boolean caseSensitive = true;
        if ("false".equalsIgnoreCase((String)params.get("caseSensitive"))) {
            caseSensitive = false;
        }
        if (!caseSensitive) {
            word = word.toLowerCase(Locale.getDefault());
        }
        BigDecimal bdWord = null;
        try {
            bdWord = new BigDecimal(word);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean previous = "previous".equalsIgnoreCase((String)params.get("action"));
        boolean wrapSearch = "true".equalsIgnoreCase((String)params.get("wrapSearch"));
        int rowIndex = 0;
        Object param = params.get("rowIndex");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                int i2 = Integer.parseInt(param.toString().trim());
                if (i2 >= 0) {
                    rowIndex = i2;
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
        }
        ++rowIndex;
        int columIndex = -1;
        param = params.get("columIndex");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                columIndex = Integer.parseInt(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (columIndex < 0) {
            columIndex = previous ? 0 : -1;
        }
        final HashMap<String, Integer> targetIndexs = new HashMap<String, Integer>();
        ArrayList<String> targets = new ArrayList<String>();
        Map sourceIndexs = (Map)params.get("targetIndexs");
        if (sourceIndexs == null || sourceIndexs.size() == 0) {
            this.errs.add(this.getResource("SelectSearchColumn"));
            return this.result;
        }
        for (Object target : sourceIndexs.keySet()) {
            param = sourceIndexs.get(target);
            Integer targetIndex = null;
            if (param instanceof Integer) {
                targetIndex = (Integer)param;
            } else if (param instanceof String) {
                try {
                    targetIndex = Integer.parseInt((String)param);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String name = (String)target;
            if (targetIndex == null || targetIndex < 0) continue;
            if (name.startsWith("asstActName")) {
                try {
                    int asstActIndex = Integer.parseInt(name.substring(11));
                    if (asstActIndex < 1 || asstActIndex > this.asstActTypes.size()) continue;
                    targetIndexs.put(name, targetIndex);
                    targets.add(name);
                }
                catch (Exception asstActIndex) {}
                continue;
            }
            targetIndexs.put(name, targetIndex);
            targets.add(name);
        }
        if (targetIndexs.size() == 0) {
            this.errs.add(this.getResource("ColumnNotSupportBackSearch"));
            return this.result;
        }
        Collections.sort(targets, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = (Integer)targetIndexs.get(o1);
                int i2 = (Integer)targetIndexs.get(o2);
                return i1 - i2;
            }
        });
        StringBuffer sql = new StringBuffer();
        ArrayList<String> searchParams = new ArrayList<String>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String csStart = "    ";
        String csEnd = "";
        if (!caseSensitive) {
            csStart = "    lower(";
            csEnd = ")";
        }
        sql.append("select /*+ LEADING(b) */ top 2 \n");
        if (targets.contains("companyNumber")) {
            if (this.sumByUnion) {
                sql.append(csStart + "u.FNumber" + csEnd + " FCompanyNumber, \n");
            } else {
                sql.append(csStart + "c.FNumber" + csEnd + " FCompanyNumber, \n");
            }
        }
        if (targets.contains("companyLongNumber")) {
            if (this.sumByUnion) {
                sql.append(csStart + "s.FLongNumber" + csEnd + " FCompanyLongNumber, \n");
            } else {
                sql.append(csStart + "c.FLongNumber" + csEnd + " FCompanyLongNumber, \n");
            }
        }
        if (targets.contains("companyName")) {
            if (this.sumByUnion) {
                sql.append(csStart + "u.FName_" + loc + csEnd + " FCompanyName, \n");
            } else {
                sql.append(csStart + "c.FName_" + loc + csEnd + " FCompanyName, \n");
            }
        }
        if (targets.contains("accountNumber")) {
            sql.append(csStart + "av.FNumber" + csEnd + " FAccountNumber, \n");
        }
        if (targets.contains("accountName")) {
            sql.append(csStart + "av.FName_" + loc + csEnd + " FAccountName, \n");
        }
        if (targets.contains("accountLongName")) {
            sql.append(csStart + "av.FDisplayName_" + loc + csEnd + " FAccountLongName, \n");
        }
        if (targets.contains("currencyNumber")) {
            sql.append(csStart + "cy.FNumber" + csEnd + " FCurrencyNumber, \n");
        }
        if (targets.contains("currencyName")) {
            sql.append(csStart + "cy.FName_" + loc + csEnd + " FCurrencyName, \n");
        }
        boolean aatTarget = false;
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            if (!targetIndexs.containsKey("asstActName" + (i + 1))) continue;
            AsstActTypeInfo type = this.asstActTypes.get(i);
            aatTarget = true;
            if (this.showAsstActNumber) {
                String FNumber = ".FNumber";
                if (type.isUseLongNumber()) {
                    FNumber = ".FLongNumber";
                }
                sql.append(csStart + "aat" + (i + 1) + FNumber + csEnd + " FAat" + (i + 1) + "Number, \n");
            }
            if (!this.showAsstActName && !this.showAsstActLongName) continue;
            String FName = "aat" + (i + 1) + ".FName_" + loc;
            if (this.showAsstActLongName) {
                FName = type.isIsMultilevel() && type.getGroupTableName() == null ? "aat" + (i + 1) + ".FDisplayName_" + loc : "g" + (i + 1) + ".FDisplayName_" + loc + " || '_' || " + FName;
            }
            sql.append(csStart + FName + csEnd + " FAat" + (i + 1) + "Name, \n");
        }
        sql.append("    b.KSQL_SEQ \n");
        sql.append("from " + params.get("pageId") + " b \n");
        if (this.sumByUnion) {
            sql.append("left join T_ORG_Structure s on s.FID = b.FUnionID \n");
            sql.append("left join T_ORG_BaseUnit u on u.FID = s.FUnitID \n");
        } else {
            sql.append("left join T_ORG_Company c on c.FID = b.FCompanyID \n");
        }
        sql.append("left join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
        sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (aatTarget) {
            sql.append("join T_BD_AssistantHG hg on hg.FID = b.FAssistGrpID \n");
            for (i = 0; i < this.asstActTypes.size(); ++i) {
                if (!targetIndexs.containsKey("asstActName" + (i + 1))) continue;
                AsstActTypeInfo aat = this.asstActTypes.get(i);
                sql.append("join " + aat.getRealtionDataObject() + " aat" + (i + 1) + " on aat" + (i + 1) + ".FID = hg." + aat.getMappingFieldName() + " \n");
                if (aat.getGroupTableName() == null) continue;
                sql.append("join " + aat.getGroupTableName() + " g" + (i + 1) + " on g" + (i + 1) + ".FID = aat" + (i + 1) + "." + aat.getGroupMappingFieldName() + " \n");
            }
        }
        csStart = "";
        csEnd = "";
        if (!caseSensitive) {
            csStart = "lower(";
            csEnd = ")";
        }
        String compare = mistiness ? " like ? \n" : " = ? \n";
        String compareValue = mistiness ? "%" + word + "%" : word;
        StringBuffer where = new StringBuffer();
        if (targets.contains("companyNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "u.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("companyLongNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "s.FLongNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FLongNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("companyName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "u.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("accountNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("accountName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("accountLongName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FDisplayName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("currencyNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cy.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("currencyName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cy.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        for (int i3 = 0; i3 < this.asstActTypes.size(); ++i3) {
            String ww;
            if (!targetIndexs.containsKey("asstActName" + (i3 + 1))) continue;
            AsstActTypeInfo type = this.asstActTypes.get(i3);
            String assWord = word;
            int ix = assWord.indexOf(58);
            if (ix > 0) {
                assWord = assWord.substring(ix + 1);
            }
            String FNumber = ".FNumber";
            if (type.isUseLongNumber()) {
                FNumber = ".FLongNumber";
            }
            Object FName = "aat" + (i3 + 1) + ".FName_" + loc;
            if (this.showAsstActLongName) {
                FName = type.isIsMultilevel() && type.getGroupTableName() == null ? "aat" + (i3 + 1) + ".FDisplayName_" + loc : "g" + (i3 + 1) + ".FDisplayName_" + loc + " || '_' || " + (String)FName;
            }
            if (this.showAsstActNumber) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                ww = assWord;
                if (type.isUseLongNumber()) {
                    ww = ww.replace('.', '!');
                }
                where.append(csStart + "aat" + (i3 + 1) + FNumber + csEnd);
                where.append(compare);
                searchParams.add(mistiness ? "%" + ww + "%" : ww);
            }
            if (this.showAsstActName || this.showAsstActLongName) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                where.append(csStart + (String)FName + csEnd);
                where.append(compare);
                searchParams.add(mistiness ? "%" + assWord + "%" : assWord);
            }
            if (!this.showAsstActNumber || assWord.indexOf(32) <= 0 || !this.showAsstActName && !this.showAsstActLongName) continue;
            if (where.length() > 0) {
                where.append("or ");
            }
            ww = assWord;
            if (type.isUseLongNumber()) {
                int idx = assWord.indexOf(32);
                ww = ww.substring(0, idx).replace('.', '!') + ww.substring(idx);
            }
            where.append(csStart + "aat" + (i3 + 1) + FNumber + " || ' ' || " + (String)FName + csEnd);
            where.append(compare);
            searchParams.add(mistiness ? "%" + ww + "%" : ww);
        }
        if (where.length() <= 0) {
            this.errs.add(this.getResource("ColumnNotSupportBackSearch"));
            return this.result;
        }
        where.append(") \n");
        if (previous) {
            where.append("order by KSQL_SEQ desc \n");
        } else {
            where.append("order by KSQL_SEQ \n");
        }
        StringBuffer sql1 = new StringBuffer();
        ArrayList<Object> searchParams1 = new ArrayList<Object>();
        sql1.append(sql);
        if (previous) {
            sql1.append("where KSQL_SEQ <= ? \n");
            searchParams1.add(rowIndex);
        } else {
            sql1.append("where KSQL_SEQ >= ? \n");
            searchParams1.add(rowIndex);
        }
        sql1.append("and ( \n" + where);
        searchParams1.addAll(searchParams);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])searchParams1.toArray());
        while (rowset.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int index = rowset.getInt("KSQL_SEQ");
            for (String target : targets) {
                String name;
                String number;
                String currencyName;
                String currencyNumber;
                String accountLongName;
                String accountName;
                String accountNumber;
                String companyName;
                String companyLongNumber;
                String companyNumber;
                if (index == rowIndex && (index != rowIndex || (!previous || (Integer)targetIndexs.get(target) >= columIndex) && (previous || (Integer)targetIndexs.get(target) <= columIndex))) continue;
                if (target.equals("companyNumber") && this.isMatch(word, bdWord, companyNumber = rowset.getString("FCompanyNumber"), mistiness)) {
                    row.put("name", "companyNumber");
                    row.put("value", companyNumber);
                    break;
                }
                if (target.equals("companyLongNumber") && this.isMatch(word, bdWord, companyLongNumber = rowset.getString("FCompanyLongNumber"), mistiness)) {
                    row.put("name", "companyLongNumber");
                    row.put("value", companyLongNumber);
                    break;
                }
                if (target.equals("companyName") && this.isMatch(word, bdWord, companyName = rowset.getString("FCompanyName"), mistiness)) {
                    row.put("name", "companyName");
                    row.put("value", companyName);
                    break;
                }
                if (target.equals("accountNumber") && this.isMatch(word, bdWord, accountNumber = rowset.getString("FAccountNumber"), mistiness)) {
                    row.put("name", "accountNumber");
                    row.put("value", accountNumber);
                    break;
                }
                if (target.equals("accountName") && this.isMatch(word, bdWord, accountName = rowset.getString("FAccountName"), mistiness)) {
                    row.put("name", "accountName");
                    row.put("value", accountName);
                    break;
                }
                if (target.equals("accountLongName") && this.isMatch(word, bdWord, accountLongName = rowset.getString("FAccountLongName"), mistiness)) {
                    row.put("name", "accountLongName");
                    row.put("value", accountLongName);
                    break;
                }
                if (target.equals("currencyNumber") && this.isMatch(word, bdWord, currencyNumber = rowset.getString("FCurrencyNumber"), mistiness)) {
                    row.put("name", "currencyNumber");
                    row.put("value", currencyNumber);
                    break;
                }
                if (target.equals("currencyName") && this.isMatch(word, bdWord, currencyName = rowset.getString("FCurrencyName"), mistiness)) {
                    row.put("name", "currencyName");
                    row.put("value", currencyName);
                    break;
                }
                if (!target.startsWith("asstActName")) continue;
                int asstActIndex = Integer.parseInt(target.substring(11));
                AsstActTypeInfo type = this.asstActTypes.get(asstActIndex - 1);
                String myWord = word;
                int ix = myWord.indexOf(58);
                if (ix > 0) {
                    myWord = myWord.substring(ix + 1);
                }
                if (this.showAsstActNumber) {
                    number = rowset.getString("FAat" + asstActIndex + "Number");
                    if (type.isUseLongNumber()) {
                        number = number.replace('!', '.');
                    }
                    if (this.isAssMatch(myWord, number, mistiness)) {
                        row.put("name", target);
                        row.put("value", number);
                        break;
                    }
                }
                if ((this.showAsstActName || this.showAsstActLongName) && this.isAssMatch(myWord, name = rowset.getString("FAat" + asstActIndex + "Name"), mistiness)) {
                    row.put("name", target);
                    row.put("value", name);
                    break;
                }
                if (!this.showAsstActNumber || myWord.indexOf(32) <= 0 || !this.showAsstActName && !this.showAsstActLongName) continue;
                number = rowset.getString("FAat" + asstActIndex + "Number");
                if (type.isUseLongNumber()) {
                    number = number.replace('!', '.');
                }
                String name2 = rowset.getString("FAat" + asstActIndex + "Name");
                if (!this.isAssMatch(myWord, number + " " + name2, mistiness)) continue;
                row.put("name", target);
                row.put("value", name2);
                break;
            }
            if (!row.containsKey("name")) continue;
            row.put("index", index);
            rows.add(row);
            return this.result;
        }
        if (!wrapSearch) {
            return this.result;
        }
        StringBuffer sql2 = new StringBuffer();
        ArrayList<Object> searchParams2 = new ArrayList<Object>();
        sql2.append(sql);
        if (previous) {
            sql2.append("where KSQL_SEQ >= ? \n");
            searchParams2.add(rowIndex);
        } else {
            sql2.append("where KSQL_SEQ <= ? \n");
            searchParams2.add(rowIndex);
        }
        sql2.append("and ( \n" + where);
        searchParams2.addAll(searchParams);
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])searchParams1.toArray());
        while (rowset.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int index = rowset.getInt("KSQL_SEQ");
            for (String target : targets) {
                String name;
                String number;
                String currencyName;
                String currencyNumber;
                String accountLongName;
                String accountName;
                String accountNumber;
                String companyName;
                String companyLongNumber;
                String companyNumber;
                if (index == rowIndex && (index != rowIndex || (!previous || (Integer)targetIndexs.get(target) < columIndex) && (previous || (Integer)targetIndexs.get(target) > columIndex))) continue;
                if (target.equals("companyNumber") && this.isMatch(word, bdWord, companyNumber = rowset.getString("FCompanyNumber"), mistiness)) {
                    row.put("name", "companyNumber");
                    row.put("value", companyNumber);
                    break;
                }
                if (target.equals("companyLongNumber") && this.isMatch(word, bdWord, companyLongNumber = rowset.getString("FCompanyLongNumber"), mistiness)) {
                    row.put("name", "companyLongNumber");
                    row.put("value", companyLongNumber);
                    break;
                }
                if (target.equals("companyName") && this.isMatch(word, bdWord, companyName = rowset.getString("FCompanyName"), mistiness)) {
                    row.put("name", "companyName");
                    row.put("value", companyName);
                    break;
                }
                if (target.equals("accountNumber") && this.isMatch(word, bdWord, accountNumber = rowset.getString("FAccountNumber"), mistiness)) {
                    row.put("name", "accountNumber");
                    row.put("value", accountNumber);
                    break;
                }
                if (target.equals("accountName") && this.isMatch(word, bdWord, accountName = rowset.getString("FAccountName"), mistiness)) {
                    row.put("name", "accountName");
                    row.put("value", accountName);
                    break;
                }
                if (target.equals("accountLongName") && this.isMatch(word, bdWord, accountLongName = rowset.getString("FAccountLongName"), mistiness)) {
                    row.put("name", "accountLongName");
                    row.put("value", accountLongName);
                    break;
                }
                if (target.equals("currencyNumber") && this.isMatch(word, bdWord, currencyNumber = rowset.getString("FCurrencyNumber"), mistiness)) {
                    row.put("name", "currencyNumber");
                    row.put("value", currencyNumber);
                    break;
                }
                if (target.equals("currencyName") && this.isMatch(word, bdWord, currencyName = rowset.getString("FCurrencyName"), mistiness)) {
                    row.put("name", "currencyName");
                    row.put("value", currencyName);
                    break;
                }
                if (!target.startsWith("asstActName")) continue;
                int asstActIndex = Integer.parseInt(target.substring(11));
                AsstActTypeInfo type = this.asstActTypes.get(asstActIndex - 1);
                String myWord = word;
                int ix = myWord.indexOf(58);
                if (ix > 0) {
                    myWord = myWord.substring(ix + 1);
                }
                if (this.showAsstActNumber) {
                    number = rowset.getString("FAat" + asstActIndex + "Number");
                    if (type.isUseLongNumber()) {
                        number = number.replace('!', '.');
                    }
                    if (this.isAssMatch(myWord, number, mistiness)) {
                        row.put("name", target);
                        row.put("value", number);
                        break;
                    }
                }
                if ((this.showAsstActName || this.showAsstActLongName) && this.isAssMatch(myWord, name = rowset.getString("FAat" + asstActIndex + "Name"), mistiness)) {
                    row.put("name", target);
                    row.put("value", name);
                    break;
                }
                if (!this.showAsstActNumber || myWord.indexOf(32) <= 0 || !this.showAsstActName && !this.showAsstActLongName) continue;
                number = rowset.getString("FAat" + asstActIndex + "Number");
                if (type.isUseLongNumber()) {
                    number = number.replace('!', '.');
                }
                String name3 = rowset.getString("FAat" + asstActIndex + "Name");
                if (!this.isAssMatch(myWord, number + " " + name3, mistiness)) continue;
                row.put("name", target);
                row.put("value", name3);
                break;
            }
            if (!row.containsKey("name")) continue;
            row.put("index", index);
            rows.add(row);
            return this.result;
        }
        return this.result;
    }

    protected boolean isMatch(String word, BigDecimal bdWord, Object value, boolean mistiness) {
        if (value != null) {
            String v;
            if (value instanceof BigDecimal) {
                if (bdWord != null && bdWord.compareTo((BigDecimal)value) == 0) {
                    return true;
                }
                v = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                if (v.equals(word)) {
                    return true;
                }
            }
            v = value.toString();
            if (mistiness && v.contains(word) || !mistiness && v.equals(word)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAssMatch(String word, String value, boolean mistiness) {
        if (value != null) {
            String str;
            String v = value.toString();
            if (mistiness) {
                return v.contains(word);
            }
            int index = v.indexOf(":");
            if (index > 0 && (index = (str = v.substring(index + 1)).indexOf(" ")) > 0 && (str.substring(0, index).equals(word) || str.substring(index + 1).equals(word))) {
                return true;
            }
            return v.equals(word);
        }
        return false;
    }
}

