/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptBasePage;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GLNRptAsstActBalancePage
extends GLNRptBasePage {
    protected boolean showYear = false;
    protected boolean showAsstActId = false;
    protected boolean showAsstActNumber = false;
    protected boolean showAsstActLongNumber = false;
    protected boolean showAsstActLevel = false;
    protected boolean showAsstActName = false;
    protected boolean showAsstActLongName = false;
    protected List<AsstActTypeInfo> asstActTypes = null;
    protected boolean showBizCode = false;
    protected int groupIdx = -1;
    protected boolean showSumRow = false;
    protected boolean sumByUnion = false;
    protected boolean showByDispatchDc = false;
    private String companyTopId = null;
    protected String localPrecision = "";
    protected String rptPrecision = "";
    protected Map<String, Integer> qtyPrecisions = new HashMap<String, Integer>();

    @Override
    protected void init() {
        super.init();
        Object param = this.params.get("showYear");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showYear = true;
        }
        if ((param = this.params.get("showAsstActId")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActId = true;
        }
        if ((param = this.params.get("showAsstActNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActNumber = true;
        }
        if ((param = this.params.get("showAsstActLongNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActLongNumber = true;
        }
        if ((param = this.params.get("showAsstActLevel")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActLevel = true;
        }
        if ((param = this.params.get("showAsstActName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActName = true;
        }
        if ((param = this.params.get("showAsstActLongName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAsstActLongName = true;
        }
        if ((param = this.params.get("showBizCode")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showBizCode = true;
        }
        this.asstActTypes = (List)this.params.get("asstActTypes");
        this.groupIdx = (Integer)this.params.get("groupIdx");
        param = this.params.get("showSumRow");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showSumRow = true;
        }
        if ((param = this.params.get("sumByUnion")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.sumByUnion = true;
        }
        if ((param = this.params.get("showByDispatchDc")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showByDispatchDc = true;
        }
        this.companyTopId = (String)this.params.get("companyTopId");
        this.localPrecision = (String)this.params.get("localPrecision");
        this.rptPrecision = (String)this.params.get("rptPrecision");
    }

    @Override
    protected String getPageSql() {
        AsstActTypeInfo aat;
        int i;
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select /*+ LEADING(b) */ \n");
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            aat = this.asstActTypes.get(i);
            if (this.showAsstActId) {
                if (i == this.groupIdx) {
                    sql.append("    case when b.FAsstActID" + (i + 1) + " is not null then b.FAsstActID" + (i + 1) + " else g.FID end FAsstActID" + (i + 1) + ", \n");
                } else {
                    sql.append("    b.FAsstActID" + (i + 1) + ", \n");
                }
            }
            if (i == this.groupIdx) {
                if (this.showAsstActNumber) {
                    sql.append("    case when b.FAsstActID" + (i + 1) + " is not null then aat" + (i + 1) + ".FNumber else g.FNumber end FAsstActNumber" + (i + 1) + ", \n");
                }
                if (this.showAsstActLongNumber) {
                    sql.append("    case when b.FAsstActID" + (i + 1) + " is not null then g.FLongNumber || '!' || aat" + (i + 1) + ".FNumber else g.FLongNumber end FAsstActLongNumber" + (i + 1) + ", \n");
                }
                if (this.showAsstActLevel) {
                    sql.append("    case when b.FAsstActID" + (i + 1) + " is not null then g.FLevel+1 else g.FLevel end FAsstActLevel" + (i + 1) + ", \n");
                }
                if (this.showAsstActName) {
                    sql.append("    case when b.FAsstActID" + (i + 1) + " is not null then aat" + (i + 1) + ".FName_" + loc + " else g.FName_" + loc + " end FAsstActName" + (i + 1) + ", \n");
                }
                if (!this.showAsstActLongName) continue;
                sql.append("    case when b.FAsstActID" + (i + 1) + " is not null then g.FDisplayName_" + loc + " || '_' || aat" + (i + 1) + ".FName_" + loc + " else g.FDisplayName_" + loc + " end FAsstActLongName" + (i + 1) + ", \n");
                continue;
            }
            if (aat.isIsMultilevel()) {
                if (this.showAsstActNumber) {
                    sql.append("    aat" + (i + 1) + ".FNumber FAsstActNumber" + (i + 1) + ", \n");
                }
                if (this.showAsstActName) {
                    sql.append("    aat" + (i + 1) + ".FName_" + loc + " FAsstActName" + (i + 1) + ", \n");
                }
                if (aat.getGroupTableName() != null) {
                    if (this.showAsstActLongNumber) {
                        sql.append("    case when b.FAsstActID" + (i + 1) + " is not null then g" + (i + 1) + ".FLongNumber || '!' || aat" + (i + 1) + ".FNumber else null end FAsstActLongNumber" + (i + 1) + ", \n");
                    }
                    if (this.showAsstActLevel) {
                        sql.append("    g" + (i + 1) + ".FLevel+1 FAsstActLevel" + (i + 1) + ", \n");
                    }
                    if (!this.showAsstActLongName) continue;
                    sql.append("    case when b.FAsstActID" + (i + 1) + " is not null then g" + (i + 1) + ".FDisplayName_" + loc + " || '_' || aat" + (i + 1) + ".FName_" + loc + " else null end FAsstActLongName" + (i + 1) + ", \n");
                    continue;
                }
                if (this.showAsstActLongNumber) {
                    sql.append("    aat" + (i + 1) + ".FLongNumber FAsstActLongNumber" + (i + 1) + ", \n");
                }
                if (this.showAsstActLevel) {
                    sql.append("    aat" + (i + 1) + ".FLevel FAsstActLevel" + (i + 1) + ", \n");
                }
                if (!this.showAsstActLongName) continue;
                sql.append("    aat" + (i + 1) + ".FDisplayName_" + loc + " FAsstActLongName" + (i + 1) + ", \n");
                continue;
            }
            if (this.showAsstActNumber || this.showAsstActLongNumber) {
                sql.append("    aat" + (i + 1) + ".FNumber FAsstActNumber" + (i + 1) + ", \n");
            }
            if (!this.showAsstActName && !this.showAsstActLongName) continue;
            sql.append("    aat" + (i + 1) + ".FName_" + loc + " FAsstActName" + (i + 1) + ", \n");
        }
        sql.append("    b.FAccountNumber, \n");
        if (this.showAccountName) {
            sql.append("    av.FName_" + loc + " FAccountName, \n");
        }
        if (this.showAccountLongName) {
            sql.append("    av.FDisplayName_" + loc + " FAccountLongName, \n");
        }
        if (this.showAccountLevel) {
            sql.append("    av.FLevel FAccountLevel, \n");
        }
        if (this.showAccountDc) {
            sql.append("    av.FDC FAccountDc, \n");
        }
        sql.append("    cy.FID FCurrencyID, \n");
        if (this.showCurrencyNumber) {
            sql.append("    cy.FNumber FCurrencyNumber, \n");
        }
        if (this.showCurrencyName) {
            sql.append("    cy.FName_" + loc + " FCurrencyName, \n");
        }
        if (this.sumByUnion) {
            sql.append("    u.FNumber FCompanyNumber, \n");
            if (this.showCompanyLongNumber) {
                sql.append("    s.FLongNumber FCompanyLongNumber, \n");
            }
            if (this.showCompanyName) {
                sql.append("    u.FName_" + loc + " FCompanyName, \n");
            }
            if (this.showCompanyLevel) {
                sql.append("    s.FLevel FCompanyLevel, \n");
            }
            if (this.showCompanyBizUnit) {
                sql.append("    s.FIsLeaf FIsBizUnit, \n");
            }
        } else {
            sql.append("    c.FNumber FCompanyNumber, \n");
            if (this.showCompanyLongNumber) {
                sql.append("    c.FLongNumber FCompanyLongNumber, \n");
            }
            if (this.showCompanyName) {
                sql.append("    c.FName_" + loc + " FCompanyName, \n");
            }
            if (this.showCompanyLevel) {
                sql.append("    c.FLevel FCompanyLevel, \n");
            }
            if (this.showCompanyBizUnit) {
                sql.append("    c.FIsBizUnit, \n");
            }
        }
        if (this.showFor) {
            if (this.showYear) {
                sql.append("    FYearBeginBalanceFor, \n");
                if (this.showByDispatchDc) {
                    sql.append("    FYearBeginBalanceDebitFor, \n");
                    sql.append("    FYearBeginBalanceCreditFor, \n");
                }
            }
            sql.append("    FBeginBalanceFor, \n");
            if (this.showByDispatchDc) {
                sql.append("    FBeginBalanceDebitFor, \n");
                sql.append("    FBeginBalanceCreditFor, \n");
            }
            sql.append("    FDebitFor, \n");
            sql.append("    FCreditFor, \n");
            sql.append("    FYearDebitFor, \n");
            sql.append("    FYearCreditFor, \n");
            sql.append("    FEndBalanceFor, \n");
            if (this.showByDispatchDc) {
                sql.append("    FEndBalanceDebitFor, \n");
                sql.append("    FEndBalanceCreditFor, \n");
            }
        }
        if (this.showLocal) {
            if (this.showYear) {
                sql.append("    FYearBeginBalanceLocal, \n");
                if (this.showByDispatchDc) {
                    sql.append("    FYearBeginBalanceDebitLocal, \n");
                    sql.append("    FYearBeginBalanceCreditLocal, \n");
                }
            }
            sql.append("    FBeginBalanceLocal, \n");
            if (this.showByDispatchDc) {
                sql.append("    FBeginBalanceDebitLocal, \n");
                sql.append("    FBeginBalanceCreditLocal, \n");
            }
            sql.append("    FDebitLocal, \n");
            sql.append("    FCreditLocal, \n");
            sql.append("    FYearDebitLocal, \n");
            sql.append("    FYearCreditLocal, \n");
            sql.append("    FEndBalanceLocal, \n");
            if (this.showByDispatchDc) {
                sql.append("    FEndBalanceDebitLocal, \n");
                sql.append("    FEndBalanceCreditLocal, \n");
            }
        }
        if (this.showRpt) {
            if (this.showYear) {
                sql.append("    FYearBeginBalanceRpt, \n");
                if (this.showByDispatchDc) {
                    sql.append("    FYearBeginBalanceDebitRpt, \n");
                    sql.append("    FYearBeginBalanceCreditRpt, \n");
                }
            }
            sql.append("    FBeginBalanceRpt, \n");
            if (this.showByDispatchDc) {
                sql.append("    FBeginBalanceDebitRpt, \n");
                sql.append("    FBeginBalanceCreditRpt, \n");
            }
            sql.append("    FDebitRpt, \n");
            sql.append("    FCreditRpt, \n");
            sql.append("    FYearDebitRpt, \n");
            sql.append("    FYearCreditRpt, \n");
            sql.append("    FEndBalanceRpt, \n");
            if (this.showByDispatchDc) {
                sql.append("    FEndBalanceDebitRpt, \n");
                sql.append("    FEndBalanceCreditRpt, \n");
            }
        }
        if (this.showQty) {
            sql.append("    mu.FName_" + loc + " FMeasureUnitName, \n");
            if (this.showYear) {
                sql.append("    FYearBeginQty, \n");
                if (this.showByDispatchDc) {
                    sql.append("    FYearBeginDebitQty, \n");
                    sql.append("    FYearBeginCreditQty, \n");
                }
            }
            sql.append("    FBeginQty, \n");
            if (this.showByDispatchDc) {
                sql.append("    FBeginDebitQty, \n");
                sql.append("    FBeginCreditQty, \n");
            }
            sql.append("    FDebitQty, \n");
            sql.append("    FCreditQty, \n");
            sql.append("    FYearDebitQty, \n");
            sql.append("    FYearCreditQty, \n");
            sql.append("    FEndQty, \n");
            if (this.showByDispatchDc) {
                sql.append("    FEndDebitQty, \n");
                sql.append("    FEndCreditQty, \n");
            }
        }
        if (this.showSumRow) {
            sql.append("    FIsTotal, \n");
        }
        sql.deleteCharAt(sql.lastIndexOf(","));
        sql.append("from " + this.params.get("pageId") + " b \n");
        if (this.sumByUnion) {
            sql.append("left join T_ORG_Structure s on s.FID = b.FUnionID \n");
            sql.append("left join T_ORG_BaseUnit u on u.FID = s.FUnitID \n");
        } else {
            sql.append("left join T_ORG_Company c on c.FID = b.FCompanyID \n");
        }
        sql.append("left join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
        sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
        sql.append("left join T_BD_MeasureUnit mu on mu.FID = b.FMeasureUnitID \n");
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            if (this.showBizCode) {
                sql.append("left join T_BD_BizAnaylysisCode aat1 on aat1.FID = b.FAsstActID1 \n");
                break;
            }
            aat = this.asstActTypes.get(i);
            sql.append("left join " + aat.getRealtionDataObject() + " aat" + (i + 1) + " on aat" + (i + 1) + ".FID = b.FAsstActID" + (i + 1) + " \n");
            if (i == this.groupIdx) {
                sql.append("left join " + aat.getGroupTableName() + " g on g.FID = b.FGroupID \n");
                continue;
            }
            if (!aat.isIsMultilevel() || aat.getGroupTableName() == null) continue;
            sql.append("left join " + aat.getGroupTableName() + " g" + (i + 1) + " on g" + (i + 1) + ".FID = aat" + (i + 1) + "." + aat.getGroupMappingFieldName() + " \n");
        }
        sql.append("where KSQL_SEQ >= ? and KSQL_SEQ < ? \n");
        sql.append("order by KSQL_SEQ \n");
        return sql.toString();
    }

    @Override
    protected List<String> buildRow(ResultSet rowset, Object cache) throws SQLException {
        String companyNumber;
        ArrayList<String> data = new ArrayList<String>();
        boolean isTotalRow = false;
        if (this.showSumRow) {
            isTotalRow = rowset.getInt("FIsTotal") == 1;
        }
        for (int i = 0; i < this.asstActTypes.size(); ++i) {
            AsstActTypeInfo aat = this.asstActTypes.get(i);
            if (this.showAsstActId) {
                data.add(isTotalRow ? "" : rowset.getString("FAsstActID" + (i + 1)));
            }
            if (this.showAsstActNumber) {
                data.add(isTotalRow ? "" : rowset.getString("FAsstActNumber" + (i + 1)));
            }
            if (this.showAsstActLongNumber) {
                if (aat.isIsMultilevel()) {
                    data.add(isTotalRow ? "" : rowset.getString("FAsstActLongNumber" + (i + 1)));
                } else {
                    data.add(isTotalRow ? "" : rowset.getString("FAsstActNumber" + (i + 1)));
                }
            }
            if (this.showAsstActLevel) {
                if (aat.isIsMultilevel()) {
                    data.add(isTotalRow ? "" : rowset.getString("FAsstActLevel" + (i + 1)));
                } else {
                    data.add(isTotalRow ? "" : "0");
                }
            }
            if (this.showAsstActName) {
                String asstActName = isTotalRow ? "" : rowset.getString("FAsstActName" + (i + 1));
                data.add(asstActName == null ? "" : asstActName);
            }
            if (!this.showAsstActLongName) continue;
            if (aat.isIsMultilevel()) {
                data.add(isTotalRow ? "" : rowset.getString("FAsstActLongName" + (i + 1)));
                continue;
            }
            data.add(isTotalRow ? "" : rowset.getString("FAsstActName" + (i + 1)));
        }
        data.add(isTotalRow ? "" : rowset.getString("FAccountNumber"));
        if (this.showAccountName) {
            data.add(isTotalRow ? "" : rowset.getString("FAccountName"));
        }
        if (this.showAccountLongName) {
            data.add(isTotalRow ? "" : rowset.getString("FAccountLongName"));
        }
        if (this.showAccountLevel) {
            data.add(isTotalRow ? "" : rowset.getString("FAccountLevel"));
        }
        if (this.showAccountDc) {
            data.add(isTotalRow ? "1" : rowset.getString("FAccountDc"));
        }
        if (this.showCurrencyNumber) {
            String currencyNumber = rowset.getString("FCurrencyNumber");
            data.add(currencyNumber == null ? "" : currencyNumber);
        }
        if (this.showCurrencyName) {
            String currencyName = rowset.getString("FCurrencyName");
            data.add(currencyName == null ? "" : currencyName);
        }
        data.add((companyNumber = rowset.getString("FCompanyNumber")) == null ? "" : companyNumber);
        if (this.showCompanyLongNumber) {
            data.add(companyNumber == null ? "" : rowset.getString("FCompanyLongNumber"));
        }
        if (this.showCompanyName) {
            data.add(companyNumber == null ? "" : rowset.getString("FCompanyName"));
        }
        if (this.showCompanyLevel) {
            data.add(companyNumber == null ? "" : rowset.getString("FCompanyLevel"));
        }
        if (this.showCompanyBizUnit) {
            data.add(companyNumber == null ? "" : String.valueOf(rowset.getInt("FIsBizUnit")));
        }
        if (this.showFor) {
            this.buildData(rowset, data, "For");
            data.add(String.valueOf(this.getCurrencyPrecision(this.ctx, rowset.getString("FCurrencyID"))));
        }
        if (this.showLocal) {
            this.buildData(rowset, data, "Local");
            data.add(this.localPrecision);
        }
        if (this.showRpt) {
            this.buildData(rowset, data, "Rpt");
            data.add(this.rptPrecision);
        }
        if (this.showQty) {
            String unitName = rowset.getString("FMeasureUnitName");
            data.add(unitName == null ? "" : unitName);
            this.buildData(rowset, data, "Qty");
            data.add(String.valueOf(this.getQtyPrecision(this.ctx, this.companyTopId)));
        }
        if (this.showSumRow) {
            data.add(isTotalRow ? "1" : "0");
        }
        return data;
    }

    protected void buildData(ResultSet rowset, List<String> data, String type) throws SQLException {
        BigDecimal yearCredit;
        BigDecimal yearDebit;
        BigDecimal endBalance = rowset.getBigDecimal(("Qty".equals(type) ? "FEnd" : "FEndBalance") + type);
        if (endBalance == null) {
            endBalance = GlUtils.zero;
        }
        if ((yearDebit = rowset.getBigDecimal("FYearDebit" + type)) == null) {
            yearDebit = GlUtils.zero;
        }
        if ((yearCredit = rowset.getBigDecimal("FYearCredit" + type)) == null) {
            yearCredit = GlUtils.zero;
        }
        if (this.showYear) {
            if (this.showByDispatchDc) {
                BigDecimal yearBeginDebit = rowset.getBigDecimal(("Qty".equals(type) ? "FYearBeginDebit" : "FYearBeginBalanceDebit") + type);
                BigDecimal yearBeginCredit = rowset.getBigDecimal(("Qty".equals(type) ? "FYearBeginCredit" : "FYearBeginBalanceCredit") + type);
                data.add(yearBeginDebit == null ? "0" : String.valueOf(yearBeginDebit));
                data.add(yearBeginCredit == null ? "0" : String.valueOf(yearBeginCredit));
            } else if (this.notIncludePLVoucher) {
                BigDecimal yearBegin = rowset.getBigDecimal(("Qty".equals(type) ? "FYearBegin" : "FYearBeginBalance") + type);
                data.add(yearBegin == null ? "0" : String.valueOf(yearBegin));
            } else {
                data.add(String.valueOf(endBalance.subtract(yearDebit).add(yearCredit)));
            }
        }
        if (this.showByDispatchDc) {
            BigDecimal beginDebit = rowset.getBigDecimal(("Qty".equals(type) ? "FBeginDebit" : "FBeginBalanceDebit") + type);
            BigDecimal beginCredit = rowset.getBigDecimal(("Qty".equals(type) ? "FBeginCredit" : "FBeginBalanceCredit") + type);
            data.add(beginDebit == null ? "0" : String.valueOf(beginDebit));
            data.add(beginCredit == null ? "0" : String.valueOf(beginCredit));
        } else {
            BigDecimal begin = rowset.getBigDecimal(("Qty".equals(type) ? "FBegin" : "FBeginBalance") + type);
            data.add(begin == null ? "0" : String.valueOf(begin));
        }
        BigDecimal debit = rowset.getBigDecimal("FDebit" + type);
        BigDecimal credit = rowset.getBigDecimal("FCredit" + type);
        data.add(debit == null ? "0" : String.valueOf(debit));
        data.add(credit == null ? "0" : String.valueOf(credit));
        if (this.showYear) {
            data.add(String.valueOf(yearDebit));
            data.add(String.valueOf(yearCredit));
        }
        if (this.showByDispatchDc) {
            BigDecimal endDebit = rowset.getBigDecimal(("Qty".equals(type) ? "FEndDebit" : "FEndBalanceDebit") + type);
            BigDecimal endCredit = rowset.getBigDecimal(("Qty".equals(type) ? "FEndCredit" : "FEndBalanceCredit") + type);
            data.add(endDebit == null ? "0" : String.valueOf(endDebit));
            data.add(endCredit == null ? "0" : String.valueOf(endCredit));
        } else {
            data.add(String.valueOf(endBalance));
        }
    }

    @Override
    public Map<String, Object> search(Context ctx, Map params) throws BOSException, SQLException {
        AsstActTypeInfo aat;
        int i;
        ArrayList rows = new ArrayList();
        this.result.put("rows", rows);
        String word = (String)params.get("word");
        if (word == null || word.length() == 0) {
            return this.result;
        }
        boolean mistiness = true;
        if ("false".equalsIgnoreCase((String)params.get("mistiness"))) {
            mistiness = false;
        }
        boolean caseSensitive = true;
        if ("false".equalsIgnoreCase((String)params.get("caseSensitive"))) {
            caseSensitive = false;
        }
        if (!caseSensitive) {
            word = word.toLowerCase(Locale.getDefault());
        }
        BigDecimal bdWord = null;
        try {
            bdWord = new BigDecimal(word);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean previous = "previous".equalsIgnoreCase((String)params.get("action"));
        boolean wrapSearch = "true".equalsIgnoreCase((String)params.get("wrapSearch"));
        int rowIndex = 0;
        Object param = params.get("rowIndex");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                int i2 = Integer.parseInt(param.toString().trim());
                if (i2 >= 0) {
                    rowIndex = i2;
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
        }
        ++rowIndex;
        int columIndex = -1;
        param = params.get("columIndex");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                columIndex = Integer.parseInt(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (columIndex < 0) {
            columIndex = previous ? 0 : -1;
        }
        final HashMap<String, Integer> targetIndexs = new HashMap<String, Integer>();
        ArrayList<String> targets = new ArrayList<String>();
        Map sourceIndexs = (Map)params.get("targetIndexs");
        if (sourceIndexs == null || sourceIndexs.size() == 0) {
            this.errs.add(this.getResource("SelectSearchColumn"));
            return this.result;
        }
        for (Object target : sourceIndexs.keySet()) {
            param = sourceIndexs.get(target);
            Integer targetIndex = null;
            if (param instanceof Integer) {
                targetIndex = (Integer)param;
            } else if (param instanceof String) {
                try {
                    targetIndex = Integer.parseInt((String)param);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String name = (String)target;
            if (targetIndex == null || targetIndex < 0) continue;
            if (name.startsWith("asstActNumber") || name.startsWith("asstActName") || name.startsWith("asstActLongNumber") || name.startsWith("asstActLongName")) {
                try {
                    int asstActIndex = Integer.parseInt(name.substring(name.length() - 1));
                    if (asstActIndex < 1 || asstActIndex > this.asstActTypes.size()) continue;
                    targetIndexs.put(name, targetIndex);
                    targets.add(name);
                }
                catch (Exception asstActIndex) {}
                continue;
            }
            targetIndexs.put(name, targetIndex);
            targets.add(name);
        }
        if (targetIndexs.size() == 0) {
            this.errs.add(this.getResource("ColumnNotSupportBackSearch"));
            return this.result;
        }
        Collections.sort(targets, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = (Integer)targetIndexs.get(o1);
                int i2 = (Integer)targetIndexs.get(o2);
                return i1 - i2;
            }
        });
        StringBuffer sql = new StringBuffer();
        ArrayList<String> searchParams = new ArrayList<String>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String csStart = "    ";
        String csEnd = "";
        if (!caseSensitive) {
            csStart = "    lower(";
            csEnd = ")";
        }
        sql.append("select /*+ LEADING(b) */ top 2 \n");
        if (targets.contains("companyNumber")) {
            if (this.sumByUnion) {
                sql.append(csStart + "u.FNumber" + csEnd + " FCompanyNumber, \n");
            } else {
                sql.append(csStart + "c.FNumber" + csEnd + " FCompanyNumber, \n");
            }
        }
        if (targets.contains("companyLongNumber")) {
            if (this.sumByUnion) {
                sql.append(csStart + "s.FLongNumber" + csEnd + " FCompanyLongNumber, \n");
            } else {
                sql.append(csStart + "c.FLongNumber" + csEnd + " FCompanyLongNumber, \n");
            }
        }
        if (targets.contains("companyName")) {
            if (this.sumByUnion) {
                sql.append(csStart + "u.FName_" + loc + csEnd + " FCompanyName, \n");
            } else {
                sql.append(csStart + "c.FName_" + loc + csEnd + " FCompanyName, \n");
            }
        }
        if (targets.contains("accountNumber")) {
            sql.append(csStart + "av.FNumber" + csEnd + " FAccountNumber, \n");
        }
        if (targets.contains("accountName")) {
            sql.append(csStart + "av.FName_" + loc + csEnd + " FAccountName, \n");
        }
        if (targets.contains("accountLongName")) {
            sql.append(csStart + "av.FDisplayName_" + loc + csEnd + " FAccountLongName, \n");
        }
        if (targets.contains("currencyNumber")) {
            sql.append(csStart + "cy.FNumber" + csEnd + " FCurrencyNumber, \n");
        }
        if (targets.contains("currencyName")) {
            sql.append(csStart + "cy.FName_" + loc + csEnd + " FCurrencyName, \n");
        }
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            aat = this.asstActTypes.get(i);
            if (targetIndexs.containsKey("asstActNumber" + (i + 1))) {
                if (i == this.groupIdx) {
                    sql.append(csStart + "case when b.FAsstActID" + (i + 1) + " is not null then aat" + (i + 1) + ".FNumber else g.FNumber end" + csEnd + " FAsstActNumber" + (i + 1) + ", \n");
                } else {
                    sql.append(csStart + "aat" + (i + 1) + ".FNumber" + csEnd + " FAsstActNumber" + (i + 1) + ", \n");
                }
            }
            if (targetIndexs.containsKey("asstActLongNumber" + (i + 1))) {
                if (i == this.groupIdx) {
                    sql.append(csStart + "case when b.FAsstActID" + (i + 1) + " is not null then g.FLongNumber || '!' || aat" + (i + 1) + ".FNumber else g.FLongNumber end" + csEnd + " FAsstActLongNumber" + (i + 1) + ", \n");
                } else if (aat.isIsMultilevel()) {
                    if (aat.getGroupTableName() != null) {
                        sql.append(csStart + "case when b.FAsstActID" + (i + 1) + " is not null then g" + (i + 1) + ".FLongNumber || '!' || aat" + (i + 1) + ".FNumber else null end" + csEnd + " FAsstActLongNumber" + (i + 1) + ", \n");
                    } else {
                        sql.append(csStart + "aat" + (i + 1) + ".FLongNumber" + csEnd + " FAsstActLongNumber" + (i + 1) + ", \n");
                    }
                } else {
                    sql.append(csStart + "aat" + (i + 1) + ".FNumber" + csEnd + " FAsstActLongNumber" + (i + 1) + ", \n");
                }
            }
            if (targetIndexs.containsKey("asstActName" + (i + 1))) {
                if (i == this.groupIdx) {
                    sql.append(csStart + "case when b.FAsstActID" + (i + 1) + " is not null then aat" + (i + 1) + ".FName_" + loc + " else g.FName_" + loc + " end" + csEnd + " FAsstActName" + (i + 1) + ", \n");
                } else {
                    sql.append(csStart + "aat" + (i + 1) + ".FName_" + loc + csEnd + " FAsstActName" + (i + 1) + ", \n");
                }
            }
            if (!targetIndexs.containsKey("asstActLongName" + (i + 1))) continue;
            if (i == this.groupIdx) {
                sql.append(csStart + "case when b.FAsstActID" + (i + 1) + " is not null then g.FDisplayName_" + loc + " || '_' || aat" + (i + 1) + ".FName_" + loc + " else g.FDisplayName_" + loc + " end" + csEnd + " FAsstActLongName" + (i + 1) + ", \n");
                continue;
            }
            if (aat.isIsMultilevel()) {
                if (aat.getGroupTableName() != null) {
                    sql.append(csStart + "case when b.FAsstActID" + (i + 1) + " is not null then g" + (i + 1) + ".FDisplayName_" + loc + " || '_' || aat" + (i + 1) + ".FName_" + loc + " else null end" + csEnd + " FAsstActLongName" + (i + 1) + ", \n");
                    continue;
                }
                sql.append(csStart + "aat" + (i + 1) + ".FDisplayName_" + loc + csEnd + " FAsstActLongName" + (i + 1) + ", \n");
                continue;
            }
            sql.append(csStart + "aat" + (i + 1) + ".FName_" + loc + csEnd + " FAsstActLongName" + (i + 1) + ", \n");
        }
        sql.append("    b.KSQL_SEQ \n");
        sql.append("from " + params.get("pageId") + " b \n");
        if (this.sumByUnion) {
            sql.append("left join T_ORG_Structure s on s.FID = b.FUnionID \n");
            sql.append("left join T_ORG_BaseUnit u on u.FID = s.FUnitID \n");
        } else {
            sql.append("left join T_ORG_Company c on c.FID = b.FCompanyID \n");
        }
        sql.append("left join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
        sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            if (!targetIndexs.containsKey("asstActNumber" + (i + 1)) && !targetIndexs.containsKey("asstActName" + (i + 1)) && !targetIndexs.containsKey("asstActLongNumber" + (i + 1)) && !targetIndexs.containsKey("asstActLongName" + (i + 1))) continue;
            aat = this.asstActTypes.get(i);
            sql.append("left join " + aat.getRealtionDataObject() + " aat" + (i + 1) + " on aat" + (i + 1) + ".FID = b.FAsstActID" + (i + 1) + " \n");
            if (i == this.groupIdx) {
                sql.append("left join " + aat.getGroupTableName() + " g on g.FID = b.FGroupID \n");
                continue;
            }
            if (!aat.isIsMultilevel() || aat.getGroupTableName() == null) continue;
            sql.append("left join " + aat.getGroupTableName() + " g" + (i + 1) + " on g" + (i + 1) + ".FID = aat" + (i + 1) + "." + aat.getGroupMappingFieldName() + " \n");
        }
        csStart = "";
        csEnd = "";
        if (!caseSensitive) {
            csStart = "lower(";
            csEnd = ")";
        }
        String compare = mistiness ? " like ? \n" : " = ? \n";
        String compareValue = mistiness ? "%" + word + "%" : word;
        StringBuffer where = new StringBuffer();
        if (targets.contains("companyNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "u.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("companyLongNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "s.FLongNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FLongNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("companyName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "u.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("accountNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("accountName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("accountLongName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FDisplayName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("currencyNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cy.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("currencyName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cy.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        for (int i3 = 0; i3 < this.asstActTypes.size(); ++i3) {
            AsstActTypeInfo aat2 = this.asstActTypes.get(i3);
            if (targetIndexs.containsKey("asstActNumber" + (i3 + 1))) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                if (i3 == this.groupIdx) {
                    where.append(csStart + "case when b.FAsstActID" + (i3 + 1) + " is not null then aat" + (i3 + 1) + ".FNumber else g.FNumber end" + csEnd);
                } else {
                    where.append(csStart + "aat" + (i3 + 1) + ".FNumber" + csEnd);
                }
                where.append(compare);
                searchParams.add(compareValue);
            }
            if (targetIndexs.containsKey("asstActLongNumber" + (i3 + 1))) {
                if (i3 == this.groupIdx) {
                    where.append(csStart + "case when b.FAsstActID" + (i3 + 1) + " is not null then g.FLongNumber || '!' || aat" + (i3 + 1) + ".FNumber else g.FLongNumber end" + csEnd);
                } else if (aat2.isIsMultilevel()) {
                    if (aat2.getGroupTableName() != null) {
                        where.append(csStart + "case when b.FAsstActID" + (i3 + 1) + " is not null then g" + (i3 + 1) + ".FLongNumber || '!' || aat" + (i3 + 1) + ".FNumber else null end" + csEnd);
                    } else {
                        where.append(csStart + "aat" + (i3 + 1) + ".FLongNumber" + csEnd);
                    }
                } else {
                    where.append(csStart + "aat" + (i3 + 1) + ".FNumber" + csEnd);
                }
                where.append(compare);
                searchParams.add(compareValue);
            }
            if (targetIndexs.containsKey("asstActName" + (i3 + 1))) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                if (i3 == this.groupIdx) {
                    where.append(csStart + "case when b.FAsstActID" + (i3 + 1) + " is not null then aat" + (i3 + 1) + ".FName_" + loc + " else g.FName_" + loc + " end" + csEnd);
                } else {
                    where.append(csStart + "aat" + (i3 + 1) + ".FName_" + loc + csEnd);
                }
                where.append(compare);
                searchParams.add(compareValue);
            }
            if (!targetIndexs.containsKey("asstActLongName" + (i3 + 1))) continue;
            if (i3 == this.groupIdx) {
                where.append(csStart + "case when b.FAsstActID" + (i3 + 1) + " is not null then g.FDisplayName_" + loc + " || '_' || aat" + (i3 + 1) + ".FName_" + loc + " else g.FDisplayName_" + loc + " end" + csEnd);
            } else if (aat2.isIsMultilevel()) {
                if (aat2.getGroupTableName() != null) {
                    where.append(csStart + "case when b.FAsstActID" + (i3 + 1) + " is not null then g" + (i3 + 1) + ".FDisplayName_" + loc + " || '_' || aat" + (i3 + 1) + ".FName_" + loc + " else null end" + csEnd);
                } else {
                    where.append(csStart + "aat" + (i3 + 1) + ".FDisplayName_" + loc + csEnd);
                }
            } else {
                where.append(csStart + "aat" + (i3 + 1) + ".FName_" + loc + csEnd);
            }
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (where.length() <= 0) {
            this.errs.add(this.getResource("ColumnNotSupportBackSearch"));
            return this.result;
        }
        where.append(") \n");
        if (previous) {
            where.append("order by KSQL_SEQ desc \n");
        } else {
            where.append("order by KSQL_SEQ \n");
        }
        StringBuffer sql1 = new StringBuffer();
        ArrayList<Object> searchParams1 = new ArrayList<Object>();
        sql1.append(sql);
        if (previous) {
            sql1.append("where KSQL_SEQ <= ? \n");
            searchParams1.add(rowIndex);
        } else {
            sql1.append("where KSQL_SEQ >= ? \n");
            searchParams1.add(rowIndex);
        }
        sql1.append("and ( \n" + where);
        searchParams1.addAll(searchParams);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])searchParams1.toArray());
        while (rowset.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int index = rowset.getInt("KSQL_SEQ");
            block15: for (String target : targets) {
                String currencyName;
                String currencyNumber;
                String accountLongName;
                String accountName;
                String accountNumber;
                String companyName;
                String companyLongNumber;
                String companyNumber;
                if (index == rowIndex && (index != rowIndex || (!previous || (Integer)targetIndexs.get(target) >= columIndex) && (previous || (Integer)targetIndexs.get(target) <= columIndex))) continue;
                if (target.equals("companyNumber") && this.isMatch(word, bdWord, companyNumber = rowset.getString("FCompanyNumber"), mistiness)) {
                    row.put("name", "companyNumber");
                    row.put("value", companyNumber);
                    break;
                }
                if (target.equals("companyLongNumber") && this.isMatch(word, bdWord, companyLongNumber = rowset.getString("FCompanyLongNumber"), mistiness)) {
                    row.put("name", "companyLongNumber");
                    row.put("value", companyLongNumber);
                    break;
                }
                if (target.equals("companyName") && this.isMatch(word, bdWord, companyName = rowset.getString("FCompanyName"), mistiness)) {
                    row.put("name", "companyName");
                    row.put("value", companyName);
                    break;
                }
                if (target.equals("accountNumber") && this.isMatch(word, bdWord, accountNumber = rowset.getString("FAccountNumber"), mistiness)) {
                    row.put("name", "accountNumber");
                    row.put("value", accountNumber);
                    break;
                }
                if (target.equals("accountName") && this.isMatch(word, bdWord, accountName = rowset.getString("FAccountName"), mistiness)) {
                    row.put("name", "accountName");
                    row.put("value", accountName);
                    break;
                }
                if (target.equals("accountLongName") && this.isMatch(word, bdWord, accountLongName = rowset.getString("FAccountLongName"), mistiness)) {
                    row.put("name", "accountLongName");
                    row.put("value", accountLongName);
                    break;
                }
                if (target.equals("currencyNumber") && this.isMatch(word, bdWord, currencyNumber = rowset.getString("FCurrencyNumber"), mistiness)) {
                    row.put("name", "currencyNumber");
                    row.put("value", currencyNumber);
                    break;
                }
                if (target.equals("currencyName") && this.isMatch(word, bdWord, currencyName = rowset.getString("FCurrencyName"), mistiness)) {
                    row.put("name", "currencyName");
                    row.put("value", currencyName);
                    break;
                }
                for (int i4 = 0; i4 < this.asstActTypes.size(); ++i4) {
                    String asstActLongName;
                    String asstActName;
                    String asstActLongNumber;
                    String asstActNumber;
                    if (targetIndexs.containsKey("asstActNumber" + (i4 + 1)) && this.isMatch(word, bdWord, asstActNumber = rowset.getString("FAsstActNumber" + (i4 + 1)), mistiness)) {
                        row.put("name", "asstActNumber" + (i4 + 1));
                        row.put("value", asstActNumber);
                        continue block15;
                    }
                    if (targetIndexs.containsKey("asstActLongNumber" + (i4 + 1)) && this.isMatch(word, bdWord, asstActLongNumber = rowset.getString("FAsstActLongNumber" + (i4 + 1)), mistiness)) {
                        row.put("name", "asstActLongNumber" + (i4 + 1));
                        row.put("value", asstActLongNumber);
                        continue block15;
                    }
                    if (targetIndexs.containsKey("asstActName" + (i4 + 1)) && this.isMatch(word, bdWord, asstActName = rowset.getString("FAsstActName" + (i4 + 1)), mistiness)) {
                        row.put("name", "asstActName" + (i4 + 1));
                        row.put("value", asstActName);
                        continue block15;
                    }
                    if (!targetIndexs.containsKey("asstActLongName" + (i4 + 1)) || !this.isMatch(word, bdWord, asstActLongName = rowset.getString("FAsstActLongName" + (i4 + 1)), mistiness)) continue;
                    row.put("name", "asstActLongName" + (i4 + 1));
                    row.put("value", asstActLongName);
                    continue block15;
                }
            }
            if (!row.containsKey("name")) continue;
            row.put("index", index);
            rows.add(row);
            return this.result;
        }
        if (!wrapSearch) {
            return this.result;
        }
        StringBuffer sql2 = new StringBuffer();
        ArrayList<Object> searchParams2 = new ArrayList<Object>();
        sql2.append(sql);
        if (previous) {
            sql2.append("where KSQL_SEQ >= ? \n");
            searchParams2.add(rowIndex);
        } else {
            sql2.append("where KSQL_SEQ <= ? \n");
            searchParams2.add(rowIndex);
        }
        sql2.append("and ( \n" + where);
        searchParams2.addAll(searchParams);
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])searchParams1.toArray());
        while (rowset.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int index = rowset.getInt("KSQL_SEQ");
            block18: for (String target : targets) {
                String currencyName;
                String currencyNumber;
                String accountLongName;
                String accountName;
                String accountNumber;
                String companyName;
                String companyLongNumber;
                String companyNumber;
                if (index == rowIndex && (index != rowIndex || (!previous || (Integer)targetIndexs.get(target) < columIndex) && (previous || (Integer)targetIndexs.get(target) > columIndex))) continue;
                if (target.equals("companyNumber") && this.isMatch(word, bdWord, companyNumber = rowset.getString("FCompanyNumber"), mistiness)) {
                    row.put("name", "companyNumber");
                    row.put("value", companyNumber);
                    break;
                }
                if (target.equals("companyLongNumber") && this.isMatch(word, bdWord, companyLongNumber = rowset.getString("FCompanyLongNumber"), mistiness)) {
                    row.put("name", "companyLongNumber");
                    row.put("value", companyLongNumber);
                    break;
                }
                if (target.equals("companyName") && this.isMatch(word, bdWord, companyName = rowset.getString("FCompanyName"), mistiness)) {
                    row.put("name", "companyName");
                    row.put("value", companyName);
                    break;
                }
                if (target.equals("accountNumber") && this.isMatch(word, bdWord, accountNumber = rowset.getString("FAccountNumber"), mistiness)) {
                    row.put("name", "accountNumber");
                    row.put("value", accountNumber);
                    break;
                }
                if (target.equals("accountName") && this.isMatch(word, bdWord, accountName = rowset.getString("FAccountName"), mistiness)) {
                    row.put("name", "accountName");
                    row.put("value", accountName);
                    break;
                }
                if (target.equals("accountLongName") && this.isMatch(word, bdWord, accountLongName = rowset.getString("FAccountLongName"), mistiness)) {
                    row.put("name", "accountLongName");
                    row.put("value", accountLongName);
                    break;
                }
                if (target.equals("currencyNumber") && this.isMatch(word, bdWord, currencyNumber = rowset.getString("FCurrencyNumber"), mistiness)) {
                    row.put("name", "currencyNumber");
                    row.put("value", currencyNumber);
                    break;
                }
                if (target.equals("currencyName") && this.isMatch(word, bdWord, currencyName = rowset.getString("FCurrencyName"), mistiness)) {
                    row.put("name", "currencyName");
                    row.put("value", currencyName);
                    break;
                }
                for (int i5 = 0; i5 < this.asstActTypes.size(); ++i5) {
                    String asstActLongName;
                    String asstActName;
                    String asstActLongNumber;
                    String asstActNumber;
                    if (targetIndexs.containsKey("asstActNumber" + (i5 + 1)) && this.isMatch(word, bdWord, asstActNumber = rowset.getString("FAsstActNumber" + (i5 + 1)), mistiness)) {
                        row.put("name", "asstActNumber" + (i5 + 1));
                        row.put("value", asstActNumber);
                        continue block18;
                    }
                    if (targetIndexs.containsKey("asstActLongNumber" + (i5 + 1)) && this.isMatch(word, bdWord, asstActLongNumber = rowset.getString("FAsstActLongNumber" + (i5 + 1)), mistiness)) {
                        row.put("name", "asstActLongNumber" + (i5 + 1));
                        row.put("value", asstActLongNumber);
                        continue block18;
                    }
                    if (targetIndexs.containsKey("asstActName" + (i5 + 1)) && this.isMatch(word, bdWord, asstActName = rowset.getString("FAsstActName" + (i5 + 1)), mistiness)) {
                        row.put("name", "asstActName" + (i5 + 1));
                        row.put("value", asstActName);
                        continue block18;
                    }
                    if (!targetIndexs.containsKey("asstActLongName" + (i5 + 1)) || !this.isMatch(word, bdWord, asstActLongName = rowset.getString("FAsstActLongName" + (i5 + 1)), mistiness)) continue;
                    row.put("name", "asstActLongName" + (i5 + 1));
                    row.put("value", asstActLongName);
                    continue block18;
                }
            }
            if (!row.containsKey("name")) continue;
            row.put("index", index);
            rows.add(row);
            return this.result;
        }
        return this.result;
    }

    protected boolean isMatch(String word, BigDecimal bdWord, Object value, boolean mistiness) {
        if (value != null) {
            String v;
            if (value instanceof BigDecimal) {
                if (bdWord != null && bdWord.compareTo((BigDecimal)value) == 0) {
                    return true;
                }
                v = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                if (v.equals(word)) {
                    return true;
                }
            }
            v = value.toString();
            if (mistiness && v.contains(word) || !mistiness && v.equals(word)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAssMatch(String word, String value, boolean mistiness) {
        if (value != null) {
            String str;
            String v = value.toString();
            if (mistiness) {
                return v.contains(word);
            }
            int index = v.indexOf(":");
            if (index > 0 && (index = (str = v.substring(index + 1)).indexOf(" ")) > 0 && (str.substring(0, index).equals(word) || str.substring(index + 1).equals(word))) {
                return true;
            }
            return v.equals(word);
        }
        return false;
    }

    protected int getQtyPrecision(Context ctx, String companyId) {
        if (this.qtyPrecisions.containsKey(companyId)) {
            return this.qtyPrecisions.get(companyId);
        }
        int qtyPrecision = 4;
        try {
            int i;
            HashMap<String, String> in = new HashMap<String, String>();
            in.put("GL_002", companyId);
            HashMap out = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(in);
            if (out.get("GL_002") != null && (i = Integer.parseInt(out.get("GL_002").toString())) >= 0) {
                qtyPrecision = i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.qtyPrecisions.put(companyId, qtyPrecision);
        return qtyPrecision;
    }
}

