/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptBasePage;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class GLNRptAsstactGDPage
extends GLNRptBasePage {
    private DateFormat DF = new SimpleDateFormat("yyyy-MM-dd");
    protected boolean showVoucherId = false;
    protected boolean showAsstActNumber = false;
    protected boolean showAsstActLongNumber = false;
    protected boolean showAsstActLongName = false;
    protected List<AsstActTypeInfo> asstActTypes = null;
    protected boolean sumByUnion = false;
    protected String localPrecision = "";
    protected String rptPrecision = "";

    @Override
    protected void init() {
        super.init();
        Object param = this.params.get("showVoucherId");
        this.showVoucherId = param != null && "true".equals(param.toString());
        param = this.params.get("showAsstActNumber");
        this.showAsstActNumber = param != null && "true".equals(param.toString());
        param = this.params.get("showAsstActLongNumber");
        this.showAsstActLongNumber = param != null && "true".equals(param.toString());
        param = this.params.get("showAsstActLongName");
        this.showAsstActLongName = param != null && "true".equals(param.toString());
        this.asstActTypes = (List)this.params.get("asstActTypes");
        this.localPrecision = (String)this.params.get("localPrecision");
        this.rptPrecision = (String)this.params.get("rptPrecision");
    }

    @Override
    protected String getPageSql() {
        AsstActTypeInfo aat;
        int i;
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select \n");
        sql.append(" /*+ LEADING(b) */ \n");
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            aat = this.asstActTypes.get(i);
            if (aat.isIsMultilevel()) {
                if (this.showAsstActNumber) {
                    sql.append(" aat").append(i + 1).append(".FNumber FAsstActNumber").append(i + 1).append(", \n");
                }
                if (aat.getGroupTableName() != null) {
                    if (this.showAsstActLongNumber) {
                        sql.append(" case when b.FAsstActID").append(i + 1).append(" is not null then g").append(i + 1).append(".FLongNumber || '!' || aat").append(i + 1).append(".FNumber else null end FAsstActLongNumber").append(i + 1).append(", \n");
                    }
                    if (this.showAsstActLongName) {
                        sql.append(" case when b.FAsstActID").append(i + 1).append(" is not null then g").append(i + 1).append(".FDisplayName_").append(loc).append(" || '_' || aat").append(i + 1).append(".FName_").append(loc).append(" else null end FAsstActLongName").append(i + 1).append(", \n");
                    }
                } else {
                    if (this.showAsstActLongNumber) {
                        sql.append(" aat").append(i + 1).append(".FLongNumber FAsstActLongNumber").append(i + 1).append(", \n");
                    }
                    if (this.showAsstActLongName) {
                        sql.append(" aat").append(i + 1).append(".FDisplayName_").append(loc).append(" FAsstActLongName").append(i + 1).append(", \n");
                    }
                }
            } else if (this.showAsstActNumber || this.showAsstActLongNumber) {
                sql.append(" aat").append(i + 1).append(".FNumber FAsstActNumber").append(i + 1).append(", \n");
            }
            sql.append(" aat").append(i + 1).append(".FName_").append(loc).append(" FAsstActName").append(i + 1).append(", \n");
        }
        sql.append(" b.FAccountNumber, \n");
        if (this.showAccountName) {
            sql.append(" av.FName_").append(loc).append(" FAccountName, \n");
        }
        if (this.showAccountLongName) {
            sql.append(" av.FDisplayName_").append(loc).append(" FAccountLongName, \n");
        }
        if (this.showAccountDc) {
            sql.append(" av.FDC FAccountDc, \n");
        }
        sql.append(" b.FPeriod, \n");
        sql.append(" v.FBookedDate, \n");
        sql.append(" vr.FBizDate, \n");
        sql.append(" c.FNumber FCompanyNumber, \n");
        if (this.showCompanyLongNumber) {
            sql.append(" c.FLongNumber FCompanyLongNumber, \n");
        }
        if (this.showCompanyName) {
            sql.append(" c.FName_").append(loc).append(" FCompanyName, \n");
        }
        if (this.showCompanyLevel) {
            sql.append(" c.FLevel FCompanyLevel, \n");
        }
        if (this.showCompanyBizUnit) {
            sql.append(" c.FIsBizUnit, \n");
        }
        if (this.showVoucherId) {
            sql.append(" b.FVoucherID, \n");
        }
        sql.append(" vt.FName_").append(loc).append(" FVoucherType, \n");
        sql.append(" v.FNumber FVoucherNumber, \n");
        sql.append(" vr.FDescription, \n");
        sql.append(" u.FName_").append(loc).append(" FCreatorName, \n");
        sql.append(" b.FEntrySeq, \n");
        sql.append(" cy.FID FCurrencyID, \n");
        if (this.showCurrencyNumber) {
            sql.append(" cy.FNumber FCurrencyNumber, \n");
        }
        if (this.showCurrencyName) {
            sql.append(" cy.FName_").append(loc).append(" FCurrencyName, \n");
        }
        sql.append(" b.FRecordSeq, \n");
        if (this.showFor) {
            sql.append("    FDebitFor, \n");
            sql.append("    FCreditFor, \n");
            sql.append("    FEndBalanceFor, \n");
        }
        if (this.showLocal) {
            sql.append("    FDebitLocal, \n");
            sql.append("    FCreditLocal, \n");
            sql.append("    FEndBalanceLocal, \n");
        }
        if (this.showRpt) {
            sql.append("    FDebitRpt, \n");
            sql.append("    FCreditRpt, \n");
            sql.append("    FEndBalanceRpt, \n");
        }
        if (this.showQty) {
            sql.append("    mu.FName_").append(loc).append(" FMeasureUnitName, \n");
            sql.append("    FDebitQty, \n");
            sql.append("    FCreditQty, \n");
            sql.append("    FEndQty, \n");
        }
        sql.append("    b.FType \n");
        sql.append("from ").append(this.params.get("pageId")).append(" b \n");
        sql.append("left join T_GL_Voucher v on v.FID = b.FVoucherID \n");
        sql.append("left join T_GL_VoucherAssistRecord vr on vr.FID = b.FRecordID \n");
        sql.append("left join T_BD_VoucherTypes vt on vt.FID = v.FVoucherTypeID \n");
        sql.append("left join T_PM_User u on u.FID = v.FCreatorID \n");
        sql.append("left join T_ORG_Company c on c.FID = b.FCompanyID \n");
        sql.append("left join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
        sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
        if (this.showQty) {
            sql.append("left join T_BD_MeasureUnit mu on mu.FID = b.FMeasureUnitID \n");
        }
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            aat = this.asstActTypes.get(i);
            sql.append("left join ").append(aat.getRealtionDataObject()).append(" aat").append(i + 1).append(" on aat").append(i + 1).append(".FID = b.FAsstActID").append(i + 1).append(" \n");
            if (!aat.isIsMultilevel() || aat.getGroupTableName() == null || !this.showAsstActLongNumber && !this.showAsstActLongName) continue;
            sql.append("left join ").append(aat.getGroupTableName()).append(" g").append(i + 1).append(" on g").append(i + 1).append(".FID = aat").append(i + 1).append(".").append(aat.getGroupMappingFieldName()).append(" \n");
        }
        sql.append("where FRowIndex >= ? and FRowIndex < ? \n");
        sql.append("order by FRowIndex \n");
        return sql.toString();
    }

    @Override
    protected List<String> buildRow(ResultSet rowset, Object cache) throws SQLException {
        int type;
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < this.asstActTypes.size(); ++i) {
            AsstActTypeInfo aat = this.asstActTypes.get(i);
            if (this.showAsstActNumber) {
                row.add(rowset.getString("FAsstActNumber" + (i + 1)));
            }
            if (this.showAsstActLongNumber) {
                if (aat.isIsMultilevel()) {
                    row.add(rowset.getString("FAsstActLongNumber" + (i + 1)));
                } else {
                    row.add(rowset.getString("FAsstActNumber" + (i + 1)));
                }
            }
            row.add(rowset.getString("FAsstActName" + (i + 1)));
            if (!this.showAsstActLongName) continue;
            if (aat.isIsMultilevel()) {
                row.add(rowset.getString("FAsstActLongName" + (i + 1)));
                continue;
            }
            row.add(rowset.getString("FAsstActName" + (i + 1)));
        }
        row.add(rowset.getString("FAccountNumber"));
        if (this.showAccountName) {
            row.add(rowset.getString("FAccountName"));
        }
        if (this.showAccountLongName) {
            row.add(rowset.getString("FAccountLongName"));
        }
        if (this.showAccountDc) {
            row.add(rowset.getString("FAccountDc"));
        }
        if ((type = rowset.getInt("FType")) == 2) {
            Date bookedDate = rowset.getDate("FBookedDate");
            row.add(bookedDate != null ? this.DF.format(bookedDate) : "");
        } else {
            row.add(String.valueOf(type));
        }
        Date bizDate = rowset.getDate("FBizDate");
        row.add(bizDate != null ? this.DF.format(bizDate) : "");
        if (type == 2) {
            row.add(rowset.getString("FPeriod"));
        } else {
            row.add(null);
        }
        row.add(rowset.getString("FCompanyNumber"));
        if (this.showCompanyLongNumber) {
            row.add(rowset.getString("FCompanyLongNumber"));
        }
        if (this.showCompanyName) {
            row.add(rowset.getString("FCompanyName"));
        }
        if (this.showCompanyLevel) {
            row.add(rowset.getString("FCompanyLevel"));
        }
        if (this.showCompanyBizUnit) {
            row.add(String.valueOf(rowset.getInt("FIsBizUnit")));
        }
        if (this.showVoucherId) {
            row.add(rowset.getString("FVoucherID"));
        }
        row.add(rowset.getString("FVoucherType"));
        row.add(rowset.getString("FVoucherNumber"));
        row.add(rowset.getString("FDescription"));
        row.add(rowset.getString("FCreatorName"));
        if (this.showCurrencyNumber) {
            row.add(rowset.getString("FCurrencyNumber"));
        }
        if (this.showCurrencyName) {
            row.add(rowset.getString("FCurrencyName"));
        }
        if (this.showFor) {
            row.add(String.valueOf(rowset.getBigDecimal("FDebitFor")));
            row.add(String.valueOf(rowset.getBigDecimal("FCreditFor")));
            row.add(String.valueOf(rowset.getBigDecimal("FEndBalanceFor")));
            row.add(String.valueOf(this.getCurrencyPrecision(this.ctx, rowset.getString("FCurrencyID"))));
        }
        if (this.showLocal) {
            row.add(String.valueOf(rowset.getBigDecimal("FDebitLocal")));
            row.add(String.valueOf(rowset.getBigDecimal("FCreditLocal")));
            row.add(String.valueOf(rowset.getBigDecimal("FEndBalanceLocal")));
            row.add(this.localPrecision);
        }
        if (this.showRpt) {
            row.add(String.valueOf(rowset.getBigDecimal("FDebitRpt")));
            row.add(String.valueOf(rowset.getBigDecimal("FCreditRpt")));
            row.add(String.valueOf(rowset.getBigDecimal("FEndBalanceRpt")));
            row.add(this.rptPrecision);
        }
        if (this.showQty) {
            row.add(rowset.getString("FMeasureUnitName"));
            row.add(String.valueOf(rowset.getBigDecimal("FDebitQty")));
            row.add(String.valueOf(rowset.getBigDecimal("FCreditQty")));
            row.add(String.valueOf(rowset.getBigDecimal("FEndQty")));
            row.add("4");
        }
        return row;
    }

    @Override
    public Map<String, Object> search(Context ctx, Map params) throws BOSException, SQLException {
        AsstActTypeInfo aat;
        int i;
        ArrayList rows = new ArrayList();
        this.result.put("rows", rows);
        String word = (String)params.get("word");
        if (word == null || word.length() == 0) {
            return this.result;
        }
        boolean mistiness = true;
        if ("false".equalsIgnoreCase((String)params.get("mistiness"))) {
            mistiness = false;
        }
        boolean caseSensitive = true;
        if ("false".equalsIgnoreCase((String)params.get("caseSensitive"))) {
            caseSensitive = false;
        }
        if (!caseSensitive) {
            word = word.toLowerCase(Locale.getDefault());
        }
        BigDecimal bdWord = null;
        try {
            bdWord = new BigDecimal(word);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean previous = "previous".equalsIgnoreCase((String)params.get("action"));
        boolean wrapSearch = "true".equalsIgnoreCase((String)params.get("wrapSearch"));
        int rowIndex = 0;
        Object param = params.get("rowIndex");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                int i2 = Integer.parseInt(param.toString().trim());
                if (i2 >= 0) {
                    rowIndex = i2;
                }
            }
            catch (Exception i2) {
                // empty catch block
            }
        }
        ++rowIndex;
        int columIndex = -1;
        param = params.get("columIndex");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                columIndex = Integer.parseInt(param.toString().trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (columIndex < 0) {
            columIndex = previous ? 0 : -1;
        }
        final HashMap<String, Integer> targetIndexs = new HashMap<String, Integer>();
        ArrayList<String> targets = new ArrayList<String>();
        Map sourceIndexs = (Map)params.get("targetIndexs");
        if (sourceIndexs == null || sourceIndexs.size() == 0) {
            this.errs.add(this.getResource("SelectSearchColumn"));
            return this.result;
        }
        for (Object target : sourceIndexs.keySet()) {
            param = sourceIndexs.get(target);
            Integer targetIndex = null;
            if (param instanceof Integer) {
                targetIndex = (Integer)param;
            } else if (param instanceof String) {
                try {
                    targetIndex = Integer.parseInt((String)param);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String name = (String)target;
            if (targetIndex == null || targetIndex < 0) continue;
            if (name.startsWith("asstActNumber") || name.startsWith("asstActName") || name.startsWith("asstActLongNumber") || name.startsWith("asstActLongName")) {
                try {
                    int asstActIndex = Integer.parseInt(name.substring(name.length() - 1));
                    if (asstActIndex < 1 || asstActIndex > this.asstActTypes.size()) continue;
                    targetIndexs.put(name, targetIndex);
                    targets.add(name);
                }
                catch (Exception asstActIndex) {}
                continue;
            }
            targetIndexs.put(name, targetIndex);
            targets.add(name);
        }
        if (targetIndexs.size() == 0) {
            this.errs.add(this.getResource("ColumnNotSupportBackSearch"));
            return this.result;
        }
        Collections.sort(targets, (Comparator)new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = (Integer)targetIndexs.get(o1);
                int i2 = (Integer)targetIndexs.get(o2);
                return i1 - i2;
            }
        });
        StringBuffer sql = new StringBuffer();
        ArrayList<String> searchParams = new ArrayList<String>();
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        String csStart = "    ";
        String csEnd = "";
        if (!caseSensitive) {
            csStart = "    lower(";
            csEnd = ")";
        }
        sql.append("select /*+ LEADING(b) */ top 2 \n");
        if (targets.contains("companyNumber")) {
            if (this.sumByUnion) {
                sql.append(csStart + "u.FNumber" + csEnd + " FCompanyNumber, \n");
            } else {
                sql.append(csStart + "c.FNumber" + csEnd + " FCompanyNumber, \n");
            }
        }
        if (targets.contains("companyLongNumber")) {
            if (this.sumByUnion) {
                sql.append(csStart + "s.FLongNumber" + csEnd + " FCompanyLongNumber, \n");
            } else {
                sql.append(csStart + "c.FLongNumber" + csEnd + " FCompanyLongNumber, \n");
            }
        }
        if (targets.contains("companyName")) {
            if (this.sumByUnion) {
                sql.append(csStart + "u.FName_" + loc + csEnd + " FCompanyName, \n");
            } else {
                sql.append(csStart + "c.FName_" + loc + csEnd + " FCompanyName, \n");
            }
        }
        if (targets.contains("accountNumber")) {
            sql.append(csStart + "av.FNumber" + csEnd + " FAccountNumber, \n");
        }
        if (targets.contains("accountName")) {
            sql.append(csStart + "av.FName_" + loc + csEnd + " FAccountName, \n");
        }
        if (targets.contains("accountLongName")) {
            sql.append(csStart + "av.FDisplayName_" + loc + csEnd + " FAccountLongName, \n");
        }
        if (targets.contains("currencyNumber")) {
            sql.append(csStart + "cy.FNumber" + csEnd + " FCurrencyNumber, \n");
        }
        if (targets.contains("currencyName")) {
            sql.append(csStart + "cy.FName_" + loc + csEnd + " FCurrencyName, \n");
        }
        if (targets.contains("voucherNumber")) {
            sql.append(csStart + "v.FNumber" + csEnd + " FVoucherNumber, \n");
        }
        if (targets.contains("voucherType")) {
            sql.append(csStart + "vt.FName_" + loc + csEnd + " FVoucherType, \n");
        }
        if (targets.contains("bookedDate")) {
            sql.append("    TOCHAR(v.FBookedDate, 'YYYY-MM-DD') FBookedDate, \n");
        }
        if (targets.contains("bizDate")) {
            sql.append("    TOCHAR(v.FBizDate, 'YYYY-MM-DD') FBizDate, \n");
        }
        if (targets.contains("description")) {
            sql.append(csStart + "vr.FDescription" + csEnd + " FDescription, \n");
        }
        if (targets.contains("creatorName")) {
            sql.append(csStart + "cu.FName_" + loc + csEnd + " FCreatorName, \n");
        }
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            aat = this.asstActTypes.get(i);
            if (targetIndexs.containsKey("asstActNumber" + (i + 1))) {
                sql.append(csStart + "aat" + (i + 1) + ".FNumber" + csEnd + " FAsstActNumber" + (i + 1) + ", \n");
            }
            if (targetIndexs.containsKey("asstActLongNumber" + (i + 1))) {
                if (aat.isIsMultilevel()) {
                    if (aat.getGroupTableName() != null) {
                        sql.append(csStart + "case when b.FAsstActID" + (i + 1) + " is not null then g" + (i + 1) + ".FLongNumber || '!' || aat" + (i + 1) + ".FNumber else null end" + csEnd + " FAsstActLongNumber" + (i + 1) + ", \n");
                    } else {
                        sql.append(csStart + "aat" + (i + 1) + ".FLongNumber" + csEnd + " FAsstActLongNumber" + (i + 1) + ", \n");
                    }
                } else {
                    sql.append(csStart + "aat" + (i + 1) + ".FNumber" + csEnd + " FAsstActLongNumber" + (i + 1) + ", \n");
                }
            }
            if (targetIndexs.containsKey("asstActName" + (i + 1))) {
                sql.append(csStart + "aat" + (i + 1) + ".FName_" + loc + csEnd + " FAsstActName" + (i + 1) + ", \n");
            }
            if (!targetIndexs.containsKey("asstActLongName" + (i + 1))) continue;
            if (aat.isIsMultilevel()) {
                if (aat.getGroupTableName() != null) {
                    sql.append(csStart + "case when b.FAsstActID" + (i + 1) + " is not null then g" + (i + 1) + ".FDisplayName_" + loc + " || '_' || aat" + (i + 1) + ".FName_" + loc + " else null end" + csEnd + " FAsstActLongName" + (i + 1) + ", \n");
                    continue;
                }
                sql.append(csStart + "aat" + (i + 1) + ".FDisplayName_" + loc + csEnd + " FAsstActLongName" + (i + 1) + ", \n");
                continue;
            }
            sql.append(csStart + "aat" + (i + 1) + ".FName_" + loc + csEnd + " FAsstActLongName" + (i + 1) + ", \n");
        }
        sql.append("    b.FRowIndex \n");
        sql.append("from " + params.get("pageId") + " b \n");
        sql.append("left join T_GL_Voucher v on v.FID = b.FVoucherID \n");
        sql.append("left join T_GL_VoucherAssistRecord vr on vr.FID = b.FRecordID \n");
        sql.append("left join T_BD_VoucherTypes vt on vt.FID = v.FVoucherTypeID \n");
        sql.append("left join T_PM_User cu on cu.FID = v.FCreatorID \n");
        if (this.sumByUnion) {
            sql.append("left join T_ORG_Structure s on s.FID = b.FUnionID \n");
            sql.append("left join T_ORG_BaseUnit u on u.FID = s.FUnitID \n");
        } else {
            sql.append("left join T_ORG_Company c on c.FID = b.FCompanyID \n");
        }
        sql.append("left join T_BD_Currency cy on cy.FID = b.FCurrencyID \n");
        sql.append("left join T_BD_AccountView av on av.FID = b.FAccountID \n");
        for (i = 0; i < this.asstActTypes.size(); ++i) {
            if (!targetIndexs.containsKey("asstActNumber" + (i + 1)) && !targetIndexs.containsKey("asstActName" + (i + 1)) && !targetIndexs.containsKey("asstActLongNumber" + (i + 1)) && !targetIndexs.containsKey("asstActLongName" + (i + 1))) continue;
            aat = this.asstActTypes.get(i);
            sql.append("left join " + aat.getRealtionDataObject() + " aat" + (i + 1) + " on aat" + (i + 1) + ".FID = b.FAsstActID" + (i + 1) + " \n");
            if (!aat.isIsMultilevel() || aat.getGroupTableName() == null) continue;
            sql.append("left join " + aat.getGroupTableName() + " g" + (i + 1) + " on g" + (i + 1) + ".FID = aat" + (i + 1) + "." + aat.getGroupMappingFieldName() + " \n");
        }
        csStart = "";
        csEnd = "";
        if (!caseSensitive) {
            csStart = "lower(";
            csEnd = ")";
        }
        String compare = mistiness ? " like ? \n" : " = ? \n";
        String compareValue = mistiness ? "%" + word + "%" : word;
        StringBuffer where = new StringBuffer();
        if (targets.contains("companyNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "u.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("companyLongNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "s.FLongNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FLongNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("companyName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            if (this.sumByUnion) {
                where.append(csStart + "u.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            } else {
                where.append(csStart + "c.FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
        }
        if (targets.contains("accountNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("accountName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("accountLongName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "av.FDisplayName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("currencyNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cy.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("currencyName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cy.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("voucherNumber")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "v.FNumber" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("voucherType")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "vt.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("bookedDate")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append("TOCHAR(v.FBookedDate, 'YYYY-MM-DD')");
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("bizDate")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append("TOCHAR(v.FBizDate, 'YYYY-MM-DD')");
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("description")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "vr.FDescription" + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (targets.contains("creatorName")) {
            if (where.length() > 0) {
                where.append("or ");
            }
            where.append(csStart + "cu.FName_" + loc + csEnd);
            where.append(compare);
            searchParams.add(compareValue);
        }
        for (int i3 = 0; i3 < this.asstActTypes.size(); ++i3) {
            AsstActTypeInfo aat2 = this.asstActTypes.get(i3);
            if (targetIndexs.containsKey("asstActNumber" + (i3 + 1))) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                where.append(csStart + "aat" + (i3 + 1) + ".FNumber" + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
            if (targetIndexs.containsKey("asstActLongNumber" + (i3 + 1))) {
                if (aat2.isIsMultilevel()) {
                    if (aat2.getGroupTableName() != null) {
                        where.append(csStart + "case when b.FAsstActID" + (i3 + 1) + " is not null then g" + (i3 + 1) + ".FLongNumber || '!' || aat" + (i3 + 1) + ".FNumber else null end" + csEnd);
                    } else {
                        where.append(csStart + "aat" + (i3 + 1) + ".FLongNumber" + csEnd);
                    }
                } else {
                    where.append(csStart + "aat" + (i3 + 1) + ".FNumber" + csEnd);
                }
                where.append(compare);
                searchParams.add(compareValue);
            }
            if (targetIndexs.containsKey("asstActName" + (i3 + 1))) {
                if (where.length() > 0) {
                    where.append("or ");
                }
                where.append(csStart + "aat" + (i3 + 1) + ".FName_" + loc + csEnd);
                where.append(compare);
                searchParams.add(compareValue);
            }
            if (!targetIndexs.containsKey("asstActLongName" + (i3 + 1))) continue;
            if (aat2.isIsMultilevel()) {
                if (aat2.getGroupTableName() != null) {
                    where.append(csStart + "case when b.FAsstActID" + (i3 + 1) + " is not null then g" + (i3 + 1) + ".FDisplayName_" + loc + " || '_' || aat" + (i3 + 1) + ".FName_" + loc + " else null end" + csEnd);
                } else {
                    where.append(csStart + "aat" + (i3 + 1) + ".FDisplayName_" + loc + csEnd);
                }
            } else {
                where.append(csStart + "aat" + (i3 + 1) + ".FName_" + loc + csEnd);
            }
            where.append(compare);
            searchParams.add(compareValue);
        }
        if (where.length() <= 0) {
            this.errs.add(this.getResource("ColumnNotSupportBackSearch"));
            return this.result;
        }
        where.append(") \n");
        if (previous) {
            where.append("order by FRowIndex desc \n");
        } else {
            where.append("order by FRowIndex \n");
        }
        StringBuffer sql1 = new StringBuffer();
        ArrayList<Object> searchParams1 = new ArrayList<Object>();
        sql1.append(sql);
        if (previous) {
            sql1.append("where FRowIndex <= ? \n");
            searchParams1.add(rowIndex);
        } else {
            sql1.append("where FRowIndex >= ? \n");
            searchParams1.add(rowIndex);
        }
        sql1.append("and ( \n" + where);
        searchParams1.addAll(searchParams);
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql1.toString(), (Object[])searchParams1.toArray());
        while (rowset.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int index = rowset.getInt("FRowIndex");
            block15: for (String target : targets) {
                String creatorName;
                String description;
                String bizDate;
                String bookedDate;
                String voucherType;
                String voucherNumber;
                String currencyName;
                String currencyNumber;
                String accountLongName;
                String accountName;
                String accountNumber;
                String companyName;
                String companyLongNumber;
                String companyNumber;
                if (index == rowIndex && (index != rowIndex || (!previous || (Integer)targetIndexs.get(target) >= columIndex) && (previous || (Integer)targetIndexs.get(target) <= columIndex))) continue;
                if (target.equals("companyNumber") && this.isMatch(word, bdWord, companyNumber = rowset.getString("FCompanyNumber"), mistiness)) {
                    row.put("name", "companyNumber");
                    row.put("value", companyNumber);
                    break;
                }
                if (target.equals("companyLongNumber") && this.isMatch(word, bdWord, companyLongNumber = rowset.getString("FCompanyLongNumber"), mistiness)) {
                    row.put("name", "companyLongNumber");
                    row.put("value", companyLongNumber);
                    break;
                }
                if (target.equals("companyName") && this.isMatch(word, bdWord, companyName = rowset.getString("FCompanyName"), mistiness)) {
                    row.put("name", "companyName");
                    row.put("value", companyName);
                    break;
                }
                if (target.equals("accountNumber") && this.isMatch(word, bdWord, accountNumber = rowset.getString("FAccountNumber"), mistiness)) {
                    row.put("name", "accountNumber");
                    row.put("value", accountNumber);
                    break;
                }
                if (target.equals("accountName") && this.isMatch(word, bdWord, accountName = rowset.getString("FAccountName"), mistiness)) {
                    row.put("name", "accountName");
                    row.put("value", accountName);
                    break;
                }
                if (target.equals("accountLongName") && this.isMatch(word, bdWord, accountLongName = rowset.getString("FAccountLongName"), mistiness)) {
                    row.put("name", "accountLongName");
                    row.put("value", accountLongName);
                    break;
                }
                if (target.equals("currencyNumber") && this.isMatch(word, bdWord, currencyNumber = rowset.getString("FCurrencyNumber"), mistiness)) {
                    row.put("name", "currencyNumber");
                    row.put("value", currencyNumber);
                    break;
                }
                if (target.equals("currencyName") && this.isMatch(word, bdWord, currencyName = rowset.getString("FCurrencyName"), mistiness)) {
                    row.put("name", "currencyName");
                    row.put("value", currencyName);
                    break;
                }
                if (target.equals("voucherNumber") && this.isMatch(word, bdWord, voucherNumber = rowset.getString("FVoucherNumber"), mistiness)) {
                    row.put("name", "voucherNumber");
                    row.put("value", voucherNumber);
                    break;
                }
                if (target.equals("voucherType") && this.isMatch(word, bdWord, voucherType = rowset.getString("FVoucherType"), mistiness)) {
                    row.put("name", "voucherType");
                    row.put("value", voucherType);
                    break;
                }
                if (target.equals("bookedDate") && this.isMatch(word, bdWord, bookedDate = rowset.getString("FBookedDate"), mistiness)) {
                    row.put("name", "bookedDate");
                    row.put("value", bookedDate);
                    break;
                }
                if (target.equals("bizDate") && this.isMatch(word, bdWord, bizDate = rowset.getString("FBizDate"), mistiness)) {
                    row.put("name", "bizDate");
                    row.put("value", bizDate);
                    break;
                }
                if (target.equals("description") && this.isMatch(word, bdWord, description = rowset.getString("FDescription"), mistiness)) {
                    row.put("name", "description");
                    row.put("value", description);
                    break;
                }
                if (target.equals("creatorName") && this.isMatch(word, bdWord, creatorName = rowset.getString("FCreatorName"), mistiness)) {
                    row.put("name", "creatorName");
                    row.put("value", creatorName);
                    break;
                }
                for (int i4 = 0; i4 < this.asstActTypes.size(); ++i4) {
                    String asstActLongName;
                    String asstActName;
                    String asstActLongNumber;
                    String asstActNumber;
                    if (targetIndexs.containsKey("asstActNumber" + (i4 + 1)) && this.isMatch(word, bdWord, asstActNumber = rowset.getString("FAsstActNumber" + (i4 + 1)), mistiness)) {
                        row.put("name", "asstActNumber" + (i4 + 1));
                        row.put("value", asstActNumber);
                        continue block15;
                    }
                    if (targetIndexs.containsKey("asstActLongNumber" + (i4 + 1)) && this.isMatch(word, bdWord, asstActLongNumber = rowset.getString("FAsstActLongNumber" + (i4 + 1)), mistiness)) {
                        row.put("name", "asstActLongNumber" + (i4 + 1));
                        row.put("value", asstActLongNumber);
                        continue block15;
                    }
                    if (targetIndexs.containsKey("asstActName" + (i4 + 1)) && this.isMatch(word, bdWord, asstActName = rowset.getString("FAsstActName" + (i4 + 1)), mistiness)) {
                        row.put("name", "asstActName" + (i4 + 1));
                        row.put("value", asstActName);
                        continue block15;
                    }
                    if (!targetIndexs.containsKey("asstActLongName" + (i4 + 1)) || !this.isMatch(word, bdWord, asstActLongName = rowset.getString("FAsstActLongName" + (i4 + 1)), mistiness)) continue;
                    row.put("name", "asstActLongName" + (i4 + 1));
                    row.put("value", asstActLongName);
                    continue block15;
                }
            }
            if (!row.containsKey("name")) continue;
            row.put("index", index);
            rows.add(row);
            return this.result;
        }
        if (!wrapSearch) {
            return this.result;
        }
        StringBuffer sql2 = new StringBuffer();
        ArrayList<Object> searchParams2 = new ArrayList<Object>();
        sql2.append(sql);
        if (previous) {
            sql2.append("where FRowIndex >= ? \n");
            searchParams2.add(rowIndex);
        } else {
            sql2.append("where FRowIndex <= ? \n");
            searchParams2.add(rowIndex);
        }
        sql2.append("and ( \n" + where);
        searchParams2.addAll(searchParams);
        rowset = DbUtil.executeQuery((Context)ctx, (String)sql2.toString(), (Object[])searchParams1.toArray());
        while (rowset.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            int index = rowset.getInt("FRowIndex");
            block18: for (String target : targets) {
                String creatorName;
                String description;
                String bizDate;
                String bookedDate;
                String voucherType;
                String voucherNumber;
                String currencyName;
                String currencyNumber;
                String accountLongName;
                String accountName;
                String accountNumber;
                String companyName;
                String companyLongNumber;
                String companyNumber;
                if (index == rowIndex && (index != rowIndex || (!previous || (Integer)targetIndexs.get(target) < columIndex) && (previous || (Integer)targetIndexs.get(target) > columIndex))) continue;
                if (target.equals("companyNumber") && this.isMatch(word, bdWord, companyNumber = rowset.getString("FCompanyNumber"), mistiness)) {
                    row.put("name", "companyNumber");
                    row.put("value", companyNumber);
                    break;
                }
                if (target.equals("companyLongNumber") && this.isMatch(word, bdWord, companyLongNumber = rowset.getString("FCompanyLongNumber"), mistiness)) {
                    row.put("name", "companyLongNumber");
                    row.put("value", companyLongNumber);
                    break;
                }
                if (target.equals("companyName") && this.isMatch(word, bdWord, companyName = rowset.getString("FCompanyName"), mistiness)) {
                    row.put("name", "companyName");
                    row.put("value", companyName);
                    break;
                }
                if (target.equals("accountNumber") && this.isMatch(word, bdWord, accountNumber = rowset.getString("FAccountNumber"), mistiness)) {
                    row.put("name", "accountNumber");
                    row.put("value", accountNumber);
                    break;
                }
                if (target.equals("accountName") && this.isMatch(word, bdWord, accountName = rowset.getString("FAccountName"), mistiness)) {
                    row.put("name", "accountName");
                    row.put("value", accountName);
                    break;
                }
                if (target.equals("accountLongName") && this.isMatch(word, bdWord, accountLongName = rowset.getString("FAccountLongName"), mistiness)) {
                    row.put("name", "accountLongName");
                    row.put("value", accountLongName);
                    break;
                }
                if (target.equals("currencyNumber") && this.isMatch(word, bdWord, currencyNumber = rowset.getString("FCurrencyNumber"), mistiness)) {
                    row.put("name", "currencyNumber");
                    row.put("value", currencyNumber);
                    break;
                }
                if (target.equals("currencyName") && this.isMatch(word, bdWord, currencyName = rowset.getString("FCurrencyName"), mistiness)) {
                    row.put("name", "currencyName");
                    row.put("value", currencyName);
                    break;
                }
                if (target.equals("voucherNumber") && this.isMatch(word, bdWord, voucherNumber = rowset.getString("FVoucherNumber"), mistiness)) {
                    row.put("name", "voucherNumber");
                    row.put("value", voucherNumber);
                    break;
                }
                if (target.equals("voucherType") && this.isMatch(word, bdWord, voucherType = rowset.getString("FVoucherType"), mistiness)) {
                    row.put("name", "voucherType");
                    row.put("value", voucherType);
                    break;
                }
                if (target.equals("bookedDate") && this.isMatch(word, bdWord, bookedDate = rowset.getString("FBookedDate"), mistiness)) {
                    row.put("name", "bookedDate");
                    row.put("value", bookedDate);
                    break;
                }
                if (target.equals("bizDate") && this.isMatch(word, bdWord, bizDate = rowset.getString("FBizDate"), mistiness)) {
                    row.put("name", "bizDate");
                    row.put("value", bizDate);
                    break;
                }
                if (target.equals("description") && this.isMatch(word, bdWord, description = rowset.getString("FDescription"), mistiness)) {
                    row.put("name", "description");
                    row.put("value", description);
                    break;
                }
                if (target.equals("creatorName") && this.isMatch(word, bdWord, creatorName = rowset.getString("FCreatorName"), mistiness)) {
                    row.put("name", "creatorName");
                    row.put("value", creatorName);
                    break;
                }
                for (int i5 = 0; i5 < this.asstActTypes.size(); ++i5) {
                    String asstActLongName;
                    String asstActName;
                    String asstActLongNumber;
                    String asstActNumber;
                    if (targetIndexs.containsKey("asstActNumber" + (i5 + 1)) && this.isMatch(word, bdWord, asstActNumber = rowset.getString("FAsstActNumber" + (i5 + 1)), mistiness)) {
                        row.put("name", "asstActNumber" + (i5 + 1));
                        row.put("value", asstActNumber);
                        continue block18;
                    }
                    if (targetIndexs.containsKey("asstActLongNumber" + (i5 + 1)) && this.isMatch(word, bdWord, asstActLongNumber = rowset.getString("FAsstActLongNumber" + (i5 + 1)), mistiness)) {
                        row.put("name", "asstActLongNumber" + (i5 + 1));
                        row.put("value", asstActLongNumber);
                        continue block18;
                    }
                    if (targetIndexs.containsKey("asstActName" + (i5 + 1)) && this.isMatch(word, bdWord, asstActName = rowset.getString("FAsstActName" + (i5 + 1)), mistiness)) {
                        row.put("name", "asstActName" + (i5 + 1));
                        row.put("value", asstActName);
                        continue block18;
                    }
                    if (!targetIndexs.containsKey("asstActLongName" + (i5 + 1)) || !this.isMatch(word, bdWord, asstActLongName = rowset.getString("FAsstActLongName" + (i5 + 1)), mistiness)) continue;
                    row.put("name", "asstActLongName" + (i5 + 1));
                    row.put("value", asstActLongName);
                    continue block18;
                }
            }
            if (!row.containsKey("name")) continue;
            row.put("index", index);
            rows.add(row);
            return this.result;
        }
        return this.result;
    }

    protected boolean isMatch(String word, BigDecimal bdWord, Object value, boolean mistiness) {
        if (value != null) {
            String v;
            if (value instanceof BigDecimal) {
                if (bdWord != null && bdWord.compareTo((BigDecimal)value) == 0) {
                    return true;
                }
                v = ((BigDecimal)value).stripTrailingZeros().toPlainString();
                if (v.equals(word)) {
                    return true;
                }
            }
            v = value.toString();
            if (mistiness && v.contains(word) || !mistiness && v.equals(word)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAssMatch(String word, String value, boolean mistiness) {
        if (value != null) {
            String str;
            String v = value.toString();
            if (mistiness) {
                return v.contains(word);
            }
            int index = v.indexOf(":");
            if (index > 0 && (index = (str = v.substring(index + 1)).indexOf(" ")) > 0 && (str.substring(0, index).equals(word) || str.substring(index + 1).equals(word))) {
                return true;
            }
            return v.equals(word);
        }
        return false;
    }
}

