/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.ReportCurrencyConvertMode;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLAsstAccountUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.GlWebServiceUtil;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.app.CashflowTableService;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptAccountBalanceService;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptAsstActBalanceService;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptAsstactGDService;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptBasePage;
import com.kingdee.eas.fi.gl.rpt.app.GLNRptSubLedgerService;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class GLNRptBaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.GLNRptBaseService");
    protected static final String CUSTOMER_STANDARD_ID = "00000000-0000-0000-0000-000000000002BC122A7F";
    protected static final String SUPPLIER_STANDARD_ID = "00000000-0000-0000-0000-000000000001BC122A7F";
    protected static final String MATERIAL_STANDARD_ID = "dR8lnQEPEADgAAWKwKgSxZeb4R8=";
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.GLNResource";
    public static final int YEAR_BEGIN_BALANCE_INDEX = 0;
    public static final int PERIOD_BEGIN_BALANCE_INDEX = 1;
    public static final int PERIOD_SUM_INDEX = 3;
    public static final int YEAR_SUM_INDEX = 4;
    protected String T_TMP_PageTable = null;
    protected Map<String, Object> result = new HashMap<String, Object>();
    protected List<List<String>> rows = new ArrayList<List<String>>();
    protected List<List<String>> batchRows = new ArrayList<List<String>>();
    protected List<String> batchNames = new ArrayList<String>();
    protected List<String> errs = new ArrayList<String>();
    protected boolean debug = false;
    protected List<String> sqls = null;
    protected int sqlCount = 100;
    protected long sqlTime = 0L;
    private Set<String> tempTables = new HashSet<String>();
    protected int balType = 5;
    protected boolean notIncludePLVoucher = false;
    protected Context ctx;
    protected Map params;
    protected ExecutorService executor = null;
    private int threadCount = 1;
    protected boolean isFutureError = false;
    protected int batchSize = -1;
    private Connection conn = null;
    protected PeriodTypeInfo periodType = null;
    protected String periodTypeId = null;
    protected int fromPeriodNumber = 0;
    protected int toPeriodNumber = 0;
    protected CurrencyInfo currency = null;
    protected String currencyId = null;
    protected boolean isFor = false;
    protected boolean isLocal = false;
    protected boolean isRpt = false;
    protected boolean showFor = false;
    protected boolean showLocal = false;
    protected boolean showRpt = false;
    protected boolean showQty = false;
    protected boolean showCompanyLongNumber = false;
    protected boolean showCompanyName = false;
    protected boolean showCompanyLevel = false;
    protected boolean showCompanyBizUnit = false;
    protected boolean showAccountName = false;
    protected boolean showAccountLongName = false;
    protected boolean showAccountLevel = false;
    protected boolean showAccountDc = false;
    protected boolean showCurrencyNumber = false;
    protected boolean showCurrencyName = false;
    protected boolean notShowZero = false;
    protected boolean notShowNoCurrent = false;
    protected boolean notShowZeroAndNoCurrent = false;
    protected boolean notShowNoYear = false;
    protected boolean notShowZeroAndNoYear = false;
    protected Set<String> accountNumbers = new HashSet<String>();
    protected String fromAccountNumber = null;
    protected String toAccountNumber = null;
    protected boolean showOnlyLeafAccount = false;
    protected int fromAccountLevel = 0;
    protected int toAccountLevel = 0;
    protected Map<String, Set<String>> asstActLongNumberss = new HashMap<String, Set<String>>();
    protected Map<String, UserInfo> users = new HashMap<String, UserInfo>();
    protected Map<String, Set<String>> userIdss = new HashMap<String, Set<String>>();
    protected boolean updateBalance = true;
    protected boolean byPage = false;
    protected Map<String, MeasureUnitInfo> mus = null;
    protected Map<String, Integer> currencyPrecisions = new HashMap<String, Integer>();
    private Map<String, List<AsstActTypeInfo>> aatss = null;

    public GLNRptBaseService(Context ctx, Map params) {
        this.ctx = ctx;
        this.params = params;
        this.result.put("rows", this.rows);
        this.result.put("errs", this.errs);
    }

    public Map executeQuery() throws BOSException, EASBizException {
        Object param = this.params.get("rptType");
        if (param != null && "getBatch".equals(param.toString().trim())) {
            return this.getBatch();
        }
        if (param != null && "getPage".equals(param.toString().trim())) {
            return this.getPage();
        }
        if (param != null && "release".equals(param.toString().trim())) {
            return this.release();
        }
        if (!this.beforeQuery()) {
            return this.result;
        }
        try {
            this.doExecuteQuery();
            Map<String, Object> map = this.result;
            return map;
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            this.afterQuery();
        }
    }

    protected void doExecuteQuery() throws Exception {
        String batchName;
        int maxThreadCount;
        Object param = this.params.get("threadCount");
        if (param != null && param.toString().trim().length() > 0) {
            try {
                int i = Integer.parseInt(param.toString().trim());
                if (i >= 1) {
                    this.threadCount = i;
                }
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (this.threadCount > (maxThreadCount = this.getMaxThreadCount(this.ctx))) {
            this.threadCount = maxThreadCount;
        }
        if (this.threadCount > 1 && this.useMulti()) {
            this.getConnection();
            this.multiQuery();
        } else {
            this.singleQuery();
        }
        if (this.batchRows.size() > 0 && (batchName = this.saveJsonFile(this.batchRows)) != null) {
            this.batchNames.add(batchName);
        }
        this.result.put("batchNames", this.batchNames);
    }

    protected boolean beforeQuery() throws BOSException, EASBizException {
        Object param = this.params.get("rptType");
        if (param == null || param.toString().trim().length() == 0) {
            this.appendErr("rptType", "", ResourceBase.getString((String)RESOURCE, (String)"paramRptTypeMissing", (Locale)this.ctx.getLocale()));
            return false;
        }
        if (this.getClass() == GLNRptBaseService.class) {
            String dataType = param.toString().trim();
            this.appendErr("rptType", dataType, ResourceBase.getString((String)RESOURCE, (String)"paramRptTypeError", (Locale)this.ctx.getLocale()));
            return false;
        }
        for (Object key : this.params.keySet()) {
            if (key == null || !key.toString().trim().equalsIgnoreCase("debug")) continue;
            param = this.params.get(key);
            if (param == null || !param.toString().trim().equalsIgnoreCase("true")) break;
            this.debug = true;
            break;
        }
        if (this.debug) {
            try {
                PermissionFactory.getLocalInstance((Context)this.ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)this.ctx).getId()), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentFIUnit((Context)this.ctx).getId()), "gl_tool");
            }
            catch (Exception e) {
                this.appendErr("debug", "true", e.getMessage());
                return false;
            }
            this.sqls = new ArrayList<String>();
            this.result.put("sqls", this.sqls);
            param = this.params.get("sqlCount");
            if (param != null && param.toString().trim().length() > 0) {
                try {
                    int count = Integer.parseInt(param.toString().trim());
                    if (count >= 0) {
                        this.sqlCount = count;
                    }
                }
                catch (Exception count) {
                    // empty catch block
                }
            }
            if ((param = this.params.get("sqlTime")) != null && param.toString().trim().length() > 0) {
                try {
                    long time = Long.parseLong(param.toString().trim());
                    if (time >= 0L) {
                        this.sqlTime = time;
                    }
                }
                catch (Exception time) {
                    // empty catch block
                }
            }
        }
        if ((param = this.params.get("balType")) != null && param.toString().trim().length() > 0) {
            String str = param.toString().trim();
            if ("5".equals(str)) {
                this.balType = 5;
            } else if ("1".equals(str)) {
                this.balType = 1;
            } else {
                this.appendErr("balType", str, ResourceBase.getString((String)RESOURCE, (String)"balTypeError", (Locale)this.ctx.getLocale()));
                return false;
            }
        }
        if ((param = this.params.get("notIncludePLVoucher")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.notIncludePLVoucher = true;
        }
        if ((param = this.params.get("periodTypeNumber")) != null && param.toString().trim().length() > 0) {
            String periodTypeNumber = param.toString().trim();
            this.periodType = this.getPeriodType(periodTypeNumber);
            if (this.periodType == null) {
                this.appendErr("periodTypeNumber", periodTypeNumber, ResourceBase.getString((String)RESOURCE, (String)"periodTypeNotFound", (Locale)this.ctx.getLocale()));
                return false;
            }
            this.periodTypeId = this.periodType.getId().toString();
        }
        if ((param = this.params.get("fromPeriodNumber")) != null && param.toString().trim().length() > 0) {
            try {
                this.fromPeriodNumber = Integer.parseInt(param.toString().trim());
                if (this.fromPeriodNumber <= 190000 || this.fromPeriodNumber > 999999) {
                    this.appendErr("fromPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
                    return false;
                }
            }
            catch (Exception e) {
                this.appendErr("fromPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
                return false;
            }
            this.toPeriodNumber = this.fromPeriodNumber;
        }
        if ((param = this.params.get("toPeriodNumber")) != null && param.toString().trim().length() > 0) {
            try {
                this.toPeriodNumber = Integer.parseInt(param.toString().trim());
                if (this.toPeriodNumber <= 190000 || this.toPeriodNumber > 999999) {
                    this.appendErr("toPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
                    return false;
                }
            }
            catch (Exception e) {
                this.appendErr("toPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
                return false;
            }
            if (this.fromPeriodNumber == 0) {
                this.fromPeriodNumber = this.toPeriodNumber;
            }
        }
        if (this.fromPeriodNumber > this.toPeriodNumber) {
            this.appendErr("toPeriodNumber", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"periodError", (Locale)this.ctx.getLocale()));
            return false;
        }
        param = this.params.get("currencyNumber");
        if (param != null && param.toString().trim().length() > 0) {
            String currencyNumber = param.toString().trim();
            this.currency = this.getCurrency(currencyNumber);
            if (this.currency == null) {
                this.appendErr("currencyNumber", currencyNumber, ResourceBase.getString((String)RESOURCE, (String)"currencyNotFound", (Locale)this.ctx.getLocale()));
                return false;
            }
            this.currencyId = this.currency.getId().toString();
        }
        this.isLocal = "11111111-1111-1111-1111-111111111111DEB58FDC".equals(this.currencyId);
        this.isRpt = "22222222-2222-2222-2222-222222222222DEB58FDC".equals(this.currencyId);
        this.isFor = !this.isLocal && !this.isRpt;
        param = this.params.get("showFor");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showFor = true;
        }
        if ((param = this.params.get("showLocal")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showLocal = true;
        }
        if ((param = this.params.get("showRpt")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showRpt = true;
        }
        if (!(this.showFor || this.showLocal || this.showRpt)) {
            this.showFor = true;
        }
        if ((param = this.params.get("showQty")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showQty = true;
        }
        if ((param = this.params.get("showCompanyLongNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyLongNumber = true;
        }
        if ((param = this.params.get("showCompanyName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyName = true;
        }
        if ((param = this.params.get("showCompanyLevel")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyLevel = true;
        }
        if ((param = this.params.get("showCompanyBizUnit")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCompanyBizUnit = true;
        }
        if ((param = this.params.get("showAccountName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountName = true;
        }
        if ((param = this.params.get("showAccountLongName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountLongName = true;
        }
        if ((param = this.params.get("showAccountLevel")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountLevel = true;
        }
        if ((param = this.params.get("showAccountDc")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showAccountDc = true;
        }
        if ((param = this.params.get("showCurrencyNumber")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCurrencyNumber = true;
        }
        if ((param = this.params.get("showCurrencyName")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showCurrencyName = true;
        }
        if ((param = this.params.get("notShowZero")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.notShowZero = true;
        }
        if ((param = this.params.get("notShowNoCurrent")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.notShowNoCurrent = true;
        }
        if ((param = this.params.get("notShowZeroAndNoCurrent")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.notShowZeroAndNoCurrent = true;
        }
        if ((param = this.params.get("notShowNoYear")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.notShowNoYear = true;
        }
        if ((param = this.params.get("notShowZeroAndNoYear")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.notShowZeroAndNoYear = true;
        }
        if ((param = this.params.get("accountNumber")) != null && param.toString().trim().length() > 0) {
            String accountNumber = param.toString().trim();
            if (accountNumber.indexOf(";") >= 0) {
                String[] strs;
                for (String str : strs = param.toString().trim().split(";")) {
                    if (str.trim().length() <= 0) continue;
                    this.accountNumbers.add(str.trim());
                }
            } else {
                this.accountNumbers.add(accountNumber);
            }
        }
        if ((param = this.params.get("fromAccountNumber")) != null && param.toString().trim().length() > 0) {
            this.fromAccountNumber = param.toString().trim();
        }
        if ((param = this.params.get("toAccountNumber")) != null && param.toString().trim().length() > 0) {
            this.toAccountNumber = param.toString().trim();
        }
        if ((param = this.params.get("showOnlyLeafAccount")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("true")) {
            this.showOnlyLeafAccount = true;
        }
        if ((param = this.params.get("fromAccountLevel")) != null && param.toString().trim().length() > 0) {
            try {
                int i = Integer.parseInt(param.toString().trim());
                if (i < 0) {
                    this.appendErr("fromAccountLevel", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"accountLevelError", (Locale)this.ctx.getLocale()));
                    return false;
                }
                this.fromAccountLevel = i;
            }
            catch (Exception e) {
                this.appendErr("fromAccountLevel", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"accountLevelError", (Locale)this.ctx.getLocale()));
                return false;
            }
        }
        if ((param = this.params.get("toAccountLevel")) != null && param.toString().trim().length() > 0) {
            try {
                int i = Integer.parseInt(param.toString().trim());
                if (i < 0) {
                    this.appendErr("toAccountLevel", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"accountLevelError", (Locale)this.ctx.getLocale()));
                    return false;
                }
                this.toAccountLevel = i;
            }
            catch (Exception e) {
                this.appendErr("toAccountLevel", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"accountLevelError", (Locale)this.ctx.getLocale()));
                return false;
            }
        }
        if (this.toAccountLevel > 0 && this.fromAccountLevel > this.toAccountLevel) {
            this.appendErr("toAccountLevel", param.toString().trim(), ResourceBase.getString((String)RESOURCE, (String)"accountLevelError", (Locale)this.ctx.getLocale()));
            return false;
        }
        param = this.params.get("updateBalance");
        if (param != null && param.toString().trim().length() > 0 && param.toString().trim().equals("false")) {
            this.updateBalance = false;
        }
        if ((param = this.params.get("dataMode")) != null && param.toString().trim().length() > 0 && param.toString().trim().equals("byPage")) {
            this.byPage = true;
        }
        return true;
    }

    protected void afterQuery() throws BOSException, EASBizException {
        if (this.conn != null) {
            try {
                SQLUtils.cleanup((Connection)this.conn);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.conn = null;
        }
        if (this.executor != null) {
            try {
                this.executor.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.executor = null;
        }
        if (!this.debug || !this.byPage) {
            for (String tempTable : this.tempTables) {
                try {
                    TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                }
                catch (Throwable throwable) {}
            }
            this.tempTables.clear();
        }
    }

    protected boolean useMulti() throws Exception {
        return false;
    }

    protected void singleQuery() throws Exception {
    }

    protected void multiQuery() throws Exception {
    }

    protected String getPermissionItem() {
        return null;
    }

    protected synchronized Connection getConnection() throws SQLException {
        if (this.conn == null) {
            this.conn = EJBFactory.getConnection((Context)this.ctx);
        }
        return this.conn;
    }

    protected synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.threadCount);
        }
        return this.executor;
    }

    protected void wait(List<Future<Object>> futures) throws EASBizException, BOSException {
        Throwable ex = null;
        for (Future<Object> one : futures) {
            try {
                one.get();
            }
            catch (Throwable e2) {
                Exception e2;
                Throwable cause = e2.getCause();
                if (cause != null && (cause instanceof EASBizException || cause instanceof BOSException)) {
                    e2 = (Exception)cause;
                }
                if (ex == null) {
                    ex = e2;
                }
                this.isFutureError = true;
            }
        }
        futures.clear();
        if (ex != null) {
            if (ex instanceof EASBizException) {
                throw (EASBizException)ex;
            }
            if (ex instanceof BOSException) {
                throw (BOSException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new BOSException(ex);
        }
    }

    protected void appendErr(String key, String val, String msg) {
        this.errs.add(key + "[" + val + "]:" + msg);
    }

    protected Object getParam(Map params, String key) {
        Object param = params.get(key);
        if (param instanceof Collection) {
            if (((Collection)param).size() == 0) {
                param = null;
            }
        } else if (param instanceof String) {
            String str = ((String)param).trim();
            param = str.length() == 0 ? null : str;
        }
        return param;
    }

    protected Set<String> getParamStrings(Object param) {
        HashSet<String> result;
        block2: {
            String[] strs;
            block3: {
                result = new HashSet<String>();
                if (param == null) break block2;
                if (!(param instanceof Collection)) break block3;
                for (Object item : (Collection)param) {
                    if (item == null || item.toString().trim().length() <= 0) continue;
                    result.add(item.toString().trim());
                }
                break block2;
            }
            if (!(param instanceof String)) break block2;
            for (String str : strs = ((String)param).trim().split(";")) {
                if (str.trim().length() <= 0) continue;
                result.add(str.trim());
            }
        }
        return result;
    }

    protected CompanyOrgUnitInfo getCompany(String companyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("name");
        selector.add("displayName");
        selector.add("isBizUnit");
        selector.add("level");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        selector.add("baseCurrency.id");
        selector.add("baseCurrency.number");
        selector.add("baseCurrency.name");
        selector.add("baseCurrency.precision");
        selector.add("reportCurrency.id");
        selector.add("reportCurrency.number");
        selector.add("reportCurrency.name");
        selector.add("reportCurrency.precision");
        selector.add("reportConvertMode");
        selector.add("CU.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber));
        view.setFilter(filter);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
        if (companys != null && companys.size() > 0) {
            return companys.get(0);
        }
        return null;
    }

    protected CompanyOrgUnitCollection getCompanys(Set<String> companyNumbers) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("longNumber");
        selector.add("name");
        selector.add("displayName");
        selector.add("isBizUnit");
        selector.add("level");
        selector.add("accountTable.id");
        selector.add("accountTable.number");
        selector.add("baseCurrency.id");
        selector.add("baseCurrency.number");
        selector.add("baseCurrency.name");
        selector.add("baseCurrency.precision");
        selector.add("reportCurrency.id");
        selector.add("reportCurrency.number");
        selector.add("reportCurrency.name");
        selector.add("reportCurrency.precision");
        selector.add("reportConvertMode");
        selector.add("CU.id");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", companyNumbers, CompareType.INCLUDE));
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo item = new SorterItemInfo("longNumber");
        item.setSortType(SortType.ASCEND);
        sorter.add(item);
        view.setSorter(sorter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
        if (coll == null) {
            coll = new CompanyOrgUnitCollection();
        }
        return coll;
    }

    protected CompanyOrgUnitCollection getChildCompanys(CompanyOrgUnitInfo parent) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select \n");
        sql.append("    c.FID, c.FNumber, c.FLongNumber, c.FName_" + loc + " FName, \n");
        sql.append("    c.FDisplayName_" + loc + " FDisplayName, c.FIsBizUnit, c.FLevel, \n");
        sql.append("    bc.FID FBaseCurrencyID, bc.FNumber FBaseCurrencyNumber, bc.FName_" + loc + " FBaseCurrencyName, bc.FPrecision FBaseCurrencyPrecision, \n");
        sql.append("    rc.FID FReportCurrencyID, rc.FNumber FReportCurrencyNumber, rc.FName_" + loc + " FReportCurrencyName, rc.FPrecision FReportCurrencyPrecision, c.FReportConvertMode, \n");
        sql.append("    at.FID FAccountTableID, at.FNumber FAccountTableNumber \n");
        sql.append("from T_ORG_Company c \n");
        sql.append("left join T_BD_Currency bc on bc.FID = c.FBaseCurrencyID \n");
        sql.append("left join T_BD_Currency rc on rc.FID = c.FReportCurrencyID \n");
        sql.append("join T_BD_SystemStatusCtrol sc on sc.FCompanyID = c.FID \n");
        sql.append("join T_BD_SystemStatus s on s.FID = sc.FSystemStatusID \n");
        sql.append("join T_BD_AccountTable at on at.FID = c.FAccountTableID \n");
        sql.append("where sc.FStartPeriodID is not null and sc.FCurrentPeriodID is not null \n");
        sql.append("    and sc.FIsStart = 1 and s.FName = 6 \n");
        sql.append("    and c.FIsBizUnit = 1 and c.FIsAssistantOrg = 0 \n");
        sql.append("    and c.FLongNumber like '" + parent.getLongNumber() + "!%' \n");
        sql.append("\n");
        sql.append("");
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                String reportCurrencyId;
                String baseCurrencyId;
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)rowSet.getString("FID")));
                company.setNumber(rowSet.getString("FNumber"));
                company.setLongNumber(rowSet.getString("FLongNumber"));
                company.setName(rowSet.getString("FName"));
                company.setDisplayName(rowSet.getString("FDisplayName"));
                company.setIsBizUnit(rowSet.getInt("FIsBizUnit") == 1);
                company.setLevel(rowSet.getInt("FLevel"));
                company.setIsAssistantOrg(false);
                String accountTableId = rowSet.getString("FAccountTableID");
                if (accountTableId != null && accountTableId.length() > 0) {
                    AccountTableInfo table = new AccountTableInfo();
                    table.setId(BOSUuid.read((String)accountTableId));
                    table.setNumber(rowSet.getString("FAccountTableNumber"));
                    company.setAccountTable(table);
                }
                if ((baseCurrencyId = rowSet.getString("FBaseCurrencyID")) != null && baseCurrencyId.length() > 0) {
                    CurrencyInfo cy = new CurrencyInfo();
                    cy.setId(BOSUuid.read((String)baseCurrencyId));
                    cy.setNumber(rowSet.getString("FBaseCurrencyNumber"));
                    cy.setName(rowSet.getString("FBaseCurrencyName"));
                    cy.setPrecision(rowSet.getInt("FBaseCurrencyPrecision"));
                    company.setBaseCurrency(cy);
                }
                if ((reportCurrencyId = rowSet.getString("FReportCurrencyID")) != null && reportCurrencyId.length() > 0) {
                    CurrencyInfo cy = new CurrencyInfo();
                    cy.setId(BOSUuid.read((String)reportCurrencyId));
                    cy.setNumber(rowSet.getString("FReportCurrencyNumber"));
                    cy.setName(rowSet.getString("FReportCurrencyName"));
                    cy.setPrecision(rowSet.getInt("FReportCurrencyPrecision"));
                    company.setReportCurrency(cy);
                    company.setReportConvertMode(ReportCurrencyConvertMode.getEnum((int)rowSet.getInt("FReportConvertMode")));
                }
                coll.add(company);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return coll;
    }

    protected CompanyOrgUnitCollection getCompanys(String orgTreeId, String unionNumber) throws BOSException, EASBizException {
        CompanyOrgUnitCollection coll = new CompanyOrgUnitCollection();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("CU.id");
        selector.add("CU.number");
        OrgTreeInfo orgTree = OrgTreeFactory.getLocalInstance((Context)this.ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(orgTreeId), selector);
        if (orgTree.getCU() == null) {
            return coll;
        }
        CompanyOrgUnitInfo cu = this.getCompany(orgTree.getCU().getNumber());
        if (cu == null) {
            return coll;
        }
        coll.add(cu);
        HashSet<String> unionNumbers = new HashSet<String>();
        if (unionNumber != null && unionNumber.length() > 0) {
            if (unionNumber.indexOf(";") >= 0) {
                String[] strs;
                for (String str : strs = unionNumber.split(";")) {
                    if (str.trim().length() <= 0) continue;
                    unionNumbers.add(str.trim());
                }
            } else {
                unionNumbers.add(unionNumber);
            }
        }
        Set<String> unionLongNumbers = this.getUnionLongNumbers(this.ctx, orgTreeId, unionNumbers);
        StringBuffer sql = new StringBuffer();
        ArrayList<String> ps = new ArrayList<String>();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append("select DISTINCT st.FID FUnionID, st.FLevel FUnionLevel, \n");
        sql.append("    c.FID, c.FNumber, c.FLongNumber, c.FName_" + loc + " FName, c.FIsAssistantOrg, \n");
        sql.append("    c.FDisplayName_" + loc + " FDisplayName, c.FIsBizUnit, c.FLevel, \n");
        sql.append("    bc.FID FBaseCurrencyID, bc.FNumber FBaseCurrencyNumber, bc.FName_" + loc + " FBaseCurrencyName, bc.FPrecision FBaseCurrencyPrecision, \n");
        sql.append("    rc.FID FReportCurrencyID, rc.FNumber FReportCurrencyNumber, rc.FName_" + loc + " FReportCurrencyName, rc.FPrecision FReportCurrencyPrecision, c.FReportConvertMode, \n");
        sql.append("    at.FID FAccountTableID, at.FNumber FAccountTableNumber \n");
        sql.append("from T_ORG_Structure st \n");
        sql.append("join T_ORG_Company c on c.FID = st.FUNITID \n");
        sql.append("left join T_BD_Currency bc on bc.FID = c.FBaseCurrencyID \n");
        sql.append("left join T_BD_Currency rc on rc.FID = c.FReportCurrencyID \n");
        sql.append("join T_BD_AccountTable at on at.FID = c.FAccountTableID \n");
        sql.append("where st.FTreeID = ? \n");
        ps.add(orgTreeId);
        sql.append("    and FIsBizUnit = 1 \n");
        if (unionLongNumbers.size() > 0) {
            sql.append("    and ( \n");
            boolean firstNumber = true;
            for (String unionLongNumber : unionLongNumbers) {
                if (!firstNumber) {
                    sql.append("or ");
                }
                firstNumber = false;
                sql.append("        st.FLongNumber like ? \n");
                ps.add(unionLongNumber + "!%");
            }
            sql.append("    ) \n");
        }
        sql.append("\n");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])ps.toArray());
            while (rowSet.next()) {
                String reportCurrencyId;
                String baseCurrencyId;
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                String id = rowSet.getString("FID");
                if (id.equals(cu.getId().toString())) continue;
                company.setId(BOSUuid.read((String)id));
                company.setNumber(rowSet.getString("FNumber"));
                company.setLongNumber(rowSet.getString("FLongNumber"));
                company.setName(rowSet.getString("FName"));
                company.setDisplayName(rowSet.getString("FDisplayName"));
                company.setIsBizUnit(rowSet.getInt("FIsBizUnit") == 1);
                company.setLevel(rowSet.getInt("FLevel"));
                company.setIsAssistantOrg(rowSet.getInt("FIsAssistantOrg") == 1);
                String accountTableId = rowSet.getString("FAccountTableID");
                if (accountTableId != null && accountTableId.length() > 0) {
                    AccountTableInfo table = new AccountTableInfo();
                    table.setId(BOSUuid.read((String)accountTableId));
                    table.setNumber(rowSet.getString("FAccountTableNumber"));
                    company.setAccountTable(table);
                }
                if ((baseCurrencyId = rowSet.getString("FBaseCurrencyID")) != null && baseCurrencyId.length() > 0) {
                    CurrencyInfo cy = new CurrencyInfo();
                    cy.setId(BOSUuid.read((String)baseCurrencyId));
                    cy.setNumber(rowSet.getString("FBaseCurrencyNumber"));
                    cy.setName(rowSet.getString("FBaseCurrencyName"));
                    cy.setPrecision(rowSet.getInt("FBaseCurrencyPrecision"));
                    company.setBaseCurrency(cy);
                }
                if ((reportCurrencyId = rowSet.getString("FReportCurrencyID")) != null && reportCurrencyId.length() > 0) {
                    CurrencyInfo cy = new CurrencyInfo();
                    cy.setId(BOSUuid.read((String)reportCurrencyId));
                    cy.setNumber(rowSet.getString("FReportCurrencyNumber"));
                    cy.setName(rowSet.getString("FReportCurrencyName"));
                    cy.setPrecision(rowSet.getInt("FReportCurrencyPrecision"));
                    company.setReportCurrency(cy);
                    company.setReportConvertMode(ReportCurrencyConvertMode.getEnum((int)rowSet.getInt("FReportConvertMode")));
                }
                company.put("unionId", (Object)rowSet.getString("FUnionID"));
                company.put("unionLevel", (Object)rowSet.getInt("FUnionLevel"));
                coll.add(company);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (coll.size() == 1) {
            coll.clear();
            return coll;
        }
        return coll;
    }

    protected Set<String> getUnionLongNumbers(Context ctx, String orgTreeId, Set<String> numbers) throws BOSException {
        HashSet<String> longNumbers = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("longNumber");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeId));
        filter.getFilterItems().add(new FilterItemInfo("unit.number", numbers, CompareType.INCLUDE));
        view.setFilter(filter);
        OrgStructureCollection coll = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(view);
        HashSet<String> lns = new HashSet<String>();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            lns.add(((OrgStructureInfo)it.next()).getLongNumber());
        }
        for (OrgStructureInfo c : coll) {
            boolean found = false;
            for (String ln : lns) {
                if (!ln.startsWith(c.getLongNumber() + "!")) continue;
                found = true;
                break;
            }
            if (found) continue;
            longNumbers.add(c.getLongNumber());
        }
        return longNumbers;
    }

    protected OrgStructureInfo getTopOrgStructure(String orgTreeId, String unionNumber) throws BOSException, EASBizException {
        HashSet<String> unionNumbers = new HashSet<String>();
        if (unionNumber != null && unionNumber.length() > 0) {
            if (unionNumber.indexOf(";") >= 0) {
                String[] strs;
                for (String str : strs = unionNumber.split(";")) {
                    if (str.trim().length() <= 0) continue;
                    unionNumbers.add(str.trim());
                }
            } else {
                unionNumbers.add(unionNumber);
            }
        }
        String topUnionLongNumber = null;
        if (unionNumbers.size() > 0) {
            Set<String> unionLongNumbers = this.getUnionLongNumbers(this.ctx, orgTreeId, unionNumbers);
            if (unionLongNumbers.size() == 0) {
                return null;
            }
            block1: for (String unionLongNumber : unionLongNumbers) {
                if (topUnionLongNumber == null) {
                    topUnionLongNumber = unionLongNumber;
                    continue;
                }
                String[] strs1 = topUnionLongNumber.split("!");
                String[] strs2 = unionLongNumber.split("!");
                for (int i = 0; i < strs1.length && i < strs2.length; ++i) {
                    if (!strs2[i].equals(strs1[i])) {
                        topUnionLongNumber = "";
                        for (int count = 0; count < i; ++count) {
                            if (topUnionLongNumber.length() > 0) {
                                topUnionLongNumber = topUnionLongNumber + "!";
                            }
                            topUnionLongNumber = topUnionLongNumber + strs1[count];
                        }
                        continue block1;
                    }
                    if (i == strs1.length - 1) continue block1;
                    if (i != strs2.length - 1) continue;
                    topUnionLongNumber = unionLongNumber;
                    continue block1;
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("longNumber");
        selector.add("level");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeId));
        if (topUnionLongNumber != null) {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)topUnionLongNumber));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("level", (Object)new Integer(1)));
        }
        view.setFilter(filter);
        OrgStructureCollection coll = OrgStructureFactory.getLocalInstance((Context)this.ctx).getOrgStructureCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    protected AccountTableInfo getAccountTable(String accountTableNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)accountTableNumber));
        view.setFilter(filter);
        AccountTableCollection ats = AccountTableFactory.getLocalInstance((Context)this.ctx).getAccountTableCollection(view);
        if (ats != null && ats.size() > 0) {
            return ats.get(0);
        }
        return null;
    }

    protected Set<String> getAccountLongNumbers(Context ctx, CompanyOrgUnitInfo company, String accountTableId, Set<String> numbers) throws BOSException {
        HashSet<String> longNumbers = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("longNumber");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        if (accountTableId != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountTableID", (Object)accountTableId));
        }
        filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
        view.setFilter(filter);
        AccountViewCollection coll = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
        for (AccountViewInfo account : coll) {
            String longNumber = account.getLongNumber();
            if (longNumbers.size() == 0) {
                longNumbers.add(longNumber);
                continue;
            }
            boolean found = false;
            for (String aln : longNumbers) {
                if (longNumber.startsWith(aln + "!")) {
                    found = true;
                    break;
                }
                if (!aln.startsWith(longNumber + "!")) continue;
                longNumbers.remove(aln);
                longNumbers.add(longNumber);
                found = true;
                break;
            }
            if (found) continue;
            longNumbers.add(longNumber);
        }
        return longNumbers;
    }

    protected PeriodTypeInfo getPeriodType(String periodTypeNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)periodTypeNumber));
        view.setFilter(filter);
        PeriodTypeCollection periodTypes = PeriodTypeFactory.getLocalInstance((Context)this.ctx).getPeriodTypeCollection(view);
        if (periodTypes != null && periodTypes.size() > 0) {
            return periodTypes.get(0);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)periodTypeNumber));
        view.setFilter(filter);
        periodTypes = PeriodTypeFactory.getLocalInstance((Context)this.ctx).getPeriodTypeCollection(view);
        if (periodTypes != null && periodTypes.size() > 0) {
            return periodTypes.get(0);
        }
        return null;
    }

    protected CurrencyInfo getCurrency(String currencyNumber) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("precision");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)currencyNumber));
        view.setFilter(filter);
        CurrencyCollection currencys = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view);
        if (currencys != null && currencys.size() > 0) {
            return currencys.get(0);
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)currencyNumber));
        view.setFilter(filter);
        currencys = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view);
        if (currencys != null && currencys.size() > 0) {
            return currencys.get(0);
        }
        return null;
    }

    protected SystemEnum getSourceSys(Context ctx, String key) {
        List list = SystemEnum.getEnumList();
        for (SystemEnum item : list) {
            if (!String.valueOf(item.getValue()).equals(key) && !item.getName().equals(key) && !item.getAlias().equals(key)) continue;
            return item;
        }
        return null;
    }

    protected SourceType getSourceType(Context ctx, String key) {
        List list = SourceType.getEnumList();
        for (SourceType item : list) {
            if (!String.valueOf(item.getValue()).equals(key) && !item.getName().equals(key) && !item.getAlias().equals(key)) continue;
            return item;
        }
        return null;
    }

    protected UserInfo getUser(Context ctx, String number) throws BOSException {
        if (this.users.containsKey(number)) {
            return this.users.get(number);
        }
        UserInfo user = GlWebServiceUtil.findUserUByName(ctx, number);
        this.users.put(number, user);
        return user;
    }

    protected Set<String> getUserIds(Context ctx, String numberOrName) throws BOSException {
        if (this.userIdss.containsKey(numberOrName)) {
            return this.userIdss.get(numberOrName);
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberOrName));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)numberOrName));
        filter.setMaskString("(#0 or #1)");
        view.setFilter(filter);
        HashSet<String> userIds = new HashSet<String>();
        UserCollection users = UserFactory.getLocalInstance((Context)ctx).getUserCollection(view);
        for (int i = 0; i < users.size(); ++i) {
            userIds.add(users.get(i).getId().toString());
        }
        this.userIdss.put(numberOrName, userIds);
        return userIds;
    }

    protected List<Map<String, Object>> toList(CompanyNode root) throws BOSException {
        ArrayList<Map<String, Object>> treeDatas = new ArrayList<Map<String, Object>>(root.childs.size());
        for (int i = 0; i < root.childs.size(); ++i) {
            HashMap<String, Object> treeData = new HashMap<String, Object>();
            treeData.put("tree", i + 1);
            CompanyNode node = root.childs.get(i);
            treeData.put("rootCompany", node.company);
            treeData.put("companys", node.getBizCompanys());
            treeDatas.add(treeData);
        }
        return treeDatas;
    }

    protected List<Map<String, Object>> toMap(List<Map<String, Object>> treeDatas) throws BOSException {
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(treeDatas.size());
        for (int i = 0; i < treeDatas.size(); ++i) {
            CompanyOrgUnitInfo root = (CompanyOrgUnitInfo)treeDatas.get(i).get("rootCompany");
            Map<String, Object> map = this.toMap(root);
            List companys = (List)treeDatas.get(i).get("companys");
            if (companys != null & companys.size() > 0) {
                ArrayList<Map<String, Object>> childs = new ArrayList<Map<String, Object>>(companys.size());
                for (CompanyOrgUnitInfo company : companys) {
                    if (company.getBoolean("hasError")) continue;
                    Map<String, Object> child = this.toMap(company);
                    childs.add(child);
                }
                map.put("childs", childs);
            }
            maps.add(map);
        }
        return maps;
    }

    private Map<String, Object> toMap(CompanyOrgUnitInfo company) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", company.getId().toString());
        map.put("number", company.getNumber());
        map.put("longNumber", company.getLongNumber());
        map.put("name", company.getName());
        map.put("displayName", company.getDisplayName());
        map.put("isBizUnit", String.valueOf(company.isIsBizUnit()));
        map.put("level", String.valueOf(company.getLevel()));
        if (company.get("inhere") != null) {
            map.put("inhere", String.valueOf(company.get("inhere")));
        }
        if (company.get("hasError") != null) {
            map.put("hasError", String.valueOf(company.get("hasError")));
        }
        return map;
    }

    protected Map<String, PeriodInfo[]> getPeriodss(Context ctx, List<CompanyOrgUnitInfo> companys) throws BOSException {
        HashSet<String> companyIds = new HashSet<String>();
        for (CompanyOrgUnitInfo company : companys) {
            companyIds.add(company.getId().toString());
        }
        return this.getPeriodss(ctx, companyIds);
    }

    protected Map<String, PeriodInfo[]> getPeriodss(Context ctx, Set<String> companyIds) throws BOSException {
        try {
            if (companyIds.size() == 0) {
                return new HashMap<String, PeriodInfo[]>();
            }
            if (companyIds.size() <= 100) {
                return this.doGetPeriods(ctx, companyIds);
            }
            Map<String, PeriodInfo[]> periodss = null;
            List<Set<String>> batchs = GlUtils.split(companyIds, 100);
            for (Set<String> batch : batchs) {
                Map<String, PeriodInfo[]> bPeriodss = this.doGetPeriods(ctx, batch);
                if (periodss == null) {
                    periodss = bPeriodss;
                    continue;
                }
                periodss.putAll(bPeriodss);
            }
            return periodss;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected Map<String, PeriodInfo[]> doGetPeriods(Context ctx, Set<String> companyIds) throws BOSException, SQLException {
        HashMap<String, PeriodInfo[]> periodss = new HashMap<String, PeriodInfo[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("select ssc.FCompanyID, \n");
        sql.append("    sp.FID FStartPeriodID, sp.FNumber FStartPeriodNumber, sp.FPeriodYear FStartPeriodYear, sp.FPeriodNumber FStartPeriodMonth, \n");
        sql.append("    cp.FID FCurrentPeriodID, cp.FNumber FCurrentPeriodNumber, cp.FPeriodYear FCurrentPeriodYear, cp.FPeriodNumber FCurrentPeriodMonth\n");
        sql.append("from T_BD_SystemStatusCtrol ssc \n");
        sql.append("join T_BD_SystemStatus ss on ss.FID = ssc.FSystemStatusID \n");
        sql.append("left join T_BD_Period sp on sp.FID = ssc.FStartPeriodID \n");
        sql.append("left join T_BD_Period cp on cp.FID = ssc.FCurrentPeriodID \n");
        sql.append("where ss.FName = 6 \n");
        sql.append("and ssc.FCompanyID in " + SQLUtil.buildMarkSQL(companyIds.size()) + "\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])companyIds.toArray());
        while (rs.next()) {
            PeriodInfo[] periods = new PeriodInfo[2];
            PeriodInfo start = null;
            String id = rs.getString("FStartPeriodID");
            if (id != null) {
                int number = rs.getInt("FStartPeriodNumber");
                int year = rs.getInt("FStartPeriodYear");
                int month = rs.getInt("FStartPeriodMonth");
                start = new PeriodInfo();
                start.setId(BOSUuid.read((String)id));
                start.setNumber(number);
                start.setPeriodYear(year);
                start.setPeriodNumber(month);
            }
            periods[0] = start;
            PeriodInfo current = null;
            id = rs.getString("FCurrentPeriodID");
            if (id != null) {
                int number = rs.getInt("FCurrentPeriodNumber");
                int year = rs.getInt("FCurrentPeriodYear");
                int month = rs.getInt("FCurrentPeriodMonth");
                current = new PeriodInfo();
                current.setId(BOSUuid.read((String)id));
                current.setNumber(number);
                current.setPeriodYear(year);
                current.setPeriodNumber(month);
            }
            periods[1] = current;
            periodss.put(rs.getString("FCompanyID"), periods);
        }
        for (String companyId : companyIds) {
            if (periodss.containsKey(companyId)) continue;
            PeriodInfo[] periods = new PeriodInfo[]{null, null};
            periodss.put(companyId, periods);
        }
        return periodss;
    }

    protected int getMaxThreadCount(Context ctx) throws EASBizException, BOSException {
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("GL_RptMax_ThreadCount", null);
        HashMap out = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(in);
        Object value = out.get("GL_RptMax_ThreadCount");
        if (value != null) {
            try {
                int count = Integer.parseInt(value.toString());
                if (count >= 1 && count <= 64) {
                    return count;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    protected int getMaxBatchSize(Context ctx) throws EASBizException, BOSException {
        if (this.batchSize > 0) {
            return this.batchSize;
        }
        this.batchSize = 50000;
        Object batchSizeObj = this.params.get("BATCH_SIZE");
        if (batchSizeObj != null && batchSizeObj.toString().trim().length() > 0) {
            this.batchSize = Integer.parseInt(batchSizeObj.toString().trim());
            return this.batchSize;
        }
        HashMap<String, Object> in = new HashMap<String, Object>();
        in.put("GL_RptMax_BatchSize", null);
        HashMap out = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(in);
        Object value = out.get("GL_RptMax_BatchSize");
        if (value != null) {
            try {
                int size = Integer.parseInt(value.toString());
                if (size >= 1 && size <= 20) {
                    this.batchSize = 10000 * size;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.batchSize;
    }

    protected static String toInSql(Set ids) {
        StringBuffer sql = new StringBuffer();
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            Object o;
            if (sql.length() > 0) {
                sql.append(",");
            }
            if ((o = it.next()) instanceof String) {
                sql.append("'").append(o).append("'");
                continue;
            }
            sql.append(o);
        }
        return "(" + sql.toString() + ")";
    }

    public AsstActTypeCollection getAsstActType(Context ctx, String asstActTypeNumber) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        view.setSelector(selector);
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("asstHGAttribute");
        selector.add("realtionDataObject");
        selector.add("mappingFieldName");
        selector.add("groupTableName");
        selector.add("groupMappingFieldName");
        selector.add("isMultilevel");
        selector.add("useLongNumber");
        selector.add("isQty");
        selector.add("glAsstActTypeGrp.*");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)asstActTypeNumber));
        AsstActTypeCollection coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        if (coll.size() > 0) {
            return coll;
        }
        filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)asstActTypeNumber));
        coll = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeCollection(view);
        if (coll.size() > 0) {
            return coll;
        }
        return coll;
    }

    protected synchronized Set<String> getAsstActLongNumbers(Context ctx, AsstActTypeInfo asstActType, Set<String> numbers) throws BOSException {
        Set<String> longNumbers = this.asstActLongNumberss.get(asstActType.getId().toString());
        if (longNumbers != null) {
            return longNumbers;
        }
        longNumbers = new HashSet<String>();
        if (asstActType.isIsMultilevel() && numbers.size() > 0) {
            StringBuffer sql = new StringBuffer();
            ArrayList<String> ps = new ArrayList<String>();
            if (asstActType.getGroupTableName() != null) {
                sql.append("select g.FLongNumber \n");
                sql.append("from " + asstActType.getGroupTableName() + " g \n");
                sql.append("where g.FNumber in " + SQLUtil.buildMarkSQL(numbers.size()) + " \n");
                ps.addAll(numbers);
                DataBaseInfo db = (DataBaseInfo)asstActType.get("standard");
                if ("customer".equals(asstActType.getAsstHGAttribute())) {
                    sql.append("and g.FCSSPGroupStandardID = ? \n");
                    ps.add(db == null ? CUSTOMER_STANDARD_ID : db.getId().toString());
                } else if ("provider".equals(asstActType.getAsstHGAttribute())) {
                    sql.append("and g.FCSSPGroupStandardID = ? \n");
                    ps.add(db == null ? SUPPLIER_STANDARD_ID : db.getId().toString());
                } else if ("material".equals(asstActType.getAsstHGAttribute())) {
                    sql.append("and g.FGroupStandard = ? \n");
                    ps.add(db == null ? MATERIAL_STANDARD_ID : db.getId().toString());
                }
            } else {
                sql.append("select g.FLongNumber \n");
                sql.append("from " + asstActType.getRealtionDataObject() + " g \n");
                sql.append("where g.FNumber in " + SQLUtil.buildMarkSQL(numbers.size()) + " \n");
                ps.addAll(numbers);
                if (asstActType.getGlAsstActTypeGrp() != null) {
                    sql.append("and g.FGroupID = ? \n");
                    ps.add(asstActType.getGlAsstActTypeGrp().getId().toString());
                }
            }
            IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])ps.toArray());
            try {
                while (rowset.next()) {
                    String longNumber = rowset.getString("FLongNumber");
                    if (longNumbers.size() == 0) {
                        longNumbers.add(longNumber);
                        continue;
                    }
                    boolean found = false;
                    for (String aln : longNumbers) {
                        if (longNumber.startsWith(aln + "!")) {
                            found = true;
                            break;
                        }
                        if (!aln.startsWith(longNumber + "!")) continue;
                        longNumbers.remove(aln);
                        longNumbers.add(longNumber);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    longNumbers.add(longNumber);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        this.asstActLongNumberss.put(asstActType.getId().toString(), longNumbers);
        return longNumbers;
    }

    protected Map<String, MeasureUnitInfo> getMeasureUnits(Context ctx) throws BOSException {
        if (this.mus != null) {
            return this.mus;
        }
        this.mus = new HashMap<String, MeasureUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("coefficient");
        selector.add("qtyPrecision");
        view.setSelector(selector);
        MeasureUnitCollection coll = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view);
        for (MeasureUnitInfo unit : coll) {
            this.mus.put(unit.getId().toString(), unit);
        }
        return this.mus;
    }

    protected int getCurrencyPrecision(Context ctx, String currencyId) {
        if (currencyId == null) {
            return 2;
        }
        if (this.currencyPrecisions.containsKey(currencyId)) {
            return this.currencyPrecisions.get(currencyId);
        }
        int precision = 2;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FPrecision from T_BD_Currency where FID = ?", (Object[])new String[]{currencyId});
            if (rs.next()) {
                precision = rs.getInt("FPrecision");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.currencyPrecisions.put(currencyId, precision);
        return precision;
    }

    protected String[] buildAssData(final Map<String, Integer> aatIndexs, Map<String, Object> rowset, String idField, String ngField, String dgField, boolean showType, boolean showNumber, boolean showName, boolean showLongName) throws SQLException {
        int i;
        String assGrpId = (String)rowset.get(idField);
        if (assGrpId == null || assGrpId.length() == 0) {
            return new String[0];
        }
        List<String[]> ngs = this.splitNumberGroup((String)rowset.get(ngField));
        if (ngs == null) {
            return new String[]{"NumberGroupError:" + assGrpId};
        }
        if (showLongName) {
            List<String[]> dgs = this.splitDisplayNameGroup((String)rowset.get(dgField));
            if (dgs == null || dgs.size() != ngs.size()) {
                return new String[]{"DisplayNameGroupError:" + assGrpId};
            }
            for (i = 0; i < ngs.size(); ++i) {
                ngs.get((int)i)[3] = dgs.get(i)[2];
            }
        }
        if (ngs.size() > 1 && aatIndexs != null && aatIndexs.size() > 0) {
            Collections.sort(ngs, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    Integer index2;
                    Integer index1 = (Integer)aatIndexs.get(o1[0]);
                    if (index1 == null) {
                        index1 = 99;
                    }
                    if ((index2 = (Integer)aatIndexs.get(o2[0])) == null) {
                        index2 = 99;
                    }
                    return index1 - index2;
                }
            });
        }
        String[] result = new String[ngs.size()];
        for (i = 0; i < ngs.size(); ++i) {
            String string = result[i] = showNumber ? ngs.get(i)[2] : "";
            if (showName || showLongName) {
                if (result[i].length() > 0) {
                    int n = i;
                    result[n] = result[n] + " ";
                }
                int n = i;
                result[n] = result[n] + ngs.get(i)[3];
            }
            if (!showType) continue;
            result[i] = ngs.get(i)[1] + ":" + result[i];
        }
        return result;
    }

    protected String[] buildAssData(final Map<String, Integer> aatIndexs, ResultSet rowset, String idField, String ngField, String dgField, boolean showType, boolean showNumber, boolean showName, boolean showLongName) throws SQLException {
        int i;
        String assGrpId = rowset.getString(idField);
        if (assGrpId == null || assGrpId.length() == 0) {
            return new String[0];
        }
        List<String[]> ngs = this.splitNumberGroup(rowset.getString(ngField));
        if (ngs == null) {
            return new String[]{"NumberGroupError:" + assGrpId};
        }
        if (showLongName) {
            List<String[]> dgs = this.splitDisplayNameGroup(rowset.getString(dgField));
            if (dgs == null || dgs.size() != ngs.size()) {
                return new String[]{"DisplayNameGroupError:" + assGrpId};
            }
            for (i = 0; i < ngs.size(); ++i) {
                ngs.get((int)i)[3] = dgs.get(i)[2];
            }
        }
        if (ngs.size() > 1 && aatIndexs != null && aatIndexs.size() > 0) {
            Collections.sort(ngs, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    Integer index2;
                    Integer index1 = (Integer)aatIndexs.get(o1[0]);
                    if (index1 == null) {
                        index1 = 99;
                    }
                    if ((index2 = (Integer)aatIndexs.get(o2[0])) == null) {
                        index2 = 99;
                    }
                    return index1 - index2;
                }
            });
        }
        String[] result = new String[ngs.size()];
        for (i = 0; i < ngs.size(); ++i) {
            String string = result[i] = showNumber ? ngs.get(i)[2] : "";
            if (showName || showLongName) {
                if (result[i].length() > 0) {
                    int n = i;
                    result[n] = result[n] + " ";
                }
                int n = i;
                result[n] = result[n] + ngs.get(i)[3];
            }
            if (!showType) continue;
            result[i] = ngs.get(i)[1] + ":" + result[i];
        }
        return result;
    }

    private List<String[]> splitNumberGroup(String numberGroup) {
        if (numberGroup != null && numberGroup.length() > 0) {
            String[] groups = numberGroup.split(";");
            ArrayList<String[]> result = new ArrayList<String[]>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                String[] strs = groups[i].replaceAll("_!", ":").split(":");
                if (strs.length != 4) {
                    return null;
                }
                result.add(strs);
            }
            return result;
        }
        return null;
    }

    private List<String[]> splitDisplayNameGroup(String displayNameGroup) {
        if (displayNameGroup != null && displayNameGroup.length() > 0) {
            String[] groups = displayNameGroup.split(";");
            ArrayList<String[]> result = new ArrayList<String[]>(groups.length);
            for (int i = 0; i < groups.length; ++i) {
                String[] strs = groups[i].replaceAll("_!", ":").split(":");
                if (strs.length != 3) {
                    return null;
                }
                result.add(strs);
            }
            return result;
        }
        return null;
    }

    protected List<AsstActTypeInfo> getAsstActTypes(String asstAccountId, List<AsstActTypeInfo> sorts) throws BOSException {
        List<AsstActTypeInfo> aats;
        if (this.aatss == null) {
            this.aatss = new HashMap<String, List<AsstActTypeInfo>>();
        }
        String key = asstAccountId;
        final HashMap<String, Integer> indexs = new HashMap<String, Integer>();
        if (sorts != null && sorts.size() > 0) {
            for (int i = 0; i < sorts.size(); ++i) {
                key = key + sorts.get(i).getNumber();
                indexs.put(sorts.get(i).getNumber(), i);
            }
        }
        if ((aats = this.aatss.get(key)) != null) {
            return aats;
        }
        AsstActTypeCollection coll = GLAsstAccountUtils.getAsstActTypes(this.ctx, asstAccountId);
        aats = new ArrayList<AsstActTypeInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            aats.add(coll.get(i));
        }
        if (aats.size() > 1 && indexs.size() > 0) {
            Collections.sort(aats, new Comparator<AsstActTypeInfo>(){

                @Override
                public int compare(AsstActTypeInfo o1, AsstActTypeInfo o2) {
                    Integer index2;
                    Integer index1 = (Integer)indexs.get(o1.getNumber());
                    if (index1 == null) {
                        index1 = 99;
                    }
                    if ((index2 = (Integer)indexs.get(o2.getNumber())) == null) {
                        index2 = 99;
                    }
                    return index1 - index2;
                }
            });
        }
        this.aatss.put(key, aats);
        return aats;
    }

    protected String[] buildAssData(List<AsstActTypeInfo> aats, Map<String, String> hg, boolean showType, boolean showNumber, boolean showName, boolean showLongName) {
        String[] asstActs = new String[aats.size()];
        for (int i = 0; i < aats.size(); ++i) {
            AsstActTypeInfo aat = aats.get(i);
            String number = null;
            if (showNumber) {
                if (aat.isUseLongNumber()) {
                    number = hg.get(aat.getNumber() + ".longNumber");
                    if (number == null) {
                        hg.get(aat.getNumber() + ".number");
                    } else {
                        number = number.replace('!', '.');
                    }
                } else {
                    number = hg.get(aat.getNumber() + ".number");
                }
            }
            if (number == null) {
                number = "";
            }
            String name = null;
            if (showLongName) {
                name = hg.get(aat.getNumber() + ".longName");
            } else if (showName) {
                name = hg.get(aat.getNumber() + ".name");
            }
            if (name == null) {
                name = "";
            }
            String asstAct = number.length() > 0 && name.length() > 0 ? number + " " + name : number + name;
            if (showType) {
                asstAct = aat.getName() + ":" + asstAct;
            }
            asstActs[i] = asstAct;
        }
        return asstActs;
    }

    protected Map<String, Object> getBatch() throws BOSException {
        Object param = this.params.get("batchName");
        if (param == null || param.toString().trim().length() == 0) {
            this.appendErr("batchName", "", ResourceBase.getString((String)RESOURCE, (String)"paramBatchNameMissing", (Locale)this.ctx.getLocale()));
            return this.result;
        }
        Object data = this.readJsonFile(param.toString().trim(), (Type)((Object)List.class));
        if (data != null) {
            this.result.put("rows", data);
        }
        return this.result;
    }

    protected String saveTmpFile(Object data) throws BOSException {
        if (data == null) {
            return null;
        }
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir == null) {
            return null;
        }
        File dir = new File(tmpdir);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        dir = new File(tmpdir + File.separator + "gl");
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        File file = null;
        String name = null;
        String prefix = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS_").format(new Date());
        for (int i = 0; i < 1000; ++i) {
            File tmp = new File(tmpdir + File.separator + "gl" + File.separator + prefix + i + ".tmp");
            if (tmp.exists()) continue;
            file = tmp;
            name = prefix + i;
            break;
        }
        if (file == null) {
            return null;
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(data);
            String string = name;
            return string;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected Object readTmpFile(String name) throws BOSException {
        return this.readTmpFile(name, true);
    }

    protected Object readTmpFile(String name, boolean delete) throws BOSException {
        if (name == null || !name.equals(FilenameUtils.normalize((String)name))) {
            return null;
        }
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir == null) {
            return null;
        }
        File dir = new File(tmpdir);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        dir = new File(tmpdir + File.separator + "gl");
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File file = new File(tmpdir + File.separator + "gl" + File.separator + name + ".tmp");
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (delete) {
                file.delete();
            }
        }
    }

    protected String saveJsonFile(Object data) throws BOSException {
        File tmp;
        if (data == null) {
            return null;
        }
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir == null) {
            return null;
        }
        File dir = new File(tmpdir);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        dir = new File(tmpdir + File.separator + "gl");
        if (!dir.exists() || !dir.isDirectory()) {
            dir.mkdir();
        }
        File file = null;
        Object name = null;
        String prefix = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS_").format(new Date());
        for (int i = 0; i < 1000; ++i) {
            tmp = new File(tmpdir + File.separator + "gl" + File.separator + prefix + i + ".tmp");
            if (tmp.exists()) continue;
            file = tmp;
            name = prefix + i;
            break;
        }
        if (file == null) {
            return null;
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            JSON.writeJSONString((OutputStream)fos, (Object)data, (SerializerFeature[])new SerializerFeature[0]);
            tmp = name;
            return tmp;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected <T> T readJsonFile(String name, Type clazz) throws BOSException {
        return this.readJsonFile(name, clazz, true);
    }

    protected <T> T readJsonFile(String name, Type clazz, boolean delete) throws BOSException {
        if (name == null || !name.equals(FilenameUtils.normalize((String)name))) {
            return null;
        }
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir == null) {
            return null;
        }
        File dir = new File(tmpdir);
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        dir = new File(tmpdir + File.separator + "gl");
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        File file = new File(tmpdir + File.separator + "gl" + File.separator + name + ".tmp");
        if (!file.exists() || !file.isFile()) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            Object object = JSON.parseObject((InputStream)fis, (Type)clazz, (Feature[])new Feature[0]);
            return (T)object;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            if (delete) {
                file.delete();
            }
        }
    }

    protected Map<String, Object> getPageParams() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.params);
        map.put("pageClass", this.getPageClass());
        map.put("pageId", this.T_TMP_PageTable);
        if (this.debug && this.byPage) {
            map.put("tempTables", this.tempTables);
        }
        return map;
    }

    protected String getPageClass() {
        return null;
    }

    protected Map<String, Object> getPage() throws BOSException {
        Object param = this.params.get("pageName");
        if (param == null || param.toString().trim().length() == 0) {
            this.appendErr("pageName", "", ResourceBase.getString((String)RESOURCE, (String)"paramPageNameMissing", (Locale)this.ctx.getLocale()));
            return this.result;
        }
        Object data = this.readTmpFile(param.toString().trim(), false);
        if (data instanceof Map) {
            Map params = (Map)data;
            params.putAll(this.params);
            Map<String, Object> pageData = this.doGetPage(params);
            if (pageData != null) {
                List rows = (List)pageData.get("rows");
                List errs = (List)pageData.get("errs");
                if (rows != null && rows.size() > 0) {
                    this.result.put("rows", rows);
                }
                if (errs != null && errs.size() > 0) {
                    this.errs.addAll(errs);
                }
            }
        }
        return this.result;
    }

    protected Map<String, Object> doGetPage(Map<String, Object> params) {
        String className = (String)params.get("pageClass");
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                if (GLNRptBasePage.class.isAssignableFrom(clazz)) {
                    GLNRptBasePage page = (GLNRptBasePage)clazz.newInstance();
                    return page.query(this.ctx, params);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new HashMap<String, Object>();
    }

    protected Map<String, Object> release() throws BOSException {
        block8: {
            Object tempTables;
            Object param = this.params.get("pageName");
            if (param == null || param.toString().trim().length() == 0) {
                this.appendErr("pageName", "", ResourceBase.getString((String)RESOURCE, (String)"paramPageNameMissing", (Locale)this.ctx.getLocale()));
                return this.result;
            }
            Object data = this.readTmpFile(param.toString().trim());
            if (!(data instanceof Map)) break block8;
            Map pageParams = (Map)data;
            String pageId = (String)pageParams.get("pageId");
            if (pageId != null) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(pageId);
            }
            if ((tempTables = pageParams.get("tempTables")) != null) {
                if (tempTables instanceof Set) {
                    for (String tempTable : (Set)tempTables) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                    }
                } else if (tempTables instanceof List) {
                    for (String tempTable : (List)tempTables) {
                        TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
                    }
                }
            }
        }
        return this.result;
    }

    public static GLNRptBaseService getService(Context ctx, Map params) {
        Object param = params.get("rptType");
        String dataType = null;
        if (param != null && param.toString().trim().length() > 0) {
            dataType = param.toString().trim();
        }
        if ("AccountBalance".equals(dataType)) {
            return new GLNRptAccountBalanceService(ctx, params);
        }
        if ("AsstActBalance".equals(dataType)) {
            return new GLNRptAsstActBalanceService(ctx, params);
        }
        if ("SubLedger".equals(dataType)) {
            return new GLNRptSubLedgerService(ctx, params);
        }
        if ("AsstactGD".equals(dataType)) {
            return new GLNRptAsstactGDService(ctx, params);
        }
        if ("Cashflow".equals(dataType)) {
            return new CashflowTableService(ctx, params);
        }
        return new GLNRptBaseService(ctx, params);
    }

    protected String createTempTable(String createSQL) throws Exception {
        return this.createTempTable(createSQL, true);
    }

    protected String createTempTable(String createSQL, boolean release) throws Exception {
        long start = System.currentTimeMillis();
        String tempTable = TempTablePool.getInstance((Context)this.ctx).createTempTable(createSQL);
        this.logSql(tempTable + ": " + createSQL, null, System.currentTimeMillis() - start);
        if (release) {
            this.tempTables.add(tempTable);
        }
        return tempTable;
    }

    protected IRowSet executeQuery(Context ctx, String sql) throws BOSException {
        return this.executeQuery(ctx, sql, null);
    }

    protected IRowSet executeQuery(Context ctx, String sql, Object[] params) throws BOSException {
        long start = System.currentTimeMillis();
        IRowSet rs = params == null ? DbUtil.executeQuery((Context)ctx, (String)sql) : DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        this.logSql(sql, params, System.currentTimeMillis() - start);
        return rs;
    }

    protected void execute(Context ctx, String sql) throws BOSException {
        this.execute(ctx, sql, null);
    }

    protected void execute(Context ctx, String sql, Object[] params) throws BOSException {
        long start = System.currentTimeMillis();
        if (params == null) {
            DbUtil.execute((Context)ctx, (String)sql);
        } else {
            DbUtil.execute((Context)ctx, (String)sql, (Object[])params);
        }
        this.logSql(sql, params, System.currentTimeMillis() - start);
    }

    protected void logSql(String sql, Object[] params, long time) {
        if (this.debug && this.sqls.size() < this.sqlCount && (time == -1L || time >= this.sqlTime)) {
            this.sqls.add("sql time:" + time + "ms\n" + (params == null ? sql : GLRptSQLUtil.getSqlWithParameters(sql, params)));
        }
    }

    public String getResource(String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)this.ctx.getLocale());
    }

    class CompanyNode {
        CompanyOrgUnitInfo company = null;
        List<CompanyNode> childs = new ArrayList<CompanyNode>(5);

        public CompanyNode() {
        }

        public CompanyNode(CompanyOrgUnitInfo company) {
            this.company = company;
        }

        public boolean isParent(CompanyNode target) {
            return this.company.getLongNumber().startsWith(target.company.getLongNumber() + "!");
        }

        public boolean isChild(CompanyNode target) {
            return target.company.getLongNumber().startsWith(this.company.getLongNumber() + "!");
        }

        public void addChild(CompanyNode node) {
            if (this.childs.size() == 0) {
                this.childs.add(node);
                return;
            }
            boolean found = false;
            for (int i = 0; i < this.childs.size(); ++i) {
                CompanyNode child = this.childs.get(i);
                if (child.isChild(node)) {
                    child.addChild(node);
                    found = true;
                    break;
                }
                if (!child.isParent(node)) continue;
                node.addChild(child);
                this.childs.set(i, node);
                found = true;
                break;
            }
            if (!found) {
                this.childs.add(node);
            }
        }

        public List<CompanyOrgUnitInfo> getBizCompanys() throws BOSException {
            ArrayList<CompanyOrgUnitInfo> companys = new ArrayList<CompanyOrgUnitInfo>();
            if (this.company != null) {
                if (this.company.isIsBizUnit()) {
                    companys.add(this.company);
                } else if (this.childs.size() == 0) {
                    CompanyOrgUnitCollection coll = GLNRptBaseService.this.getChildCompanys(this.company);
                    for (CompanyOrgUnitInfo c : coll) {
                        if (!c.isIsBizUnit()) continue;
                        companys.add(c);
                    }
                }
            }
            for (CompanyNode node : this.childs) {
                companys.addAll(node.getBizCompanys());
            }
            return companys;
        }

        public String toString() {
            if (this.company != null) {
                return this.company.getLongNumber();
            }
            return "";
        }
    }
}

