/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.app.GLAcctAgeUtils;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountAgeCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.app.GLRptAcctAgeIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.GLRptAcctAgePageQuery;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAcctAgeDao
extends AbstractGLRptDao {
    private Logger logger = Logger.getLogger(this.getClass());
    protected Context ctx;
    protected GLRptAccountAgeCondition cond;
    protected AccountAgeParam paramAge;
    private boolean isShowLeft;

    public GLRptAcctAgeDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
        this.ctx = ctx;
    }

    @Override
    public void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptAccountAgeCondition)ev.get("GLFixCondition");
        this.cond.setCtx(this.ctx);
        Object isShowLeftObj = ev.get("isShowLeft");
        if (isShowLeftObj != null && isShowLeftObj instanceof Boolean) {
            this.isShowLeft = (Boolean)isShowLeftObj;
        }
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        String title;
        GLRptSelector selector = new GLRptSelector();
        if (this.cond.getIndexType() == 0 && this.cond.getItems() != null) {
            if (this.isShowLeft) {
                // empty if block
            }
            if (this.cond.isBizCode()) {
                if (this.cond.getItems().size() > 0) {
                    title = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"AnalyzeName", (Locale)this.ctx.getOriginLocale());
                    selector.add(new GLRptField("Taccountid", "Taccountid", "Taccountid", "NVARCHAR(44)", null, -1));
                    selector.add(new GLRptField("T0fnumber", "T0fnumber", "T0fnumber", "NVARCHAR(100)", null, -1));
                    selector.add(new GLRptField("T0fname", "T0fname", "T0fname", "NVARCHAR(100)", title, 100));
                }
            } else {
                HashMap<Integer, GLRptSelector> m = new HashMap<Integer, GLRptSelector>();
                Iterator it = this.cond.getItems().keySet().iterator();
                while (it.hasNext()) {
                    GLRptSelector temp = new GLRptSelector();
                    Map type = (Map)it.next();
                    Integer seq = (Integer)type.get("seq");
                    String typeID = "T" + seq + "F" + type.get("propname") + "ID";
                    String typeNum = "T" + seq + "fnumber";
                    String typeName = "T" + seq + "fname";
                    temp.add(new GLRptField(typeID, typeID, typeID, "NVARCHAR(44)", null, -1));
                    temp.add(new GLRptField(typeNum, typeNum, typeNum, "NVARCHAR(100)", null, -1));
                    temp.add(new GLRptField(typeName, typeName, typeName, "NVARCHAR(100)", (String)type.get("name"), 100));
                    m.put(seq, temp);
                }
                for (int i = 0; i < this.cond.getItems().keySet().size(); ++i) {
                    selector.add((GLRptSelector)m.get(i));
                }
            }
        } else {
            Iterator it = this.cond.getItems().keySet().iterator();
            title = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"84_AccountAgeUI", (Locale)this.ctx.getOriginLocale());
            if (this.cond.isBizCode()) {
                selector.add(new GLRptField("Taccountid", "Taccountid", "Taccountid", "NVARCHAR(44)", null, -1));
                selector.add(new GLRptField("T0fnumber", "T0fnumber", "T0fnumber", "NVARCHAR(100)", null, -1));
                selector.add(new GLRptField("T0fname", "T0fname", "T0fname", "NVARCHAR(100)", title, 100));
            } else {
                while (it.hasNext()) {
                    Map type = (Map)it.next();
                    Integer seq = (Integer)type.get("seq");
                    if (seq != 0) continue;
                    String typeID = "T0F" + type.get("propname") + "ID";
                    selector.add(new GLRptField(typeID, typeID, typeID, "NVARCHAR(44)", null, -1));
                    selector.add(new GLRptField("T0fnumber", "T0fnumber", "T0fnumber", "NVARCHAR(100)", null, -1));
                    selector.add(new GLRptField("T0fname", "T0fname", "T0fname", "NVARCHAR(100)", title, 100));
                }
            }
        }
        String currTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"FCurrName", (Locale)this.ctx.getOriginLocale());
        selector.add(new GLRptField("fcurrid", "fcurrid", "fcurrid", "NVARCHAR(44)", null, -1));
        selector.add(new GLRptField("fcurrname", "fcurrname", "fcurrname", "NVARCHAR(44)", currTitle, 100));
        if (CompanyDisplayModeEnum.enumerate != this.cond.getCompanyDisplayMode()) {
            selector.add(GLRptField.orgUnitID);
            selector.add(GLRptField.orgUnitName);
        }
        if (this.cond.getIndexType() == 1) {
            selector.add(new GLRptField("hgid", "hgid", "hgid", "NVARCHAR(44)", null, -1));
        }
        if (this.isAllCurrency()) {
            selector.add(new GLRptField("currencyPre", "currency.fprecision", "INT", "currencyPre", -1, false));
        }
        selector.add(new GLRptField("FIsTotal", "t.FIsTotal", "FIsTotal", "INT"));
        String amountTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"balance", (Locale)this.ctx.getOriginLocale());
        selector.add(new GLRptField("sumall", "sumall", "sumall", "NUMERIC(29,10)", amountTitle, 100));
        String unSumTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"UNOVERDUE_TOTAL_AMOUNT", (Locale)this.ctx.getOriginLocale());
        selector.add(new GLRptField("sumunoverdue", "sumunoverdue", "sumunoverdue", "NUMERIC(29,10)", unSumTitle, 100));
        String[] dTitle = this.cond.getDaysTitle();
        String sumTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"OVERDUE_TOTAL_AMOUNT", (Locale)this.ctx.getOriginLocale());
        if (this.cond.isShowUnexpired()) {
            String[] udTitle = this.cond.getUnDaysTitle();
            for (int i = 0; i < this.cond.getUnDays().length + 1; ++i) {
                selector.add(new GLRptField("amount" + i, "amount" + i, "amount" + i, "NUMERIC(29,10)", udTitle[i], 100));
            }
            selector.add(new GLRptField("sumoverdue", "sumoverdue", "sumoverdue", "NUMERIC(29,10)", sumTitle, 100));
            int j = 0;
            for (int i = this.cond.getUnDays().length + 1; i < this.cond.getDays().length + this.cond.getUnDays().length + 2; ++i) {
                selector.add(new GLRptField("amount" + i, "amount" + i, "amount" + i, "NUMERIC(29,10)", dTitle[j++], 100));
            }
        } else {
            selector.add(new GLRptField("sumoverdue", "sumoverdue", "sumoverdue", "NUMERIC(29,10)", sumTitle, 100));
            for (int i = 0; i < this.cond.getDays().length + 1; ++i) {
                selector.add(new GLRptField("amount" + i, "amount" + i, "amount" + i, "NUMERIC(29,10)", dTitle[i], 100));
            }
        }
        return selector;
    }

    @Override
    protected boolean isCreateDataTempTable() throws EASBizException, BOSException {
        return true;
    }

    @Override
    public void buildData() throws BOSException, EASBizException {
        this.insertData();
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptAcctAgePageQuery(this.ctx, this.cond, this.paramAge);
    }

    @Override
    public IGLRptIDCreator getGLRptIDCreator(String mainTableAlias, GLRptField field) {
        return new GLRptAcctAgeIDCreator(mainTableAlias, this.getQueryCondition(), this.paramAge.isIsOnlyUnion());
    }

    @Override
    protected int getExpandLevel() {
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            if (this.cond.isDisplayLeafCompany()) {
                return 1;
            }
            return 0;
        }
        return super.getExpandLevel();
    }

    @Override
    protected CurrencyInfo getQueryCurrencyInfo() throws EASBizException, BOSException {
        if (CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString().equals(this.cond.getCurrencyID())) {
            return this.getCompany().getBaseCurrency();
        }
        if (CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString().equals(this.cond.getCurrencyID())) {
            return this.getCompany().getReportCurrency();
        }
        if (!this.cond.isAllCurrency()) {
            return this.getCurrency(this.ctx, this.cond.getCurrencyID());
        }
        return null;
    }

    @Override
    protected void setAmountColScale(GLRptField field, GLRptTableHeadInfo.GLRptTableColumnInfo colInfo) throws EASBizException, BOSException {
        CurrencyInfo currency = this.getQueryCurrencyInfo();
        if (currency != null) {
            colInfo.setScale(currency.getPrecision());
        }
    }

    @Override
    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = new String[][]{this.getTitleRow1(), this.getTitleRow2()};
        return titles;
    }

    @Override
    protected String[] getTitleRow1() throws EASBizException, BOSException {
        GLRptField field;
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        String fieldName = "";
        int len = this.cond.getDays().length;
        String overDueTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"OVERDUE", (Locale)this.ctx.getOriginLocale());
        int unLen = this.cond.getUnDays().length;
        String unOverDueTitle = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.ReportAccountAgeResource", (String)"NOT_IN_ACCOUNTDATE", (Locale)this.ctx.getOriginLocale());
        if (this.cond.isShowUnexpired()) {
            while (it.hasNext()) {
                field = it.next();
                fieldName = field.getName();
                if (fieldName == null) continue;
                if (fieldName.contains("amount")) {
                    if (fieldName.replace("amount", "").compareTo(String.valueOf(unLen + 1)) < 0) {
                        this.setRow1Title(colTitles, new GLRptField("Foverdue", "NVARCHAR(44)", unOverDueTitle, (unLen + 1) * 40, false));
                        continue;
                    }
                    this.setRow1Title(colTitles, new GLRptField("Funoverdue", "NVARCHAR(44)", overDueTitle, (len + 1) * 40, false));
                    continue;
                }
                this.setRow1Title(colTitles, field);
            }
        } else {
            while (it.hasNext()) {
                field = it.next();
                fieldName = field.getName();
                if (fieldName == null) continue;
                if (fieldName.contains("amount")) {
                    this.setRow1Title(colTitles, new GLRptField("Funoverdue", "NVARCHAR(44)", overDueTitle, (len + 1) * 40, false));
                    continue;
                }
                this.setRow1Title(colTitles, field);
            }
        }
        this.addSumItemTitle(colTitles);
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    @Override
    protected String[] getTitleRow2() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        String fieldName = "";
        while (it.hasNext()) {
            GLRptField field = it.next();
            fieldName = field.getName();
            if (fieldName == null) continue;
            this.setRow1Title(colTitles, field);
        }
        this.addSumItemTitle(colTitles);
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    @Override
    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws BOSException, EASBizException, SQLException {
        super.toGLRptRowData(rs, rowData);
        if (rs.getBoolean("FIsTotal")) {
            if (this.cond.isSumDC()) {
                String title = rs.getInt("FdebtDC") == 1 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"87_AccountAgeUI", (Locale)this.ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"88_AccountAgeUI", (Locale)this.ctx.getOriginLocale());
                rowData.updateString("accountName", title);
            } else {
                rowData.updateString("fcurrname", rs.getString("fcurrname") + " " + ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"86_AccountAgeUI", (Locale)this.ctx.getOriginLocale()));
            }
            return;
        }
        if (this.cond.getIndexType() == 0 || this.cond.isSumDC()) {
            if (this.cond.isBizCode()) {
                if (this.cond.getItems().size() > 0 && !rs.getString("T0fnumber").equals("")) {
                    rowData.updateString("T0fname", rs.getString("T0fnumber") + " " + rs.getString("T0fname"));
                }
            } else {
                for (int i = 0; i < this.cond.getItems().keySet().size(); ++i) {
                    rowData.updateString("T" + i + "fname", rs.getString("T" + i + "fnumber") + " " + rs.getString("T" + i + "fname"));
                }
            }
        } else {
            rowData.updateString("T0fname", rs.getString("T0fnumber") + " " + rs.getString("T0fname"));
        }
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        this.paramAge = new AccountAgeParam();
        String accountid = this.cond.getSelectAccountID();
        String currencyid = this.cond.getCurrencyID();
        int[] days = this.cond.getDays();
        boolean isShowUmexpired = this.cond.isShowUnexpired();
        int[] undays = new int[]{};
        if (isShowUmexpired) {
            undays = this.cond.getUnDays();
        }
        HashMap hmItems = (HashMap)this.cond.getItems();
        java.util.Date endDate = this.cond.getEndDate();
        java.util.Date historyDate = this.cond.getHistoryDate();
        boolean isIncludeUnPosted = this.cond.isIncludeUnPosted();
        boolean isIncludeInit = this.cond.isIncludeInit();
        boolean isIncludeVerifyVch = this.cond.isIncludeVerifyVch();
        boolean isBizCode = this.cond.isBizCode();
        String companyid = this.cond.getCompany().getId().toString();
        int dateType = this.cond.getDataType();
        int indexType = this.cond.getIndexType();
        Object accountFrom = this.cond.getAccountViewStart();
        Object accountTo = this.cond.getAccountViewEnd();
        CompanyOrgUnitInfo _company = this.cond.getCompany();
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        int companyLevel = 0;
        String curCompanyid = null;
        HashMap otherInfo = null;
        boolean isfirstload = true;
        String accountViewNumber = null;
        String acctTableId = null;
        CompanyOrgUnitInfo curCompany = null;
        if (isIsOnlyUnion) {
            companyid = this.cond.getCompanyIdsStr().replace("(", "").replace(")", "");
            curCompanyid = this.cond.getCompany().getId().toString();
            accountViewNumber = this.cond.getSelectAcctNumber();
            accountid = this.cond.getHgid();
            acctTableId = this.cond.getAccountTableId();
            int displayMode = this.cond.getCompanyDisplayMode().getValue();
            boolean isDisplayLeafCompany = this.cond.isDisplayLeafCompany();
            String hgid = null;
            GLAcctAgeUtils.prepareAccountAgeParam(this.paramAge, this.ctx, _company, isIsOnlyUnion, accountid, currencyid, days, undays, isShowUmexpired, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyid, dateType, indexType, accountFrom, accountTo, companyLevel, curCompanyid, accountViewNumber, otherInfo, acctTableId, isfirstload, isIncludeVerifyVch, isBizCode, historyDate, displayMode, isDisplayLeafCompany, hgid);
            if (isIsOnlyUnion && this.paramAge.isBizCode() && !this.paramAge.isAccountList() && !this.paramAge.isIsfirstload() && !this.paramAge.isDisplayLeafCompany() && this.paramAge.getDisplayMode() == 4 && hmItems.size() != 0) {
                this.paramAge.setBizCode(this.cond.getBizCode());
            }
            this.queryAgeByAcctBalUnion(this.paramAge);
        } else {
            if (indexType == 0) {
                accountid = accountid != null && accountid.indexOf("'") == -1 ? "'" + accountid + "'" : accountid;
                accountViewNumber = this.cond.getSelectAcctNumber();
            } else if (!isBizCode) {
                accountid = this.cond.getHgid();
            }
            curCompany = companyid != null ? GlUtils.getCompanyById(this.ctx, companyid) : _company;
            GLAcctAgeUtils.prepareAccountAgeParam(this.paramAge, this.ctx, curCompany, isIsOnlyUnion, accountid, currencyid, days, undays, isShowUmexpired, hmItems, endDate, isIncludeUnPosted, isIncludeInit, companyid, dateType, indexType, accountFrom, accountTo, companyLevel, curCompanyid, accountViewNumber, otherInfo, acctTableId, isfirstload, isIncludeVerifyVch, isBizCode, historyDate, 0, false, null);
            this.queryAgeByAcctBal(this.paramAge);
        }
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    protected void queryAgeByAcctBalUnion(AccountAgeParam paramAge) throws BOSException, EASBizException {
        if (paramAge.getDays() == null || paramAge.getDays().length < 1) {
            return;
        }
        String maxChar = GlUtils.getMaxChar();
        ArrayList alAcResult = new ArrayList();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int iAdjust;
            con = this.getConnection(paramAge.getCtx());
            GLAcctAgeUtils.dealwith_Param(paramAge);
            int daylen = paramAge.getDaylen();
            int undaylen = paramAge.getUndaylen();
            GLAcctAgeUtils.prepareTempTableCompanyVerifyMode(con, paramAge);
            GLAcctAgeUtils.getSql_ByAcctBal_AmountField(paramAge);
            GLAcctAgeUtils.getSql_ByAcctBal_Param_AlDates(paramAge);
            this.getSql_ByAcctBal_SelectHgJoin(paramAge);
            StringBuffer sqlBizCodeHgid = new StringBuffer();
            if (paramAge.isBizCode() && paramAge.isAccountList()) {
                sqlBizCodeHgid = GLAcctAgeUtils.queryBizCodeHgid(paramAge);
            } else if (paramAge.isAccountBC() && (!paramAge.isAccountBCNoType() || paramAge.isIncludeVerifyVch())) {
                sqlBizCodeHgid = GLAcctAgeUtils.queryBizCodeHgid(paramAge);
            }
            paramAge.setSqlBizCodeHgid(sqlBizCodeHgid);
            if (paramAge.isIncludeVerifyVch()) {
                this.createTempTable_ByBal_AcSum(paramAge);
            } else {
                this.createTempTable_ByAcct_AcSum(paramAge);
            }
            String tempTableHistory = GLAcctAgeUtils.createTempTable4QueryHistory4InTime(paramAge);
            StringBuffer sql0InsertAcTemp = this.getSql_InsertAcTemp(paramAge, false, false);
            StringBuffer sql1NotInit = this.getSql_ByAcctBal_AcNotInit_union(paramAge);
            StringBuffer sql2Init = this.getSql_ByAcctBal_AcInit_union(paramAge);
            StringBuffer sql4VchAdjExchRate = new StringBuffer();
            StringBuffer sql5HistorySql = new StringBuffer();
            sql5HistorySql = paramAge.isInTimeVerify() ? this.getHistorySql4InTime_union(con, paramAge) : this.getHistorySql4NotInTime_union(con, paramAge);
            StringBuffer merge = new StringBuffer();
            merge = this.getSql_ByAcctBal_InsertAcTempUnion(paramAge, sql0InsertAcTemp, sql1NotInit, sql2Init, sql4VchAdjExchRate, sql5HistorySql);
            ArrayList params = new ArrayList();
            SqlParams spp = new SqlParams();
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            String companyID = paramAge.getCurCompanyid();
            index = GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum_union(true, false, paramAge.getAccountid(), paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), ps, params, index, paramAge.getAccountViewNumber(), spp, paramAge.getLastPhaseBeginDate());
            if (paramAge.isIncludeInit()) {
                index = GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum_union(true, true, paramAge.getAccountid(), paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), ps, params, index, paramAge.getAccountViewNumber(), spp, null);
            }
            paramAge.setCurCompanyid(companyID);
            ps.execute();
            ps.close();
            if (paramAge.isIncludeVerifyVch()) {
                this.createTempTable4SumVerify(paramAge);
                StringBuffer sql6VeriSum = this.getSql_ByBal_AcVeriSum(paramAge);
                this.insertIntoTempTable_ByBal_SumVeri(paramAge, con, sql6VeriSum);
                this.createTempTable4SumVerified(paramAge);
                StringBuffer sql7HistorySql4Verified = this.getHistorySql4Verified(paramAge);
                this.insertIntoTempTable_ByBal_SumVerified(paramAge, con, sql7HistorySql4Verified);
                this.updateTempTable_ByBal_SumVeriFromSumVerified_PreInsertLine(paramAge, con);
                this.updateTempTable_ByBal_SumVeriFromSumVerified(paramAge, con);
                this.updateTempTable_ByBal_AcSumFromBal_PreInsertLine(paramAge, con);
                this.updateTempTable_ByBal_AcSumFromSumVeri(paramAge, con);
                if (paramAge.isAddFieldHgid()) {
                    this.calculateSumallSumOverduePre(paramAge, con, ps);
                }
            }
            GLAcctAgeUtils.prepareTempTableAdjExch(paramAge);
            if (paramAge.isGeneralCy()) {
                this.calculateLocalAmt4GeneralCy(con, paramAge);
                this.insertTotalSumLines4GeneralCurency(con, paramAge);
            }
            this.calculateSumallSumOverdue(con, ps, paramAge.getTempTableAcSum(), daylen, true, paramAge);
            this.deleteBalZeroAcFromTempTable(con, ps, paramAge);
            merge = this.getSql_ByAcctBal_LastResult_FromTempAcSum(paramAge);
            this.insertData(merge.toString());
            if (!paramAge.isAccountList() && paramAge.isGeneralCy() && paramAge.isIsfirstload() || paramAge.isIsOnlyUnion()) {
                this.insertAcSum(paramAge);
            }
            if (paramAge.isIsOnlyUnion()) {
                this.insertCompanySum(paramAge);
            }
            if (paramAge.isGeneralCy() && !paramAge.isAccountList() && (iAdjust = this.calculateLocalAmt4Deviation(con, paramAge)) != 0) {
                this.calculateSumallSumOverdue(con, ps, paramAge.getTempTableAcSum(), daylen, true, paramAge);
            }
        }
        catch (SQLException sqle) {
            try {
                this.logger.error((Object)sqle);
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                GLAcctAgeUtils.dropTempTable(paramAge, this.logger);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
        GLAcctAgeUtils.dropTempTable(paramAge, this.logger);
    }

    protected void queryAgeByAcctBal(AccountAgeParam paramAge) throws BOSException, EASBizException {
        if (paramAge.getDays() == null || paramAge.getDays().length < 1) {
            return;
        }
        String maxChar = GlUtils.getMaxChar();
        ArrayList alAcResult = new ArrayList();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            int iAdjust;
            con = this.getConnection(paramAge.getCtx());
            GLAcctAgeUtils.dealwith_Param(paramAge);
            int daylen = paramAge.getDaylen();
            int undaylen = paramAge.getUndaylen();
            GLAcctAgeUtils.prepareTempTableCompanyVerifyMode(con, paramAge);
            GLAcctAgeUtils.getSql_ByAcctBal_AmountField(paramAge);
            GLAcctAgeUtils.getSql_ByAcctBal_Param_AlDates(paramAge);
            this.getSql_ByAcctBal_SelectHgJoin(paramAge);
            StringBuffer sqlBizCodeHgid = new StringBuffer();
            if (paramAge.isBizCode() && paramAge.isAccountList()) {
                sqlBizCodeHgid = GLAcctAgeUtils.queryBizCodeHgid(paramAge);
            } else if (paramAge.isAccountBC() && (!paramAge.isAccountBCNoType() || paramAge.isIncludeVerifyVch())) {
                sqlBizCodeHgid = GLAcctAgeUtils.queryBizCodeHgid(paramAge);
            }
            paramAge.setSqlBizCodeHgid(sqlBizCodeHgid);
            if (paramAge.isIncludeVerifyVch()) {
                this.createTempTable_ByBal_AcSum(paramAge);
            } else {
                this.createTempTable_ByAcct_AcSum(paramAge);
            }
            String tempTableHistory = GLAcctAgeUtils.createTempTable4QueryHistory4InTime(paramAge);
            StringBuffer sql0InsertAcTemp = this.getSql_InsertAcTemp(paramAge, false, false);
            StringBuffer sql1NotInit = this.getSql_ByAcctBal_AcNotInit(paramAge);
            StringBuffer sql2Init = this.getSql_ByAcctBal_AcInit(paramAge);
            StringBuffer sql4VchAdjExchRate = new StringBuffer();
            StringBuffer sql5HistorySql = new StringBuffer();
            sql5HistorySql = paramAge.isInTimeVerify() ? this.getHistorySql4InTime(con, paramAge) : this.getHistorySql4NotInTime(con, paramAge);
            StringBuffer merge = new StringBuffer();
            merge = this.getSql_ByAcctBal_InsertAcTempUnion(paramAge, sql0InsertAcTemp, sql1NotInit, sql2Init, sql4VchAdjExchRate, sql5HistorySql);
            ArrayList params = new ArrayList();
            SqlParams spp = new SqlParams();
            ps = con.prepareStatement(merge.toString());
            int index = 1;
            if (paramAge.isIsOnlyUnion()) {
                String companyID = paramAge.getCurCompanyid();
                if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
                    paramAge.setCurCompanyid(null);
                }
                index = GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(true, false, paramAge.getAccountid(), paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), ps, params, index, paramAge.getAccountViewNumber(), spp, paramAge.getLastPhaseBeginDate());
                if (paramAge.isIncludeInit()) {
                    index = GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(true, true, paramAge.getAccountid(), paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), ps, params, index, paramAge.getAccountViewNumber(), spp, null);
                }
                paramAge.setCurCompanyid(companyID);
            } else {
                index = GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(false, false, null, paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), ps, params, index, null, spp, paramAge.getLastPhaseBeginDate());
                if (paramAge.isIncludeInit()) {
                    index = GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(false, true, null, paramAge, paramAge.getHistoryDate(), paramAge.getAlDates(), ps, params, index, null, spp, null);
                }
            }
            ps.execute();
            ps.close();
            if (paramAge.isIncludeVerifyVch()) {
                this.createTempTable4SumVerify(paramAge);
                StringBuffer sql6VeriSum = this.getSql_ByBal_AcVeriSum(paramAge);
                this.insertIntoTempTable_ByBal_SumVeri(paramAge, con, sql6VeriSum);
                this.createTempTable4SumVerified(paramAge);
                StringBuffer sql7HistorySql4Verified = this.getHistorySql4Verified(paramAge);
                this.insertIntoTempTable_ByBal_SumVerified(paramAge, con, sql7HistorySql4Verified);
                this.updateTempTable_ByBal_SumVeriFromSumVerified_PreInsertLine(paramAge, con);
                this.updateTempTable_ByBal_SumVeriFromSumVerified(paramAge, con);
                this.updateTempTable_ByBal_AcSumFromBal_PreInsertLine(paramAge, con);
                this.updateTempTable_ByBal_AcSumFromSumVeri(paramAge, con);
                if (paramAge.isAddFieldHgid()) {
                    this.calculateSumallSumOverduePre(paramAge, con, ps);
                }
            }
            GLAcctAgeUtils.prepareTempTableAdjExch(paramAge);
            if (paramAge.isGeneralCy()) {
                this.calculateLocalAmt4GeneralCy(con, paramAge);
                this.insertTotalSumLines4GeneralCurency(con, paramAge);
            }
            if (paramAge.isIsOnlyUnion()) {
                this.calculateSumForBizCode(paramAge, con);
                this.deleteFsumcompanyId(paramAge);
            }
            this.calculateSumallSumOverdue(con, ps, paramAge.getTempTableAcSum(), daylen, true, paramAge);
            this.deleteBalZeroAcFromTempTable(con, ps, paramAge);
            if (paramAge.isIsOnlyUnion()) {
                this.calculateSumForBizCode(paramAge, con);
                this.deleteFsumcompanyId(paramAge);
            }
            this.calculateSumallSumOverdue(con, ps, paramAge.getTempTableAcSum(), daylen, true, paramAge);
            this.deleteBalZeroAcFromTempTable(con, ps, paramAge);
            if (paramAge.isGeneralCy() && !paramAge.isAccountList() && (iAdjust = this.calculateLocalAmt4Deviation(con, paramAge)) != 0) {
                this.calculateSumallSumOverdue(con, ps, paramAge.getTempTableAcSum(), daylen, true, paramAge);
            }
            merge.setLength(0);
            merge.append(" ");
            merge = this.getSql_ByAcctBal_LastResult_FromTempAcSum(paramAge);
            this.insertData(merge.toString());
            this.insertTotalSumLines2(con, paramAge);
        }
        catch (SQLException sqle) {
            try {
                this.logger.error((Object)sqle);
                throw new SQLAccessException(sqle);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)con);
                GLAcctAgeUtils.dropTempTable(paramAge, this.logger);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps, (Connection)con);
        GLAcctAgeUtils.dropTempTable(paramAge, this.logger);
    }

    protected void insertCompanySum(AccountAgeParam paramAge2) throws EASBizException, BOSException {
        int j;
        StringBuffer sql = new StringBuffer("select ");
        StringBuffer temp = new StringBuffer();
        if (this.paramAge.isIncludeVerifyVch() && !this.paramAge.isAccountList()) {
            temp.append(this.paramAge.getSqlSelecthgoutsideReal());
        } else {
            temp.append(this.paramAge.getSqlSelecthgoutside());
        }
        if (this.paramAge.isIsOnlyUnion()) {
            sql.append(temp.substring(0, temp.indexOf(",fsumcompanyid")));
        } else {
            sql.append(temp);
        }
        if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(", '").append(this.cond.getCompany().getId().toString()).append("'");
        } else if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(",cp.FParentID ");
        }
        if (temp.indexOf("hgid") > 0) {
            sql.append(",'' hgid");
        }
        sql.append("\r\n ,0 FIsTotal, sum(sumall) sumall,sum(sumunoverdue) sumunoverdue");
        int index = 0;
        if (this.paramAge.isShowUmexpired()) {
            for (j = 0; j <= this.paramAge.getUndaylen(); ++j) {
                sql.append(",sum(amount" + j).append(") amount" + j);
            }
        }
        sql.append(",sum(sumoverdue) sumoverdue");
        for (int i = 0; i <= this.paramAge.getDaylen(); ++i) {
            index = i + j;
            sql.append(",sum(amount" + index).append(") amount" + index);
        }
        sql.append("\r\n from ").append(this.getDataSourceTable().getTableName()).append(" TP ");
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" inner join t_org_company cp on cp.fid = tp.forgunitid ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" where cp.flevel = ? ");
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            sql.append(" where TP.Forgunitid is not null ");
        }
        sql.append(" and TP.FIsTotal = 0 ");
        sql.append(" group by ");
        List lstHgOutSide = this.paramAge.getLstHgOutSide();
        if (!temp.toString().contains("hgid")) {
            lstHgOutSide.remove("hgid");
        }
        lstHgOutSide.remove("fsubcompanyid");
        if (lstHgOutSide.size() > 0) {
            int size = lstHgOutSide.size();
            for (int i = 0; i < size; ++i) {
                if (lstHgOutSide.get(i).toString().contains("fsumcompany")) continue;
                sql.append(lstHgOutSide.get(i) + ",");
            }
            sql.setLength(sql.length() - 1);
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            sql.append(" ,cp.FParentID ");
        }
        if (CompanyDisplayModeEnum.level == this.cond.getCompanyDisplayMode()) {
            int maxLevel;
            for (int i = maxLevel = this.getMaxCompanyLevel(); i > this.getCompany().getLevel(); --i) {
                ArrayList<Integer> sp = new ArrayList<Integer>();
                sp.add(new Integer(i));
                this.insertData(sql.toString(), sp);
            }
        } else if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode() || CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode()) {
            this.insertData(sql.toString());
        }
    }

    protected void insertAcSum(AccountAgeParam paramAge) throws EASBizException, BOSException {
        int j;
        StringBuffer sql = new StringBuffer("select ");
        StringBuffer temp = new StringBuffer();
        if (paramAge.isIncludeVerifyVch() && !paramAge.isAccountList()) {
            temp.append(paramAge.getSqlSelecthgoutsideReal().toString());
        } else {
            temp.append(paramAge.getSqlSelecthgoutside().toString());
        }
        temp.replace(temp.indexOf("fsumcompanyid"), temp.indexOf("fsubcompanyid") + 13, "FOrgUnitID");
        String[] s = temp.toString().split(",");
        for (int i = 0; i < s.length; ++i) {
            if (s[i].contains("curr")) {
                sql.append(s[i]).append(",");
                continue;
            }
            sql.append(" '' as ").append(s[i]).append(",");
        }
        sql.append("\r\n 1 FIsTotal, sum(sumall) sumall,sum(sumunoverdue) sumunoverdue");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sql.append(",sum(amount" + j).append(") amount" + j);
            }
        }
        sql.append(",sum(sumoverdue) sumoverdue");
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            sql.append(",sum(amount" + index).append(") amount" + index);
        }
        sql.append("\r\n from ").append(this.getDataSourceTable().getTableName());
        sql.append(" group by  fcurrid,fcurrname");
        this.insertData(sql.toString());
    }

    protected void createTempTable_ByBal_AcSum(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        String tempTableAcSum = null;
        StringBuffer createTable = new StringBuffer();
        createTable.append("( ");
        if (paramAge.getSqlCreateHgTbl().length() > 0) {
            createTable.append(paramAge.getSqlCreateHgTbl());
        }
        createTable.append(" leftamount numeric(28,10) not null default 0,sumall numeric(28,10) not null default 0");
        createTable.append(",sumunoverdue numeric(28,10) not null default 0,sumoverdue numeric(28,10) not null default 0");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                createTable.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            createTable.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        createTable.append(" )");
        tempTableAcSum = GLAcctAgeUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_age", createTable);
        paramAge.setTempTableAcSum(tempTableAcSum);
    }

    protected void createTempTable_ByAcct_AcSum(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        String tempTableAcSum = null;
        StringBuffer createTable = new StringBuffer();
        createTable.append("( FCUSSENTID varchar (44) NULL,fdc int");
        createTable.append(", leftamount numeric(28,10) not null default 0");
        createTable.append(", sumall numeric(28,10) not null default 0");
        createTable.append(", sumunoverdue numeric(28,10) not null default 0");
        createTable.append(", sumoverdue numeric(28,10) not null default 0");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                createTable.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            createTable.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        createTable.append((paramAge.getSqlCreateHgTbl().length() > 0 ? "," + paramAge.getSqlCreateHgTbl().substring(0, paramAge.getSqlCreateHgTbl().length() - 1) : "") + ")");
        tempTableAcSum = GLAcctAgeUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_age", createTable);
        paramAge.setTempTableAcSum(tempTableAcSum);
    }

    protected StringBuffer getSql_InsertAcTemp(AccountAgeParam paramAge, boolean isInclude3SumOverDue, boolean isUseHgOutSideReal) {
        int j;
        StringBuffer sql = new StringBuffer();
        sql.append(" Insert Into ").append(paramAge.getTempTableAcSum());
        sql.append("( ");
        if (paramAge.isIncludeVerifyVch() && isUseHgOutSideReal) {
            sql.append(paramAge.getSqlSelecthgoutsideReal());
        } else {
            sql.append(paramAge.getSqlSelecthgoutside());
        }
        if (isInclude3SumOverDue) {
            sql.append(",leftamount,sumall");
            sql.append(",sumoverdue");
        }
        sql.append(",sumunoverdue");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sql.append(",sum" + j);
            }
        }
        int index = 0;
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = j + i;
            sql.append(",sum" + index);
        }
        sql.append(") ");
        return sql;
    }

    protected StringBuffer getSql_ByAcctBal_AcNotInit_union(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcNotInit_Select(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcNotInit_From(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcNotInit_Where_union(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectNotInit()).append(paramAge.getSqlFromTable()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereNotInitBalNotZero()).append(paramAge.getSqlGroupby());
        return sql;
    }

    protected StringBuffer getSql_ByAcctBal_AcNotInit(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcNotInit_Select(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcNotInit_From(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcNotInit_Where(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectNotInit()).append(paramAge.getSqlFromTable()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereNotInitBalNotZero()).append(paramAge.getSqlGroupby());
        return sql;
    }

    protected StringBuffer getSql_ByAcctBal_AcInit_union(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcInit_Select(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcInit_From(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcInit_Where_union(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectInit()).append(paramAge.getSqlFromInit()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereInitBalNotZero()).append(paramAge.getSqlGroupby());
        return sql;
    }

    protected StringBuffer getSql_ByAcctBal_AcInit(AccountAgeParam paramAge) {
        StringBuffer sql = new StringBuffer();
        this.getSql_ByAcctBal_AcInit_Select(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcInit_From(paramAge);
        GLAcctAgeUtils.getSql_ByAcctBal_AcInit_Where(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(paramAge.getSqlSelectInit()).append(paramAge.getSqlFromInit()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereInitBalNotZero()).append(paramAge.getSqlGroupby());
        return sql;
    }

    protected void getSql_ByAcctBal_AcInit_Select(AccountAgeParam paramAge) {
        int j;
        StringBuffer sqlSelect = paramAge.getSqlSelectInit();
        StringBuffer sumOnePhase = new StringBuffer(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append("<? and cussent.").append(paramAge.getStrDateType_AC()).append(">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum");
        sqlSelect.append("\r\n sum(case when cussent." + paramAge.getStrDateType_AC() + ">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sumUnOverDue  \r\n");
        if (paramAge.isShowUmexpired()) {
            StringBuffer sumUnOnePhase = new StringBuffer(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append(">? and cussent.").append(paramAge.getStrDateType_AC()).append("<=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum");
            for (j = 0; j < paramAge.getUndaylen(); ++j) {
                if (j == 0) {
                    sqlSelect.append(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append(">=? and cussent.").append(paramAge.getStrDateType_AC()).append("<=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum0 \r\n");
                    continue;
                }
                sqlSelect.append(sumUnOnePhase).append(j).append("  \r\n");
            }
            sqlSelect.append(",sum(case when cussent." + paramAge.getStrDateType_AC() + ">? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum" + j + "\r\n");
            ++j;
        }
        int index = 0;
        sqlSelect.append(sumOnePhase).append(j + " \r\n");
        for (int i = 1; i < paramAge.getDaylen(); ++i) {
            index = i + j;
            sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
        }
        index = paramAge.getDaylen() + j;
        sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
    }

    protected StringBuffer getHistorySql4InTime(Connection con, AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuffer hisAgeTableSql = new StringBuffer();
        String amountField = null;
        amountField = "his.FOroginalAmount";
        String tempTableHistory = paramAge.getTempTableHistory();
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeUtils.checkDbTypeIsOracleDB2(paramAge.getCtx());
        try {
            String sumstr = "";
            sumstr = sumstr + "0 as sumoro";
            StringBuffer querySql = new StringBuffer();
            querySql.append("insert into ").append(tempTableHistory);
            querySql.append("(fcussentid,SUMORO) SELECT distinct cussent.fid fcussentid,");
            querySql.append(sumstr).append(paramAge.getSqlFromTable());
            querySql.append(paramAge.getSqlInnerJoin());
            querySql.append(paramAge.getSqlWhereNotInit());
            ps = con.prepareStatement(querySql.toString());
            Calendar hiscal = Calendar.getInstance();
            hiscal.setTime(paramAge.getHistoryDate());
            hiscal.add(1, 100);
            if (paramAge.isIsOnlyUnion()) {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(true, false, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), paramAge.getLastPhaseBeginDate());
            } else {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(false, false, null, paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), paramAge.getLastPhaseBeginDate());
            }
            ps.execute();
            ps.close();
            querySql.setLength(0);
            querySql.append("insert into ").append(tempTableHistory);
            querySql.append("(fcussentid,SUMORO) SELECT distinct cussent.fid fcussentid,");
            querySql.append(sumstr).append(paramAge.getSqlFromInit());
            querySql.append(paramAge.getSqlInnerJoin());
            querySql.append(paramAge.getSqlWhereInit());
            ps = con.prepareStatement(querySql.toString());
            if (paramAge.isIsOnlyUnion()) {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(true, true, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), null);
            } else {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(false, true, null, paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), null);
            }
            ps.execute();
            ps.close();
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
            Date _dayIndex = new Date(_cal.getTimeInMillis());
            Object _day1 = null;
            Date _day2 = new Date(_cal.getTime().getTime());
            hisAgeTableSql.append("update ").append(tempTableHistory).append(" tmp \r\n");
            hisAgeTableSql.append("set (sumoro) = \r\n");
            hisAgeTableSql.append("(select sumhis.sumoro from \r\n");
            hisAgeTableSql.append("(select his.FCussentIDID,isnull(sum( \r\n");
            hisAgeTableSql.append(amountField);
            hisAgeTableSql.append("),0) as sumoro \r\n");
            hisAgeTableSql.append("from t_gl_acctcussenthistory his  \r\n");
            hisAgeTableSql.append("inner join t_gl_voucher voucher on his.FVeriVchID=voucher.FID  \r\n");
            hisAgeTableSql.append("where 1=1  \r\n");
            if (!paramAge.isIsOnlyUnion()) {
                hisAgeTableSql.append(" and his.fcompanyid = ?  \r\n");
            } else {
                hisAgeTableSql.append(" and his.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
            }
            hisAgeTableSql.append(" and voucher.FBookedDate>? ");
            if (!paramAge.isIncludeUnPosted()) {
                hisAgeTableSql.append(" and voucher.FBizStatus=5 ");
            } else {
                hisAgeTableSql.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            hisAgeTableSql.append("\r\n group by his.fcussentidid  \r\n");
            hisAgeTableSql.append(") sumhis ");
            hisAgeTableSql.append("where sumhis.FCussentIDID=tmp.fcussentid  \r\n");
            hisAgeTableSql.append(")  \r\n");
            ps = con.prepareStatement(hisAgeTableSql.toString());
            int index = 1;
            if (!paramAge.isIsOnlyUnion()) {
                ps.setString(index++, paramAge.getCompanyId());
            }
            ps.setDate(index++, _dayIndex);
            ps.execute();
            ps.close();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps);
        return new StringBuffer();
    }

    protected StringBuffer getHistorySql4InTime_union(Connection con, AccountAgeParam paramAge) throws BOSException, EASBizException {
        StringBuffer hisAgeTableSql = new StringBuffer();
        String amountField = null;
        amountField = "his.FOroginalAmount";
        String tempTableHistory = paramAge.getTempTableHistory();
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeUtils.checkDbTypeIsOracleDB2(paramAge.getCtx());
        try {
            String sumstr = "";
            sumstr = sumstr + "0 as sumoro";
            StringBuffer querySql = new StringBuffer();
            querySql.append("insert into ").append(tempTableHistory);
            querySql.append("(fcussentid,SUMORO) SELECT distinct cussent.fid fcussentid,");
            querySql.append(sumstr).append(paramAge.getSqlFromTable());
            querySql.append(paramAge.getSqlInnerJoin());
            querySql.append(paramAge.getSqlWhereNotInit());
            ps = con.prepareStatement(querySql.toString());
            Calendar hiscal = Calendar.getInstance();
            hiscal.setTime(paramAge.getHistoryDate());
            hiscal.add(1, 100);
            GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum_union(true, false, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), paramAge.getLastPhaseBeginDate());
            ps.execute();
            ps.close();
            querySql.setLength(0);
            querySql.append("insert into ").append(tempTableHistory);
            querySql.append("(fcussentid,SUMORO) SELECT distinct cussent.fid fcussentid,");
            querySql.append(sumstr).append(paramAge.getSqlFromInit());
            querySql.append(paramAge.getSqlInnerJoin());
            querySql.append(paramAge.getSqlWhereInit());
            ps = con.prepareStatement(querySql.toString());
            GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum_union(true, true, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), null);
            ps.execute();
            ps.close();
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
            Date _dayIndex = new Date(_cal.getTimeInMillis());
            Object _day1 = null;
            Date _day2 = new Date(_cal.getTime().getTime());
            hisAgeTableSql.append("update ").append(tempTableHistory).append(" tmp \r\n");
            hisAgeTableSql.append("set (sumoro) = \r\n");
            hisAgeTableSql.append("(select sumhis.sumoro from \r\n");
            hisAgeTableSql.append("(select his.FCussentIDID,isnull(sum( \r\n");
            hisAgeTableSql.append(amountField);
            hisAgeTableSql.append("),0) as sumoro \r\n");
            hisAgeTableSql.append("from t_gl_acctcussenthistory his  \r\n");
            hisAgeTableSql.append("inner join t_gl_voucher voucher on his.FVeriVchID=voucher.FID  \r\n");
            hisAgeTableSql.append("where 1=1  \r\n");
            if (!paramAge.isIsOnlyUnion()) {
                hisAgeTableSql.append(" and his.fcompanyid = ?  \r\n");
            } else {
                hisAgeTableSql.append(" and his.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
            }
            hisAgeTableSql.append(" and voucher.FBookedDate>? ");
            if (!paramAge.isIncludeUnPosted()) {
                hisAgeTableSql.append(" and voucher.FBizStatus=5 ");
            } else {
                hisAgeTableSql.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2 ");
            }
            hisAgeTableSql.append("\r\n group by his.fcussentidid  \r\n");
            hisAgeTableSql.append(") sumhis ");
            hisAgeTableSql.append("where sumhis.FCussentIDID=tmp.fcussentid  \r\n");
            hisAgeTableSql.append(")  \r\n");
            ps = con.prepareStatement(hisAgeTableSql.toString());
            int index = 1;
            if (!paramAge.isIsOnlyUnion()) {
                ps.setString(index++, paramAge.getCompanyId());
            }
            ps.setDate(index++, _dayIndex);
            ps.execute();
            ps.close();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)ps);
        return new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer getHistorySql4NotInTime(Connection con, AccountAgeParam paramAge) throws BOSException, EASBizException {
        String querySql;
        int j;
        StringBuffer historySql = new StringBuffer();
        String tempTableHistory = this.createTempTable4QueryHistory(paramAge);
        String tempTable4SumPhase = this.createTempTable4SumPhase(paramAge);
        String tempTableHistory2 = this.createTempTable4QueryHistory(paramAge);
        String selectHgString = paramAge.getSqlSelecthg().substring(0, paramAge.getSqlSelecthg().length() - 1);
        String sql = "";
        String amountField = "khis.FOroginalAmount";
        String sumstr = "";
        sumstr = sumstr + "0 as sumUnOverDue,";
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sumstr = sumstr + "0 sum" + j + ",";
            }
        }
        int index = 0;
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            sumstr = sumstr + "0 sum" + index + ",";
        }
        String tSql = querySql = "insert into " + tempTableHistory + "\r\n SELECT distinct cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + paramAge.getSqlFromTable() + paramAge.getSqlInnerJoin() + paramAge.getSqlWhereNotInit();
        String querySqlNew = null;
        if (!paramAge.isIsOnlyUnion()) {
            StringBuffer fromInner = new StringBuffer();
            if (paramAge.isAccountList()) {
                fromInner.append(" \r\n inner join t_bd_accountview account on account.fid=cussent.faccountid \r\n");
            }
            if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
                fromInner.append(" \r\n inner join t_bd_Currency currency on cussent.fcurrencyid=currency.fid");
            }
            if (paramAge.isJoinHgTable()) {
                fromInner.append(" \r\n inner join t_bd_assistanthg hg on cussent.fassgrpid=hg.fid \r\n");
            }
            if (paramAge.getSqlBizCodeHgid().length() > 0) {
                fromInner.append("\r\n inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid ");
            }
            String sqlInnerJoin = paramAge.getSqlInnerJoin().toString();
            for (String number : paramAge.getAlAstNumbers()) {
                sqlInnerJoin = sqlInnerJoin.replaceFirst("\\?", "'" + number + "'");
            }
            tSql = querySqlNew = "insert into " + tempTableHistory + "\r\n  SELECT cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + " \r\n  FROM t_gl_acctcussent cussent \r\n" + fromInner + sqlInnerJoin + this.getSqlWhereNotInit(paramAge);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeUtils.checkDbTypeIsOracleDB2(paramAge.getCtx());
        try {
            int i;
            ps = con.prepareStatement(tSql);
            Calendar hiscal = Calendar.getInstance();
            hiscal.setTime(paramAge.getHistoryDate());
            if (paramAge.isIsOnlyUnion()) {
                String companyID = paramAge.getCurCompanyid();
                if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
                    paramAge.setCurCompanyid(null);
                }
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(true, false, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), paramAge.getLastPhaseBeginDate());
                paramAge.setCurCompanyid(companyID);
            } else {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(false, false, null, paramAge, hiscal.getTime(), new ArrayList(), con.prepareStatement(querySql), new ArrayList(), 1, null, new SqlParams(), paramAge.getLastPhaseBeginDate());
            }
            ps.execute();
            ps.close();
            Statement psIndex = null;
            try {
                StringBuffer indexSql = new StringBuffer("create index C").append(tempTableHistory).append(" on ").append(tempTableHistory).append("(").append("fcussentid").append(") ");
                psIndex = con.prepareStatement(indexSql.toString());
                psIndex.execute();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (psIndex != null) {
                        psIndex.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            querySql = "insert into " + tempTableHistory + "\r\n SELECT distinct cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + paramAge.getSqlFromInit() + paramAge.getSqlInnerJoin() + paramAge.getSqlWhereInit();
            ps = con.prepareStatement(querySql);
            if (paramAge.isIsOnlyUnion()) {
                String companyID = paramAge.getCurCompanyid();
                if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
                    paramAge.setCurCompanyid(null);
                }
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(true, true, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), null);
                paramAge.setCurCompanyid(companyID);
            } else {
                GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum(false, true, null, paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), null);
            }
            ps.execute();
            ps.close();
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
            Date _dayIndex = new Date(_cal.getTimeInMillis());
            Date _day1 = null;
            Date _day2 = new Date(_cal.getTime().getTime());
            java.util.Date endDate = paramAge.getEndDate();
            StringBuffer sqlSumUnion = new StringBuffer();
            sqlSumUnion.append("select \r\n");
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _cal = Calendar.getInstance();
                    if (j == 0) {
                        _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                        _day1 = new Date(_cal.getTime().getTime());
                        _cal.add(5, -1 * paramAge.getUndays()[0]);
                        _day2 = new Date(_cal.getTime().getTime());
                        sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                        continue;
                    }
                    if (j == paramAge.getDaylen()) {
                        _cal.set(2949, 0, 1);
                        _day2 = new Date(_cal.getTime().getTime());
                        _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                        _cal.add(5, -1 * paramAge.getUndays()[j - 1]);
                        _day1 = new Date(_cal.getTime().getTime());
                        sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " > to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                        continue;
                    }
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getUndays()[j - 1]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    if (j < paramAge.getUndays().length) {
                        _cal.add(5, -1 * paramAge.getUndays()[j]);
                        _day2 = new Date(_cal.getTime().getTime());
                    }
                    sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " > to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                }
            }
            for (i = 0; i <= paramAge.getDaylen(); ++i) {
                index = i + j;
                _cal = Calendar.getInstance();
                if (i == 0) {
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[0]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _day2 = new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime());
                } else if (i == paramAge.getDaylen()) {
                    _cal.set(1900, 0, 1);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i - 1]);
                    _day2 = new Date(_cal.getTime().getTime());
                } else {
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i - 1]);
                    _day2 = new Date(_cal.getTime().getTime());
                }
                sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " < to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + index + ", \r\n");
            }
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
            _day1 = new Date(_cal.getTime().getTime());
            _cal.add(1, 100);
            _day2 = new Date(_cal.getTime().getTime());
            sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " < to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sumunoverdue, \r\n");
            sqlSumUnion.append("khis.fcussentidid as fcussentidid \r\n");
            sqlSumUnion.append(" from t_gl_acctcussenthistory khis INNER JOIN t_gl_acctcussent ac ON khis.FCussentidID = ac.fid AND khis.fcompanyid = ac.fcompanyid \r\n");
            sqlSumUnion.append(" left outer join " + tempTableHistory + " tmp on tmp.fcussentid = khis.FCussentidID \r\n");
            sqlSumUnion.append(" inner join t_bd_assistanthg hg\ton ac.fassgrpid = hg.fid \r\n");
            if (!paramAge.isIsOnlyUnion() && paramAge.isBizCode() && paramAge.isAccountList()) {
                sqlSumUnion.append(" inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid ");
            }
            if (paramAge.isSetCurrency()) {
                sqlSumUnion.append(" where ac.fcurrencyid = '" + paramAge.getCurrencyid() + "' \r\n");
            }
            if (!paramAge.isIsOnlyUnion() && paramAge.getAccountid() != null) {
                if (paramAge.isAccountList()) {
                    if (paramAge.isBizCode() && !paramAge.isIsOnlyUnion()) {
                        String accountid = paramAge.getAccountid();
                        String[] accountids = accountid == null ? null : accountid.split(",");
                        String id = "";
                        String curCuid = paramAge.getCompany().getCU().getId().toString();
                        if (accountids != null) {
                            for (int i2 = 0; i2 < accountids.length; ++i2) {
                                id = id + "'" + accountids[i2] + "',";
                            }
                            id = id.substring(0, id.length() - 1);
                        }
                        sqlSumUnion.append(" and T_Hgid.bacid in (" + id + ") \r\n");
                    } else if (this.cond.isSumDC()) {
                        sqlSumUnion.append(" and hg.FASSTACCOUNTID in (" + paramAge.getAccountid() + ") \r\n");
                    } else {
                        sqlSumUnion.append(" and ac.fassgrpid in (" + paramAge.getAccountid() + ") \r\n");
                    }
                } else {
                    sqlSumUnion.append(" and ac.faccountid in (" + paramAge.getAccountid() + ") \r\n");
                }
            }
            sqlSumUnion.append(" and ac." + paramAge.getStrDateType_AC() + " is not null \r\n");
            if (!paramAge.isIsOnlyUnion()) {
                sqlSumUnion.append(" and ac.fcompanyid = '" + paramAge.getCompanyId() + "' \r\n");
                sqlSumUnion.append(" and khis.fcompanyid = '" + paramAge.getCompanyId() + "' \r\n");
            } else {
                sqlSumUnion.append(" and ac.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
                sqlSumUnion.append(" and khis.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
            }
            sqlSumUnion.append(" and ((khis.fdc IN (0, 2) AND EXISTS \r\n");
            sqlSumUnion.append(" (select 1 from t_gl_voucher voucher \r\n");
            sqlSumUnion.append(" where khis.fverivchid = voucher.fid \r\n");
            sqlSumUnion.append(" and voucher.fbookeddate > to_date('" + this.getFormateDate(_dayIndex) + "') " + paramAge.getSqlWhereHistoryVeriVchBizstas() + ")) \r\n");
            sqlSumUnion.append(" OR (khis.fdc = 1 AND EXISTS \r\n");
            sqlSumUnion.append(" (select 1 from t_gl_acctcussenthistory k2 \r\n");
            sqlSumUnion.append(" where k2.fvoucherasstidid = khis.fcussentidid \r\n");
            sqlSumUnion.append(" and k2.fcussentidid = khis.fvoucherasstidid and k2.fvchdate > to_date('" + this.getFormateDate(_dayIndex) + "'))))\r\n");
            sqlSumUnion.append(" group by khis.fcussentidid");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                sqlSumUnion.append(",tmp.fsumcompanyid");
            }
            sql = "insert into " + tempTable4SumPhase + " select ";
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                sql = sql + " distinct ";
            }
            sql = sql + this.getSumi("t.", "", index, 0) + ", sumunoverdue,t.fcussentidid from (" + sqlSumUnion.toString() + ") t";
            ps = con.prepareStatement(sql);
            ps.execute();
            ps.close();
            sql = "insert into " + tempTableHistory2 + " select t1.fcussentid, t1.fdc, isnull(t2.sumunoverdue, 0), " + this.getSumi("isnull(t2.", ", 0)", index, 0) + ", " + this.preAdd(paramAge.getSqlSelecthgoutside().toString(), "t1.") + " from " + tempTableHistory + " t1 left join " + tempTable4SumPhase + " t2 \r\n on t1.fcussentid = t2.fcussentid";
            ps = con.prepareStatement(sql);
            ps.execute();
            ps.close();
            sumstr = "sumUnOverDue,";
            for (i = 0; i <= index - 1; ++i) {
                sumstr = sumstr + "sum" + i + ",";
            }
            sumstr = sumstr + "sum" + index;
            historySql.append("\r\n union all \r\n SELECT " + (paramAge.getSqlSelecthgoutside().length() > 0 ? paramAge.getSqlSelecthgoutside().toString() + "," : "") + sumstr + " from " + tempTableHistory2);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            InitHelp.dropTempTable(paramAge.getCtx(), tempTableHistory);
            InitHelp.dropTempTable(paramAge.getCtx(), tempTable4SumPhase);
            SQLUtils.cleanup(rs, (Statement)ps);
        }
        return historySql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringBuffer getHistorySql4NotInTime_union(Connection con, AccountAgeParam paramAge) throws BOSException, EASBizException {
        String querySql;
        int j;
        StringBuffer historySql = new StringBuffer();
        String tempTableHistory = this.createTempTable4QueryHistory(paramAge);
        String tempTable4SumPhase = this.createTempTable4SumPhase(paramAge);
        String tempTableHistory2 = this.createTempTable4QueryHistory(paramAge);
        String selectHgString = paramAge.getSqlSelecthg().substring(0, paramAge.getSqlSelecthg().length() - 1);
        String sql = "";
        String amountField = "khis.FOroginalAmount";
        String sumstr = "";
        sumstr = sumstr + "0 as sumUnOverDue,";
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sumstr = sumstr + "0 sum" + j + ",";
            }
        }
        int index = 0;
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            sumstr = sumstr + "0 sum" + index + ",";
        }
        String tSql = querySql = "insert into " + tempTableHistory + "\r\n SELECT distinct cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + paramAge.getSqlFromTable() + paramAge.getSqlInnerJoin() + paramAge.getSqlWhereNotInit();
        Object querySqlNew = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean isDbTypeOracleDB2 = GLAcctAgeUtils.checkDbTypeIsOracleDB2(paramAge.getCtx());
        try {
            int i;
            ps = con.prepareStatement(tSql);
            Calendar hiscal = Calendar.getInstance();
            hiscal.setTime(paramAge.getHistoryDate());
            String companyID = paramAge.getCurCompanyid();
            if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
                paramAge.setCurCompanyid(null);
            }
            GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum_union(true, false, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), paramAge.getLastPhaseBeginDate());
            paramAge.setCurCompanyid(companyID);
            ps.execute();
            ps.close();
            Statement psIndex = null;
            try {
                StringBuffer indexSql = new StringBuffer("create index C").append(tempTableHistory).append(" on ").append(tempTableHistory).append("(").append("fcussentid").append(") ");
                psIndex = con.prepareStatement(indexSql.toString());
                psIndex.execute();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (psIndex != null) {
                        psIndex.close();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            querySql = "insert into " + tempTableHistory + "\r\n SELECT distinct cussent.fid fcussentid,1 fdc," + sumstr + selectHgString + paramAge.getSqlFromInit() + paramAge.getSqlInnerJoin() + paramAge.getSqlWhereInit();
            ps = con.prepareStatement(querySql);
            if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
                paramAge.setCurCompanyid(null);
            }
            GLAcctAgeUtils.setupParams_ByAcctBal_InsertSum_union(true, true, paramAge.getAccountid(), paramAge, hiscal.getTime(), new ArrayList(), ps, new ArrayList(), 1, null, new SqlParams(), null);
            paramAge.setCurCompanyid(companyID);
            ps.execute();
            ps.close();
            Calendar _cal = Calendar.getInstance();
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)paramAge.getHistoryDate()));
            Date _dayIndex = new Date(_cal.getTimeInMillis());
            Date _day1 = null;
            Date _day2 = new Date(_cal.getTime().getTime());
            java.util.Date endDate = paramAge.getEndDate();
            StringBuffer sqlSumUnion = new StringBuffer();
            sqlSumUnion.append("select \r\n");
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _cal = Calendar.getInstance();
                    if (j == 0) {
                        _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                        _day1 = new Date(_cal.getTime().getTime());
                        _cal.add(5, -1 * paramAge.getUndays()[0]);
                        _day2 = new Date(_cal.getTime().getTime());
                        sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                        continue;
                    }
                    if (j == paramAge.getDaylen()) {
                        _cal.set(2949, 0, 1);
                        _day2 = new Date(_cal.getTime().getTime());
                        _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                        _cal.add(5, -1 * paramAge.getUndays()[j - 1]);
                        _day1 = new Date(_cal.getTime().getTime());
                        sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " > to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                        continue;
                    }
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getUndays()[j - 1]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    if (j < paramAge.getUndays().length) {
                        _cal.add(5, -1 * paramAge.getUndays()[j]);
                        _day2 = new Date(_cal.getTime().getTime());
                    }
                    sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " > to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " <= to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + j + ", \r\n");
                }
            }
            for (i = 0; i <= paramAge.getDaylen(); ++i) {
                index = i + j;
                _cal = Calendar.getInstance();
                if (i == 0) {
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[0]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _day2 = new Date(DateTimeUtils.truncateDate((java.util.Date)endDate).getTime());
                } else if (i == paramAge.getDaylen()) {
                    _cal.set(1900, 0, 1);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i - 1]);
                    _day2 = new Date(_cal.getTime().getTime());
                } else {
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i]);
                    _day1 = new Date(_cal.getTime().getTime());
                    _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
                    _cal.add(5, -1 * paramAge.getDays()[i - 1]);
                    _day2 = new Date(_cal.getTime().getTime());
                }
                sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " < to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sum" + index + ", \r\n");
            }
            _cal.setTime(DateTimeUtils.truncateDate((java.util.Date)endDate));
            _day1 = new Date(_cal.getTime().getTime());
            _cal.add(1, 100);
            _day2 = new Date(_cal.getTime().getTime());
            sqlSumUnion.append("sum(case when ac." + paramAge.getStrDateType_AC() + " >= to_date('" + this.getFormateDate(_day1) + "')  and ac." + paramAge.getStrDateType_AC() + " < to_date('" + this.getFormateDate(_day2) + "')  then " + amountField + " else 0 end) as sumunoverdue, \r\n");
            sqlSumUnion.append("khis.fcussentidid as fcussentidid \r\n");
            sqlSumUnion.append(" from t_gl_acctcussenthistory khis INNER JOIN t_gl_acctcussent ac ON khis.FCussentidID = ac.fid AND khis.fcompanyid = ac.fcompanyid \r\n");
            sqlSumUnion.append(" inner join " + tempTableHistory + " tmp on tmp.fcussentid = khis.FCussentidID \r\n");
            if (!paramAge.isIsOnlyUnion() && paramAge.isBizCode() && paramAge.isAccountList()) {
                sqlSumUnion.append(" inner join t_bd_assistanthg hg\ton ac.fassgrpid = hg.fid \r\n");
                sqlSumUnion.append(" inner join ").append(paramAge.getSqlBizCodeHgid()).append(" on hg.fid = T_Hgid.fid ");
            }
            if (paramAge.isSetCurrency()) {
                sqlSumUnion.append(" where ac.fcurrencyid = '" + paramAge.getCurrencyid() + "' \r\n");
            }
            sqlSumUnion.append(" and ac." + paramAge.getStrDateType_AC() + " is not null \r\n");
            sqlSumUnion.append(" and ac.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
            sqlSumUnion.append(" and khis.fcompanyid in ( ").append(paramAge.getCompanyId()).append(" )  \r\n");
            sqlSumUnion.append(" and ((khis.fdc IN (0, 2) AND EXISTS \r\n");
            sqlSumUnion.append(" (select 1 from t_gl_voucher voucher \r\n");
            sqlSumUnion.append(" where khis.fverivchid = voucher.fid \r\n");
            sqlSumUnion.append(" and voucher.fbookeddate > to_date('" + this.getFormateDate(_dayIndex) + "') " + paramAge.getSqlWhereHistoryVeriVchBizstas() + ")) \r\n");
            sqlSumUnion.append(" OR (khis.fdc = 1 AND EXISTS \r\n");
            sqlSumUnion.append(" (select 1 from t_gl_acctcussenthistory k2 \r\n");
            sqlSumUnion.append(" where k2.fvoucherasstidid = khis.fcussentidid \r\n");
            sqlSumUnion.append(" and k2.fcussentidid = khis.fvoucherasstidid and k2.fvchdate > to_date('" + this.getFormateDate(_dayIndex) + "'))))\r\n");
            sqlSumUnion.append(" group by khis.fcussentidid");
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                sqlSumUnion.append(",tmp.fsumcompanyid");
            }
            sql = "insert into " + tempTable4SumPhase + " select ";
            if (paramAge.getDisplayMode() == 4 && paramAge.isDisplayLeafCompany()) {
                sql = sql + " distinct ";
            }
            sql = sql + this.getSumi("t.", "", index, 0) + ", sumunoverdue,t.fcussentidid from (" + sqlSumUnion.toString() + ") t";
            ps = con.prepareStatement(sql);
            ps.execute();
            ps.close();
            sql = "insert into " + tempTableHistory2 + " select t1.fcussentid, t1.fdc, isnull(t2.sumunoverdue, 0), " + this.getSumi("isnull(t2.", ", 0)", index, 0) + ", " + this.preAdd(paramAge.getSqlSelecthgoutside().toString(), "t1.") + " from " + tempTableHistory + " t1 left join " + tempTable4SumPhase + " t2 \r\n on t1.fcussentid = t2.fcussentid";
            ps = con.prepareStatement(sql);
            ps.execute();
            ps.close();
            sumstr = "sumUnOverDue,";
            for (i = 0; i <= index - 1; ++i) {
                sumstr = sumstr + "sum" + i + ",";
            }
            sumstr = sumstr + "sum" + index;
            historySql.append("\r\n union all \r\n SELECT " + (paramAge.getSqlSelecthgoutside().length() > 0 ? paramAge.getSqlSelecthgoutside().toString() + "," : "") + sumstr + " from " + tempTableHistory2);
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            InitHelp.dropTempTable(paramAge.getCtx(), tempTableHistory);
            InitHelp.dropTempTable(paramAge.getCtx(), tempTable4SumPhase);
            SQLUtils.cleanup(rs, (Statement)ps);
        }
        return historySql;
    }

    protected StringBuffer getSql_ByAcctBal_InsertAcTempUnion(AccountAgeParam paramAge, StringBuffer sql0InsertAcTemp, StringBuffer sql1NotInit, StringBuffer sql2Init, StringBuffer sql4VchAdjExchRate, StringBuffer sql5HistorySql) {
        int i;
        int j;
        StringBuffer merge = new StringBuffer();
        merge.append(sql0InsertAcTemp);
        StringBuffer sum = new StringBuffer();
        StringBuffer orderby = new StringBuffer();
        sum.append("isnull(sum(sumunoverdue),0) as sumunoverdue ");
        String _whereCause = "t.sum0";
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sum.append(",isnull(sum(sum" + j + "),0) as sum" + j);
                if (j == 0) continue;
                _whereCause = _whereCause + "+t.sum" + j;
            }
        }
        int index = 0;
        for (i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = i + j;
            sum.append(",isnull(sum(sum" + index + "),0) as sum" + index);
            if (i == 0) continue;
            _whereCause = _whereCause + "+t.sum" + index;
        }
        for (i = 0; i < paramAge.getAlAstTables().size(); ++i) {
            String numkey = "T" + i + "fnumber";
            String namekey = "T" + i + "fname";
            if (paramAge.isAccountList() && i != 0) continue;
            orderby.append(numkey).append(",");
        }
        merge.append("\r\n select ").append(paramAge.getSqlSelecthgoutside()).append(",").append(sum).append("\r\n from (\r\n").append(sql1NotInit);
        if (paramAge.isIncludeInit()) {
            merge.append("\r\n union all \r\n").append(sql2Init);
        }
        merge.append(sql5HistorySql);
        merge.append("\r\n ) t   group by " + paramAge.getSqlSelecthgoutside() + " ");
        if (!paramAge.isIsOnlyUnion()) {
            StringBuffer orderbyCurr = new StringBuffer("\r\n order by fcurrid,fcurrname ");
            if (orderby.length() > 0) {
                orderbyCurr.append(",").append(orderby.lastIndexOf(",") > 0 ? orderby.substring(0, orderby.length() - 1) : orderby);
            }
            if (paramAge.isAccountList() || paramAge.isAllCurr()) {
                merge.append(orderbyCurr);
            }
            paramAge.setSqlOrderby(orderbyCurr);
        } else {
            StringBuffer orderby1 = new StringBuffer("\r\n order by ");
            if (paramAge.isAccountList() || paramAge.isAllCurr()) {
                orderby1.append(" fcurrid,fcurrname,");
            }
            if (paramAge.isAccountList()) {
                orderby1.append(" hgid,");
            }
            orderby1.append(orderby);
            if (paramAge.isBizCode() && paramAge.isAccountList()) {
                orderby1.append(" Taccountid,fsumcompanylevel,fsumcompanyname");
            } else {
                orderby1.append("fsumcompanylevel,fsumcompanyname");
            }
            merge.append(orderby1);
            paramAge.setSqlOrderby(orderby1);
        }
        return merge;
    }

    protected void createTempTable4SumVerify(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        sql.append(paramAge.getSqlCreateHgTbl());
        sql.append("SumVeri numeric(28,10) not null default 0");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        } else {
            sql.append(",SumVeriUnOverDue numeric(28,10) not null default 0");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        sql.append(")");
        String tempTable = GLAcctAgeUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_age", sql);
        paramAge.setTempTableSumVeri(tempTable);
    }

    protected StringBuffer getSql_ByBal_AcVeriSum(AccountAgeParam paramAge) {
        int j;
        String dateField = paramAge.getStrDateType_AC();
        if (!dateField.equalsIgnoreCase("fenddate")) {
            dateField = "fbizDate";
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer sum = new StringBuffer(" isnull(sum(").append(paramAge.getAmountField_veri()).append("),0) SumVeri  \r\n");
        ArrayList allPhaseDates = GLAcctAgeUtils.getAllPhaseDates(paramAge);
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                if (j == 0) {
                    sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(j * 2)) + "')  and cussent.").append(dateField).append("<=to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(j * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + j + "  \r\n");
                    continue;
                }
                sum.append(",sum(case when cussent.").append(dateField).append(">to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(j * 2)) + "')  and cussent.").append(dateField).append("<=to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(j * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + j + "  \r\n");
            }
        } else {
            sum.append(",sum(CASE WHEN cussent.").append(dateField).append(" >= to_date('" + this.getFormateDate(paramAge.getEndDate()) + "') THEN " + paramAge.getAmountField_veri() + " ELSE 0 END) AS SumVeriUnOverDue   \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(index * 2)) + "') and cussent.").append(dateField).append("<to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(index * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + index + "  \r\n");
        }
        GLAcctAgeUtils.getSql_ByBal_AcVeriSum_From(paramAge);
        GLAcctAgeUtils.getSql_ByBal_AcVeriSum_Where(paramAge);
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(sum).append(paramAge.getSqlFromVeriSum()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereVeriSum()).append(paramAge.getSqlGroupby());
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                sql.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                sql.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
        StringBuffer sqlForSumVeriPositive = paramAge.getSqlForSumVeriPositive();
        sqlForSumVeriPositive.append("select ").append(paramAge.getSqlSelecthg()).append(sum).append(paramAge.getSqlFromVeriSum()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereVeriSum());
        if (paramAge.isBizCode()) {
            sqlForSumVeriPositive.append(" and T_Hgid.bacid = ?");
        } else {
            sqlForSumVeriPositive.append(" and cussent.fassgrpid = ?");
        }
        sqlForSumVeriPositive.append(" and entry.fcurrencyid = ? and ").append(paramAge.getAmountField_veri()).append(">0.0 ").append(paramAge.getSqlGroupby());
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                sqlForSumVeriPositive.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                sqlForSumVeriPositive.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
        StringBuffer sqlForSumVeriNegative = paramAge.getSqlForSumVeriNegative();
        sqlForSumVeriNegative.append("select ").append(paramAge.getSqlSelecthg()).append(sum).append(paramAge.getSqlFromVeriSum()).append(paramAge.getSqlInnerJoin()).append(paramAge.getSqlWhereVeriSum());
        if (paramAge.isBizCode()) {
            sqlForSumVeriNegative.append(" and T_Hgid.bacid = ?");
        } else {
            sqlForSumVeriNegative.append(" and cussent.fassgrpid = ?");
        }
        sqlForSumVeriNegative.append(" and entry.fcurrencyid = ? and ").append(paramAge.getAmountField_veri()).append("<0.0 ").append(paramAge.getSqlGroupby());
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                sqlForSumVeriNegative.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                sqlForSumVeriNegative.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
        return sql;
    }

    protected void insertIntoTempTable_ByBal_SumVeri(AccountAgeParam paramAge, Connection con, StringBuffer sqlSumVeri) throws SQLException {
        int j;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(paramAge.getTempTableSumVeri()).append("\r\n (").append(paramAge.getSqlSelecthgoutside()).append(",SumVeri \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j);
            }
        } else {
            sql.append(",SumVeriUnOverDue \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index);
        }
        sql.append(") ");
        sql.append(sqlSumVeri);
        if (sql.indexOf("'' as Taccountid,") > 0) {
            sql = sql.replace(sql.indexOf("'' as Taccountid,"), sql.indexOf("'' as Taccountid,") + 17, "account.Fid as Taccountid,");
        }
        ps = con.prepareStatement(sql.toString());
        index = 1;
        String companyID = paramAge.getCurCompanyid();
        if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
            paramAge.setCurCompanyid(null);
        }
        index = GLAcctAgeUtils.setupParams_ByBal_InsertSumVeri(paramAge, ps, index, false);
        paramAge.setCurCompanyid(companyID);
        ps.execute();
        ps.close();
    }

    protected String getFormateDate(java.util.Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    protected String getFormateDateByDBType(java.util.Date date, boolean isOracleDB2) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (isOracleDB2) {
            return " to_date('" + format.format(date) + "')";
        }
        return "'" + format.format(date) + "'";
    }

    protected String getSumi(String preStr, String nextStr, int len, int type) {
        StringBuffer sumBuffer = new StringBuffer();
        for (int i = 0; i <= len; ++i) {
            if (type == 0) {
                if (i == len) {
                    sumBuffer.append(preStr + "sum" + i + nextStr);
                    continue;
                }
                sumBuffer.append(preStr + "sum" + i + nextStr + ", ");
                continue;
            }
            if (i == len) {
                sumBuffer.append("sum(" + preStr + "sum" + i + ") sum" + i + nextStr);
                continue;
            }
            sumBuffer.append("sum(" + preStr + "sum" + i + ") sum" + i + nextStr + ", ");
        }
        return sumBuffer.toString();
    }

    protected String preAdd(String des, String pre) {
        StringBuffer add = new StringBuffer();
        String[] dess = des.trim().split(",");
        int len = dess.length;
        for (int i = 0; i < len; ++i) {
            if (i == len - 1) {
                add.append(pre + dess[i] + " as " + dess[i]);
                continue;
            }
            add.append(pre + dess[i] + " as " + dess[i] + ", ");
        }
        return add.toString();
    }

    protected StringBuffer getSqlWhereNotInit(AccountAgeParam paramAge) {
        StringBuffer whereNotInit = new StringBuffer();
        StringBuffer whereCussent = new StringBuffer();
        StringBuffer wherePeriod = new StringBuffer();
        StringBuffer whereVch = new StringBuffer();
        StringBuffer whereAH = new StringBuffer();
        StringBuffer whereCurr = new StringBuffer();
        StringBuffer whereKhis = new StringBuffer();
        whereNotInit.append(" WHERE \r\n");
        whereCussent.append(" cussent.fisinit<>1   \r\n");
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode() && !paramAge.isIsOnlyUnion()) {
                String accountid = paramAge.getAccountid();
                String[] accountids = accountid == null ? null : accountid.split(",");
                String id = "";
                String curCuid = paramAge.getCompany().getCU().getId().toString();
                if (accountids != null) {
                    for (int i = 0; i < accountids.length; ++i) {
                        id = id + "'" + accountids[i] + "',";
                    }
                    id = id.substring(0, id.length() - 1);
                }
                whereAH.append(" and T_Hgid.bacid in (" + id + ") \r\n");
            } else if (this.cond.isSumDC()) {
                whereAH.append(" and hg.FASSTACCOUNTID in (" + paramAge.getAccountid() + ") \r\n");
            } else {
                whereAH.append(" and hg.FID in (" + paramAge.getAccountid() + ") \r\n");
            }
        } else if (paramAge.getAccountViewNumber() == null) {
            whereAH.append(" and cussent.faccountid in (" + paramAge.getAccountid() + ")   \r\n");
        } else if (paramAge.getIndexType() != 0) {
            whereAH.append(" and account.fcompanyid='" + paramAge.getCompanyId() + "'   \r\n");
            whereAH.append(" and account.FAccountTableID='" + paramAge.getAcctTableId() + "'   \r\n");
            whereAH.append(" and account.fnumber like '").append(paramAge.getAccountViewNumber()).append("%'  \r\n");
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereCussent.append(" and cussent.fcompanyid='" + paramAge.getCompanyId() + "'  \r\n");
        }
        if (paramAge.isSetCurrency()) {
            whereCussent.append(" and cussent.fcurrencyid='" + paramAge.getCurrencyid() + "'   \r\n");
        }
        wherePeriod.append(" and exists (select 1 from v_gl_acperiod acp where acp.fcompanyid=cussent.fcompanyid and cussent.fperiodid = acp.fperiodid)  \r\n");
        whereVch.append(" and exists (select 1 from t_gl_voucher voucher where cussent.fvoucherid = voucher.fid \r\n");
        if (paramAge.isIncludeVerifyVch()) {
            whereVch.append(" and voucher.fbookeddate >= to_date('" + this.getFormateDate(paramAge.getHistoryDate()) + "')   \r\n");
        }
        if (!paramAge.isIsOnlyUnion()) {
            whereVch.append(" and voucher.fcompanyid='" + paramAge.getCompanyId() + "'  \r\n");
        }
        if (!paramAge.isIncludeUnPosted()) {
            whereVch.append(" and voucher.FBizStatus=5  \r\n");
        } else {
            whereVch.append(" and voucher.fbizstatus <> 0 and voucher.fbizstatus<>2   \r\n");
        }
        whereVch.append(" )  \r\n");
        whereKhis.append(" and (cussent.funverifiedamtfor <> 0 or exists (\r\n");
        whereKhis.append(" select 1 from t_gl_acctcussenthistory khis where khis.fcussentidid = cussent.fid \r\n");
        whereKhis.append(" and khis.fverifydate >= to_date('" + this.getFormateDate(paramAge.getHistoryDate()) + "') \r\n");
        whereKhis.append(" and khis.fvchdate <= to_date('" + this.getFormateDate(paramAge.getHistoryDate()) + "') \r\n");
        whereKhis.append("\r\n))");
        whereNotInit.append(whereCussent).append(whereAH).append(wherePeriod).append(whereVch).append(whereKhis);
        return whereNotInit;
    }

    protected String createTempTable4QueryHistory(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        String tempateTable = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx()).getTableName("gl_temp");
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(tempateTable);
        createTable.append("( FCUSSENTID varchar (44) NOT NULL,fdc int");
        createTable.append(",sumunoverdue numeric(28,10) not null default 0");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                createTable.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            createTable.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        createTable.append((paramAge.getSqlCreateHgTbl().length() > 0 ? "," + paramAge.getSqlCreateHgTbl().substring(0, paramAge.getSqlCreateHgTbl().length() - 1) : "") + ")");
        ITableManagerFacade tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx());
        tableManagerFacade.createTable(createTable.toString());
        paramAge.setTempTableHistory(tempateTable);
        return tempateTable;
    }

    protected String createTempTable4AcSumUnion(Context ctx, int daylen, StringBuffer sqlCreateHgTbl) throws BOSException, EASBizException {
        String tempateTable = null;
        StringBuffer createTable = new StringBuffer();
        createTable.append("( ");
        if (sqlCreateHgTbl.length() > 0) {
            createTable.append(sqlCreateHgTbl);
        }
        createTable.append(" leftamount  decimal(28,10) not null default 0,");
        createTable.append(" SUMALL  decimal(28,10) not null default 0,");
        createTable.append(" SUMUNOVERDUE    decimal(28,10) not null default 0,");
        createTable.append(" SUMOVERDUE  decimal(28,10) not null default 0");
        for (int i = 0; i <= daylen; ++i) {
            createTable.append(",SUM" + i + " decimal(28,10) not null default 0");
        }
        createTable.append(" )");
        tempateTable = GLAcctAgeUtils.createTempTableByDDL(ctx, "gl_act_ageunion", createTable);
        return tempateTable;
    }

    protected void getSql_ByAcctBal_AcNotInit_Select(AccountAgeParam paramAge) {
        int j;
        StringBuffer sqlSelect = paramAge.getSqlSelectNotInit();
        StringBuffer sumOnePhase = new StringBuffer(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append("<? and cussent.").append(paramAge.getStrDateType_AC()).append(">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum");
        sqlSelect.append("\r\n sum(case when cussent." + paramAge.getStrDateType_AC() + ">=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sumUnOverDue  \r\n");
        if (paramAge.isShowUmexpired()) {
            StringBuffer sumUnOnePhase = new StringBuffer(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append(">? and cussent.").append(paramAge.getStrDateType_AC()).append("<=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum");
            for (j = 0; j < paramAge.getUndaylen(); ++j) {
                if (j == 0) {
                    sqlSelect.append(" ,sum(case when cussent.").append(paramAge.getStrDateType_AC()).append(">=? and cussent.").append(paramAge.getStrDateType_AC()).append("<=? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum0   \r\n");
                    continue;
                }
                sqlSelect.append(sumUnOnePhase).append(j).append("  \r\n");
            }
            sqlSelect.append(",sum(case when cussent." + paramAge.getStrDateType_AC() + ">? then ").append(paramAge.getAmountField()).append(" else 0 end) as sum" + j + "\r\n");
            ++j;
        }
        int index = 0;
        sqlSelect.append(sumOnePhase).append(j + " \r\n");
        for (int i = 1; i < paramAge.getDaylen(); ++i) {
            index = i + j;
            sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
        }
        index = paramAge.getDaylen() + j;
        sqlSelect.append(sumOnePhase).append(index).append("  \r\n");
    }

    protected void createTempTable4SumVerified(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        StringBuffer sql = new StringBuffer();
        sql.append("(");
        sql.append(paramAge.getSqlCreateHgTbl());
        sql.append("SumVeri numeric(28,10) not null default 0 ");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j + " numeric(28,10) not null default 0");
            }
        } else {
            sql.append(",SumVeriUnOverDue numeric(28,10) not null default 0 ");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index + " numeric(28,10) not null default 0");
        }
        sql.append(")");
        String tempTable = GLAcctAgeUtils.createTempTableByDDL(paramAge.getCtx(), "gl_act_age", sql);
        paramAge.setTempTableSumVerified(tempTable);
    }

    protected StringBuffer getHistorySql4Verified(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        StringBuffer historySql = new StringBuffer();
        GLAcctAgeUtils.getSql_ByBal_VerifiedSum_NotInit_From(paramAge);
        GLAcctAgeUtils.getSql_ByBal_VerifiedSum_Init_From(paramAge);
        GLAcctAgeUtils.getSql_ByBal_VerifiedSum_NotInit_Where(paramAge);
        GLAcctAgeUtils.getSql_ByBal_VerifiedSum_Init_Where(paramAge);
        String amountField = "khis.FOroginalAmount";
        StringBuffer sum = new StringBuffer("\r\n isnull(sum(" + amountField + "),0) SumVeri  \r\n");
        String dateField = paramAge.getStrDateType_AC();
        if (!dateField.equalsIgnoreCase("fenddate")) {
            dateField = "fbizdate";
        }
        ArrayList allPhaseDates = GLAcctAgeUtils.getAllPhaseDates(paramAge);
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                if (j == 0) {
                    sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(j * 2)) + "') and cussent.").append(dateField).append("<=to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(j * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + j + "  \r\n");
                    continue;
                }
                sum.append(",sum(case when cussent.").append(dateField).append(">to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(j * 2)) + "')  and cussent.").append(dateField).append("<=to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(j * 2 + 1)) + "') then " + paramAge.getAmountField_veri() + " else 0 end) as sum" + j + "  \r\n");
            }
        } else {
            sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + this.getFormateDate(paramAge.getEndDate()) + "') then " + amountField + " else 0 end) as SumVeriUnOverDue  \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sum.append(",sum(case when cussent.").append(dateField).append(">=to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(index * 2)) + "')  and cussent.").append(dateField).append("<to_date('" + this.getFormateDate((java.util.Date)allPhaseDates.get(index * 2 + 1)) + "') then " + amountField + " else 0 end) as sum" + index + "  \r\n");
        }
        StringBuffer sumstr = new StringBuffer("\r\n ,sum(SumVeri) SumVeri  \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sumstr.append(",sum(sum" + j + ") as sum" + j);
            }
        } else {
            sumstr.append("\r\n ,sum(SumVeriUnOverDue) SumVeriUnOverDue  \r\n");
        }
        index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sumstr.append(",sum(sum" + index + ") as sum" + index);
        }
        historySql.append("select ").append(paramAge.getSqlSelecthgoutside()).append(sumstr).append(" from ( \r\n");
        historySql.append("select ").append(paramAge.getSqlSelecthg()).append(sum).append(paramAge.getSqlFromVerifiedSum_NotInit()).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(paramAge.getSqlWhereVerifiedSum_NotInit());
        historySql.append(paramAge.getSqlGroupby()).append(" \r\n");
        if (paramAge.isIncludeInit()) {
            historySql.append("\r\n UNION ALL \r\n");
            historySql.append("select ").append(paramAge.getSqlSelecthg()).append(sum).append(paramAge.getSqlFromVerifiedSum_Init()).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(paramAge.getSqlWhereVerifiedSum_Init()).append(" \r\n");
            historySql.append(paramAge.getSqlGroupby());
        }
        historySql.append("\r\n )t  \r\n");
        historySql.append("group by ").append(paramAge.getSqlSelecthgoutside()).append(" \r\n");
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                historySql.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                historySql.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
        this.getSimulVeriSql(paramAge, sumstr, sum, paramAge.getSqlForSumVerifiedPositive(), ">");
        this.getSimulVeriSql(paramAge, sumstr, sum, paramAge.getSqlForSumVerifiedNegative(), "<");
        return historySql;
    }

    protected void getSimulVeriSql(AccountAgeParam paramAge, StringBuffer sumstr, StringBuffer sum, StringBuffer sql, String moreOrless) {
        sql.append("select ").append(paramAge.getSqlSelecthgoutside()).append(sumstr).append(" from ( \r\n");
        sql.append("select ").append(paramAge.getSqlSelecthg()).append(sum).append(paramAge.getSqlFromVerifiedSum_NotInit()).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(paramAge.getSqlWhereVerifiedSum_NotInit());
        if (paramAge.isBizCode()) {
            sql.append(" and T_Hgid.bacid = ?");
        } else {
            sql.append(" and cussent.fassgrpid = ?");
        }
        sql.append("  and khis.fcurrencyid = ? and ").append(paramAge.getAmountField_veri()).append(moreOrless).append("0.0 ");
        sql.append(paramAge.getSqlGroupby()).append(" \r\n");
        if (paramAge.isIncludeInit()) {
            sql.append("\r\n UNION ALL \r\n");
            sql.append("select ").append(paramAge.getSqlSelecthg()).append(sum).append(paramAge.getSqlFromVerifiedSum_Init()).append(" \r\n").append(paramAge.getSqlInnerJoin()).append(" \r\n").append(paramAge.getSqlWhereVerifiedSum_Init()).append(" \r\n");
            if (paramAge.isBizCode()) {
                sql.append(" and T_Hgid.bacid = ?");
            } else {
                sql.append(" and cussent.fassgrpid = ?");
            }
            sql.append("  and khis.fcurrencyid = ? and ").append(paramAge.getAmountField_veri()).append(moreOrless).append("0.0 ");
            sql.append(paramAge.getSqlGroupby());
        }
        sql.append("\r\n )t  \r\n");
        sql.append("group by ").append(paramAge.getSqlSelecthgoutside()).append(" \r\n");
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode()) {
            if (paramAge.isAccountList()) {
                sql.append(" order by T0fnumber,fsumcompanylevel,fsumcompanyname");
            } else {
                sql.append(" order by hgid,fsumcompanylevel,fsumcompanyname");
            }
        }
    }

    protected String createTempTable4SumPhase(AccountAgeParam paramAge) throws BOSException, EASBizException {
        int j;
        String tempateTable = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx()).getTableName("gl_temp");
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(tempateTable).append("(  \r\n");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                createTable.append("sum" + j + " numeric(28,10) not null default 0, ");
            }
        }
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            createTable.append("sum" + index + " numeric(28,10) not null default 0, ");
        }
        createTable.append("sumunoverdue numeric(28,10) not null default 0, ");
        createTable.append("FCUSSENTID varchar (44) NOT NULL)");
        ITableManagerFacade tableManagerFacade = TableManagerFacadeFactory.getLocalInstance((Context)paramAge.getCtx());
        tableManagerFacade.createTable(createTable.toString());
        return tempateTable;
    }

    protected void insertIntoTempTable_ByBal_SumVerified(AccountAgeParam paramAge, Connection con, StringBuffer sqlSumVeri) throws SQLException {
        int j;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Insert Into ").append(paramAge.getTempTableSumVerified()).append("\r\n (").append(paramAge.getSqlSelecthgoutside()).append(",SumVeri \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sql.append(",sum" + j);
            }
        } else {
            sql.append(",SumVeriUnOverDue \r\n");
        }
        int index = 0;
        for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sql.append(",sum" + index);
        }
        sql.append(") ");
        sql.append(sqlSumVeri);
        ps = con.prepareStatement(sql.toString());
        String companyID = paramAge.getCurCompanyid();
        if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
            paramAge.setCurCompanyid(null);
        }
        index = 1;
        index = GLAcctAgeUtils.setupParams_ByBal_InsertSumVeri(paramAge, ps, index, false);
        Calendar cal = Calendar.getInstance();
        cal.setTime(paramAge.getHistoryDate());
        ps.setDate(index++, new Date(cal.getTimeInMillis()));
        if (paramAge.isIncludeInit()) {
            index = GLAcctAgeUtils.setupParams_ByBal_InsertSumVeri(paramAge, ps, index, true);
            cal.setTime(paramAge.getHistoryDate());
            ps.setDate(index++, new Date(cal.getTimeInMillis()));
        }
        paramAge.setCurCompanyid(companyID);
        ps.execute();
        ps.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTempTable_ByBal_SumVeriFromSumVerified_PreInsertLine(AccountAgeParam paramAge, Connection con) throws SQLException {
        Statement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlInsertFields = new StringBuffer();
        StringBuffer sqlSelectFields = new StringBuffer();
        StringBuffer sqlWhereUpdate = new StringBuffer();
        StringBuffer sqlIndexField = new StringBuffer();
        String keyField2 = "";
        for (String keyField2 : paramAge.getLstHgOutSide()) {
            sqlInsertFields.append(",").append(keyField2);
            sqlSelectFields.append(",").append(" bal.").append(keyField2);
            if (keyField2.indexOf("number") >= 0 || keyField2.indexOf("name") >= 0) continue;
            sqlWhereUpdate.append(" AND bal.").append(keyField2).append(" = tmp.").append(keyField2);
            sqlIndexField.append(keyField2).append(",");
        }
        sqlIndexField.append("SumVeri");
        try {
            sql.setLength(0);
            sql.append("create index I").append(paramAge.getTempTableSumVeri()).append(" on ").append(paramAge.getTempTableSumVeri()).append("(").append(sqlIndexField).append(") ");
            ps = con.prepareStatement(sql.toString());
            ps.execute();
            ps.close();
            sql.setLength(0);
            sql.append("create index I").append(paramAge.getTempTableSumVerified()).append(" on ").append(paramAge.getTempTableSumVerified()).append("(").append(sqlIndexField).append(") ");
            ps = con.prepareStatement(sql.toString());
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        sql.setLength(0);
        sql.append(" Insert Into ").append(paramAge.getTempTableSumVeri());
        sql.append("( ");
        sql.append(sqlInsertFields.substring(1, sqlInsertFields.length()));
        sql.append(") \r\n");
        sql.append(" select ");
        sql.append(sqlSelectFields.substring(1, sqlSelectFields.length()));
        sql.append("\r\n from ").append(paramAge.getTempTableSumVerified()).append(" bal    \r\n");
        sql.append(" left outer join ").append(paramAge.getTempTableSumVeri()).append(" tmp \r\n");
        sql.append(" on ").append(sqlWhereUpdate.substring(4, sqlWhereUpdate.length()));
        sql.append("\r\n Where tmp.fcurrid is null ");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTempTable_ByBal_AcSumFromBal_PreInsertLine(AccountAgeParam paramAge, Connection con) throws SQLException {
        Statement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlInsertFields = new StringBuffer();
        StringBuffer sqlSelectFields = new StringBuffer();
        StringBuffer sqlWhereUpdate = new StringBuffer();
        StringBuffer sqlIndexField = new StringBuffer();
        String keyField2 = "";
        for (String keyField2 : paramAge.getLstHgOutSide()) {
            sqlInsertFields.append(",").append(keyField2);
            sqlSelectFields.append(",").append(" bal.").append(keyField2);
            if (keyField2.indexOf("number") >= 0 || keyField2.indexOf("name") >= 0) continue;
            sqlWhereUpdate.append(" AND bal.").append(keyField2).append(" = tmp.").append(keyField2);
            sqlIndexField.append(keyField2).append(",");
        }
        sqlIndexField = GLAcctAgeUtils.truncateStringTailDot(sqlIndexField);
        try {
            sql.setLength(0);
            sql.append("create index I").append(paramAge.getTempTableAcSum()).append(" on ").append(paramAge.getTempTableAcSum()).append("(").append(sqlIndexField).append(") ");
            ps = con.prepareStatement(sql.toString());
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        sql.setLength(0);
        sql.append(" Insert Into ").append(paramAge.getTempTableAcSum());
        sql.append("( ");
        sql.append(sqlInsertFields.substring(1, sqlInsertFields.length()));
        sql.append(") \r\n");
        sql.append(" select ");
        sql.append(sqlSelectFields.substring(1, sqlSelectFields.length()));
        sql.append("\r\n from ").append(paramAge.getTempTableSumVeri()).append(" bal    \r\n");
        sql.append(" left outer join ").append(paramAge.getTempTableAcSum()).append(" tmp \r\n");
        sql.append(" on ").append(sqlWhereUpdate.substring(4, sqlWhereUpdate.length()));
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && paramAge.isAccountList()) {
            sql.append(" and  bal.T0fnumber = tmp.T0fnumber");
        }
        sql.append(" \r\n Where tmp.fcurrid is null ");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    protected void updateTempTable_ByBal_AcSumFromSumVeri(AccountAgeParam paramAge, Connection con) throws SQLException {
        int j;
        PreparedStatement ps = null;
        PreparedStatement psVeri = null;
        PreparedStatement psUpdate = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        ResultSet rsVeri = null;
        ResultSet rsAcSum = null;
        StringBuffer sqlWhere = new StringBuffer();
        ArrayList<String> lstParam = new ArrayList<String>();
        int index = 1;
        sql.append(" select * from ").append(paramAge.getTempTableSumVeri());
        sql.append(" where sumVeri <> 0.0 ");
        psVeri = con.prepareStatement(sql.toString());
        rsVeri = psVeri.executeQuery();
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(paramAge.getTempTableAcSum());
        sqlUpdate.append(" set ");
        int im = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sqlUpdate.append("sum" + j).append("=?,");
            }
        }
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            im = i + j;
            sqlUpdate.append("sum" + im).append("=?,");
        }
        sqlUpdate.append("sumUnOverDue = ?");
        String keyField = "";
        sqlWhere.append(" Where 1=1");
        for (int i = 0; i < paramAge.getLstHgOutSide().size(); ++i) {
            keyField = (String)paramAge.getLstHgOutSide().get(i);
            if (keyField.indexOf("number") >= 0 || keyField.indexOf("name") >= 0) continue;
            sqlWhere.append(" AND ");
            sqlWhere.append(keyField).append(" = ?");
        }
        sql.setLength(0);
        sql.append(sqlUpdate);
        if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && paramAge.isAccountList()) {
            sqlWhere.append(" and T0fnumber = ?");
        }
        sql.append(sqlWhere);
        psUpdate = con.prepareStatement(sql.toString());
        try {
            int iCountPsUpdate = 0;
            String hgID = null;
            String currID = null;
            while (rsVeri.next()) {
                int i;
                BigDecimal sumVeri = rsVeri.getBigDecimal("SumVeri");
                if (sumVeri.compareTo(GlUtils.zero) == 0) continue;
                lstParam.clear();
                for (int i2 = 0; i2 < paramAge.getLstHgOutSide().size(); ++i2) {
                    keyField = (String)paramAge.getLstHgOutSide().get(i2);
                    if (keyField.indexOf("number") >= 0 || keyField.indexOf("name") >= 0) continue;
                    lstParam.add(rsVeri.getString(keyField));
                }
                sql.setLength(0);
                sql.append("select * from ").append(paramAge.getTempTableAcSum()).append(sqlWhere);
                ps = con.prepareStatement(sql.toString());
                index = 1;
                index = GLAcctAgeUtils.setupParams_updateTempTable_ByBal_AcSumFromSumVeri(ps, index, lstParam);
                if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && paramAge.isAccountList()) {
                    ps.setString(index++, rsVeri.getString("T0fnumber"));
                }
                if (!(rsAcSum = ps.executeQuery()).next()) {
                    SQLUtils.cleanup((ResultSet)rsAcSum, (Statement)ps);
                    continue;
                }
                BigDecimal[] acSum = null;
                BigDecimal[] veriSum = null;
                BigDecimal acSumTotal = GlUtils.zero;
                BigDecimal veriSumTotal = GlUtils.zero;
                BigDecimal sumUnOverDue = rsAcSum.getBigDecimal("sumUnOverDue");
                BigDecimal verisumUnOverDue = null;
                if (paramAge.isShowUmexpired()) {
                    acSum = new BigDecimal[paramAge.getDaylen() + paramAge.getUndaylen() + 2];
                    veriSum = new BigDecimal[paramAge.getDaylen() + paramAge.getUndaylen() + 2];
                    for (i = 0; i < acSum.length; ++i) {
                        acSum[i] = GlUtils.zero;
                        veriSum[i] = GlUtils.zero;
                    }
                    for (i = acSum.length - 1; i >= 0; --i) {
                        if (rsAcSum.getBigDecimal("sum" + i) == null) continue;
                        acSum[i] = rsAcSum.getBigDecimal("sum" + i);
                        acSumTotal = acSumTotal.add(acSum[i]);
                    }
                    for (i = veriSum.length - 1; i >= 0; --i) {
                        if (rsVeri.getBigDecimal("sum" + i) == null) continue;
                        veriSum[i] = rsVeri.getBigDecimal("sum" + i);
                        veriSumTotal = veriSumTotal.add(veriSum[i]);
                    }
                    this.beginToEnd(acSum, paramAge.getUndaylen());
                    this.beginToEnd(veriSum, paramAge.getUndaylen());
                } else {
                    acSum = new BigDecimal[paramAge.getDaylen() + 2];
                    veriSum = new BigDecimal[paramAge.getDaylen() + 2];
                    for (i = 0; i < acSum.length; ++i) {
                        acSum[i] = GlUtils.zero;
                        veriSum[i] = GlUtils.zero;
                    }
                    verisumUnOverDue = rsVeri.getBigDecimal("sumVeriUnOverDue");
                    for (i = acSum.length - 1; i >= 1; --i) {
                        if (rsAcSum.getBigDecimal("sum" + (i - 1)) == null) continue;
                        acSum[i] = rsAcSum.getBigDecimal("sum" + (i - 1));
                        acSumTotal = acSumTotal.add(acSum[i]);
                    }
                    acSum[0] = sumUnOverDue;
                    acSumTotal = acSumTotal.add(acSum[0]);
                    for (i = veriSum.length - 1; i >= 1; --i) {
                        if (rsVeri.getBigDecimal("sum" + (i - 1)) == null) continue;
                        veriSum[i] = rsVeri.getBigDecimal("sum" + (i - 1));
                        veriSumTotal = veriSumTotal.add(veriSum[i]);
                    }
                    veriSum[0] = verisumUnOverDue;
                    veriSumTotal = veriSumTotal.add(veriSum[0]);
                }
                SQLUtils.cleanup((ResultSet)rsAcSum, (Statement)ps);
                hgID = rsVeri.getString("hgid");
                currID = rsVeri.getString("fcurrid");
                acSum = this.simulVeri_New(acSum, veriSum, acSumTotal, veriSumTotal, paramAge, con, hgID, currID);
                if (paramAge.isShowUmexpired()) {
                    this.beginToEnd(acSum, paramAge.getUndaylen());
                } else {
                    sumUnOverDue = acSum[0];
                }
                index = 1;
                if (paramAge.isShowUmexpired()) {
                    for (i = 0; i < acSum.length; ++i) {
                        psUpdate.setBigDecimal(index++, acSum[i]);
                    }
                } else {
                    for (i = 1; i < acSum.length; ++i) {
                        psUpdate.setBigDecimal(index++, acSum[i]);
                    }
                }
                psUpdate.setBigDecimal(index++, sumUnOverDue);
                index = GLAcctAgeUtils.setupParams_updateTempTable_ByBal_AcSumFromSumVeri(psUpdate, index, lstParam);
                if (paramAge.isIsOnlyUnion() && !paramAge.isBizCode() && paramAge.isAccountList()) {
                    psUpdate.setString(index++, rsVeri.getString("T0fnumber"));
                }
                psUpdate.addBatch();
                if (++iCountPsUpdate < 2000) continue;
                iCountPsUpdate = 0;
                psUpdate.executeBatch();
                psUpdate.clearBatch();
            }
            if (iCountPsUpdate > 0) {
                iCountPsUpdate = 0;
                psUpdate.executeBatch();
                psUpdate.clearBatch();
            }
            SQLUtils.cleanup((Statement)psUpdate);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
            SQLUtils.cleanup(rsAcSum, ps);
            SQLUtils.cleanup((Statement)psUpdate);
        }
    }

    protected void beginToEnd(BigDecimal[] decs, int index) {
        BigDecimal temp = null;
        for (int i = 0; i <= index / 2; ++i) {
            temp = decs[i];
            decs[i] = decs[index - i];
            decs[index - i] = temp;
        }
    }

    private BigDecimal[] simulVeri_New(BigDecimal[] acSum, BigDecimal[] veriSum, BigDecimal acSumTotal, BigDecimal veriSumTotal, AccountAgeParam paramAge, Connection con, String hgID, String currID) throws SQLException {
        if (acSumTotal.compareTo(GlUtils.zero) == 0) {
            boolean isAllZero = true;
            int len = acSum.length - 1;
            for (int i = 0; i <= len; ++i) {
                if (acSum[i].compareTo(GlUtils.zero) == 0) continue;
                isAllZero = false;
            }
            if (isAllZero) {
                veriSum = this.reGetVeriData(paramAge, con, hgID, currID, veriSumTotal, veriSum);
                acSum = this.showVerifyAge(acSum, veriSum, acSumTotal, veriSumTotal);
            }
        } else {
            acSum = acSumTotal.compareTo(GlUtils.zero) > 0 && veriSumTotal.compareTo(GlUtils.zero) > 0 && acSumTotal.compareTo(veriSumTotal) < 0 || acSumTotal.compareTo(GlUtils.zero) < 0 && veriSumTotal.compareTo(GlUtils.zero) < 0 && acSumTotal.compareTo(veriSumTotal) > 0 ? this.showVerifyAge(acSum, veriSum, acSumTotal, veriSumTotal) : this.showCussentAge(acSum, veriSum, acSumTotal, veriSumTotal);
        }
        return acSum;
    }

    private BigDecimal[] reGetVeriData(AccountAgeParam paramAge, Connection con, String hgID, String currID, BigDecimal veriSumTotal, BigDecimal[] veriSum) throws SQLException {
        BigDecimal[] tempVeriSum;
        ResultSet rsVerfied;
        ResultSet rsVeri;
        PreparedStatement psVerfied;
        PreparedStatement psVeri;
        block6: {
            BigDecimal[] bigDecimalArray;
            psVeri = null;
            psVerfied = null;
            rsVeri = null;
            rsVerfied = null;
            tempVeriSum = new BigDecimal[]{};
            try {
                if (veriSumTotal.compareTo(GlUtils.zero) > 0) {
                    psVeri = con.prepareStatement(paramAge.getSqlForSumVeriPositive().toString());
                    psVerfied = con.prepareStatement(paramAge.getSqlForSumVerifiedPositive().toString());
                    System.out.println("=====================================\u5927\u4e8e0");
                    System.out.println("=====================================getSqlForSumVeriPositive " + paramAge.getSqlForSumVeriPositive().toString());
                    System.out.println("=====================================getSqlForSumVerifiedPositive " + paramAge.getSqlForSumVerifiedPositive().toString());
                } else {
                    psVeri = con.prepareStatement(paramAge.getSqlForSumVeriNegative().toString());
                    psVerfied = con.prepareStatement(paramAge.getSqlForSumVerifiedNegative().toString());
                    System.out.println("=====================================getSqlForSumVeriNegative " + paramAge.getSqlForSumVeriNegative().toString());
                    System.out.println("=====================================getSqlForSumVerifiedNegative " + paramAge.getSqlForSumVerifiedNegative().toString());
                    System.out.println("=====================================\u5c0f\u4e8e0");
                }
                this.setupParams_ByBal_InsertSumVeriAndSumVeri(paramAge, psVeri, psVerfied, hgID, currID);
                rsVeri = psVeri.executeQuery();
                rsVerfied = psVerfied.executeQuery();
                if (!rsVeri.next()) break block6;
                System.out.println("===================================\u6709\u6838\u9500\u8bb0\u5f55");
                veriSum = this.getVeriData(paramAge, rsVeri, rsVerfied);
                bigDecimalArray = veriSum;
            }
            catch (SQLException e) {
                try {
                    throw e;
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rsVeri, psVeri);
                    SQLUtils.cleanup(rsVerfied, psVerfied);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
            SQLUtils.cleanup((ResultSet)rsVerfied, (Statement)psVerfied);
            return bigDecimalArray;
        }
        SQLUtils.cleanup((ResultSet)rsVeri, (Statement)psVeri);
        SQLUtils.cleanup((ResultSet)rsVerfied, (Statement)psVerfied);
        System.out.println("===================================\u6ca1\u6709\u6838\u9500\u8bb0\u5f55");
        return tempVeriSum;
    }

    private BigDecimal[] showVerifyAge(BigDecimal[] acSum, BigDecimal[] veriSum, BigDecimal acSumTotal, BigDecimal veriSumTotal) {
        this.dealSimulVeri_for_showVerifyAge(veriSum, veriSumTotal);
        BigDecimal veriLeftamount = veriSumTotal.subtract(acSumTotal);
        BigDecimal nagetiveOne = new BigDecimal(-1);
        if (veriLeftamount.compareTo(GlUtils.zero) > 0) {
            int len = veriSum.length - 1;
            for (int i = 0; i <= len; ++i) {
                if (veriSum[i].compareTo(GlUtils.zero) > 0 && veriSum[i].compareTo(veriLeftamount) >= 0) {
                    acSum[i] = veriLeftamount.multiply(nagetiveOne);
                    ++i;
                    while (i <= len) {
                        acSum[i] = GlUtils.zero;
                        ++i;
                    }
                    continue;
                }
                if (veriSum[i].compareTo(GlUtils.zero) > 0 && veriSum[i].compareTo(veriLeftamount) < 0) {
                    acSum[i] = veriSum[i].multiply(nagetiveOne);
                    veriLeftamount = veriLeftamount.subtract(veriSum[i]);
                    continue;
                }
                if (veriSum[i].compareTo(GlUtils.zero) > 0) continue;
                acSum[i] = GlUtils.zero;
            }
        } else {
            int len = veriSum.length - 1;
            for (int i = 0; i <= len; ++i) {
                if (veriSum[i].compareTo(GlUtils.zero) < 0 && veriSum[i].compareTo(veriLeftamount) <= 0) {
                    acSum[i] = veriLeftamount.multiply(nagetiveOne);
                    ++i;
                    while (i <= len) {
                        acSum[i] = GlUtils.zero;
                        ++i;
                    }
                    continue;
                }
                if (veriSum[i].compareTo(GlUtils.zero) < 0 && veriSum[i].compareTo(veriLeftamount) > 0) {
                    acSum[i] = veriSum[i].multiply(nagetiveOne);
                    veriLeftamount = veriLeftamount.subtract(veriSum[i]);
                    continue;
                }
                if (veriSum[i].compareTo(GlUtils.zero) < 0) continue;
                acSum[i] = GlUtils.zero;
            }
        }
        return acSum;
    }

    private BigDecimal[] dealSimulVeri_for_showVerifyAge(BigDecimal[] veriSum, BigDecimal veriSumTotal) {
        BigDecimal oneSideSum = GlUtils.zero;
        if (veriSumTotal.compareTo(GlUtils.zero) > 0) {
            for (int i = veriSum.length - 1; i >= 0; --i) {
                if (veriSum[i].compareTo(GlUtils.zero) >= 0) continue;
                oneSideSum = oneSideSum.add(veriSum[i]);
                veriSum[i] = GlUtils.zero;
            }
        } else {
            for (int i = veriSum.length - 1; i >= 0; --i) {
                if (veriSum[i].compareTo(GlUtils.zero) <= 0) continue;
                oneSideSum = oneSideSum.add(veriSum[i]);
                veriSum[i] = GlUtils.zero;
            }
        }
        veriSum = this.simulVeri_for_showVerifyAge(veriSum, oneSideSum);
        return veriSum;
    }

    /*
     * Enabled aggressive block sorting
     */
    private BigDecimal[] showCussentAge(BigDecimal[] acSum, BigDecimal[] veriSum, BigDecimal acSumTotal, BigDecimal veriSumTotal) {
        if (veriSumTotal.compareTo(GlUtils.zero) > 0) {
            int i = acSum.length - 1;
            while (i >= 0) {
                if (acSum[i].compareTo(GlUtils.zero) != 0) {
                    if (acSum[i].compareTo(GlUtils.zero) <= 0) {
                        acSum[i] = acSum[i].subtract(veriSumTotal);
                        veriSumTotal = GlUtils.zero;
                        return acSum;
                    }
                    if (acSum[i].compareTo(veriSumTotal) > 0) {
                        acSum[i] = acSum[i].subtract(veriSumTotal);
                        veriSumTotal = GlUtils.zero;
                        return acSum;
                    }
                    veriSumTotal = veriSumTotal.subtract(acSum[i]);
                    acSum[i] = GlUtils.zero;
                }
                --i;
            }
            return acSum;
        }
        if (veriSumTotal.compareTo(GlUtils.zero) >= 0) return acSum;
        int i = acSum.length - 1;
        while (i >= 0) {
            if (acSum[i].compareTo(GlUtils.zero) != 0) {
                if (acSum[i].compareTo(GlUtils.zero) > 0) {
                    acSum[i] = acSum[i].subtract(veriSumTotal);
                    veriSumTotal = GlUtils.zero;
                    return acSum;
                }
                if (acSum[i].compareTo(veriSumTotal) <= 0) {
                    acSum[i] = acSum[i].subtract(veriSumTotal);
                    veriSumTotal = GlUtils.zero;
                    return acSum;
                }
                veriSumTotal = veriSumTotal.subtract(acSum[i]);
                acSum[i] = GlUtils.zero;
            }
            --i;
        }
        return acSum;
    }

    protected void setupParams_ByBal_InsertSumVeriAndSumVeri(AccountAgeParam paramAge, PreparedStatement psVeri, PreparedStatement psVerfied, String hgID, String currID) throws SQLException {
        int index = 1;
        String companyID = paramAge.getCurCompanyid();
        if (paramAge.getDisplayMode() == 4 && !paramAge.isDisplayLeafCompany() && !paramAge.isIsfirstload()) {
            paramAge.setCurCompanyid(null);
        }
        HashMap<Integer, String> map1 = new HashMap<Integer, String>();
        index = GLAcctAgeUtils.setupParams_ByBal_InsertSumVeri(paramAge, psVeri, index, false, map1);
        map1.put(index, hgID);
        psVeri.setString(index++, hgID);
        map1.put(index, currID);
        psVeri.setString(index++, currID);
        System.out.println("====================================map1:" + map1);
        HashMap<Integer, Object> map2 = new HashMap<Integer, Object>();
        index = 1;
        index = GLAcctAgeUtils.setupParams_ByBal_InsertSumVeri(paramAge, psVerfied, index, false, map2);
        Calendar cal = Calendar.getInstance();
        cal.setTime(paramAge.getHistoryDate());
        map2.put(index, new Date(cal.getTimeInMillis()));
        psVerfied.setDate(index++, new Date(cal.getTimeInMillis()));
        map2.put(index, hgID);
        psVerfied.setString(index++, hgID);
        map2.put(index, currID);
        psVerfied.setString(index++, currID);
        if (paramAge.isIncludeInit()) {
            index = GLAcctAgeUtils.setupParams_ByBal_InsertSumVeri(paramAge, psVerfied, index, true, map2);
            cal.setTime(paramAge.getHistoryDate());
            map2.put(index, new Date(cal.getTimeInMillis()));
            psVerfied.setDate(index++, new Date(cal.getTimeInMillis()));
            map2.put(index, hgID);
            psVerfied.setString(index++, hgID);
            map2.put(index, currID);
            psVerfied.setString(index++, currID);
        }
        paramAge.setCurCompanyid(companyID);
        System.out.println("====================================map2:" + map2);
    }

    private BigDecimal[] getVeriData(AccountAgeParam paramAge, ResultSet rsVeri, ResultSet rsVerfied) throws SQLException {
        BigDecimal[] veriSum = null;
        if (rsVerfied.next()) {
            System.out.println("================================\u6709\u663e\u793a\u660e\u7ec6\uff0c\u6709\u5df2\u6838\u9500\u8bb0\u5f55");
            if (paramAge.isShowUmexpired()) {
                veriSum = new BigDecimal[paramAge.getDaylen() + paramAge.getUndaylen() + 2];
                for (int i = veriSum.length - 1; i >= 0; --i) {
                    veriSum[i] = (rsVeri.getBigDecimal("sum" + i) != null ? rsVeri.getBigDecimal("sum" + i) : GlUtils.zero).subtract(rsVerfied.getBigDecimal("sum" + i) != null ? rsVerfied.getBigDecimal("sum" + i) : GlUtils.zero);
                }
                this.beginToEnd(veriSum, paramAge.getUndaylen());
            } else {
                System.out.println("================================\u6ca1\u6709\u663e\u793a\u660e\u7ec6\uff0c\u6709\u5df2\u6838\u9500\u8bb0\u5f55");
                veriSum = new BigDecimal[paramAge.getDaylen() + 2];
                for (int i = veriSum.length - 1; i >= 1; --i) {
                    veriSum[i] = (rsVeri.getBigDecimal("sum" + (i - 1)) != null ? rsVeri.getBigDecimal("sum" + (i - 1)) : GlUtils.zero).subtract(rsVerfied.getBigDecimal("sum" + (i - 1)) != null ? rsVerfied.getBigDecimal("sum" + (i - 1)) : GlUtils.zero);
                }
                veriSum[0] = (rsVeri.getBigDecimal("sumVeriUnOverDue") != null ? rsVeri.getBigDecimal("sumVeriUnOverDue") : GlUtils.zero).subtract(rsVerfied.getBigDecimal("sumVeriUnOverDue") != null ? rsVerfied.getBigDecimal("sumVeriUnOverDue") : GlUtils.zero);
            }
        } else if (paramAge.isShowUmexpired()) {
            System.out.println("================================\u6709\u663e\u793a\u660e\u7ec6\uff0c\u6ca1\u6709\u5df2\u6838\u9500\u8bb0\u5f55");
            veriSum = new BigDecimal[paramAge.getDaylen() + paramAge.getUndaylen() + 2];
            for (int i = veriSum.length - 1; i >= 0; --i) {
                veriSum[i] = rsVeri.getBigDecimal("sum" + i) != null ? rsVeri.getBigDecimal("sum" + i) : GlUtils.zero;
            }
            this.beginToEnd(veriSum, paramAge.getUndaylen());
        } else {
            System.out.println("================================\u6ca1\u6709\u663e\u793a\u660e\u7ec6\uff0c\u6ca1\u6709\u5df2\u6838\u9500\u8bb0\u5f55");
            veriSum = new BigDecimal[paramAge.getDaylen() + 2];
            for (int i = veriSum.length - 1; i >= 1; --i) {
                veriSum[i] = rsVeri.getBigDecimal("sum" + (i - 1)) != null ? rsVeri.getBigDecimal("sum" + (i - 1)) : GlUtils.zero;
            }
            veriSum[0] = rsVeri.getBigDecimal("sumVeriUnOverDue") != null ? rsVeri.getBigDecimal("sumVeriUnOverDue") : GlUtils.zero;
        }
        return veriSum;
    }

    private BigDecimal[] simulVeri_for_showVerifyAge(BigDecimal[] veriSum, BigDecimal oneSideSum) {
        int positiveOrNagetive_old = oneSideSum.signum();
        int positiveOrNagetive_new = 0;
        boolean isOver = false;
        for (int i = veriSum.length - 1; i >= 0; --i) {
            if (veriSum[i].compareTo(GlUtils.zero) == 0) continue;
            positiveOrNagetive_new = (oneSideSum = oneSideSum.add(veriSum[i])).signum();
            if (positiveOrNagetive_new != positiveOrNagetive_old) {
                veriSum[i] = oneSideSum;
                isOver = true;
            } else {
                veriSum[i] = GlUtils.zero;
            }
            if (isOver) break;
        }
        return veriSum;
    }

    protected void updateTempTable_ByBal_SumVeriFromSumVerified(AccountAgeParam paramAge, Connection con) throws SQLException {
        int i;
        int j;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlUpdate = new StringBuffer();
        StringBuffer sqlWhereUpdate = new StringBuffer();
        String keyField2 = "";
        for (String keyField2 : paramAge.getLstHgOutSide()) {
            if (keyField2.indexOf("number") >= 0 || keyField2.indexOf("name") >= 0) continue;
            sqlWhereUpdate.append(" AND bal.").append(keyField2).append(" = tmp.").append(keyField2);
        }
        sqlUpdate.setLength(0);
        sqlUpdate.append("update ").append(paramAge.getTempTableSumVeri()).append(" tmp \r\n");
        sqlUpdate.append(" set(SumVeri    \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sqlUpdate.append(",sum" + j);
            }
        } else {
            sqlUpdate.append(",SumVeriUnOverDue   \r\n");
        }
        int index = 0;
        for (i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sqlUpdate.append(",sum" + index);
        }
        sqlUpdate.append(" ) \r\n");
        sqlUpdate.append(" =                \r\n");
        sqlUpdate.append("(select tmp.SumVeri - bal.SumVeri                \r\n");
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                sqlUpdate.append(" ,tmp.sum" + j + "-bal.sum" + j);
            }
        } else {
            sqlUpdate.append(",tmp.SumVeriUnOverDue - bal.SumVeriUnOverDue \r\n");
        }
        index = 0;
        for (i = 0; i < paramAge.getDaylen() + 1; ++i) {
            index = j + i;
            sqlUpdate.append(" ,tmp.sum" + index + "-bal.sum" + index);
        }
        sqlUpdate.append(" from ").append(paramAge.getTempTableSumVerified()).append(" bal \r\n");
        sqlUpdate.append(" where 1=1               \r\n");
        sqlUpdate.append(sqlWhereUpdate).append(" )                \r\n");
        ps = con.prepareStatement(sqlUpdate.toString());
        ps.execute();
        ps.close();
    }

    protected void calculateSumallSumOverduePre(AccountAgeParam paramAge, Connection con, PreparedStatement ps) throws SQLException {
        int i;
        StringBuffer totalSum = new StringBuffer();
        StringBuffer _tempSum = new StringBuffer(",sumunoverdue");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            index = paramAge.getUndaylen() + 1;
        }
        for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
            _tempSum.append(",sum" + i);
        }
        totalSum.append("insert into ").append(paramAge.getTempTableAcSum()).append("  \r\n");
        totalSum.append("(").append(paramAge.getSqlSelecthgoutsideReal()).append(_tempSum);
        totalSum.append(")\r\n");
        _tempSum = new StringBuffer(",sum(sumunoverdue) sumunoverdue");
        for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
            _tempSum.append(",sum(sum" + i + ") as sum" + i);
        }
        totalSum.append(" select ").append(paramAge.getSqlSelecthgoutsideReal()).append(_tempSum).append("  \r\n");
        totalSum.append(" from ").append(paramAge.getTempTableAcSum()).append("  \r\n");
        totalSum.append(" group by ").append(paramAge.getSqlSelecthgoutsideReal());
        ps = con.prepareStatement(totalSum.toString());
        ps.execute();
        ps.close();
        totalSum.setLength(0);
        totalSum.append(" delete from ").append(paramAge.getTempTableAcSum()).append(" where hgid is not null");
        ps = con.prepareStatement(totalSum.toString());
        ps.execute();
        ps.close();
    }

    protected void calculateLocalAmt4GeneralCy(Connection con, AccountAgeParam paramAge) throws SQLException {
        int i;
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        sql.append("Update ").append(paramAge.getTempTableAcSum());
        sql.append(" tmp set (");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            index = paramAge.getUndaylen() + 1;
        }
        for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
            sql.append("sum").append(i);
            sql.append(",");
        }
        sql.append("sumunoverdue");
        sql.append(" )");
        sql.append(" = ");
        sql.append(" ( select ");
        for (i = 0; i <= paramAge.getDaylen() + index; ++i) {
            sql.append("sum").append(i);
            sql.append(" * isnull(tmpExch.FCONVERTRATEA,1)");
            sql.append(",");
        }
        sql.append("sumunoverdue");
        sql.append(" * isnull(tmpExch.FCONVERTRATEA,1)");
        sql.append(" from " + paramAge.getTempTableExchRate() + " tmpExch where tmpExch.fid = tmp.fcurrid  \r\n");
        sql.append(" )");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    protected void insertTotalSumLines4GeneralCurency(Connection con, AccountAgeParam paramAge) throws SQLException {
        String selecthgoutsiderealNoCy;
        StringBuffer sql = new StringBuffer();
        StringBuffer totalSum = new StringBuffer();
        ResultSet rs = null;
        PreparedStatement ps = null;
        int generalCyScale = paramAge.getGeneralCurrency().getPrecision();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        int daylen = paramAge.getDaylen();
        if (paramAge.isAccountList()) {
            int i;
            String sumStr = "";
            String sumStrRound = "";
            int index = 0;
            if (paramAge.isShowUmexpired()) {
                index = paramAge.getUndaylen() + 1;
            }
            for (i = 0; i <= daylen + index; ++i) {
                sumStr = sumStr + "sum" + i + ",";
            }
            for (i = 0; i <= daylen + index; ++i) {
                sumStrRound = sumStrRound + "sum" + i + "=round(sum" + i + "," + generalCyScale + "),";
            }
            sql.setLength(0);
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            sql.append(sumStrRound);
            sql.append("sumunoverdue=round(sumunoverdue," + generalCyScale + "),");
            sql.append("leftamount=round(leftamount," + generalCyScale + "),");
            sql.append("sumall=round(sumall," + generalCyScale + "),");
            sql.append("sumoverdue=round(sumoverdue," + generalCyScale + ")");
            ps = con.prepareStatement(sql.toString());
            ps.execute();
            ps.close();
        }
        totalSum.append("select top 1 1 from ").append(paramAge.getTempTableAcSum());
        ps = con.prepareStatement(totalSum.toString());
        rs = ps.executeQuery();
        if (!rs.next()) {
            rs.close();
            ps.close();
            return;
        }
        rs.close();
        ps.close();
        String selecthgoutsiderealGenCy = selecthgoutsiderealNoCy = paramAge.isIncludeVerifyVch() ? paramAge.getSqlSelecthgoutsideReal().toString().trim() : paramAge.getSqlSelecthgoutside().toString().trim();
        String strCy = "fcurrid,fcurrname,";
        String strGeneralCY = "'" + paramAge.getCurrency().getId().toString() + "' fcurrid,N'" + paramAge.getCurrency().getName() + "' fcurrname";
        int startPosi = selecthgoutsiderealNoCy.indexOf(strCy);
        if (startPosi < 0) {
            strCy = "fcurrid,fcurrname";
            startPosi = selecthgoutsiderealNoCy.indexOf(strCy);
        }
        if (startPosi >= 0) {
            selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.replaceAll(strCy, "");
        }
        strCy = "fcurrid,fcurrname";
        selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.replaceAll(strCy, strGeneralCY);
        if ((selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.trim()).length() > 0 && selecthgoutsiderealNoCy.endsWith(",")) {
            selecthgoutsiderealNoCy = selecthgoutsiderealNoCy.substring(0, selecthgoutsiderealNoCy.length() - 1);
        }
        if ((selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.trim()).length() > 0 && selecthgoutsiderealGenCy.endsWith(",")) {
            selecthgoutsiderealGenCy = selecthgoutsiderealGenCy.substring(0, selecthgoutsiderealGenCy.length() - 1);
        }
        totalSum.setLength(0);
        totalSum.append(this.getSql_InsertAcTemp(paramAge, false, true));
        totalSum.append("\r\n select  ");
        if (selecthgoutsiderealGenCy.length() > 0) {
            totalSum.append(selecthgoutsiderealGenCy).append(",");
        }
        totalSum.append("\r\n sum(sumunoverdue) sumunoverdue");
        StringBuffer _tempSum = new StringBuffer("sum(sum1) sum1");
        int ide = 0;
        if (paramAge.isShowUmexpired()) {
            ide = paramAge.getUndaylen() + 1;
        }
        for (int i = 1; i < paramAge.getDaylen() + ide; ++i) {
            _tempSum.append(",sum(sum" + (i + 1) + ") as sum" + (i + 1));
        }
        totalSum.append("\r\n ,sum(sum0) sum0,").append(_tempSum).append("\r\n from ");
        totalSum.append(paramAge.getTempTableAcSum());
        if (selecthgoutsiderealNoCy.toString().trim().length() > 0) {
            totalSum.append(" group by ").append(selecthgoutsiderealNoCy);
        }
        totalSum.append("\r\n");
        ps = con.prepareStatement(totalSum.toString());
        ps.execute();
        ps.close();
        totalSum.setLength(0);
        totalSum.append("delete from ").append(paramAge.getTempTableAcSum());
        totalSum.append(" where fcurrid <> ? ");
        ps = con.prepareStatement(totalSum.toString());
        int index = 1;
        DbUtil.prepareVarcharParam((PreparedStatement)ps, (int)index++, (String)paramAge.getCurrency().getId().toString());
        ps.execute();
        ps.close();
    }

    protected void calculateSumForBizCode(AccountAgeParam paramAge, Connection conn) throws BOSException, EASBizException {
        String orignalTbl = paramAge.getTempTableAcSum();
        try {
            int j;
            String selectItems = paramAge.getSqlSelecthgoutside().toString().replace(",fsubcompanyid", "");
            if (!paramAge.isAccountList()) {
                selectItems = selectItems.replace(",hgid", "");
            }
            StringBuffer acSelectintoSql = new StringBuffer();
            acSelectintoSql.append("select " + selectItems);
            acSelectintoSql.append(", sum(leftamount) as leftamount,sum(sumall) as  sumall");
            acSelectintoSql.append(",sum(sumunoverdue) as sumunoverdue,sum(sumoverdue) as sumoverdue");
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j < paramAge.getUndaylen() + 1; ++j) {
                    acSelectintoSql.append(",sum(sum" + j + ") as sum" + j + "");
                }
            }
            int index = 0;
            for (int i = 0; i < paramAge.getDaylen() + 1; ++i) {
                index = j + i;
                acSelectintoSql.append(",sum(sum" + index + ") as sum" + index + "");
            }
            acSelectintoSql.append(" into tempTableforAcSum from ");
            acSelectintoSql.append(paramAge.getTempTableAcSum());
            acSelectintoSql.append(" group by ");
            List lstHgOutSide = paramAge.getLstHgOutSide();
            lstHgOutSide.remove("fsubcompanyid");
            int size = lstHgOutSide.size();
            for (int i = 0; i < size; ++i) {
                acSelectintoSql.append(lstHgOutSide.get(i) + ",");
            }
            String acSumNewSql = acSelectintoSql.substring(0, acSelectintoSql.length() - 1);
            String acSumNewtempTable = DBUtil.executeSelectIntoForTempTable((Context)paramAge.getCtx(), (String)acSumNewSql, null, (Connection)conn).getTempTable();
            paramAge.setTempTableAcSum(acSumNewtempTable);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool iPool = TempTablePool.getInstance((Context)paramAge.getCtx());
            if (!StringUtils.isEmpty((String)orignalTbl)) {
                iPool.releaseTable(orignalTbl);
            }
        }
    }

    protected void deleteFsumcompanyId(AccountAgeParam paramAge) {
        if (paramAge.getSqlSelecthgoutside().indexOf(",fsubcompanyid") > 0) {
            paramAge.setSqlSelecthgoutside(new StringBuffer(paramAge.getSqlSelecthgoutside().toString().replace(",fsubcompanyid", "")));
        }
        if (paramAge.getSqlSelecthgoutsideReal().indexOf(",fsubcompanyid") > 0) {
            paramAge.setSqlSelecthgoutsideReal(new StringBuffer(paramAge.getSqlSelecthgoutsideReal().toString().replace(",fsubcompanyid", "")));
        }
    }

    protected void calculateSumallSumOverdue(Connection con, PreparedStatement ps, String tempTableAcSum, int daylen, boolean isSumLeft, AccountAgeParam paramAge) throws SQLException {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlSum = new StringBuffer();
        StringBuffer unSqlSum = new StringBuffer();
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            int i;
            index = paramAge.getUndaylen() + 1;
            for (i = 0; i < index; ++i) {
                unSqlSum.append("sum").append(i);
                if (i >= paramAge.getUndaylen()) continue;
                unSqlSum.append("+");
            }
            for (i = index; i <= daylen + index; ++i) {
                sqlSum.append("sum").append(i);
                if (i >= daylen + index) continue;
                sqlSum.append("+");
            }
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            sql.append(" sumunoverdue =").append("(").append(unSqlSum).append(")");
            if (isSumLeft) {
                sql.append(", leftamount=").append("(").append(sqlSum).append("+").append(unSqlSum).append(")");
                sql.append(", sumall=").append("(").append(sqlSum).append("+").append(unSqlSum).append(")");
            }
            sql.append(",sumoverdue=").append("(").append(sqlSum).append(")");
        } else {
            sqlSum.append("(");
            for (int i = 0; i <= daylen; ++i) {
                sqlSum.append("sum").append(i);
                if (i >= daylen) continue;
                sqlSum.append("+");
            }
            sqlSum.append(")");
            sql.append("Update ").append(tempTableAcSum);
            sql.append(" set ");
            if (isSumLeft) {
                sql.append(" leftamount=").append(sqlSum).append("+sumunoverdue,");
                sql.append(" sumall=").append(sqlSum).append("+sumunoverdue,");
            }
            sql.append(" sumoverdue=").append(sqlSum);
        }
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    protected void deleteBalZeroAcFromTempTable(Connection con, PreparedStatement ps, AccountAgeParam paramAge) throws SQLException {
        int j;
        String tempTableAcSum = paramAge.getTempTableAcSum();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append(tempTableAcSum);
        sql.append(" where sumUnOverDue = 0 ");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sql.append(" and ").append("sum" + j).append(" = 0");
            }
        }
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            sql.append(" and ").append("sum" + index).append(" = 0");
        }
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
    }

    protected void insertTotalSumLines2(Connection con, AccountAgeParam paramAge) throws EASBizException, BOSException {
        int j;
        Object ps = null;
        StringBuffer totalSum = new StringBuffer();
        totalSum.append("\r\n select  ");
        for (int i = 0; i < paramAge.getAlAstFields().size(); ++i) {
            totalSum.append(" '' ").append("T" + i + paramAge.getAlAstFields().get(i).toString());
            totalSum.append(" , ''  ").append("T" + i + "fnumber ");
            totalSum.append(" , ''  ").append("T" + i + "fname ,");
            if (paramAge.isAccountList()) break;
        }
        if (paramAge.isBizCode() && !paramAge.isAccountBCNoType()) {
            totalSum.append(" '' Taccountid, '' T0fnumber, '' T0fname,");
        }
        if (paramAge.isAccountList()) {
            totalSum.append(" fcurrid fcurrid, fcurrname fcurrname,'' hgid,1 FIsTotal ,");
        } else {
            totalSum.append(" fcurrid fcurrid, fcurrname fcurrname, 1 FIsTotal ,");
        }
        StringBuffer _tempSum = null;
        _tempSum = new StringBuffer();
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                _tempSum.append(",sum(sum" + j + ") as sum" + j);
            }
        }
        _tempSum.append(" ,sum(sumoverdue) sumoverdue ");
        for (int i = index; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            _tempSum.append(",sum(sum" + index + ") as sum" + index);
        }
        totalSum.append("\r\n sum(sumall) sumall,sum(sumunoverdue) sumunoverdue");
        totalSum.append(_tempSum);
        totalSum.append("\r\n from ");
        totalSum.append(paramAge.getTempTableAcSum());
        totalSum.append(" \r\n");
        totalSum.append("  group by fcurrid,fcurrname");
        totalSum.append("\r\n");
        this.insertData(totalSum.toString());
    }

    protected void insertTotalSumLines(Connection con, AccountAgeParam paramAge) throws EASBizException, BOSException, SQLException {
        int index;
        PreparedStatement ps = null;
        StringBuffer totalSum = new StringBuffer();
        String sql = " select top 1 1 from " + paramAge.getTempTableAcSum();
        ps = con.prepareStatement(sql);
        ResultSet rs = ps.executeQuery();
        if (!rs.next()) {
            ps.execute();
            ps.close();
            return;
        }
        rs.close();
        totalSum.append(" select  ");
        for (int i = 0; i < paramAge.getAlAstFields().size(); ++i) {
            totalSum.append(" '' ").append("T" + i + paramAge.getAlAstFields().get(i).toString()).append(",");
            totalSum.append(" N'' ").append("T" + i + "fnumber ").append(",");
            totalSum.append(" N'' ").append("T" + i + "fname ").append(",");
            if (paramAge.isAccountList()) break;
        }
        if (paramAge.isBizCode() && !paramAge.isAccountBCNoType()) {
            totalSum.append(" '' ").append("Taccountid").append(",");
            totalSum.append(" N'' ").append("T0fnumber ").append(",");
            totalSum.append(" N'' ").append("T0fname ").append(",");
        }
        totalSum.append(" '' fcurrid, ");
        if (paramAge.isIsOnlyUnion() && paramAge.isAllCurr()) {
            totalSum.append("fcurrname fcurrname, ");
        } else {
            totalSum.append("N'' fcurrname, ");
        }
        if (paramAge.isIsOnlyUnion()) {
            totalSum.append(" '' FOrgUnitID,");
        }
        StringBuffer _tempSum = null;
        if (paramAge.isAllCurr() || !paramAge.isBizCode() && paramAge.getAlAstFields().size() > 0 || paramAge.isBizCode() && paramAge.isAccountBC() && !paramAge.isAccountBCNoType()) {
            int j;
            _tempSum = new StringBuffer();
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _tempSum.append(",sum(sum" + (j + 1) + ") as sum" + (j + 1));
                }
            }
            for (int i = index; i < paramAge.getDaylen(); ++i) {
                index = i + j + 1;
                _tempSum.append(",sum(sum" + index + ") as sum" + index);
            }
            totalSum.append("\r\n 1 FIsTotal, sum(sumall) sumall,,sum(sumoverdue) sumoverdue").append("\r\n ,sum(sumunoverdue) sumunoverdue ,sum(sum0) sum0");
        } else if (paramAge.isIsOnlyUnion() && paramAge.isBizCode() && paramAge.isAccountList()) {
            int j;
            _tempSum = new StringBuffer();
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _tempSum.append(",sum(sum" + (j + 1) + ") as sum" + (j + 1));
                }
            }
            for (int i = index; i < paramAge.getDaylen(); ++i) {
                index = i + j + 1;
                _tempSum.append(",sum(sum" + index + ") as sum" + index);
            }
            totalSum.append("\r\n 1 FIsTotal, sum(sumall) sumall,,sum(sumoverdue) sumoverdue").append("\r\n ,sum(sumunoverdue) sumunoverdue ,sum(sum0) sum0");
        } else {
            int j;
            _tempSum = new StringBuffer();
            index = 0;
            if (paramAge.isShowUmexpired()) {
                for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                    _tempSum.append(",sum" + (j + 1));
                }
            }
            for (int i = index; i < paramAge.getDaylen(); ++i) {
                index = i + j + 1;
                _tempSum.append(",sum" + index);
            }
            totalSum.append("\r\n 1 FIsTotal,sumall,sumoverdue,sumunoverdue ,sum0");
        }
        totalSum.append(_tempSum);
        totalSum.append("\r\n from ");
        totalSum.append(paramAge.getTempTableAcSum());
        if (paramAge.isIsOnlyUnion()) {
            int rootCompanylevel = 1;
            sql = " select min(fsumcompanylevel) companyLevel from " + paramAge.getTempTableAcSum();
            ps = con.prepareStatement(sql);
            rs = ps.executeQuery();
            if (rs.next()) {
                rootCompanylevel = rs.getInt("companyLevel");
            }
            totalSum.append("\r\n where fsumcompanylevel=").append(rootCompanylevel);
        }
        totalSum.append(" \r\n");
        if (paramAge.isAllCurr()) {
            totalSum.append("  group by fcurrid,fcurrname");
        }
        totalSum.append("\r\n");
        this.insertData(totalSum.toString());
    }

    protected int calculateLocalAmt4Deviation(Connection con, AccountAgeParam paramAge) throws SQLException {
        int i;
        int i2;
        int iAdjust = 0;
        PreparedStatement ps = null;
        ResultSet rs = null;
        int index = 1;
        StringBuffer sql = new StringBuffer();
        StringBuffer totalSum = new StringBuffer();
        int generalCyScale = paramAge.getGeneralCurrency().getPrecision();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        if (!UUTN.isTempTable((String)tempTableAcSum) && !UUTN.isGlobalTempTable((String)tempTableAcSum)) {
            return iAdjust;
        }
        int daylen = paramAge.getDaylen();
        BigDecimal sumunoverdue = GlUtils.zero;
        BigDecimal leftamount = GlUtils.zero;
        BigDecimal sumall = GlUtils.zero;
        BigDecimal sumoverdue = GlUtils.zero;
        BigDecimal sumallAdd = GlUtils.zero;
        BigDecimal delta = GlUtils.zero;
        String strFieldNameMaxAmount = "";
        String sumStr = "";
        String sumStrRound = "";
        int ide = 0;
        if (paramAge.isShowUmexpired()) {
            ide = paramAge.getUndaylen() + 1;
        }
        BigDecimal[] sum = new BigDecimal[daylen + ide + 1];
        for (i2 = 0; i2 <= daylen + ide; ++i2) {
            sumStr = sumStr + "sum" + i2 + ",";
        }
        for (i2 = 0; i2 <= daylen + ide; ++i2) {
            sumStrRound = sumStrRound + "sum" + i2 + "=round(sum" + i2 + "," + generalCyScale + "),";
        }
        sql.setLength(0);
        sql.append("Update ").append(tempTableAcSum);
        sql.append(" set ");
        sql.append(sumStrRound);
        sql.append("sumunoverdue=round(sumunoverdue," + generalCyScale + "),");
        sql.append("leftamount=round(leftamount," + generalCyScale + "),");
        sql.append("sumall=round(sumall," + generalCyScale + "),");
        sql.append("sumoverdue=round(sumoverdue," + generalCyScale + ")");
        ps = con.prepareStatement(sql.toString());
        ps.execute();
        ps.close();
        boolean isIsOnlyUnionAdj = false;
        if (paramAge.isIsOnlyUnion() && !paramAge.isIsfirstload() && paramAge.getOtherInfo() != null && paramAge.getOtherInfo().get("sumall") != null) {
            isIsOnlyUnionAdj = true;
            leftamount = (BigDecimal)paramAge.getOtherInfo().get("sumall");
        }
        sql.setLength(0);
        sql.append(" select ");
        sql.append(sumStr);
        sql.append(" sumunoverdue,leftamount,sumall,sumoverdue");
        sql.append(" from ");
        sql.append(tempTableAcSum);
        ArrayList<String> paramList = new ArrayList<String>();
        if (!isIsOnlyUnionAdj) {
            sql.append(" where fcurrid = ? ");
            paramList.add(paramAge.getMaxChar());
        }
        ps = con.prepareStatement(sql.toString());
        for (i = 0; i < paramList.size(); ++i) {
            ps.setObject(i + 1, paramList.get(i));
        }
        rs = ps.executeQuery();
        if (rs.next()) {
            for (i = 0; i <= daylen + ide; ++i) {
                sum[i] = rs.getBigDecimal("sum" + i);
                sumallAdd = sumallAdd.add(sum[i]);
            }
            sumunoverdue = rs.getBigDecimal("sumunoverdue");
            if (!isIsOnlyUnionAdj) {
                leftamount = rs.getBigDecimal("leftamount");
            }
            sumall = rs.getBigDecimal("sumall");
            sumoverdue = rs.getBigDecimal("sumoverdue");
            if (!paramAge.isShowUmexpired()) {
                sumallAdd = sumallAdd.add(sumunoverdue);
            }
        }
        rs.close();
        ps.close();
        if (leftamount.compareTo(sumallAdd) != 0) {
            StringBuffer updateFilterRow;
            iAdjust = -1;
            delta = leftamount.subtract(sumallAdd);
            int iMaxCol = GLAcctAgeUtils.findMaxInSumArray(sum);
            strFieldNameMaxAmount = sumunoverdue.abs().compareTo(sum[iMaxCol].abs()) >= 0 ? "sumunoverdue" : "sum" + iMaxCol;
            if (!isIsOnlyUnionAdj) {
                sql.setLength(0);
                sql.append("Update ").append(tempTableAcSum);
                sql.append(" set ");
                sql.append(strFieldNameMaxAmount);
                sql.append(" = ");
                sql.append(strFieldNameMaxAmount);
                sql.append(" + ? ");
                sql.append(" where fcurrid = '").append(paramAge.getMaxChar()).append("'");
                ps = con.prepareStatement(sql.toString());
                index = 1;
                ps.setBigDecimal(index++, delta);
                ps.executeUpdate();
                ps.close();
            }
            if ((updateFilterRow = this.findMaxRowInTempTable(con, paramAge, strFieldNameMaxAmount)).length() > 0) {
                sql.setLength(0);
                sql.append("Update ").append(tempTableAcSum);
                sql.append(" set ");
                sql.append(strFieldNameMaxAmount);
                sql.append(" = ");
                sql.append(strFieldNameMaxAmount);
                sql.append(" + ? ");
                sql.append(" where fcurrid <> ? ");
                sql.append(updateFilterRow);
                ps = con.prepareStatement(sql.toString());
                index = 1;
                ps.setBigDecimal(index++, delta);
                ps.setString(index++, paramAge.getMaxChar());
                ps.executeUpdate();
            }
        }
        rs.close();
        ps.close();
        return iAdjust;
    }

    protected StringBuffer findMaxRowInTempTable(Connection con, AccountAgeParam paramAge, String filedName) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean index = true;
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlWhere = new StringBuffer();
        String tempTableAcSum = paramAge.getTempTableAcSum();
        sql.append(" select * from ").append(tempTableAcSum).append(" tmp   \r\n");
        sql.append(" where abs(tmp.").append(filedName).append(") =                               \r\n");
        sql.append(" (                                              \r\n");
        sql.append("  select max(abs(tmp2.").append(filedName).append("))                    \r\n");
        sql.append("  from ").append(tempTableAcSum).append(" tmp2          \r\n");
        sql.append("  where tmp2.fcurrid <> '").append(paramAge.getMaxChar()).append("' \r\n");
        sql.append(" )                                              \r\n");
        sql.append(" and tmp.fcurrid <> '").append(paramAge.getMaxChar()).append("' \r\n");
        ps = con.prepareStatement(sql.toString());
        rs = ps.executeQuery();
        if (rs.next()) {
            String keyField = "";
            sqlWhere.append(" ");
            for (int i = 0; i < paramAge.getLstHgOutSide().size(); ++i) {
                keyField = (String)paramAge.getLstHgOutSide().get(i);
                if (keyField.indexOf("number") >= 0 || keyField.indexOf("name") >= 0 || paramAge.isGeneralCy() && keyField.indexOf("hgid") >= 0) continue;
                sqlWhere.append(" AND ");
                sqlWhere.append(keyField).append(" = ");
                sqlWhere.append("'").append(rs.getString(keyField)).append("'  \r\n");
            }
        }
        rs.close();
        ps.close();
        return sqlWhere;
    }

    protected StringBuffer getSql_ByAcctBal_LastResult_FromTempAcSum(AccountAgeParam paramAge) {
        StringBuffer orderby;
        int j;
        StringBuffer sql = new StringBuffer("select ");
        if (paramAge.isIncludeVerifyVch() && !paramAge.isAccountList()) {
            sql.append(paramAge.getSqlSelecthgoutsideReal());
        } else {
            sql.append(paramAge.getSqlSelecthgoutside());
        }
        if (paramAge.isIsOnlyUnion()) {
            sql.replace(sql.indexOf("fsumcompanyid"), sql.indexOf("fsumcompanyisleaf,") + 18, " fsumcompanyid ");
        }
        sql.append("\r\n ,0 FIsTotal").append(",leftamount as sumall");
        sql.append(",sumunoverdue");
        int index = 0;
        if (paramAge.isShowUmexpired()) {
            for (j = 0; j <= paramAge.getUndaylen(); ++j) {
                sql.append(",sum" + j).append(" as amount" + j);
            }
        }
        sql.append(",sumoverdue");
        for (int i = 0; i <= paramAge.getDaylen(); ++i) {
            index = i + j;
            sql.append(",sum" + index).append(" as amount" + index);
        }
        sql.append("\r\n from ").append(paramAge.getTempTableAcSum());
        if (this.isAllCurrency()) {
            sql.append(" as t inner join t_bd_currency currency on t.fcurrid = currency.fid ");
        }
        if (paramAge.isIsOnlyUnion()) {
            sql.append(" where fsumcompanyisleaf = 1 ");
        }
        if ((orderby = paramAge.getSqlOrderby()) != null && orderby.length() > 0) {
            if (paramAge.isIsOnlyUnion()) {
                HashMap hmItems = paramAge.getHmItems();
                if (hmItems.size() == 0 || paramAge.isBizCode() && !paramAge.isAccountList() && hmItems.size() != 0) {
                    sql.append(" order by fcurrid,fsumcompanylevel,fsumcompanyname");
                } else {
                    sql.append(orderby);
                }
            } else {
                sql.append(orderby);
            }
        }
        return sql;
    }

    protected void getSql_ByAcctBal_SelectHgJoin(AccountAgeParam paramAge) throws EASBizException, BOSException {
        String accountname;
        HashMap hmItems = paramAge.getHmItems();
        StringBuffer sqlSelecthg = paramAge.getSqlSelecthg();
        StringBuffer sqlInnerJoin = paramAge.getSqlInnerJoin();
        StringBuffer sqlGroupby = paramAge.getSqlGroupby();
        StringBuffer sqlSelecthgoutside = paramAge.getSqlSelecthgoutside();
        StringBuffer sqlCreateHgTbl = paramAge.getSqlCreateHgTbl();
        StringBuffer sqlSelecthgoutsideReal = paramAge.getSqlSelecthgoutsideReal();
        boolean isAddFieldHgid = paramAge.isAddFieldHgid();
        int gi = 0;
        ArrayList alAstNumbers = paramAge.getAlAstNumbers();
        ArrayList alAstTables = paramAge.getAlAstTables();
        ArrayList alAstFields = paramAge.getAlAstFields();
        ArrayList alAstAlias = paramAge.getAlAstAlias();
        int tablei = 0;
        String string = accountname = GlUtils.isAccountShowLongName(paramAge.getCtx(), paramAge.getCurCompanyid()) ? "Flongname_" : "Fname_";
        if (paramAge.isAccountList()) {
            sqlGroupby.append(" group by ");
            sqlGroupby.append("account.FID ,account.Fnumber ,account.").append(accountname).append(paramAge.getLoc());
        }
        if (this.isShowLeft && !paramAge.isAccountList()) {
            sqlSelecthg.append("");
            sqlSelecthgoutside.append("");
            sqlCreateHgTbl.append("");
        }
        if (!paramAge.isBizCode()) {
            HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
            hmParamIn.put("GL_064", null);
            HashMap hmAllParam = ParamControlFactory.getLocalInstance((Context)paramAge.getCtx()).getParamHashMap(hmParamIn);
            Object isShowLongNumberObj = hmAllParam.get("GL_064");
            boolean isShowLongNumber = false;
            if (isShowLongNumberObj != null) {
                isShowLongNumber = true;
            }
            Iterator itemkeyit = hmItems.keySet().iterator();
            HashMap[] itemList = new HashMap[hmItems.keySet().size()];
            int k = 0;
            while (itemkeyit.hasNext()) {
                HashMap item = (HashMap)itemkeyit.next();
                Integer seq = (Integer)item.get("seq");
                if (seq != null) {
                    itemList[seq.intValue()] = item;
                } else {
                    itemList[k] = item;
                }
                ++k;
            }
            for (int i = 0; i < itemList.length; ++i) {
                HashMap item = itemList[i];
                boolean isGeneralActType = item.get("FGLAsstActTypeGrpID") != null;
                boolean isUseLongNumber = (Boolean)item.get("useLongNUmber");
                String numberFieldNumber = "fnumber";
                String[] numbers = (String[])hmItems.get(item);
                if (isGeneralActType && isUseLongNumber) {
                    numberFieldNumber = "flongnumber";
                    for (int ll = 0; ll < numbers.length; ++ll) {
                        if (numbers[ll] == null) continue;
                        numbers[ll] = numbers[ll].replace(".", "!");
                    }
                }
                String table = (String)item.get("tablename");
                String field = (String)item.get("fieldname");
                alAstTables.add(table);
                alAstFields.add(field);
                alAstAlias.add((String)item.get("name"));
                sqlInnerJoin.append(" inner join ").append(table).append(" ").append("T").append(tablei).append(" on hg.").append(field).append("=").append("T").append(tablei).append(".fid");
                if (paramAge.isIsOnlyUnion() && paramAge.getOtherInfo() != null && paramAge.getOtherInfo().get(field) != null) {
                    sqlInnerJoin.append(" and hg.").append(field).append(" = '").append(paramAge.getOtherInfo().get(field).toString()).append("' ");
                }
                if (numbers[0] != null) {
                    alAstNumbers.add(numbers[0]);
                    sqlInnerJoin.append(" and ").append("T").append(tablei).append(".").append(numberFieldNumber).append(" >= ? ");
                }
                if (numbers[1] != null) {
                    alAstNumbers.add(numbers[1]);
                    sqlInnerJoin.append(" and ").append("T").append(tablei).append(".").append(numberFieldNumber).append(" <= ? ");
                }
                if (numbers[2] != null) {
                    String[] nums;
                    sqlInnerJoin.append(" and ").append("T").append(tablei).append(".").append(numberFieldNumber).append(" in (");
                    for (String num : nums = numbers[2].split(",")) {
                        alAstNumbers.add(num);
                        sqlInnerJoin.append("?,");
                    }
                    sqlInnerJoin.deleteCharAt(sqlInnerJoin.lastIndexOf(",")).append(")");
                }
                sqlInnerJoin.append("  \r\n");
                if (!paramAge.isAccountList()) {
                    if (gi == 0) {
                        sqlGroupby.append(" group by ");
                    } else {
                        sqlGroupby.append(" ,");
                    }
                    sqlSelecthg.append("hg.").append(field).append(" as ").append("T").append(tablei).append(field).append(",");
                    sqlGroupby.append("hg.").append(field).append(",");
                    if (isShowLongNumber && item.get("propname") != null && item.get("propname").toString().startsWith("general")) {
                        sqlSelecthg.append("replace(T").append(tablei).append(".flongnumber,'!','.') as ").append("T").append(tablei).append("fnumber,");
                        sqlGroupby.append("T").append(tablei).append(".flongnumber,");
                    } else {
                        sqlSelecthg.append("T").append(tablei).append(".fnumber as ").append("T").append(tablei).append("fnumber,");
                        sqlGroupby.append("T").append(tablei).append(".fnumber,");
                    }
                    sqlSelecthg.append("T").append(tablei).append(".fname_").append(paramAge.getLoc()).append(" as ").append("T").append(tablei).append("fname,");
                    sqlGroupby.append("T").append(tablei).append(".fname_").append(paramAge.getLoc());
                    sqlSelecthgoutside.append("T").append(tablei).append(field).append(",T").append(tablei).append("fnumber,").append("T").append(tablei).append("fname,");
                    sqlCreateHgTbl.append("T").append(tablei).append(field).append(" varchar(44),").append("T").append(tablei).append("fnumber nvarchar(80),").append("T").append(tablei).append("fname nvarchar(255),");
                } else if (tablei == 0) {
                    sqlSelecthgoutside.append("T").append(tablei).append(field).append(",");
                    sqlSelecthgoutside.append("T").append(tablei).append("fnumber,");
                    sqlSelecthgoutside.append("T").append(tablei).append("fname,");
                    if (paramAge.isIsOnlyUnion()) {
                        sqlSelecthg.append("' ' as T0").append(field).append(",account.Fnumber as T0fnumber,account.").append(accountname).append(paramAge.getLoc()).append(" as T0fname,");
                    } else {
                        sqlSelecthg.append("account.FID as T0").append(field).append(",account.Fnumber as T0fnumber,account.").append(accountname).append(paramAge.getLoc()).append(" as T0fname,");
                    }
                    sqlCreateHgTbl.append("T0").append(field).append(" varchar(44),T0fnumber nvarchar(80),T0fname nvarchar(255),");
                }
                ++tablei;
                ++gi;
            }
        } else if (!paramAge.isAccountBC()) {
            sqlSelecthgoutside.append("Taccountid").append(",T0fnumber").append(",T0fname,");
            if (paramAge.isIsOnlyUnion() && paramAge.isBizCode() && paramAge.isAccountList()) {
                sqlSelecthg.append("'' as Taccountid");
            } else {
                sqlSelecthg.append("account.FID as Taccountid");
            }
            sqlSelecthg.append(",account.Fnumber as T0fnumber,account.").append(accountname).append(paramAge.getLoc()).append(" as T0fname,");
            sqlCreateHgTbl.append("Taccountid").append(" varchar(44),").append("T0fnumber nvarchar(80),").append("T0fname nvarchar(255),");
        } else if (paramAge.isAccountBC() && !paramAge.isAccountBCNoType()) {
            sqlSelecthgoutside.append("Taccountid").append(",T0fnumber").append(",T0fname,");
            sqlSelecthg.append("T_Hgid.bacid as Taccountid").append(",T_Hgid.bacnumber as T0fnumber, T_Hgid.bacname as T0fname,");
            sqlCreateHgTbl.append("Taccountid").append(" varchar(44),").append("T0fnumber nvarchar(80),").append("T0fname nvarchar(255),");
            sqlGroupby.append(" group by ");
            sqlGroupby.append(" T_Hgid.bacid ").append(",T_Hgid.bacnumber , T_Hgid.bacname");
        }
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            sqlSelecthg.append("currency.fid fcurrid,currency.Fname_" + paramAge.getLoc() + " fcurrname,");
        } else {
            sqlSelecthg.append("'" + paramAge.getCurrency().getId() + "' fcurrid,N'" + paramAge.getCurrency().getName() + "' fcurrname,");
        }
        sqlCreateHgTbl.append("fcurrid varchar(44),fcurrname nvarchar(100),");
        sqlSelecthgoutside.append("fcurrid,fcurrname,");
        if (paramAge.isIsOnlyUnion()) {
            sqlSelecthg.append(" sumcompany.fid fsumcompanyid,sumcompany.Fname_" + paramAge.getLoc() + " fsumcompanyname,sumcompany.flevel fsumcompanylevel,sumcompany.fisleaf fsumcompanyisleaf,");
            sqlSelecthgoutside.append("fsumcompanyid,fsumcompanyname,fsumcompanylevel,fsumcompanyisleaf,");
            sqlCreateHgTbl.append("fsumcompanyid varchar(44),fsumcompanyname nvarchar(100),fsumcompanylevel int,fsumcompanyisleaf int,");
            sqlSelecthg.append(" company.fid fsubcompanyid,");
            sqlSelecthgoutside.append("fsubcompanyid,");
            sqlCreateHgTbl.append("fsubcompanyid varchar(44),");
        }
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode()) {
                sqlSelecthg.append("T_Hgid.bacid as hgid,");
            } else {
                sqlSelecthg.append("cussent.fassgrpid as hgid,");
            }
            sqlCreateHgTbl.append("hgid varchar(44),");
            sqlSelecthgoutside.append("hgid,");
        }
        if (paramAge.isIncludeVerifyVch()) {
            sqlSelecthgoutsideReal.append(sqlSelecthgoutside);
            if (!paramAge.isAccountList()) {
                isAddFieldHgid = true;
                paramAge.setAddFieldHgid(isAddFieldHgid);
                if (paramAge.isBizCode()) {
                    sqlSelecthg.append("T_Hgid.bacid as hgid,");
                } else {
                    sqlSelecthg.append("cussent.fassgrpid as hgid,");
                }
                sqlCreateHgTbl.append("hgid varchar(44),");
                sqlSelecthgoutside.append("hgid,");
            }
        }
        List lstHgOutSide = GLAcctAgeUtils.getListFromSelecthgoutside(sqlSelecthgoutside);
        paramAge.setLstHgOutSide(lstHgOutSide);
        sqlSelecthgoutsideReal = GLAcctAgeUtils.truncateStringTailDot(sqlSelecthgoutsideReal);
        sqlSelecthgoutside = GLAcctAgeUtils.truncateStringTailDot(sqlSelecthgoutside);
        if (paramAge.isAllCurr() || paramAge.isGeneralCy()) {
            sqlGroupby.append(",currency.fid, currency.Fname_" + paramAge.getLoc());
        }
        if (paramAge.isIsOnlyUnion()) {
            sqlGroupby.append(", sumcompany.fid  ,sumcompany.Fname_" + paramAge.getLoc() + " ,sumcompany.flevel ,sumcompany.fisleaf  ");
            sqlGroupby.append(",company.fid ");
        }
        if (paramAge.isAccountList()) {
            if (paramAge.isBizCode()) {
                sqlGroupby.append(",T_Hgid.bacid");
            } else {
                sqlGroupby.append(",cussent.fassgrpid");
            }
        }
        if (paramAge.isIncludeVerifyVch() && !paramAge.isAccountList()) {
            if (paramAge.isBizCode()) {
                if (sqlGroupby.length() == 0) {
                    sqlGroupby.append(" group by ");
                    sqlGroupby.append("T_Hgid.bacid");
                } else if (sqlGroupby.indexOf("T_Hgid.bacid") < 0) {
                    sqlGroupby.append(",T_Hgid.bacid");
                }
            } else {
                sqlGroupby.append(",cussent.fassgrpid");
            }
        }
        if (sqlGroupby.toString().trim().startsWith(",")) {
            sqlGroupby = GLAcctAgeUtils.truncateStringHeadDot(sqlGroupby);
            sqlGroupby = GLAcctAgeUtils.appendFromHead(sqlGroupby, " group by ");
        }
    }
}

