/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountAgeCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import java.util.Iterator;

public class GLRptAcctAgeTotalPageQuery
extends GLRptPageQuery {
    protected AccountAgeParam paramAge;
    private String locale = "_L2";

    public GLRptAcctAgeTotalPageQuery(Context ctx, GLRptAccountAgeCondition cond, AccountAgeParam paramAge) {
        super(ctx, cond);
        this.locale = "_" + ctx.getLocale().getLanguage();
        this.paramAge = paramAge;
    }

    @Override
    protected String getSelectSQL() throws BOSException, EASBizException {
        int j;
        StringBuffer sql = new StringBuffer();
        this.appendRecordID(sql);
        sql.append(",");
        if (this.paramAge.isIncludeVerifyVch()) {
            if (!this.paramAge.isAccountList()) {
                sql.append(this.paramAge.getSqlSelecthgoutsideReal());
            } else {
                sql.append(this.paramAge.getSqlSelecthgoutside());
            }
        } else {
            sql.append(this.paramAge.getSqlSelecthgoutside());
        }
        GLRptSelector selector = this.getSelector();
        Iterator<GLRptField> it = selector.iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field != GLRptField.accountName && field != GLRptField.accountDisplayName) continue;
            StringBuffer name = new StringBuffer("av.FAccountID,av.fnumber||' '||").append(field.getSelect()).append(this.locale).append(" as accountName ");
            String temp = sql.toString().replace("FAccountID", name.toString());
            sql.setLength(0);
            sql.append(temp);
        }
        sql.append("\r\n ,FIstotal,FdebtDC,sumall");
        sql.append(",sumunoverdue");
        sql.append(",sumoverdue");
        int index = 0;
        if (this.paramAge.isShowUmexpired()) {
            for (j = 0; j <= this.paramAge.getUndaylen(); ++j) {
                sql.append(",amount" + j);
            }
        }
        for (int i = 0; i <= this.paramAge.getDaylen(); ++i) {
            index = i + j;
            sql.append(",amount" + index);
        }
        return sql.toString();
    }

    @Override
    protected String getWhereSQL() throws BOSException, EASBizException {
        if (this.paramAge.isIsOnlyUnion()) {
            StringBuffer where = new StringBuffer(super.getWhereSQL());
            return where.toString();
        }
        return super.getWhereSQL();
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" left outer join t_bd_accountview av on av.fid = t.faccountid ");
        sql.append(super.getJoinSQL());
        return sql.toString();
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException, EASBizException {
        GLRptAccountAgeCondition cond = (GLRptAccountAgeCondition)this.getCond();
        GLRptSQLOrder order = new GLRptSQLOrder();
        if (cond.isOrderDC()) {
            order.add("FdebtDC", SortType.DESCEND);
            order.add("FIsTotal");
            order.add("fcurrid");
            order.add("av.fnumber");
        } else {
            order.add("FIsTotal");
            order.add("FdebtDC", SortType.DESCEND);
            order.add("fcurrid");
            order.add("av.fnumber");
        }
        return order;
    }
}

