/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.common.SimpleCompanyUserObject;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptTreeNode;
import com.kingdee.eas.fi.gl.rpt.app.IGLRptIDCreator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class GLRptAsstActTypeBalanceIDCreator
implements IGLRptIDCreator {
    private GLRptBaseCondition cond;
    private Map companys = new HashMap();
    private SimpleCompanyUserObject rootObj;

    public GLRptAsstActTypeBalanceIDCreator(String mainTableAlias, GLRptBaseCondition cond) {
        this.cond = cond;
        this.initCompanyMap(cond);
    }

    private void initCompanyMap(GLRptBaseCondition cond) {
        if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.merger || cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
            CompanyOrgUnitInfo[] companyArrays = cond.getCompanys();
            for (int i = 0; i < companyArrays.length; ++i) {
                CompanyOrgUnitInfo company = companyArrays[i];
                SimpleCompanyUserObject simpleCompany = new SimpleCompanyUserObject();
                simpleCompany.setCompanyId(company.getId().toString());
                simpleCompany.setLeaf(company.isIsLeaf());
                simpleCompany.setLevel(company.getLevel());
                simpleCompany.setName(company.getName());
                this.companys.put(simpleCompany.getCompanyId(), simpleCompany);
            }
            if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.details) {
                this.rootObj = new SimpleCompanyUserObject();
                this.rootObj.setCompanyId(cond.getCompany().getId().toString());
                this.rootObj.setName(cond.getCompany().getName());
                this.companys.put(cond.getCompany().getId().toString(), this.rootObj);
            } else {
                SimpleCompanyUserObject adminCompany = new SimpleCompanyUserObject();
                adminCompany.setCompanyId("00000000-0000-0000-0000-000000000000CCE7AED4");
                this.companys.put(adminCompany.getCompanyId(), adminCompany);
            }
        } else if (cond.getCompanyDisplayMode() == CompanyDisplayModeEnum.level) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)cond.getTreeModelOfCompany();
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            this.rootObj = (SimpleCompanyUserObject)root.getUserObject();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                SimpleCompanyUserObject userObject = (SimpleCompanyUserObject)node.getUserObject();
                this.companys.put(userObject.getCompanyId(), userObject);
            }
        }
    }

    @Override
    public String getIDSelect() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("t.").append("KSQL_SEQ").append(", t.").append("SQL_BATCH");
        if (this.cond.getCompanyDisplayMode() != CompanyDisplayModeEnum.enumerate) {
            sql.append(", t.FOrgUnitID treeID ");
        }
        return sql.toString();
    }

    @Override
    public GLRptID create(ResultSet rs) throws SQLException {
        GLRptTreeNode node = new GLRptTreeNode(rs.getInt("SQL_BATCH"), rs.getInt("KSQL_SEQ"));
        SimpleCompanyUserObject obj = this.getTreeNodeObjectById(rs.getString("treeID"));
        if (CompanyDisplayModeEnum.merger == this.cond.getCompanyDisplayMode()) {
            if (obj != null) {
                if (obj.getCompanyId().equals("00000000-0000-0000-0000-000000000000CCE7AED4")) {
                    node.setLevel(0);
                    node.setLeaf(false);
                } else {
                    node.setLevel(1);
                    node.setLeaf(true);
                }
                node.setUserObject(obj);
            }
        } else if (CompanyDisplayModeEnum.details == this.cond.getCompanyDisplayMode() && obj != null) {
            if (obj.getCompanyId().equals(this.rootObj.getCompanyId())) {
                node.setLevel(0);
                node.setLeaf(false);
            } else {
                node.setLevel(1);
                node.setLeaf(true);
            }
            node.setUserObject(obj);
        }
        return node;
    }

    public SimpleCompanyUserObject getTreeNodeObjectById(String objId) {
        SimpleCompanyUserObject obj = (SimpleCompanyUserObject)this.companys.get(objId);
        if (obj == null) {
            return this.rootObj;
        }
        return obj;
    }
}

