/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.master.account.AccountPLType;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeCollection;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeFactory;
import com.kingdee.eas.basedata.master.account.AsstAccountChangeInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActGroupDetailInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.ReportConditionAsstactMultiColumn;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.common.CommonSchema;
import com.kingdee.eas.fi.gl.common.GLResUtil;
import com.kingdee.eas.fi.gl.common.RptServerUtil;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptID;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.IGLRptRowData;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAsstactMultiColumnDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableStruct;
import com.kingdee.eas.framework.AbstractDataBaseInfo;
import com.kingdee.eas.framework.report.util.LabelValueBean;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractGLRptMulColAbsDao {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptMulColAbsDao");
    private static final int ROW_COUNT = 5;
    private static final int BEGIN_BALANCE_INDEX = -1;
    private static final int PERIOD_TOTAL_INDEX = 1;
    private static final int PERIOD_TOTAL_PL_INDEX = 2;
    private static final int YEAR_SUM_INDEX = 3;
    private static final int YEAR_SUM_PL_INDEX = 4;
    private static final int END_BALANCE_INDEX = 0;
    private static final int DB_END_BALANCE_INDEX = 5;
    protected Context ctx;
    protected String loc;
    protected boolean isInited = false;
    protected String entryTempTable;
    protected String fetchSbPerId;
    protected boolean isInitPeriod;
    protected int preLinePYear;
    protected GLRptRowSet balData = null;
    protected int fechedCounts = 0;
    protected ReportConditionAsstactMultiColumn condition;
    protected CommonSchema cs;
    protected GLRptAsstactMultiColumnDao dao;
    protected CompanyOrgUnitInfo company;
    protected String companyid;
    protected String baseCurrencyId;
    protected String periodType;
    protected boolean isBalanceDirSameAsAccount;
    protected int qtyScale = 2;
    protected int priceScale = 2;
    protected CurrencyCollection currencys;
    protected int currencySize;
    protected AccountViewInfo accountView;
    protected String accountTableID;
    protected int accountDc;
    protected boolean displayAmount;
    protected boolean displayOneLineBiz;
    protected boolean displayOrigine;
    protected boolean needDisplayOrigine;
    protected boolean isQtyAsst;
    protected boolean includeNoTransPLVoucher;
    protected boolean noDisplayNoCol;
    protected boolean displayZeroTotal;
    protected int fetchDataType;
    protected boolean isAccountUpLevel;
    protected int balType = 5;
    protected String balTypes;
    protected int[] periodRange;
    protected List<LabelValueBean> itemList;
    protected List<LabelValueBean> debitList;
    protected List<LabelValueBean> creditList;
    protected int debitSize;
    protected Object[][] md;
    protected Object[][] debitColumn;
    protected Object[][] creditColumn;
    protected int uperAccountLevel;
    protected boolean needFilteHg = false;
    protected String hgFieldName = null;
    protected BigDecimal[] balances = new BigDecimal[]{GlUtils.zero, GlUtils.zero};
    protected BigDecimal[] plBalances = new BigDecimal[]{GlUtils.zero, GlUtils.zero};
    protected GLRptTableHeadInfo headInfo;
    protected String[] columnNames;
    protected Map colHideMap = new HashMap();
    protected GLRptRowSet sBalRowData = null;
    protected boolean fetchstartBalanceFlag = false;
    protected boolean fetchstartColumnAmtFlag = false;
    protected boolean allAccountSameUnit = true;
    private int startBalanceFlag = 0;
    private int fetchSbPeriodYear = -1;
    private GLRptRowSet fetchSbBalData = null;
    protected List<LabelValueBean> accountViewList;
    protected List<LabelValueBean> debitAccountViewList;
    protected List<LabelValueBean> creditAccountViewList;
    protected boolean isAccountMultiColumn = true;
    private Map<String, List<List<String>>> accountAsstActListActTypeListMap;
    private boolean isPLAccount;

    public AbstractGLRptMulColAbsDao(Context ctx, CompanyOrgUnitInfo company, GLRptAsstactMultiColumnDao dao, GLRptBaseCondition condition, CommonSchema cs) throws BOSException, EASBizException {
        this.dao = dao;
        this.company = company;
        this.cs = cs;
        this.ctx = ctx;
        this.setRptCondtion(condition);
        this.init();
    }

    protected int getSystemStatusName() {
        return 6;
    }

    protected void initSchema_checkBoxsValue() {
        this.displayAmount = this.condition.isShowQty();
        this.displayOneLineBiz = this.condition.isDisplayOneLineBiz();
        this.includeNoTransPLVoucher = this.condition.isNotIncluePLVoucher();
        this.displayOrigine = this.condition.isDisplayOrigine();
        this.noDisplayNoCol = this.condition.isNoDisplayNoCol();
        this.displayZeroTotal = this.condition.isDisplayZeroTotal();
        this.fetchDataType = this.condition.getFetchDataType();
        this.needDisplayOrigine = false;
        for (int i = 0; i < this.currencySize; ++i) {
            if (!this.displayOrigine || this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) continue;
            this.needDisplayOrigine = true;
            break;
        }
        this.balType = this.condition.getOptionPosting() ? 1 : 5;
        this.balTypes = this.condition.getOptionPosting() ? "(1,3,4,5)" : "(5)";
        this.periodRange = new int[]{this.condition.getPeriodYearStart(), this.condition.getPeriodNumberStart(), this.condition.getPeriodYearEnd(), this.condition.getPeriodNumberEnd()};
        if (this.condition.getActAttributes() != null) {
            this.hgFieldName = (String)this.condition.getActAttributes()[0];
        }
    }

    protected void setRptCondtion(GLRptBaseCondition cond) {
        this.condition = (ReportConditionAsstactMultiColumn)cond;
    }

    protected GLRptBaseCondition getRptCondition() {
        return this.condition;
    }

    protected void init() throws BOSException, EASBizException {
        this.loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        this.currencys = this.dao.getCurrencys();
        this.currencySize = this.currencys.size();
        String accViewId = this.cs.getParams().getString("accountViewID");
        this.accountView = this.getAccountById(accViewId);
        this.accountTableID = this.cs.getParams().getString("accountTableID");
        this.accountDc = this.accountView.getDC().getValue();
        this.companyid = this.company.getId().toString();
        this.baseCurrencyId = this.company.getBaseCurrency().getId().toString();
        this.periodType = this.company.getAccountPeriodType().getId().toString();
        boolean isAccountColumnType = this.cs.getParams().getBoolean("isAccountColumnType");
        this.isAccountMultiColumn = !this.accountView.isIsLeaf() && isAccountColumnType;
        this.initSysParams();
        this.initSchema_checkBoxsValue();
        this.isQtyAsst = this.cs.getParams().getBoolean("isQtyAsst");
        this.isAccountUpLevel = this.cs.getParams().getBoolean("isAccountUpLevel");
        this.md = (Object[][])this.cs.getParams().getObject("md");
        this.debitList = new ArrayList<LabelValueBean>();
        this.creditList = new ArrayList<LabelValueBean>();
        this.itemList = new ArrayList<LabelValueBean>();
        this.accountViewList = new ArrayList<LabelValueBean>();
        this.debitAccountViewList = new ArrayList<LabelValueBean>();
        this.creditAccountViewList = new ArrayList<LabelValueBean>();
        for (int i = 0; i < this.md.length; ++i) {
            String avLongNumber;
            String actItemId;
            if (this.md[i][1] instanceof AbstractDataBaseInfo) {
                actItemId = ((AbstractDataBaseInfo)this.md[i][1]).getId().toString();
                avLongNumber = ((AbstractDataBaseInfo)this.md[i][1]).getNumber();
                if (!StringUtils.isEmpty((String)avLongNumber)) {
                    avLongNumber = GlUtils.getAccountViewLongNumber(avLongNumber);
                }
            } else {
                actItemId = ((LabelValueBean)this.md[i][1]).getValue();
                avLongNumber = ((LabelValueBean)this.md[i][1]).getLabel();
                if (!StringUtils.isEmpty((String)avLongNumber)) {
                    avLongNumber = GlUtils.getAccountViewLongNumber(avLongNumber);
                }
            }
            if (BalanceDirectionEnum.DEBIT.equals(this.md[i][0])) {
                this.debitList.add(new LabelValueBean(actItemId, (String)this.md[i][2]));
                this.debitAccountViewList.add(new LabelValueBean(avLongNumber, (String)this.md[i][2]));
                continue;
            }
            this.creditList.add(new LabelValueBean(actItemId, (String)this.md[i][2]));
            this.creditAccountViewList.add(new LabelValueBean(avLongNumber, (String)this.md[i][2]));
        }
        this.debitSize = this.debitList.size();
        this.itemList.addAll(this.debitList);
        this.itemList.addAll(this.creditList);
        this.accountViewList.addAll(this.debitAccountViewList);
        this.accountViewList.addAll(this.creditAccountViewList);
        this.isPLAccount = this.accountView.getPLType() != AccountPLType.NONE;
        this.initColumnNames();
    }

    protected void initSysParams() throws EASBizException, BOSException {
        String[] paramList = new String[]{"GL_005", "GL_002", "GL_003"};
        GlParam sysParam = GlParam.getGlParams((Context)this.ctx, (String[])paramList, (String)this.companyid);
        this.isBalanceDirSameAsAccount = sysParam.getBoolean("GL_005");
        this.qtyScale = sysParam.getInt("GL_002");
        this.priceScale = sysParam.getInt("GL_003");
    }

    protected AccountViewInfo getAccountById(String id) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("longName"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("DC"));
        sic.add(new SelectorItemInfo("AC"));
        sic.add(new SelectorItemInfo("isQty"));
        sic.add(new SelectorItemInfo("pltype"));
        return AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    protected void buildData() throws BOSException, EASBizException {
        this.createEntryTmpTable();
        this.insertVchData();
        this.insertSumLine();
    }

    protected abstract void createEntryTmpTable() throws BOSException;

    protected boolean getIsDisplayOneLineBiz() {
        return this.condition.isDisplayOneLineBiz();
    }

    protected void insertVchData() throws EASBizException, BOSException {
        StringBuffer sumsql = new StringBuffer();
        sumsql.append("SELECT  0 no, voucherId, FSourcetype, ActDC, FPeriodID, FPeriodYear, FPeriodNumber, \r\n");
        sumsql.append("bizDate, voucherTypeName, ");
        if (this.getIsDisplayOneLineBiz()) {
            sumsql.append("max(description) description,");
        } else {
            sumsql.append("description,fentryid,fseq ,");
        }
        sumsql.append("'' Orginal_DC \r\n");
        if (this.displayAmount) {
            sumsql.append(", muname ");
        }
        sumsql.append(" from ").append(this.entryTempTable).append(" tempp ");
        if (this.getIsDisplayOneLineBiz()) {
            sumsql.append("group by voucherId,  ActDC, FSourcetype,  FPeriodID,");
            sumsql.append("FPeriodYear,FPeriodNumber , bizDate, voucherTypeName ");
            if (this.displayAmount) {
                sumsql.append(", muname ");
            }
        }
        this.dao.insertData(this.getTempTableStruct().getFieldNames(), sumsql.toString());
    }

    protected boolean getIsDisplayEndBalance() {
        return this.condition.isDisplayEndBalance();
    }

    protected void insertSumLine() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> sp = new ArrayList<Object>();
        sql.append(this.getSumLineSql(-1, GLResUtil.getRes("balance_period_begin", this.ctx)));
        sp.add(this.periodType);
        sql.append("union all \r\n");
        sql.append(this.getSumLineSql(1, GLResUtil.getRes("period_total", this.ctx)));
        sp.add(this.periodType);
        sp.add(this.periodRange[0] * 100 + this.periodRange[1]);
        sp.add(this.periodRange[2] * 100 + this.periodRange[3]);
        sql.append("union all \r\n");
        sql.append(this.getSumLineSql(3, GLResUtil.getRes("sum_year", this.ctx)));
        sp.add(this.periodType);
        sp.add(this.periodRange[0] * 100 + this.periodRange[1]);
        sp.add(this.periodRange[2] * 100 + this.periodRange[3]);
        if (this.isPLAccount && !this.includeNoTransPLVoucher) {
            sql.append("union all \r\n");
            sql.append(this.getSumLineSql(2, GLResUtil.getRes("period_total_pl", this.ctx)));
            sp.add(this.periodType);
            sp.add(this.periodRange[0] * 100 + this.periodRange[1]);
            sp.add(this.periodRange[2] * 100 + this.periodRange[3]);
            sql.append("union all \r\n");
            sql.append(this.getSumLineSql(4, GLResUtil.getRes("sum_year_pl", this.ctx)));
            sp.add(this.periodType);
            sp.add(this.periodRange[0] * 100 + this.periodRange[1]);
            sp.add(this.periodRange[2] * 100 + this.periodRange[3]);
        }
        if (this.getIsDisplayEndBalance()) {
            sql.append("union all \r\n");
            String endRes = ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLAutoGenerateResource", (String)"487_RptAsstactMultiColumnControllerBean", (Locale)this.ctx.getLocale());
            sql.append(this.getSumLineSql(5, endRes));
            sp.add(this.periodType);
            sp.add(this.periodRange[0] * 100 + this.periodRange[1]);
            sp.add(this.periodRange[2] * 100 + this.periodRange[3]);
        }
        this.dao.insertData(this.getTempTableStruct().getFieldNames(), "select t.* from (" + sql.toString() + ") t", sp);
    }

    protected String getSumLineSql(int no, String desc) {
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(no).append(" no, '' voucherId, -1 FSourcetype, ");
        sql.append(this.accountDc).append(" ActDC, P.FID FPeriodID, P.FPeriodYear, p.FPeriodNumber, ");
        if (no == -1) {
            sql.append("  P.FBeginDate BizDate, ");
        } else {
            sql.append("  P.FEndDate BizDate, ");
        }
        sql.append("N'' voucherTypeName, N'").append(desc).append("' Description, \r\n");
        if (!this.displayOneLineBiz) {
            sql.append("'' fentryid, \r\n");
            sql.append("-1 fseq, \r\n");
        }
        sql.append("'' Orginal_DC \r\n");
        if (this.displayAmount) {
            sql.append(", N'' muname ");
        }
        sql.append("from T_BD_Period P \r\n");
        if (no == -1) {
            sql.append("where P.FPeriodYear = ").append(this.periodRange[0]);
            sql.append(" and P.FPeriodNumber = ").append(this.periodRange[1]).append(" \r\n");
            sql.append(" and P.FTypeID = ? \r\n");
        } else {
            if (this.displayZeroTotal) {
                sql.append("inner join ").append(this.dao.getDataSourceTableName());
            } else {
                sql.append("left join ").append(this.dao.getDataSourceTableName());
            }
            sql.append(" TEMP on P.FID = TEMP.FPeriodID and TEMP.no = 0 \r\n");
            sql.append(" where P.FTypeID = ? and P.fNumber >= ? and P.fNumber <= ? \r\n");
            sql.append(" group by P.FID, P.FPeriodYear, P.FPeriodNumber, P.FEndDate \r\n");
        }
        return sql.toString();
    }

    protected void fetchStartBalance(IRowSet rs) throws BOSException, SQLException, EASBizException {
        int seq = rs.getInt("KSQL_SEQ");
        int batch = rs.getInt("SQL_BATCH");
        String periodid = rs.getString("fperiodid");
        int periodYear = rs.getInt("FPeriodYear");
        String vchId = rs.getString("voucherId");
        this.fetchSbPerId = periodid;
        this.fetchSbPeriodYear = periodYear;
        this.balances[0] = GlUtils.zero;
        this.balances[1] = GlUtils.zero;
        this.balData = new GLRptRowSet(this.getColumnNames(), 5);
        this.dealStartBalance(rs, null, false);
        this.dealVchBalance(seq, batch, periodid, vchId);
        this.fetchSbBalData = this.fromGlRptRowSet(this.balData);
    }

    protected boolean isInitPeriod(String periodID) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyid));
        filter.getFilterItems().add(new FilterItemInfo("systemStatus.name", (Object)new Integer(6)));
        filter.getFilterItems().add(new FilterItemInfo("startPeriod.id", (Object)periodID));
        return SystemStatusCtrolFactory.getLocalInstance((Context)this.ctx).exists(filter);
    }

    protected abstract void dealVchBalance(int var1, int var2, String var3, String var4) throws BOSException;

    public GLRptRowSet getData(GLRptID[] ids) throws BOSException, EASBizException {
        boolean hasFecthedBalance = false;
        if (ids == null || ids.length == 0) {
            logger.error((Object)"In the method getData(GLRptID[] ids), ids is null!");
            return new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), 0);
        }
        this.fechedCounts += ids.length;
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getQuerySql(ids));
        GLRptRowSet data = new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), ids.length);
        try {
            while (rs.next()) {
                int seq = rs.getInt("KSQL_SEQ");
                int batch = rs.getInt("SQL_BATCH");
                int curPYear = rs.getInt("fperiodYear");
                int rowIndex = this.dao.indexof(ids, rs);
                if (rowIndex == -1) {
                    throw new BOSException("Data not found!");
                }
                data.insertRow(rowIndex);
                if (this.preLinePYear != curPYear) {
                    this.clearBalDataYearSum();
                }
                this.preLinePYear = curPYear;
                if (!hasFecthedBalance) {
                    int curCount;
                    StringBuffer rcSql = new StringBuffer();
                    SqlParams sp = new SqlParams();
                    int index = 1;
                    rcSql.append("select ksql_seq from ").append(this.dao.getIdListTempTable()).append(" \r\n");
                    rcSql.append("where SQL_SEQ = ? and SQL_BATCH = ?\r\n");
                    sp.setInt(index++, seq);
                    sp.setInt(index++, batch);
                    IRowSet rsCounts = DbUtil.executeQuery((Context)this.ctx, (String)rcSql.toString(), (Object[])sp.getParams());
                    if (rsCounts.next() && this.fechedCounts - ids.length + 1 != (curCount = rsCounts.getInt("ksql_seq"))) {
                        this.fetchStartBalance(rs);
                        this.fechedCounts = curCount - 1 + ids.length;
                    }
                    hasFecthedBalance = true;
                }
                this.toGLRptRowData(rs, data, false);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return data;
    }

    public GLRptRowSet getData(GLRptID[] ids, String orderSql) throws BOSException, EASBizException {
        boolean hasFecthedBalance = false;
        if (ids == null || ids.length == 0) {
            logger.error((Object)"In the method getData(GLRptID[] ids), ids is null!");
            return new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), 0);
        }
        this.fechedCounts += ids.length;
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getQuerySql(ids));
        GLRptRowSet data = new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), ids.length);
        try {
            while (rs.next()) {
                int seq = rs.getInt("KSQL_SEQ");
                int batch = rs.getInt("SQL_BATCH");
                int curPYear = rs.getInt("fperiodYear");
                int curPNum = rs.getInt("fperiodNumber");
                String curPeriodId = rs.getString("FPeriodID");
                int rowIndex = this.dao.indexof(ids, rs);
                if (rowIndex == -1) {
                    throw new BOSException("Data not found!");
                }
                data.insertRow(rowIndex);
                if (this.preLinePYear != curPYear) {
                    this.clearBalDataYearSum();
                }
                this.preLinePYear = curPYear;
                if (!hasFecthedBalance) {
                    int curCount;
                    StringBuffer rcSql = new StringBuffer();
                    SqlParams sp = new SqlParams();
                    int index = 1;
                    rcSql.append("select ksql_seq from ").append(this.dao.getIdListTempTable()).append(" \r\n");
                    rcSql.append("where SQL_SEQ = ? and SQL_BATCH = ?\r\n");
                    sp.setInt(index++, seq);
                    sp.setInt(index++, batch);
                    IRowSet rsCounts = DbUtil.executeQuery((Context)this.ctx, (String)rcSql.toString(), (Object[])sp.getParams());
                    if (rsCounts.next() && this.fechedCounts - ids.length + 1 != (curCount = rsCounts.getInt("ksql_seq"))) {
                        this.fetchstartBalanceFlag = true;
                        Object[] params = null;
                        params = this.displayAmount ? new Object[]{curPYear, curPYear, curPNum, curPYear, curPYear, curPNum, curPYear, curPYear, curPNum, curPYear, curPYear, curPNum, curCount} : new Object[]{curPYear, curPYear, curPNum, curPYear, curPYear, curPNum, curCount};
                        this.fetchStartBalance_new(params, curPeriodId, curPYear);
                        this.fetchstartBalanceFlag = false;
                        this.fechedCounts = curCount - 1 + ids.length;
                    }
                    hasFecthedBalance = true;
                }
                this.toGLRptRowData(rs, data, false);
            }
        }
        catch (SQLException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        return data;
    }

    private void fetchStartBalance_new(Object[] params, String curPeriodId, int curPeriodYear) throws EASBizException, BOSException, SQLException {
        String balPriceSumColName;
        String balMuSumColName;
        String dcColName;
        String balQtySumColName;
        String balSumColName;
        this.balData = curPeriodYear == this.fetchSbPeriodYear ? this.fromGlRptRowSet(this.fetchSbBalData) : new GLRptRowSet(this.getColumnNames(), 5);
        BigDecimal periodDetLmt = BigDecimal.ZERO;
        BigDecimal yearDetLmt = BigDecimal.ZERO;
        BigDecimal periodCetLmt = BigDecimal.ZERO;
        BigDecimal yearCetLmt = BigDecimal.ZERO;
        String sql = this.getQueryBalSql();
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])params);
        while (rs.next()) {
            int row;
            balSumColName = "Balance_Amount";
            balQtySumColName = "Balance_Qty";
            dcColName = "Orginal_DC";
            balMuSumColName = "Balance_Mu";
            balPriceSumColName = "Balance_Price";
            this.balances[1] = rs.getBigDecimal("FLocalAmount");
            this.balances[1] = GLResUtil.getRes("credit", this.ctx).equals(this.sBalRowData.getString(dcColName)) ? this.balances[1].subtract(this.sBalRowData.getBigDecimal(balSumColName)) : this.balances[1].add(this.sBalRowData.getBigDecimal(balSumColName));
            if (this.displayAmount) {
                this.balances[0] = this.isQtyAsst ? rs.getBigDecimal("FStandardQuantity") : rs.getBigDecimal("FQuantity");
                this.balances[0] = GLResUtil.getRes("credit", this.ctx).equals(this.sBalRowData.getString(dcColName)) ? this.balances[0].subtract(this.sBalRowData.getBigDecimal(balQtySumColName)) : this.balances[0].add(this.sBalRowData.getBigDecimal(balQtySumColName));
            }
            if (this.fetchSbPerId.equals(curPeriodId)) break;
            String dSumColName = "Debit_Sum";
            String cSumColName = "Credit_Sum";
            periodDetLmt = rs.getBigDecimal("FPeriodDetLMT");
            yearDetLmt = rs.getBigDecimal("FYearDetLMT");
            periodCetLmt = rs.getBigDecimal("FPeriodCetLMT");
            yearCetLmt = rs.getBigDecimal("FYearCetLMT");
            if (this.fetchSbPeriodYear == curPeriodYear) {
                yearDetLmt = GlUtils.add(this.getFetchSbBalDataDecimal(dSumColName), yearDetLmt);
                yearCetLmt = GlUtils.add(this.getFetchSbBalDataDecimal(cSumColName), yearCetLmt);
            }
            this.balData.updateBigDecimal(1, dSumColName, periodDetLmt);
            this.balData.updateBigDecimal(1, cSumColName, periodCetLmt);
            this.balData.updateBigDecimal(3, dSumColName, yearDetLmt);
            this.balData.updateBigDecimal(3, cSumColName, yearCetLmt);
            Object[] balanceAndDC = this.autoBanlanceDc(this.balances[1]);
            for (row = 0; row < 5; ++row) {
                if (row == 2 || row == 4) continue;
                this.balData.updateString(row, dcColName, (String)balanceAndDC[1]);
                this.balData.updateBigDecimal(row, balSumColName, (BigDecimal)balanceAndDC[0]);
            }
            if (!this.displayAmount) continue;
            for (row = 0; row < 5; ++row) {
                if (row == 2 || row == 4) continue;
                this.balData.updateString(row, balMuSumColName, this.getUniqueMeasureUnitName());
            }
            if (this.balances[1].compareTo((BigDecimal)balanceAndDC[0]) != 0) {
                for (row = 0; row < 5; ++row) {
                    if (row == 2 || row == 4) continue;
                    this.balData.updateBigDecimal(row, balQtySumColName, this.balances[0].negate());
                }
            } else {
                for (row = 0; row < 5; ++row) {
                    if (row == 2 || row == 4) continue;
                    this.balData.updateBigDecimal(row, balQtySumColName, this.balances[0]);
                }
            }
            if (this.balances[0].compareTo(GlUtils.zero) != 0) {
                for (row = 0; row < 5; ++row) {
                    if (row == 2 || row == 4) continue;
                    this.balData.updateBigDecimal(row, balPriceSumColName, this.balances[1].divide(this.balances[0], this.priceScale, 4));
                }
                continue;
            }
            for (row = 0; row < 5; ++row) {
                if (row == 2 || row == 4) continue;
                this.balData.updateBigDecimal(row, balPriceSumColName, null);
            }
        }
        if (!this.condition.isNotIncluePLVoucher() && this.isPLAccount) {
            rs = DbUtil.executeQuery((Context)this.ctx, (String)(sql + " and vch.fsourcetype = 1 "), (Object[])params);
            while (rs.next()) {
                int row;
                balSumColName = "Balance_Amount";
                balQtySumColName = "Balance_Qty";
                dcColName = "Orginal_DC";
                balMuSumColName = "Balance_Mu";
                balPriceSumColName = "Balance_Price";
                this.plBalances[1] = BigDecimal.ZERO;
                if (this.displayAmount) {
                    BigDecimal bigDecimal = this.plBalances[0] = this.isQtyAsst ? rs.getBigDecimal("FStandardQuantity") : rs.getBigDecimal("FQuantity");
                }
                if (this.fetchSbPerId.equals(curPeriodId)) {
                    return;
                }
                String dPLSumColName = "Debit_Sum";
                String cPLSumColName = "Credit_Sum";
                BigDecimal periodPLDetLmt = rs.getBigDecimal("FPeriodDetLMT");
                BigDecimal yearPLDetLmt = rs.getBigDecimal("FYearDetLMT");
                BigDecimal periodPLCetLmt = rs.getBigDecimal("FPeriodCetLMT");
                BigDecimal yearPLCetLmt = rs.getBigDecimal("FYearCetLMT");
                this.balData.updateBigDecimal(2, dPLSumColName, periodDetLmt.subtract(periodPLDetLmt));
                this.balData.updateBigDecimal(2, cPLSumColName, periodCetLmt.subtract(periodPLCetLmt));
                this.balData.updateBigDecimal(4, dPLSumColName, yearDetLmt.subtract(yearPLDetLmt));
                this.balData.updateBigDecimal(4, cPLSumColName, yearCetLmt.subtract(yearPLCetLmt));
                Object[] balanceAndDC = this.autoBanlanceDc(this.balances[1].add(this.plBalances[1]));
                this.balData.updateString(2, dcColName, (String)balanceAndDC[1]);
                this.balData.updateBigDecimal(2, balSumColName, (BigDecimal)balanceAndDC[0]);
                this.balData.updateString(4, dcColName, (String)balanceAndDC[1]);
                this.balData.updateBigDecimal(4, balSumColName, (BigDecimal)balanceAndDC[0]);
                if (!this.displayAmount) continue;
                for (row = 0; row < 5; ++row) {
                    if (row == 1 || row == 3) continue;
                    this.balData.updateString(row, balMuSumColName, this.getUniqueMeasureUnitName());
                }
                if (this.balances[1].compareTo((BigDecimal)balanceAndDC[0]) != 0) {
                    for (row = 0; row < 5; ++row) {
                        if (row == 1 || row == 3) continue;
                        this.balData.updateBigDecimal(row, balQtySumColName, this.balances[0].add(this.plBalances[0]).negate());
                    }
                } else {
                    for (row = 0; row < 5; ++row) {
                        if (row == 1 || row == 3) continue;
                        this.balData.updateBigDecimal(row, balQtySumColName, this.balances[0].add(this.plBalances[0]));
                    }
                }
                if (this.balances[0].add(this.plBalances[0]).compareTo(GlUtils.zero) != 0) {
                    for (row = 0; row < 5; ++row) {
                        if (row == 1 || row == 3) continue;
                        this.balData.updateBigDecimal(row, balPriceSumColName, this.balances[1].add(this.plBalances[1]).divide(this.balances[0].add(this.plBalances[0]), this.priceScale, 4));
                    }
                    continue;
                }
                for (row = 0; row < 5; ++row) {
                    if (row == 1 || row == 3) continue;
                    this.balData.updateBigDecimal(row, balPriceSumColName, null);
                }
            }
        }
        if (this.fetchSbPerId.equals(curPeriodId)) {
            return;
        }
        this.fetchstartColumnAmtFlag = true;
        rs = DbUtil.executeQuery((Context)this.ctx, (String)this.getQueryColSumSql(), (Object[])params);
        this.fetchstartColumnAmtFlag = false;
        HashMap<String, BigDecimal> mulColMap = new HashMap<String, BigDecimal>();
        while (rs.next()) {
            this.dealRowToMap(rs, mulColMap);
        }
        this.dealMulColSumToMap(mulColMap);
        this.fetchBalData(this.isAccountMultiColumn ? this.debitAccountViewList : this.debitList, mulColMap, 1, curPeriodYear);
        this.fetchBalData(this.isAccountMultiColumn ? this.creditAccountViewList : this.creditList, mulColMap, 0, curPeriodYear);
    }

    protected void dealRowToMap(IRowSet rs, Map<String, BigDecimal> map) throws BOSException, EASBizException, SQLException {
    }

    protected void dealMulColSumToMap(Map<String, BigDecimal> map) {
    }

    protected String getQueryBalSql() {
        return null;
    }

    protected String getQueryColSumSql() throws BOSException, EASBizException {
        return null;
    }

    protected void fetchBalData(List<LabelValueBean> itemList, Map<String, BigDecimal> mulColMap, int dc, int curPeriodYear) throws BOSException {
        int i;
        String dcCol = "Credit";
        if (dc == 1) {
            dcCol = "Debit";
        }
        List<String> mulColNames = Arrays.asList(this.getColumnNames());
        boolean isNegate = false;
        for (i = 0; i < itemList.size(); ++i) {
            LabelValueBean lvb = itemList.get(i);
            if (lvb == null) continue;
            String longNumber = lvb.getValue();
            int idc = dc;
            for (int cur = 0; cur < this.currencys.size(); ++cur) {
                String hCurId = this.currencys.get(cur).getId().toString();
                String key = longNumber + "_" + hCurId + "_";
                if (!mulColMap.containsKey(key + 0 + "_for") && !mulColMap.containsKey(key + 1 + "_for")) continue;
                if (idc == 1 && mulColMap.containsKey(key + 0 + "_for") || idc == 0 && mulColMap.containsKey(key + 1 + "_for")) {
                    idc = idc == 1 ? 0 : 1;
                    isNegate = true;
                }
                if (!mulColMap.containsKey((key = key + idc) + "_for")) continue;
                BigDecimal omt = mulColMap.get(key + "_for");
                BigDecimal loc = mulColMap.get(key + "_loc");
                BigDecimal qty = mulColMap.get(key + "_qty");
                key = key + "_year";
                BigDecimal yearOmt = mulColMap.get(key + "_for");
                BigDecimal yearLoc = mulColMap.get(key + "_loc");
                BigDecimal yearQty = mulColMap.get(key + "_qty");
                key = key + "_period";
                BigDecimal periodOmt = mulColMap.get(key + "_for");
                BigDecimal periodLoc = mulColMap.get(key + "_loc");
                BigDecimal periodQty = mulColMap.get(key + "_qty");
                String omtColName = dcCol + "For_" + i + "_" + cur;
                String locColName = dcCol + "Local_" + i + "_" + cur;
                if (isNegate) {
                    omt = omt.negate();
                    loc = loc.negate();
                    yearOmt = yearOmt.negate();
                    yearLoc = yearLoc.negate();
                    periodOmt = periodOmt.negate();
                    periodLoc = periodLoc.negate();
                }
                if (this.fetchSbPeriodYear == curPeriodYear) {
                    yearLoc = GlUtils.add(this.getFetchSbBalDataDecimal(locColName), yearLoc);
                    if (mulColNames.contains(omtColName)) {
                        yearOmt = GlUtils.add(this.getFetchSbBalDataDecimal(omtColName), yearOmt);
                    }
                }
                if (mulColNames.contains(locColName)) {
                    loc = GlUtils.add(this.sBalRowData.getBigDecimal(locColName), loc);
                    this.balData.updateBigDecimal(0, locColName, loc);
                    this.balData.updateBigDecimal(1, locColName, periodLoc);
                    this.balData.updateBigDecimal(3, locColName, yearLoc);
                }
                if (mulColNames.contains(omtColName)) {
                    omt = GlUtils.add(this.sBalRowData.getBigDecimal(omtColName), omt);
                    this.balData.updateBigDecimal(0, omtColName, omt);
                    this.balData.updateBigDecimal(1, omtColName, periodOmt);
                    this.balData.updateBigDecimal(3, omtColName, yearOmt);
                }
                if (!this.condition.isNotIncluePLVoucher() && this.isPLAccount) {
                    this.balData.updateBigDecimal(2, locColName, periodLoc);
                    this.balData.updateBigDecimal(4, locColName, yearLoc);
                    if (mulColNames.contains(omtColName)) {
                        this.balData.updateBigDecimal(2, omtColName, periodOmt);
                        this.balData.updateBigDecimal(4, omtColName, yearOmt);
                    }
                }
                if (!this.displayAmount) continue;
                if (isNegate) {
                    qty = qty.negate();
                    yearQty = yearQty.negate();
                    periodQty = periodQty.negate();
                }
                String qtyColName = dcCol + "Qty_" + i + "_" + cur;
                if (this.fetchSbPeriodYear == curPeriodYear) {
                    yearQty = GlUtils.add(this.getFetchSbBalDataDecimal(qtyColName), yearQty);
                }
                if (mulColNames.contains(qtyColName)) {
                    qty = GlUtils.add(this.sBalRowData.getBigDecimal(qtyColName), qty);
                }
                this.balData.updateBigDecimal(0, qtyColName, qty);
                this.balData.updateBigDecimal(1, qtyColName, periodQty);
                this.balData.updateBigDecimal(3, qtyColName, yearQty);
                if (this.condition.isNotIncluePLVoucher() || !this.isPLAccount) continue;
                this.balData.updateBigDecimal(2, qtyColName, periodQty);
                this.balData.updateBigDecimal(4, qtyColName, yearQty);
            }
        }
        for (i = 0; i < this.currencys.size(); ++i) {
            String currencyId = this.currencys.get(i).getId().toString();
            String sumKey = dcCol + "_" + currencyId;
            if (!mulColMap.containsKey(sumKey + "_for")) continue;
            sumKey = sumKey + "_year";
            BigDecimal yearOmt = mulColMap.get(sumKey + "_for");
            BigDecimal yearLoc = mulColMap.get(sumKey + "_loc");
            BigDecimal yearQty = mulColMap.get(sumKey + "_qty");
            sumKey = sumKey + "_period";
            BigDecimal periodOmt = mulColMap.get(sumKey + "_for");
            BigDecimal periodLoc = mulColMap.get(sumKey + "_loc");
            BigDecimal periodQty = mulColMap.get(sumKey + "_qty");
            String omtColName = dcCol + "For_" + i;
            String locColName = dcCol + "Local_" + i;
            if (this.fetchSbPeriodYear == curPeriodYear) {
                if (mulColNames.contains(locColName)) {
                    yearLoc = GlUtils.add(this.getFetchSbBalDataDecimal(locColName), yearLoc);
                }
                if (mulColNames.contains(omtColName)) {
                    yearOmt = GlUtils.add(this.getFetchSbBalDataDecimal(omtColName), yearOmt);
                }
            }
            if (mulColNames.contains(locColName)) {
                this.balData.updateBigDecimal(1, locColName, periodLoc);
                this.balData.updateBigDecimal(3, locColName, yearLoc);
                if (!this.condition.isNotIncluePLVoucher() && this.isPLAccount) {
                    this.balData.updateBigDecimal(2, locColName, periodLoc);
                    this.balData.updateBigDecimal(4, locColName, yearLoc);
                }
            }
            if (mulColNames.contains(omtColName)) {
                this.balData.updateBigDecimal(1, omtColName, periodOmt);
                this.balData.updateBigDecimal(3, omtColName, yearOmt);
                if (!this.condition.isNotIncluePLVoucher() && this.isPLAccount) {
                    this.balData.updateBigDecimal(2, omtColName, periodOmt);
                    this.balData.updateBigDecimal(4, omtColName, yearOmt);
                }
            }
            if (!this.displayAmount) continue;
            String qtyColName = dcCol + "Qty_" + i;
            if (this.fetchSbPeriodYear == curPeriodYear) {
                yearQty = GlUtils.add(this.getFetchSbBalDataDecimal(qtyColName), yearQty);
            }
            this.balData.updateBigDecimal(1, qtyColName, periodQty);
            this.balData.updateBigDecimal(3, qtyColName, yearQty);
            if (this.condition.isNotIncluePLVoucher() || !this.isPLAccount) continue;
            this.balData.updateBigDecimal(2, qtyColName, periodQty);
            this.balData.updateBigDecimal(4, qtyColName, yearQty);
        }
    }

    protected void clearBalDataYearSum() throws BOSException {
        String[] columnNames = this.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i].contains("Balance") || columnNames[i].equals("Orginal_DC") || columnNames[i].contains("Mu")) continue;
            this.balData.updateObject(3, columnNames[i], null);
            this.balData.updateObject(4, columnNames[i], null);
        }
    }

    protected abstract String getQuerySql(GLRptID[] var1) throws BOSException, EASBizException;

    protected abstract String getQuerySql(GLRptID[] var1, String var2) throws BOSException, EASBizException;

    protected void toGLRptRowData(IRowSet rs, IGLRptRowData rowData, boolean isAll) throws SQLException, EASBizException, BOSException {
        String[] columnNames = this.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i].equals("bizDate")) {
                rowData.updateDate(columnNames[i], rs.getDate(columnNames[i]));
                continue;
            }
            if (!columnNames[i].equals("voucherTypeName") && !columnNames[i].equals("description") && !columnNames[i].equals("Orginal_DC") && !columnNames[i].equals("no") && !columnNames[i].equals("FSourceType") && !columnNames[i].equals("voucherId")) continue;
            rowData.updateObject(columnNames[i], rs.getString(columnNames[i]));
        }
        int no = rs.getInt("no");
        if (no == -1) {
            String periodId = rs.getString("fperiodid");
            int periodYear = rs.getInt("FPeriodYear");
            this.fetchSbPerId = periodId;
            this.fetchSbPeriodYear = periodYear;
            if (isAll) {
                this.dealStartBalance(rs, rowData, true);
            } else {
                this.copyRowData(this.sBalRowData, rowData);
            }
            if (this.fetchSbBalData == null) {
                this.fetchSbBalData = this.fromGlRptRowSet(this.balData);
                String cColName = "Credit_Sum";
                String dColName = "Debit_Sum";
                String dcColName = "Orginal_DC";
                String balColName = "Balance_Amount";
                for (int i = 0; i < 5; ++i) {
                    String balanceDc;
                    BigDecimal debit = this.fetchSbBalData.getBigDecimal(i, dColName);
                    BigDecimal credit = this.fetchSbBalData.getBigDecimal(i, cColName);
                    if (debit == null || credit == null) continue;
                    BigDecimal balance = debit.subtract(credit);
                    if (balance.signum() == 1) {
                        balanceDc = GLResUtil.getRes("debit", this.ctx);
                    } else if (balance.signum() == -1) {
                        balanceDc = GLResUtil.getRes("credit", this.ctx);
                        balance = balance.negate();
                    } else {
                        balanceDc = GLResUtil.getRes("dir_equal", this.ctx);
                    }
                    this.fetchSbBalData.updateString(i, dcColName, balanceDc);
                    this.fetchSbBalData.updateBigDecimal(i, balColName, balance);
                }
            }
        } else if (no == 0) {
            this.dealVchLine(rs, rowData);
        } else {
            this.dealSumLine(rs, rowData);
        }
    }

    protected void copyRowData(GLRptRowSet from, IGLRptRowData to) throws SQLException, BOSException {
        String[] columnNames = this.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i].equals("bizDate") || columnNames[i].equals("voucherTypeName") || columnNames[i].equals("description") || columnNames[i].equals("no") || columnNames[i].equals("FSourceType") || columnNames[i].equals("voucherId")) continue;
            to.updateObject(columnNames[i], from.getObject(0, columnNames[i]));
        }
    }

    private void copyRowDataForRow(GLRptRowSet from, GLRptRowSet to, int index) throws BOSException {
        String[] columnNames;
        for (String columnName : columnNames = this.getColumnNames()) {
            to.updateObject(index, columnName, from.getObject(index, columnName));
        }
    }

    protected void dealSumLine(IRowSet rs, IGLRptRowData rowData) throws SQLException, BOSException {
        int no = rs.getInt("no");
        if (this.condition != null && this.condition.isNotIncluePLVoucher() && (no == 2 || no == 4)) {
            return;
        }
        if (no == 5) {
            no = 0;
        }
        String[] columnNames = this.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnNames[i].equals("bizDate") || columnNames[i].equals("voucherTypeName") || columnNames[i].equals("description") || columnNames[i].equals("no") || columnNames[i].equals("FSourceType") || columnNames[i].equals("voucherId")) continue;
            if (columnNames[i].contains("Mu") || columnNames[i].equals("Orginal_DC")) {
                rowData.updateString(columnNames[i], this.balData.getString(no, columnNames[i]));
                continue;
            }
            BigDecimal amountSum = this.balData.getBigDecimal(no, columnNames[i]);
            if (amountSum == null) {
                amountSum = BigDecimal.ZERO;
            }
            if ((no == 2 || no == 4) && columnNames[i].equals("Balance_Amount")) {
                BigDecimal debitSum = rowData.getBigDecimal("Debit_Sum") == null ? BigDecimal.ZERO : rowData.getBigDecimal("Debit_Sum");
                BigDecimal creditSum = rowData.getBigDecimal("Credit_Sum") == null ? BigDecimal.ZERO : rowData.getBigDecimal("Credit_Sum");
                Object[] amountAndDC = this.autoBanlanceDc(debitSum.subtract(creditSum));
                rowData.updateString("Orginal_DC", (String)amountAndDC[1]);
                this.balData.updateString(no, "Orginal_DC", (String)amountAndDC[1]);
                this.balData.updateBigDecimal(no, "Balance_Amount", (BigDecimal)amountAndDC[0]);
                amountSum = (BigDecimal)amountAndDC[0];
            }
            rowData.updateBigDecimal(columnNames[i], amountSum);
            if (no != 1 && no != 2 || columnNames[i].contains("Balance")) continue;
            this.balData.updateBigDecimal(no, columnNames[i], null);
        }
    }

    protected abstract void createSumLineSql(IRowSet var1, StringBuffer var2, SqlParams var3) throws EASBizException, BOSException, SQLException;

    protected void initColHideMap() throws SQLException, EASBizException, BOSException {
        StringBuffer selectPsql = new StringBuffer();
        SqlParams selectPsp = new SqlParams();
        int selectindex = 1;
        this.sBalRowData = new GLRptRowSet(this.getColumnNames(), 1);
        this.sBalRowData.insertRow();
        if (this.balData == null) {
            this.balData = new GLRptRowSet(this.getColumnNames(), 5);
        }
        selectPsql.append("select p.fid fperiodid, p.fperiodyear, p.fperiodNumber from T_BD_Period p \r\n");
        selectPsql.append("where p.ftypeid = ? \r\n");
        selectPsql.append(" and p.fperiodYear = ? and p.fperiodNumber = ? ");
        selectPsp.setString(selectindex++, this.periodType);
        selectPsp.setInt(selectindex++, this.periodRange[0]);
        selectPsp.setInt(selectindex++, this.periodRange[1]);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectPsql.toString(), (Object[])selectPsp.getParams());
            if (rs.next()) {
                this.preLinePYear = rs.getInt("fperiodyear");
                String periodId = rs.getString("fperiodid");
                this.isInitPeriod = this.isInitPeriod(periodId);
                this.dealStartBalance(rs, this.sBalRowData, true);
            }
        }
        catch (SQLDataException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
        if (this.noDisplayNoCol) {
            String[] columnNames = this.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                this.colHideMap.put(columnNames[i], this.sBalRowData.getObject(columnNames[i]));
            }
            this.initColHideMapByVch();
        }
    }

    protected abstract void createInitColHideMapByVchSql(StringBuffer var1);

    protected void initColHideMapByVch() throws SQLException, BOSException {
        String hCurId = null;
        String lCurId = null;
        StringBuffer sql = new StringBuffer();
        this.createInitColHideMapByVchSql(sql);
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rs.next()) {
                for (int mu = 0; mu < this.itemList.size(); ++mu) {
                    for (int cur = 0; cur < this.currencys.size(); ++cur) {
                        hCurId = this.currencys.get(cur).getId().toString();
                        lCurId = rs.getString("FCurrencyID");
                        if (!this.checkColItem(rs, mu) || hCurId == null || lCurId == null || !hCurId.equals(lCurId)) continue;
                        if (mu < this.debitSize) {
                            this.initColHideMapByVchDC(1, hCurId, mu, cur);
                            continue;
                        }
                        this.initColHideMapByVchDC(0, hCurId, mu, cur);
                    }
                }
            }
        }
        catch (SQLDataException e) {
            throw new BOSException("SQL ERROR!", (Throwable)e);
        }
    }

    protected void initColHideMapByVchDC(int dc, String hCurId, int mu, int cur) {
        String dcCol = dc == 1 ? "Debit" : "Credit";
        String oAmountColName = new StringBuffer(dcCol).append("For_").append(mu).append("_").append(cur).toString();
        String locColName = new StringBuffer(dcCol).append("Local_").append(mu).append("_").append(cur).toString();
        String muColName = new StringBuffer(dcCol).append("Mu_").append(mu).append("_").append(cur).toString();
        String qtyColName = new StringBuffer(dcCol).append("Qty_").append(mu).append("_").append(cur).toString();
        String priColName = new StringBuffer(dcCol).append("Price_").append(mu).append("_").append(cur).toString();
        if (this.displayOrigine && !hCurId.equals(this.baseCurrencyId)) {
            this.colHideMap.put(oAmountColName, GlUtils.one);
        }
        this.colHideMap.put(locColName, GlUtils.one);
        if (this.displayAmount) {
            this.colHideMap.put(muColName, "mu");
            this.colHideMap.put(qtyColName, GlUtils.one);
            this.colHideMap.put(priColName, GlUtils.one);
        }
    }

    protected void dealVchLine(IRowSet rs, IGLRptRowData rowData) throws SQLException, BOSException {
        VoucherLineData lineData = new VoucherLineData(rs, this.displayAmount);
        this.dealVchLineDCSumAndBalance(rowData, lineData);
        String hCurId = null;
        int currencyIndex = -1;
        for (int i = 0; i < this.currencys.size(); ++i) {
            hCurId = this.currencys.get(i).getId().toString();
            if (hCurId == null || !hCurId.equals(lineData.getCurrencyID())) continue;
            currencyIndex = i;
            break;
        }
        if (currencyIndex == -1) {
            return;
        }
        int itemIndex = -1;
        for (int i = 0; i < this.itemList.size(); ++i) {
            if (i == 0) {
                this.getDetailMeasure(lineData, rs);
                this.dealVchLineCurSumDC(rowData, lineData, currencyIndex);
            }
            if (this.checkColItem_absolute(rs, i)) {
                itemIndex = i;
                this.dealVchLineColsDC(rs, rowData, lineData, itemIndex, currencyIndex);
                continue;
            }
            if (!this.checkColItem(rs, i)) continue;
            itemIndex = i;
            boolean dspStandard = lineData.isDetailDspStandard();
            if (!dspStandard) {
                lineData.setDetailDspStandard(true);
            }
            String detailMu = lineData.getDetailDspMu();
            lineData.setDetailDspMu(null);
            this.dealVchLineColsDC(rs, rowData, lineData, itemIndex, currencyIndex);
            lineData.setDetailDspStandard(dspStandard);
            lineData.setDetailDspMu(detailMu);
        }
    }

    protected void dealVchLineColsDC(IRowSet rs, IGLRptRowData rowData, VoucherLineData lineData, int itemIndex, int currencyIndex) throws BOSException, SQLException {
        int row;
        String dcCol;
        if (this.fetchDataType == 1 && lineData.getActDC() != 1 || this.fetchDataType == 2 && lineData.getActDC() != 0) {
            return;
        }
        boolean dc = true;
        if (itemIndex >= this.debitSize) {
            dc = false;
        }
        String headCurrencyId = this.currencys.get(currencyIndex).getId().toString();
        String periodId = lineData.getPeriodID();
        BigDecimal oAmountCol = lineData.getOriginalAmount();
        BigDecimal locAmountCol = lineData.getLocalAmount();
        BigDecimal qtyCol = lineData.getQuantity();
        BigDecimal standardQtyCol = lineData.getStdQuantity();
        if (dc) {
            dcCol = "Debit";
            if (lineData.getActDC() != 1) {
                oAmountCol = lineData.getOriginalAmount().negate();
                locAmountCol = lineData.getLocalAmount().negate();
                if (this.displayAmount) {
                    qtyCol = lineData.getQuantity().negate();
                    standardQtyCol = lineData.getStdQuantity().negate();
                }
            }
        } else {
            dcCol = "Credit";
            if (lineData.getActDC() != 0) {
                oAmountCol = lineData.getOriginalAmount().negate();
                locAmountCol = lineData.getLocalAmount().negate();
                if (this.displayAmount) {
                    qtyCol = lineData.getQuantity().negate();
                    standardQtyCol = lineData.getStdQuantity().negate();
                }
            }
        }
        String oAmountColName = new StringBuffer(dcCol).append("For_").append(itemIndex).append("_").append(currencyIndex).toString();
        String locAmountColName = new StringBuffer(dcCol).append("Local_").append(itemIndex).append("_").append(currencyIndex).toString();
        String muColName = new StringBuffer(dcCol).append("Mu_").append(itemIndex).append("_").append(currencyIndex).toString();
        String qtyColName = new StringBuffer(dcCol).append("Qty_").append(itemIndex).append("_").append(currencyIndex).toString();
        String priceColName = new StringBuffer(dcCol).append("Price_").append(itemIndex).append("_").append(currencyIndex).toString();
        if (this.displayOrigine && !headCurrencyId.equals(this.baseCurrencyId)) {
            this.updateRowAmount(rowData, oAmountColName, oAmountCol);
            if (!periodId.equals(this.fetchSbPerId)) {
                for (row = 0; row < 5; ++row) {
                    this.updateBalDataCache(row, oAmountColName, oAmountCol);
                }
            }
        }
        this.updateRowAmount(rowData, locAmountColName, locAmountCol);
        if (!periodId.equals(this.fetchSbPerId)) {
            for (row = 0; row < 5; ++row) {
                if (lineData.getSourceType() == 1 && (row == 2 || row == 4)) continue;
                this.updateBalDataCache(row, locAmountColName, locAmountCol);
            }
        }
        if (this.displayAmount) {
            if (lineData.isDetailDspStandard()) {
                qtyCol = standardQtyCol;
            }
            if (!periodId.equals(this.fetchSbPerId)) {
                for (row = 0; row < 5; ++row) {
                    if (lineData.getSourceType() == 1 && (row == 2 || row == 4)) continue;
                    this.updateBalDataCache(row, qtyColName, standardQtyCol);
                }
            }
            this.updateRowPriceMu(rowData, locAmountColName, qtyColName, qtyCol, priceColName, muColName, lineData.getDetailDspMu());
            if (!periodId.equals(this.fetchSbPerId)) {
                for (row = 0; row < 5; ++row) {
                    BigDecimal locAmount = this.balData.getBigDecimal(row, locAmountColName);
                    this.updateRowPriceMu(this.balData, row, qtyColName, priceColName, muColName, this.getUniqueMeasureUnitName4Item(itemIndex), locAmount);
                }
            }
        }
    }

    protected abstract void getDetailMeasure(VoucherLineData var1, IRowSet var2) throws SQLException;

    protected void dealVchLineCurSumDC(IGLRptRowData rowData, VoucherLineData lineData, int currencyIndex) throws BOSException {
        int row;
        String dcCol = "Debit";
        if (lineData.getActDC() == 0) {
            dcCol = "Credit";
        }
        String hCurId = this.currencys.get(currencyIndex).getId().toString();
        String sumColName = new StringBuffer(dcCol).append("_Sum").toString();
        String curOAmountColName = new StringBuffer(dcCol).append("For_").append(currencyIndex).toString();
        String curLocAmountColName = new StringBuffer(dcCol).append("Local_").append(currencyIndex).toString();
        String curQtyColName = new StringBuffer(dcCol).append("Qty_").append(currencyIndex).toString();
        String curPriceColName = new StringBuffer(dcCol).append("Price_").append(currencyIndex).toString();
        String curMuColName = new StringBuffer(dcCol).append("Mu_").append(currencyIndex).toString();
        if (this.displayOrigine && !hCurId.equals(this.baseCurrencyId)) {
            this.updateRowAmount(rowData, curOAmountColName, lineData.getOriginalAmount());
            if (!lineData.getPeriodID().equals(this.fetchSbPerId)) {
                for (row = 1; row < 5; ++row) {
                    if (lineData.getSourceType() == 1 && (row == 2 || row == 4)) continue;
                    this.updateBalDataCache(row, curOAmountColName, lineData.getOriginalAmount());
                }
            }
        }
        if (this.currencySize > 1) {
            this.updateRowAmount(rowData, curLocAmountColName, lineData.getLocalAmount());
            if (!lineData.getPeriodID().equals(this.fetchSbPerId)) {
                for (row = 1; row < 5; ++row) {
                    if (lineData.getSourceType() == 1 && (row == 2 || row == 4)) continue;
                    this.updateBalDataCache(row, curLocAmountColName, lineData.getLocalAmount());
                }
            }
        }
        if (this.displayAmount) {
            BigDecimal qty = lineData.isDetailDspStandard() ? lineData.getStdQuantity() : lineData.getQuantity();
            if (!lineData.getPeriodID().equals(this.fetchSbPerId)) {
                for (int row2 = 1; row2 < 5; ++row2) {
                    if (lineData.getSourceType() == 1 && (row2 == 2 || row2 == 4)) continue;
                    this.updateBalDataCache(row2, curQtyColName, lineData.getStdQuantity());
                }
            }
            String amountColName = null;
            amountColName = this.currencySize > 1 ? curLocAmountColName : sumColName;
            this.updateRowPriceMu(rowData, amountColName, curQtyColName, qty, curPriceColName, curMuColName, lineData.getDetailDspMu());
            if (!lineData.getPeriodID().equals(this.fetchSbPerId)) {
                for (int row3 = 1; row3 < 5; ++row3) {
                    if (lineData.getSourceType() == 1 && (row3 == 2 || row3 == 4)) continue;
                    BigDecimal locAmount = this.balData.getBigDecimal(row3, amountColName);
                    this.updateRowPriceMu(this.balData, row3, curQtyColName, curPriceColName, curMuColName, null, locAmount);
                }
            }
        }
    }

    protected void dealVchLineDCSumAndBalance(IGLRptRowData rowData, VoucherLineData lineData) throws BOSException {
        String dSumColName = "Debit_Sum";
        String cSumColName = "Credit_Sum";
        if (lineData.getActDC() == 1) {
            this.updateRowAmount(rowData, dSumColName, lineData.getLocalAmount());
            if (!lineData.getPeriodID().equals(this.fetchSbPerId)) {
                for (int row = 1; row < 5; ++row) {
                    if (lineData.getSourceType() == 1 && (row == 2 || row == 4)) continue;
                    this.updateBalDataCache(row, dSumColName, lineData.getLocalAmount());
                }
            }
        } else {
            this.updateRowAmount(rowData, cSumColName, lineData.getLocalAmount());
            if (!lineData.getPeriodID().equals(this.fetchSbPerId)) {
                for (int row = 1; row < 5; ++row) {
                    if (lineData.getSourceType() == 1 && (row == 2 || row == 4)) continue;
                    this.updateBalDataCache(row, cSumColName, lineData.getLocalAmount());
                }
            }
        }
        if (!this.includeNoTransPLVoucher && lineData.getSourceType() == 1) {
            if (lineData.getActDC() == 1) {
                this.plBalances[0] = this.plBalances[0].add(lineData.getStdQuantity());
                this.plBalances[1] = this.plBalances[1].add(lineData.getLocalAmount());
            } else {
                this.plBalances[0] = this.plBalances[0].subtract(lineData.getStdQuantity());
                this.plBalances[1] = this.plBalances[1].subtract(lineData.getLocalAmount());
            }
        }
        if (lineData.getActDC() == 1) {
            this.balances[0] = this.balances[0].add(lineData.getStdQuantity());
            this.balances[1] = this.balances[1].add(lineData.getLocalAmount());
        } else {
            this.balances[0] = this.balances[0].subtract(lineData.getStdQuantity());
            this.balances[1] = this.balances[1].subtract(lineData.getLocalAmount());
        }
        this.dealLineBalance(rowData, true);
    }

    protected Object[] autoBanlanceDc(BigDecimal balance) {
        if (balance == null || balance.compareTo(GlUtils.zero) == 0) {
            return new Object[]{GlUtils.zero, GLResUtil.getRes("dir_equal", this.ctx)};
        }
        if (!this.isBalanceDirSameAsAccount) {
            if (balance.compareTo(GlUtils.zero) == -1) {
                return new Object[]{balance.negate(), GLResUtil.getRes("credit", this.ctx)};
            }
            return new Object[]{balance, GLResUtil.getRes("debit", this.ctx)};
        }
        if (this.accountDc == 1) {
            return new Object[]{balance, GLResUtil.getRes("debit", this.ctx)};
        }
        return new Object[]{balance.negate(), GLResUtil.getRes("credit", this.ctx)};
    }

    protected void dealStartBalance(IRowSet rs, IGLRptRowData rowData, boolean isFirst) throws BOSException, EASBizException, SQLException {
        String dSumColName = "Debit_Sum";
        String cSumColName = "Credit_Sum";
        BigDecimal[] periodSum = new BigDecimal[]{GlUtils.zero, GlUtils.zero};
        BigDecimal[] periodPLSum = new BigDecimal[]{GlUtils.zero, GlUtils.zero};
        BigDecimal[] yearSum = new BigDecimal[]{GlUtils.zero, GlUtils.zero};
        BigDecimal[] yearPLSum = new BigDecimal[]{GlUtils.zero, GlUtils.zero};
        StringBuffer sql = new StringBuffer();
        SqlParams sp = new SqlParams();
        this.createSumLineSql(rs, sql, sp);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])sp.getParams());
            this.dealLineBalance(rowData, isFirst);
            while (rowSet.next()) {
                String lCurId = rowSet.getString("FCurrencyID");
                BigDecimal debitLocal = rowSet.getBigDecimal("FDebitLocal");
                BigDecimal creditLocal = rowSet.getBigDecimal("FCreditLocal");
                BigDecimal yearDebitLocal = rowSet.getBigDecimal("FyearDebitLocal");
                BigDecimal yearCreditLocal = rowSet.getBigDecimal("FyearCreditLocal");
                BigDecimal plVDebitLocal = rowSet.getBigDecimal("DebitLocal");
                BigDecimal plVCreditLocal = rowSet.getBigDecimal("CreditLocal");
                BigDecimal plvYDebitLocal = rowSet.getBigDecimal("yDebitLocal");
                BigDecimal plvYCreditLocal = rowSet.getBigDecimal("yCreditLocal");
                BigDecimal balance = rowSet.getBigDecimal("FbeginbalanceLocal");
                BigDecimal balQty = rowSet.getBigDecimal("Fbeginqty");
                this.balances[1] = this.balances[1].add(balance);
                this.balances[0] = this.balances[0].add(balQty);
                this.dealLineBalance(rowData, isFirst);
                if (this.includeNoTransPLVoucher) {
                    periodSum[0] = periodSum[0].add(debitLocal.subtract(plVDebitLocal));
                    periodSum[1] = periodSum[1].add(creditLocal.subtract(plVCreditLocal));
                    yearSum[0] = yearSum[0].add(yearDebitLocal.subtract(plvYDebitLocal));
                    yearSum[1] = yearSum[1].add(yearCreditLocal.subtract(plvYCreditLocal));
                } else {
                    periodSum[0] = periodSum[0].add(debitLocal);
                    periodSum[1] = periodSum[1].add(creditLocal);
                    yearSum[0] = yearSum[0].add(yearDebitLocal);
                    yearSum[1] = yearSum[1].add(yearCreditLocal);
                    if (this.isPLAccount) {
                        periodPLSum[0] = periodPLSum[0].add(debitLocal.subtract(plVDebitLocal));
                        periodPLSum[1] = periodPLSum[1].add(creditLocal.subtract(plVCreditLocal));
                        yearPLSum[0] = yearPLSum[0].add(yearDebitLocal.subtract(plvYDebitLocal));
                        yearPLSum[1] = yearPLSum[1].add(yearCreditLocal.subtract(plvYCreditLocal));
                    }
                }
                for (int mu = 0; mu < this.itemList.size(); ++mu) {
                    for (int cur = 0; cur < this.currencys.size(); ++cur) {
                        String hCurId = this.currencys.get(cur).getId().toString();
                        if (mu == 0 && hCurId != null && hCurId.equals(lCurId)) {
                            this.dealStartBalanceCurSum(rowSet, cur, periodSum, periodPLSum, yearSum, yearPLSum);
                        }
                        if (!this.checkColItem(rowSet, mu) || hCurId == null || !hCurId.equals(lCurId)) continue;
                        if (mu < this.debitSize) {
                            this.dealStartBalanceCurColsDC(rowSet, rowData, cur, mu, isFirst, 1);
                            continue;
                        }
                        this.dealStartBalanceCurColsDC(rowSet, rowData, cur, mu, isFirst, 0);
                    }
                }
            }
            this.balData.updateBigDecimal(1, dSumColName, periodSum[0]);
            this.balData.updateBigDecimal(1, cSumColName, periodSum[1]);
            this.balData.updateBigDecimal(3, dSumColName, yearSum[0]);
            this.balData.updateBigDecimal(3, cSumColName, yearSum[1]);
            if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                this.balData.updateBigDecimal(2, dSumColName, periodPLSum[0]);
                this.balData.updateBigDecimal(2, cSumColName, periodPLSum[1]);
                this.balData.updateBigDecimal(4, dSumColName, yearPLSum[0]);
                this.balData.updateBigDecimal(4, cSumColName, yearPLSum[1]);
            }
        }
        catch (SQLDataException e) {
            throw new BOSException("SQL ERROR!" + sp.sql((Object)sql.toString()), (Throwable)e);
        }
    }

    protected String getAmountSelectSQL(SqlParams sp, IRowSet rs, String suffix) throws SQLException {
        int startPeriod;
        String periodId = rs.getString("fperiodid");
        int pYear = rs.getInt("fperiodyear");
        int pNumber = rs.getInt("fperiodNumber");
        int period = pYear * 100 + pNumber;
        int endPeriod = startPeriod = pYear * 100 + pNumber;
        int endPeriodYear = pYear;
        int index = sp.size() + 1;
        StringBuffer sql = new StringBuffer();
        sql.append(" ,sum(case ");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.fbeginbalance").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber then gl.fendbalance").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod > cp.fnumber and gl.fperiod < ? then gl.fdebit").append(suffix).append(" - gl.fcredit").append(suffix).append(" \r\n");
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sql.append(" else 0 end) fbeginbalance").append(suffix).append(",\r\n");
        sql.append(" sum(case when gl.Fperiod = ? then gl.FDebit").append(suffix).append(" else 0 end").append(") FDebit").append(suffix);
        sql.append(",sum(case when gl.Fperiod = ? then gl.FCredit").append(suffix).append(" else 0 end").append(") FCredit").append(suffix);
        sp.setInt(index++, period);
        sp.setInt(index++, period);
        sql.append(", sum(case when gl.Fperiod = ? then gl.Fmonthpnl").append(suffix).append(" else 0 end").append(") Fmonthpnl").append(suffix);
        sp.setInt(index++, period);
        sql.append(", sum(case ");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.fyeardebit").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber and TO_INT(gl.fperiod/100) = ? then gl.fyeardebit").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod> cp.fnumber and TO_INT(gl.fperiod/100) = ?  then gl.fdebit").append(suffix).append(" \r\n");
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sql.append(" else 0 end) fyeardebit").append(suffix).append(", \r\n");
        sql.append(" sum(case ");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.fyearcredit").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber and TO_INT(gl.fperiod/100) = ? then gl.fyearcredit").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod > cp.fnumber and TO_INT(gl.fperiod/100) = ?  then gl.fcredit").append(suffix).append(" \r\n");
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sql.append(" else 0 end) fyearcredit").append(suffix).append(", \r\n");
        sql.append(" sum(case ");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.Fyearpnl").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber and TO_INT(gl.fperiod/100) = ? then gl.Fyearpnl").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod > cp.fnumber and TO_INT(gl.fperiod/100) = ?  then gl.Fmonthpnl").append(suffix).append(" \r\n");
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sql.append(" else 0 end) Fyearpnl").append(suffix).append(", \r\n");
        sql.append(" sum(case ");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.fendbalance").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber  then gl.fendbalance").append(suffix).append(" \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod > cp.fnumber then gl.fdebit").append(suffix).append(" - gl.fcredit").append(suffix).append(" \r\n");
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sql.append(" else 0 end) fendbalance").append(suffix).append(" \r\n");
        return sql.toString();
    }

    protected String getQtySelectSQL(SqlParams sp, IRowSet rs) throws SQLException {
        int startPeriod;
        String periodId = rs.getString("fperiodid");
        int pYear = rs.getInt("fperiodyear");
        int pNumber = rs.getInt("fperiodNumber");
        int period = pYear * 100 + pNumber;
        int endPeriod = startPeriod = pYear * 100 + pNumber;
        int endPeriodYear = pYear;
        int index = sp.size() + 1;
        StringBuffer sql = new StringBuffer();
        sql.append(" ,sum(case \r\n");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.fbeginQty \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber then gl.fendQty \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod > cp.fnumber and gl.fperiod < ? then gl.fdebitQty - gl.fcreditQty \r\n");
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sp.setInt(index++, startPeriod);
        sql.append(" else 0 end) fbeginQty,\r\n");
        sql.append(" sum(case when gl.Fperiod = ? then gl.FDebitQty else 0 end").append(") FDebitQty");
        sql.append(",sum(case when gl.Fperiod = ? then gl.FCreditQty else 0 end").append(") FCreditQty, ");
        sp.setInt(index++, period);
        sp.setInt(index++, period);
        sql.append(" sum(case \r\n");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.fyeardebitQty \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber and TO_INT(gl.fperiod/100) = ? then gl.fyeardebitQty \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod > cp.fnumber and TO_INT(gl.fperiod/100) = ?  then gl.fdebitQty \r\n");
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sql.append(" else 0 end) fyeardebitQty, \r\n");
        sql.append(" sum(case \r\n");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.fyearcreditQty \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber and TO_INT(gl.fperiod/100) = ? then gl.fyearcreditQty \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod > cp.fnumber and TO_INT(gl.fperiod/100) = ?  then gl.fcreditQty \r\n");
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriodYear);
        sql.append(" else 0 end) fyearcreditQty, \r\n");
        sql.append(" sum(case \r\n");
        sql.append(" when ? >= sp.fnumber and ? <= cp.fnumber and gl.fperiod = ? then gl.fendQty \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod = cp.fnumber then gl.fendQty \r\n");
        sql.append(" when ? > cp.fnumber and gl.fperiod > cp.fnumber then gl.fdebitQty - gl.fcreditQty \r\n");
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sp.setInt(index++, endPeriod);
        sql.append(" else 0 end) fendQty \r\n");
        return sql.toString();
    }

    protected abstract boolean checkColItem(IRowSet var1, int var2) throws SQLException;

    protected abstract boolean checkColItem_absolute(IRowSet var1, int var2) throws SQLException;

    protected List getTableData() {
        return this.condition.getTableData();
    }

    protected void fiterHg(StringBuffer sql, SqlParams sp, String accountTableName) throws BOSException {
        List data = this.getTableData();
        SqlParams asstWhereSp = new SqlParams();
        sql.append(" and ");
        try {
            sql.append(RptServerUtil.GetAsstSqlWithoutPermissionFilter(this.ctx, data, false, true, "HG.FID", asstWhereSp));
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sp.addParams(asstWhereSp);
        HashMap<String, AsstactTypeEntity> actTypes = new HashMap<String, AsstactTypeEntity>();
        boolean needHandlePerm = false;
        List tblData = this.getTableData();
        int size = tblData.size();
        for (int i = 0; i < size; ++i) {
            AsstactTypeEntity at = (AsstactTypeEntity)tblData.get(i);
            actTypes.put(at.getId().toString(), at);
            if (!at.isEnabledPermissionLimit()) continue;
            needHandlePerm = true;
        }
        if (needHandlePerm) {
            Map<String, List<List<String>>> accountAsstActListActTypeListMap = this.findAccountActTypeListMap();
            HashSet intersectActType = new HashSet();
            for (List list : accountAsstActListActTypeListMap.values()) {
                for (List actTypeList : list) {
                    intersectActType.addAll(actTypeList);
                }
            }
            BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId();
            BOSUuid bOSUuid = ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId();
            HashMap<String, Object[]> asst2PermSql = new HashMap<String, Object[]>();
            IPermissionServiceProvider provider = PermissionServiceProviderFactory.getLocalInstance((Context)this.ctx);
            IPermission permission = PermissionFactory.getLocalInstance((Context)this.ctx);
            for (String actTypeId : intersectActType) {
                String permSql;
                String asstRule;
                AsstactTypeEntity at = (AsstactTypeEntity)actTypes.get(actTypeId);
                if (at == null || !at.isEnabledPermissionLimit()) continue;
                try {
                    asstRule = provider.getPermissionRule((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(bOSUuid), at.getPermissionItem());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                if (StringUtils.isEmpty((String)asstRule)) continue;
                try {
                    permSql = permission.getQueryPermissionSQL((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(bOSUuid), at.getPermissionItem());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                asst2PermSql.put(at.getId(), new Object[]{at, permSql});
            }
            if (asst2PermSql.size() > 0) {
                StringBuilder collectAsstPermSql = new StringBuilder();
                StringBuilder acctAsstPermSql = new StringBuilder();
                for (Map.Entry<String, List<List<String>>> entry : accountAsstActListActTypeListMap.entrySet()) {
                    String accountId = entry.getKey();
                    List<List<String>> asstActList = entry.getValue();
                    for (List<String> actTypeList : asstActList) {
                        acctAsstPermSql.setLength(0);
                        for (String actTypeId : actTypeList) {
                            Object[] actTypePermSqlObjects = (Object[])asst2PermSql.get(actTypeId);
                            if (actTypePermSqlObjects == null) continue;
                            if (acctAsstPermSql.length() > 0) {
                                acctAsstPermSql.append(" and ");
                            }
                            acctAsstPermSql.append("HG.").append(((AsstactTypeEntity)actTypePermSqlObjects[0]).getHgField()).append(" in (").append(actTypePermSqlObjects[1]).append(")");
                        }
                        if (acctAsstPermSql.length() <= 0) continue;
                        acctAsstPermSql.append(" and ").append(accountTableName).append(".FID='").append(accountId).append("'");
                        if (collectAsstPermSql.length() > 0) {
                            collectAsstPermSql.append(" or ");
                        }
                        collectAsstPermSql.append("(").append((CharSequence)acctAsstPermSql).append(")");
                    }
                    if (collectAsstPermSql.length() <= 0) continue;
                    sql.append(" and (").append((CharSequence)collectAsstPermSql).append(")");
                }
            }
        }
    }

    private Map<String, List<List<String>>> findAccountActTypeListMap() throws BOSException {
        if (this.accountAsstActListActTypeListMap == null) {
            this.accountAsstActListActTypeListMap = new HashMap<String, List<List<String>>>();
        }
        if (!this.accountAsstActListActTypeListMap.isEmpty()) {
            return this.accountAsstActListActTypeListMap;
        }
        int periodStart = this.periodRange[0] * 100 + this.periodRange[1];
        int periodEnd = this.periodRange[2] * 100 + this.periodRange[3];
        EntityViewInfo entityView = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("account.companyID.id", (Object)this.companyid, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("account.accountTableID.id", (Object)this.accountTableID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("account.isLeaf", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("account.longNumber", (Object)(this.accountView.getLongNumber() + "%"), CompareType.LIKE));
        entityView.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("account.id");
        selector.add("period.number");
        selector.add("before.id");
        selector.add("after.id");
        entityView.setSelector(selector);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("account.id"));
        sorter.add(new SorterItemInfo("period.number"));
        entityView.setSorter(sorter);
        AsstAccountChangeCollection asstAccountChangeHistory = AsstAccountChangeFactory.getLocalInstance((Context)this.ctx).getAsstAccountChangeCollection(entityView);
        HashMap accountAsstActListMap = new HashMap();
        HashSet asstAccountIdSet = new HashSet();
        for (AsstAccountChangeInfo aac : asstAccountChangeHistory) {
            String accountId = aac.getAccount().getId().toString();
            int periodNumber = aac.getPeriod().getNumber();
            ArrayList<String> asstAccountList = (ArrayList<String>)accountAsstActListMap.get(accountId);
            if (asstAccountList == null) {
                asstAccountList = new ArrayList<String>();
                accountAsstActListMap.put(accountId, asstAccountList);
                if (aac.getBefore() != null && periodStart < periodNumber) {
                    asstAccountList.add(aac.getBefore().getId().toString());
                }
            }
            if (aac.getAfter() == null) continue;
            if (periodEnd >= periodNumber) {
                asstAccountList.add(aac.getAfter().getId().toString());
            }
            asstAccountIdSet.addAll(asstAccountList);
        }
        entityView = new EntityViewInfo();
        filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("asstAccount.id", asstAccountIdSet, CompareType.INCLUDE));
        entityView.setFilter(filterInfo);
        selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("asstAccount.id");
        selector.add("asstActType.id");
        entityView.setSelector(selector);
        AsstActGroupDetailCollection asstActGroupDetailCollection = AsstActGroupDetailFactory.getLocalInstance((Context)this.ctx).getAsstActGroupDetailCollection(entityView);
        HashMap<String, ArrayList<String>> asstActActTypeListMap = new HashMap<String, ArrayList<String>>();
        for (AsstActGroupDetailInfo asstActGD : asstActGroupDetailCollection) {
            String asstAccountId = asstActGD.getAsstAccount().getId().toString();
            String asstActTypeId = asstActGD.getAsstActType().getId().toString();
            ArrayList<String> actTypeList = (ArrayList<String>)asstActActTypeListMap.get(asstAccountId);
            if (actTypeList == null) {
                actTypeList = new ArrayList<String>();
                asstActActTypeListMap.put(asstAccountId, actTypeList);
            }
            actTypeList.add(asstActTypeId);
        }
        for (Map.Entry accountAsstActListEntry : accountAsstActListMap.entrySet()) {
            String accountId = (String)accountAsstActListEntry.getKey();
            List asstActList = (List)accountAsstActListEntry.getValue();
            if (asstActList == null || asstActList.isEmpty()) continue;
            for (String asstActId : asstActList) {
                List actTypeList = (List)asstActActTypeListMap.get(asstActId);
                if (actTypeList == null || actTypeList.isEmpty()) continue;
                List<List<String>> asstActListActTypeList = this.accountAsstActListActTypeListMap.get(accountId);
                if (asstActListActTypeList == null) {
                    asstActListActTypeList = new ArrayList<List<String>>();
                    this.accountAsstActListActTypeListMap.put(accountId, asstActListActTypeList);
                }
                asstActListActTypeList.add(actTypeList);
            }
        }
        return this.accountAsstActListActTypeListMap;
    }

    protected void dealStartBalanceCurColsDC(IRowSet rowSet, IGLRptRowData rowData, int cur, int mu, boolean isFirst, int dc) throws SQLException, BOSException {
        BigDecimal locAmount;
        BigDecimal yLocAmount;
        BigDecimal sumLocAmount;
        String hCurId = this.currencys.get(cur).getId().toString();
        int speriodyear = rowSet.getInt("fsperiodyear");
        int periodyear = rowSet.getInt("fperiodyear");
        int property = rowSet.getInt("fproperty");
        BigDecimal endbalancefor = rowSet.getBigDecimal("fendbalancefor");
        BigDecimal endbalanceLocal = rowSet.getBigDecimal("fendbalanceLocal");
        BigDecimal debitFor = rowSet.getBigDecimal("FDebitFor");
        BigDecimal creditFor = rowSet.getBigDecimal("FCreditFor");
        BigDecimal yearDebitFor = rowSet.getBigDecimal("FyearDebitFor");
        BigDecimal yearCreditFor = rowSet.getBigDecimal("FyearCreditFor");
        BigDecimal plVDebitFor = rowSet.getBigDecimal("DebitFor");
        BigDecimal plVCreditFor = rowSet.getBigDecimal("CreditFor");
        BigDecimal plvYDebitFor = rowSet.getBigDecimal("yDebitFor");
        BigDecimal plvYCreditFor = rowSet.getBigDecimal("yCreditFor");
        BigDecimal plvSumDebitFor = rowSet.getBigDecimal("sumDebitFor");
        BigDecimal plvSumCreditFor = rowSet.getBigDecimal("sumCreditFor");
        BigDecimal debitLocal = rowSet.getBigDecimal("FDebitLocal");
        BigDecimal creditLocal = rowSet.getBigDecimal("FCreditLocal");
        BigDecimal debitQty = rowSet.getBigDecimal("FDebitQty");
        BigDecimal creditQty = rowSet.getBigDecimal("FCreditQty");
        BigDecimal yearDebitLocal = rowSet.getBigDecimal("FyearDebitLocal");
        BigDecimal yearCreditLocal = rowSet.getBigDecimal("FyearCreditLocal");
        BigDecimal yearDebitQty = rowSet.getBigDecimal("FyearDebitQty");
        BigDecimal yearCreditQty = rowSet.getBigDecimal("FyearCreditQty");
        BigDecimal plVDebitLocal = rowSet.getBigDecimal("DebitLocal");
        BigDecimal plVCreditLocal = rowSet.getBigDecimal("CreditLocal");
        BigDecimal plVDebitQty = rowSet.getBigDecimal("DebitQty");
        BigDecimal plVCreditQty = rowSet.getBigDecimal("CreditQty");
        BigDecimal plvYDebitLocal = rowSet.getBigDecimal("yDebitLocal");
        BigDecimal plvYCreditLocal = rowSet.getBigDecimal("yCreditLocal");
        BigDecimal plvYDebitQty = rowSet.getBigDecimal("yDebitQty");
        BigDecimal plvYCreditQty = rowSet.getBigDecimal("yCreditQty");
        BigDecimal plvSumDebitLocal = rowSet.getBigDecimal("sumDebitLocal");
        BigDecimal plvSumCreditLocal = rowSet.getBigDecimal("sumCreditLocal");
        BigDecimal qty = rowSet.getBigDecimal("Fbeginqty");
        BigDecimal debitOAmount = null;
        BigDecimal debitLocAmount = null;
        BigDecimal creditOAmount = null;
        BigDecimal creditLocAmount = null;
        BigDecimal debitCurQty = null;
        BigDecimal creditCurQty = null;
        BigDecimal[] plPeriodAmount = new BigDecimal[6];
        BigDecimal dYearOAmount = null;
        BigDecimal dYearLocAmount = null;
        BigDecimal cYearOAmount = null;
        BigDecimal cYearLocAmount = null;
        BigDecimal dYearCurQty = null;
        BigDecimal cYearCurQty = null;
        BigDecimal[] plYearAmount = new BigDecimal[6];
        BigDecimal dSumOAmount = null;
        BigDecimal dSumLocAmount = null;
        BigDecimal cSumOAmount = null;
        BigDecimal cSumLocAmount = null;
        Object dSumCurQty = null;
        Object cSumCurQty = null;
        BigDecimal yPLOAmount = GlUtils.zero;
        BigDecimal plOAmount = GlUtils.zero;
        BigDecimal yPLLocAmount = GlUtils.zero;
        BigDecimal plLocAmount = GlUtils.zero;
        BigDecimal yPLCurQty = GlUtils.zero;
        BigDecimal plCurQty = GlUtils.zero;
        BigDecimal psDebitFor = GlUtils.zero;
        BigDecimal psCreditFor = GlUtils.zero;
        BigDecimal psDebitLocal = GlUtils.zero;
        BigDecimal psCreditLocal = GlUtils.zero;
        BigDecimal psDebitQty = GlUtils.zero;
        BigDecimal psCreditQty = GlUtils.zero;
        String dcCol = dc == 1 ? "Debit" : "Credit";
        String oAmountColName = dcCol + "For_" + mu + "_" + cur;
        String locColName = dcCol + "Local_" + mu + "_" + cur;
        String muColName = dcCol + "Mu_" + mu + "_" + cur;
        String qtyColName = dcCol + "Qty_" + mu + "_" + cur;
        String priColName = dcCol + "Price_" + mu + "_" + cur;
        if (this.displayOrigine && !hCurId.equals(this.baseCurrencyId)) {
            BigDecimal yOAmount;
            BigDecimal oAmount;
            BigDecimal sumOAmount;
            BigDecimal sAmount = this.getColumnStartBalance(rowSet, mu, hCurId, "For");
            if (this.includeNoTransPLVoucher) {
                debitOAmount = debitFor.subtract(plVDebitFor);
                creditOAmount = creditFor.subtract(plVCreditFor);
                if (property != 4) {
                    dSumOAmount = sAmount.add(debitFor.subtract(plvSumDebitFor));
                    cSumOAmount = creditFor.subtract(plvSumCreditFor);
                    dYearOAmount = yearDebitFor.subtract(plvYDebitFor);
                    cYearOAmount = yearCreditFor.subtract(plvYCreditFor);
                } else {
                    dSumOAmount = sAmount.add(debitFor.subtract(plVDebitFor));
                    cSumOAmount = creditFor.subtract(plVCreditFor);
                    dYearOAmount = sAmount.add(debitFor.subtract(plVDebitFor));
                    cYearOAmount = creditFor.subtract(plVCreditFor);
                }
            } else {
                debitOAmount = debitFor;
                creditOAmount = creditFor;
                plPeriodAmount[0] = debitFor.subtract(plVDebitFor);
                plPeriodAmount[2] = creditFor.subtract(plVCreditFor);
                if (property != 4) {
                    dSumOAmount = sAmount.add(debitFor);
                    cSumOAmount = creditFor;
                    dYearOAmount = yearDebitFor;
                    cYearOAmount = yearCreditFor;
                    plYearAmount[0] = yearDebitFor.subtract(plvYDebitFor);
                    plYearAmount[2] = yearCreditFor.subtract(plvYCreditFor);
                } else {
                    dSumOAmount = sAmount.add(debitFor);
                    cSumOAmount = creditFor;
                    dYearOAmount = sAmount.add(debitFor);
                    cYearOAmount = creditFor;
                    plYearAmount[0] = sAmount.add(debitFor.subtract(plVDebitFor));
                    plYearAmount[2] = creditFor.subtract(plVCreditFor);
                }
            }
            if (this.fetchDataType == 0) {
                if (dc == 1) {
                    sumOAmount = dSumOAmount.subtract(cSumOAmount);
                    oAmount = debitOAmount.subtract(creditOAmount);
                    yOAmount = dYearOAmount.subtract(cYearOAmount);
                } else {
                    sumOAmount = cSumOAmount.subtract(dSumOAmount);
                    oAmount = creditOAmount.subtract(debitOAmount);
                    yOAmount = cYearOAmount.subtract(dYearOAmount);
                }
                if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                    if (dc == 1) {
                        plOAmount = plPeriodAmount[0].subtract(plPeriodAmount[2]);
                        yPLOAmount = plYearAmount[0].subtract(plYearAmount[2]);
                    } else {
                        plOAmount = plPeriodAmount[2].subtract(plPeriodAmount[0]);
                        yPLOAmount = plYearAmount[2].subtract(plYearAmount[0]);
                    }
                }
            } else if (this.fetchDataType == 1) {
                psCreditFor = rowSet.getBigDecimal("psCreditFor");
                if (this.includeNoTransPLVoucher) {
                    if (dc == 1) {
                        sumOAmount = dSumOAmount.subtract(cSumOAmount).add(psCreditFor.subtract(plvSumCreditFor));
                        yOAmount = yearDebitFor.subtract(plvYDebitFor);
                        oAmount = debitOAmount;
                    } else {
                        sumOAmount = dSumOAmount.subtract(cSumOAmount).add(psCreditFor.subtract(plvSumCreditFor)).negate();
                        yOAmount = yearDebitFor.subtract(plvYDebitFor).negate();
                        oAmount = debitOAmount.negate();
                    }
                } else if (dc == 1) {
                    sumOAmount = dSumOAmount.subtract(cSumOAmount).add(psCreditFor);
                    yOAmount = yearDebitFor.subtract(plvYDebitFor);
                    yPLOAmount = yearDebitFor.subtract(plvYDebitFor);
                    oAmount = debitOAmount;
                    plOAmount = plPeriodAmount[0];
                } else {
                    sumOAmount = dSumOAmount.subtract(cSumOAmount).add(psCreditFor).negate();
                    yOAmount = yearDebitFor.negate();
                    yPLOAmount = yearDebitFor.subtract(plvYDebitFor).negate();
                    oAmount = debitOAmount.negate();
                    plOAmount = plPeriodAmount[0].negate();
                }
            } else {
                psDebitFor = rowSet.getBigDecimal("psDebitFor");
                if (this.includeNoTransPLVoucher) {
                    if (dc == 1) {
                        sumOAmount = dSumOAmount.subtract(cSumOAmount).subtract(psDebitFor.subtract(plvSumDebitFor));
                        yOAmount = yearCreditFor.subtract(plvYCreditFor).negate();
                        oAmount = creditOAmount.negate();
                    } else {
                        sumOAmount = dSumOAmount.subtract(cSumOAmount).subtract(psDebitFor.subtract(plvSumDebitFor)).negate();
                        yOAmount = yearCreditFor.subtract(plvYCreditFor);
                        oAmount = creditOAmount;
                    }
                } else if (dc == 1) {
                    sumOAmount = dSumOAmount.subtract(cSumOAmount).subtract(psDebitFor);
                    yOAmount = yearCreditFor.negate();
                    yPLOAmount = yearCreditFor.subtract(plvYCreditFor).negate();
                    oAmount = creditOAmount.negate();
                    plOAmount = plPeriodAmount[2].negate();
                } else {
                    sumOAmount = dSumOAmount.subtract(cSumOAmount).subtract(psDebitFor).negate();
                    yOAmount = yearCreditFor;
                    yPLOAmount = yearCreditFor.subtract(plvYCreditFor);
                    oAmount = creditOAmount;
                    plOAmount = plPeriodAmount[2];
                }
            }
            this.updateBalDataCache(0, oAmountColName, sumOAmount);
            this.updateBalDataCache(1, oAmountColName, oAmount);
            this.updateBalDataCache(3, oAmountColName, yOAmount);
            if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                this.updateBalDataCache(2, oAmountColName, plOAmount);
                this.updateBalDataCache(4, oAmountColName, yPLOAmount);
            }
            if (isFirst) {
                if (dc == 1) {
                    this.updateRowAmount(rowData, oAmountColName, sAmount);
                } else {
                    this.updateRowAmount(rowData, oAmountColName, GlUtils.zero.subtract(sAmount));
                }
            }
        }
        BigDecimal sLoc = this.getColumnStartBalance(rowSet, mu, hCurId, "Local");
        this.startBalanceFlag = 1;
        if (this.includeNoTransPLVoucher) {
            debitLocAmount = debitLocal.subtract(plVDebitLocal);
            creditLocAmount = creditLocal.subtract(plVCreditLocal);
            if (property != 4) {
                dSumLocAmount = sLoc.add(debitLocal.subtract(plvSumDebitLocal));
                cSumLocAmount = creditLocal.subtract(plvSumCreditLocal);
                dYearLocAmount = yearDebitLocal.subtract(plvYDebitLocal);
                cYearLocAmount = yearCreditLocal.subtract(plvYCreditLocal);
            } else {
                dYearLocAmount = sLoc.add(debitLocal.subtract(plVDebitLocal));
                cYearLocAmount = creditLocal.subtract(plVCreditLocal);
                dSumLocAmount = sLoc.add(debitLocal.subtract(plVDebitLocal));
                cSumLocAmount = creditLocal.subtract(plVCreditLocal);
            }
        } else {
            debitLocAmount = debitLocal;
            creditLocAmount = creditLocal;
            plPeriodAmount[1] = debitLocal.subtract(plVDebitLocal);
            plPeriodAmount[3] = creditLocal.subtract(plVCreditLocal);
            if (property != 4) {
                dSumLocAmount = sLoc.add(debitLocal);
                cSumLocAmount = creditLocal;
                dYearLocAmount = yearDebitLocal;
                cYearLocAmount = yearCreditLocal;
                plYearAmount[1] = yearDebitLocal.subtract(plvYDebitLocal);
                plYearAmount[3] = yearCreditLocal.subtract(plvYCreditLocal);
            } else {
                dYearLocAmount = sLoc.add(debitLocal);
                cYearLocAmount = creditLocal;
                plYearAmount[1] = sLoc.add(debitLocal.subtract(plVDebitLocal));
                plYearAmount[3] = creditLocal.subtract(plVCreditLocal);
                dSumLocAmount = sLoc.add(debitLocal);
                cSumLocAmount = creditLocal;
            }
        }
        if (this.fetchDataType == 0) {
            if (dc == 1) {
                sumLocAmount = dSumLocAmount.subtract(cSumLocAmount);
                yLocAmount = dYearLocAmount.subtract(cYearLocAmount);
                locAmount = debitLocAmount.subtract(creditLocAmount);
            } else {
                sumLocAmount = cSumLocAmount.subtract(dSumLocAmount);
                yLocAmount = cYearLocAmount.subtract(dYearLocAmount);
                locAmount = creditLocAmount.subtract(debitLocAmount);
            }
            if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                if (dc == 1) {
                    plLocAmount = plPeriodAmount[1].subtract(plPeriodAmount[3]);
                    yPLLocAmount = plYearAmount[1].subtract(plYearAmount[3]);
                } else {
                    plLocAmount = plPeriodAmount[3].subtract(plPeriodAmount[1]);
                    yPLLocAmount = plYearAmount[3].subtract(plYearAmount[1]);
                }
            }
        } else if (this.fetchDataType == 1) {
            psCreditLocal = rowSet.getBigDecimal("psCreditLocal");
            if (this.includeNoTransPLVoucher) {
                if (dc == 1) {
                    sumLocAmount = dSumLocAmount.subtract(cSumLocAmount).add(psCreditLocal.subtract(plvSumCreditLocal));
                    yLocAmount = yearDebitLocal.subtract(plvYDebitLocal);
                    locAmount = debitLocAmount;
                } else {
                    sumLocAmount = GlUtils.zero.subtract(dSumLocAmount.subtract(cSumLocAmount).add(psCreditLocal.subtract(plvSumCreditLocal)));
                    yLocAmount = GlUtils.zero.subtract(yearDebitLocal.subtract(plvYDebitLocal));
                    locAmount = GlUtils.zero.subtract(debitLocAmount);
                }
            } else if (dc == 1) {
                sumLocAmount = dSumLocAmount.subtract(cSumLocAmount).add(psCreditLocal);
                yLocAmount = yearDebitLocal;
                yPLLocAmount = yearDebitLocal.subtract(plvYDebitLocal);
                locAmount = debitLocAmount;
                plLocAmount = plPeriodAmount[1];
            } else {
                sumLocAmount = dSumLocAmount.subtract(cSumLocAmount).add(psCreditLocal).negate();
                yLocAmount = yearDebitLocal.negate();
                yPLLocAmount = yearDebitLocal.subtract(plvYDebitLocal).negate();
                locAmount = debitLocAmount.negate();
                plLocAmount = plPeriodAmount[1].negate();
            }
        } else {
            psDebitLocal = rowSet.getBigDecimal("psDebitLocal");
            if (this.includeNoTransPLVoucher) {
                if (dc == 1) {
                    sumLocAmount = dSumLocAmount.subtract(cSumLocAmount).subtract(psDebitLocal.subtract(plvSumDebitLocal));
                    yLocAmount = GlUtils.zero.subtract(yearCreditLocal.subtract(plvYCreditLocal));
                    locAmount = GlUtils.zero.subtract(creditLocAmount);
                } else {
                    sumLocAmount = GlUtils.zero.subtract(dSumLocAmount.subtract(cSumLocAmount).subtract(psDebitLocal.subtract(plvSumDebitLocal)));
                    yLocAmount = yearCreditLocal.subtract(plvYCreditLocal);
                    locAmount = creditLocAmount.subtract(GlUtils.zero);
                }
            } else if (dc == 1) {
                sumLocAmount = dSumLocAmount.subtract(cSumLocAmount).subtract(psDebitLocal);
                yLocAmount = GlUtils.zero.subtract(yearCreditLocal);
                yPLLocAmount = GlUtils.zero.subtract(yearCreditLocal.subtract(plvYCreditLocal));
                locAmount = creditLocAmount.negate();
                plLocAmount = plPeriodAmount[1].negate();
            } else {
                sumLocAmount = GlUtils.zero.subtract(dSumLocAmount.subtract(cSumLocAmount).subtract(psDebitLocal));
                yLocAmount = yearCreditLocal;
                yPLLocAmount = yearCreditLocal.subtract(plvYCreditLocal);
                locAmount = creditLocAmount;
                plLocAmount = plPeriodAmount[1].negate();
            }
        }
        this.updateBalDataCache(0, locColName, sumLocAmount);
        this.updateBalDataCache(1, locColName, locAmount);
        this.updateBalDataCache(3, locColName, yLocAmount);
        if (this.isPLAccount && !this.includeNoTransPLVoucher) {
            this.updateBalDataCache(2, locColName, plLocAmount);
            this.updateBalDataCache(4, locColName, yPLLocAmount);
        }
        if (isFirst) {
            if (dc == 1) {
                this.updateRowAmount(rowData, locColName, sLoc);
            } else {
                this.updateRowAmount(rowData, locColName, GlUtils.zero.subtract(sLoc));
            }
        }
        if (this.displayAmount) {
            BigDecimal sumCurQty;
            BigDecimal curQty;
            BigDecimal yCurQty;
            if (this.includeNoTransPLVoucher) {
                debitCurQty = debitQty.subtract(plVDebitQty);
                creditCurQty = creditQty.subtract(plVCreditQty);
                dYearCurQty = yearDebitQty.subtract(plvYDebitQty);
                cYearCurQty = yearCreditQty.subtract(plvYCreditQty);
            } else {
                debitCurQty = debitQty;
                creditCurQty = creditQty;
                plPeriodAmount[4] = debitQty.subtract(plVDebitQty);
                plPeriodAmount[5] = creditQty.subtract(plVCreditQty);
                dYearCurQty = yearDebitQty;
                cYearCurQty = yearCreditQty;
                plYearAmount[4] = yearDebitQty.subtract(plvYDebitQty);
                plYearAmount[5] = yearCreditQty.subtract(plvYCreditQty);
            }
            if (this.fetchDataType == 0) {
                if (dc == 1) {
                    yCurQty = dYearCurQty.subtract(cYearCurQty);
                    curQty = debitCurQty.subtract(creditCurQty);
                    sumCurQty = qty.add(curQty);
                } else {
                    yCurQty = cYearCurQty.subtract(dYearCurQty);
                    curQty = creditCurQty.subtract(debitCurQty);
                    sumCurQty = curQty.subtract(qty);
                }
                if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                    if (dc == 1) {
                        yPLCurQty = plYearAmount[4].subtract(plYearAmount[5]);
                        plCurQty = plPeriodAmount[4].subtract(plPeriodAmount[5]);
                    } else {
                        yPLCurQty = plYearAmount[5].subtract(plYearAmount[4]);
                        plCurQty = plPeriodAmount[5].subtract(plPeriodAmount[4]);
                    }
                }
            } else if (this.fetchDataType == 1) {
                if (dc == 1) {
                    yCurQty = dYearCurQty;
                    curQty = debitCurQty;
                    sumCurQty = qty.add(curQty);
                } else {
                    yCurQty = dYearCurQty.negate();
                    curQty = debitCurQty.negate();
                    sumCurQty = curQty.subtract(qty);
                }
                if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                    if (dc == 1) {
                        yPLCurQty = plYearAmount[4];
                        plCurQty = plPeriodAmount[4];
                    } else {
                        yPLCurQty = plYearAmount[4].negate();
                        plCurQty = plPeriodAmount[4].negate();
                    }
                }
            } else {
                if (dc == 1) {
                    yCurQty = cYearCurQty.negate();
                    curQty = creditCurQty.negate();
                    sumCurQty = qty.add(curQty);
                } else {
                    yCurQty = cYearCurQty;
                    curQty = creditCurQty;
                    sumCurQty = curQty.subtract(qty);
                }
                if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                    if (dc == 1) {
                        yPLCurQty = plYearAmount[5].negate();
                        plCurQty = plPeriodAmount[5].negate();
                    } else {
                        yPLCurQty = plYearAmount[5];
                        plCurQty = plPeriodAmount[5];
                    }
                }
            }
            if (this.allAccountSameUnit) {
                this.updateBalDataCache(0, qtyColName, sumCurQty);
                BigDecimal locAmount0 = this.balData.getBigDecimal(0, locColName);
                this.updateRowPriceMu(this.balData, 0, qtyColName, priColName, muColName, null, locAmount0);
                this.updateBalDataCache(1, qtyColName, curQty);
                BigDecimal locAmount1 = this.balData.getBigDecimal(1, locColName);
                this.updateRowPriceMu(this.balData, 1, qtyColName, priColName, muColName, this.getUniqueMeasureUnitName4Item(mu), locAmount1);
                this.updateBalDataCache(3, qtyColName, yCurQty);
                BigDecimal locAmount3 = this.balData.getBigDecimal(3, locColName);
                this.updateRowPriceMu(this.balData, 3, qtyColName, priColName, muColName, this.getUniqueMeasureUnitName4Item(mu), locAmount3);
                if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                    this.updateBalDataCache(2, qtyColName, plCurQty);
                    BigDecimal locAmount2 = this.balData.getBigDecimal(2, locColName);
                    this.updateRowPriceMu(this.balData, 2, qtyColName, priColName, muColName, this.getUniqueMeasureUnitName4Item(mu), locAmount2);
                    this.updateBalDataCache(4, qtyColName, yPLCurQty);
                    BigDecimal locAmount4 = this.balData.getBigDecimal(4, locColName);
                    this.updateRowPriceMu(this.balData, 4, qtyColName, priColName, muColName, this.getUniqueMeasureUnitName4Item(mu), locAmount4);
                }
            }
            if (isFirst) {
                this.updateRowPriceMu(rowData, locColName, qtyColName, qty, priColName, muColName, this.getUniqueMeasureUnitName4Item(mu));
            }
        }
    }

    protected void dealStartBalanceCurSum(IRowSet rowSet, int cur, BigDecimal[] periodSum, BigDecimal[] periodPLSum, BigDecimal[] yearSum, BigDecimal[] yearPLSum) throws BOSException, SQLException {
        BigDecimal debitFor = rowSet.getBigDecimal("FDebitFor");
        BigDecimal creditFor = rowSet.getBigDecimal("FCreditFor");
        BigDecimal yearDebitFor = rowSet.getBigDecimal("FyearDebitFor");
        BigDecimal yearCreditFor = rowSet.getBigDecimal("FyearCreditFor");
        BigDecimal plVDebitFor = rowSet.getBigDecimal("DebitFor");
        BigDecimal plVCreditFor = rowSet.getBigDecimal("CreditFor");
        BigDecimal plvYDebitFor = rowSet.getBigDecimal("yDebitFor");
        BigDecimal plvYCreditFor = rowSet.getBigDecimal("yCreditFor");
        BigDecimal debitLocal = rowSet.getBigDecimal("FDebitLocal");
        BigDecimal creditLocal = rowSet.getBigDecimal("FCreditLocal");
        BigDecimal debitQty = rowSet.getBigDecimal("FDebitQty");
        BigDecimal creditQty = rowSet.getBigDecimal("FCreditQty");
        BigDecimal yearDebitLocal = rowSet.getBigDecimal("FyearDebitLocal");
        BigDecimal yearCreditLocal = rowSet.getBigDecimal("FyearCreditLocal");
        BigDecimal yearDebitQty = rowSet.getBigDecimal("FyearDebitQty");
        BigDecimal yearCreditQty = rowSet.getBigDecimal("FyearCreditQty");
        BigDecimal plVDebitLocal = rowSet.getBigDecimal("DebitLocal");
        BigDecimal plVCreditLocal = rowSet.getBigDecimal("CreditLocal");
        BigDecimal plVDebitQty = rowSet.getBigDecimal("DebitQty");
        BigDecimal plVCreditQty = rowSet.getBigDecimal("CreditQty");
        BigDecimal plvYDebitLocal = rowSet.getBigDecimal("yDebitLocal");
        BigDecimal plvYCreditLocal = rowSet.getBigDecimal("yCreditLocal");
        BigDecimal plvYDebitQty = rowSet.getBigDecimal("yDebitQty");
        BigDecimal plvYCreditQty = rowSet.getBigDecimal("yCreditQty");
        BigDecimal dPerOAmount = null;
        BigDecimal dPerLocAmount = null;
        BigDecimal cPerOAmount = null;
        BigDecimal cPerLocAmount = null;
        BigDecimal dPerCurQty = null;
        BigDecimal cPerCurQty = null;
        BigDecimal dPLPerOAmount = null;
        BigDecimal dPLPerLocAmount = null;
        BigDecimal cPLPerOAmount = null;
        BigDecimal cPLPerLocAmount = null;
        BigDecimal dPLPerCurQty = null;
        BigDecimal cPLPerCurQty = null;
        BigDecimal dYearOAmount = null;
        BigDecimal dYearLocAmount = null;
        BigDecimal cYearOAmount = null;
        BigDecimal cYearLocAmount = null;
        BigDecimal dYearCurQty = null;
        BigDecimal cYearCurQty = null;
        BigDecimal dPLYearOAmount = null;
        BigDecimal dPLYearLocAmount = null;
        BigDecimal cPLYearOAmount = null;
        BigDecimal cPLYearLocAmount = null;
        BigDecimal dPLYearCurQty = null;
        BigDecimal cPLYearCurQty = null;
        if (this.includeNoTransPLVoucher) {
            dPerOAmount = debitFor.subtract(plVDebitFor);
            cPerOAmount = creditFor.subtract(plVCreditFor);
            dYearOAmount = yearDebitFor.subtract(plvYDebitFor);
            cYearOAmount = yearCreditFor.subtract(plvYCreditFor);
            if (this.currencySize > 1) {
                dPerLocAmount = debitLocal.subtract(plVDebitLocal);
                cPerLocAmount = creditLocal.subtract(plVCreditLocal);
                dYearLocAmount = yearDebitLocal.subtract(plvYDebitLocal);
                cYearLocAmount = yearCreditLocal.subtract(plvYCreditLocal);
            }
            if (this.displayAmount) {
                dPerCurQty = debitQty.subtract(plVDebitQty);
                cPerCurQty = creditQty.subtract(plVCreditQty);
                dYearCurQty = yearDebitQty.subtract(plvYDebitQty);
                cYearCurQty = yearCreditQty.subtract(plvYCreditQty);
            }
        } else {
            dPerOAmount = debitFor;
            cPerOAmount = creditFor;
            dYearOAmount = yearDebitFor;
            cYearOAmount = yearCreditFor;
            if (this.currencySize > 1) {
                dPerLocAmount = debitLocal;
                cPerLocAmount = creditLocal;
                dYearLocAmount = yearDebitLocal;
                cYearLocAmount = yearCreditLocal;
            }
            if (this.displayAmount) {
                dPerCurQty = debitQty;
                cPerCurQty = creditQty;
                dYearCurQty = yearDebitQty;
                cYearCurQty = yearCreditQty;
            }
            if (this.isPLAccount) {
                dPLPerOAmount = debitFor.subtract(plVDebitFor);
                cPLPerOAmount = creditFor.subtract(plVCreditFor);
                dPLYearOAmount = yearDebitFor.subtract(plvYDebitFor);
                cPLYearOAmount = yearCreditFor.subtract(plvYCreditFor);
                if (this.currencySize > 1) {
                    dPLPerLocAmount = debitLocal.subtract(plVDebitLocal);
                    cPLPerLocAmount = creditLocal.subtract(plVCreditLocal);
                    dPLYearLocAmount = yearDebitLocal.subtract(plvYDebitLocal);
                    cPLYearLocAmount = yearCreditLocal.subtract(plvYCreditLocal);
                }
                if (this.displayAmount) {
                    dPLPerCurQty = debitQty.subtract(plVDebitQty);
                    cPLPerCurQty = creditQty.subtract(plVCreditQty);
                    dPLYearCurQty = yearDebitQty.subtract(plvYDebitQty);
                    cPLYearCurQty = yearCreditQty.subtract(plvYCreditQty);
                }
            }
        }
        BigDecimal[] dcPOAmout = new BigDecimal[]{dPerOAmount, cPerOAmount};
        BigDecimal[] dcPLocAmout = new BigDecimal[]{dPerLocAmount, cPerLocAmount};
        BigDecimal[] dcPCurQty = new BigDecimal[]{dPerCurQty, cPerCurQty};
        BigDecimal[] dcYOAmout = new BigDecimal[]{dYearOAmount, cYearOAmount};
        BigDecimal[] dcYLocAmout = new BigDecimal[]{dYearLocAmount, cYearLocAmount};
        BigDecimal[] dcYCurQty = new BigDecimal[]{dYearCurQty, cYearCurQty};
        this.dealStartBalanceCurSumPY(rowSet, cur, 1, dcPOAmout, dcPLocAmout, dcPCurQty, periodSum);
        this.dealStartBalanceCurSumPY(rowSet, cur, 3, dcYOAmout, dcYLocAmout, dcYCurQty, yearSum);
        if (this.isPLAccount && !this.includeNoTransPLVoucher) {
            BigDecimal[] dcPLPOAmout = new BigDecimal[]{dPLPerOAmount, cPLPerOAmount};
            BigDecimal[] dcPLPLocAmout = new BigDecimal[]{dPLPerLocAmount, cPLPerLocAmount};
            BigDecimal[] dcPLPCurQty = new BigDecimal[]{dPLPerCurQty, cPLPerCurQty};
            BigDecimal[] dcPLYOAmout = new BigDecimal[]{dPLYearOAmount, cPLYearOAmount};
            BigDecimal[] dcPLYLocAmout = new BigDecimal[]{dPLYearLocAmount, cPLYearLocAmount};
            BigDecimal[] dcPLYCurQty = new BigDecimal[]{dPLYearCurQty, cPLYearCurQty};
            this.dealStartBalanceCurSumPY(rowSet, cur, 2, dcPLPOAmout, dcPLPLocAmout, dcPLPCurQty, periodPLSum);
            this.dealStartBalanceCurSumPY(rowSet, cur, 4, dcPLYOAmout, dcPLYLocAmout, dcPLYCurQty, yearPLSum);
        }
    }

    protected void updateBalDataCache(int tRow, String colName, BigDecimal amount) throws BOSException {
        BigDecimal oldV = this.balData.getBigDecimal(tRow, colName);
        if (oldV == null) {
            this.balData.updateBigDecimal(tRow, colName, amount);
        } else {
            BigDecimal dNewV = oldV.add(amount);
            this.balData.updateBigDecimal(tRow, colName, dNewV);
        }
    }

    protected void updateRowAmount(IGLRptRowData rowData, String colName, BigDecimal amount) throws BOSException {
        BigDecimal oldV = rowData.getBigDecimal(colName);
        if (oldV == null) {
            rowData.updateBigDecimal(colName, amount);
        } else {
            BigDecimal dNewV = oldV.add(amount);
            rowData.updateBigDecimal(colName, dNewV);
        }
    }

    protected void updateRowPriceMu(IGLRptRowData rowData, String locColName, String qtyColName, BigDecimal qty, String priColName, String muColName, String muName) throws BOSException {
        this.updateRowAmount(rowData, qtyColName, qty);
        BigDecimal locAmount = rowData.getBigDecimal(locColName);
        qty = rowData.getBigDecimal(qtyColName);
        if (locAmount != null && qty != null && qty.compareTo(GlUtils.zero) != 0) {
            BigDecimal price = locAmount.divide(qty, this.priceScale, 4);
            rowData.updateBigDecimal(priColName, price);
            if (muName != null) {
                rowData.updateString(muColName, muName);
            } else {
                rowData.updateString(muColName, this.getUniqueMeasureUnitName());
            }
        } else {
            rowData.updateBigDecimal(priColName, null);
            rowData.updateString(muColName, null);
        }
    }

    protected abstract String getUniqueMeasureUnitName();

    protected abstract String getUniqueMeasureUnitName4Item(int var1);

    protected void updateRowPriceMu(GLRptRowSet balData, int tRow, String qtyColName, String priColName, String muColName, String muName, BigDecimal sum) throws BOSException {
        BigDecimal locAmount = sum;
        BigDecimal qty = balData.getBigDecimal(tRow, qtyColName);
        if (locAmount != null && qty != null && qty.compareTo(GlUtils.zero) != 0) {
            BigDecimal price = locAmount.divide(qty, this.priceScale, 4);
            balData.updateBigDecimal(tRow, priColName, price);
            if (muName == null) {
                muName = this.getUniqueMeasureUnitName();
            }
            balData.updateString(tRow, muColName, muName);
        } else {
            balData.updateBigDecimal(tRow, priColName, null);
            balData.updateString(tRow, muColName, null);
        }
    }

    protected void dealStartBalanceCurSumPY(IRowSet rowSet, int cur, int tRow, BigDecimal[] dcOAmout, BigDecimal[] dcLocAmout, BigDecimal[] dcCurQty, BigDecimal[] sum) throws BOSException, SQLException {
        String headCurrencyId = this.currencys.get(cur).getId().toString();
        String dOColName = new StringBuffer("DebitFor_").append(cur).toString();
        String dLocColName = new StringBuffer("DebitLocal_").append(cur).toString();
        String cOColName = new StringBuffer("CreditFor_").append(cur).toString();
        String cLocColName = new StringBuffer("CreditLocal_").append(cur).toString();
        String dQtyColName = new StringBuffer("DebitQty_").append(cur).toString();
        String cQtyColName = new StringBuffer("CreditQty_").append(cur).toString();
        String dPriColName = new StringBuffer("DebitPrice_").append(cur).toString();
        String cPriColName = new StringBuffer("CreditPrice_").append(cur).toString();
        String dMuColName = new StringBuffer("DebitMu_").append(cur).toString();
        String cMuColName = new StringBuffer("CreditMu_").append(cur).toString();
        if (this.displayOrigine && !headCurrencyId.equals(this.baseCurrencyId)) {
            this.updateBalDataCache(tRow, dOColName, dcOAmout[0]);
            this.updateBalDataCache(tRow, cOColName, dcOAmout[1]);
        }
        if (this.currencySize > 1) {
            this.updateBalDataCache(tRow, dLocColName, dcLocAmout[0]);
            this.updateBalDataCache(tRow, cLocColName, dcLocAmout[1]);
        }
        if (this.displayAmount) {
            this.updateBalDataCache(tRow, dQtyColName, dcCurQty[0]);
            this.updateBalDataCache(tRow, cQtyColName, dcCurQty[1]);
            if (this.currencySize > 1) {
                BigDecimal locAmount_d = this.balData.getBigDecimal(tRow, dLocColName);
                this.updateRowPriceMu(this.balData, tRow, dQtyColName, dPriColName, dMuColName, null, locAmount_d);
                BigDecimal locAmount_c = this.balData.getBigDecimal(tRow, cLocColName);
                this.updateRowPriceMu(this.balData, tRow, cQtyColName, cPriColName, cMuColName, null, locAmount_c);
            } else {
                this.updateRowPriceMu(this.balData, tRow, dQtyColName, dPriColName, dMuColName, null, sum[0]);
                this.updateRowPriceMu(this.balData, tRow, cQtyColName, cPriColName, cMuColName, null, sum[1]);
            }
        }
    }

    protected void dealLineBalance(IGLRptRowData rowData, boolean isFirst) throws BOSException {
        int row;
        Object[] balanceAndDC = this.autoBanlanceDc(this.balances[1]);
        Object[] plBalanceAndDC = this.autoBanlanceDc(this.balances[1].add(this.plBalances[1]));
        if (isFirst) {
            rowData.updateString("Orginal_DC", (String)balanceAndDC[1]);
            rowData.updateBigDecimal("Balance_Amount", (BigDecimal)balanceAndDC[0]);
        }
        for (row = 0; row < 5; ++row) {
            if (row == 2 || row == 4) {
                this.balData.updateString(row, "Orginal_DC", (String)plBalanceAndDC[1]);
                this.balData.updateBigDecimal(row, "Balance_Amount", (BigDecimal)plBalanceAndDC[0]);
                continue;
            }
            this.balData.updateString(row, "Orginal_DC", (String)balanceAndDC[1]);
            this.balData.updateBigDecimal(row, "Balance_Amount", (BigDecimal)balanceAndDC[0]);
        }
        if (this.displayAmount) {
            if (isFirst) {
                rowData.updateString("Balance_Mu", this.getUniqueMeasureUnitName());
            }
            for (row = 0; row < 5; ++row) {
                this.balData.updateString(row, "Balance_Mu", this.getUniqueMeasureUnitName());
            }
            if (this.balances[1].add(this.plBalances[1]).compareTo((BigDecimal)balanceAndDC[0]) != 0) {
                if (isFirst) {
                    rowData.updateBigDecimal("Balance_Qty", this.balances[0].add(this.plBalances[0]).negate());
                }
                for (row = 0; row < 5; ++row) {
                    if (row == 2 || row == 4) continue;
                    this.balData.updateBigDecimal(row, "Balance_Qty", this.balances[0].add(this.plBalances[0]).negate());
                }
            } else {
                if (isFirst) {
                    rowData.updateBigDecimal("Balance_Qty", this.balances[0].add(this.plBalances[0]));
                }
                for (row = 0; row < 5; ++row) {
                    if (row == 2 || row == 4) continue;
                    this.balData.updateBigDecimal(row, "Balance_Qty", this.balances[0].add(this.plBalances[0]));
                }
            }
            if (this.balances[0].add(this.plBalances[0]).compareTo(GlUtils.zero) != 0) {
                if (isFirst) {
                    rowData.updateBigDecimal("Balance_Price", this.balances[1].add(this.plBalances[1]).divide(this.balances[0].add(this.plBalances[0]), this.priceScale, 4));
                }
                for (row = 0; row < 5; ++row) {
                    if (row == 2 || row == 4) continue;
                    this.balData.updateBigDecimal(row, "Balance_Price", this.balances[1].add(this.plBalances[1]).divide(this.balances[0].add(this.plBalances[0]), this.priceScale, 4));
                }
            } else {
                if (isFirst) {
                    rowData.updateBigDecimal("Balance_Price", null);
                }
                for (row = 0; row < 5; ++row) {
                    if (row == 2 || row == 4) continue;
                    this.balData.updateBigDecimal(row, "Balance_Price", null);
                }
            }
            if (this.isPLAccount && !this.includeNoTransPLVoucher) {
                if (this.balances[1].compareTo((BigDecimal)plBalanceAndDC[0]) != 0) {
                    if (isFirst) {
                        rowData.updateBigDecimal("Balance_Qty", this.balances[0].negate());
                    }
                    this.balData.updateBigDecimal(2, "Balance_Qty", this.balances[0].negate());
                    this.balData.updateBigDecimal(4, "Balance_Qty", this.balances[0].negate());
                } else {
                    if (isFirst) {
                        rowData.updateBigDecimal("Balance_Qty", this.balances[0]);
                    }
                    this.balData.updateBigDecimal(2, "Balance_Qty", this.balances[0]);
                    this.balData.updateBigDecimal(4, "Balance_Qty", this.balances[0]);
                }
                if (this.balances[0].compareTo(GlUtils.zero) != 0) {
                    if (isFirst) {
                        rowData.updateBigDecimal("Balance_Price", this.balances[1].divide(this.balances[0], this.priceScale, 4));
                    }
                    this.balData.updateBigDecimal(2, "Balance_Price", this.balances[1].divide(this.balances[0], this.priceScale, 4));
                    this.balData.updateBigDecimal(4, "Balance_Price", this.balances[1].divide(this.balances[0], this.priceScale, 4));
                } else {
                    if (isFirst) {
                        rowData.updateBigDecimal("Balance_Price", null);
                    }
                    this.balData.updateBigDecimal(2, "Balance_Price", null);
                    this.balData.updateBigDecimal(4, "Balance_Price", null);
                }
            }
        }
    }

    protected BigDecimal getColumnStartBalance(IRowSet rowSet, int mu, String hCurId, String cur) throws SQLException {
        String curID = rowSet.getString("FCurrencyID");
        BigDecimal beginbalance = rowSet.getBigDecimal("FBEGINBALANCE" + cur);
        if (this.checkColItem(rowSet, mu) && curID.equals(hCurId)) {
            return beginbalance;
        }
        return GlUtils.zero;
    }

    protected GLRptTempTableStruct getTempTableStruct() throws BOSException, EASBizException {
        GLRptTempTableStruct struct = new GLRptTempTableStruct();
        struct.addField("no", "INT");
        struct.addField("voucherId", "VARCHAR(44)");
        struct.addField("FSourcetype", "INT");
        struct.addField("ActDC", "INT");
        struct.addField("FPeriodID", "VARCHAR(44)");
        struct.addField("FPeriodYear", "INT");
        struct.addField("FPeriodNumber", "INT");
        struct.addField("bizDate", "DateTime");
        struct.addField("voucherTypeName", "NVARCHAR(80)");
        struct.addField("description", "NVARCHAR(300)");
        if (!this.displayOneLineBiz) {
            struct.addField("fentryid", "varchar(44)");
            struct.addField("fseq", "INT");
        }
        struct.addField("Orginal_DC", "VARCHAR(10)");
        if (this.displayAmount) {
            struct.addField("muname", "NVARCHAR(80)");
        }
        return struct;
    }

    public GLRptTableHeadInfo initTableHeadInfo(GLRptTableHeadInfo headInfo) throws BOSException, EASBizException {
        if (!this.isInited) {
            this.initHeadInfo(headInfo);
            this.isInited = true;
        }
        return this.headInfo;
    }

    protected void initHeadInfo(GLRptTableHeadInfo headInfo) throws BOSException, EASBizException {
        String[] columnNames = this.getColumnNames();
        try {
            this.initColHideMap();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < columnNames.length; ++i) {
            GLRptTableHeadInfo.GLRptTableColumnInfo colInfo = headInfo.addColumnInfo();
            colInfo.setColName(columnNames[i]);
            if (columnNames[i].equals("no")) {
                colInfo.setWidth(-1);
                colInfo.setHide(true);
                continue;
            }
            if (columnNames[i].equals("FSourceType")) {
                colInfo.setWidth(-1);
                colInfo.setHide(true);
                continue;
            }
            if (columnNames[i].equals("voucherId")) {
                colInfo.setWidth(-1);
                colInfo.setHide(true);
                continue;
            }
            if (columnNames[i].equals("bizDate") || columnNames[i].equals("voucherTypeName")) {
                colInfo.setWidth(100);
                colInfo.setFreeze(true);
                continue;
            }
            if (columnNames[i].equals("Orginal_DC")) {
                colInfo.setWidth(40);
                colInfo.setAlign(2);
                continue;
            }
            if (columnNames[i].equals("description")) {
                colInfo.setWidth(100);
                continue;
            }
            if (columnNames[i].indexOf("Mu") != -1) {
                if (this.noDisplayNoCol && columnNames[i].indexOf("_") != columnNames[i].lastIndexOf("_") && (this.colHideMap.get(columnNames[i]) == null || "".equals(this.colHideMap.get(columnNames[i]).toString().trim()))) {
                    colInfo.setWidth(-1);
                    colInfo.setHide(true);
                    continue;
                }
                colInfo.setWidth(100);
                continue;
            }
            if (this.noDisplayNoCol && columnNames[i].indexOf("_") != columnNames[i].lastIndexOf("_") && (this.colHideMap.get(columnNames[i]) == null || ((BigDecimal)this.colHideMap.get(columnNames[i])).compareTo(GlUtils.zero) == 0)) {
                colInfo.setWidth(-1);
                colInfo.setHide(true);
                continue;
            }
            colInfo.setWidth(100);
            colInfo.setNumeral(true);
            if (columnNames[i].indexOf("Qty") != -1) {
                colInfo.setScale(this.qtyScale);
                continue;
            }
            if (columnNames[i].indexOf("Price") != -1) {
                colInfo.setScale(this.priceScale);
                continue;
            }
            if (columnNames[i].indexOf("For") != -1) {
                String end = columnNames[i].substring(columnNames[i].length() - 1);
                int iend = Integer.parseInt(end);
                int scale = this.currencys.get(iend).getPrecision();
                colInfo.setScale(scale);
                continue;
            }
            int scale = this.company.getBaseCurrency().getPrecision();
            colInfo.setScale(scale);
        }
        headInfo.setHeadTitle(this.getTitles());
        this.headInfo = headInfo;
    }

    protected void initColumnNames() throws BOSException {
        int i;
        StringBuffer columnNamesStr = new StringBuffer();
        columnNamesStr.append("bizDate,voucherTypeName,description,");
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                columnNamesStr.append("DebitMu_").append(i).append(",");
                columnNamesStr.append("DebitQty_").append(i).append(",");
                columnNamesStr.append("DebitPrice_").append(i).append(",");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                columnNamesStr.append("DebitFor_").append(i).append(",");
            }
            if (this.currencySize <= 1) continue;
            columnNamesStr.append("DebitLocal_").append(i).append(",");
        }
        columnNamesStr.append("Debit_Sum,");
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                columnNamesStr.append("CreditMu_").append(i).append(",");
                columnNamesStr.append("CreditQty_").append(i).append(",");
                columnNamesStr.append("CreditPrice_").append(i).append(",");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                columnNamesStr.append("CreditFor_").append(i).append(",");
            }
            if (this.currencySize <= 1) continue;
            columnNamesStr.append("CreditLocal_").append(i).append(",");
        }
        columnNamesStr.append("Credit_Sum,");
        if (this.displayAmount) {
            columnNamesStr.append("Balance_Mu,Balance_Qty,Balance_Price,");
        }
        columnNamesStr.append("Orginal_DC,Balance_Amount,");
        for (i = 0; i < this.itemList.size(); ++i) {
            for (int j = 0; j < this.currencys.size(); ++j) {
                if (i < this.debitSize) {
                    if (this.displayAmount) {
                        columnNamesStr.append("DebitMu_").append(i).append("_").append(j).append(",");
                        columnNamesStr.append("DebitQty_").append(i).append("_").append(j).append(",");
                        columnNamesStr.append("DebitPrice_").append(i).append("_").append(j).append(",");
                    }
                    if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                        columnNamesStr.append("DebitFor_").append(i).append("_").append(j).append(",");
                    }
                    columnNamesStr.append("DebitLocal_").append(i).append("_").append(j).append(",");
                    continue;
                }
                if (this.displayAmount) {
                    columnNamesStr.append("CreditMu_").append(i).append("_").append(j).append(",");
                    columnNamesStr.append("CreditQty_").append(i).append("_").append(j).append(",");
                    columnNamesStr.append("CreditPrice_").append(i).append("_").append(j).append(",");
                }
                if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                    columnNamesStr.append("CreditFor_").append(i).append("_").append(j).append(",");
                }
                columnNamesStr.append("CreditLocal_").append(i).append("_").append(j).append(",");
            }
        }
        columnNamesStr.append("no,FSourceType,voucherId");
        String[] columnNames = columnNamesStr.toString().split(",");
        this.columnNames = columnNames;
    }

    public String[] getColumnNames() throws BOSException {
        return this.columnNames;
    }

    public String[][] getTitles() throws BOSException, EASBizException {
        StringBuffer lineStr1 = new StringBuffer();
        StringBuffer lineStr2 = new StringBuffer();
        StringBuffer lineStr3 = new StringBuffer();
        StringBuffer lineStr4 = new StringBuffer();
        StringBuffer[] dynamicsLines = null;
        if (this.uperAccountLevel > 0) {
            dynamicsLines = new StringBuffer[this.uperAccountLevel];
            for (int i = 0; i < this.uperAccountLevel; ++i) {
                dynamicsLines[i] = new StringBuffer();
            }
        }
        int rowCounts = !this.displayAmount && !this.needDisplayOrigine && this.currencySize == 1 ? this.dealSimpTitleLine(lineStr1, lineStr2, dynamicsLines) : this.dealMultiTitleLine(lineStr1, lineStr2, lineStr3, lineStr4, dynamicsLines);
        String[][] titles = new String[rowCounts][];
        titles[0] = lineStr1.toString().split("\u2191\u2191");
        for (int line = 0; line < this.uperAccountLevel; ++line) {
            titles[1 + line] = dynamicsLines[line].toString().split("\u2191\u2191");
        }
        if (this.uperAccountLevel < 1) {
            this.uperAccountLevel = 0;
        }
        titles[this.uperAccountLevel + 1] = lineStr2.toString().split("\u2191\u2191");
        if (lineStr3 != null && !"".equals(lineStr3.toString())) {
            titles[this.uperAccountLevel + 2] = lineStr3.toString().split("\u2191\u2191");
        }
        if (lineStr4 != null && !"".equals(lineStr4.toString())) {
            titles[this.uperAccountLevel + 3] = lineStr4.toString().split("\u2191\u2191");
        }
        return titles;
    }

    protected int dealSimpTitleLine(StringBuffer lineStr1, StringBuffer lineStr2, StringBuffer[] dynamicsLines) throws EASBizException, BOSException {
        this.dealSimpTitleLine1(lineStr1);
        int rowCounts = this.uperAccountLevel > 0 ? 2 + this.uperAccountLevel : 2;
        for (int line = 0; line < this.uperAccountLevel; ++line) {
            this.dealSimpTitleDynamicsLine(dynamicsLines, line);
        }
        this.dealSimpTitleLine2(lineStr2);
        return rowCounts;
    }

    protected void dealSimpTitleLine2(StringBuffer lineStr2) throws EASBizException, BOSException {
        lineStr2.append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            lineStr2.append("\u2191\u2191").append("SQL_BATCH");
        }
        lineStr2.append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        lineStr2.append("dir_debit\u2191\u2191dir_credit\u2191\u2191direction\u2191\u2191money_amount\u2191\u2191");
        for (int i = 0; i < this.itemList.size(); ++i) {
            for (int j = 0; j < this.currencys.size(); ++j) {
                String key;
                if (i < this.debitSize) {
                    key = String.valueOf(this.debitColumn[this.debitColumn.length - i - 1][0]);
                    lineStr2.append(key).append("\u2191\u2191");
                    continue;
                }
                key = String.valueOf(this.creditColumn[this.creditColumn.length - i - 1 + this.debitSize][0]);
                lineStr2.append(key).append("\u2191\u2191");
            }
        }
        this.delLastChars(lineStr2, 2);
    }

    protected void dealSimpTitleDynamicsLine(StringBuffer[] dynamicsLines, int line) throws EASBizException, BOSException {
        dynamicsLines[line].append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            dynamicsLines[line].append("\u2191\u2191").append("SQL_BATCH");
        }
        dynamicsLines[line].append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        dynamicsLines[line].append("dir_debit\u2191\u2191dir_credit\u2191\u2191balance\u2191\u2191balance\u2191\u2191");
        for (int i = 0; i < this.itemList.size(); ++i) {
            String key;
            if (i < this.debitSize) {
                key = String.valueOf(this.debitColumn[this.debitColumn.length - i - 1][this.uperAccountLevel - line]);
                dynamicsLines[line].append(key).append("\u2191\u2191");
                continue;
            }
            key = String.valueOf(this.creditColumn[this.creditColumn.length - i - 1 + this.debitSize][this.uperAccountLevel - line]);
            dynamicsLines[line].append(key).append("\u2191\u2191");
        }
        this.delLastChars(dynamicsLines[line], 2);
    }

    protected void dealSimpTitleLine1(StringBuffer lineStr1) throws EASBizException, BOSException {
        lineStr1.append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            lineStr1.append("\u2191\u2191").append("SQL_BATCH");
        }
        lineStr1.append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        lineStr1.append("dir_debit\u2191\u2191dir_credit\u2191\u2191balance\u2191\u2191balance\u2191\u2191");
        for (int i = 0; i < this.itemList.size(); ++i) {
            if (i < this.debitSize) {
                lineStr1.append("dir_debit\u2191\u2191");
                continue;
            }
            lineStr1.append("dir_credit\u2191\u2191");
        }
        this.delLastChars(lineStr1, 2);
    }

    protected int dealMultiTitleLine(StringBuffer lineStr1, StringBuffer lineStr2, StringBuffer lineStr3, StringBuffer lineStr4, StringBuffer[] dynamicsLines) throws EASBizException, BOSException {
        int rowCounts;
        this.dealMultiTitleLine1(lineStr1);
        for (int line = 0; line < this.uperAccountLevel; ++line) {
            this.dealMultiTitleDynamicsLine(dynamicsLines, line);
        }
        this.dealMultiTitleLine2(lineStr2);
        if (this.currencySize == 1) {
            rowCounts = this.uperAccountLevel > 0 ? 3 + this.uperAccountLevel : 3;
            this.dealMutiTitleLine3OfOneCur(lineStr3);
        } else {
            rowCounts = this.uperAccountLevel > 0 ? 4 + this.uperAccountLevel : 4;
            this.dealMultiTitleLine3(lineStr3);
            this.dealMultiTitleLine4(lineStr4);
        }
        return rowCounts;
    }

    protected void dealMutiTitleLine3OfOneCur(StringBuffer lineStr3) throws EASBizException, BOSException {
        int i;
        lineStr3.append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            lineStr3.append("\u2191\u2191").append("SQL_BATCH");
        }
        lineStr3.append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                lineStr3.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr3.append("currency_for\u2191\u2191");
            }
            lineStr3.append("currency_local\u2191\u2191");
        }
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                lineStr3.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr3.append("currency_for\u2191\u2191");
            }
            lineStr3.append("currency_local\u2191\u2191");
        }
        if (this.displayAmount) {
            lineStr3.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
        }
        lineStr3.append("direction\u2191\u2191money_amount\u2191\u2191");
        for (i = 0; i < this.itemList.size(); ++i) {
            for (int j = 0; j < this.currencys.size(); ++j) {
                if (i < this.debitSize) {
                    if (this.displayAmount) {
                        lineStr3.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
                    }
                    if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                        lineStr3.append("currency_for\u2191\u2191");
                    }
                    lineStr3.append("currency_local\u2191\u2191");
                    continue;
                }
                if (this.displayAmount) {
                    lineStr3.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
                }
                if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                    lineStr3.append("currency_for\u2191\u2191");
                }
                lineStr3.append("currency_local\u2191\u2191");
            }
        }
        this.delLastChars(lineStr3, 2);
    }

    protected void dealMultiTitleLine3(StringBuffer lineStr3) throws EASBizException, BOSException {
        String curName;
        int i;
        lineStr3.append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            lineStr3.append("\u2191\u2191").append("SQL_BATCH");
        }
        lineStr3.append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        for (i = 0; i < this.currencySize; ++i) {
            curName = this.currencys.get(i).getName();
            if (this.displayAmount) {
                lineStr3.append(curName).append("\u2191\u2191").append(curName).append("\u2191\u2191").append(curName).append("\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr3.append(curName).append("\u2191\u2191");
            }
            lineStr3.append(curName).append("\u2191\u2191");
        }
        lineStr3.append("total\u2191\u2191");
        for (i = 0; i < this.currencySize; ++i) {
            curName = this.currencys.get(i).getName();
            if (this.displayAmount) {
                lineStr3.append(curName).append("\u2191\u2191").append(curName).append("\u2191\u2191").append(curName).append("\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr3.append(curName).append("\u2191\u2191");
            }
            lineStr3.append(curName).append("\u2191\u2191");
        }
        lineStr3.append("total\u2191\u2191");
        if (this.displayAmount) {
            lineStr3.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
        }
        lineStr3.append("direction\u2191\u2191money_amount\u2191\u2191");
        for (i = 0; i < this.itemList.size(); ++i) {
            for (int j = 0; j < this.currencys.size(); ++j) {
                String curName2 = this.currencys.get(j).getName();
                if (i < this.debitSize) {
                    if (this.displayAmount) {
                        lineStr3.append(curName2).append("\u2191\u2191").append(curName2).append("\u2191\u2191").append(curName2).append("\u2191\u2191");
                    }
                    if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                        lineStr3.append(this.currencys.get(j).getName()).append("\u2191\u2191");
                    }
                    lineStr3.append(this.currencys.get(j).getName()).append("\u2191\u2191");
                    continue;
                }
                if (this.displayAmount) {
                    lineStr3.append(curName2).append("\u2191\u2191").append(curName2).append("\u2191\u2191").append(curName2).append("\u2191\u2191");
                }
                if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                    lineStr3.append(curName2).append("\u2191\u2191");
                }
                lineStr3.append(curName2).append("\u2191\u2191");
            }
        }
        this.delLastChars(lineStr3, 2);
    }

    protected void dealMultiTitleLine4(StringBuffer lineStr4) throws EASBizException, BOSException {
        int i;
        lineStr4.append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            lineStr4.append("\u2191\u2191").append("SQL_BATCH");
        }
        lineStr4.append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                lineStr4.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr4.append("currency_for\u2191\u2191");
            }
            if (this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                if (this.displayAmount) {
                    lineStr4.append(" ").append(this.currencys.get(i).getName()).append(" \u2191\u2191");
                    continue;
                }
                lineStr4.append(this.currencys.get(i).getName()).append("\u2191\u2191");
                continue;
            }
            lineStr4.append("currency_local\u2191\u2191");
        }
        lineStr4.append("total\u2191\u2191");
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                lineStr4.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr4.append("currency_for\u2191\u2191");
            }
            if (this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                if (this.displayAmount) {
                    lineStr4.append(" ").append(this.currencys.get(i).getName()).append(" \u2191\u2191");
                    continue;
                }
                lineStr4.append(this.currencys.get(i).getName()).append("\u2191\u2191");
                continue;
            }
            lineStr4.append("currency_local\u2191\u2191");
        }
        lineStr4.append("total\u2191\u2191");
        if (this.displayAmount) {
            lineStr4.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
        }
        lineStr4.append("direction\u2191\u2191money_amount\u2191\u2191");
        for (i = 0; i < this.itemList.size(); ++i) {
            for (int j = 0; j < this.currencys.size(); ++j) {
                if (i < this.debitSize) {
                    if (this.displayAmount) {
                        lineStr4.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
                    }
                    if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                        lineStr4.append("currency_for\u2191\u2191");
                    }
                    if (this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                        if (this.displayAmount) {
                            lineStr4.append(" ").append(this.currencys.get(j).getName()).append(" \u2191\u2191");
                            continue;
                        }
                        lineStr4.append(this.currencys.get(j).getName()).append("\u2191\u2191");
                        continue;
                    }
                    lineStr4.append("currency_local\u2191\u2191");
                    continue;
                }
                if (this.displayAmount) {
                    lineStr4.append("MeasureUnit\u2191\u2191asst_quantity\u2191\u2191price\u2191\u2191");
                }
                if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                    lineStr4.append("currency_for\u2191\u2191");
                }
                if (this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                    if (this.displayAmount) {
                        lineStr4.append(" ").append(this.currencys.get(j).getName()).append(" \u2191\u2191");
                        continue;
                    }
                    lineStr4.append(this.currencys.get(j).getName()).append("\u2191\u2191");
                    continue;
                }
                lineStr4.append("currency_local\u2191\u2191");
            }
        }
        this.delLastChars(lineStr4, 2);
    }

    protected void dealMultiTitleLine2(StringBuffer lineStr2) throws EASBizException, BOSException {
        int i;
        lineStr2.append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            lineStr2.append("\u2191\u2191").append("SQL_BATCH");
        }
        lineStr2.append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                lineStr2.append("dir_debit\u2191\u2191dir_debit\u2191\u2191dir_debit\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr2.append("dir_debit\u2191\u2191");
            }
            lineStr2.append("dir_debit\u2191\u2191");
        }
        if (this.currencySize > 1) {
            lineStr2.append("dir_debit\u2191\u2191");
        }
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                lineStr2.append("dir_credit\u2191\u2191dir_credit\u2191\u2191dir_credit\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr2.append("dir_credit\u2191\u2191");
            }
            lineStr2.append("dir_credit\u2191\u2191");
        }
        if (this.currencySize > 1) {
            lineStr2.append("dir_credit\u2191\u2191");
        }
        if (this.displayAmount) {
            lineStr2.append("balance\u2191\u2191balance\u2191\u2191balance\u2191\u2191");
        }
        lineStr2.append("balance\u2191\u2191balance\u2191\u2191");
        for (i = 0; i < this.itemList.size(); ++i) {
            for (int j = 0; j < this.currencys.size(); ++j) {
                String key;
                if (i < this.debitSize) {
                    key = String.valueOf(this.debitColumn[this.debitColumn.length - i - 1][0]);
                    if (this.displayAmount) {
                        lineStr2.append(key).append("\u2191\u2191");
                        lineStr2.append(key).append("\u2191\u2191");
                        lineStr2.append(key).append("\u2191\u2191");
                    }
                    if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                        lineStr2.append(key).append("\u2191\u2191");
                    }
                    lineStr2.append(key).append("\u2191\u2191");
                    continue;
                }
                key = String.valueOf(this.creditColumn[this.creditColumn.length - i - 1 + this.debitSize][0]);
                if (this.displayAmount) {
                    lineStr2.append(key).append("\u2191\u2191");
                    lineStr2.append(key).append("\u2191\u2191");
                    lineStr2.append(key).append("\u2191\u2191");
                }
                if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                    lineStr2.append(key).append("\u2191\u2191");
                }
                lineStr2.append(key).append("\u2191\u2191");
            }
        }
        this.delLastChars(lineStr2, 2);
    }

    protected void dealMultiTitleDynamicsLine(StringBuffer[] dynamicsLines, int line) throws EASBizException, BOSException {
        int i;
        dynamicsLines[line].append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            dynamicsLines[line].append("\u2191\u2191").append("SQL_BATCH");
        }
        dynamicsLines[line].append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                dynamicsLines[line].append("dir_debit\u2191\u2191dir_debit\u2191\u2191dir_debit\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                dynamicsLines[line].append("dir_debit\u2191\u2191");
            }
            dynamicsLines[line].append("dir_debit\u2191\u2191");
        }
        if (this.currencySize > 1) {
            dynamicsLines[line].append("dir_debit\u2191\u2191");
        }
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                dynamicsLines[line].append("dir_credit\u2191\u2191dir_credit\u2191\u2191dir_credit\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                dynamicsLines[line].append("dir_credit\u2191\u2191");
            }
            dynamicsLines[line].append("dir_credit\u2191\u2191");
        }
        if (this.currencySize > 1) {
            dynamicsLines[line].append("dir_credit\u2191\u2191");
        }
        if (this.displayAmount) {
            dynamicsLines[line].append("balance\u2191\u2191balance\u2191\u2191balance\u2191\u2191");
        }
        dynamicsLines[line].append("balance\u2191\u2191balance\u2191\u2191");
        for (i = 0; i < this.itemList.size(); ++i) {
            for (int j = 0; j < this.currencys.size(); ++j) {
                String key;
                if (i < this.debitSize) {
                    key = String.valueOf(this.debitColumn[this.debitColumn.length - i - 1][this.uperAccountLevel - line]);
                    if (this.displayAmount) {
                        dynamicsLines[line].append(key).append("\u2191\u2191");
                        dynamicsLines[line].append(key).append("\u2191\u2191");
                        dynamicsLines[line].append(key).append("\u2191\u2191");
                    }
                    if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                        dynamicsLines[line].append(key).append("\u2191\u2191");
                    }
                    dynamicsLines[line].append(key).append("\u2191\u2191");
                    continue;
                }
                key = String.valueOf(this.creditColumn[this.creditColumn.length - i - 1 + this.debitSize][this.uperAccountLevel - line]);
                if (this.displayAmount) {
                    dynamicsLines[line].append(key).append("\u2191\u2191");
                    dynamicsLines[line].append(key).append("\u2191\u2191");
                    dynamicsLines[line].append(key).append("\u2191\u2191");
                }
                if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                    dynamicsLines[line].append(key).append("\u2191\u2191");
                }
                dynamicsLines[line].append(key).append("\u2191\u2191");
            }
        }
        this.delLastChars(dynamicsLines[line], 2);
    }

    protected void dealMultiTitleLine1(StringBuffer lineStr1) throws EASBizException, BOSException {
        int i;
        lineStr1.append("KSQL_SEQ");
        if (!this.dao.isCreateSeqTable()) {
            lineStr1.append("\u2191\u2191").append("SQL_BATCH");
        }
        lineStr1.append("\u2191\u2191date\u2191\u2191voucher_type_number\u2191\u2191abstract_description\u2191\u2191");
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                lineStr1.append("dir_debit\u2191\u2191dir_debit\u2191\u2191dir_debit\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr1.append("dir_debit\u2191\u2191");
            }
            lineStr1.append("dir_debit\u2191\u2191");
        }
        if (this.currencySize > 1) {
            lineStr1.append("dir_debit\u2191\u2191");
        }
        for (i = 0; i < this.currencySize; ++i) {
            if (this.displayAmount) {
                lineStr1.append("dir_credit\u2191\u2191dir_credit\u2191\u2191dir_credit\u2191\u2191");
            }
            if (this.displayOrigine && !this.currencys.get(i).getId().toString().equals(this.baseCurrencyId)) {
                lineStr1.append("dir_credit\u2191\u2191");
            }
            lineStr1.append("dir_credit\u2191\u2191");
        }
        if (this.currencySize > 1) {
            lineStr1.append("dir_credit\u2191\u2191");
        }
        if (this.displayAmount) {
            lineStr1.append("balance\u2191\u2191balance\u2191\u2191balance\u2191\u2191");
        }
        lineStr1.append("balance\u2191\u2191balance\u2191\u2191");
        for (i = 0; i < this.itemList.size(); ++i) {
            for (int j = 0; j < this.currencys.size(); ++j) {
                if (i < this.debitSize) {
                    if (this.displayAmount) {
                        lineStr1.append("dir_debit\u2191\u2191dir_debit\u2191\u2191dir_debit\u2191\u2191");
                    }
                    if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                        lineStr1.append("dir_debit\u2191\u2191");
                    }
                    lineStr1.append("dir_debit\u2191\u2191");
                    continue;
                }
                if (this.displayAmount) {
                    lineStr1.append("dir_credit\u2191\u2191dir_credit\u2191\u2191dir_credit\u2191\u2191");
                }
                if (this.displayOrigine && !this.currencys.get(j).getId().toString().equals(this.baseCurrencyId)) {
                    lineStr1.append("dir_credit\u2191\u2191");
                }
                lineStr1.append("dir_credit\u2191\u2191");
            }
        }
        this.delLastChars(lineStr1, 2);
    }

    protected String glRptIDs2StrId(GLRptID[] ids, String tbAlias) {
        StringBuffer strIds = new StringBuffer();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    strIds.append(" or ");
                }
                strIds.append(" (").append(tbAlias).append(".").append("KSQL_SEQ").append(" = ").append(ids[i].getSeq()).append(" and ").append(tbAlias).append(".").append("SQL_BATCH").append(" = ").append(ids[i].getBatch()).append(")");
            }
        }
        return strIds.length() > 0 ? "(" + strIds.toString() + ")" : null;
    }

    protected void delLastChar(StringBuffer sb) {
        this.delLastChars(sb, 1);
    }

    protected void delLastChars(StringBuffer sb, int len) {
        if (sb.length() > 0) {
            for (int i = 0; i < len; ++i) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
    }

    protected Object getGovAccountDetailFilter(Context ctx, ReportConditionAsstactMultiColumn condition) {
        return null;
    }

    protected String getGovAccountDetailJoinTable(Context ctx, ReportConditionAsstactMultiColumn condition) {
        return null;
    }

    protected void releaseTempTable() {
        try {
            if (this.dao.getIdListTempTable() != null) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.dao.getIdListTempTable());
            }
        }
        catch (Exception e) {
            logger.error((Object)"Release tempTable error!", (Throwable)e);
        }
        try {
            if (this.entryTempTable != null) {
                TempTablePool.getInstance((Context)this.ctx).releaseTable(this.entryTempTable);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Release tempTable error!", (Throwable)e);
        }
    }

    protected String getAccountViewMeasureUnitName() throws BOSException {
        String baseMuName = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select av.fid,av.flongnumber ,mu.fname_" + this.loc + " fmuname from t_bd_accountview av \n");
        sql.append("left join T_BD_MeasureUnitGroup mug on av.FMeasureUnitGroupID = mug.fid ");
        sql.append("left join T_BD_MeasureUnit mu on mu.fid = mug.FDefaultUnitID \n");
        sql.append(" where av.fid = '").append(this.accountView.getId().toString()).append("' ");
        IRowSet iRowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (iRowSet.next()) {
                baseMuName = iRowSet.getString("fmuname");
            }
        }
        catch (SQLException ex) {
            throw new BOSException("sql error!", (Throwable)ex);
        }
        return baseMuName;
    }

    private GLRptRowSet fromGlRptRowSet(GLRptRowSet from) throws BOSException {
        String[] columnKeys = from.getColumKeys();
        int rowCount = from.size();
        GLRptRowSet result = new GLRptRowSet(columnKeys, rowCount);
        for (int i = 0; i < rowCount; ++i) {
            for (String columnKey : columnKeys) {
                result.updateObject(i, columnKey, from.getObject(i, columnKey));
            }
        }
        return result;
    }

    private BigDecimal getFetchSbBalDataDecimal(String colName) throws BOSException {
        return GlUtils.substract(this.fetchSbBalData.getBigDecimal(2, colName), this.fetchSbBalData.getBigDecimal(1, colName));
    }

    protected class VoucherLineData {
        private int sourceType;
        private int actDC;
        private String periodID;
        private String currencyID;
        private BigDecimal originalAmount;
        private BigDecimal localAmount;
        private BigDecimal quantity;
        private BigDecimal stdQuantity;
        private BigDecimal coefficient;
        private String measureUnitName;
        private boolean detailDspStandard;
        private String detailDspMu;

        public VoucherLineData(IRowSet rs, boolean displayAmount) throws SQLException {
            this.sourceType = rs.getInt("FSourceType");
            this.actDC = rs.getInt("ActDC");
            this.periodID = rs.getString("fperiodid");
            this.currencyID = rs.getString("FCurrencyID");
            this.originalAmount = rs.getBigDecimal("FOriginalAmount");
            this.localAmount = rs.getBigDecimal("FLocalAmount");
            this.quantity = GlUtils.zero;
            this.stdQuantity = GlUtils.zero;
            if (displayAmount) {
                this.quantity = rs.getBigDecimal("fquantity");
                this.stdQuantity = rs.getBigDecimal("FStandardQuantity");
                this.coefficient = rs.getBigDecimal("FCoefficient");
                this.measureUnitName = rs.getString("muname");
            }
        }

        public int getSourceType() {
            return this.sourceType;
        }

        public void setSourceType(int sourceType) {
            this.sourceType = sourceType;
        }

        public int getActDC() {
            return this.actDC;
        }

        public void setActDC(int actDC) {
            this.actDC = actDC;
        }

        public String getPeriodID() {
            return this.periodID;
        }

        public void setPeriodID(String periodID) {
            this.periodID = periodID;
        }

        public String getCurrencyID() {
            return this.currencyID;
        }

        public void setCurrencyID(String currencyID) {
            this.currencyID = currencyID;
        }

        public BigDecimal getOriginalAmount() {
            return this.originalAmount;
        }

        public void setOriginalAmount(BigDecimal originalAmount) {
            this.originalAmount = originalAmount;
        }

        public BigDecimal getLocalAmount() {
            return this.localAmount;
        }

        public void setLocalAmount(BigDecimal localAmount) {
            this.localAmount = localAmount;
        }

        public BigDecimal getQuantity() {
            return this.quantity;
        }

        public void setQuantity(BigDecimal quantity) {
            this.quantity = quantity;
        }

        public BigDecimal getStdQuantity() {
            return this.stdQuantity;
        }

        public void setStdQuantity(BigDecimal stdQuantity) {
            this.stdQuantity = stdQuantity;
        }

        public BigDecimal getCoefficient() {
            return this.coefficient;
        }

        public void setCoefficient(BigDecimal coefficient) {
            this.coefficient = coefficient;
        }

        public void setMeasureUnitName(String measureUnitName) {
            this.measureUnitName = measureUnitName;
        }

        public String getMeasureUnitName() {
            return this.measureUnitName;
        }

        public String getDetailDspMu() {
            return this.detailDspMu;
        }

        public void setDetailDspMu(String detailDspMu) {
            this.detailDspMu = detailDspMu;
        }

        public void setDetailDspStandard(boolean detailDspStandard) {
            this.detailDspStandard = detailDspStandard;
        }

        public boolean isDetailDspStandard() {
            return this.detailDspStandard;
        }
    }
}

