/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.InitHelp;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.AcctCussentCheckCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.AcctCussentCheckPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptTempTableInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class AcctCussentCheckDao
extends AbstractGLRptDao {
    public static final String RESOURCE = "com.kingdee.eas.fi.gl.app.AcctCussentCheckDaoResource";
    protected AcctCussentCheckCondition cond;

    public AcctCussentCheckDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
    }

    public String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)RESOURCE, (String)resName, (Locale)ctx.getLocale());
    }

    @Override
    protected void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (AcctCussentCheckCondition)this.getQueryCondition();
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new AcctCussentCheckPageQuery(this.getContex(), this.cond);
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        if (this.cond.isExport()) {
            List asstList = this.cond.getAsstActList();
            Iterator it = asstList.iterator();
            AsstactTypeEntity at = null;
            while (it.hasNext()) {
                at = (AsstactTypeEntity)it.next();
                selector.add(new GLRptField(at.getHgAttribute() + "Name", "NVARCHAR(100)", at.getName(), 100, false));
            }
        }
        selector.add(new GLRptField("FDate", "DateTime", this.getResource(this.getContex(), "bookDate"), 100, true));
        selector.add(new GLRptField("FVoucherId", "NVARCHAR(44)", null, -1, true));
        selector.add(new GLRptField("FVoucherNumber", "NVARCHAR(100)", this.getResource(this.getContex(), "voucherNumber"), 150, true));
        selector.add(new GLRptField("FVoucherType", "NVARCHAR(100)", null, -1, true));
        selector.add(new GLRptField("FDescription", "NVARCHAR(500)", this.getResource(this.getContex(), "description"), 100, true));
        selector.add(new GLRptField("FCurrencyID", "NVARCHAR(44)", null, -1, true));
        if (this.cond.isAllCurrency()) {
            selector.add(new GLRptField("FCurrencyName", "NVARCHAR(44)", this.getResource(this.getContex(), "currency"), 80, false));
        }
        selector.add(new GLRptField("FVoucherAsstID", "NVARCHAR(44)", null, -1, true));
        selector.add(new GLRptField("FAcctCussentID", "NVARCHAR(44)", null, -1, true));
        selector.add(new GLRptField("FAssGrpID", "NVARCHAR(44)", null, -1, true));
        if (this.cond.isKShowBizNum()) {
            selector.add(new GLRptField("FinvoiceNumber", "NVARCHAR(44)", this.getResource(this.getContex(), "invoiceNumber"), 120, true));
            selector.add(new GLRptField("FbizNumber", "NVARCHAR(80)", this.getResource(this.getContex(), "bizNumber"), 120, true));
        }
        selector.add(new GLRptField("FDebit", "NUMERIC(27,10)", this.getResource(this.getContex(), "Debit"), 100, true));
        selector.add(new GLRptField("FCredit", "NUMERIC(27,10)", this.getResource(this.getContex(), "Credit"), 100, true));
        selector.add(new GLRptField("FDC", "INT", "\u65b9\u5411", 60, true));
        selector.add(new GLRptField("FBalance", "NUMERIC(27,10)", this.getResource(this.getContex(), "amount"), 100, true));
        selector.add(new GLRptField("FLineType", "INT", null, -1, true));
        selector.add(new GLRptField("FIsInit", "INT", null, -1, true));
        return selector;
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        boolean isInTimeVerify;
        Connection con = this.getConnection();
        String tablename = this.getDataSourceTableName();
        AcctCussentCheckPageQuery query = new AcctCussentCheckPageQuery(this.getContex(), this.cond);
        query.setSelector(this.getGLRptSelector());
        int verifyMode = GlUtils.getVerifyMode(this.getContex(), this.cond.getCompany().getId().toString());
        boolean bl = isInTimeVerify = verifyMode == 0;
        if (verifyMode == 2) {
            query.setIncludeUnPosted(true);
        }
        String loc = this.getContex().getLocale().toString();
        this.insertBeginBalance(con);
        if (this.cond.isIncludeFinished()) {
            this.insertAcVoucherBal(con, query, tablename, loc, isInTimeVerify);
        } else {
            this.insertVoucherBal(con, query, tablename, loc, isInTimeVerify);
        }
    }

    @Override
    protected void insertSumItem() throws EASBizException, BOSException {
        AcctCussentCheckPageQuery query = new AcctCussentCheckPageQuery(this.getContex(), this.cond);
        query.setSelector(this.getGLRptSelector());
        query.setDataSourceTable(this.getDataSourceTable());
        DbUtil.execute((Context)this.getContex(), (String)query.getSumSql());
    }

    @Override
    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws BOSException, EASBizException, SQLException {
        super.toGLRptRowData(rs, rowData);
    }

    private void insertVoucherBal(Connection con, AcctCussentCheckPageQuery query, String tablename, String loc, boolean isInTimeVerify) throws EASBizException, BOSException {
        ArrayList params = new ArrayList();
        StringBuffer insert = query.getInsertAcSql(tablename, false);
        StringBuffer select = query.getSelectAcVeriSql(tablename, loc, isInTimeVerify, params);
        select.append(query.transWhereSelfDefineToSQL_Assist(this.cond.getSelfCond(), loc));
        insert.append(select);
        this.execute(con, insert.toString(), params.toArray());
        SQLUtils.cleanup((Connection)con);
    }

    private void insertAcVoucherBal(Connection con, AcctCussentCheckPageQuery query, String tablename, String loc, boolean isInTimeVerify) throws EASBizException, BOSException {
        ArrayList params = new ArrayList();
        StringBuffer insert = query.getInsertAcSql(tablename, true);
        StringBuffer select = query.getSelectOnlyAcSql(tablename, loc, isInTimeVerify, params);
        select.append(query.transWhereSelfDefineToSQL(this.cond.getSelfCond(), loc));
        this.execute(con, insert.toString() + select.toString(), params.toArray());
        params = new ArrayList();
        String sql = query.returnBackFutureVerify(query.getAccountDC(), tablename, isInTimeVerify, params);
        this.execute(con, sql, params.toArray());
        params = new ArrayList();
        sql = query.reCalcBal(tablename).toString();
        this.execute(con, sql, params.toArray());
        if (isInTimeVerify) {
            params = new ArrayList();
            StringBuffer verSql = query.getVeriSql_InTime(tablename, loc, isInTimeVerify, params);
            verSql.append(query.transWhereSelfDefineToSQL_Assist(this.cond.getSelfCond(), loc));
            this.execute(con, insert.toString() + verSql.toString(), params.toArray());
        } else {
            TempTablePool iPool = TempTablePool.getInstance((Context)this.getContex());
            String tempTableVerify = this.createTempTable4Verify(iPool, con);
            String tempTableVerified = this.createTempTable4Verified(iPool, con);
            params = new ArrayList();
            insert = query.getInsertAcSql(tempTableVerify, this.cond.isIncludeFinished());
            StringBuffer verNotSql = query.getVeriSql_NotInTime(loc, isInTimeVerify, params);
            verNotSql.append(query.transWhereSelfDefineToSQL_Assist(this.cond.getSelfCond(), loc));
            this.execute(con, insert.toString() + verNotSql.toString(), params.toArray());
            params = new ArrayList();
            StringBuffer historySql = query.getHistorySql4Verified(tempTableVerify, params);
            StringBuffer inVerSql = new StringBuffer();
            inVerSql.append("Insert Into ").append(tempTableVerified).append("\r\n (FVoucherAsstID,FSumVeri) \r\n");
            inVerSql.append(historySql);
            this.execute(con, inVerSql.toString(), params.toArray());
            query.updateTempTable_Veri_VerifyFromVerified(con, query.getAccountDC(), tempTableVerify, tempTableVerified);
            query.insertIntoTempTable_Ac_FromVerify(con, tablename, tempTableVerify);
        }
        params = new ArrayList();
        select.setLength(0);
        select.append("delete from ").append(tablename);
        select.append(" where flinetype = ").append(0);
        select.append(" and facctcussentid is not null and FBalance = 0");
        this.execute(con, select.toString(), params.toArray());
        SQLUtils.cleanup((Connection)con);
    }

    @Override
    protected void addTableHeadColumn(GLRptTableHeadInfo headInfo, GLRptField field) throws EASBizException, BOSException {
        super.addTableHeadColumn(headInfo, field);
        if (field.getType() == "INT") {
            headInfo.getTableColumnInfo(headInfo.getColumnSize() - 1).setAlign(2);
        } else if (field.getType() == "NUMERIC(28,10)") {
            headInfo.getTableColumnInfo(headInfo.getColumnSize() - 1).setAlign(3);
            headInfo.getTableColumnInfo(headInfo.getColumnSize() - 1).setNumeral(true);
            if (!("FDebit".equals(field.getName()) || "FCredit".equals(field.getName()) || "FBalance".equals(field.getName()))) {
                headInfo.getTableColumnInfo(headInfo.getColumnSize() - 1).setScale(this.cond.getRptParams().getPriceScale());
            }
        }
    }

    @Override
    protected String[][] getHeadTitles() throws EASBizException, BOSException {
        String[][] titles = new String[][]{this.getTitleRow1(), this.getTitleRow2()};
        return titles;
    }

    @Override
    protected String[] getTitleRow1() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        String fieldName = "";
        while (it.hasNext()) {
            GLRptField field = it.next();
            fieldName = field.getName();
            if (fieldName == null) continue;
            if ("FDC".equals(fieldName) || "FBalance".equals(fieldName)) {
                this.setRow1Title(colTitles, new GLRptField("FDebit", "NVARCHAR(44)", this.getResource(this.getContex(), "balance"), 180, false));
                continue;
            }
            this.setRow1Title(colTitles, field);
        }
        this.addSumItemTitle(colTitles);
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    private String createTempTable4Verify(TempTablePool iPool, Connection con) throws BOSException, EASBizException {
        String tempateTable = null;
        tempateTable = this.createTempTable4VerifyDDL(iPool, con);
        StringBuffer sql = new StringBuffer();
        try {
            sql.setLength(0);
            sql.append("create index I").append(tempateTable);
            sql.append(" on ").append(tempateTable);
            sql.append(" (FVoucherAsstID)");
            PreparedStatement ps = null;
            ps = con.prepareStatement(sql.toString());
            ps.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return tempateTable;
    }

    private String createTempTable4Verified(TempTablePool iPool, Connection con) throws BOSException, EASBizException {
        String tempateTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append("(                            \r\n");
        sql.append("    FVoucherAsstID varChar(44), \r\n");
        sql.append("\tFSumVeri Decimal(28,10) \r\n");
        sql.append(")                            \r\n");
        tempateTable = this.createTempTableByDDL(iPool, con, "AcctCussentCheckVerified", sql);
        try {
            sql.setLength(0);
            sql.append("create index I").append(tempateTable);
            sql.append(" on ").append(tempateTable);
            sql.append(" (FVoucherAsstID)");
            PreparedStatement ps = null;
            ps = con.prepareStatement(sql.toString());
            ps.execute();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return tempateTable;
    }

    @Override
    protected String[] getTitleRow2() throws EASBizException, BOSException {
        ArrayList<String> colTitles = new ArrayList<String>();
        colTitles.add("KSQL_SEQ");
        if (!this.isCreateSeqTable()) {
            colTitles.add("SQL_BATCH");
        }
        Iterator<GLRptField> it = this.getGLRptSelector().iterator();
        while (it.hasNext()) {
            GLRptField field = it.next();
            if (field.getName() == null) continue;
            this.setRow1Title(colTitles, field);
        }
        this.addSumItemTitle(colTitles);
        String[] titles = new String[colTitles.size()];
        colTitles.toArray(titles);
        return titles;
    }

    private List getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.cond.getAccountCodeStart());
        params.add(this.cond.getCompanyId());
        params.add(this.cond.getBookedDateStart());
        params.add(this.cond.getBookedDateEnd());
        if (!this.cond.isAllCurrency()) {
            params.add(this.cond.getCurrencyID());
        }
        List asstList = this.cond.getAsstActList();
        Iterator it = asstList.iterator();
        AsstactTypeEntity at = null;
        while (it.hasNext()) {
            at = (AsstactTypeEntity)it.next();
            params.add(at.getId());
        }
        return params;
    }

    private void insertBeginBalance(Connection con) throws BOSException, EASBizException {
        PeriodInfo beginPeriodInfo;
        AcctCussentCheckPageQuery query = new AcctCussentCheckPageQuery(this.getContex(), this.cond);
        query.setSelector(this.getGLRptSelector());
        ObjectUuidPK comPK = new ObjectUuidPK(this.cond.getCompany().getId());
        PeriodInfo minPeriodInfo = beginPeriodInfo = PeriodUtils.getPeriodInfo((Context)this.getContex(), (java.util.Date)this.cond.getBookedDateStart(), (IObjectPK)comPK);
        if (this.cond.getCurrPeriod().getNumber() < beginPeriodInfo.getNumber()) {
            minPeriodInfo = this.cond.getCurrPeriod();
        }
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>();
        String tablename = this.getDataSourceTableName();
        String executeSql = query.getBalanceSql(params, tablename).toString();
        params.set(2, Integer.valueOf(minPeriodInfo.getNumber()));
        DbUtil.execute((Context)this.getContex(), (String)executeSql, (Object[])params.toArray());
        java.util.Date minBeginDate = new java.util.Date(minPeriodInfo.getBeginDate().getTime());
        if (minBeginDate.before(this.cond.getBookedDateStart())) {
            StringBuffer sql = new StringBuffer();
            sql.append("create Table AcctCussentCheckHappen ");
            sql.append("(                   \r\n");
            sql.append("\tFCurrencyID varChar(44), \r\n");
            sql.append("\tFBalance Decimal(28,10) default(0) not null,  \r\n");
            sql.append("\tFAssGrpID varChar(44)    \r\n");
            sql.append(")                   \r\n");
            String tempTableHappend = this.createTempTable(sql.toString());
            params = new ArrayList();
            executeSql = query.getSql_AcBeginBalHappen(tempTableHappend, params).toString();
            params.set(2, minBeginDate);
            params.set(3, this.cond.getBookedDateStart());
            this.execute(con, executeSql, params.toArray());
            query.insertIntoTempTable_AcBeginBal_Preline(tablename, tempTableHappend);
            params = new ArrayList();
            executeSql = query.getSql_AcBeginBalUpdate(tablename, tempTableHappend, params).toString();
            this.execute(con, executeSql, params.toArray());
        }
    }

    private Connection getConnection() throws BOSException {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.getContex());
        }
        catch (SQLException exc) {
            SQLUtils.cleanup((Connection)conn);
            throw new BOSException("CONFIG_EXCEPTION", (Throwable)exc);
        }
        return conn;
    }

    private void execute(Connection con, String sql, Object[] params) throws BOSException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                if (params[i].getClass().equals(Integer.class)) {
                    ps.setInt(i + 1, (Integer)params[i]);
                    continue;
                }
                if (params[i].getClass().equals(java.util.Date.class)) {
                    ps.setDate(i + 1, new Date(((java.util.Date)params[i]).getTime()));
                    continue;
                }
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < params.length; ++i) {
                sb.append("param ").append(i).append(" is:").append(params[i]);
            }
            throw new BOSException("Sql222 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)ps);
        }
    }

    private String createTempTable(String createTable) {
        String tempateTable = "";
        try {
            tempateTable = TempTablePool.getInstance((Context)this.getContex()).createTempTable(createTable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempateTable;
    }

    private String createTempTableByDDL(TempTablePool iPool, Connection con, String keyDesc, StringBuffer strFields) throws BOSException, EASBizException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("CREATE TABLE ").append(keyDesc).append(strFields);
        String tempateTable = "";
        try {
            tempateTable = iPool.createTempTable(createTable.toString());
            InitHelp.truncate(con, tempateTable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tempateTable;
    }

    @Override
    protected GLRptTempTableInfo createDataTempTable() throws BOSException, EASBizException {
        String tempateTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" Create Table AcctCussentCheckResult ");
        sql.append("( \r\n");
        sql.append("\tFDate DateTime, \r\n");
        sql.append("\tFAcctCussentID varChar(44), \r\n");
        sql.append("    FDC Int default 0, \r\n");
        sql.append("\tFVoucherID varChar(44), \r\n");
        sql.append("\tFVoucherNumber NVarchar(100), \r\n");
        sql.append("\tFVoucherType NVarchar(100),\r\n");
        sql.append("\tFDescription NVarchar(255), \r\n");
        sql.append("\tFCurrencyID varChar(44), \r\n");
        sql.append("\tFDebit Decimal(28,10), \r\n");
        sql.append("\tFCredit Decimal(28,10), \r\n");
        sql.append("\tFBalance Decimal(28,10), \r\n");
        sql.append("\tFLineType Int, \r\n");
        sql.append("    FVoucherAsstID varChar(44), \r\n");
        sql.append("    FAssGrpID varChar(44), \r\n");
        sql.append("    FBizNumber nvarChar(80), \r\n");
        sql.append("    FInvoiceNumber nvarChar(160), \r\n");
        sql.append("    FIsInit Int default 0 ) \r\n");
        tempateTable = this.createTempTable(sql.toString());
        return new GLRptTempTableInfo(tempateTable);
    }

    private String createTempTable4VerifyDDL(TempTablePool iPool, Connection con) throws BOSException, EASBizException {
        String tempateTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append("(   ");
        sql.append("\tFDate DateTime, ");
        sql.append("\tFAcctCussentID varChar(44), ");
        sql.append("    FDC Int default 0, ");
        sql.append("\tFVoucherID varChar(44), ");
        sql.append("\tFVoucherNumber NVarchar(100), ");
        sql.append("\tFVoucherType NVarchar(100),");
        sql.append("\tFDescription NVarchar(255), ");
        sql.append("\tFCurrencyID varChar(44), ");
        sql.append("\tFDebit Decimal(28,10), ");
        sql.append("\tFCredit Decimal(28,10), ");
        sql.append("\tFBalance Decimal(28,10), ");
        sql.append("\tFLineType Int, ");
        sql.append("    FVoucherAsstID varChar(44), ");
        sql.append("    FAssGrpId varChar(44),");
        sql.append("    FBizNumber nvarChar(80), ");
        sql.append("    FInvoiceNumber nvarChar(160), ");
        sql.append("    FIsInit Int default 0) ");
        tempateTable = this.createTempTableByDDL(iPool, con, "AcctCussentCheckVerify", sql);
        return tempateTable;
    }

    protected GLRptPageQuery getQuery(Context ctx, AcctCussentCheckCondition cond) throws EASBizException, BOSException {
        return new AcctCussentCheckPageQuery(ctx, cond);
    }
}

