/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GLBalanceUtils;
import com.kingdee.eas.fi.gl.common.AsstactTypeEntity;
import com.kingdee.eas.fi.gl.rpt.AcctCussentCheckCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class AcctCussentCheckPageQuery
extends GLRptPageQuery {
    private AcctCussentCheckCondition cond;
    private boolean hideNotHappened = false;
    private boolean includeFinished = false;
    private boolean includeUnPosted = false;
    private boolean kShowBizNum = false;
    private String tablename;
    private String localeSuf;

    public boolean isIncludeUnPosted() {
        return this.includeUnPosted;
    }

    public void setIncludeUnPosted(boolean includeUnPosted) {
        this.includeUnPosted = includeUnPosted;
    }

    public AcctCussentCheckPageQuery(Context ctx, AcctCussentCheckCondition cond) {
        super(ctx, cond);
        this.hideNotHappened = cond.isHideNotHappened();
        this.includeFinished = cond.isIncludeFinished();
        this.includeUnPosted = cond.isIncludeUnPosted();
        this.kShowBizNum = cond.isKShowBizNum();
        this.tablename = super.getDataSourceTableName();
        this.cond = cond;
        this.localeSuf = ctx.getLocale().toString();
    }

    @Override
    protected String getJoinSQL() throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (this.cond.isExport()) {
            Iterator it = this.cond.getAsstActList().iterator();
            sql.append(" inner join ").append("t_bd_assistanthg hg ").append(" on t.FAssGrpID").append(" = ").append("hg.fid ");
            while (it.hasNext()) {
                AsstactTypeEntity at = (AsstactTypeEntity)it.next();
                sql.append(" left outer join ").append(at.getTableName()).append(" ").append(at.getHgAttribute()).append(" on hg.").append(at.getHgField()).append(" = ").append(at.getHgAttribute()).append(".fid ");
            }
        }
        return sql.toString();
    }

    @Override
    protected GLRptSQLOrder getOrder() throws BOSException {
        GLRptSQLOrder order = new GLRptSQLOrder();
        if (this.cond.isExport()) {
            List asstList = this.cond.getAsstActList();
            Iterator it = asstList.iterator();
            AsstactTypeEntity at = null;
            while (it.hasNext()) {
                at = (AsstactTypeEntity)it.next();
                order.add("hg." + at.getHgField());
            }
        }
        order.add("fcurrencyid");
        order.add("flinetype");
        order.add("fdate");
        order.add("fisinit");
        order.add("fvouchernumber");
        return order;
    }

    protected String getSumSql() {
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT ");
        insert.append(this.getDataSourceTableName());
        insert.append("\t(FCurrencyID, FDebit, FCredit,");
        insert.append("\tFBalance,FAssGrpId,FLineType)");
        StringBuffer select = new StringBuffer();
        select.append(" select FCurrencyID, sum(fdebit) fdebit,sum(fcredit) fcredit,sum(fbalance) fbalance,FAssGrpId,").append(9);
        select.append(" from ").append(this.getDataSourceTableName()).append(" where FLineType<>").append(-3);
        select.append(" group by FAssGrpId,FCurrencyID");
        return insert.toString() + select.toString();
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        StringBuffer selectSql = new StringBuffer("select ");
        StringBuffer joinSql = new StringBuffer();
        StringBuffer orderSql = new StringBuffer();
        if (this.cond.isExport()) {
            joinSql.append(" left join T_BD_AssistantHG hg on hg.fid = t.FAssGrpID ");
            List asstList = this.cond.getAsstActList();
            Iterator it = asstList.iterator();
            AsstactTypeEntity at = null;
            int i = 1;
            String alas = "";
            while (it.hasNext()) {
                at = (AsstactTypeEntity)it.next();
                alas = "asst" + i++;
                selectSql.append(alas).append(".fname_").append(this.localeSuf).append(" ").append(at.getHgAttribute()).append("Name, ");
                joinSql.append(" left join ").append(at.getTableName()).append(" ").append(alas).append(" on hg.").append(at.getHgField()).append(" = ").append(alas).append(".fid");
                orderSql.append(" hg.").append(at.getHgField()).append(",");
            }
        }
        this.getCtx().getLocale();
        joinSql.append(" inner join t_bd_currency cy on cy.fid = t.fcurrencyid ");
        selectSql.append(" t.*,cy.fname_").append(this.localeSuf).append(" fcurrencyName,");
        selectSql.append(" cy.fprecision ");
        selectSql.append(" from ").append(this.getDataSourceTableName()).append(" t ");
        StringBuffer sql = new StringBuffer();
        sql.append(selectSql).append(joinSql);
        sql.append(" where ").append(super.getWhereSQL().toString());
        sql.append(" order by ").append(orderSql).append("t.fcurrencyid,t.flinetype,t.fdate,t.fisinit,t.fvouchernumber");
        return sql.toString();
    }

    protected StringBuffer getBalanceSql(List params, String tablename) throws EASBizException, BOSException {
        StringBuffer sql_AcBegin = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT ");
        insert.append(tablename);
        insert.append(" ( FCurrencyID,FDebit,FCredit,FBalance,FLineType,FAssGrpId ) ");
        select.append(" select bal.fcurrencyid, 0 FDebit, 0 FCredit,                  \r\n");
        select.append("  sum(bal.fbeginbalancefor) FBalance, -3 as FLineType          \r\n");
        select.append("  ,bal.fassistgrpid as FAssGrpId          \r\n");
        select.append(" from " + GLBalanceUtils.getAssistBalanceTable(5) + " bal                                   \r\n");
        select.append("  inner join t_bd_assistanthg hg on bal.fassistgrpid = hg.fid  \r\n");
        select.append(" where bal.faccountid = ?                                      \r\n");
        select.append("  and bal.forgunitid = ?                                       \r\n");
        select.append("  and bal.fperiod = ?                                        \r\n");
        params.add(this.cond.getAccountId());
        params.add(this.cond.getCompany().getId().toString());
        params.add(this.cond.getCurrPeriod().getNumber());
        if (!this.cond.isAllCurrency()) {
            select.append(" and bal.fcurrencyid=?  \r\n");
            params.add(this.cond.getCurrencyID());
        }
        select.append(this.getSelectHg(params));
        select.append(" group by bal.fassistgrpid,bal.fcurrencyid  \r\n");
        sql_AcBegin.append(insert);
        sql_AcBegin.append(select);
        return sql_AcBegin;
    }

    protected StringBuffer getSql_AcBeginBalHappen(String tempTableHappend, List params) throws BOSException {
        StringBuffer sql_AcBegin = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT ");
        insert.append(tempTableHappend);
        insert.append(" (FCurrencyID,FBalance,FAssGrpID)  \r\n");
        String amountField = "assist.foriginalamount";
        String amountField_AC = "";
        select.append("select /*+ leading (hg) */ ");
        select.append("entry.fcurrencyid,  \r\n");
        select.append("sum((entry.fentrydc * 2 - 1) * " + amountField + ") fbalance  \r\n,assist.fassgrpid");
        select.append(" from t_gl_voucherassistrecord assist  \r\n");
        select.append(" inner join t_gl_voucherentry entry on assist.fentryid=entry.fid  \r\n");
        select.append(" inner join t_gl_voucher voucher on voucher.fid = entry.fbillid  \r\n");
        select.append("                                 and voucher.fid = assist.fbillid  \r\n");
        select.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = voucher.fperiodid  \r\n");
        select.append("                                 and acperiod.fcompanyid=voucher.fcompanyid  \r\n");
        select.append(" left outer join t_bd_vouchertypes vouchertype on voucher.fvouchertypeid=vouchertype.fid  \r\n");
        select.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
        select.append(" where entry.faccountid = ? and voucher.fcompanyid = ?  \r\n");
        select.append("  and voucher.fbookeddate >= ? and voucher.fbookeddate < ?  \r\n");
        params.add(this.cond.getAccountId());
        params.add(this.cond.getCompany().getId().toString());
        params.add(this.cond.getBookedDateStart());
        params.add(this.cond.getBookedDateEnd());
        if (!this.includeUnPosted) {
            select.append(" and voucher.fbizstatus=").append(5);
        } else {
            select.append(" and voucher.fbizstatus<>").append(2);
            select.append(" and voucher.fbizstatus<>").append(0);
        }
        if (!this.cond.isAllCurrency()) {
            select.append("\r\n and entry.fcurrencyid=?  \r\n");
            params.add(this.cond.getCurrencyID());
        }
        select.append(this.getSelectHg(params));
        select.append("\r\n group by assist.fassgrpid,entry.fcurrencyid  \r\n");
        sql_AcBegin.append(insert);
        sql_AcBegin.append(select);
        return sql_AcBegin;
    }

    protected StringBuffer getSelectOnlyAcSql(String tablename, String loc, boolean isInTimeVerify, List params) throws BOSException {
        StringBuffer select = new StringBuffer();
        String amountField = "";
        amountField = !this.includeFinished ? "cussent.foriginalamount" : (isInTimeVerify && this.includeUnPosted ? "cussent.funholdedAmtFor" : "cussent.funverifiedamtfor");
        select.append(" select /*+ leading (hg) */ voucher.FBookedDate,voucher.fid,voucher.fnumber,vouchertype.fname_").append(this.localeSuf);
        select.append(",cussent.fdescription,cussent.fcurrencyid,(case when entry.fentrydc=1 then " + amountField + " else 0 end),");
        select.append("(case when entry.fentrydc=0 then ").append(amountField).append(" else 0 end),");
        select.append("(entry.fentrydc*2-1)*").append(amountField).append(",").append(0);
        select.append(" ,cussent.fvchassistrecordid,cussent.fassgrpid,cussent.FBizNumber,cussent.FInvoiceNumber");
        if (this.includeFinished) {
            select.append(",cussent.fid facctcussentid,account.fdc  \r\n");
        }
        select.append(" from t_gl_acctcussent cussent  \r\n");
        select.append(" inner join t_gl_voucherentry entry on cussent.fentryid=entry.fid  \r\n");
        select.append(" inner join t_gl_voucher voucher on voucher.fid = cussent.fvoucherid  \r\n");
        select.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = voucher.fperiodid and acperiod.fcompanyid=voucher.fcompanyid  \r\n");
        select.append(" inner join t_bd_vouchertypes vouchertype on voucher.fvouchertypeid=vouchertype.fid  \r\n");
        select.append(" inner join t_bd_assistanthg hg on cussent.fassgrpid=hg.fid  \r\n");
        select.append(" inner join t_bd_accountview account on entry.faccountid = account.fid and cussent.faccountid = account.fid  \r\n");
        select.append("where entry.faccountid=? and cussent.faccountid=?  \r\n");
        select.append("and voucher.fcompanyid=? and cussent.fcompanyid=?  \r\n");
        params.add(this.cond.getAccountId());
        params.add(this.cond.getAccountId());
        params.add(this.cond.getCompany().getId().toString());
        params.add(this.cond.getCompany().getId().toString());
        select.append("and voucher.FBookedDate>=? and voucher.FBookedDate<=?  \r\n");
        params.add(this.cond.getBookedDateStart());
        params.add(this.cond.getBookedDateEnd());
        if (!this.includeUnPosted) {
            select.append(" and voucher.fbizstatus=5  \r\n");
        } else {
            select.append(" and voucher.fbizstatus<>0 and voucher.fbizstatus<>2  \r\n");
        }
        if (!"AllCurrency".equals(this.cond.getCurrencyID())) {
            select.append(" and entry.fcurrencyid=?  \r\n");
            select.append(" and cussent.fcurrencyid=?  \r\n");
            params.add(this.cond.getCurrencyID());
            params.add(this.cond.getCurrencyID());
        }
        select.append(this.getSelectHg(params));
        return select;
    }

    protected StringBuffer getSelectAcVeriSql(String tablename, String loc, boolean isInTimeVerify, List params) throws BOSException {
        String amountField = "assist.foriginalamount";
        StringBuffer select = new StringBuffer();
        select.append(" select /*+ leading (hg) */ voucher.FBookedDate,voucher.fid,voucher.fnumber,vouchertype.fname_").append(this.localeSuf).append("  \r\n");
        select.append(",assist.fdescription,entry.fcurrencyid,  \r\n");
        select.append("(case when entry.fentrydc=1 then ").append(amountField).append(" else 0 end),  \r\n");
        select.append("(case when entry.fentrydc=0 then ").append(amountField).append(" else 0 end),  \r\n");
        select.append("(entry.fentrydc*2-1)*").append(amountField).append(",  \r\n");
        select.append(0);
        select.append(" ,assist.fid,assist.fassgrpid,assist.FBizNumber,assist.FInvoiceNumber  \r\n");
        select.append(" from t_gl_voucherassistrecord assist  \r\n");
        select.append(" inner join t_gl_voucherentry entry on assist.fentryid=entry.fid  \r\n");
        select.append(" inner join t_gl_voucher voucher on voucher.fid = entry.fbillid  \r\n");
        select.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = voucher.fperiodid and acperiod.fcompanyid=voucher.fcompanyid  \r\n");
        select.append(" inner join t_bd_vouchertypes vouchertype on voucher.fvouchertypeid=vouchertype.fid  \r\n");
        select.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
        select.append(" inner join t_bd_accountview account on entry.faccountid = account.fid  \r\n");
        select.append("where entry.faccountid=? and voucher.fcompanyid=?  \r\n");
        select.append("and voucher.FBookedDate>=? and voucher.FBookedDate<=?  \r\n");
        params.add(this.cond.getAccountId());
        params.add(this.cond.getCompany().getId().toString());
        params.add(this.cond.getBookedDateStart());
        params.add(this.cond.getBookedDateEnd());
        if (isInTimeVerify) {
            if (!this.includeUnPosted) {
                select.append(" and voucher.fbizstatus=5 ");
            } else {
                select.append(" and (entry.fentrydc*2-1 = account.fdc   \r\n");
                select.append("   and voucher.fbizstatus=5 ");
                select.append("   or entry.fentrydc*2-1 <> account.fdc   \r\n");
                select.append("   and voucher.fbizstatus<>0 and voucher.fbizstatus<>2 ");
                select.append("   )                                      \r\n");
            }
        } else if (!this.includeUnPosted) {
            select.append("   and voucher.fbizstatus=5 ");
        } else {
            select.append("   and voucher.fbizstatus<>0 and voucher.fbizstatus<>2 ");
        }
        if (!"AllCurrency".equals(this.cond.getCurrencyID())) {
            select.append("\r\n and entry.fcurrencyid=?   \r\n");
            params.add(this.cond.getCurrencyID());
        }
        select.append(this.getSelectHg(params));
        return select;
    }

    protected StringBuffer transWhereSelfDefineToSQL(EntityViewInfo mainQuery, String loc) {
        StringBuffer where = new StringBuffer();
        String preTable = "cussent.";
        String preTableVch = "voucher.";
        String preTableDC = "cussent.";
        if (mainQuery == null) {
            return where;
        }
        FilterInfo filterInfo = mainQuery.getFilter();
        if (filterInfo == null) {
            return where;
        }
        String filter = filterInfo.toString();
        if (StringUtils.isEmpty((String)filter)) {
            return where;
        }
        if (filter.indexOf("bizNumber") != -1) {
            filter = filter.replaceAll("bizNumber", preTable + "fbizNumber");
        }
        if (filter.indexOf("invoiceNumber") != -1) {
            filter = filter.replaceAll("invoiceNumber", preTable + "finvoiceNumber");
        }
        if (filter.indexOf("entrydc") != -1) {
            filter = filter.replaceAll("entrydc", preTableDC + "fentrydc");
        }
        if (filter.indexOf("originalAmount") != -1) {
            filter = filter.replaceAll("originalAmount", preTable + "foriginalAmount");
        }
        if (filter.indexOf("voucherType.name") != -1) {
            filter = filter.replaceAll("voucherType.name", "voucherType.fname_" + this.localeSuf);
        }
        if (filter.indexOf("voucher.number") != -1) {
            filter = filter.replaceAll("voucher.number", preTableVch + "fnumber");
        }
        if (filter.indexOf("description") != -1) {
            filter = filter.replaceAll("description", preTable + "fdescription");
        }
        if (filter.indexOf("debitAmount") != -1) {
            filter = filter.replaceAll("debitAmount", "(case " + preTableDC + "fentrydc when 1 then " + preTable + "foriginalAmount else 0 end)");
        }
        if (filter.indexOf("creditAmount") != -1) {
            filter = filter.replaceAll("creditAmount", "(case " + preTableDC + "fentrydc when 0 then " + preTable + "foriginalAmount else 0 end)");
        }
        if (filter.indexOf("VARBizDate") != -1) {
            filter = filter.replaceAll("VARBizDate", preTable + "fVARBizDate");
        }
        where.append(" and ").append(filter).append("  \r\n");
        return where;
    }

    protected int getAccountDC() throws BOSException {
        int dc = 1;
        Object ps = null;
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fdc from t_bd_accountview where fid = ?");
        rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString(), (Object[])new Object[]{this.cond.getAccountId()});
        try {
            if (rs.next()) {
                dc = rs.getInt("fdc");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return dc;
    }

    protected StringBuffer getVeriSql_InTime(String tablename, String loc, boolean isInTimeVerify, List params) throws BOSException {
        StringBuffer selectVeri = new StringBuffer();
        StringBuffer select = this.getVeriSql_Select(loc, this.includeFinished);
        StringBuffer from = this.getVeriSql_From();
        from.append(" left join ").append(tablename).append("  \r\n");
        from.append(" tmp on tmp.FAcctCussentID = assist.fverifiedcussentid \r\n");
        StringBuffer where = this.getVeriSql_Where(isInTimeVerify, params);
        where.append(" and tmp.FAcctCussentID is null  \r\n");
        selectVeri.append(select).append(from).append(where);
        return selectVeri;
    }

    private StringBuffer getVeriSql_From() {
        StringBuffer selectVeri = new StringBuffer();
        selectVeri.append(" from t_gl_voucherassistrecord assist  \r\n");
        selectVeri.append(" inner join t_gl_voucherentry entry on assist.fentryid=entry.fid  \r\n");
        selectVeri.append(" inner join t_gl_voucher voucher on voucher.fid = entry.fbillid  \r\n");
        selectVeri.append(" inner join v_gl_acperiod acperiod on acperiod.fperiodid = voucher.fperiodid and acperiod.fcompanyid=voucher.fcompanyid  \r\n");
        selectVeri.append(" inner join t_bd_vouchertypes vouchertype on voucher.fvouchertypeid=vouchertype.fid  \r\n");
        selectVeri.append(" inner join t_bd_assistanthg hg on assist.fassgrpid=hg.fid  \r\n");
        selectVeri.append(" inner join t_bd_accountview account on entry.faccountid = account.fid  \r\n");
        return selectVeri;
    }

    private StringBuffer getVeriSql_Where(boolean isInTimeVerify, List params) throws BOSException {
        StringBuffer selectVeri = new StringBuffer();
        selectVeri.append("where entry.faccountid=? and voucher.fcompanyid=?  \r\n");
        params.add(this.cond.getAccountId());
        params.add(this.cond.getCompany().getId().toString());
        selectVeri.append("and voucher.FBookedDate>=? and voucher.FBookedDate<=?  \r\n");
        params.add(this.cond.getBookedDateStart());
        params.add(this.cond.getBookedDateEnd());
        if (isInTimeVerify && !this.includeUnPosted) {
            selectVeri.append(" and voucher.fbizstatus=5  \r\n");
        } else {
            selectVeri.append(" and voucher.fbizstatus<>0 and voucher.fbizstatus<>2  \r\n");
        }
        if (!"AllCurrency".equals(this.cond.getCurrencyID())) {
            selectVeri.append(" and entry.fcurrencyid=?  \r\n");
            params.add(this.cond.getCurrencyID());
        }
        selectVeri.append(" and entry.fentrydc*2-1 <> account.fdc  \r\n");
        selectVeri.append(this.getSelectHg(params));
        return selectVeri;
    }

    private StringBuffer getVeriSql_Select(String loc, boolean includeFinished) {
        StringBuffer selectVeri = new StringBuffer();
        String amountField = "assist.foriginalamount";
        selectVeri.append(" select /*+ leading (hg) */ voucher.FBookedDate,voucher.fid,voucher.fnumber,vouchertype.fname_").append(this.localeSuf).append("  \r\n");
        selectVeri.append(",assist.fdescription,entry.fcurrencyid,  \r\n");
        selectVeri.append("(case when entry.fentrydc=1 then ").append(amountField).append(" else 0 end),  \r\n");
        selectVeri.append("(case when entry.fentrydc=0 then ").append(amountField).append(" else 0 end),  \r\n");
        selectVeri.append("(entry.fentrydc*2-1)*").append(amountField).append(",  \r\n");
        selectVeri.append(0);
        selectVeri.append(",assist.fid,assist.fassgrpid,assist.FBizNumber,assist.FInvoiceNumber  \r\n");
        if (includeFinished) {
            selectVeri.append(",null,account.fdc  \r\n");
        }
        return selectVeri;
    }

    protected void insertIntoTempTable_Ac_FromVerify(Connection con, String tablename, String tempTableVerify) {
        PreparedStatement ps = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer select = new StringBuffer();
        StringBuffer insert = this.getInsertAcSql(tablename, this.includeFinished);
        select.append("\tSelect FDate,FVoucherID,FVoucherNumber,FVoucherType, FDescription, FCurrencyID,  \r\n");
        select.append("\tFDebit, FCredit,FBalance,FLineType,FVoucherAsstID,FAssGrpId,FBizNumber,FInvoiceNumber  \r\n");
        if (this.includeFinished) {
            select.append(",FAcctCussentID,FDC  \r\n");
        }
        select.append(" from ").append(tempTableVerify);
        sql.append(insert).append(select);
        try {
            ps = con.prepareStatement(sql.toString());
            ps.execute();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected void updateTempTable_Veri_VerifyFromVerified(Connection con, int accountDC, String tempTableVerify, String tempTableVerified) {
        PreparedStatement ps = null;
        StringBuffer sqlUpdate = new StringBuffer();
        try {
            if (accountDC == -1) {
                sqlUpdate.append("update ").append(tempTableVerify).append(" tmp \r\n");
                sqlUpdate.append(" set (FDebit)    \r\n");
                sqlUpdate.append(" =                \r\n");
                sqlUpdate.append("(select tmp.FDebit - bal.FSumVeri                \r\n");
                sqlUpdate.append(" from ").append(tempTableVerified).append(" bal \r\n");
                sqlUpdate.append(" where tmp.FVoucherAsstID = bal.FVoucherAsstID  \r\n");
                sqlUpdate.append(")");
            } else {
                sqlUpdate.setLength(0);
                sqlUpdate.append("update ").append(tempTableVerify).append(" tmp \r\n");
                sqlUpdate.append(" set (FCredit)    \r\n");
                sqlUpdate.append(" =                \r\n");
                sqlUpdate.append("(select tmp.FCredit - bal.FSumVeri                \r\n");
                sqlUpdate.append(" from ").append(tempTableVerified).append(" bal \r\n");
                sqlUpdate.append(" where tmp.FVoucherAsstID = bal.FVoucherAsstID  \r\n");
                sqlUpdate.append(")");
            }
            ps = con.prepareStatement(sqlUpdate.toString());
            ps.executeUpdate();
            ps.close();
            sqlUpdate.setLength(0);
            sqlUpdate.append("update ").append(tempTableVerify);
            sqlUpdate.append(" set FBalance = FDebit - FCredit ");
            ps = con.prepareStatement(sqlUpdate.toString());
            ps.executeUpdate();
            ps.close();
            sqlUpdate.setLength(0);
            sqlUpdate.append("delete from ").append(tempTableVerify);
            sqlUpdate.append(" where FBalance = 0");
            ps = con.prepareStatement(sqlUpdate.toString());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    protected StringBuffer getHistorySql4Verified(String tempTableVerify, List params) throws BOSException, EASBizException {
        StringBuffer historySql = new StringBuffer();
        String amountField = null;
        amountField = "khis.FOroginalAmount";
        String sum = "\r\n isnull(sum(" + amountField + "),0) FSumVeri  \r\n";
        String strSumTotal = "\r\n sum(FSumVeri) FSumVeri  \r\n";
        historySql.append("select FVoucherAsstIDID,").append(strSumTotal).append(" from ( \r\n");
        historySql.append(" select ").append("khis.FVOUCHERASSTIDID,").append(sum);
        historySql.append(" from t_gl_acctcussenthistory khis        \r\n");
        historySql.append(" INNER JOIN ").append(tempTableVerify).append(" veri on khis.FVOUCHERASSTIDID = veri.FVOUCHERASSTID    \r\n");
        historySql.append(" where khis.fdc IN (0, 2) AND khis.fvchdate >= ?  AND khis.fvchdate <= ?  \r\n");
        params.add(this.cond.getBookedDateStart());
        params.add(this.cond.getBookedDateEnd());
        historySql.append(" group by khis.FVOUCHERASSTIDID  \r\n");
        historySql.append(" UNION ALL  \r\n");
        historySql.append(" select ").append("khis.FVOUCHERASSTIDID,").append(sum);
        historySql.append(" from t_gl_acctcussenthistory khis        \r\n");
        historySql.append(" INNER JOIN ").append(tempTableVerify).append(" veri on khis.FVOUCHERASSTIDID = veri.FVOUCHERASSTID    \r\n");
        historySql.append(" inner join t_gl_voucher voucher on khis.fverivchid=voucher.fid     \r\n");
        historySql.append(" where khis.fdc IN (3) AND voucher.fbookeddate >= ?  AND voucher.fbookeddate <= ?  \r\n");
        params.add(this.cond.getBookedDateStart());
        params.add(this.cond.getBookedDateEnd());
        historySql.append(" group by khis.FVOUCHERASSTIDID \r\n");
        historySql.append(" )t  \r\n");
        historySql.append("group by FVOUCHERASSTIDID  \r\n");
        return historySql;
    }

    protected StringBuffer getVeriSql_NotInTime(String loc, boolean isInTimeVerify, List params) throws BOSException {
        StringBuffer selectVeri = new StringBuffer();
        StringBuffer select = this.getVeriSql_Select(loc, this.includeFinished);
        StringBuffer from = this.getVeriSql_From();
        StringBuffer where = this.getVeriSql_Where(isInTimeVerify, params);
        selectVeri.append(select).append(from).append(where);
        return selectVeri;
    }

    protected StringBuffer reCalcBal(String tablename) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tablename);
        sql.append(" set FBalance = FDebit - FCredit ");
        sql.append(" where flinetype = ").append(0);
        sql.append(" and facctcussentid is not null ");
        return sql;
    }

    protected String returnBackFutureVerify(int accountDC, String acTempateTable, boolean isInTimeVerify, List params) throws BOSException, EASBizException {
        String sql = "";
        String strDateType = "v.FBookedDate";
        Date sDate = this.cond.getBookedDateStart();
        Date eDate = this.cond.getBookedDateEnd();
        String sqlSelectSumOnePhase = null;
        if (isInTimeVerify) {
            sqlSelectSumOnePhase = "ISNULL(                                                                                                                         \r\n       (select ISNULL( SUM(R.Foriginalamount),0)       \r\n            FROM t_gl_voucherassistrecord R                                                                                   \r\n                INNER JOIN t_gl_voucher V ON v.fid = r.fbillid   \r\n            WHERE R.Fverifiedcussentid  = tmp.facctcussentid                                                  \r\n                AND (" + strDateType + " < ? or " + strDateType + " > ? )         \r\n";
            params.add(sDate);
            params.add(eDate);
            sqlSelectSumOnePhase = !this.includeUnPosted ? sqlSelectSumOnePhase + "                 and v.fbizstatus = 5  \r\n" : sqlSelectSumOnePhase + "                 and v.fbizstatus <> 0 and v.fbizstatus <> 2  \r\n";
            sqlSelectSumOnePhase = sqlSelectSumOnePhase + "          GROUP BY R.Fverifiedcussentid)                                                                                    \r\n       ,0)                                                                                                                      \r\n";
        } else {
            sqlSelectSumOnePhase = "ISNULL(                                                                                                                         \r\n       (select ISNULL(SUM(k.foroginalamount),0)       \r\n            FROM t_gl_acctcussenthistory k                                                                                   \r\n            WHERE k.fcussentidid = tmp.facctcussentid                                                            \r\n                AND k.fdc IN (0, 2)                         \r\n                AND EXISTS (SELECT 1 FROM t_gl_voucherassistrecord r LEFT OUTER JOIN t_gl_voucher v ON v.fid = r.fbillid   \r\n                             WHERE k.fvoucherasstidid = r.fid AND (" + strDateType + " < ? or " + strDateType + " > ? )                 \r\n            ) GROUP BY k.fcussentidid)                                                                                          \r\n     ,0)                                                                                                                        \r\n";
            params.add(sDate);
            params.add(eDate);
            sqlSelectSumOnePhase = sqlSelectSumOnePhase + "+                                                                                                                               \r\nISNULL(                                                                                                                         \r\n       (SELECT ISNULL(SUM(k.foroginalamount),0)          \r\n            FROM t_gl_acctcussenthistory k                                                                                \r\n            WHERE k.fcussentidid = tmp.facctcussentid                                                         \r\n                   AND k.fdc = 1                           \r\n                   AND EXISTS (SELECT 1 FROM t_gl_acctcussenthistory k2                                                    \r\n                                WHERE k2.fvoucherasstidid = k.fcussentidid AND k2.fcussentidid = k.fvoucherasstidid             \r\n                                  AND (k2.fvchdate < ? or k2.fvchdate > ? or k2.fvchdate is null)                                                  \r\n            ) GROUP BY k.fcussentidid)                                                                                          \r\n     ,0)                                                                                                                        \r\n";
            params.add(sDate);
            params.add(eDate);
        }
        sql = accountDC == 1 ? "UPDATE " + acTempateTable + " tmp SET FDebit = FDebit +                 \r\n" + sqlSelectSumOnePhase + "where tmp.FDC = 1" : "UPDATE " + acTempateTable + " tmp SET FCredit = FCredit +                 \r\n" + sqlSelectSumOnePhase + "where tmp.FDC = -1";
        return sql.toString();
    }

    protected StringBuffer transWhereSelfDefineToSQL_Assist(EntityViewInfo mainQuery, String loc) {
        StringBuffer where = new StringBuffer();
        String preTable = "assist.";
        String preTableVch = "voucher.";
        String preTableDC = "entry.";
        if (mainQuery == null) {
            return where;
        }
        FilterInfo filterInfo = mainQuery.getFilter();
        if (filterInfo == null) {
            return where;
        }
        String filter = filterInfo.toString();
        if (StringUtils.isEmpty((String)filter)) {
            return where;
        }
        if (filter.indexOf("bizNumber") != -1) {
            filter = filter.replaceAll("bizNumber", preTable + "fbizNumber");
        }
        if (filter.indexOf("invoiceNumber") != -1) {
            filter = filter.replaceAll("invoiceNumber", preTable + "finvoiceNumber");
        }
        if (filter.indexOf("entrydc") != -1) {
            filter = filter.replaceAll("entrydc", preTableDC + "fentrydc");
        }
        if (filter.indexOf("originalAmount") != -1) {
            filter = filter.replaceAll("originalAmount", preTable + "foriginalAmount");
        }
        if (filter.indexOf("voucherType.name") != -1) {
            filter = filter.replaceAll("voucherType.name", "voucherType.fname_" + this.localeSuf);
        }
        if (filter.indexOf("voucher.number") != -1) {
            filter = filter.replaceAll("voucher.number", preTableVch + "fnumber");
        }
        if (filter.indexOf("description") != -1) {
            filter = filter.replaceAll("description", preTable + "fdescription");
        }
        if (filter.indexOf("debitAmount") != -1) {
            filter = filter.replaceAll("debitAmount", "(case " + preTableDC + "fentrydc when 1 then " + preTable + "foriginalAmount else 0 end)");
        }
        if (filter.indexOf("creditAmount") != -1) {
            filter = filter.replaceAll("creditAmount", "(case " + preTableDC + "fentrydc when 0 then " + preTable + "foriginalAmount else 0 end)");
        }
        if (filter.indexOf("VARBizDate") != -1) {
            filter = filter.replaceAll("VARBizDate", preTable + "FBIZDATE");
        }
        where.append(" and ").append(filter).append("  \r\n");
        return where;
    }

    protected StringBuffer getInsertAcSql(String tablename, boolean includeFinished) {
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT ");
        insert.append(tablename);
        insert.append("\r\n\t(FDate,FVoucherID,FVoucherNumber,FVoucherType, FDescription, FCurrencyID, FDebit, FCredit,  \r\n");
        insert.append("\tFBalance,FLineType,FVoucherAsstID,FAssGrpId,FBizNumber,FInvoiceNumber  \r\n");
        if (includeFinished) {
            insert.append(",FAcctCussentID,FDC");
        }
        insert.append(")  \r\n");
        return insert;
    }

    protected StringBuffer getSelectHg(List params) throws BOSException {
        StringBuffer selectHG = new StringBuffer();
        List asstList = this.cond.getAsstActList();
        AsstactTypeEntity at2 = null;
        GLRptRowSet row = this.cond.getSelectedItem();
        if (row == null) {
            return selectHG;
        }
        boolean aflag = asstList.size() > 1;
        boolean rflag = row.size() > 1;
        String andStr = aflag ? "and" : "";
        String orStr = rflag ? "or" : "";
        String lRBrackets = rflag ? " ( " : "";
        String rRBrackets = rflag ? " ) " : "";
        String lABrackets = aflag ? " ( " : "";
        String rABrackets = aflag ? " ) " : "";
        selectHG.append(" and ").append(lRBrackets);
        row.beforeFirst();
        while (row.next()) {
            selectHG.append(lABrackets);
            for (AsstactTypeEntity at2 : asstList) {
                selectHG.append(" hg.").append(at2.getHgField()).append(" = ?  ").append(andStr);
                params.add(row.getObject(at2.getHgField()));
            }
            if (aflag) {
                selectHG.delete(selectHG.lastIndexOf("and"), selectHG.length());
            }
            selectHG.append(rABrackets).append(orStr);
        }
        if (rflag) {
            selectHG.delete(selectHG.lastIndexOf("or"), selectHG.length());
        }
        selectHG.append(rRBrackets);
        return selectHG;
    }

    protected StringBuffer getSql_AcBeginBalUpdate(String tempTableBal, String tempTableHappend, List params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update ").append(tempTableBal).append(" tmp    \r\n");
        sql.append(" set (fbalance) =                               \r\n");
        sql.append(" (                                              \r\n");
        sql.append(" select tmp.fbalance + bal.fbalance            \r\n");
        sql.append(" from ").append(tempTableHappend).append(" bal \r\n");
        sql.append(" where tmp.fcurrencyid = bal.fcurrencyid      \r\n");
        String selectHG = this.getSelectHg(params).toString();
        if (!StringUtil.isEmpty((String)selectHG)) {
            selectHG = selectHG.substring(selectHG.indexOf("and") + 3, selectHG.length() - 1);
        }
        params.removeAll(params);
        sql.append(" and tmp.FASSGRPID = bal.FASSGRPID      \r\n");
        sql.append(" )                                              \r\n");
        if (!StringUtil.isEmpty((String)selectHG)) {
            this.getSelectHg(params);
            sql.append(" where tmp.fassgrpid in(select hg.fid from t_bd_assistanthg hg  \r\n");
            sql.append(" where ").append(selectHG).append(")");
        }
        return sql;
    }

    protected void insertIntoTempTable_AcBeginBal_Preline(String tempTableBal, String tempTableHappend) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT ");
        sql.append(tempTableBal);
        sql.append(" ( FCurrencyID,FDebit,FCredit,FBalance,FLineType,FAssgrpID ) ");
        sql.append(" select bal.fcurrencyid, 0 FDebit, 0 FCredit,        \r\n");
        sql.append("  0 FBalance, -3 as FLineType,                        \r\n");
        sql.append("  bal.FAssgrpID                        \r\n");
        sql.append(" from ").append(tempTableHappend).append(" bal \r\n");
        sql.append(" left outer join ").append(tempTableBal).append(" tmp \r\n");
        sql.append("   on tmp.fcurrencyid = bal.fcurrencyid      \r\n");
        sql.append(" where tmp.fcurrencyid is null               \r\n");
        DbUtil.execute((Context)this.getCtx(), (String)sql.toString());
    }
}

