/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSQLOrder;
import com.kingdee.eas.fi.gl.rpt.app.dao.IRptDataManager;
import com.kingdee.eas.fi.gl.rpt.app.dao.RptFileStorage;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class FileRptDataManager
implements IRptDataManager {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gl.rpt.app.FileRptDataManager");
    private Context ctx;
    private AbstractGLRptDao dao;
    private RptFileStorage storage;

    public FileRptDataManager(AbstractGLRptDao dao) {
        this.dao = dao;
        this.ctx = dao.getContex();
    }

    @Override
    public void init() throws BOSException, EASBizException {
        GLRptSQLOrder orders;
        GLRptPageQuery query = this.dao.getGLRptDataQuery();
        query.setDataSourceTable(this.dao.getDataSourceTable());
        query.setSelector(this.dao.getGLRptSelector());
        query.setSumItems(this.dao.getSumItem());
        StringBuffer sql = new StringBuffer();
        sql.append(" select ").append(query.getSelectSQL());
        sql.append(" from ").append(query.getFromSQL());
        sql.append(query.getJoinSQL());
        String whereSQL = query.getWhereSQL();
        if (whereSQL != null && whereSQL.trim().length() > 0) {
            sql.append(" where ").append(whereSQL);
        }
        if ((orders = query.getOrder()) != null && !orders.isEmpty()) {
            sql.append(orders.getOrderSQL());
        }
        try {
            String sqlStr = KSqlUtil.optimize((String)sql.toString());
            Connection cn = null;
            Statement st = null;
            ResultSet rs = null;
            try {
                cn = EJBFactory.getConnection((Context)this.ctx);
                st = cn.createStatement();
                rs = st.executeQuery(sqlStr);
                this.storage = new RptFileStorage(this.ctx, this.dao.getClass().getSimpleName());
                this.storage.store(rs);
            }
            catch (Exception e) {
                try {
                    throw new BOSException("persist data error!", (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, st, (Connection)cn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)st, (Connection)cn);
        }
        catch (Exception e) {
            throw new BOSException("create tempTable error!", (Throwable)e);
        }
        finally {
            this.dropDBSysTempTable(query.getDataSourceTableName());
        }
    }

    @Override
    public GLRptRowSet getData(int start, int length) throws BOSException, EASBizException {
        try {
            GLRptRowSet rowSet = new GLRptRowSet(this.dao.getTableHeadInfo().getColNames(), length);
            IRowSet rs = this.storage.readRowSet(start, length);
            int rowIndex = 0;
            while (rs.next()) {
                rowSet.insertRow(rowIndex);
                rowSet.setRowIndex(rowIndex + start);
                this.dao.toGLRptRowData(rs, rowSet);
                this.dao.doGLRptRowData(rowSet);
                this.dao.doDetailRowSet(rowSet);
                ++rowIndex;
            }
            return rowSet;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    public int getTotalRowCount() throws BOSException, EASBizException {
        return this.storage.getRowCount();
    }

    @Override
    public String getQueryId() {
        return this.storage.getFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dropDBSysTempTable(String tableName) {
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            TempTablePool.getInstance((Context)this.ctx).releaseDBSystemTempTable(tableName, conn);
        }
        catch (Exception e) {
            logger.error((Object)"release database sytem tempTable error!", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }
}

