/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.common.SQLUtil;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptBaseCondition;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptDaoUtil;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptFilter;
import com.kingdee.util.StringUtils;
import java.util.Iterator;
import java.util.Set;

public class GLRptAccountFilter
implements GLRptFilter {
    protected static final String AND = " and ";
    protected Context ctx;
    protected GLRptBaseCondition cond;
    protected String accountAlias;
    protected String field;
    protected String fieldCompany;
    protected boolean isAccountLevelFilter;
    protected boolean bizUnit;
    protected boolean isPermFilter = true;
    protected String companyIds;

    public GLRptAccountFilter(Context ctx, GLRptBaseCondition cond, String accountAlias, String field, String fieldCompany, boolean isAccountLevelFilter, boolean bizUnit, String companyIds) {
        this.ctx = ctx;
        this.cond = cond;
        this.accountAlias = accountAlias;
        this.field = field;
        this.fieldCompany = fieldCompany;
        this.isAccountLevelFilter = isAccountLevelFilter;
        this.bizUnit = bizUnit;
        this.companyIds = companyIds;
    }

    public GLRptAccountFilter(Context ctx, GLRptBaseCondition cond, String accountAlias, String field, String fieldCompany, boolean isAccountLevelFilter) throws BOSException {
        this(ctx, cond, accountAlias, field, fieldCompany, isAccountLevelFilter, false, cond.getCompanyIdsStr());
    }

    @Override
    public String getSQL() throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer();
        String accountFilter = this.getAccountFilter(this.cond, this.accountAlias, this.field, this.bizUnit);
        if (accountFilter != null) {
            sql.append(accountFilter);
        }
        if (this.isAccountLevelFilter) {
            this.setAccountLevelFilter(sql);
        }
        if (this.isPermFilter) {
            this.setPermissionFilter(sql);
        }
        if (this.getCond().getCtx().get((Object)"isPca") == null) {
            if (sql.length() > 0) {
                sql.append(" AND ").append(this.accountAlias).append(".fisProfitCenter <> 1 ");
            } else {
                sql.append(this.accountAlias).append(".fisProfitCenter <> 1 ");
            }
        }
        return sql.length() > 0 ? sql.toString() : null;
    }

    public void setPermFilter(boolean isPermFilter) {
        this.isPermFilter = isPermFilter;
    }

    protected void setPermissionFilter(StringBuffer sql) throws EASBizException, BOSException {
        if (this.cond.getRptParams().useAccountPermission()) {
            String strPermItem = "bd_account_accountView_view";
            CompanyDisplayModeEnum companyDisplayMode = this.cond.getCompanyDisplayMode();
            String permSql = GLRptDaoUtil.getDataPermSqlFilter(this.ctx, companyDisplayMode, this.cond.getCompany(), this.companyIds, strPermItem, false, this.field, this.fieldCompany);
            if (!StringUtils.isEmpty((String)permSql)) {
                if (sql.length() > 0) {
                    sql.append(AND);
                }
                sql.append(permSql);
            }
        }
    }

    protected void setAccountLevelFilter(StringBuffer sql) {
        if (sql.length() > 0) {
            sql.append(AND);
        }
        sql.append(" (").append(this.accountAlias).append(".fisleaf = 1");
        if (!this.cond.isShowLeafAccount() && this.cond.getAccountLevelEnd() != -1) {
            sql.append(" or ").append(this.accountAlias).append(".flevel <= ").append(this.cond.getAccountLevelEnd());
        }
        sql.append(")");
    }

    protected String getAccountFilter(GLRptBaseCondition cond, String accountAlias, String accountFieldName, boolean bizUnit) throws BOSException {
        String accountIdFilter = this.getAccountIdFilter(cond, accountFieldName, bizUnit);
        if (accountIdFilter != null) {
            return accountIdFilter;
        }
        return this.getAccountNumberFilter(cond, accountAlias);
    }

    private String getAccountIdFilter(GLRptBaseCondition cond, String accountFieldName, boolean bizUnit) throws BOSException {
        if (cond.getAccountIdSet().isEmpty()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        if (bizUnit && CompanyDisplayModeEnum.enumerate != cond.getCompanyDisplayMode()) {
            sql.append(accountFieldName).append(" in (select av.fid from t_bd_accountview pav ");
            sql.append(" inner join t_bd_accountview av on av.faccounttableid = pav.faccounttableid ");
            if (SQLUtil.isSupportCharIndexToLike(this.ctx)) {
                sql.append(" and av.flongnumber like concat(pav.flongnumber, '%') ");
            } else {
                sql.append(" and charindex(pav.flongnumber, av.flongnumber) = 1 ");
            }
            sql.append(" and av.fcompanyid in ").append(this.companyIds);
            sql.append(" where pav.fid in (").append(cond.getAccountIdFilter()).append("))");
        } else {
            String accountFilter = cond.getAccountIdFilter();
            sql.append(accountFieldName).append(" in (").append(accountFilter).append(")");
        }
        return sql.toString();
    }

    private String getAccountFilter(Set accountIdSet) {
        StringBuffer sbBuffer = new StringBuffer();
        Iterator iterator = accountIdSet.iterator();
        while (iterator.hasNext()) {
            sbBuffer.append("'").append(iterator.next()).append("'").append(",");
        }
        String result = sbBuffer.toString();
        return result.substring(0, result.length() - 1);
    }

    private String getAccountNumberFilter(GLRptBaseCondition cond, String accountAlias) {
        if (!cond.isInputCodeStart() && !cond.isInputCodeEnd()) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" (");
        if (cond.isInputCodeStart() && cond.isInputCodeEnd()) {
            String[] starAcc = cond.getAccountCodeStart().split(",");
            String[] endAcc = cond.getAccountCodeEnd().split(",");
            if (starAcc.length == 1 && endAcc.length == 1 && starAcc[0].equals(endAcc[0])) {
                sql.append(accountAlias).append(".fnumber >= '").append(starAcc[0]).append("'");
                sql.append(AND).append(accountAlias).append(".fnumber < '").append(endAcc[0]).append("zz'");
            } else {
                sql.append(accountAlias).append(".fnumber in ( '");
                sql.append(cond.getAccountCodeStart().replaceAll(",", "','"));
                sql.append("','");
                sql.append(cond.getAccountCodeEnd().replaceAll(",", "','"));
                sql.append("' ) ");
                sql.append(" or (").append(accountAlias).append(".fnumber > '").append(starAcc[starAcc.length - 1]).append("'");
                sql.append(AND).append(accountAlias).append(".fnumber < '").append(endAcc[0]);
                sql.append("zz");
                sql.append("')");
            }
        } else if (cond.isInputCodeStart()) {
            String[] starAcc = cond.getAccountCodeStart().split(",");
            sql.append(accountAlias).append(".fnumber in ( '").append(cond.getAccountCodeStart().replaceAll(",", "','")).append("' ) ");
            sql.append(" or (").append(accountAlias).append(".fnumber > '").append(starAcc[starAcc.length - 1]).append("')");
        } else if (cond.isInputCodeEnd()) {
            String[] endAcc = cond.getAccountCodeEnd().split(",");
            sql.append(" ").append(accountAlias).append(".fnumber in ( '").append(cond.getAccountCodeEnd().replaceAll(",", "','")).append("' ) ");
            sql.append(" or (").append(accountAlias).append(".fnumber < '").append(endAcc[0]).append("zz").append("')");
        }
        sql.append(" ) ");
        return sql.toString();
    }

    protected GLRptBaseCondition getCond() {
        return this.cond;
    }

    protected String getAccountAlias() {
        return this.accountAlias;
    }
}

