/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gl.rpt.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.cssp.BizAnalysisCodeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.gl.app.AccountAgeParam;
import com.kingdee.eas.fi.gl.rpt.GLRptAccountAgeCondition;
import com.kingdee.eas.fi.gl.rpt.GLRptRowSet;
import com.kingdee.eas.fi.gl.rpt.GLRptTableHeadInfo;
import com.kingdee.eas.fi.gl.rpt.app.dao.AbstractGLRptDao;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptAcctAgeBizPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptField;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptPageQuery;
import com.kingdee.eas.fi.gl.rpt.app.dao.GLRptSelector;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class GLRptAcctAgeBizTreeDao
extends AbstractGLRptDao {
    private static Logger logger = Logger.getLogger((String)GLRptAcctAgeBizTreeDao.class.getClass().getName());
    protected Context ctx;
    protected GLRptAccountAgeCondition cond;
    protected AccountAgeParam paramAge;

    public GLRptAcctAgeBizTreeDao(Context ctx) throws EASBizException, BOSException {
        super(ctx);
        this.ctx = ctx;
    }

    @Override
    public void init(EntityViewInfo ev) throws EASBizException, BOSException {
        super.init(ev);
        this.cond = (GLRptAccountAgeCondition)this.getQueryCondition();
    }

    @Override
    public GLRptTableHeadInfo getTableHeadInfo() throws BOSException, EASBizException {
        return super.getTableHeadInfo();
    }

    @Override
    protected GLRptSelector initSelector() throws EASBizException, BOSException {
        GLRptSelector selector = new GLRptSelector();
        selector.add(new GLRptField("fid", "fid", "fid", "NVARCHAR(44)", null, -1));
        selector.add(new GLRptField("fbiznumber", "fbiznumber", "fbiznumber", "NVARCHAR(100)", null, -1));
        selector.add(new GLRptField("fbizname", "fbizname", "fbizname", "NVARCHAR(100)", this.getLocaleStr("bizCodeIndex"), 100));
        return selector;
    }

    @Override
    protected void toGLRptRowData(IRowSet rs, GLRptRowSet rowData) throws BOSException, EASBizException, SQLException {
        super.toGLRptRowData(rs, rowData);
        rowData.updateString("fbizname", rs.getString("fbiznumber") + "-" + rs.getString("fbizname"));
    }

    @Override
    protected void insertData() throws BOSException, EASBizException {
        StringBuffer merge = new StringBuffer();
        ArrayList listParam = new ArrayList();
        this.getBizTreeSql(merge, listParam);
        String insert = merge.toString();
        this.insertData(insert, listParam);
    }

    private void getBizTreeSql(StringBuffer sql, List listParam) throws BOSException, EASBizException {
        CompanyOrgUnitInfo _company;
        CompanyOrgUnitInfo curCompany = _company = ContextUtil.getCurrentFIUnit((Context)this.ctx);
        boolean isIsOnlyUnion = GlUtils.isCompanyUnion(_company);
        Map hmItems = this.cond.getItems();
        String companyId = isIsOnlyUnion ? this.cond.getCompanyIdsStr().replace("(", "").replace(")", "") : this.cond.getSelectedCompanys()[0].getId().toString();
        ArrayList alAcResult = new ArrayList();
        String loc = LocaleUtils.getLocaleString((Locale)this.ctx.getLocale());
        sql.append(" select bc.fid,bc.fnumber fbiznumber,bc.fname_").append(loc).append(" fbizname\r\nfrom T_BD_BizAnaylysisCode bc \r\nwhere ");
        Iterator itemkeyit = hmItems.keySet().iterator();
        int j = 0;
        while (itemkeyit.hasNext()) {
            HashMap item = (HashMap)itemkeyit.next();
            String[] numbers = (String[])hmItems.get(item);
            if (numbers[0] != null) {
                sql.append("bc.fnumber >='").append(numbers[0]).append("' and ");
            }
            if (numbers[1] != null) {
                sql.append("bc.fnumber <'").append(numbers[1]).append("~' and ");
            }
            ++j;
        }
        if (isIsOnlyUnion) {
            String[] comid = (companyId == null ? "" : companyId).split(",");
            HashSet<String> comSet = new HashSet<String>();
            for (int i = 0; i < comid.length; ++i) {
                if (comid[i] != null && comid[i].length() > 1) {
                    comSet.add(comid[i].substring(1, comid[i].length() - 1));
                    continue;
                }
                comSet.add("");
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            EntityViewInfo view = new EntityViewInfo();
            sic = view.getSelector();
            sic.add(new SelectorItemInfo("cu.id"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            FilterItemCollection fic = filter.getFilterItems();
            fic.add(new FilterItemInfo("id", comSet, CompareType.INCLUDE));
            CompanyOrgUnitCollection col = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(view);
            StringBuffer cuids = new StringBuffer("''");
            for (int i = 0; col != null && i < col.size(); ++i) {
                CompanyOrgUnitInfo com = col.get(i);
                cuids.append(",'").append(com.getCU().getId().toString()).append("'");
            }
            sql.append(" (  bc.fadmincuid in (").append(cuids.toString()).append(") or bc.fadmincuid = ").append("'").append(ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString()).append("')");
        } else {
            curCompany = GlUtils.getCompanyById(this.ctx, companyId);
            sql.append(BizAnalysisCodeFactory.getLocalInstance((Context)this.ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(curCompany.getCU().getId()), "bc.fid", "bc.fadmincuid"));
        }
        sql.append(" order by bc.fnumber ");
    }

    @Override
    protected GLRptPageQuery getGLRptDataQuery() throws EASBizException, BOSException {
        return new GLRptAcctAgeBizPageQuery(this.ctx, this.cond, this.paramAge);
    }

    @Override
    protected boolean isUseRptID() {
        return false;
    }
}

